!= 䤤碌
!= Inquire information of date
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dccaldateinquire.f90,v 1.2 2009-10-18 02:34:48 morikawa Exp $
! Tag Name::  $Name: gtool5-20100413 $
! Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե˵ܤ³ dc_calendar ⥸塼뤫󶡤ޤ. 
!
! Procedures described in this file are provided from "dc_calendar" module. 
!

subroutine DCCalDateInquire1( year, month, day, hour, min, sec, zone, &
  & elapse_sec, date, cal, err )
  !
  ! 䤤碌Ԥޤ. 
  !
  ! 䤤碌η̤
  ! YYYY-MM-DDThh:mm:ss.sTZD Τ褦ʸ 
  ! (YYYY ǯ, MM Ϸ, DD , hh ϻ, mm ʬ, ss.s ,
  ! TZD ϥॾ) Ǽꤿˤ, 
  ! Ʊ̾Υ֥롼ѤƲ. 
  ! 
  ! άǽ *date* ά줿ˤ, dc_calendar 
  ! ݻ˴ؤޤ. 
  ! *date* άʤˤϤѿꤵ줿ξޤ. 
  !
  ! άǽ *cal* ά줿ˤ, вÿ *elapse_sec* 
  ! ǯʬؤѴ dc_calendar ݻѤޤ. 
  ! *cal* άʤˤϤѿꤵ줿Ѥޤ. 
  !
  ! Inquire information of date. 
  !
  ! If a string like as "YYYY-MM-DDThh:mm:ss.sTZD"
  ! (YYYY is year, MM is month, DD is day, hh is hour, mm is minute, 
  ! ss.s is second, TZD is time zone) is needed, 
  ! use a following homonymous subroutine. 
  ! 
  ! If an optional argument *date* is omitted, 
  ! information of date that is stored in the "dc_calendar" 
  ! is returned, 
  ! If *date* is not omitted, information of the variable is returned. 
  !
  ! If an optional argument *cal* is omitted, 
  ! information of calendar that is stored in the "dc_calendar" 
  ! is used for conversion of elapsed seconds *elapse_sec* into 
  ! year-month-day etc.
  ! If *cal* is not omitted, information of the variable is used. 
  !
  use dc_calendar_types, only: DC_CAL, DC_CAL_DATE
  use dc_calendar_internal, only: default_cal, default_cal_set, default_date, &
    & dccaldate_normalize
  use dc_calendar_generic, only: DCCalDateToChar, DCCalToChar
  use dc_message, only: MessageNotify
  use dc_string, only: LChar
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, &
    & DC_EINCONSISTCALDATE, DC_ENEGATIVE
  use dc_types, only: STRING, DP, TOKEN
  implicit none
  integer, intent(out), optional:: year           ! ǯ. Year.  
  integer, intent(out), optional:: month          ! . Month. 
  integer, intent(out), optional:: day            ! . Day. 
  integer, intent(out), optional:: hour           ! . Hour. 
  integer, intent(out), optional:: min            ! ʬ. Minute. 
  real(DP), intent(out), optional:: sec           ! . Sec. 
  character(*), intent(out), optional:: zone      ! UTC λ. Time-zone. 
  real(DP), intent(in), optional:: elapse_sec
                              ! *date* ηвÿ. 
                              ! Elapsed seconds from *date*. 
  type(DC_CAL_DATE), intent(in), optional, target:: date
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! date and time. 
  type(DC_CAL), intent(in), optional, target:: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 
  logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


  ! ѿ
  ! Work variables
  !
  integer:: wyear, wmonth, wday, whour, wmin
  real(DP):: wsec
  character(TOKEN):: wzone
  type(DC_CAL_DATE), pointer:: datep =>null()
  type(DC_CAL), pointer:: calp =>null()
  character(STRING):: e_date_str, e_cal_str
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter:: subname = 'DCCalInquire1'
continue
  call BeginSub( subname )
  stat = DC_NOERR
  cause_c = ''

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( date ) ) then
    datep => date
  else
    datep => default_date
  end if

  if ( present( cal ) ) then
    calp => cal
  else
    calp => default_cal
    if ( .not. calp % initialized ) call default_cal_set
  end if

  ! Υå
  ! Check initialization
  !
  if ( .not. datep % initialized ) then
    stat = DC_ENOTINIT
    cause_c = 'DC_CAL_DATE'
    goto 999
  end if

  if ( .not. calp % initialized ) then
    stat = DC_ENOTINIT
    cause_c = 'DC_CAL'
    goto 999
  end if

  ! Ǥؤͤλ
  ! Refer elements
  !
  wyear  = datep % year
  wmonth = datep % month
  wday   = datep % day
  whour  = datep % hour
  wmin   = datep % min
  wsec   = datep % sec
  wzone  = datep % zone

  ! в()ɲ
  ! Add elapsed time (seconds)
  !
  if ( present( elapse_sec ) ) then
    if ( elapse_sec < 0.0_DP ) then
      stat = DC_ENEGATIVE
      cause_c = 'elapse_sec'
      goto 999
    end if

    wsec = wsec + elapse_sec
  end if

  ! 
  ! Normalize date and time 
  !
  stat = dccaldate_normalize( wyear, wmonth, wday, whour, wmin, wsec, & ! (inout)
    &                         calp )                                    ! (in)
  if ( stat == DC_EINCONSISTCALDATE ) then
    e_cal_str = DCCalToChar( calp )
    e_date_str = DCCalDateToChar( wyear, wmonth, wday, whour, wmin, wsec, wzone )
    call MessageNotify('W', subname, 'cal=<%c> and date=<%c> are inconsistency', &
      & c1 = trim(e_cal_str), c2 = trim(e_date_str) )
    goto 999
  end if

  ! ؤ
  ! Substitute arguments
  !
  if ( present(year ) ) year  = wyear
  if ( present(month) ) month = wmonth
  if ( present(day  ) ) day   = wday
  if ( present(hour ) ) hour  = whour
  if ( present(min  ) ) min   = wmin
  if ( present(sec  ) ) sec   = wsec
  if ( present(zone ) ) zone  = wzone

  ! λ, 㳰
  ! Termination and Exception handling
  !
999 continue
  nullify( calp, datep )
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )
end subroutine DCCalDateInquire1

subroutine DCCalDateInquire2( date_str, elapse_sec, date, cal, err )
  !
  ! 䤤碌Ԥޤ. 
  ! 䤤碌̤ YYYY-MM-DDThh:mm:ss.sTZD Τ褦ʸ 
  ! (YYYY ǯ, MM Ϸ, DD , hh ϻ, mm ʬ, ss.s ,
  ! TZD ϥॾ) ֤ޤ. 
  ! ʸ 
  ! gtool4 netCDF 5.5 פ˽򤷤Ƥޤ. 
  !
  ! 䤤碌η̤ǯʬäǳƸѿǼꤿ
  ! 嵭Ʊ̾Υ֥롼ѤƲ. 
  !
  ! άǽ *date* ά줿ˤ, dc_calendar 
  ! ݻ˴ؤޤ. 
  ! *date* άʤˤϤѿꤵ줿ξޤ. 
  !
  ! άǽ *cal* ά줿ˤ, вÿ *elapse_sec* 
  ! ǯʬؤѴ dc_calendar ݻѤޤ. 
  ! *cal* άʤˤϤѿꤵ줿Ѥޤ. 
  !
  ! Inquire information of date. 
  ! A result is returned as a string like as 
  ! YYYY-MM-DDThh:mm:ss.sTZD 
  ! (YYYY is year, MM is month, DD is day, hh is hour, mm is minute, 
  ! ss.s is second, TZD is time zone). 
  ! Format of date is conformed to gtool4 netCDF Convention "5.5 Expression of date and time" 
  !
  ! If individual variables (year, month, day, hour, minute, second, zone) 
  ! are needed, use a foregoing homonymous subroutine. 
  !
  ! If an optional argument *date* is omitted, 
  ! information of date that is stored in the "dc_calendar" 
  ! is returned, 
  ! If *date* is not omitted, information of the variable is returned. 
  !
  ! If an optional argument *cal* is omitted, 
  ! information of calendar that is stored in the "dc_calendar" 
  ! is used for conversion of elapsed seconds *elapse_sec* into 
  ! year-month-day etc.
  ! If *cal* is not omitted, information of the variable is used. 
  !
  use dc_calendar_generic, only: DCCalDateToChar
  use dc_calendar_types, only: DC_CAL, DC_CAL_DATE
  use dc_calendar_internal, only: default_cal, default_cal_set, default_date, &
    & dccaldate_normalize
  use dc_calendar_generic, only: DCCalDateToChar, DCCalToChar
  use dc_message, only: MessageNotify
  use dc_string, only: LChar
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, &
    & DC_EINCONSISTCALDATE, DC_ENEGATIVE
  use dc_types, only: STRING, DP, TOKEN
  implicit none
  character(*), intent(out):: date_str
                              ! ɽʸ. 
                              ! ɽˤĤƤ gtool4 netCDF 
                              ! 5.5 򻲾ȤΤ. 
                              ! 
                              ! Strings that express date and time. 
                              ! See gtool4 netCDF Convention 
                              ! 5.5 Expression of date and time for details. 
  real(DP), intent(in), optional:: elapse_sec
                              ! *date* ηвÿ. 
                              ! Elapsed seconds from *date*. 
  type(DC_CAL_DATE), intent(in), optional, target:: date
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! date and time. 
  type(DC_CAL), intent(in), optional, target:: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 
  logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


  ! ѿ
  ! Work variables
  !
  integer:: year, month, day, hour, min
  real(DP):: sec
  character(TOKEN):: zone
  type(DC_CAL_DATE), pointer:: datep =>null()
  type(DC_CAL), pointer:: calp =>null()
  character(STRING):: e_date_str, e_cal_str
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter:: subname = 'DCCalInquire2'
continue
  call BeginSub( subname )
  stat = DC_NOERR
  cause_c = ''

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( date ) ) then
    datep => date
  else
    datep => default_date
  end if

  if ( present( cal ) ) then
    calp => cal
  else
    calp => default_cal
    if ( .not. calp % initialized ) call default_cal_set
  end if

  ! Υå
  ! Check initialization
  !
  if ( .not. datep % initialized ) then
    stat = DC_ENOTINIT
    cause_c = 'DC_CAL_DATE'
    goto 999
  end if

  if ( .not. calp % initialized ) then
    stat = DC_ENOTINIT
    cause_c = 'DC_CAL'
    goto 999
  end if

  ! Ǥμ
  ! Get elements
  !
  year  = datep % year
  month = datep % month
  day   = datep % day
  hour  = datep % hour
  min   = datep % min
  sec   = datep % sec
  zone  = datep % zone


  ! в()ɲ
  ! Add elapsed time (seconds)
  !
  if ( present( elapse_sec ) ) then
    if ( elapse_sec < 0.0_DP ) then
      stat = DC_ENEGATIVE
      cause_c = 'elapse_sec'
      goto 999
    end if

    sec = sec + elapse_sec
  end if

  ! 
  ! Normalize date and time 
  !
  stat = dccaldate_normalize( year, month, day, hour, min, sec, & ! (inout)
    &                         calp )                              ! (in)
  if ( stat == DC_EINCONSISTCALDATE ) then
    e_cal_str = DCCalToChar( calp )
    e_date_str = DCCalDateToChar( year, month, day, hour, min, sec, zone )
    call MessageNotify('W', subname, 'cal=<%c> and date=<%c> are inconsistency', &
      & c1 = trim(e_cal_str), c2 = trim(e_date_str) )
    goto 999
  end if

  ! ɽgtool4 netCDF  5.5 ˤؤѴ
  ! Convert expression of date (gtool4 netCDF Convention 5.5 Expression of date and time)
  !
  date_str = DCCalDateToChar( year, month, day, hour, min, sec, zone )

  ! λ, 㳰
  ! Termination and Exception handling
  !
999 continue
  nullify( calp, datep )
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )
end subroutine DCCalDateInquire2
