! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

! ե̾ urlBase ˰¸ѿ٤ƤˤϤޤ
! var_search(iter, urlbase) ƤӽФƤ̵¥롼פ
! attr_next(iter, url, end) ƤӽФurl ҤȤ
! ҤȤĤ°̾Ϳ롣end ˤˤʤäȤ
! ٤Ƥ°õȤˤʤ롣

subroutine GDNcVarSearchInit(iter, urlBase)
  use dc_types, only: string
  use gtdata_netcdf_types, only: GD_NC_VARIABLE_SEARCH
  use dc_url, only: UrlSplit
  use gtdata_netcdf_file_generic, only: GDNcFileOpen
  use dc_trace, only: beginsub, endsub, DbgMessage
  implicit none
  type(GD_NC_VARIABLE_SEARCH), intent(out):: iter
  character(len = *), intent(in):: urlBase
  character(len = string):: file
  logical:: err
  character(len = *), parameter:: subname = 'GDNcVarSearchInit'

  call beginsub(subname, 'urlbase=<%c>', c1=trim(urlbase))
  call UrlSplit(trim(urlbase), file=file)
  call GDNcFileOpen(iter%fileid, filename=file, writable=.FALSE., err=err)
  if (err) iter%fileid = -1
  iter%varid = 0
  iter%dimid = 0 
  call endsub(subname, 'file=%d', i=(/iter%fileid/))
end subroutine GDNcVarSearchInit

subroutine GDNcVarSearchNext(iter, url, end)
  use gtdata_netcdf_types, only: GD_NC_VARIABLE_SEARCH
  use dc_types, only: string
  use netcdf_f77
  use dc_url, only: UrlMerge
  use gtdata_netcdf_file_generic, only: GDNcFileInquire, GDNcFileClose
  use dc_trace, only: beginsub, endsub, DbgMessage
  implicit none
  type(GD_NC_VARIABLE_SEARCH), intent(inout):: iter
  character(len = *), intent(out):: url
  logical, intent(out):: end
  character(len = string):: filename
  character(len = NF_MAX_NAME):: varname
  integer:: stat, varid_tmp
  character(len = *), parameter:: subname = 'GDNcVarSearchNext'
continue
  call beginsub(subname)
  if (iter%fileid <= 0) then
    end = .TRUE.
    url = ''
    call endsub(subname, "bad file %d", i=(/iter%fileid/))
    return
  endif
  if (iter%varid >= 0) then
    iter%varid = iter%varid + 1
    stat = NF_INQ_VARNAME(iter%fileid, iter%varid, varname)
    if (stat == NF_NOERR) goto 900
    iter%varid = -1
  endif
  do while (iter%dimid >= 0)
    iter%dimid = iter%dimid + 1
    ! --- ֹμʤХ顼 ---
    stat = NF_INQ_DIMNAME(iter%fileid, iter%dimid, varname)
    if (stat /= NF_NOERR) exit
    ! --- ֹμƱ̾ѿеѲֹ ---
    stat = NF_INQ_VARID(iter%fileid, varname, varid_tmp)
    if (stat /= NF_NOERR) goto 900
  enddo
  end = .TRUE.
  url = ""
  call GDNcFileClose(iter%fileid)
  iter%dimid = -1
  call endsub(subname, "end file %d", i=(/iter%fileid/))
  return
  
900 continue
  call GDNcFileInquire(iter%fileid, name=filename)
  url = UrlMerge(file=trim(filename), var=trim(varname))
  end = .FALSE.
  call endsub(subname, "file=%d url=<%c>", &
    & i=(/iter%fileid/), c1=trim(url))
  return
end subroutine GDNcVarSearchNext
