#!/usr/bin/env ruby
require("gsl")
require("../gsl_test.rb")
include GSL::Test

dbleps = 1e-6
n = 1
x = Vector.new(0.002)
y = Vector.new(-0.921)
expected = Vector.new(0.002)
Blas.dcopy(x, y)
for i in 0...n do
  GSL::Test::test_rel(y[i], expected[i], dbleps, "dcopy")
end

x = Vector::Complex.new([[ 0.315, -0.324]])
y = Vector::Complex.new([[-0.312, -0.748]])
expected = Vector::Complex.new([[0.315, -0.324]])
Blas.zcopy(x, y)
for i in 0...n do
  GSL::Test::test_rel(y[i].re, expected[i].re, dbleps, "zcopy real")
  GSL::Test::test_rel(y[i].im, expected[i].im, dbleps, "zcopy imag")
end
