#!/usr/bin/env ruby
require("gsl")
include MultiFit

N = 100

y0 = 1.0
A = 2.0
x0 = 3.0
B = 4.0

r = Rng.new()
x = Vector.linspace(-10, 20, N)
y =  y0 + A/(pow_2(x-x0)+B) + 0.03*Ran::gaussian(r, 1, N)

coef, err, chi2, dof = MultiFit::FdfSolver.fit(x, y, "lorentzian")
y0 = coef[0]
amp = coef[1]
x0 = coef[2]
b = coef[3]
p coef
p err
graph(x, y, y0+amp/(pow_2(x-x0)+b))
