#
# quick2.rb
#   $Id: quick2.rb,v 1.2 2000/11/18 19:03:42 keiko Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math

nmax = 400
dt = PI/(nmax-1)

x = NArray.sfloat(nmax)
y = NArray.sfloat(nmax)

#-- data ----
for n in 0..nmax-1
  t = dt*n
  x[n] = 1.0e5*sin(6.0*t)
  y[n] = 1.0e-4*cos(14.0*t) + 1.0
end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

DCL::usgrph(x, y)

DCL::grcls

