require "numru/gphys"
require "numru/ganalysis/sigma_coord"
require "test/unit"
include NumRu

class SigmaCoordTest < Test::Unit::TestCase
  def setup
    nx = 6
    x = NArray.float(nx).indgen!*60
    lam = ( x * (Math::PI/180) ).newdim(-1)
    ny = 5
    y = NArray.float(ny).indgen!*30 - 60.0
    phi = ( y * (Math::PI/180) ).newdim(0)
    ns = 4
    s = 1.0 - NArray.float(ns).indgen / ns
    vx = VArray.new(x,{"units"=>"degrees_east", "long_name"=>"longitude"},"lon")
    vy = VArray.new(y,{"units"=>"degrees_north","long_name"=>"latitude"},"lat")
    vs = VArray.new(s,{"units"=>"1","long_name"=>"sigma"},"sig")
    ax = Axis.new().set_pos(vx)
    ay = Axis.new().set_pos(vy)
    as = Axis.new().set_pos(vs)
    grid_xy = Grid.new(ax, ay)
    grid_xys = Grid.new(ax, ay, as)

    ps = NArray.float(nx,ny).fill!(1000) + NMath.cos(lam)*NMath.cos(phi)*10
    @ps = GPhys.new( grid_xy, VArray.new(ps, {"units"=>"hPa"}, "ps") )

    u = NArray.float(nx,ny,ns) + (NMath.cos(lam)*NMath.sin(2*phi)*10).newdim(-1)
    @u = GPhys.new( grid_xys, VArray.new(u, {"units"=>"m.s-1"}, "u") )
  end

  def test_find_sigma_d
    assert_equal( GAnalysis::SigmaCoord.find_sigma_d(@u), 2 )
  end

  def test_sig_ps2p
    sig = @u.coord(2)
    sigval = sig.val
    p1 = GAnalysis::SigmaCoord.sig_ps2p(@ps.val, sigval, 2 )
    assert( p1.is_a?(NArray) )
    assert_equal( p1.shape, @u.shape )

    p2 = GAnalysis::SigmaCoord.sig_ps2p(@ps, sig, 2 )
    assert( p2.is_a?(GPhys) )
    assert_equal( p2.shape, @u.shape )
    assert_equal( p2.val, p1 )
  end

end
