*************************************************************************
*   ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING          *
*   Copyright (C) 2001 Keiichi Ishioka                                  *
*                                                                       *
*   This library is free software; you can redistribute it and/or       *
*   modify it under the terms of the GNU Library General Public         *
*   License as published by the Free Software Foundation; either        *
*   version 2 of the License, or (at your option) any later version.    *
*                                                                       *
*   This library is distributed in the hope that it will be useful,     *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of      *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   *
*   Library General Public License for more details.                    *
*                                                                       *
*   You should have received a copy of the GNU Library General Public   *
*   License along with this library; if not, write to the Free          *
*   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *
*************************************************************************
************************************************************************
*     TRANSFORM SPECTRA TO GRID                               2001/07/20
************************************************************************
      SUBROUTINE P2S2GA(LM,KM,JM,IM,S,G,W,ITJ,TJ,ITI,TI)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION S(-LM:LM,-KM:KM)
      DIMENSION G(0:JM-1,2,0:IM/2-1)      
      DIMENSION W(KM,0:JM-1,2)
      DIMENSION ITJ(5),TJ(JM*2),ITI(5),TI(IM*2)

      CALL BSSET0(KM*2*JM,W)

      DO L=1,LM
        DO K=1,KM
          W(K,L,1)=S(L,K)
          W(K,L,2)=S(-L,-K)
          W(K,JM-L,1)=S(-L,K)
          W(K,JM-L,2)=S(L,-K)
        END DO
      END DO

      DO K=1,KM
        W(K,0,1)=S(0,K)
        W(K,0,2)=S(0,-K)
      END DO

      CALL FTTZUB(KM,JM,W,G,ITJ,TJ)

      CALL BSSET0(JM*IM,G)

      DO IR=1,2
        DO K=1,KM
          DO J=0,JM-1
            G(J,IR,K)=W(K,J,IR)
          END DO
        END DO
      END DO

      DO L=1,LM
        G(L,1,0)=S(L,0)
        G(L,2,0)=S(-L,0)
        G(JM-L,1,0)=S(L,0)
        G(JM-L,2,0)=-S(-L,0)
      END DO

      G(0,1,0)=S(0,0)
      
      CALL FTTZUB(1,JM,G,W,ITJ,TJ)

      CALL BSSET0(JM,G(0,2,0))

      CALL FTTRUB(JM,IM,G,W,ITI,TI)

      END
