!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  esc_module ƥȥץ
!
!  2002/08/20  ݹ
!
program esc_intavr

  use esc_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=16, jm=16            ! ʻ(X,Y)
  integer, parameter :: km=5, lm=5              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: xy_Data(0:jm,0:im-1)    ! ʻҥǡ
  real(8)            :: x_Data(0:im-1)          ! ʻҥǡ
  real(8)            :: y_Data(0:jm)            ! ʻҥǡ
  real(8)            :: ec_Data(-km:km,0:lm)    ! ڥȥǡ

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  real(8), parameter :: eps = 1.0d-10            ! Ƚ

 !---------------- ɸͤ ---------------------
  call esc_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------
  xy_Data = sin(pi*xy_X) * xy_Y**2
  write(6,*) 'f = sin(pi*X)*Y**2'

    call check0d(IntXY_xy(xy_Data)-0.0, eps, 'IntXY_xy') 
    call check0d(AvrXY_xy(xy_Data)-0.0, eps, 'AvrXY_xy')

    call check1d(y_IntX_xy(xy_Data) - 0.0, eps, 'y_IntX_xy') 
    call check1d(y_AvrX_xy(xy_Data) - 0.0, eps, 'y_AvrX_xy') 

    call check1d(x_IntY_xy(xy_Data) - 2/3.0d0 * sin(pi*x_X), eps, 'x_IntY_xy')
    call check1d(x_AvrY_xy(xy_Data) - 1/3.0d0 * sin(pi*x_X), eps, 'x_AvrY_xy')

  xy_Data = (1 - sin(pi*xy_X)) * cos(pi*xy_Y/2)
  write(6,*)
  write(6,*) 'f = (1-sin(pi*X))*cos(pi*Y/2)'

    call check0d(IntXY_xy(xy_Data) - 8/pi, eps, 'IntXY_xy') 
    call check0d(AvrXY_xy(xy_Data) - 2/pi, eps, 'AvrXY_xy')

    call check1d(y_IntX_xy(xy_Data) - 2*cos(pi*y_Y/2), eps, 'y_IntX_xy') 
    call check1d(y_AvrX_xy(xy_Data) - cos(pi*y_Y/2), eps, 'y_AvrX_xy')

    call check1d(x_IntY_xy(xy_Data) - 4/pi * (1 - sin(pi*x_X)), eps, 'x_IntY_xy')
    call check1d(x_AvrY_xy(xy_Data) - 2/pi * (1 - sin(pi*x_X)), eps, 'x_AvrY_xy')

  x_Data = 1 - sin(2*pi*x_X)
  write(6,*)
  write(6,*) 'f = 1-sin(2*pi*X)'

    call check0d(IntX_x(x_Data) - 2.0d0, eps, 'IntX_x')
    call check0d(AvrX_x(x_Data) - 1.0d0, eps, 'AvrX_x')

  y_Data = cos(pi*y_Y/2)
  write(6,*)
  write(6,*) 'f = cos(pi*Y/2)'

    call check0d(IntY_y(y_Data) - 4/pi, eps, 'IntY_y')
    call check0d(AvrY_y(y_Data) - 2/pi, eps, 'AvrY_y')

  y_Data = cos(pi*y_Y)**2
  write(6,*)
  write(6,*) 'f = cos(pi*Y)**2'

    call check0d(IntY_y(y_Data) - 1.0, eps, 'IntY_y')
    call check0d(AvrY_y(y_Data) - 0.5, eps, 'AvrY_y')

 stop
contains

  subroutine check1d(var,eps,funcname) ! ͤ eps ʾ var Ǥ
    real(8) :: var(:)                  ! Ƚꤹ
    real(8) :: eps                     ! 
    character(len=*), optional :: funcname
    integer i

    if ( present(funcname) )then
       write(6,*) '  Checking ', funcname, '...'
    endif

    do i=1,size(var)
       if (abs(var(i)) .gt. eps ) then
          write(6,*) '    Value larger than EPS : i= ', i, var(i)
       endif
    enddo
  end subroutine check1d

  subroutine check0d(var,eps,funcname)   ! var ͤ eps ʾȽ
    real(8) :: var                       ! Ƚꤹ
    real(8) :: eps                       ! 
    real(8) :: vartmp(1)                 ! 
    character(len=*), optional :: funcname
    integer i

    vartmp(1) = var
    if ( present(funcname) ) then
       call check1d(vartmp,eps,funcname)
    else
       call check1d(vartmp,eps)
    endif
  end subroutine check0d

end program esc_intavr
