!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_af_galerkin_MM_test1d
!
!      ӥաݥ顼ˡ
!      ǥꥯ졦Υޥ󺮹維ѥ⥸塼ƥȥץ(2)
!          cfdx1_xmax f'(:,i=0)  + cfdx0_xmax f(:,i=0)  = 0,
!          cfdx1_xmin f'(:,i=im) + cfdx0_xmin f(:,i=im) = 0,
!
!       : cfdx1_xmax=1, cfdx0_xmax =alpha, cfdx1_xmin=1, cfdx0_xmin =-alpha
!
!           f(x) = cos(lambda*t)
!              t=(xmax+xmin)/2 + (xmax-xmin)/2 * t
!              lambda tan(lambda) = alpha*(xmax-xmin)/2
!
!  2006/01/04  ݹ  
!      2006/01/23  ݹ  ⥸塼̾ѹȼ
!
program at_af_galerkin_MM_test2d

  use at_af_galerkin_MM, only: at_af_galerkin_MM_Initial, &
                               af_at, at_af, af_ag, ag_af
  use at_module
  use dc_message

  implicit none

  integer, parameter :: jm=10                   ! 1 ܳʻ
  integer, parameter :: im=64                  ! ʻ              
  integer, parameter :: km=64                  ! ӥȿ  
  integer, parameter :: ks=2                   ! 顼㼡
  real(8), parameter :: xmin=0.0, xmax=1.0     ! ׻ΰ

  real(8), parameter :: alpha=2.0D0            ! ﷸ

  real(8) :: ag_data(jm,0:im)
  real(8) :: ag_data_orig(jm,0:im)

  real(8) :: af_data(jm,ks:km)

  real(8) :: pi
  real(8) :: lambda(jm)                          ! ϲ򷸿
  integer :: j

  pi = atan(1.0D0)*4.0D0
  lambda = InvXtanX(alpha*(xmax-xmin)/2.0D0,jm)
!!$  write(6,*) lambda

  call at_Initial(im,km,xmin,xmax)
  !--- ǥꥯ졦Υޥ󺮹維 ---
  call at_af_galerkin_MM_Initial(im,km,        &
       cfdx0_xmax=alpha, cfdx1_xmax=1.0D0, &
       cfdx0_xmin=-alpha,  cfdx1_xmin=1.0D0    )

  do j=1,jm
     ag_data(j,:) = cos(lambda(j)*(2.0D0/(xmax-xmin)*(g_X-(xmax+xmin)/2.0D0)))
  enddo
  ag_data_orig = ag_data

  af_data = af_ag(ag_data)
  ag_data = ag_af(af_data)

  write(6,*) 
  write(6,*) '*** Max. Error of Grid -> Galerkin -> Grid conversion ***'
  write(6,*) 
  write(6,*) 'j, error of cos (lambda(j)*t) :'
  do j=1,jm
     write(6,*) j, maxval(abs(ag_data_orig(j,:)-ag_data(j,:)))
  enddo

!  
!  ag_data = ag_af(af_Dx_af(af_Dx_af(af_data)))

!  褤 : ʬͤϥӥշݻ٤
  af_data = af_at(at_Dx_at(at_Dx_at(at_af(af_data))))
  ag_data = ag_af(af_data)

  write(6,*) 
  write(6,*) '*** Max. Error of of Grid -> Galerkin -> (Dx)^2 -> Grid conversion ***'
  write(6,*) 
  write(6,*) 'j, error of dx^2 cos (lambda(j)*t) :'
  do j=1,jm
     write(6,*) j, &
          maxval(abs(-(lambda(j)/(xmax-xmin)*2)**2 * ag_data_orig(j,:) &
                 -ag_data(j,:)))
  enddo

contains
  !
  ! x*tan(x)=val β
  !
  function InvXtanX(val,n)
    real(8), intent(IN) :: val                ! x*tan(x)=val > 0
    integer, intent(IN) :: n                  ! θĿ
    real(8)             :: InvXtanX(n)
    real(8), parameter  :: eps = 1.0D-14     ! 

    real(8) :: PI
    integer :: i
    real(8) :: xs, xl, xm
    real(8) :: ValS, ValL, ValM

    PI = atan(1.0D0)*4.0D0

    do i=1,n
       xs=(i-1)*PI
       xl=PI/2.0D0  + (i-1)*PI - eps

       ValS = xs*tan(xs)-val ; ValL = xl*tan(xl)-val
       if ( ValS * ValL .GT. 0.0D0 ) &
            call MessageNotify('E','InvXtanX',&
            'Initial values of ValS and ValL are the same sign.')
!!$       write(6,*) 'vals, vall',vals, vall
1000   xm = (xs + xl)/2.0
       ValM = xm*tan(xm) - val

       if ( ValS * ValM .GT. 0.0D0 ) then
          xs = xm ; ValS=xs*tan(xs)-val
       else
          xl = xm ; ValL=xl*tan(xl)-val
       endif

       if ( abs(xl-xs) .lt. eps ) then
          InvXtanX(i) = xm
          goto 99
       endif

       goto 1000

99  end do
  end function InvXtanX

end program at_af_galerkin_MM_test2d
