!----------------------------------------------------------------------
!     Copyright (c) 2002--2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_base_module
!
!  2001/12/08  ݹ
!      2001/12/26  ݹ  ؿ,ѿ̾ѹ
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ؿ,ѿ̾ƺѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2005/03/13  ݹ  l_nm, nm_l ǰϤ褦˳ĥ
!      2005/07/04  ݹ  OpenMP Ѵ롼б
!                            Х󥯶򤱤뤿κɲ
!      2005/07/10  ݹ  OpenMP åȥåפΥå
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module w_base_module

  use dc_message
  implicit none

  integer               :: im=64, jm=32     ! ʻ(, )
  integer               :: nm=21            ! ȿ
  integer               :: np=1             ! OPENMP 祹åɿ

  logical               :: openmp=.false.   ! OPENMP å

  integer               :: it(6)            ! Ѵ
  real(8), allocatable  :: t(:)             ! Ѵ
  integer, allocatable  :: ip(:)            ! Ѵ
  real(8), allocatable  :: p(:), r(:)       ! Ѵ
  integer, allocatable  :: ia(:)            ! Ѵ
  real(8), allocatable  :: a(:)             ! Ѵ
  real(8), allocatable  :: y(:,:)           ! Ѵ

  real(8), allocatable  :: q(:)             ! 
  real(8), allocatable  :: ww(:), ws(:)     ! 
  real(8), allocatable  :: wv(:)            ! (OPENMP)

  real(8), allocatable  :: x_Lon(:), y_Lat(:)                ! ٷ
  real(8), allocatable  :: x_Lon_Weight(:), y_Lat_Weight(:)  ! ɸŤ
  real(8), allocatable  :: xy_Lon(:,:), xy_Lat(:,:)

  real(8), allocatable  :: xy_work(:,:)     ! w_xy,xy_w Ѵ
  integer               :: id=65, jd=33     ! xy_work 礭

  real(8), parameter    :: pi=3.1415926535897932385D0

  private

  public im, jm, nm                           ! ʻ, ȿ, Ⱦ
  public it, t, y, ip, p, r, ia, a            ! ѴѺ
  public openmp, np                           ! OPENMP ѿ

  public w_base_Initial                       ! ֥롼
  public x_Lon, y_Lat                         ! ʻҺɸ
  public x_Lon_Weight, y_Lat_Weight           ! ʻҺɸŤ
  public xy_Lon, xy_Lat                       ! ʻҺɸ(im,jm)
  public l_nm, nm_l                           ! ȿǼ
  public xy_w, w_xy                           ! Ѵؿ

  interface l_nm
     module procedure l_nm_array00
     module procedure l_nm_array01
     module procedure l_nm_array10
     module procedure l_nm_array11
  end interface

  interface nm_l
     module procedure nm_l_int
     module procedure nm_l_array
  end interface

  save im, jm, nm                             ! ʻ, ȿ, Ⱦ¤򵭲
  save it, t, y, ip, p, r, ia, a              ! Ѵ򵭲
  save id, jd                                 ! Ѵ礭

  contains
  !---------------  -----------------
    subroutine w_base_Initial(n_in,i_in,j_in,np_in)

      integer,intent(in) :: i_in, j_in        ! ʻ(, )
      integer,intent(in) :: n_in              ! ȿ
      integer,intent(in), optional :: np_in   ! OPENMP Ǥκ祹åɿ

      integer :: iw, i, j

      im = i_in  ; jm = j_in  ; nm = n_in

      if ( present(np_in) )then
         np = np_in

         if ( np .gt. 1 ) then
            openmp = .true. 
            allocate(wv((nm+4)*(nm+3)*np))
            call MessageNotify('M','w_base_Initial', &
                 'OpenMP computation was set up.')
         else
            openmp = .false. 
         endif

      else
         openmp = .false. 
      endif

      if ( im/2*2 .eq. im ) then
         id = im+1 
      else
         id = im
      endif
      if ( openmp ) then
         jd = jm
      else if ( jm/2*2 .eq. jm ) then
         jd = jm+1
      else
         jd = jm
      endif
      allocate(xy_work(id,jd))                ! Ѵ

      allocate(t(im*2))                       ! Ѵ
      allocate(ip(((nm+1)/2+nm+1)*2))         ! Ѵ
      allocate(p(((nm+1)/2+nm+1)*jm))         ! Ѵ
      allocate(r(((nm+1)/2*2+3)*(nm/2+1)))    ! Ѵ
      allocate(ia((nm+1)*(nm+1)*4))           ! Ѵ
      allocate(a((nm+1)*(nm+1)*6))            ! Ѵ
      allocate(y(jm/2,4))                     ! Ѵ

      allocate(q(((nm+1)/2+nm+1)*jm))         ! 
      if ( openmp ) then
         iw=(im+nm+1)*3*jm/2
      else
         iw=max((nm+4)*(nm+3),jd*3*(nm+1),jd*im)
      endif
      allocate(ws(iw),ww(iw))                 ! 

      allocate(x_Lon(im), y_Lat(jm))              ! ʻɸǼ
      allocate(x_Lon_Weight(im),y_Lat_Weight(jm)) ! ʻɸǼ
      allocate(xy_Lon(im,jm),xy_Lat(im,jm))       ! ʻɸǼ

      call sninit(nm,im,jm,it,t,y,ip,p,r,ia,a)

      do i=1,im
         x_Lon(i)  = 2*pi/im*(i-1)              ! ٺɸ
         x_Lon_Weight(i) = 2*pi/im              ! ٺɸŤ
      enddo

      do j=1,jm/2
         y_Lat(jm/2+j)   =  asin(y(j,1))        ! ٺɸ
         y_Lat(jm/2-j+1) = -asin(y(j,1))        ! ٺɸ
         y_Lat_Weight(jm/2+j)   = 2*y(j,2)      ! ٽŤ(Gauss grid)
         y_Lat_Weight(jm/2-j+1) = 2*y(j,2)      ! ٽŤ(Gauss grid)
      enddo

      do j=1,jm
         xy_Lon(:,j) = x_Lon
      enddo

      do i=1,im
         xy_Lat(i,:) = y_Lat
      enddo

    end subroutine w_base_Initial

  !--------------- Ѵ -----------------

    function l_nm_array00(n,m)
      ! 
      !  n,m Ȥͤξ, ֤ͤ. 
      !
      integer               :: l_nm_array00   ! ڥȥǡγǼ 
      integer, intent(in)   :: n, m           ! ȿ, Ӿȿ           

      call snnm2l(n,m,l_nm_array00)
    end function l_nm_array00

    function l_nm_array01(n,marray)           ! ڥȥǡγǼ 
      ! 
      !  1  n ,  2  marray  1 ξ, 
      ! marray Ʊ礭 1 ֤. 
      !
      integer, intent(in)  :: n               ! ȿ
      integer, intent(in)  :: marray(:)       ! Ӿȿ
      integer              :: l_nm_array01(size(marray)) ! ڥȥǡ

      integer              :: i 

      do i=1, size(marray)
         l_nm_array01(i) = l_nm_array00(n,marray(i))
      enddo
    end function l_nm_array01

    function l_nm_array10(narray,m)
      ! 
      !  1  narray  1 ,  2   m ξ, 
      ! narray Ʊ礭 1 ֤. 
      !
      integer, intent(in)  :: narray(:)           ! ȿ  
      integer, intent(in)  :: m                   ! Ӿȿ
      integer              :: l_nm_array10(size(narray)) ! ڥȥǡ

      integer              :: i 

      do i=1, size(narray)
         l_nm_array10(i) = l_nm_array00(narray(i),m)
      enddo
    end function l_nm_array10

    function l_nm_array11(narray,marray)
      ! 
      !  1,2  narray, marray Ȥ 1 ξ, 
      ! narray, marray Ʊ礭 1 ֤. 
      ! narray, marray Ʊ礭ǤʤФʤʤ. 
      !
      integer, intent(in)  :: narray(:)          ! ȿ  
      integer, intent(in)  :: marray(:)          ! Ӿȿ
      integer              :: l_nm_array11(size(narray)) ! ڥȥǡ

      integer              :: i 

      if ( size(narray) .ne. size(marray) ) then
         call MessageNotify('E','l_nm_array11',&
              'dimensions of input arrays  n and m are different.')
      endif

      do i=1, size(narray)
         l_nm_array11(i) = l_nm_array00(narray(i),marray(i))
      enddo
    end function l_nm_array11

    function nm_l_int(l)
      ! 
      !  l ͤξ, бȿӾȿ
      ! Ĺ 2  1 ֤ͤ. 
      ! nm_l(1) ȿ, nm_l(2) ӾȿǤ. 
      !
      integer               :: nm_l_int(2)  ! ȿ, Ӿȿ
      integer, intent(in)   :: l            ! ڥȥǡγǼ
      
      call snl2nm(l,nm_l_int(1),nm_l_int(2))
    end function nm_l_int

    function nm_l_array(larray)
      ! 
      !  larray  1 ξ, 
      ! larray б n, m Ǽ 2 ֤. 
      ! nm_l_array(:,1) ȿ, nm_l_array(:,2) ӾȿǤ. 
      !
      integer, intent(in)  :: larray(:)
      integer              :: nm_l_array(size(larray),2)

      integer              :: i

      do i=1, size(larray)
         nm_l_array(i,:) = nm_l_int(larray(i))
      enddo
    end function nm_l_array

    function xy_w(w_data,ipow,iflag)    ! Ĵ´ؿڥȥ -> ʻ
      real(8)               :: xy_w(im,jm)            ! ʻ
      real(8), intent(in)   :: w_data((nm+1)*(nm+1))  ! ڥȥ
      integer, intent(in), optional  :: ipow      ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag     ! Ѵμ

      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval

      logical :: first=.true.                    ! Ƚꥹå
      save first

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      if ( openmp ) then
         if ( first ) then
            call MessageNotify('M','xy_w', &
                 'OpenMP routine SNTSOG/SNPACK is used for spherical harmonic transformation.')
         endif
         call sntsog(nm,im,id,jm,1,w_data,xy_work,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,wv,ipval,ifval)
      else
         call snts2g(nm,im,id,jm,jd,1,w_data,xy_work,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval)
      endif
      xy_w=xy_work(1:im,1:jm)
      first = .false.

    end function xy_w

    function w_xy(xy_data,ipow,iflag) ! ʻ -> Ĵ´ؿڥȥ
      real(8)               :: w_xy((nm+1)*(nm+1))! ڥȥ
      real(8), intent(in)   :: xy_data(im,jm)     ! ʻ
      integer, intent(in), optional  :: ipow      ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag     ! Ѵμ

      integer, parameter  :: ipow_default  = 0    ! åǥե
      integer, parameter  :: iflag_default = 0    ! åǥե

      integer ipval, ifval

      logical :: first=.true.                     ! Ƚꥹå
      save first

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      xy_work(1:im,1:jm)=xy_data

      if ( openmp ) then
         if ( first ) then
            call MessageNotify('M','w_xy', &
                 'OpenMP routine SNTGOS/SNPACK is used for spherical harmonic transformation.')
         endif
         call sntgos(nm,im,id,jm,1,xy_work,w_xy,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,wv,ipval,ifval)
      else
         call sntg2s(nm,im,id,jm,jd,1,xy_work,w_xy,&
              it,t,y,ip,p,r,ia,a,q,ws,ww,ipval,ifval)
      endif
      first = .false.

    end function w_xy

  end module w_base_module
