!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_deriv_module
!
!  2002/02/02  ݹ 
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ⥸塼̾ѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2002/10/07  ݹ  , ̺ɸʬɲ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module wa_deriv_module
  use w_base_module, only : im, jm, nm
  use wa_base_module, only : km, wa_base_Initial, xya_wa, wa_xya
  use w_deriv_module, only : rn, irm, w_Jacobian_w_w

  implicit none

  private
 
  public wa_deriv_Initial                     ! 
  public wa_Lapla_wa, wa_LaplaInv_wa          ! ץ饷ȵձ黻
  public wa_DLon_wa                           ! ʬ
  public xya_GradLon_wa, xya_GradLat_wa       ! ۷ʬ
  public wa_DivLon_xya, wa_DivLat_xya         ! ȯʬ
  public wa_Div_xya_xya                       ! ȯʬ
  public wa_Jacobian_wa_wa                    ! 䥳ӥ
  public xya_GradLambda_wa, xya_GradMu_wa     ! ۷ʬ(,̺ɸ)
  public wa_DivLambda_xya, wa_DivMu_xya       ! ȯʬ(,̺ɸ)

  contains

  !---------------  -----------------
    subroutine wa_deriv_Initial(k_in)

      integer,intent(in) :: k_in              ! ǡ(ؿ)򵭲

      call wa_base_Initial(k_in)

    end subroutine wa_deriv_Initial

  !--------------- ʬ׻ -----------------
    function wa_Lapla_wa(wa_data)       ! ڥȥ˺Ѥ Laplacian
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: wa_lapla_wa((nm+1)*(nm+1),size(wa_data,2))

      integer :: l,k

      do k=1,size(wa_data,2)
         do l=1,(nm+1)*(nm+1)
            wa_Lapla_wa(l,k) = rn(l,1)*wa_data(l,k)
         enddo
      enddo
    end function wa_Lapla_wa

    function wa_LaplaInv_wa(wa_data)    ! ڥȥ˺Ѥ Laplacian 黻
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: wa_LaplaInv_wa((nm+1)*(nm+1),size(wa_data,2))

      integer :: l,k

      do k=1,size(wa_data,2)
         do l=1,(nm+1)*(nm+1)
            wa_LaplaInv_wa(l,k) = rn(l,2)*wa_data(l,k)
         enddo
      enddo
    end function wa_LaplaInv_wa

    function wa_DLon_wa(wa_data)        ! ڥȥ˺Ѥʬ /ߦ
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: wa_DLon_wa((nm+1)*(nm+1),size(wa_data,2))

      integer :: l,k

      do k=1,size(wa_data,2)
         do l=1,(nm+1)*(nm+1)
            wa_DLon_wa(irm(l,1),k) = irm(l,2)*wa_data(l,k)
         enddo
      enddo
    end function wa_DLon_wa

    function xya_GradLon_wa(wa_data) ! ڥȥ˺Ѥ۷ʬ
                                ! 1/cosա/ߦ
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: xya_GradLon_wa(im,jm,size(wa_data,2))

      xya_GradLon_wa = xya_wa(wa_data,ipow=1,iflag=-1)
    end function xya_GradLon_wa

    function xya_GradLat_wa(wa_data) ! ڥȥ˺Ѥ۷ʬ, /ߦ
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: xya_GradLat_wa(im,jm,size(wa_data,2))

      xya_GradLat_wa = xya_wa(wa_data,ipow=1,iflag=1)
    end function xya_GradLat_wa

    function wa_DivLon_xya(xya_data)   ! ʻҤ˺Ѥȯʬ 
                                  ! 1/cosա/ߦ

      real(8), intent(in)  :: xya_data(:,:,:)
      real(8)              :: wa_DivLon_xya((nm+1)*(nm+1),size(xya_data,3))

      wa_DivLon_xya = wa_xya(xya_data,ipow=1,iflag=-1)
    end function wa_DivLon_xya

    function wa_DivLat_xya(xya_data)   ! ʻҤ˺Ѥȯʬ
                                  ! 1/cosա(f cos)/ߦ

      real(8), intent(in)  :: xya_data(:,:,:)
      real(8)              :: wa_DivLat_xya((nm+1)*(nm+1),size(xya_data,3))

      wa_DivLat_xya = wa_xya(xya_data,ipow=1,iflag=1)
    end function wa_DivLat_xya

    function wa_Div_xya_xya(xya_u,xya_v)     ! ʻҤ˺Ѥȯ
      real(8), intent(in)  :: xya_u(:,:,:)   ! ٥ȥʬ
      real(8), intent(in)  :: xya_v(:,:,:)   ! ٥ȥʬ
      real(8)              :: wa_Div_xya_xya((nm+1)*(nm+1),size(xya_u,3))

      wa_Div_xya_xya = wa_DivLon_xya(xya_u) + wa_DivLat_xya(xya_v)
    end function wa_Div_xya_xya

    function wa_Jacobian_wa_wa(wa_a,wa_b)  ! ڥȥ˺Ѥ䥳ӥ
                             ! J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
                             !        = f/ߦˡ1/cosաg/ߦ
                             !           - g/ߦˡ1/cosաf/ߦ

      real(8), intent(in) :: wa_a(:,:)
      real(8), intent(in) :: wa_b(:,:)
      real(8)             :: wa_Jacobian_wa_wa((nm+1)*(nm+1),size(wa_a,2))

      integer :: k

      do k=1,size(wa_a,2)
         wa_Jacobian_wa_wa(:,k) = w_Jacobian_w_w(wa_a(:,k),wa_b(:,k))
      end do
    end function wa_Jacobian_wa_wa


  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xya_GradLambda_wa(wa_data) ! ڥȥ˺Ѥ۷ʬ
                                        ! /ߦ
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: xya_GradLambda_wa(im,jm,size(wa_data,2))

      xya_GradLambda_wa = xya_wa(wa_data,ipow=0,iflag=-1)
    end function xya_GradLambda_wa

    function xya_GradMu_wa(wa_data) ! ڥȥ˺Ѥ۷ʬ
                                    ! (1-^2)/ߦ  (=sin)
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: xya_GradMu_wa(im,jm,size(wa_data,2))

      xya_GradMu_wa = xya_wa(wa_data,ipow=0,iflag=1)
    end function xya_GradMu_wa

    function wa_DivLambda_xya(xya_data)   ! ʻҤ˺Ѥȯʬ 
                                          ! 1/(1-^2)/ߦ

      real(8), intent(in)  :: xya_data(:,:,:)
      real(8)              :: wa_DivLambda_xya((nm+1)*(nm+1),size(xya_data,3))

      wa_DivLambda_xya = wa_xya(xya_data,ipow=2,iflag=-1)
    end function wa_DivLambda_xya

    function wa_DivMu_xya(xya_data)   ! ʻҤ˺Ѥȯʬ
                                      ! /ߦ

      real(8), intent(in)  :: xya_data(:,:,:)
      real(8)              :: wa_DivMu_xya((nm+1)*(nm+1),size(xya_data,3))

      wa_DivMu_xya = wa_xya(xya_data,ipow=2,iflag=1)
    end function wa_DivMu_xya

  end module wa_deriv_module

