!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_module
!      Chebyshev Ÿ
!
!  2002/01/24  ݹ
!      2002/02/06  ݹ  ŤƳ. ̥󥿡եʤ. 
!                            η˱󥿡ե̾
!      2002/03/25  ݹ  ⥸塼̾ѹ
!      2002/08/20  ݹ  ʬʿѴؿɲ
!
module at_module

  use lumatrix
  implicit none
  private
  public g_X, g_X_Weight                      ! ɸѿ
  public at_Initial                           ! 
  public ag_at, at_ag, g_t, t_g               ! Ѵ
  public at_Dx_at, t_Dx_t                     ! ʬ
  public at_Boundaries_DD, at_Boundaries_DN   ! 
  public at_Boundaries_ND, at_Boundaries_NN   ! 
  public a_Int_ag, Int_g, a_Avr_ag, Avr_g     ! ʬʿ


  interface at_Boundaries_DD            ! ξüǥꥯ
     module procedure at_Boundaries_DD_1d, at_Boundaries_DD_2d
  end interface

  interface at_Boundaries_DN            ! ǥꥯ콪Υޥ
     module procedure at_Boundaries_DN_1d, at_Boundaries_DN_2d
  end interface

  interface at_Boundaries_ND            ! Υޥǥꥯ
     module procedure at_Boundaries_ND_1d, at_Boundaries_ND_2d
  end interface

  interface at_Boundaries_NN            ! ξüΥޥ
     module procedure at_Boundaries_NN_1d, at_Boundaries_NN_2d
  end interface

  integer, dimension(5)              :: it
  real(8), dimension(:), allocatable :: t
  real(8), parameter                 :: pi=3.1415926535897932385D0

  integer :: im, km                        ! ʻ, ȿ
  real(8) :: xl                            ! ΰ礭

  real(8), allocatable :: g_X(:)           ! ʻɸ
  real(8), allocatable :: g_X_Weight(:)    ! ʻŤ

  save :: im, km, xl, it, t, g_X, g_X_Weight

contains

! ----  ---- 
  subroutine at_Initial(i,k,xmin,xmax)
    integer, intent(in) :: i, k
    real(8), intent(in) :: xmin,xmax

    integer :: ii,kk

    im=i ; km=k 
    xl = xmax-xmin

    if ( im <= 0 .or. km <= 0 ) then
       call msgdmp('E','at_initial', &
            'Number of grid points and waves should be positive')
    elseif ( mod(im,2) /= 0 ) then
       call msgdmp('E','at_initial','Number of grid points should be even')
    elseif ( km > im ) then
       call msgdmp('E','at_initial','KM shoud be less equal IM')
    endif

    allocate(t(3*im))
    call fttcti(im,it,t)

    allocate(g_X(0:im))
    do ii=0,im
       g_X(ii) = (xmax+xmin)/2 + xl/2 * cos(pi*ii/im)
    enddo

    allocate(g_X_Weight(0:im))
    do ii=0,im
       g_X_Weight(ii) = 1.0
       do kk=2,km,2
          g_X_Weight(ii) = g_X_Weight(ii) &
                          + 2/(1D0-kk**2) * cos(kk*ii*pi/im)
       enddo
       if ( (km == im) .and. (mod(im,2)==0) ) then  ! Ǹ¤ factor 1/2.
          g_X_Weight(ii) = g_X_Weight(ii) &
                          - 1/(1D0-km**2)* cos(km*ii*pi/im)
       endif
       g_X_Weight(ii) = 2D0/im * g_X_Weight(ii) * xl/2
    enddo
    g_X_Weight(0)  = g_X_Weight(0) / 2
    g_X_Weight(im) = g_X_Weight(im) / 2

  end subroutine at_Initial

! ---- Ѵ ---- 
  function ag_at(at_data)  ! ڥȥ -> ʻ(2 )

    double precision, dimension(:,:), intent(in)      :: at_data
    double precision, dimension(size(at_data,1),0:im)  :: ag_at

    real(8), dimension(size(at_data,1)*im) :: y
    integer :: m

    m = size(at_data,1)
    if ( size(at_data,2)-1 < km ) then
       call msgdmp('E','ag_at', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call msgdmp('W','ag_at', &
            'The Chebyshev dimension of input data too large.')
    endif

    ag_at = 0.0D0
    ag_at(:,0:km)=at_data
    call fttctb(m,im,ag_at,y,it,t)

  end function ag_at

  function g_t(t_data)  ! ڥȥ -> ʻ(1 )
    double precision, dimension(:), intent(in)  :: t_data
    double precision, dimension(0:im)           :: g_t

    double precision, dimension(1,size(t_data)) :: t_work
    double precision, dimension(1,0:im)         :: g_work

    t_work(1,:) = t_data  
    g_work = ag_at(t_work)
    g_t = g_work(1,:)

  end function g_t


! ---- Ѵ ---- 
  function at_ag(ag_data)  ! ʻ -> ڥȥ(2 )
    double precision, dimension(:,:), intent(in)      :: ag_data
    double precision, dimension(size(ag_data,1),0:km) :: at_ag

    real(8), dimension(size(ag_data,1)*im)   :: y
    real(8), dimension(size(ag_data,1),0:im) :: ag_work
    integer :: m

    m = size(ag_data,1)
    if ( size(ag_data,2)-1 < im ) then
       call msgdmp('E','at_ag', &
            'The Grid points of input data too small.')
    elseif ( size(ag_data,2)-1 > im ) then
       call msgdmp('W','at_ag', &
            'The Grid points of input data too large.')
    endif
    ag_work = ag_data

    call fttctf(m,im,ag_work,y,it,t)
    at_ag = ag_work(:,0:km)

  end function at_ag

  function t_g(g_data)  ! ʻ -> ڥȥ
    double precision, dimension(:), intent(in)     :: g_data
    double precision, dimension(0:km)              :: t_g

    real(8), dimension(1,size(g_data)) :: ag_work
    real(8), dimension(1,0:km)         :: at_work

    ag_work(1,:) = g_data
    at_work = at_ag(ag_work)
    t_g = at_work(1,:)
    
  end function t_g

! ---- ʬ׻ ---- 
  function at_Dx_at(at_data)
    real(8), dimension(:,0:), intent(in)                    :: at_data
    real(8), dimension(size(at_data,1),0:size(at_data,2)-1) :: at_Dx_at

    integer :: m, k
    integer :: nm, kmax

    nm=size(at_data,1)
    kmax=size(at_data,2)-1
    if ( kmax  < km ) then
       call msgdmp('W','at_Dx_at', &
            'The Chebyshev dimension of input data too small.')
    elseif ( kmax > km ) then
       call msgdmp('E','at_Dx_at', &
            'The Chebyshev dimension of input data too large.')
    endif

    if ( kmax == im ) then
       do m=1,nm
          at_Dx_at(m,kmax)   = 0. 
          at_Dx_at(m,kmax-1) = 2 * km * at_data(m,kmax) /2
       enddo
    else
       do m=1,nm
          at_Dx_at(m,kmax)   = 0. 
          at_Dx_at(m,kmax-1) = 2 * km * at_data(m,kmax) 
          ! Ȥϥåбȿ̤. Factor 1/2 
       enddo
    endif

    do k=kmax-2,0,-1
       do m=1,nm
          at_Dx_at(m,k) = at_Dx_at(m,k+2) + 2*(k+1)*at_data(m,k+1)
       enddo
    enddo

    do k=0,kmax
       do m=1,nm
          at_Dx_at(m,k) = 2/xl * at_Dx_at(m,k)
       enddo
    enddo

  end function at_Dx_at

  function t_Dx_t(t_data)
    real(8), dimension(:), intent(in)   :: t_data
    real(8), dimension(size(t_data))    :: t_Dx_t

    real(8), dimension(1,size(t_data))  :: at_work
    
    at_work(1,:) = t_data
    at_work = at_Dx_at(at_work)
    t_Dx_t = at_work(1,:)

  end function t_Dx_t

!---- Dirichlet  ----

  subroutine at_boundaries_DD_2d(at_data,values)
   ! Dirichlet Ŭ

    real(8), dimension(:,0:),intent(inout)         :: at_data ! ǡ(m,0:km)
    real(8), dimension(:,:), intent(in), optional  :: values  ! (m,2)

    real(8), dimension(:,:), allocatable  :: alu
    integer, dimension(:), allocatable    :: kp
    real(8), dimension(0:km,0:km)         :: tt_data
    real(8), dimension(0:km,0:im)         :: tg_data
    real(8), dimension(size(at_data,1))    :: value1, value2           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(at_data,2)-1 < km ) then
       call msgdmp('E','at_boundaries_DD', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call msgdmp('W','at_boundaries_DD', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.

       allocate(alu(0:km,0:km),kp(0:km))

       tt_data=0
       do k=0,km
          tt_data(k,k)=1
       enddo
       alu = tt_data

       tg_data = ag_at(tt_data)
       alu(km-1,:) = tg_data(:,0)
       alu(km,:)   = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    at_data(:,km-1) = value1
    at_data(:,km)   = value2
    at_data = lusolve(alu,kp,at_data)

  end subroutine at_boundaries_DD_2d

  subroutine at_boundaries_DD_1d(t_data,values)
   ! Dirichlet Ŭ

    real(8), dimension(0:km),intent(inout)       :: t_data
    real(8), dimension(2), intent(in), optional  :: values          ! 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_boundaries_DD_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_boundaries_DD_1d


!---- Dirichlet/Neumann  ----

  subroutine at_boundaries_DN_2d(at_data,values)
   ! Dirichlet/Neumann Ŭ

    real(8), dimension(:,0:),intent(inout)         :: at_data ! ǡ(m,0:km)
    real(8), dimension(:,:), intent(in), optional  :: values  ! (m,2)

    real(8), dimension(:,:), allocatable  :: alu
    integer, dimension(:), allocatable    :: kp
    real(8), dimension(0:km,0:km)         :: tt_data
    real(8), dimension(0:km,0:im)         :: tg_data
    real(8), dimension(size(at_data,1))    :: value1, value2           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(at_data,2)-1 < km ) then
       call msgdmp('E','at_boundaries_DN', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call msgdmp('W','at_boundaries_DN', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.

       allocate(alu(0:km,0:km),kp(0:km))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1
       enddo
       alu = tt_data

       tg_data = ag_at(tt_data)
       alu(km-1,:) = tg_data(:,0)
       tg_data = ag_at(at_Dx_at(tt_data))
       alu(km,:)   = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    at_data(:,km-1) = value1
    at_data(:,km)   = value2
    at_data = lusolve(alu,kp,at_data)

  end subroutine at_boundaries_DN_2d

  subroutine at_boundaries_DN_1d(t_data,values)
   ! Dirichlet/Neumann Ŭ

    real(8), dimension(0:km),intent(inout)       :: t_data
    real(8), dimension(2), intent(in), optional  :: values          ! 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_boundaries_DN_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_boundaries_DN_1d

!---- Neumann/Dirichlet  ----

  subroutine at_boundaries_ND_2d(at_data,values)
   ! Neumann/Dirichlet Ŭ

    real(8), dimension(:,0:),intent(inout)         :: at_data ! ǡ(m,0:km)
    real(8), dimension(:,:), intent(in), optional  :: values  ! (m,2)

    real(8), dimension(:,:), allocatable  :: alu
    integer, dimension(:), allocatable    :: kp
    real(8), dimension(0:km,0:km)         :: tt_data
    real(8), dimension(0:km,0:im)         :: tg_data
    real(8), dimension(size(at_data,1))    :: value1, value2           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(at_data,2)-1 < km ) then
       call msgdmp('E','at_boundaries_DN', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call msgdmp('W','at_boundaries_DN', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.

       allocate(alu(0:km,0:km),kp(0:km))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1
       enddo
       alu = tt_data

       tg_data = ag_at(at_Dx_at(tt_data))
       alu(km-1,:) = tg_data(:,0)
       tg_data = ag_at(tt_data)
       alu(km,:)   = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    at_data(:,km-1) = value1
    at_data(:,km)   = value2
    at_data = lusolve(alu,kp,at_data)

  end subroutine at_boundaries_ND_2d

  subroutine at_boundaries_ND_1d(t_data,values)
   ! Neumann/Dirichlet Ŭ

    real(8), dimension(0:km),intent(inout)       :: t_data
    real(8), dimension(2), intent(in), optional  :: values          ! 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_boundaries_ND_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_boundaries_ND_1d


!---- Neumann  ----

  subroutine at_boundaries_NN_2d(at_data,values)
   ! Neumann/Dirichlet Ŭ

    real(8), dimension(:,0:),intent(inout)         :: at_data ! ǡ(m,0:km)
    real(8), dimension(:,:), intent(in), optional  :: values  ! (m,2)

    real(8), dimension(:,:), allocatable  :: alu
    integer, dimension(:), allocatable    :: kp
    real(8), dimension(0:km,0:km)         :: tt_data
    real(8), dimension(0:km,0:im)         :: tg_data
    real(8), dimension(size(at_data,1))    :: value1, value2           ! 

    logical :: first = .true.
    integer :: k
    save    :: alu, kp, first

    if ( size(at_data,2)-1 < km ) then
       call msgdmp('E','at_boundaries_DN', &
            'The Chebyshev dimension of input data too small.')
    elseif ( size(at_data,2)-1 > km ) then
       call msgdmp('W','at_boundaries_DN', &
            'The Chebyshev dimension of input data too large.')
    endif

    if (.not. present(values)) then
       value1=0 ; value2=0
    else
       value1 = values(:,1) ; value2 = values(:,2)
    endif

    if ( first ) then
       first = .false.

       allocate(alu(0:km,0:km),kp(0:km))

       tt_data = 0
       do k=0,km
          tt_data(k,k)=1
       enddo
       alu = tt_data

       tg_data = ag_at(at_Dx_at(tt_data))
       alu(km-1,:) = tg_data(:,0)
       alu(km,:)   = tg_data(:,im)

       call ludecomp(alu,kp)
    endif

    at_data(:,km-1) = value1
    at_data(:,km)   = value2
    at_data = lusolve(alu,kp,at_data)

  end subroutine at_boundaries_NN_2d

  subroutine at_boundaries_NN_1d(t_data,values)
   ! Neumann/Dirichlet Ŭ

    real(8), dimension(0:km),intent(inout)       :: t_data
    real(8), dimension(2), intent(in), optional  :: values          ! 

    real(8), dimension(1,0:km)                   :: at_work
    real(8), dimension(1,2)                      :: vwork           ! 

    if (.not. present(values)) then
       vwork(1,1)=0 ; vwork(1,2)=0
    else
       vwork(1,:) = values
    endif

    at_work(1,:)=t_data
    call at_boundaries_NN_2d(at_work,vwork)
    t_data=at_work(1,:)

  end subroutine at_boundaries_NN_1d

  !--------------- ʬ׻ -----------------
    function a_Int_ag(ag)
      real(8), dimension(:,0:), intent(in)     :: ag
      real(8), dimension(size(ag,1))           :: a_Int_ag
      integer :: i

      if ( size(ag,2) < im+1 ) then
         call msgdmp('E','ae_ag', &
              'The Grid points of input data too small.')
      elseif ( size(ag,2) > im+1 ) then
         call msgdmp('W','ae_ag', &
              'The Grid points of input data too large.')
      endif

      a_Int_ag = 0.0d0
      do i=0,im
         a_Int_ag(:) = a_Int_ag(:) + ag(:,i)*g_X_Weight(i)
      enddo
    end function a_Int_ag

    function Int_g(g)
      real(8), dimension(0:im), intent(in)   :: g
      real(8)                                :: Int_g

      Int_g = sum(g*g_X_Weight)
    end function Int_g

    function a_Avr_ag(ag)
      real(8), dimension(:,0:), intent(in)   :: ag
      real(8), dimension(size(ag,1))         :: a_Avr_ag

      a_Avr_ag = a_Int_ag(ag)/sum(g_X_Weight)
    end function a_Avr_ag

    function Avr_g(g)
      real(8), dimension(0:im), intent(in)   :: g
      real(8)                                :: Avr_g

      Avr_g = Int_g(g)/sum(g_X_Weight)
    end function Avr_g

end module at_module
