!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_integral_module
!
!  2002/05/25  ݹ 
!
module w_integral_module
  use w_base_module, only : im, jm, x_Lon_Weight, y_Lat_Weight

  implicit none

  private
 
  public IntLonLat_xy                      ! ٷʬ
  public y_IntLon_xy, IntLon_x             ! ʬ    
  public x_IntLat_xy, IntLat_y             ! ʬ    
  public AvrLonLat_xy                      ! ٷʿ
  public y_AvrLon_xy, AvrLon_x             ! ʿ    
  public x_AvrLat_xy, AvrLat_y             ! ʿ    

  contains

  !--------------- ʬ׻ -----------------
    function IntLonLat_xy(xy_data)        ! ٷʬ
      real(8), intent(in)   :: xy_data(im,jm)         ! ʻ(im,jm)
      real(8) :: IntLonLat_xy                         ! ʬ

      IntLonLat_xy = IntLon_x(x_IntLat_xy(xy_data))
    end function IntLonLat_xy

    function x_IntLat_xy(xy_data)          ! ʬ
      real(8), intent(in) :: xy_data(im,jm)           ! ʻ(im,jm)
      real(8)             :: x_IntLat_xy(im)          ! ʻ(im)
      integer :: j

      x_IntLat_xy = 0
      do j=1,jm
         x_IntLat_xy = x_IntLat_xy + xy_data(:,j) * y_Lat_weight(j)
      enddo

    end function x_IntLat_xy

    function y_IntLon_xy(xy_data)          ! ʬ
      real(8), intent(in) :: xy_data(im,jm)            ! ʻ(im,jm)
      real(8)             :: y_IntLon_xy(jm)           ! ʻ(jm)
      integer :: i

      y_IntLon_xy = 0
      do i=1,im
         y_IntLon_xy = y_IntLon_xy + xy_data(i,:) * x_Lon_weight(i)
      enddo

    end function y_IntLon_xy

    function IntLat_y(y_data)          ! ʬ
      real(8), intent(in) :: y_data(jm)                ! ʻ(jm)
      real(8)             :: IntLat_y                  ! ʬ

      IntLat_y = sum(y_data * y_Lat_weight)

    end function IntLat_y

    function IntLon_x(x_data)          ! ʬ
      real(8), intent(in) :: x_data(im)                ! ʻ(im)
      real(8)             :: IntLon_x                  ! ʬ

      IntLon_x = sum(x_data * x_Lon_weight)

    end function IntLon_x

  !--------------- ʿѷ׻ -----------------
    function AvrLonLat_xy(xy_data)        ! ٷʿ
      real(8), intent(in)   :: xy_data(im,jm)        ! ʻ(im,jm)
      real(8) :: AvrLonLat_xy                        ! ʿ

      AvrLonLat_xy = AvrLon_x(x_AvrLat_xy(xy_data))
    end function AvrLonLat_xy

    function x_AvrLat_xy(xy_data)          ! ʿ
      real(8), intent(in) :: xy_data(im,jm)          ! ʻ(im,jm)
      real(8)             :: x_AvrLat_xy(im)         ! ʻ(im)

      x_AvrLat_xy = x_IntLat_xy(xy_data)/sum(y_Lat_weight)

    end function x_AvrLat_xy

    function y_AvrLon_xy(xy_data)          ! ʿ
      real(8), intent(in) :: xy_data(im,jm)          ! ʻ(im,jm)
      real(8)             :: y_AvrLon_xy(jm)         ! ʻ(jm)

      y_AvrLon_xy = y_IntLon_xy(xy_data)/sum(x_Lon_weight)

    end function y_AvrLon_xy

    function AvrLat_y(y_data)          ! ʿ
      real(8), intent(in) :: y_data(jm)              ! ʻ(jm)
      real(8)             :: AvrLat_y                ! ʿ

      AvrLat_y = IntLat_y(y_data)/sum(y_Lat_weight)

    end function AvrLat_y

    function AvrLon_x(x_data)          ! ʿ
      real(8), intent(in) :: x_data(jm)               ! ʻ(im,*)
      real(8)             :: AvrLon_x                 ! ʿ

      AvrLon_x = IntLon_x(x_data)/sum(x_Lon_weight)

    end function AvrLon_x

  end module w_integral_module
