#
# u2df07.rb
#
# $Id$
#

require "numru/dcl"

include NumRu
include Math


nx = 19
ny = 19
xmin = 0
xmax = 360
ymin = -90
ymax = 90
drad = PI/180
dz = 0.05

p = NArray.sfloat(nx, ny)
u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

rmiss = DCL::glrget('RMISS')
DCL::gllset('LMISS', true)

for j in 0..ny-1
  for i in 0..nx-1
    if (j == 0 || j == ny-1)
      u[i,j]=rmiss
      v[i,j]=rmiss
    else
      u[i,j] = p[i,j-1] - p[i,j+1]
      v[i,j] = p[DCL::imod(i+1,nx-1),j] - p[DCL::imod(i-1,nx-1),j]
    end
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::usdaxs

DCL::ugvect(u, v)

DCL::grcls

