#
# uspk06.rb
#
# $Id$
#

require "numru/dcl"

include NumRu
include Math


n = 200
t = NArray.sfloat(n)
a = NArray.sfloat(n)
x, y, z, s, r, b, dt = [0.0, 1.0, 1.0, 10.0, 26.0, 2.6, 0.01]

#-----------------------------------------------------------------------
t = t.indgen(0.0, 1000)
for i in 0..n-1
  for j in 0..7
    dx = -s*x + s*y
    dy = -x*z + r*x - y
    dz =  x*y - b*z
    x = x + dx*dt
    y = y + dy*dt
    z = z + dz*dt
  end
  a[i] = y + 20.0
end

#-----------------------------------------------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::ussttl('TIME', 'SEC', 'HEAT FLUX', 'W/m|2"')
DCL::usgrph(t, a)

DCL::grcls

