#! /bin/sh
#
### BEGIN INIT INFO
# Provides:          dhis-client
# Required-Start:    $network $remote_fs
# Required-Stop:     $network $remote_fs
# Should-Start:      $syslog
# Should-Stop:       $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start the Dynamic Host Information System client
# Description:       DHIS is a client-server architecture meant to update
#                    databases for systems which are assigned a dynamic IP[v4]
#                    address. By the means of a DHIS client a host which is
#                    assigned a dynamic IP address (either from its ISP or from
#                    DHCP) is able to communicate with a DHIS server in order
#                    to advertise its newly acquired IP address.
### END INIT INFO

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/dhid
NAME=dhid
DESC=dhis-client

test -f $DAEMON || exit 0

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: $NAME"
	start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
		--exec $DAEMON
	echo "."
	;;
  stop)
	echo -n "Stopping $DESC: $NAME"
	start-stop-daemon --oknodo --stop --quiet --pidfile /var/run/$NAME.pid \
		--exec $DAEMON
	echo "."
	;;
  #reload)
	#echo "Reloading $DESC configuration files."
	#start-stop-daemon --stop --signal 1 --quiet --pidfile \
	#	/var/run/$NAME.pid --exec $DAEMON
  	#;;
  restart|force-reload)
	echo -n "Restarting $DESC: $NAME"
	start-stop-daemon --oknodo --stop --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON
	sleep 1
	start-stop-daemon --start --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON
	echo "."
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
