funcparserlib
=============

A recurisve descent parsing library based on functional combinators.


Installation
------------

The `funcparserlib` library is installed via the standard Python installation
tools `pip` and `distribute`:

    $ pip install funcparserlib

You can also download the source code manually and install it using:

    $ python setup.py install

It is also possible to run tests via `unittest`, `nosetests` or `tox`:

    $ python -m unittest discover funcparserlib.tests
    $ nosetests funcparserlib.tests
    $ tox


Documentation
-------------

The comprehensive [funcparserlib Tutorial][1] is available as `./doc/Tutorial.md`.

A short intro to `funcparserlib` can be found in the [Nested Brackets
Mini-HOWTO][2], see `./doc/Brackets.md`.

See also comments inside the modules `funcparserlib.parser` and
`funcparserlib.lexer` or generate the API docs from the modules using `pydoc`.

There a couple of examples available in `./examples` directory:

* GraphViz DOT parser
* JSON paser

See also [the changelog][3] and [FAQ][4].

  [1]: Tutorial
  [2]: Brackets
  [3]: Changes
  [4]: FAQ

<!-- vim:set ft=markdown tw=80: -->

