/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.sheet;

import java.util.ArrayList;

public class Lines {
    
    ArrayList<Line> lineList;
    
    public Lines() {
        lineList = new ArrayList<Line>();
    }
    
    public void add(Line line) {
        
        if (line != null && lineList.contains(line) == false) {
            lineList.add(line);
        }
    }

    public Line getFirstLine() {

        if (lineList != null && lineList.size() > 0) {
            return lineList.get(0);
        }
        
        return null;
    }

    public Line getLine(int index) {

        if (lineList != null && lineList.size() > index) {
            return lineList.get(index);
        }
        
        return null;
    }

    public ArrayList<Line> getList() {
        return lineList;
    }

    public void clear() {
        lineList.clear();
    }

    public int size() {
        return lineList.size();
    }

    public Line getLastLine() {

        if (lineList.size() > 0) {
            return lineList.get(lineList.size() -1);
        }
        
        return null;
    }
}
