; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse4.1 -O3 | FileCheck %s --check-prefixes=SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 -O3 | FileCheck %s --check-prefixes=SSE41
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512f -O3 | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f -O3 | FileCheck %s --check-prefixes=AVX

declare <4 x float> @llvm.experimental.constrained.ceil.v4f32(<4 x float>, metadata)
declare <2 x double>  @llvm.experimental.constrained.ceil.v2f64(<2 x double>, metadata)
declare <4 x float> @llvm.experimental.constrained.floor.v4f32(<4 x float>, metadata)
declare <2 x double> @llvm.experimental.constrained.floor.v2f64(<2 x double>, metadata)
declare <4 x float> @llvm.experimental.constrained.trunc.v4f32(<4 x float>, metadata)
declare <2 x double> @llvm.experimental.constrained.trunc.v2f64(<2 x double>, metadata)
declare <4 x float> @llvm.experimental.constrained.rint.v4f32(<4 x float>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.rint.v2f64(<2 x double>, metadata, metadata)
declare <4 x float> @llvm.experimental.constrained.nearbyint.v4f32(<4 x float>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.nearbyint.v2f64(<2 x double>, metadata, metadata)

define <4 x float> @fceilv4f32(<4 x float> %f) #0 {
; SSE41-LABEL: fceilv4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundps $10, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: fceilv4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundps $10, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.experimental.constrained.ceil.v4f32(
                          <4 x float> %f, metadata !"fpexcept.strict") #0
  ret <4 x float> %res
}

define <2 x double> @fceilv2f64(<2 x double> %f) #0 {
; SSE41-LABEL: fceilv2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundpd $10, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: fceilv2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundpd $10, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.experimental.constrained.ceil.v2f64(
                        <2 x double> %f, metadata !"fpexcept.strict") #0
  ret <2 x double> %res
}

define <4 x float> @ffloorv4f32(<4 x float> %f) #0 {
; SSE41-LABEL: ffloorv4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundps $9, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: ffloorv4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundps $9, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.experimental.constrained.floor.v4f32(
                          <4 x float> %f, metadata !"fpexcept.strict") #0
  ret <4 x float> %res
}

define <2 x double> @ffloorv2f64(<2 x double> %f) #0 {
; SSE41-LABEL: ffloorv2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundpd $9, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: ffloorv2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundpd $9, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.experimental.constrained.floor.v2f64(
                        <2 x double> %f, metadata !"fpexcept.strict") #0
  ret <2 x double> %res
}

define <4 x float> @ftruncv4f32(<4 x float> %f) #0 {
; SSE41-LABEL: ftruncv4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundps $11, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: ftruncv4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundps $11, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.experimental.constrained.trunc.v4f32(
                          <4 x float> %f, metadata !"fpexcept.strict") #0
  ret <4 x float> %res
}

define <2 x double> @ftruncv2f64(<2 x double> %f) #0 {
; SSE41-LABEL: ftruncv2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundpd $11, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: ftruncv2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundpd $11, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.experimental.constrained.trunc.v2f64(
                        <2 x double> %f, metadata !"fpexcept.strict") #0
  ret <2 x double> %res
}

define <4 x float> @frintv4f32(<4 x float> %f) #0 {
; SSE41-LABEL: frintv4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundps $4, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: frintv4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundps $4, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.experimental.constrained.rint.v4f32(
                          <4 x float> %f,
                          metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret <4 x float> %res
}

define <2 x double> @frintv2f64(<2 x double> %f) #0 {
; SSE41-LABEL: frintv2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundpd $4, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: frintv2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundpd $4, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.experimental.constrained.rint.v2f64(
                        <2 x double> %f,
                        metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret <2 x double> %res
}

define <4 x float> @fnearbyintv4f32(<4 x float> %f) #0 {
; SSE41-LABEL: fnearbyintv4f32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundps $12, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: fnearbyintv4f32:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundps $12, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <4 x float> @llvm.experimental.constrained.nearbyint.v4f32(
                          <4 x float> %f,
                          metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret <4 x float> %res
}

define <2 x double> @fnearbyintv2f64(<2 x double> %f) #0 {
; SSE41-LABEL: fnearbyintv2f64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    roundpd $12, %xmm0, %xmm0
; SSE41-NEXT:    ret{{[l|q]}}
;
; AVX-LABEL: fnearbyintv2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vroundpd $12, %xmm0, %xmm0
; AVX-NEXT:    ret{{[l|q]}}
  %res = call <2 x double> @llvm.experimental.constrained.nearbyint.v2f64(
                        <2 x double> %f,
                        metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret <2 x double> %res
}

attributes #0 = { strictfp }
