"""add "is_retroactive" to Thread and fix nullable columns

Revision ID: 6af2d8f6be76
Revises: 29f85e56b6d4
Create Date: 2025-05-02 11:21:54.023587

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy.sql import false


# revision identifiers, used by Alembic.
revision = "6af2d8f6be76"
down_revision = "29f85e56b6d4"
branch_labels = None
depends_on = None


def upgrade():
    with op.batch_alter_table("thread", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "is_retroactive",
                sa.Boolean(),
                server_default=false(),
                nullable=False,
                comment="Indicates if thread ID was added after the original message was sent (e.g. to link a parent message which didn't have a thread ID to a thread).",
            )
        )
        batch_op.alter_column("thread_id", existing_type=sa.TEXT(), nullable=False)


def downgrade():
    with op.batch_alter_table("thread", schema=None) as batch_op:
        batch_op.alter_column("thread_id", existing_type=sa.TEXT(), nullable=True)
        batch_op.drop_column("is_retroactive")
