/* SPDX-FileCopyrightText: 2007 - 2009 Jesús Barbero Rodríguez <chuchiperriman@gmail.com>
 * SPDX-FileCopyrightText: 2009 - Jesse van den Kieboom <jessevdk@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_COMPLETION_INFO             (gtk_source_completion_info_get_type ())
#define GTK_SOURCE_COMPLETION_INFO(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_COMPLETION_INFO, GtkSourceCompletionInfo))
#define GTK_SOURCE_COMPLETION_INFO_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_COMPLETION_INFO, GtkSourceCompletionInfoClass)
#define GTK_SOURCE_IS_COMPLETION_INFO(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_COMPLETION_INFO))
#define GTK_SOURCE_IS_COMPLETION_INFO_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_COMPLETION_INFO))
#define GTK_SOURCE_COMPLETION_INFO_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_COMPLETION_INFO, GtkSourceCompletionInfoClass))

typedef struct _GtkSourceCompletionInfo         GtkSourceCompletionInfo;
typedef struct _GtkSourceCompletionInfoClass    GtkSourceCompletionInfoClass;
typedef struct _GtkSourceCompletionInfoPrivate  GtkSourceCompletionInfoPrivate;

struct _GtkSourceCompletionInfo
{
	GtkWindow parent;
	GtkSourceCompletionInfoPrivate *priv;
};

struct _GtkSourceCompletionInfoClass
{
	GtkWindowClass parent_class;
	gpointer padding[1];
};

G_MODULE_EXPORT
GType		gtk_source_completion_info_get_type		(void) G_GNUC_CONST;

G_MODULE_EXPORT
GtkSourceCompletionInfo *
		gtk_source_completion_info_new			(void);

G_MODULE_EXPORT
void		gtk_source_completion_info_move_to_iter		(GtkSourceCompletionInfo *info,
								 GtkTextView             *view,
								 GtkTextIter             *iter);

G_GNUC_INTERNAL
void		_gtk_source_completion_info_set_xoffset		(GtkSourceCompletionInfo *info,
								 gint                     xoffset);

G_END_DECLS
