/* Known-answer tests for passphrase hashes.  -*- mode: c -*-
   Automatically generated by ka-table-gen.py.
   Do not edit this file by hand.  */

#if INCLUDE_bcrypt && defined TEST_bcrypt
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.7uG0VCzI2bS7j6ymqJi9CdcdxiRTWNy", "" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu0oImNDIy4flhldV9YqunRgBAePKmw7m", "" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.Cg0ly9t/KVBCBYYDfOmZKwry9JuXClC", "" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuubyCG3zY1GIXMyxfivm.ClDiInHzxjiq", "" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.REUe.wVCLEE7cNcWpheIXR9MaRPCoVC", " " },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuueHjTs35M4oLkB0oz2vpFCrkqmB3wDyK", " " },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.QK3io8Pm4WhsBSZhzvm1OPPQ1MU.WxC", " " },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu/ied6LYDv4Nek.n8vXq7pbx7mJcRizO", " " },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.crbyEJ0XFaJ9sONRyOTHdI7c4ZT.ndu", "a" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu8.veTXNDPV2eEsdpKNczMw2otgh5LnK", "a" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.f/Fm9DOYGp2ai9rjxvG4QHlhtDCuDuu", "a" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuMFdJu9yVgmagVAIC24fOZkaFqd3s9JC", "a" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.w5.fxtwCNbJ3swM5YKT2SoO0YcCOkhS", "ab" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu0EJam7uq2UHswNA05epRm6fJdiFmbUi", "ab" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.ThcCpjPKXmu6XgQqJJEGokAiEUquQVe", "ab" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu0CkeIeZLJOlOL1QPPhfXulLNPdFqJBW", "ab" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.gNn9EDJdrUJF53AHnb.4T9BCvqhUYdW", "abc" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuRWUgMyyCUnsDr8evYotXg5ZXVF/HhzS", "abc" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.AKurti2nSiRoaXd0tyyeWA.1jj9Kto2", "abc" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuCi15uRb1eH7NAlJ/TgeJertyknQpYn2", "abc" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.E5YPO9kmyuRGyh0XouQYb4YMJKvyOeW", "U*U" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuMpLhh66NJUQMuZ6FwRQX0sqAEKeWcKW", "U*U" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.K7Qr0se1MxuggH4aP4YgB.U2Em1pGSK", "U*U" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuCFaEytnzrfaPZJKbS76hh9vqd9r8v2S", "U*U" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.VGOzA784oUp/Z0DY336zx7pLYAy0lwK", "U*U*" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuueqZzwRqX8BEsrV2jF8gx70v6bcd1qAG", "U*U*" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.5dvsdVl2y/501tm9dvdbbSRbpuvxsaC", "U*U*" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuBtzXFXMcxIslxJptQaoJYuU.xP21coS", "U*U*" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.Bw3BobdGs1SFsKsRLIx9rC4T.Q7DtEm", "U*U*U" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuupkvHj1c6E382bN8hwXRlu1xE4bc1pgG", "U*U*U" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.r2Gz4aKpQDpr6TmvEJksSv12hIDVgXe", "U*U*U" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuMJG4SPxGpsI2PpmiVYJg7D.hA7CdQyO", "U*U*U" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.6YtT5mHh5I666KkHRqqIuteDuaNX1GS", "....." },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuun3YeQp9ZOh1qWiEKJNRybZT69WMr2sW", "....." },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.6v/P2K1bqBzj9FILn7LJntMzJQxUuA6", "....." },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu7bnTzNnC9mpomsuya2sDYCcZGtW3FKu", "....." },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.LZrfN0lz4CULfFuRjqXiVMP49yNOHKi", "dragon" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuG4nizIsfFMB34Hh5MoYcbtdFUq5YPJK", "dragon" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.tidtIFf5ZCN.gk6Mobs.YyDMzNhFfFm", "dragon" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuujzhP54E3nDKxLTbGbyrFiW3EkV.7ERC", "dragon" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.i7hPnfU5WycMwd1C9qJZDFBCw8NcAFu", "dRaGoN" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuMA7xTS.7H8Lal4RW.s8KBMURGOrPxQa", "dRaGoN" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.5TqUWVAHsz4mvbAcNwu3JSwt7Pd.dm2", "dRaGoN" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuqS/OX35wGo1BfqluN8dsq//CyXY2pNS", "dRaGoN" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.ZGVtQn6eTc3aPe.tQ.zJuH3XlzyI9Di", "DrAgOn" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuO5PYTf2OGllbJ1tyzjIAdpnQ9rUDGNC", "DrAgOn" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.SzmeTH6T6GIGbKj9Om75UAlglaj4twK", "DrAgOn" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuE9zYHFcawnjSDJKsSux5hf1fyy3utXW", "DrAgOn" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.u/WsPSagrbjc3QmFLSt6j9e/LJ8FoNm", "PAROLX" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuzyv2QWIljnSNjMYpSebmlCqn.QEGEB6", "PAROLX" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.pQY3jmCmc/1Pk8B2m6DNUj9ANrzICLK", "PAROLX" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuumicc49hlc3UdUYSMeE8ZXKFJcV/Q2Nm", "PAROLX" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.7Knr9/jUQJ0lh8N4AU/fMnQskXCdfSu", "U*U***U" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu0whe22G2FGJcNLWQaY2ZVuZIf5IJBHK", "U*U***U" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.H3n2rsAGLquD5DBiTNaKBEYcc0HJy5K", "U*U***U" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuDu3PK53XxhceAEiIIFWWlG16bn5LvcG", "U*U***U" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.HjTkKOvb2xTYRqeMFaN1PRcxuDYro5y", "abcdefg" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu3NLAiMrV.ggY98aZ7cNIwxII7afa91.", "abcdefg" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.GQNqYPSPnkqs4XPHOKxta8z3oVxx.Oe", "abcdefg" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuGTNT0Ri8Ic/nBhrRQu0ORxwctqE11mO", "abcdefg" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.RFkLTR7KyUmGXnFvMFlLbB23MCIzsgi", "01234567" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuQOF57SPhYRiKufm4.epZm3ELZ4UlAVy", "01234567" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.3uce2XN8xqrZ2aIduEu48JNEUk6ih9y", "01234567" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuucnCKiuhmJV3sCjWqQH.rYNPhmru2Bfq", "01234567" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.hz7CVP6wIj8Z57Ze7yuhrhzKfvq0Ty.", "726 even" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuIaVbx2I8MHKuu1rBc/gqV8Fo2An7wQm", "726 even" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.ib/v2w9PynSZewkHDlSuFwGC.jkyh4a", "726 even" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuus/VSIfP19Ty4eQaE51vB9GbPNmLhq2S", "726 even" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.jUMW9ITlTfAw5cFja1iYihO7V9qsmWK", "zyxwvuts" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuucN2On7GNyUtMxT..Bo0a0ICaTeQOJ4u", "zyxwvuts" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.xf6Tlh/zfR9Qob4S/6wj9RneRcBt4yG", "zyxwvuts" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuucqOWKor12VNz5REoX.a3GqgU2btIQWS", "zyxwvuts" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.hdihJRIixUmRFFg0NQNaid9UF3Uw/Q.", "ab1234567" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuulK6ChIvFKqdreUvOY9oKm2O2Fn.1Zuq", "ab1234567" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.xq4CFi9Keo/OhWm9tosH45r9gI3Gd4C", "ab1234567" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuuBq8XeHGZZJdrs6jsgiLupxqOP4GLc6", "ab1234567" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.0c9Eoia74tfCGVyINCZAcZaVzJdMsoi", "alexander" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu3qH73fcOvo6pdGd/u/Of.mkavvVviAG", "alexander" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.bK5f5L/foC9KH3IYxj9uWGZPE/w22J2", "alexander" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu1zazepZSS74T7o4eCXaJqsa4KC41vt6", "alexander" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.Tc9f8dMIa03zsepKEv1oSFsFWT84Me.", "beautiful" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuusxVo.QMslOcijv585zolzUwesRGYfui", "beautiful" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.7XxYg42754jz07Elen5lFQuommU7crW", "beautiful" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuHz11b40qtSU5.OKZJGONgmO6tsOw8ny", "beautiful" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.SxOcYMxtg44jVOAYY0zBeTBbfCYXSBu", "challenge" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuD2bZx1XnT2xoC7mKx.Jr7E20hJXg5y.", "challenge" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.mK3Hkg2ZFCrNFQRor1M7Bd.pyBSFz56", "challenge" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu92OCZ/GwgJ2w0KrMJRu6fK7i2iKqYha", "challenge" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.455yryJspofWOsWxxZ/Tsu5qtg8j2wm", "chocolate" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuulZGdWs.WkvfSGHTz.1.5CPi2ETJLi3.", "chocolate" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.N0Iumk1Mt6l7kbmk8iYgSA9FqaEfv5y", "chocolate" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuLbL252qaabO.sIFmAzyShKINVGRsGeu", "chocolate" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.ZA//OMzj1MY4PfGODYfbeGs8HPUS2zq", "cr1234567" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuUccVOwN/r/34c2SICyLEwyfRWS4Vgja", "cr1234567" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.8tZkJ2HTsa4Pn6bgGzpDRWJ8c1biGYu", "cr1234567" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuA.Ry5GZ8Ob/wI0r8UydZ6XfbyfLJ5JK", "cr1234567" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.XyLDmzSo8jvTANPtIoCB164F84v8EkS", "katherine" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuOYRnTkqPmRfoAB/blXEA7y5xOBtiEg6", "katherine" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.bsdSaZOaobkZJkNO2MxskcWIZCJ8btK", "katherine" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu5i6Sk8a0h8mpYFdjQZdYrEsLaxZ1EaG", "katherine" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC./cK5Kv8QvFDy9GyVbaJS/eEKlmhA6wW", "stephanie" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuucK0uB5JOSYLNCq75/1vd9213cIwiEQi", "stephanie" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.Yr8Btf/4dkO36VgY1VYAp6Q9B4.B/rm", "stephanie" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuug3T9Nmp5d1Zd35nXtrYPiCSv8A6PVAu", "stephanie" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.VYs2hleVmLTA.FbmrBwOI38C4Pd/8BS", "sunflower" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuY/44p2UkK4uV0kvS9KurVonsOh/oc5m", "sunflower" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.VuKIcBGfiLx.AYuX6c48oQtlhMCQPRq", "sunflower" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuul18yFhC69sq/WwO8ibiE1VQy773yVfu", "sunflower" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.465.cDVHqgo4g9qBZIbQbOcdcGqRs2O", "basketball" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuFT2m2RbIlbhkAJBfZ3FCN3Sn3V.N4Bm", "basketball" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.R293rqybpDGrtZIhZxApKqVLXiOJUTG", "basketball" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuudp7.T6JYoR2jjqAKGX8kDLzPDm6RR3S", "basketball" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.XUKWvx5JT0wYalbOFE4HU.j3lDUpDcm", "porsche911" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuupKJ./ES4uwzJk/SsN3YaTFdl9AIiAdu", "porsche911" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.jgOl9b/oD1cEHohzVyGK6zqcGccVRBG", "porsche911" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuVXo2ooNppOi53FnAHCUuZp8EyiwUoCi", "porsche911" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.sXCEcM/a6jUtNpF7EFCOWiQRogVPxNW", "|_337T`/p3" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuugZjL4p/g0M.xDKdvzvO1BKtO0aYdnwC", "|_337T`/p3" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.UyHWsohI3G2oJ05vftc06k9UIwXNW4a", "|_337T`/p3" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuh7AZQzpU7Q7C5l4VczvD6UVfhLQVCDK", "|_337T`/p3" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.ScdVt/vv5qxU5Weko6ZqQcaHw2EjuRG", "thunderbird" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuhX1c3kKr2qeB4tFvvRmDk/ta3LTQtma", "thunderbird" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.XXuNspXmlmLMqkZ37Xt0om56PIqSupq", "thunderbird" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuSJB.YmarGme5IjgFBN49eRn74KS.zVC", "thunderbird" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.z6PrHbuSsMSSwIGFy1JGevQZf6CqJ1y", "Hello world!" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu7nFISH/8YdwlXD3lw69A4iBUf6fvWAW", "Hello world!" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.M.JZM2tZUe85sR83hfk5p2NZ0IVXwXe", "Hello world!" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuyeG8laUfZvsCmc.AE6qIDYSPGM2efmK", "Hello world!" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.cTKgEgC.g8ePpbyZbNC34HvEm4dr75a", "pleaseletmein" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu2EjsH9/6E2HK9wvYowfGqPX5wGi4UDS", "pleaseletmein" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.3WPQy/x8EhyouO1Eia.f.CS216k/lTq", "pleaseletmein" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuumH1BFkDxi3LKCbP6FQ2juPgiLLcuV6S", "pleaseletmein" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.UTQ/YCMF16uRDggIHAnzfTGA1GG/5.K", "a short string" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuZM773JiyU8IodKIqJ54EAWHzd/nJoF6", "a short string" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.nks3nTLHIdR6yOhEvQZRsOoYVEqWOtW", "a short string" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu.oBhtv6clsTihZTgUKW34dikJs1Zg1y", "a short string" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.gBXVnji0fmYJspngWLhq07sJA.unyGS", "zxyDPWgydbQjgq" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuGbGKxJ6BsCRT7AGpwiKNOKUzJzb5AA.", "zxyDPWgydbQjgq" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.6vf3XUm.amMyfSlIH2P/SIU5V6p644a", "zxyDPWgydbQjgq" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuukgPMil1AyxXOwqj9OWvu3muVwEMg1Aq", "zxyDPWgydbQjgq" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.8TeQYvjyS9VKUlqSLz.kDaRa5v396hC", "photojournalism" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuhJe3S.rJQghSggwRY8.DQE1zCW18PcG", "photojournalism" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.1h1LaJMlvaH2Defb280WzG6X/kqHQQy", "photojournalism" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuugpKNM0gEaEfwZ43UsjoT1tNLK25mqV6", "photojournalism" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC./fog6ND8iIMkWXIpr.Y6LCOndkFsu/m", "ecclesiastically" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuDUj/hoyzOfsxHnlzXPdMGJybsJgbODG", "ecclesiastically" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.AYMycNr126P8pzb9X2aVQjINCiZadp2", "ecclesiastically" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuOt9ERn2.X0reuqDc7blRS.5f8ttIq3a", "ecclesiastically" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.dsZw45vJh0v/SWcvr.H79lmJF/uZKAy", "congregationalism" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuZu0OqjIDqSsvpAvbAqbC.8HRlYYcVkW", "congregationalism" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.1CYpRB/IxktadiLrbTzgJ.Jd/Q06oBe", "congregationalism" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuulau/kOpHdl7CjZgjQuvsiDAB2f/8Aqa", "congregationalism" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.aHkGX/fiki8Qrwu3gWTRnejC9Hba52e", "dihydrosphingosine" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuEJAH.2Z6lOSn5WvfN87I7V1JhCPsW5y", "dihydrosphingosine" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.8obhdpTZ2CAxc8Qbd8dIApwIFM6pzZe", "dihydrosphingosine" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu3tvUtVPx0FPXPsdjb7uta674As4iQfq", "dihydrosphingosine" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.sYSxc3RiA3.WrH2ic000nunk3yqkXHa", "semianthropological" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuLa.VWC3vq9KMn0BrxUY.r4HUotKepnO", "semianthropological" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.tLQTlKtJqj8kJFe92LPFDJdoiTxQ9PO", "semianthropological" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu6yC/otJXGOxvYDo3uRwUKNucauhdOPO", "semianthropological" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.Kvy1q1BWf93W1T7eSLpj/6OuRO.4FqC", "palaeogeographically" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuYNeqeSEZQQFODdHVEfj5MJFvrZPOeF6", "palaeogeographically" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.ybSWdRvitEQlA9I.Oq9wpqMqvBcJiti", "palaeogeographically" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu1POIcCAIthmV0dvj5BClL3hMpuuUctO", "palaeogeographically" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.g7bhq.l6.ix6BSpqhW6wIRoq310s.qO", "electromyographically" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuFj/NgndkQJ9QWdR8vDPZF92Ql/3UYFy", "electromyographically" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.rnGfJV5/J4BjTZj66R1dckO0Gy88d5e", "electromyographically" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuui7gF3bPS07zaLzWARBCVakWoF70OE8K", "electromyographically" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.fr2hBCxymAKP.MXKdQbm7/rIBEBis9y", "noninterchangeableness" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuueL38vMSpfDTZP0TBBAuZDp0A/4eFDFa", "noninterchangeableness" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.z1xt/vCOI.kmvN8L8t9GsafzGsOXupS", "noninterchangeableness" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuR1nrUOQ7HQO0AfPt3niv6JJN90IEgi2", "noninterchangeableness" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.UwjPIUFoFVfh.JD5Z/iVMDQ/.s2BdmK", "abcdefghijklmnopqrstuvwxyz" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuq9gWjWvJAAO9dtIxbLejROlOtpZkAZ2", "abcdefghijklmnopqrstuvwxyz" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.2qEx6VDzW/1gZVPz1yxtxnopI9gvYHG", "abcdefghijklmnopqrstuvwxyz" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuucUHlaG.p8AVcD5w/eidx9TAkwV4EXAW", "abcdefghijklmnopqrstuvwxyz" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.BdcD8qjQ3jCap/PcGpUCiau8u4PMcSy", "electroencephalographically" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuXDAnjJaWDI/Zcl0Om1uOs90q4mqBRWy", "electroencephalographically" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.n1A7hL3v/hM0RBTwKl/MB.eEE0e4av2", "electroencephalographically" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuvcwFX7UZ8m2DKl4e6qPHdONvRVRgApi", "electroencephalographically" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.9WsvENLhmOLqpxNHHDPzl0/i3I0QLXy", "antidisestablishmentarianism" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuNq0IwONJZaZ7QfLbcoA7E.G9LXdQ.8.", "antidisestablishmentarianism" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.WM1vtlGv4CR1StKJWw9/1zvZjhQpVm2", "antidisestablishmentarianism" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu.Nk99xH6C1i1s687VYJkw/9TgJZwvkW", "antidisestablishmentarianism" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.9vgB/QG0/5yJ0/eI2lb6I1NvMoYZHEi", "cyclotrimethylenetrinitramine" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuwOuvuEB8yOWqrtta0jWB10wzwfcx.sG", "cyclotrimethylenetrinitramine" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.mumkbiG5cCSVfxbwD8LbcQV6CFQ3MXq", "cyclotrimethylenetrinitramine" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuukUEvmtjkKEjAeshmrzk18VIJ5pOYI9G", "cyclotrimethylenetrinitramine" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.ld/W//3S8PyfCs05HnX4ctiJEWzxvtu", "dichlorodiphenyltrichloroethane" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuJaeloUBsLGuKojqNVj.JssS.S.5SOoG", "dichlorodiphenyltrichloroethane" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.IJ0s8nV/cDKYfTVFgirVaOoRoZvbMAW", "dichlorodiphenyltrichloroethane" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuQBL3QBmqpQVj0lKsVoN/yVsN7LDfMom", "dichlorodiphenyltrichloroethane" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.qgmN7ezpNt2mv7RXpV9nwxAwSRHe8Z6", "multiple words seperated by spaces" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuUyj6XHAnIT7HIUaHPt/mAqWbLOZ95oW", "multiple words seperated by spaces" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.ya4OMfax14JgLKjCeRnok41QNmDHk.6", "multiple words seperated by spaces" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuurps.S9nvQl/40RApzaFs9lIt3AMcneK", "multiple words seperated by spaces" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.2CHByRiD9EoV4pN2mhPq49ZZhIg5K/.", "supercalifragilisticexpialidocious" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuchc4Fu0voJQx93SMHFKQgbDXESzxUai", "supercalifragilisticexpialidocious" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.mqD8IRcEmTxZ.ChOQZyLHygiTWmqvk2", "supercalifragilisticexpialidocious" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuG9j0r2T6lEIX9LVt3txW9dZuFY0Ew1q", "supercalifragilisticexpialidocious" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.pr..QUPolGyX.oqq.qgP8kNIbwX1YlC", "we have a short salt string but not a short password" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuwLVtPJcEI87Gw5SVMgJ3jR.jz4FXA3C", "we have a short salt string but not a short password" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.S693iU5aWL1P1CiTvv4sKd4VtqEefpm", "we have a short salt string but not a short password" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuus8h4uV7ZQW6KJvz2prsjqaySAO/1k2e", "we have a short salt string but not a short password" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.VkOUUuotOZvrmtXJpkTGsRR7av5It52", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuT837gAqiU/1zYnau8zpkZMploUCluwS", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.iNDvHP9V2K7P.xzMWcBO.ucnS87zUrq", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu5RYaD3UZMA62Bfinm5QndpfWzruwF.O", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.8b67df7RZ0XnI62umy35MYpe4K51Fk2", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuW5igozlL8rSr/rkFexuDh1grrkW8FSi", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.F3K5wiwHej.p9lTXgX9bOlrEyWKv066", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuViu5c2UpaacAGAhQuLE2zyrV3jz4b5e", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.Td/f8oS7ISMxGfHYB8YP9rXGhoZDosO", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuxuElans2nYY6zVSN13XYHtA0oeOXZLa", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.kLVEehyg8LFsXfIVuFyGfLj4dvN7a4e", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuMNSliUjQvcDZoWAZHm/hAG9Z3ZRf5wy", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.4aisLqC2w3pT8aeXd3SHZFJkWSCkf0a", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuoBz.G9gMNiZlW/Gsj.oKhiomPeIRFTC", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.9c/KG5wY7kGTdky/Js0KWIpuVuJFUJG", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuinRgQYMZk.yuMIssG.kPPL6i9WP0xFa", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.heAts1y/8kcTTP0/vD3yeuMX1ihF8dO", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuTp1b9XCEV16BcrQ.0k4xf7V/OGPZLnK", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.A96emG/jBf0K1K6vCG.eZGdLkSridom", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuoaE0x.b2rUEITWgPdg.GEcU4ePHLh6m", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.qJn4AY9ch/WAR5JXeeJtVGeovjQrhd2", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuiYbzuFNFwSfCgqTGNsUFtSDh8PJAqSe", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.h0JFRyDXfP0duxAkVxWGr8nMDEDvPca", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuw8RVl3rh7sNazq544l0944qGq4GUFUq", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.FZEYKXyyMgG13MK0uV8dwNotWf4Wm6e", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuK2KXzhsMefB8v6hJJG3bOyKV.XRf6Qe", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.I7vjUzDOKf8XqcK8VSCm9b0bwoSm1Qm", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuhWYb0x3Q3zM0aBkB2G1arbzmWxRQS/i", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.HD8RnTmGEavoR3LFVfdHvh3xA0QPka2", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuSRMKxjeMqVSDMhSLhOnvtEZ/p5KhUbq", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.zQPVIDk6wF8XmESji30KDHFabTlu0WK", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuk9Hv17Gha84losGKAq61csCZokj5pyy", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.PYLCOpTKZmhFn1CoBM2XNbWgqMX4Jk2", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuUTFLPGm29p.YVzcY6pqejGEql1x8Ccq", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.PQInhDOdCKnXeUE.n/L.kQmTKM9ldK2", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuugI4g/1M6K/Sz2bsgu9VDeEl6reszuXa", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.uIZ1Lgb.jHRDU/Z/LVXfpQCK72fTEHq", "\xc3\xa9tude" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuYdPam5/ypFIyDUQMyCCEIwzVsTi0Sa6", "\xc3\xa9tude" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.TszY8.avBpwJ6xbNjwws3SKBbK6kj6S", "\xc3\xa9tude" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu3wn02pxRJPnFwvlGt75DURDbt4g7om.", "\xc3\xa9tude" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.qcYQ0c2j2SvETms11hszz5bnbvNhN0G", "C)tude" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuo170FGVreUKlJWzQl8GcfhpghDIp2c.", "C)tude" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.2iSSZ5gtiVxKz8BdAoDV9IxZl3LAH7y", "C)tude" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuutA7.Ir5GREoOf.twyI.Zoy.dI1gNHfC", "C)tude" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.tLCLEXAt3RUjOgs.yvfWSni4j1JX/JS", "Chl\xc3\xb6""e" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuz4QFggBRTVUeHRGL/CQxlAYHraYPcpa", "Chl\xc3\xb6""e" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.KHsCqMFVxOAGJObHwEBR3JaEdKVu1.m", "Chl\xc3\xb6""e" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuG6PeIXKiqeNUPUbqFkMJvvI7G9hd51W", "Chl\xc3\xb6""e" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.w.V.mBIadppiKKxZ0OzpXn86NOk43pC", "ChlC6e" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuQ2qgoto47/GjSmc6truiPxHNSL1jAfS", "ChlC6e" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.r7GLvyVWQLuQaOTYsrMOBkbLfy8sPIi", "ChlC6e" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuueolw0UBEFN.qCtReAkwiO7BAjrY4CX6", "ChlC6e" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.UPBzTBMwJb5mKWflQ.5Rid4481RrxVy", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuCARhc7ugFdgoPjDb7LUG.yQF2lboK6e", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.ZHZAnvydiPNiYH2VjRNhEAD6BEiyaWS", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu2WegkGS5Xr/qYNkfEi6JmnR16WVSwcW", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.gx7D73FxK1lx9aoctuj3fhNJqC.IYc6", "C\x05ngstrC6m" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuusSqmEHNEXYcUAamAuvd.piiJP2/SvW6", "C\x05ngstrC6m" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.pjA09E/vp0VG8cavv0kgRuMJNPJRdqS", "C\x05ngstrC6m" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuEFW231TUkQA55cajdiwh2GQXkKY7v4.", "C\x05ngstrC6m" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.OVB6qjs7Uzos9N7/Rpm1laBHwGw11u.", "C\x05ngstrCU*U***U*" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuAEHJsqoIo5645CuTbmM6VobcvFM6pxK", "C\x05ngstrCU*U***U*" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.E/ZiYei4bcJNCJEyI148Q1.aMAOn66e", "C\x05ngstrCU*U***U*" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuumAqJP8MYx4tSoKoE9d0vR0QW81bYuSC", "C\x05ngstrCU*U***U*" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.84ASbYYPYkl18.t0.TvQbm0oh98TFvG", "U*U***U*ignored" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuR.W0Ohu3KxpPUfr5Knw07yOOzZkdd7.", "U*U***U*ignored" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.wx4V3qBoGl7ej9kbsoEpQTxmptzY0yq", "U*U***U*ignored" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu4SS72T2y2mc0YsQSe9qECdkPhGVslHS", "U*U***U*ignored" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.ebmmSqlfcFhKGN/743nH7i03zpqftle", "U*U*U*U*" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuF1QNFce4DfYnYJUcafR1v2/7XbWeLjK", "U*U*U*U*" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.5KIIW3tGg2xhhVu/AQXLZX9lSSeeehu", "U*U*U*U*" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuudBYNJEBvC10idL3LIvyzUGdaxqz0jJW", "U*U*U*U*" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.htnOkHgQ8LrcyWv4cQVE5Bt0DiVxJzG", "U*U*U*U*ignored" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu1JJvN7RoX92Zzq1yGezl/5/3vlXyrxi", "U*U*U*U*ignored" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.7YCBkroPI7yK9JGre8Hne5hdwmA6Z3S", "U*U*U*U*ignored" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuc1KKQsfk4nXu9CnvuF/SfMwrmif7tsC", "U*U*U*U*ignored" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.DzSBCMqe17IfGIqEfq.FrxykxqtrVi2", "*U*U*U*U" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuuzPVVNB/SAKLJbAoTgm3qolIt8JCyqG", "*U*U*U*U" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.1fL1/3fOtt1usdRoe0dWgjAUT/TMd76", "*U*U*U*U" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu39YJ8HbI96dgaVWEUkKUCgXR4676Qjq", "*U*U*U*U" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.yu/PNF5atjbvgp2r9GyRzSYOErUPNHq", "*U*U*U*U*" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuZu/4jl7FZnNPiPunsfxbXLTBcZ4XPMe", "*U*U*U*U*" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.YT6TwplC9qsDdIyZ4nZ.2STP1srJcv.", "*U*U*U*U*" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuQ6t3zlOYOUrJSlX7AdtXuuWd0hDhQiC", "*U*U*U*U*" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.7Cc1PePc3H0bDi8khYlhX6PVDNBB0QK", "*U*U*U*U*U*U*U*U" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuwd22F2Sxe6gq2OS.jcQfMBY2dJtwKyS", "*U*U*U*U*U*U*U*U" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.AYh0eQgGLbt9qiP1jMH9.zHrUuVNY5.", "*U*U*U*U*U*U*U*U" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuui4ZHqA63Ft09xDrL31aaZvJ3RjuITQq", "*U*U*U*U*U*U*U*U" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.jlPoM5ioW.OQLW.5JcdEmo4HtRjF876", "*U*U*U*U*U*U*U*U*" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuz3ESgmDkKJlK0Nuq2.ylqgmDHlpC38q", "*U*U*U*U*U*U*U*U*" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.scf6.mexwrzCAGi3ShQ8cYkynqeH0bK", "*U*U*U*U*U*U*U*U*" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuQLykgCNxKyLhRD0HXzLibuZLZfiGOEO", "*U*U*U*U*U*U*U*U*" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.BvtRGGx3p8o0C5C36uS442Qqnrwofrq", "\xa3" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuEuEnx.TyCLYgkTV/uhWL5xJTHV7ZMjG", "\xa3" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.nCdKcLO57oLlc6J6sNnGyfT9FrIawiW", "\xa3" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuurz1efvzeJjL4mQ813hrZNg3p1.ivOii", "\xa3" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.k786rdsOdUP4cRi.dLa3dsYueMj5UnS", "\xa3""a" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuLN/CEHXLfFeYdOOxbdxKu8ZqSIKgqAu", "\xa3""a" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.4QrucGf30zIbQA.sO0d1QrU63xBrEYq", "\xa3""a" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuugbhoNOH4mWxoEhRrQNdeI.rpk9XeuZS", "\xa3""a" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.1qOUgfpg30XDHLx/zrbWiMRcWyFhwye", "\xd1\x91" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuus6h1E6A2RzVn2KxXLQXsKosQeRo8bLa", "\xd1\x91" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.7UwHe/ywPmdp.nr.ZLQSxd8hqn7qURW", "\xd1\x91" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuSqNATdQiNEckAKLsqgsKbAM5.hZoMCq", "\xd1\x91" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.bJFOmj3TaByM10X0BF32w0Fv/xFNSvm", "\xa3""ab" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuojaU9K.vmSlY6BHpgIQ/WY9rEOCcJO2", "\xa3""ab" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.0EeTSP42yLfD7uTTcDffPd2CNLKHdoy", "\xa3""ab" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuikYh/9nIvugTp.kFPFeZDBu7eW6BLoa", "\xa3""ab" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.Qjdj3GXX7D0sFE9jji6wxSTWIhqI3US", "\xff\xff\xa3" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuHdhhdUXVgLADnbTYf12kvsasO1gS51C", "\xff\xff\xa3" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.PIeeyENZVZmrKLAq5lwBUU9fMRVfV2m", "\xff\xff\xa3" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuMOaOTHB4gEm.rriBjXNwBNh.Oc4mKGG", "\xff\xff\xa3" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.RbKkfW2ph8bd8B5yul5E97DxgDw9cT.", "1\xa3""345" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuurPSVExmrZ2WB1xntSbqZ/DRQRlKtVw.", "1\xa3""345" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.XEhidoDX1kz.RFnwWIzMJvtW2aP/k4e", "1\xa3""345" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuXl2V4mQ7s0zX0b4XXH/b9UkRRCWpq3e", "1\xa3""345" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.WI7ZNXFtzCd9mN1mWoNMQRHEmkDsZnm", "\xff\xa3""345" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu6WgD2zYQDPgxR2sXlUeEeGKknxt95W.", "\xff\xa3""345" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.KBv1eBM2he2T/QheS8zPHMejn5fMNRe", "\xff\xa3""345" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuUIzecIiCguM2sPh1F7L9IS3zOtmg5Im", "\xff\xa3""345" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.VmFQpoXeVuKTzkg2ZRsAf.8PZJZg142", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuucaGU5ROXj4M8Tgsx3s/D5BQIuhazIWa", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.8jdeg8QqT4CX3ERA9vZPFZAkxZRpxJW", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu9f4sA9SRA0scUKcRyC5kce8dao2.GKe", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.xGPMyJSPyyeICKolPQ2gecm8rOgHwz.", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuuTNb9MEHVGI7kd6UnQjYxgRNiKJM01S", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.k.qekGiJym3QgfeFCwNhPHg0Zk99KSa", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuyM59Cq5iVZDB3u45gTNhRSnOgrY1tdG", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.VAQY6kySmwStlNY.sut9Y87njVr0mm.", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuPPtdI0NcxZ4Txyv/Y5ORfcP1XFriKT2", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.tHwehGUs3q0b/Ejn42MsoM4Yv/iA1rq", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuu3cFqlEl7Y0HWaVLHpyyCqG8dBNk1DSm", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.n2VnrmAaokJwiDSekcCjbZxRIyVngRy", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu5s2v8.iXieOjg/.AySBTTZIIVFJeBui", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.0ZsAfF0DsSCOCcfZKxtwXxkV4RFYBVG", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuRAip/W0RPQX4QKkqYqXE3GIXWH518Sm", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.n2VnrmAaokJwiDSekcCjbZxRIyVngRy", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu5s2v8.iXieOjg/.AySBTTZIIVFJeBui", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.0ZsAfF0DsSCOCcfZKxtwXxkV4RFYBVG", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuRAip/W0RPQX4QKkqYqXE3GIXWH518Sm", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.ZkQGqjbMpqQ9oCsxNZjN8LQJaHFqPMC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu51cV.PJOQVwmiao4t4lXsb9Cc3Jnuem", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.DQjlTXDA5PBQ97.qBJY/vsHPQhLJDMe", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuAqM0XavJxJXeVlJ3Te3umGJaPOCYmZi", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.ZkQGqjbMpqQ9oCsxNZjN8LQJaHFqPMC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu51cV.PJOQVwmiao4t4lXsb9Cc3Jnuem", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.DQjlTXDA5PBQ97.qBJY/vsHPQhLJDMe", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuAqM0XavJxJXeVlJ3Te3umGJaPOCYmZi", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.uB1no1bSvQlNFbG6DThB52xIhyG9z8G", "THE YEAR" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuuySE45JP/avbudkXbPzjvqTBKf61NNfi", "THE YEAR" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.c/NBil2GQ9h1axG3uDE7cen7O1yt4wu", "THE YEAR" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuT4fz1ym9dcyOwa1hMmFJSuk4yISb03.", "THE YEAR" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2b$05$CCCCCCCCCCCCCCCCCCCCC.", "$2b$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2b$05$abcdefghijklmnopqrstuu", "$2b$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2b$04$CCCCCCCCCCCCCCCCCCCCC.", "$2b$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2b$04$abcdefghijklmnopqrstuu", "$2b$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // bcrypt

#if INCLUDE_bcrypt_y && defined TEST_bcrypt_y
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.7uG0VCzI2bS7j6ymqJi9CdcdxiRTWNy", "" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu0oImNDIy4flhldV9YqunRgBAePKmw7m", "" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.Cg0ly9t/KVBCBYYDfOmZKwry9JuXClC", "" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuubyCG3zY1GIXMyxfivm.ClDiInHzxjiq", "" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.REUe.wVCLEE7cNcWpheIXR9MaRPCoVC", " " },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuueHjTs35M4oLkB0oz2vpFCrkqmB3wDyK", " " },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.QK3io8Pm4WhsBSZhzvm1OPPQ1MU.WxC", " " },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu/ied6LYDv4Nek.n8vXq7pbx7mJcRizO", " " },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.crbyEJ0XFaJ9sONRyOTHdI7c4ZT.ndu", "a" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu8.veTXNDPV2eEsdpKNczMw2otgh5LnK", "a" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.f/Fm9DOYGp2ai9rjxvG4QHlhtDCuDuu", "a" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuMFdJu9yVgmagVAIC24fOZkaFqd3s9JC", "a" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.w5.fxtwCNbJ3swM5YKT2SoO0YcCOkhS", "ab" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu0EJam7uq2UHswNA05epRm6fJdiFmbUi", "ab" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.ThcCpjPKXmu6XgQqJJEGokAiEUquQVe", "ab" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu0CkeIeZLJOlOL1QPPhfXulLNPdFqJBW", "ab" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.gNn9EDJdrUJF53AHnb.4T9BCvqhUYdW", "abc" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuRWUgMyyCUnsDr8evYotXg5ZXVF/HhzS", "abc" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.AKurti2nSiRoaXd0tyyeWA.1jj9Kto2", "abc" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuCi15uRb1eH7NAlJ/TgeJertyknQpYn2", "abc" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.E5YPO9kmyuRGyh0XouQYb4YMJKvyOeW", "U*U" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuMpLhh66NJUQMuZ6FwRQX0sqAEKeWcKW", "U*U" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.K7Qr0se1MxuggH4aP4YgB.U2Em1pGSK", "U*U" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuCFaEytnzrfaPZJKbS76hh9vqd9r8v2S", "U*U" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.VGOzA784oUp/Z0DY336zx7pLYAy0lwK", "U*U*" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuueqZzwRqX8BEsrV2jF8gx70v6bcd1qAG", "U*U*" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.5dvsdVl2y/501tm9dvdbbSRbpuvxsaC", "U*U*" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuBtzXFXMcxIslxJptQaoJYuU.xP21coS", "U*U*" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.Bw3BobdGs1SFsKsRLIx9rC4T.Q7DtEm", "U*U*U" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuupkvHj1c6E382bN8hwXRlu1xE4bc1pgG", "U*U*U" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.r2Gz4aKpQDpr6TmvEJksSv12hIDVgXe", "U*U*U" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuMJG4SPxGpsI2PpmiVYJg7D.hA7CdQyO", "U*U*U" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.6YtT5mHh5I666KkHRqqIuteDuaNX1GS", "....." },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuun3YeQp9ZOh1qWiEKJNRybZT69WMr2sW", "....." },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.6v/P2K1bqBzj9FILn7LJntMzJQxUuA6", "....." },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu7bnTzNnC9mpomsuya2sDYCcZGtW3FKu", "....." },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.LZrfN0lz4CULfFuRjqXiVMP49yNOHKi", "dragon" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuG4nizIsfFMB34Hh5MoYcbtdFUq5YPJK", "dragon" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.tidtIFf5ZCN.gk6Mobs.YyDMzNhFfFm", "dragon" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuujzhP54E3nDKxLTbGbyrFiW3EkV.7ERC", "dragon" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.i7hPnfU5WycMwd1C9qJZDFBCw8NcAFu", "dRaGoN" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuMA7xTS.7H8Lal4RW.s8KBMURGOrPxQa", "dRaGoN" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.5TqUWVAHsz4mvbAcNwu3JSwt7Pd.dm2", "dRaGoN" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuqS/OX35wGo1BfqluN8dsq//CyXY2pNS", "dRaGoN" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.ZGVtQn6eTc3aPe.tQ.zJuH3XlzyI9Di", "DrAgOn" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuO5PYTf2OGllbJ1tyzjIAdpnQ9rUDGNC", "DrAgOn" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.SzmeTH6T6GIGbKj9Om75UAlglaj4twK", "DrAgOn" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuE9zYHFcawnjSDJKsSux5hf1fyy3utXW", "DrAgOn" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.u/WsPSagrbjc3QmFLSt6j9e/LJ8FoNm", "PAROLX" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuzyv2QWIljnSNjMYpSebmlCqn.QEGEB6", "PAROLX" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.pQY3jmCmc/1Pk8B2m6DNUj9ANrzICLK", "PAROLX" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuumicc49hlc3UdUYSMeE8ZXKFJcV/Q2Nm", "PAROLX" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.7Knr9/jUQJ0lh8N4AU/fMnQskXCdfSu", "U*U***U" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu0whe22G2FGJcNLWQaY2ZVuZIf5IJBHK", "U*U***U" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.H3n2rsAGLquD5DBiTNaKBEYcc0HJy5K", "U*U***U" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuDu3PK53XxhceAEiIIFWWlG16bn5LvcG", "U*U***U" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.HjTkKOvb2xTYRqeMFaN1PRcxuDYro5y", "abcdefg" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu3NLAiMrV.ggY98aZ7cNIwxII7afa91.", "abcdefg" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.GQNqYPSPnkqs4XPHOKxta8z3oVxx.Oe", "abcdefg" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuGTNT0Ri8Ic/nBhrRQu0ORxwctqE11mO", "abcdefg" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.RFkLTR7KyUmGXnFvMFlLbB23MCIzsgi", "01234567" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuQOF57SPhYRiKufm4.epZm3ELZ4UlAVy", "01234567" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.3uce2XN8xqrZ2aIduEu48JNEUk6ih9y", "01234567" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuucnCKiuhmJV3sCjWqQH.rYNPhmru2Bfq", "01234567" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.hz7CVP6wIj8Z57Ze7yuhrhzKfvq0Ty.", "726 even" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuIaVbx2I8MHKuu1rBc/gqV8Fo2An7wQm", "726 even" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.ib/v2w9PynSZewkHDlSuFwGC.jkyh4a", "726 even" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuus/VSIfP19Ty4eQaE51vB9GbPNmLhq2S", "726 even" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.jUMW9ITlTfAw5cFja1iYihO7V9qsmWK", "zyxwvuts" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuucN2On7GNyUtMxT..Bo0a0ICaTeQOJ4u", "zyxwvuts" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.xf6Tlh/zfR9Qob4S/6wj9RneRcBt4yG", "zyxwvuts" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuucqOWKor12VNz5REoX.a3GqgU2btIQWS", "zyxwvuts" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.hdihJRIixUmRFFg0NQNaid9UF3Uw/Q.", "ab1234567" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuulK6ChIvFKqdreUvOY9oKm2O2Fn.1Zuq", "ab1234567" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.xq4CFi9Keo/OhWm9tosH45r9gI3Gd4C", "ab1234567" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuuBq8XeHGZZJdrs6jsgiLupxqOP4GLc6", "ab1234567" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.0c9Eoia74tfCGVyINCZAcZaVzJdMsoi", "alexander" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu3qH73fcOvo6pdGd/u/Of.mkavvVviAG", "alexander" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.bK5f5L/foC9KH3IYxj9uWGZPE/w22J2", "alexander" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu1zazepZSS74T7o4eCXaJqsa4KC41vt6", "alexander" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.Tc9f8dMIa03zsepKEv1oSFsFWT84Me.", "beautiful" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuusxVo.QMslOcijv585zolzUwesRGYfui", "beautiful" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.7XxYg42754jz07Elen5lFQuommU7crW", "beautiful" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuHz11b40qtSU5.OKZJGONgmO6tsOw8ny", "beautiful" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.SxOcYMxtg44jVOAYY0zBeTBbfCYXSBu", "challenge" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuD2bZx1XnT2xoC7mKx.Jr7E20hJXg5y.", "challenge" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.mK3Hkg2ZFCrNFQRor1M7Bd.pyBSFz56", "challenge" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu92OCZ/GwgJ2w0KrMJRu6fK7i2iKqYha", "challenge" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.455yryJspofWOsWxxZ/Tsu5qtg8j2wm", "chocolate" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuulZGdWs.WkvfSGHTz.1.5CPi2ETJLi3.", "chocolate" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.N0Iumk1Mt6l7kbmk8iYgSA9FqaEfv5y", "chocolate" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuLbL252qaabO.sIFmAzyShKINVGRsGeu", "chocolate" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.ZA//OMzj1MY4PfGODYfbeGs8HPUS2zq", "cr1234567" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuUccVOwN/r/34c2SICyLEwyfRWS4Vgja", "cr1234567" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.8tZkJ2HTsa4Pn6bgGzpDRWJ8c1biGYu", "cr1234567" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuA.Ry5GZ8Ob/wI0r8UydZ6XfbyfLJ5JK", "cr1234567" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.XyLDmzSo8jvTANPtIoCB164F84v8EkS", "katherine" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuOYRnTkqPmRfoAB/blXEA7y5xOBtiEg6", "katherine" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.bsdSaZOaobkZJkNO2MxskcWIZCJ8btK", "katherine" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu5i6Sk8a0h8mpYFdjQZdYrEsLaxZ1EaG", "katherine" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC./cK5Kv8QvFDy9GyVbaJS/eEKlmhA6wW", "stephanie" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuucK0uB5JOSYLNCq75/1vd9213cIwiEQi", "stephanie" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.Yr8Btf/4dkO36VgY1VYAp6Q9B4.B/rm", "stephanie" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuug3T9Nmp5d1Zd35nXtrYPiCSv8A6PVAu", "stephanie" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.VYs2hleVmLTA.FbmrBwOI38C4Pd/8BS", "sunflower" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuY/44p2UkK4uV0kvS9KurVonsOh/oc5m", "sunflower" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.VuKIcBGfiLx.AYuX6c48oQtlhMCQPRq", "sunflower" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuul18yFhC69sq/WwO8ibiE1VQy773yVfu", "sunflower" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.465.cDVHqgo4g9qBZIbQbOcdcGqRs2O", "basketball" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuFT2m2RbIlbhkAJBfZ3FCN3Sn3V.N4Bm", "basketball" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.R293rqybpDGrtZIhZxApKqVLXiOJUTG", "basketball" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuudp7.T6JYoR2jjqAKGX8kDLzPDm6RR3S", "basketball" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.XUKWvx5JT0wYalbOFE4HU.j3lDUpDcm", "porsche911" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuupKJ./ES4uwzJk/SsN3YaTFdl9AIiAdu", "porsche911" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.jgOl9b/oD1cEHohzVyGK6zqcGccVRBG", "porsche911" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuVXo2ooNppOi53FnAHCUuZp8EyiwUoCi", "porsche911" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.sXCEcM/a6jUtNpF7EFCOWiQRogVPxNW", "|_337T`/p3" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuugZjL4p/g0M.xDKdvzvO1BKtO0aYdnwC", "|_337T`/p3" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.UyHWsohI3G2oJ05vftc06k9UIwXNW4a", "|_337T`/p3" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuh7AZQzpU7Q7C5l4VczvD6UVfhLQVCDK", "|_337T`/p3" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.ScdVt/vv5qxU5Weko6ZqQcaHw2EjuRG", "thunderbird" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuhX1c3kKr2qeB4tFvvRmDk/ta3LTQtma", "thunderbird" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.XXuNspXmlmLMqkZ37Xt0om56PIqSupq", "thunderbird" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuSJB.YmarGme5IjgFBN49eRn74KS.zVC", "thunderbird" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.z6PrHbuSsMSSwIGFy1JGevQZf6CqJ1y", "Hello world!" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu7nFISH/8YdwlXD3lw69A4iBUf6fvWAW", "Hello world!" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.M.JZM2tZUe85sR83hfk5p2NZ0IVXwXe", "Hello world!" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuyeG8laUfZvsCmc.AE6qIDYSPGM2efmK", "Hello world!" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.cTKgEgC.g8ePpbyZbNC34HvEm4dr75a", "pleaseletmein" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu2EjsH9/6E2HK9wvYowfGqPX5wGi4UDS", "pleaseletmein" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.3WPQy/x8EhyouO1Eia.f.CS216k/lTq", "pleaseletmein" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuumH1BFkDxi3LKCbP6FQ2juPgiLLcuV6S", "pleaseletmein" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.UTQ/YCMF16uRDggIHAnzfTGA1GG/5.K", "a short string" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuZM773JiyU8IodKIqJ54EAWHzd/nJoF6", "a short string" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.nks3nTLHIdR6yOhEvQZRsOoYVEqWOtW", "a short string" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu.oBhtv6clsTihZTgUKW34dikJs1Zg1y", "a short string" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.gBXVnji0fmYJspngWLhq07sJA.unyGS", "zxyDPWgydbQjgq" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuGbGKxJ6BsCRT7AGpwiKNOKUzJzb5AA.", "zxyDPWgydbQjgq" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.6vf3XUm.amMyfSlIH2P/SIU5V6p644a", "zxyDPWgydbQjgq" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuukgPMil1AyxXOwqj9OWvu3muVwEMg1Aq", "zxyDPWgydbQjgq" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.8TeQYvjyS9VKUlqSLz.kDaRa5v396hC", "photojournalism" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuhJe3S.rJQghSggwRY8.DQE1zCW18PcG", "photojournalism" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.1h1LaJMlvaH2Defb280WzG6X/kqHQQy", "photojournalism" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuugpKNM0gEaEfwZ43UsjoT1tNLK25mqV6", "photojournalism" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC./fog6ND8iIMkWXIpr.Y6LCOndkFsu/m", "ecclesiastically" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuDUj/hoyzOfsxHnlzXPdMGJybsJgbODG", "ecclesiastically" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.AYMycNr126P8pzb9X2aVQjINCiZadp2", "ecclesiastically" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuOt9ERn2.X0reuqDc7blRS.5f8ttIq3a", "ecclesiastically" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.dsZw45vJh0v/SWcvr.H79lmJF/uZKAy", "congregationalism" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuZu0OqjIDqSsvpAvbAqbC.8HRlYYcVkW", "congregationalism" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.1CYpRB/IxktadiLrbTzgJ.Jd/Q06oBe", "congregationalism" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuulau/kOpHdl7CjZgjQuvsiDAB2f/8Aqa", "congregationalism" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.aHkGX/fiki8Qrwu3gWTRnejC9Hba52e", "dihydrosphingosine" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuEJAH.2Z6lOSn5WvfN87I7V1JhCPsW5y", "dihydrosphingosine" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.8obhdpTZ2CAxc8Qbd8dIApwIFM6pzZe", "dihydrosphingosine" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu3tvUtVPx0FPXPsdjb7uta674As4iQfq", "dihydrosphingosine" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.sYSxc3RiA3.WrH2ic000nunk3yqkXHa", "semianthropological" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuLa.VWC3vq9KMn0BrxUY.r4HUotKepnO", "semianthropological" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.tLQTlKtJqj8kJFe92LPFDJdoiTxQ9PO", "semianthropological" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu6yC/otJXGOxvYDo3uRwUKNucauhdOPO", "semianthropological" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.Kvy1q1BWf93W1T7eSLpj/6OuRO.4FqC", "palaeogeographically" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuYNeqeSEZQQFODdHVEfj5MJFvrZPOeF6", "palaeogeographically" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.ybSWdRvitEQlA9I.Oq9wpqMqvBcJiti", "palaeogeographically" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu1POIcCAIthmV0dvj5BClL3hMpuuUctO", "palaeogeographically" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.g7bhq.l6.ix6BSpqhW6wIRoq310s.qO", "electromyographically" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuFj/NgndkQJ9QWdR8vDPZF92Ql/3UYFy", "electromyographically" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.rnGfJV5/J4BjTZj66R1dckO0Gy88d5e", "electromyographically" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuui7gF3bPS07zaLzWARBCVakWoF70OE8K", "electromyographically" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.fr2hBCxymAKP.MXKdQbm7/rIBEBis9y", "noninterchangeableness" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuueL38vMSpfDTZP0TBBAuZDp0A/4eFDFa", "noninterchangeableness" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.z1xt/vCOI.kmvN8L8t9GsafzGsOXupS", "noninterchangeableness" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuR1nrUOQ7HQO0AfPt3niv6JJN90IEgi2", "noninterchangeableness" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.UwjPIUFoFVfh.JD5Z/iVMDQ/.s2BdmK", "abcdefghijklmnopqrstuvwxyz" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuq9gWjWvJAAO9dtIxbLejROlOtpZkAZ2", "abcdefghijklmnopqrstuvwxyz" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.2qEx6VDzW/1gZVPz1yxtxnopI9gvYHG", "abcdefghijklmnopqrstuvwxyz" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuucUHlaG.p8AVcD5w/eidx9TAkwV4EXAW", "abcdefghijklmnopqrstuvwxyz" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.BdcD8qjQ3jCap/PcGpUCiau8u4PMcSy", "electroencephalographically" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuXDAnjJaWDI/Zcl0Om1uOs90q4mqBRWy", "electroencephalographically" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.n1A7hL3v/hM0RBTwKl/MB.eEE0e4av2", "electroencephalographically" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuvcwFX7UZ8m2DKl4e6qPHdONvRVRgApi", "electroencephalographically" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.9WsvENLhmOLqpxNHHDPzl0/i3I0QLXy", "antidisestablishmentarianism" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuNq0IwONJZaZ7QfLbcoA7E.G9LXdQ.8.", "antidisestablishmentarianism" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.WM1vtlGv4CR1StKJWw9/1zvZjhQpVm2", "antidisestablishmentarianism" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu.Nk99xH6C1i1s687VYJkw/9TgJZwvkW", "antidisestablishmentarianism" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.9vgB/QG0/5yJ0/eI2lb6I1NvMoYZHEi", "cyclotrimethylenetrinitramine" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuwOuvuEB8yOWqrtta0jWB10wzwfcx.sG", "cyclotrimethylenetrinitramine" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.mumkbiG5cCSVfxbwD8LbcQV6CFQ3MXq", "cyclotrimethylenetrinitramine" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuukUEvmtjkKEjAeshmrzk18VIJ5pOYI9G", "cyclotrimethylenetrinitramine" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.ld/W//3S8PyfCs05HnX4ctiJEWzxvtu", "dichlorodiphenyltrichloroethane" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuJaeloUBsLGuKojqNVj.JssS.S.5SOoG", "dichlorodiphenyltrichloroethane" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.IJ0s8nV/cDKYfTVFgirVaOoRoZvbMAW", "dichlorodiphenyltrichloroethane" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuQBL3QBmqpQVj0lKsVoN/yVsN7LDfMom", "dichlorodiphenyltrichloroethane" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.qgmN7ezpNt2mv7RXpV9nwxAwSRHe8Z6", "multiple words seperated by spaces" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuUyj6XHAnIT7HIUaHPt/mAqWbLOZ95oW", "multiple words seperated by spaces" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.ya4OMfax14JgLKjCeRnok41QNmDHk.6", "multiple words seperated by spaces" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuurps.S9nvQl/40RApzaFs9lIt3AMcneK", "multiple words seperated by spaces" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.2CHByRiD9EoV4pN2mhPq49ZZhIg5K/.", "supercalifragilisticexpialidocious" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuchc4Fu0voJQx93SMHFKQgbDXESzxUai", "supercalifragilisticexpialidocious" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.mqD8IRcEmTxZ.ChOQZyLHygiTWmqvk2", "supercalifragilisticexpialidocious" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuG9j0r2T6lEIX9LVt3txW9dZuFY0Ew1q", "supercalifragilisticexpialidocious" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.pr..QUPolGyX.oqq.qgP8kNIbwX1YlC", "we have a short salt string but not a short password" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuwLVtPJcEI87Gw5SVMgJ3jR.jz4FXA3C", "we have a short salt string but not a short password" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.S693iU5aWL1P1CiTvv4sKd4VtqEefpm", "we have a short salt string but not a short password" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuus8h4uV7ZQW6KJvz2prsjqaySAO/1k2e", "we have a short salt string but not a short password" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.VkOUUuotOZvrmtXJpkTGsRR7av5It52", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuT837gAqiU/1zYnau8zpkZMploUCluwS", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.iNDvHP9V2K7P.xzMWcBO.ucnS87zUrq", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu5RYaD3UZMA62Bfinm5QndpfWzruwF.O", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.8b67df7RZ0XnI62umy35MYpe4K51Fk2", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuW5igozlL8rSr/rkFexuDh1grrkW8FSi", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.F3K5wiwHej.p9lTXgX9bOlrEyWKv066", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuViu5c2UpaacAGAhQuLE2zyrV3jz4b5e", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.Td/f8oS7ISMxGfHYB8YP9rXGhoZDosO", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuxuElans2nYY6zVSN13XYHtA0oeOXZLa", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.kLVEehyg8LFsXfIVuFyGfLj4dvN7a4e", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuMNSliUjQvcDZoWAZHm/hAG9Z3ZRf5wy", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.4aisLqC2w3pT8aeXd3SHZFJkWSCkf0a", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuoBz.G9gMNiZlW/Gsj.oKhiomPeIRFTC", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.9c/KG5wY7kGTdky/Js0KWIpuVuJFUJG", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuinRgQYMZk.yuMIssG.kPPL6i9WP0xFa", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.heAts1y/8kcTTP0/vD3yeuMX1ihF8dO", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuTp1b9XCEV16BcrQ.0k4xf7V/OGPZLnK", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.A96emG/jBf0K1K6vCG.eZGdLkSridom", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuoaE0x.b2rUEITWgPdg.GEcU4ePHLh6m", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.qJn4AY9ch/WAR5JXeeJtVGeovjQrhd2", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuiYbzuFNFwSfCgqTGNsUFtSDh8PJAqSe", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.h0JFRyDXfP0duxAkVxWGr8nMDEDvPca", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuw8RVl3rh7sNazq544l0944qGq4GUFUq", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.FZEYKXyyMgG13MK0uV8dwNotWf4Wm6e", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuK2KXzhsMefB8v6hJJG3bOyKV.XRf6Qe", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.I7vjUzDOKf8XqcK8VSCm9b0bwoSm1Qm", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuhWYb0x3Q3zM0aBkB2G1arbzmWxRQS/i", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.HD8RnTmGEavoR3LFVfdHvh3xA0QPka2", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuSRMKxjeMqVSDMhSLhOnvtEZ/p5KhUbq", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.zQPVIDk6wF8XmESji30KDHFabTlu0WK", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuk9Hv17Gha84losGKAq61csCZokj5pyy", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.PYLCOpTKZmhFn1CoBM2XNbWgqMX4Jk2", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuUTFLPGm29p.YVzcY6pqejGEql1x8Ccq", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.PQInhDOdCKnXeUE.n/L.kQmTKM9ldK2", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuugI4g/1M6K/Sz2bsgu9VDeEl6reszuXa", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.uIZ1Lgb.jHRDU/Z/LVXfpQCK72fTEHq", "\xc3\xa9tude" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuYdPam5/ypFIyDUQMyCCEIwzVsTi0Sa6", "\xc3\xa9tude" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.TszY8.avBpwJ6xbNjwws3SKBbK6kj6S", "\xc3\xa9tude" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu3wn02pxRJPnFwvlGt75DURDbt4g7om.", "\xc3\xa9tude" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.qcYQ0c2j2SvETms11hszz5bnbvNhN0G", "C)tude" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuo170FGVreUKlJWzQl8GcfhpghDIp2c.", "C)tude" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.2iSSZ5gtiVxKz8BdAoDV9IxZl3LAH7y", "C)tude" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuutA7.Ir5GREoOf.twyI.Zoy.dI1gNHfC", "C)tude" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.tLCLEXAt3RUjOgs.yvfWSni4j1JX/JS", "Chl\xc3\xb6""e" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuz4QFggBRTVUeHRGL/CQxlAYHraYPcpa", "Chl\xc3\xb6""e" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.KHsCqMFVxOAGJObHwEBR3JaEdKVu1.m", "Chl\xc3\xb6""e" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuG6PeIXKiqeNUPUbqFkMJvvI7G9hd51W", "Chl\xc3\xb6""e" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.w.V.mBIadppiKKxZ0OzpXn86NOk43pC", "ChlC6e" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuQ2qgoto47/GjSmc6truiPxHNSL1jAfS", "ChlC6e" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.r7GLvyVWQLuQaOTYsrMOBkbLfy8sPIi", "ChlC6e" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuueolw0UBEFN.qCtReAkwiO7BAjrY4CX6", "ChlC6e" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.UPBzTBMwJb5mKWflQ.5Rid4481RrxVy", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuCARhc7ugFdgoPjDb7LUG.yQF2lboK6e", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.ZHZAnvydiPNiYH2VjRNhEAD6BEiyaWS", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu2WegkGS5Xr/qYNkfEi6JmnR16WVSwcW", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.gx7D73FxK1lx9aoctuj3fhNJqC.IYc6", "C\x05ngstrC6m" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuusSqmEHNEXYcUAamAuvd.piiJP2/SvW6", "C\x05ngstrC6m" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.pjA09E/vp0VG8cavv0kgRuMJNPJRdqS", "C\x05ngstrC6m" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuEFW231TUkQA55cajdiwh2GQXkKY7v4.", "C\x05ngstrC6m" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.OVB6qjs7Uzos9N7/Rpm1laBHwGw11u.", "C\x05ngstrCU*U***U*" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuAEHJsqoIo5645CuTbmM6VobcvFM6pxK", "C\x05ngstrCU*U***U*" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.E/ZiYei4bcJNCJEyI148Q1.aMAOn66e", "C\x05ngstrCU*U***U*" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuumAqJP8MYx4tSoKoE9d0vR0QW81bYuSC", "C\x05ngstrCU*U***U*" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.84ASbYYPYkl18.t0.TvQbm0oh98TFvG", "U*U***U*ignored" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuR.W0Ohu3KxpPUfr5Knw07yOOzZkdd7.", "U*U***U*ignored" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.wx4V3qBoGl7ej9kbsoEpQTxmptzY0yq", "U*U***U*ignored" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu4SS72T2y2mc0YsQSe9qECdkPhGVslHS", "U*U***U*ignored" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.ebmmSqlfcFhKGN/743nH7i03zpqftle", "U*U*U*U*" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuF1QNFce4DfYnYJUcafR1v2/7XbWeLjK", "U*U*U*U*" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.5KIIW3tGg2xhhVu/AQXLZX9lSSeeehu", "U*U*U*U*" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuudBYNJEBvC10idL3LIvyzUGdaxqz0jJW", "U*U*U*U*" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.htnOkHgQ8LrcyWv4cQVE5Bt0DiVxJzG", "U*U*U*U*ignored" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu1JJvN7RoX92Zzq1yGezl/5/3vlXyrxi", "U*U*U*U*ignored" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.7YCBkroPI7yK9JGre8Hne5hdwmA6Z3S", "U*U*U*U*ignored" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuc1KKQsfk4nXu9CnvuF/SfMwrmif7tsC", "U*U*U*U*ignored" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.DzSBCMqe17IfGIqEfq.FrxykxqtrVi2", "*U*U*U*U" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuuzPVVNB/SAKLJbAoTgm3qolIt8JCyqG", "*U*U*U*U" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.1fL1/3fOtt1usdRoe0dWgjAUT/TMd76", "*U*U*U*U" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu39YJ8HbI96dgaVWEUkKUCgXR4676Qjq", "*U*U*U*U" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.yu/PNF5atjbvgp2r9GyRzSYOErUPNHq", "*U*U*U*U*" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuZu/4jl7FZnNPiPunsfxbXLTBcZ4XPMe", "*U*U*U*U*" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.YT6TwplC9qsDdIyZ4nZ.2STP1srJcv.", "*U*U*U*U*" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuQ6t3zlOYOUrJSlX7AdtXuuWd0hDhQiC", "*U*U*U*U*" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.7Cc1PePc3H0bDi8khYlhX6PVDNBB0QK", "*U*U*U*U*U*U*U*U" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuwd22F2Sxe6gq2OS.jcQfMBY2dJtwKyS", "*U*U*U*U*U*U*U*U" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.AYh0eQgGLbt9qiP1jMH9.zHrUuVNY5.", "*U*U*U*U*U*U*U*U" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuui4ZHqA63Ft09xDrL31aaZvJ3RjuITQq", "*U*U*U*U*U*U*U*U" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.jlPoM5ioW.OQLW.5JcdEmo4HtRjF876", "*U*U*U*U*U*U*U*U*" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuz3ESgmDkKJlK0Nuq2.ylqgmDHlpC38q", "*U*U*U*U*U*U*U*U*" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.scf6.mexwrzCAGi3ShQ8cYkynqeH0bK", "*U*U*U*U*U*U*U*U*" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuQLykgCNxKyLhRD0HXzLibuZLZfiGOEO", "*U*U*U*U*U*U*U*U*" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.BvtRGGx3p8o0C5C36uS442Qqnrwofrq", "\xa3" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuEuEnx.TyCLYgkTV/uhWL5xJTHV7ZMjG", "\xa3" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.nCdKcLO57oLlc6J6sNnGyfT9FrIawiW", "\xa3" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuurz1efvzeJjL4mQ813hrZNg3p1.ivOii", "\xa3" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.k786rdsOdUP4cRi.dLa3dsYueMj5UnS", "\xa3""a" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuLN/CEHXLfFeYdOOxbdxKu8ZqSIKgqAu", "\xa3""a" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.4QrucGf30zIbQA.sO0d1QrU63xBrEYq", "\xa3""a" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuugbhoNOH4mWxoEhRrQNdeI.rpk9XeuZS", "\xa3""a" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.1qOUgfpg30XDHLx/zrbWiMRcWyFhwye", "\xd1\x91" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuus6h1E6A2RzVn2KxXLQXsKosQeRo8bLa", "\xd1\x91" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.7UwHe/ywPmdp.nr.ZLQSxd8hqn7qURW", "\xd1\x91" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuSqNATdQiNEckAKLsqgsKbAM5.hZoMCq", "\xd1\x91" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.bJFOmj3TaByM10X0BF32w0Fv/xFNSvm", "\xa3""ab" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuojaU9K.vmSlY6BHpgIQ/WY9rEOCcJO2", "\xa3""ab" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.0EeTSP42yLfD7uTTcDffPd2CNLKHdoy", "\xa3""ab" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuikYh/9nIvugTp.kFPFeZDBu7eW6BLoa", "\xa3""ab" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.Qjdj3GXX7D0sFE9jji6wxSTWIhqI3US", "\xff\xff\xa3" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuHdhhdUXVgLADnbTYf12kvsasO1gS51C", "\xff\xff\xa3" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.PIeeyENZVZmrKLAq5lwBUU9fMRVfV2m", "\xff\xff\xa3" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuMOaOTHB4gEm.rriBjXNwBNh.Oc4mKGG", "\xff\xff\xa3" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.RbKkfW2ph8bd8B5yul5E97DxgDw9cT.", "1\xa3""345" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuurPSVExmrZ2WB1xntSbqZ/DRQRlKtVw.", "1\xa3""345" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.XEhidoDX1kz.RFnwWIzMJvtW2aP/k4e", "1\xa3""345" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuXl2V4mQ7s0zX0b4XXH/b9UkRRCWpq3e", "1\xa3""345" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.WI7ZNXFtzCd9mN1mWoNMQRHEmkDsZnm", "\xff\xa3""345" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu6WgD2zYQDPgxR2sXlUeEeGKknxt95W.", "\xff\xa3""345" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.KBv1eBM2he2T/QheS8zPHMejn5fMNRe", "\xff\xa3""345" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuUIzecIiCguM2sPh1F7L9IS3zOtmg5Im", "\xff\xa3""345" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.VmFQpoXeVuKTzkg2ZRsAf.8PZJZg142", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuucaGU5ROXj4M8Tgsx3s/D5BQIuhazIWa", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.8jdeg8QqT4CX3ERA9vZPFZAkxZRpxJW", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu9f4sA9SRA0scUKcRyC5kce8dao2.GKe", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.xGPMyJSPyyeICKolPQ2gecm8rOgHwz.", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuuTNb9MEHVGI7kd6UnQjYxgRNiKJM01S", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.k.qekGiJym3QgfeFCwNhPHg0Zk99KSa", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuyM59Cq5iVZDB3u45gTNhRSnOgrY1tdG", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.VAQY6kySmwStlNY.sut9Y87njVr0mm.", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuPPtdI0NcxZ4Txyv/Y5ORfcP1XFriKT2", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.tHwehGUs3q0b/Ejn42MsoM4Yv/iA1rq", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuu3cFqlEl7Y0HWaVLHpyyCqG8dBNk1DSm", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.n2VnrmAaokJwiDSekcCjbZxRIyVngRy", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu5s2v8.iXieOjg/.AySBTTZIIVFJeBui", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.0ZsAfF0DsSCOCcfZKxtwXxkV4RFYBVG", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuRAip/W0RPQX4QKkqYqXE3GIXWH518Sm", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.n2VnrmAaokJwiDSekcCjbZxRIyVngRy", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu5s2v8.iXieOjg/.AySBTTZIIVFJeBui", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.0ZsAfF0DsSCOCcfZKxtwXxkV4RFYBVG", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuRAip/W0RPQX4QKkqYqXE3GIXWH518Sm", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.ZkQGqjbMpqQ9oCsxNZjN8LQJaHFqPMC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu51cV.PJOQVwmiao4t4lXsb9Cc3Jnuem", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.DQjlTXDA5PBQ97.qBJY/vsHPQhLJDMe", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuAqM0XavJxJXeVlJ3Te3umGJaPOCYmZi", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.ZkQGqjbMpqQ9oCsxNZjN8LQJaHFqPMC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu51cV.PJOQVwmiao4t4lXsb9Cc3Jnuem", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.DQjlTXDA5PBQ97.qBJY/vsHPQhLJDMe", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuAqM0XavJxJXeVlJ3Te3umGJaPOCYmZi", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.uB1no1bSvQlNFbG6DThB52xIhyG9z8G", "THE YEAR" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuuySE45JP/avbudkXbPzjvqTBKf61NNfi", "THE YEAR" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.c/NBil2GQ9h1axG3uDE7cen7O1yt4wu", "THE YEAR" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuT4fz1ym9dcyOwa1hMmFJSuk4yISb03.", "THE YEAR" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2y$05$CCCCCCCCCCCCCCCCCCCCC.", "$2y$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2y$05$abcdefghijklmnopqrstuu", "$2y$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2y$04$CCCCCCCCCCCCCCCCCCCCC.", "$2y$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2y$04$abcdefghijklmnopqrstuu", "$2y$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // bcrypt_y

#if INCLUDE_bcrypt_a && defined TEST_bcrypt_a
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.7uG0VCzI2bS7j6ymqJi9CdcdxiRTWNy", "" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu0oImNDIy4flhldV9YqunRgBAePKmw7m", "" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.Cg0ly9t/KVBCBYYDfOmZKwry9JuXClC", "" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuubyCG3zY1GIXMyxfivm.ClDiInHzxjiq", "" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.REUe.wVCLEE7cNcWpheIXR9MaRPCoVC", " " },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuueHjTs35M4oLkB0oz2vpFCrkqmB3wDyK", " " },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.QK3io8Pm4WhsBSZhzvm1OPPQ1MU.WxC", " " },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu/ied6LYDv4Nek.n8vXq7pbx7mJcRizO", " " },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.crbyEJ0XFaJ9sONRyOTHdI7c4ZT.ndu", "a" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu8.veTXNDPV2eEsdpKNczMw2otgh5LnK", "a" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.f/Fm9DOYGp2ai9rjxvG4QHlhtDCuDuu", "a" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuMFdJu9yVgmagVAIC24fOZkaFqd3s9JC", "a" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.w5.fxtwCNbJ3swM5YKT2SoO0YcCOkhS", "ab" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu0EJam7uq2UHswNA05epRm6fJdiFmbUi", "ab" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.ThcCpjPKXmu6XgQqJJEGokAiEUquQVe", "ab" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu0CkeIeZLJOlOL1QPPhfXulLNPdFqJBW", "ab" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.gNn9EDJdrUJF53AHnb.4T9BCvqhUYdW", "abc" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuRWUgMyyCUnsDr8evYotXg5ZXVF/HhzS", "abc" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.AKurti2nSiRoaXd0tyyeWA.1jj9Kto2", "abc" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuCi15uRb1eH7NAlJ/TgeJertyknQpYn2", "abc" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.E5YPO9kmyuRGyh0XouQYb4YMJKvyOeW", "U*U" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuMpLhh66NJUQMuZ6FwRQX0sqAEKeWcKW", "U*U" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.K7Qr0se1MxuggH4aP4YgB.U2Em1pGSK", "U*U" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuCFaEytnzrfaPZJKbS76hh9vqd9r8v2S", "U*U" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.VGOzA784oUp/Z0DY336zx7pLYAy0lwK", "U*U*" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuueqZzwRqX8BEsrV2jF8gx70v6bcd1qAG", "U*U*" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.5dvsdVl2y/501tm9dvdbbSRbpuvxsaC", "U*U*" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuBtzXFXMcxIslxJptQaoJYuU.xP21coS", "U*U*" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.Bw3BobdGs1SFsKsRLIx9rC4T.Q7DtEm", "U*U*U" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuupkvHj1c6E382bN8hwXRlu1xE4bc1pgG", "U*U*U" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.r2Gz4aKpQDpr6TmvEJksSv12hIDVgXe", "U*U*U" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuMJG4SPxGpsI2PpmiVYJg7D.hA7CdQyO", "U*U*U" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.6YtT5mHh5I666KkHRqqIuteDuaNX1GS", "....." },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuun3YeQp9ZOh1qWiEKJNRybZT69WMr2sW", "....." },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.6v/P2K1bqBzj9FILn7LJntMzJQxUuA6", "....." },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu7bnTzNnC9mpomsuya2sDYCcZGtW3FKu", "....." },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.LZrfN0lz4CULfFuRjqXiVMP49yNOHKi", "dragon" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuG4nizIsfFMB34Hh5MoYcbtdFUq5YPJK", "dragon" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.tidtIFf5ZCN.gk6Mobs.YyDMzNhFfFm", "dragon" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuujzhP54E3nDKxLTbGbyrFiW3EkV.7ERC", "dragon" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.i7hPnfU5WycMwd1C9qJZDFBCw8NcAFu", "dRaGoN" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuMA7xTS.7H8Lal4RW.s8KBMURGOrPxQa", "dRaGoN" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.5TqUWVAHsz4mvbAcNwu3JSwt7Pd.dm2", "dRaGoN" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuqS/OX35wGo1BfqluN8dsq//CyXY2pNS", "dRaGoN" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.ZGVtQn6eTc3aPe.tQ.zJuH3XlzyI9Di", "DrAgOn" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuO5PYTf2OGllbJ1tyzjIAdpnQ9rUDGNC", "DrAgOn" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.SzmeTH6T6GIGbKj9Om75UAlglaj4twK", "DrAgOn" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuE9zYHFcawnjSDJKsSux5hf1fyy3utXW", "DrAgOn" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.u/WsPSagrbjc3QmFLSt6j9e/LJ8FoNm", "PAROLX" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuzyv2QWIljnSNjMYpSebmlCqn.QEGEB6", "PAROLX" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.pQY3jmCmc/1Pk8B2m6DNUj9ANrzICLK", "PAROLX" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuumicc49hlc3UdUYSMeE8ZXKFJcV/Q2Nm", "PAROLX" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.7Knr9/jUQJ0lh8N4AU/fMnQskXCdfSu", "U*U***U" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu0whe22G2FGJcNLWQaY2ZVuZIf5IJBHK", "U*U***U" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.H3n2rsAGLquD5DBiTNaKBEYcc0HJy5K", "U*U***U" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuDu3PK53XxhceAEiIIFWWlG16bn5LvcG", "U*U***U" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.HjTkKOvb2xTYRqeMFaN1PRcxuDYro5y", "abcdefg" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu3NLAiMrV.ggY98aZ7cNIwxII7afa91.", "abcdefg" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.GQNqYPSPnkqs4XPHOKxta8z3oVxx.Oe", "abcdefg" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuGTNT0Ri8Ic/nBhrRQu0ORxwctqE11mO", "abcdefg" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.RFkLTR7KyUmGXnFvMFlLbB23MCIzsgi", "01234567" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuQOF57SPhYRiKufm4.epZm3ELZ4UlAVy", "01234567" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.3uce2XN8xqrZ2aIduEu48JNEUk6ih9y", "01234567" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuucnCKiuhmJV3sCjWqQH.rYNPhmru2Bfq", "01234567" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.hz7CVP6wIj8Z57Ze7yuhrhzKfvq0Ty.", "726 even" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuIaVbx2I8MHKuu1rBc/gqV8Fo2An7wQm", "726 even" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.ib/v2w9PynSZewkHDlSuFwGC.jkyh4a", "726 even" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuus/VSIfP19Ty4eQaE51vB9GbPNmLhq2S", "726 even" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.jUMW9ITlTfAw5cFja1iYihO7V9qsmWK", "zyxwvuts" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuucN2On7GNyUtMxT..Bo0a0ICaTeQOJ4u", "zyxwvuts" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.xf6Tlh/zfR9Qob4S/6wj9RneRcBt4yG", "zyxwvuts" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuucqOWKor12VNz5REoX.a3GqgU2btIQWS", "zyxwvuts" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.hdihJRIixUmRFFg0NQNaid9UF3Uw/Q.", "ab1234567" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuulK6ChIvFKqdreUvOY9oKm2O2Fn.1Zuq", "ab1234567" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.xq4CFi9Keo/OhWm9tosH45r9gI3Gd4C", "ab1234567" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuuBq8XeHGZZJdrs6jsgiLupxqOP4GLc6", "ab1234567" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.0c9Eoia74tfCGVyINCZAcZaVzJdMsoi", "alexander" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu3qH73fcOvo6pdGd/u/Of.mkavvVviAG", "alexander" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.bK5f5L/foC9KH3IYxj9uWGZPE/w22J2", "alexander" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu1zazepZSS74T7o4eCXaJqsa4KC41vt6", "alexander" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.Tc9f8dMIa03zsepKEv1oSFsFWT84Me.", "beautiful" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuusxVo.QMslOcijv585zolzUwesRGYfui", "beautiful" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.7XxYg42754jz07Elen5lFQuommU7crW", "beautiful" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuHz11b40qtSU5.OKZJGONgmO6tsOw8ny", "beautiful" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.SxOcYMxtg44jVOAYY0zBeTBbfCYXSBu", "challenge" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuD2bZx1XnT2xoC7mKx.Jr7E20hJXg5y.", "challenge" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.mK3Hkg2ZFCrNFQRor1M7Bd.pyBSFz56", "challenge" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu92OCZ/GwgJ2w0KrMJRu6fK7i2iKqYha", "challenge" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.455yryJspofWOsWxxZ/Tsu5qtg8j2wm", "chocolate" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuulZGdWs.WkvfSGHTz.1.5CPi2ETJLi3.", "chocolate" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.N0Iumk1Mt6l7kbmk8iYgSA9FqaEfv5y", "chocolate" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuLbL252qaabO.sIFmAzyShKINVGRsGeu", "chocolate" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.ZA//OMzj1MY4PfGODYfbeGs8HPUS2zq", "cr1234567" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuUccVOwN/r/34c2SICyLEwyfRWS4Vgja", "cr1234567" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.8tZkJ2HTsa4Pn6bgGzpDRWJ8c1biGYu", "cr1234567" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuA.Ry5GZ8Ob/wI0r8UydZ6XfbyfLJ5JK", "cr1234567" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.XyLDmzSo8jvTANPtIoCB164F84v8EkS", "katherine" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuOYRnTkqPmRfoAB/blXEA7y5xOBtiEg6", "katherine" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.bsdSaZOaobkZJkNO2MxskcWIZCJ8btK", "katherine" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu5i6Sk8a0h8mpYFdjQZdYrEsLaxZ1EaG", "katherine" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC./cK5Kv8QvFDy9GyVbaJS/eEKlmhA6wW", "stephanie" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuucK0uB5JOSYLNCq75/1vd9213cIwiEQi", "stephanie" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.Yr8Btf/4dkO36VgY1VYAp6Q9B4.B/rm", "stephanie" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuug3T9Nmp5d1Zd35nXtrYPiCSv8A6PVAu", "stephanie" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.VYs2hleVmLTA.FbmrBwOI38C4Pd/8BS", "sunflower" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuY/44p2UkK4uV0kvS9KurVonsOh/oc5m", "sunflower" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.VuKIcBGfiLx.AYuX6c48oQtlhMCQPRq", "sunflower" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuul18yFhC69sq/WwO8ibiE1VQy773yVfu", "sunflower" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.465.cDVHqgo4g9qBZIbQbOcdcGqRs2O", "basketball" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuFT2m2RbIlbhkAJBfZ3FCN3Sn3V.N4Bm", "basketball" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.R293rqybpDGrtZIhZxApKqVLXiOJUTG", "basketball" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuudp7.T6JYoR2jjqAKGX8kDLzPDm6RR3S", "basketball" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.XUKWvx5JT0wYalbOFE4HU.j3lDUpDcm", "porsche911" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuupKJ./ES4uwzJk/SsN3YaTFdl9AIiAdu", "porsche911" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.jgOl9b/oD1cEHohzVyGK6zqcGccVRBG", "porsche911" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuVXo2ooNppOi53FnAHCUuZp8EyiwUoCi", "porsche911" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.sXCEcM/a6jUtNpF7EFCOWiQRogVPxNW", "|_337T`/p3" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuugZjL4p/g0M.xDKdvzvO1BKtO0aYdnwC", "|_337T`/p3" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.UyHWsohI3G2oJ05vftc06k9UIwXNW4a", "|_337T`/p3" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuh7AZQzpU7Q7C5l4VczvD6UVfhLQVCDK", "|_337T`/p3" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.ScdVt/vv5qxU5Weko6ZqQcaHw2EjuRG", "thunderbird" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuhX1c3kKr2qeB4tFvvRmDk/ta3LTQtma", "thunderbird" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.XXuNspXmlmLMqkZ37Xt0om56PIqSupq", "thunderbird" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuSJB.YmarGme5IjgFBN49eRn74KS.zVC", "thunderbird" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.z6PrHbuSsMSSwIGFy1JGevQZf6CqJ1y", "Hello world!" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu7nFISH/8YdwlXD3lw69A4iBUf6fvWAW", "Hello world!" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.M.JZM2tZUe85sR83hfk5p2NZ0IVXwXe", "Hello world!" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuyeG8laUfZvsCmc.AE6qIDYSPGM2efmK", "Hello world!" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.cTKgEgC.g8ePpbyZbNC34HvEm4dr75a", "pleaseletmein" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu2EjsH9/6E2HK9wvYowfGqPX5wGi4UDS", "pleaseletmein" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.3WPQy/x8EhyouO1Eia.f.CS216k/lTq", "pleaseletmein" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuumH1BFkDxi3LKCbP6FQ2juPgiLLcuV6S", "pleaseletmein" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.UTQ/YCMF16uRDggIHAnzfTGA1GG/5.K", "a short string" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuZM773JiyU8IodKIqJ54EAWHzd/nJoF6", "a short string" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.nks3nTLHIdR6yOhEvQZRsOoYVEqWOtW", "a short string" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu.oBhtv6clsTihZTgUKW34dikJs1Zg1y", "a short string" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.gBXVnji0fmYJspngWLhq07sJA.unyGS", "zxyDPWgydbQjgq" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuGbGKxJ6BsCRT7AGpwiKNOKUzJzb5AA.", "zxyDPWgydbQjgq" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.6vf3XUm.amMyfSlIH2P/SIU5V6p644a", "zxyDPWgydbQjgq" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuukgPMil1AyxXOwqj9OWvu3muVwEMg1Aq", "zxyDPWgydbQjgq" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.8TeQYvjyS9VKUlqSLz.kDaRa5v396hC", "photojournalism" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuhJe3S.rJQghSggwRY8.DQE1zCW18PcG", "photojournalism" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.1h1LaJMlvaH2Defb280WzG6X/kqHQQy", "photojournalism" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuugpKNM0gEaEfwZ43UsjoT1tNLK25mqV6", "photojournalism" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC./fog6ND8iIMkWXIpr.Y6LCOndkFsu/m", "ecclesiastically" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuDUj/hoyzOfsxHnlzXPdMGJybsJgbODG", "ecclesiastically" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.AYMycNr126P8pzb9X2aVQjINCiZadp2", "ecclesiastically" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuOt9ERn2.X0reuqDc7blRS.5f8ttIq3a", "ecclesiastically" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.dsZw45vJh0v/SWcvr.H79lmJF/uZKAy", "congregationalism" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuZu0OqjIDqSsvpAvbAqbC.8HRlYYcVkW", "congregationalism" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.1CYpRB/IxktadiLrbTzgJ.Jd/Q06oBe", "congregationalism" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuulau/kOpHdl7CjZgjQuvsiDAB2f/8Aqa", "congregationalism" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.aHkGX/fiki8Qrwu3gWTRnejC9Hba52e", "dihydrosphingosine" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuEJAH.2Z6lOSn5WvfN87I7V1JhCPsW5y", "dihydrosphingosine" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.8obhdpTZ2CAxc8Qbd8dIApwIFM6pzZe", "dihydrosphingosine" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu3tvUtVPx0FPXPsdjb7uta674As4iQfq", "dihydrosphingosine" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.sYSxc3RiA3.WrH2ic000nunk3yqkXHa", "semianthropological" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuLa.VWC3vq9KMn0BrxUY.r4HUotKepnO", "semianthropological" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.tLQTlKtJqj8kJFe92LPFDJdoiTxQ9PO", "semianthropological" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu6yC/otJXGOxvYDo3uRwUKNucauhdOPO", "semianthropological" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.Kvy1q1BWf93W1T7eSLpj/6OuRO.4FqC", "palaeogeographically" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuYNeqeSEZQQFODdHVEfj5MJFvrZPOeF6", "palaeogeographically" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.ybSWdRvitEQlA9I.Oq9wpqMqvBcJiti", "palaeogeographically" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu1POIcCAIthmV0dvj5BClL3hMpuuUctO", "palaeogeographically" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.g7bhq.l6.ix6BSpqhW6wIRoq310s.qO", "electromyographically" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuFj/NgndkQJ9QWdR8vDPZF92Ql/3UYFy", "electromyographically" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.rnGfJV5/J4BjTZj66R1dckO0Gy88d5e", "electromyographically" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuui7gF3bPS07zaLzWARBCVakWoF70OE8K", "electromyographically" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.fr2hBCxymAKP.MXKdQbm7/rIBEBis9y", "noninterchangeableness" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuueL38vMSpfDTZP0TBBAuZDp0A/4eFDFa", "noninterchangeableness" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.z1xt/vCOI.kmvN8L8t9GsafzGsOXupS", "noninterchangeableness" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuR1nrUOQ7HQO0AfPt3niv6JJN90IEgi2", "noninterchangeableness" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.UwjPIUFoFVfh.JD5Z/iVMDQ/.s2BdmK", "abcdefghijklmnopqrstuvwxyz" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuq9gWjWvJAAO9dtIxbLejROlOtpZkAZ2", "abcdefghijklmnopqrstuvwxyz" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.2qEx6VDzW/1gZVPz1yxtxnopI9gvYHG", "abcdefghijklmnopqrstuvwxyz" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuucUHlaG.p8AVcD5w/eidx9TAkwV4EXAW", "abcdefghijklmnopqrstuvwxyz" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.BdcD8qjQ3jCap/PcGpUCiau8u4PMcSy", "electroencephalographically" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuXDAnjJaWDI/Zcl0Om1uOs90q4mqBRWy", "electroencephalographically" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.n1A7hL3v/hM0RBTwKl/MB.eEE0e4av2", "electroencephalographically" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuvcwFX7UZ8m2DKl4e6qPHdONvRVRgApi", "electroencephalographically" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.9WsvENLhmOLqpxNHHDPzl0/i3I0QLXy", "antidisestablishmentarianism" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuNq0IwONJZaZ7QfLbcoA7E.G9LXdQ.8.", "antidisestablishmentarianism" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.WM1vtlGv4CR1StKJWw9/1zvZjhQpVm2", "antidisestablishmentarianism" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu.Nk99xH6C1i1s687VYJkw/9TgJZwvkW", "antidisestablishmentarianism" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.9vgB/QG0/5yJ0/eI2lb6I1NvMoYZHEi", "cyclotrimethylenetrinitramine" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuwOuvuEB8yOWqrtta0jWB10wzwfcx.sG", "cyclotrimethylenetrinitramine" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.mumkbiG5cCSVfxbwD8LbcQV6CFQ3MXq", "cyclotrimethylenetrinitramine" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuukUEvmtjkKEjAeshmrzk18VIJ5pOYI9G", "cyclotrimethylenetrinitramine" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.ld/W//3S8PyfCs05HnX4ctiJEWzxvtu", "dichlorodiphenyltrichloroethane" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuJaeloUBsLGuKojqNVj.JssS.S.5SOoG", "dichlorodiphenyltrichloroethane" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.IJ0s8nV/cDKYfTVFgirVaOoRoZvbMAW", "dichlorodiphenyltrichloroethane" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuQBL3QBmqpQVj0lKsVoN/yVsN7LDfMom", "dichlorodiphenyltrichloroethane" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.qgmN7ezpNt2mv7RXpV9nwxAwSRHe8Z6", "multiple words seperated by spaces" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuUyj6XHAnIT7HIUaHPt/mAqWbLOZ95oW", "multiple words seperated by spaces" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.ya4OMfax14JgLKjCeRnok41QNmDHk.6", "multiple words seperated by spaces" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuurps.S9nvQl/40RApzaFs9lIt3AMcneK", "multiple words seperated by spaces" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.2CHByRiD9EoV4pN2mhPq49ZZhIg5K/.", "supercalifragilisticexpialidocious" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuchc4Fu0voJQx93SMHFKQgbDXESzxUai", "supercalifragilisticexpialidocious" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.mqD8IRcEmTxZ.ChOQZyLHygiTWmqvk2", "supercalifragilisticexpialidocious" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuG9j0r2T6lEIX9LVt3txW9dZuFY0Ew1q", "supercalifragilisticexpialidocious" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.pr..QUPolGyX.oqq.qgP8kNIbwX1YlC", "we have a short salt string but not a short password" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuwLVtPJcEI87Gw5SVMgJ3jR.jz4FXA3C", "we have a short salt string but not a short password" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.S693iU5aWL1P1CiTvv4sKd4VtqEefpm", "we have a short salt string but not a short password" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuus8h4uV7ZQW6KJvz2prsjqaySAO/1k2e", "we have a short salt string but not a short password" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.VkOUUuotOZvrmtXJpkTGsRR7av5It52", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuT837gAqiU/1zYnau8zpkZMploUCluwS", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.iNDvHP9V2K7P.xzMWcBO.ucnS87zUrq", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu5RYaD3UZMA62Bfinm5QndpfWzruwF.O", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.8b67df7RZ0XnI62umy35MYpe4K51Fk2", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuW5igozlL8rSr/rkFexuDh1grrkW8FSi", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.F3K5wiwHej.p9lTXgX9bOlrEyWKv066", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuViu5c2UpaacAGAhQuLE2zyrV3jz4b5e", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.Td/f8oS7ISMxGfHYB8YP9rXGhoZDosO", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuxuElans2nYY6zVSN13XYHtA0oeOXZLa", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.kLVEehyg8LFsXfIVuFyGfLj4dvN7a4e", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuMNSliUjQvcDZoWAZHm/hAG9Z3ZRf5wy", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.4aisLqC2w3pT8aeXd3SHZFJkWSCkf0a", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuoBz.G9gMNiZlW/Gsj.oKhiomPeIRFTC", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.9c/KG5wY7kGTdky/Js0KWIpuVuJFUJG", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuinRgQYMZk.yuMIssG.kPPL6i9WP0xFa", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.heAts1y/8kcTTP0/vD3yeuMX1ihF8dO", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuTp1b9XCEV16BcrQ.0k4xf7V/OGPZLnK", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.A96emG/jBf0K1K6vCG.eZGdLkSridom", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuoaE0x.b2rUEITWgPdg.GEcU4ePHLh6m", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.qJn4AY9ch/WAR5JXeeJtVGeovjQrhd2", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuiYbzuFNFwSfCgqTGNsUFtSDh8PJAqSe", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.h0JFRyDXfP0duxAkVxWGr8nMDEDvPca", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuw8RVl3rh7sNazq544l0944qGq4GUFUq", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.FZEYKXyyMgG13MK0uV8dwNotWf4Wm6e", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuK2KXzhsMefB8v6hJJG3bOyKV.XRf6Qe", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.I7vjUzDOKf8XqcK8VSCm9b0bwoSm1Qm", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuhWYb0x3Q3zM0aBkB2G1arbzmWxRQS/i", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.HD8RnTmGEavoR3LFVfdHvh3xA0QPka2", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuSRMKxjeMqVSDMhSLhOnvtEZ/p5KhUbq", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.zQPVIDk6wF8XmESji30KDHFabTlu0WK", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuk9Hv17Gha84losGKAq61csCZokj5pyy", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.PYLCOpTKZmhFn1CoBM2XNbWgqMX4Jk2", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuUTFLPGm29p.YVzcY6pqejGEql1x8Ccq", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.PQInhDOdCKnXeUE.n/L.kQmTKM9ldK2", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuugI4g/1M6K/Sz2bsgu9VDeEl6reszuXa", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.uIZ1Lgb.jHRDU/Z/LVXfpQCK72fTEHq", "\xc3\xa9tude" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuYdPam5/ypFIyDUQMyCCEIwzVsTi0Sa6", "\xc3\xa9tude" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.TszY8.avBpwJ6xbNjwws3SKBbK6kj6S", "\xc3\xa9tude" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu3wn02pxRJPnFwvlGt75DURDbt4g7om.", "\xc3\xa9tude" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.qcYQ0c2j2SvETms11hszz5bnbvNhN0G", "C)tude" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuo170FGVreUKlJWzQl8GcfhpghDIp2c.", "C)tude" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.2iSSZ5gtiVxKz8BdAoDV9IxZl3LAH7y", "C)tude" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuutA7.Ir5GREoOf.twyI.Zoy.dI1gNHfC", "C)tude" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.tLCLEXAt3RUjOgs.yvfWSni4j1JX/JS", "Chl\xc3\xb6""e" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuz4QFggBRTVUeHRGL/CQxlAYHraYPcpa", "Chl\xc3\xb6""e" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.KHsCqMFVxOAGJObHwEBR3JaEdKVu1.m", "Chl\xc3\xb6""e" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuG6PeIXKiqeNUPUbqFkMJvvI7G9hd51W", "Chl\xc3\xb6""e" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.w.V.mBIadppiKKxZ0OzpXn86NOk43pC", "ChlC6e" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuQ2qgoto47/GjSmc6truiPxHNSL1jAfS", "ChlC6e" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.r7GLvyVWQLuQaOTYsrMOBkbLfy8sPIi", "ChlC6e" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuueolw0UBEFN.qCtReAkwiO7BAjrY4CX6", "ChlC6e" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.UPBzTBMwJb5mKWflQ.5Rid4481RrxVy", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuCARhc7ugFdgoPjDb7LUG.yQF2lboK6e", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.ZHZAnvydiPNiYH2VjRNhEAD6BEiyaWS", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu2WegkGS5Xr/qYNkfEi6JmnR16WVSwcW", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.gx7D73FxK1lx9aoctuj3fhNJqC.IYc6", "C\x05ngstrC6m" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuusSqmEHNEXYcUAamAuvd.piiJP2/SvW6", "C\x05ngstrC6m" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.pjA09E/vp0VG8cavv0kgRuMJNPJRdqS", "C\x05ngstrC6m" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuEFW231TUkQA55cajdiwh2GQXkKY7v4.", "C\x05ngstrC6m" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.OVB6qjs7Uzos9N7/Rpm1laBHwGw11u.", "C\x05ngstrCU*U***U*" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuAEHJsqoIo5645CuTbmM6VobcvFM6pxK", "C\x05ngstrCU*U***U*" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.E/ZiYei4bcJNCJEyI148Q1.aMAOn66e", "C\x05ngstrCU*U***U*" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuumAqJP8MYx4tSoKoE9d0vR0QW81bYuSC", "C\x05ngstrCU*U***U*" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.84ASbYYPYkl18.t0.TvQbm0oh98TFvG", "U*U***U*ignored" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuR.W0Ohu3KxpPUfr5Knw07yOOzZkdd7.", "U*U***U*ignored" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.wx4V3qBoGl7ej9kbsoEpQTxmptzY0yq", "U*U***U*ignored" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu4SS72T2y2mc0YsQSe9qECdkPhGVslHS", "U*U***U*ignored" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.ebmmSqlfcFhKGN/743nH7i03zpqftle", "U*U*U*U*" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuF1QNFce4DfYnYJUcafR1v2/7XbWeLjK", "U*U*U*U*" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.5KIIW3tGg2xhhVu/AQXLZX9lSSeeehu", "U*U*U*U*" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuudBYNJEBvC10idL3LIvyzUGdaxqz0jJW", "U*U*U*U*" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.htnOkHgQ8LrcyWv4cQVE5Bt0DiVxJzG", "U*U*U*U*ignored" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu1JJvN7RoX92Zzq1yGezl/5/3vlXyrxi", "U*U*U*U*ignored" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.7YCBkroPI7yK9JGre8Hne5hdwmA6Z3S", "U*U*U*U*ignored" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuc1KKQsfk4nXu9CnvuF/SfMwrmif7tsC", "U*U*U*U*ignored" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.DzSBCMqe17IfGIqEfq.FrxykxqtrVi2", "*U*U*U*U" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuuzPVVNB/SAKLJbAoTgm3qolIt8JCyqG", "*U*U*U*U" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.1fL1/3fOtt1usdRoe0dWgjAUT/TMd76", "*U*U*U*U" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu39YJ8HbI96dgaVWEUkKUCgXR4676Qjq", "*U*U*U*U" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.yu/PNF5atjbvgp2r9GyRzSYOErUPNHq", "*U*U*U*U*" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuZu/4jl7FZnNPiPunsfxbXLTBcZ4XPMe", "*U*U*U*U*" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.YT6TwplC9qsDdIyZ4nZ.2STP1srJcv.", "*U*U*U*U*" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuQ6t3zlOYOUrJSlX7AdtXuuWd0hDhQiC", "*U*U*U*U*" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.7Cc1PePc3H0bDi8khYlhX6PVDNBB0QK", "*U*U*U*U*U*U*U*U" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuwd22F2Sxe6gq2OS.jcQfMBY2dJtwKyS", "*U*U*U*U*U*U*U*U" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.AYh0eQgGLbt9qiP1jMH9.zHrUuVNY5.", "*U*U*U*U*U*U*U*U" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuui4ZHqA63Ft09xDrL31aaZvJ3RjuITQq", "*U*U*U*U*U*U*U*U" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.jlPoM5ioW.OQLW.5JcdEmo4HtRjF876", "*U*U*U*U*U*U*U*U*" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuz3ESgmDkKJlK0Nuq2.ylqgmDHlpC38q", "*U*U*U*U*U*U*U*U*" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.scf6.mexwrzCAGi3ShQ8cYkynqeH0bK", "*U*U*U*U*U*U*U*U*" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuQLykgCNxKyLhRD0HXzLibuZLZfiGOEO", "*U*U*U*U*U*U*U*U*" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.BvtRGGx3p8o0C5C36uS442Qqnrwofrq", "\xa3" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuEuEnx.TyCLYgkTV/uhWL5xJTHV7ZMjG", "\xa3" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.nCdKcLO57oLlc6J6sNnGyfT9FrIawiW", "\xa3" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuurz1efvzeJjL4mQ813hrZNg3p1.ivOii", "\xa3" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.k786rdsOdUP4cRi.dLa3dsYueMj5UnS", "\xa3""a" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuLN/CEHXLfFeYdOOxbdxKu8ZqSIKgqAu", "\xa3""a" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.4QrucGf30zIbQA.sO0d1QrU63xBrEYq", "\xa3""a" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuugbhoNOH4mWxoEhRrQNdeI.rpk9XeuZS", "\xa3""a" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.1qOUgfpg30XDHLx/zrbWiMRcWyFhwye", "\xd1\x91" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuus6h1E6A2RzVn2KxXLQXsKosQeRo8bLa", "\xd1\x91" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.7UwHe/ywPmdp.nr.ZLQSxd8hqn7qURW", "\xd1\x91" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuSqNATdQiNEckAKLsqgsKbAM5.hZoMCq", "\xd1\x91" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.bJFOmj3TaByM10X0BF32w0Fv/xFNSvm", "\xa3""ab" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuojaU9K.vmSlY6BHpgIQ/WY9rEOCcJO2", "\xa3""ab" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.0EeTSP42yLfD7uTTcDffPd2CNLKHdoy", "\xa3""ab" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuikYh/9nIvugTp.kFPFeZDBu7eW6BLoa", "\xa3""ab" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.euRNRfAA6e0fjpTfQPPAMU1PCOf9IHq", "\xff\xff\xa3" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu5jlqAXzFdq.3//pJFBa432Pepsclbdu", "\xff\xff\xa3" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.h87NWu/js59XXaIj1hDyHxnjw7MJ5K6", "\xff\xff\xa3" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuZQhQBRpiYJCaQFgyHlB.t/F01cqLCIu", "\xff\xff\xa3" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.RbKkfW2ph8bd8B5yul5E97DxgDw9cT.", "1\xa3""345" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuurPSVExmrZ2WB1xntSbqZ/DRQRlKtVw.", "1\xa3""345" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.XEhidoDX1kz.RFnwWIzMJvtW2aP/k4e", "1\xa3""345" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuXl2V4mQ7s0zX0b4XXH/b9UkRRCWpq3e", "1\xa3""345" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.WI7ZNXFtzCd9mN1mWoNMQRHEmkDsZnm", "\xff\xa3""345" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu6WgD2zYQDPgxR2sXlUeEeGKknxt95W.", "\xff\xa3""345" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.KBv1eBM2he2T/QheS8zPHMejn5fMNRe", "\xff\xa3""345" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuUIzecIiCguM2sPh1F7L9IS3zOtmg5Im", "\xff\xa3""345" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.vrukkCtLqHBLoBDsz6QoBtSwzI9Qxiq", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu7N5c8AaH.dbqz7.2o.V2mRkUDV0TZnO", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.D8jTC5oJeIumVOhMVpz79BzoGVhCjrW", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuE8Lpo1/qkGPTBDBxEsJjeEzh9nkZ9uW", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.xGPMyJSPyyeICKolPQ2gecm8rOgHwz.", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuuTNb9MEHVGI7kd6UnQjYxgRNiKJM01S", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.k.qekGiJym3QgfeFCwNhPHg0Zk99KSa", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuyM59Cq5iVZDB3u45gTNhRSnOgrY1tdG", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.VAQY6kySmwStlNY.sut9Y87njVr0mm.", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuPPtdI0NcxZ4Txyv/Y5ORfcP1XFriKT2", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.tHwehGUs3q0b/Ejn42MsoM4Yv/iA1rq", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuu3cFqlEl7Y0HWaVLHpyyCqG8dBNk1DSm", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.n2VnrmAaokJwiDSekcCjbZxRIyVngRy", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu5s2v8.iXieOjg/.AySBTTZIIVFJeBui", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.0ZsAfF0DsSCOCcfZKxtwXxkV4RFYBVG", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuRAip/W0RPQX4QKkqYqXE3GIXWH518Sm", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.n2VnrmAaokJwiDSekcCjbZxRIyVngRy", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu5s2v8.iXieOjg/.AySBTTZIIVFJeBui", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.0ZsAfF0DsSCOCcfZKxtwXxkV4RFYBVG", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuRAip/W0RPQX4QKkqYqXE3GIXWH518Sm", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.ZkQGqjbMpqQ9oCsxNZjN8LQJaHFqPMC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu51cV.PJOQVwmiao4t4lXsb9Cc3Jnuem", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.DQjlTXDA5PBQ97.qBJY/vsHPQhLJDMe", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuAqM0XavJxJXeVlJ3Te3umGJaPOCYmZi", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.ZkQGqjbMpqQ9oCsxNZjN8LQJaHFqPMC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu51cV.PJOQVwmiao4t4lXsb9Cc3Jnuem", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.DQjlTXDA5PBQ97.qBJY/vsHPQhLJDMe", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuAqM0XavJxJXeVlJ3Te3umGJaPOCYmZi", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.uB1no1bSvQlNFbG6DThB52xIhyG9z8G", "THE YEAR" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuuySE45JP/avbudkXbPzjvqTBKf61NNfi", "THE YEAR" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.c/NBil2GQ9h1axG3uDE7cen7O1yt4wu", "THE YEAR" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuT4fz1ym9dcyOwa1hMmFJSuk4yISb03.", "THE YEAR" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2a$05$CCCCCCCCCCCCCCCCCCCCC.", "$2a$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2a$05$abcdefghijklmnopqrstuu", "$2a$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2a$04$CCCCCCCCCCCCCCCCCCCCC.", "$2a$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2a$04$abcdefghijklmnopqrstuu", "$2a$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // bcrypt_a

#if INCLUDE_bcrypt_x && defined TEST_bcrypt_x
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.7uG0VCzI2bS7j6ymqJi9CdcdxiRTWNy", "" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu0oImNDIy4flhldV9YqunRgBAePKmw7m", "" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.Cg0ly9t/KVBCBYYDfOmZKwry9JuXClC", "" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuubyCG3zY1GIXMyxfivm.ClDiInHzxjiq", "" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.REUe.wVCLEE7cNcWpheIXR9MaRPCoVC", " " },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuueHjTs35M4oLkB0oz2vpFCrkqmB3wDyK", " " },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.QK3io8Pm4WhsBSZhzvm1OPPQ1MU.WxC", " " },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu/ied6LYDv4Nek.n8vXq7pbx7mJcRizO", " " },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.crbyEJ0XFaJ9sONRyOTHdI7c4ZT.ndu", "a" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu8.veTXNDPV2eEsdpKNczMw2otgh5LnK", "a" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.f/Fm9DOYGp2ai9rjxvG4QHlhtDCuDuu", "a" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuMFdJu9yVgmagVAIC24fOZkaFqd3s9JC", "a" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.w5.fxtwCNbJ3swM5YKT2SoO0YcCOkhS", "ab" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu0EJam7uq2UHswNA05epRm6fJdiFmbUi", "ab" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.ThcCpjPKXmu6XgQqJJEGokAiEUquQVe", "ab" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu0CkeIeZLJOlOL1QPPhfXulLNPdFqJBW", "ab" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.gNn9EDJdrUJF53AHnb.4T9BCvqhUYdW", "abc" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuRWUgMyyCUnsDr8evYotXg5ZXVF/HhzS", "abc" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.AKurti2nSiRoaXd0tyyeWA.1jj9Kto2", "abc" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuCi15uRb1eH7NAlJ/TgeJertyknQpYn2", "abc" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.E5YPO9kmyuRGyh0XouQYb4YMJKvyOeW", "U*U" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuMpLhh66NJUQMuZ6FwRQX0sqAEKeWcKW", "U*U" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.K7Qr0se1MxuggH4aP4YgB.U2Em1pGSK", "U*U" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuCFaEytnzrfaPZJKbS76hh9vqd9r8v2S", "U*U" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.VGOzA784oUp/Z0DY336zx7pLYAy0lwK", "U*U*" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuueqZzwRqX8BEsrV2jF8gx70v6bcd1qAG", "U*U*" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.5dvsdVl2y/501tm9dvdbbSRbpuvxsaC", "U*U*" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuBtzXFXMcxIslxJptQaoJYuU.xP21coS", "U*U*" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.Bw3BobdGs1SFsKsRLIx9rC4T.Q7DtEm", "U*U*U" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuupkvHj1c6E382bN8hwXRlu1xE4bc1pgG", "U*U*U" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.r2Gz4aKpQDpr6TmvEJksSv12hIDVgXe", "U*U*U" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuMJG4SPxGpsI2PpmiVYJg7D.hA7CdQyO", "U*U*U" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.6YtT5mHh5I666KkHRqqIuteDuaNX1GS", "....." },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuun3YeQp9ZOh1qWiEKJNRybZT69WMr2sW", "....." },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.6v/P2K1bqBzj9FILn7LJntMzJQxUuA6", "....." },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu7bnTzNnC9mpomsuya2sDYCcZGtW3FKu", "....." },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.LZrfN0lz4CULfFuRjqXiVMP49yNOHKi", "dragon" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuG4nizIsfFMB34Hh5MoYcbtdFUq5YPJK", "dragon" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.tidtIFf5ZCN.gk6Mobs.YyDMzNhFfFm", "dragon" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuujzhP54E3nDKxLTbGbyrFiW3EkV.7ERC", "dragon" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.i7hPnfU5WycMwd1C9qJZDFBCw8NcAFu", "dRaGoN" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuMA7xTS.7H8Lal4RW.s8KBMURGOrPxQa", "dRaGoN" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.5TqUWVAHsz4mvbAcNwu3JSwt7Pd.dm2", "dRaGoN" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuqS/OX35wGo1BfqluN8dsq//CyXY2pNS", "dRaGoN" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.ZGVtQn6eTc3aPe.tQ.zJuH3XlzyI9Di", "DrAgOn" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuO5PYTf2OGllbJ1tyzjIAdpnQ9rUDGNC", "DrAgOn" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.SzmeTH6T6GIGbKj9Om75UAlglaj4twK", "DrAgOn" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuE9zYHFcawnjSDJKsSux5hf1fyy3utXW", "DrAgOn" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.u/WsPSagrbjc3QmFLSt6j9e/LJ8FoNm", "PAROLX" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuzyv2QWIljnSNjMYpSebmlCqn.QEGEB6", "PAROLX" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.pQY3jmCmc/1Pk8B2m6DNUj9ANrzICLK", "PAROLX" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuumicc49hlc3UdUYSMeE8ZXKFJcV/Q2Nm", "PAROLX" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.7Knr9/jUQJ0lh8N4AU/fMnQskXCdfSu", "U*U***U" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu0whe22G2FGJcNLWQaY2ZVuZIf5IJBHK", "U*U***U" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.H3n2rsAGLquD5DBiTNaKBEYcc0HJy5K", "U*U***U" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuDu3PK53XxhceAEiIIFWWlG16bn5LvcG", "U*U***U" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.HjTkKOvb2xTYRqeMFaN1PRcxuDYro5y", "abcdefg" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu3NLAiMrV.ggY98aZ7cNIwxII7afa91.", "abcdefg" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.GQNqYPSPnkqs4XPHOKxta8z3oVxx.Oe", "abcdefg" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuGTNT0Ri8Ic/nBhrRQu0ORxwctqE11mO", "abcdefg" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.RFkLTR7KyUmGXnFvMFlLbB23MCIzsgi", "01234567" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuQOF57SPhYRiKufm4.epZm3ELZ4UlAVy", "01234567" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.3uce2XN8xqrZ2aIduEu48JNEUk6ih9y", "01234567" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuucnCKiuhmJV3sCjWqQH.rYNPhmru2Bfq", "01234567" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.hz7CVP6wIj8Z57Ze7yuhrhzKfvq0Ty.", "726 even" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuIaVbx2I8MHKuu1rBc/gqV8Fo2An7wQm", "726 even" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.ib/v2w9PynSZewkHDlSuFwGC.jkyh4a", "726 even" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuus/VSIfP19Ty4eQaE51vB9GbPNmLhq2S", "726 even" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.jUMW9ITlTfAw5cFja1iYihO7V9qsmWK", "zyxwvuts" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuucN2On7GNyUtMxT..Bo0a0ICaTeQOJ4u", "zyxwvuts" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.xf6Tlh/zfR9Qob4S/6wj9RneRcBt4yG", "zyxwvuts" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuucqOWKor12VNz5REoX.a3GqgU2btIQWS", "zyxwvuts" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.hdihJRIixUmRFFg0NQNaid9UF3Uw/Q.", "ab1234567" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuulK6ChIvFKqdreUvOY9oKm2O2Fn.1Zuq", "ab1234567" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.xq4CFi9Keo/OhWm9tosH45r9gI3Gd4C", "ab1234567" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuuBq8XeHGZZJdrs6jsgiLupxqOP4GLc6", "ab1234567" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.0c9Eoia74tfCGVyINCZAcZaVzJdMsoi", "alexander" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu3qH73fcOvo6pdGd/u/Of.mkavvVviAG", "alexander" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.bK5f5L/foC9KH3IYxj9uWGZPE/w22J2", "alexander" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu1zazepZSS74T7o4eCXaJqsa4KC41vt6", "alexander" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.Tc9f8dMIa03zsepKEv1oSFsFWT84Me.", "beautiful" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuusxVo.QMslOcijv585zolzUwesRGYfui", "beautiful" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.7XxYg42754jz07Elen5lFQuommU7crW", "beautiful" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuHz11b40qtSU5.OKZJGONgmO6tsOw8ny", "beautiful" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.SxOcYMxtg44jVOAYY0zBeTBbfCYXSBu", "challenge" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuD2bZx1XnT2xoC7mKx.Jr7E20hJXg5y.", "challenge" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.mK3Hkg2ZFCrNFQRor1M7Bd.pyBSFz56", "challenge" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu92OCZ/GwgJ2w0KrMJRu6fK7i2iKqYha", "challenge" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.455yryJspofWOsWxxZ/Tsu5qtg8j2wm", "chocolate" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuulZGdWs.WkvfSGHTz.1.5CPi2ETJLi3.", "chocolate" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.N0Iumk1Mt6l7kbmk8iYgSA9FqaEfv5y", "chocolate" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuLbL252qaabO.sIFmAzyShKINVGRsGeu", "chocolate" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.ZA//OMzj1MY4PfGODYfbeGs8HPUS2zq", "cr1234567" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuUccVOwN/r/34c2SICyLEwyfRWS4Vgja", "cr1234567" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.8tZkJ2HTsa4Pn6bgGzpDRWJ8c1biGYu", "cr1234567" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuA.Ry5GZ8Ob/wI0r8UydZ6XfbyfLJ5JK", "cr1234567" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.XyLDmzSo8jvTANPtIoCB164F84v8EkS", "katherine" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuOYRnTkqPmRfoAB/blXEA7y5xOBtiEg6", "katherine" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.bsdSaZOaobkZJkNO2MxskcWIZCJ8btK", "katherine" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu5i6Sk8a0h8mpYFdjQZdYrEsLaxZ1EaG", "katherine" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC./cK5Kv8QvFDy9GyVbaJS/eEKlmhA6wW", "stephanie" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuucK0uB5JOSYLNCq75/1vd9213cIwiEQi", "stephanie" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.Yr8Btf/4dkO36VgY1VYAp6Q9B4.B/rm", "stephanie" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuug3T9Nmp5d1Zd35nXtrYPiCSv8A6PVAu", "stephanie" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.VYs2hleVmLTA.FbmrBwOI38C4Pd/8BS", "sunflower" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuY/44p2UkK4uV0kvS9KurVonsOh/oc5m", "sunflower" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.VuKIcBGfiLx.AYuX6c48oQtlhMCQPRq", "sunflower" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuul18yFhC69sq/WwO8ibiE1VQy773yVfu", "sunflower" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.465.cDVHqgo4g9qBZIbQbOcdcGqRs2O", "basketball" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuFT2m2RbIlbhkAJBfZ3FCN3Sn3V.N4Bm", "basketball" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.R293rqybpDGrtZIhZxApKqVLXiOJUTG", "basketball" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuudp7.T6JYoR2jjqAKGX8kDLzPDm6RR3S", "basketball" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.XUKWvx5JT0wYalbOFE4HU.j3lDUpDcm", "porsche911" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuupKJ./ES4uwzJk/SsN3YaTFdl9AIiAdu", "porsche911" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.jgOl9b/oD1cEHohzVyGK6zqcGccVRBG", "porsche911" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuVXo2ooNppOi53FnAHCUuZp8EyiwUoCi", "porsche911" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.sXCEcM/a6jUtNpF7EFCOWiQRogVPxNW", "|_337T`/p3" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuugZjL4p/g0M.xDKdvzvO1BKtO0aYdnwC", "|_337T`/p3" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.UyHWsohI3G2oJ05vftc06k9UIwXNW4a", "|_337T`/p3" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuh7AZQzpU7Q7C5l4VczvD6UVfhLQVCDK", "|_337T`/p3" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.ScdVt/vv5qxU5Weko6ZqQcaHw2EjuRG", "thunderbird" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuhX1c3kKr2qeB4tFvvRmDk/ta3LTQtma", "thunderbird" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.XXuNspXmlmLMqkZ37Xt0om56PIqSupq", "thunderbird" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuSJB.YmarGme5IjgFBN49eRn74KS.zVC", "thunderbird" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.z6PrHbuSsMSSwIGFy1JGevQZf6CqJ1y", "Hello world!" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu7nFISH/8YdwlXD3lw69A4iBUf6fvWAW", "Hello world!" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.M.JZM2tZUe85sR83hfk5p2NZ0IVXwXe", "Hello world!" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuyeG8laUfZvsCmc.AE6qIDYSPGM2efmK", "Hello world!" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.cTKgEgC.g8ePpbyZbNC34HvEm4dr75a", "pleaseletmein" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu2EjsH9/6E2HK9wvYowfGqPX5wGi4UDS", "pleaseletmein" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.3WPQy/x8EhyouO1Eia.f.CS216k/lTq", "pleaseletmein" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuumH1BFkDxi3LKCbP6FQ2juPgiLLcuV6S", "pleaseletmein" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.UTQ/YCMF16uRDggIHAnzfTGA1GG/5.K", "a short string" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuZM773JiyU8IodKIqJ54EAWHzd/nJoF6", "a short string" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.nks3nTLHIdR6yOhEvQZRsOoYVEqWOtW", "a short string" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu.oBhtv6clsTihZTgUKW34dikJs1Zg1y", "a short string" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.gBXVnji0fmYJspngWLhq07sJA.unyGS", "zxyDPWgydbQjgq" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuGbGKxJ6BsCRT7AGpwiKNOKUzJzb5AA.", "zxyDPWgydbQjgq" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.6vf3XUm.amMyfSlIH2P/SIU5V6p644a", "zxyDPWgydbQjgq" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuukgPMil1AyxXOwqj9OWvu3muVwEMg1Aq", "zxyDPWgydbQjgq" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.8TeQYvjyS9VKUlqSLz.kDaRa5v396hC", "photojournalism" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuhJe3S.rJQghSggwRY8.DQE1zCW18PcG", "photojournalism" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.1h1LaJMlvaH2Defb280WzG6X/kqHQQy", "photojournalism" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuugpKNM0gEaEfwZ43UsjoT1tNLK25mqV6", "photojournalism" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC./fog6ND8iIMkWXIpr.Y6LCOndkFsu/m", "ecclesiastically" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuDUj/hoyzOfsxHnlzXPdMGJybsJgbODG", "ecclesiastically" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.AYMycNr126P8pzb9X2aVQjINCiZadp2", "ecclesiastically" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuOt9ERn2.X0reuqDc7blRS.5f8ttIq3a", "ecclesiastically" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.dsZw45vJh0v/SWcvr.H79lmJF/uZKAy", "congregationalism" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuZu0OqjIDqSsvpAvbAqbC.8HRlYYcVkW", "congregationalism" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.1CYpRB/IxktadiLrbTzgJ.Jd/Q06oBe", "congregationalism" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuulau/kOpHdl7CjZgjQuvsiDAB2f/8Aqa", "congregationalism" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.aHkGX/fiki8Qrwu3gWTRnejC9Hba52e", "dihydrosphingosine" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuEJAH.2Z6lOSn5WvfN87I7V1JhCPsW5y", "dihydrosphingosine" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.8obhdpTZ2CAxc8Qbd8dIApwIFM6pzZe", "dihydrosphingosine" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu3tvUtVPx0FPXPsdjb7uta674As4iQfq", "dihydrosphingosine" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.sYSxc3RiA3.WrH2ic000nunk3yqkXHa", "semianthropological" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuLa.VWC3vq9KMn0BrxUY.r4HUotKepnO", "semianthropological" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.tLQTlKtJqj8kJFe92LPFDJdoiTxQ9PO", "semianthropological" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu6yC/otJXGOxvYDo3uRwUKNucauhdOPO", "semianthropological" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.Kvy1q1BWf93W1T7eSLpj/6OuRO.4FqC", "palaeogeographically" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuYNeqeSEZQQFODdHVEfj5MJFvrZPOeF6", "palaeogeographically" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.ybSWdRvitEQlA9I.Oq9wpqMqvBcJiti", "palaeogeographically" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu1POIcCAIthmV0dvj5BClL3hMpuuUctO", "palaeogeographically" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.g7bhq.l6.ix6BSpqhW6wIRoq310s.qO", "electromyographically" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuFj/NgndkQJ9QWdR8vDPZF92Ql/3UYFy", "electromyographically" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.rnGfJV5/J4BjTZj66R1dckO0Gy88d5e", "electromyographically" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuui7gF3bPS07zaLzWARBCVakWoF70OE8K", "electromyographically" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.fr2hBCxymAKP.MXKdQbm7/rIBEBis9y", "noninterchangeableness" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuueL38vMSpfDTZP0TBBAuZDp0A/4eFDFa", "noninterchangeableness" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.z1xt/vCOI.kmvN8L8t9GsafzGsOXupS", "noninterchangeableness" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuR1nrUOQ7HQO0AfPt3niv6JJN90IEgi2", "noninterchangeableness" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.UwjPIUFoFVfh.JD5Z/iVMDQ/.s2BdmK", "abcdefghijklmnopqrstuvwxyz" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuq9gWjWvJAAO9dtIxbLejROlOtpZkAZ2", "abcdefghijklmnopqrstuvwxyz" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.2qEx6VDzW/1gZVPz1yxtxnopI9gvYHG", "abcdefghijklmnopqrstuvwxyz" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuucUHlaG.p8AVcD5w/eidx9TAkwV4EXAW", "abcdefghijklmnopqrstuvwxyz" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.BdcD8qjQ3jCap/PcGpUCiau8u4PMcSy", "electroencephalographically" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuXDAnjJaWDI/Zcl0Om1uOs90q4mqBRWy", "electroencephalographically" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.n1A7hL3v/hM0RBTwKl/MB.eEE0e4av2", "electroencephalographically" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuvcwFX7UZ8m2DKl4e6qPHdONvRVRgApi", "electroencephalographically" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.9WsvENLhmOLqpxNHHDPzl0/i3I0QLXy", "antidisestablishmentarianism" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuNq0IwONJZaZ7QfLbcoA7E.G9LXdQ.8.", "antidisestablishmentarianism" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.WM1vtlGv4CR1StKJWw9/1zvZjhQpVm2", "antidisestablishmentarianism" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu.Nk99xH6C1i1s687VYJkw/9TgJZwvkW", "antidisestablishmentarianism" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.9vgB/QG0/5yJ0/eI2lb6I1NvMoYZHEi", "cyclotrimethylenetrinitramine" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuwOuvuEB8yOWqrtta0jWB10wzwfcx.sG", "cyclotrimethylenetrinitramine" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.mumkbiG5cCSVfxbwD8LbcQV6CFQ3MXq", "cyclotrimethylenetrinitramine" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuukUEvmtjkKEjAeshmrzk18VIJ5pOYI9G", "cyclotrimethylenetrinitramine" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.ld/W//3S8PyfCs05HnX4ctiJEWzxvtu", "dichlorodiphenyltrichloroethane" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuJaeloUBsLGuKojqNVj.JssS.S.5SOoG", "dichlorodiphenyltrichloroethane" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.IJ0s8nV/cDKYfTVFgirVaOoRoZvbMAW", "dichlorodiphenyltrichloroethane" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuQBL3QBmqpQVj0lKsVoN/yVsN7LDfMom", "dichlorodiphenyltrichloroethane" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.qgmN7ezpNt2mv7RXpV9nwxAwSRHe8Z6", "multiple words seperated by spaces" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuUyj6XHAnIT7HIUaHPt/mAqWbLOZ95oW", "multiple words seperated by spaces" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.ya4OMfax14JgLKjCeRnok41QNmDHk.6", "multiple words seperated by spaces" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuurps.S9nvQl/40RApzaFs9lIt3AMcneK", "multiple words seperated by spaces" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.2CHByRiD9EoV4pN2mhPq49ZZhIg5K/.", "supercalifragilisticexpialidocious" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuchc4Fu0voJQx93SMHFKQgbDXESzxUai", "supercalifragilisticexpialidocious" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.mqD8IRcEmTxZ.ChOQZyLHygiTWmqvk2", "supercalifragilisticexpialidocious" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuG9j0r2T6lEIX9LVt3txW9dZuFY0Ew1q", "supercalifragilisticexpialidocious" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.pr..QUPolGyX.oqq.qgP8kNIbwX1YlC", "we have a short salt string but not a short password" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuwLVtPJcEI87Gw5SVMgJ3jR.jz4FXA3C", "we have a short salt string but not a short password" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.S693iU5aWL1P1CiTvv4sKd4VtqEefpm", "we have a short salt string but not a short password" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuus8h4uV7ZQW6KJvz2prsjqaySAO/1k2e", "we have a short salt string but not a short password" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.VkOUUuotOZvrmtXJpkTGsRR7av5It52", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuT837gAqiU/1zYnau8zpkZMploUCluwS", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.iNDvHP9V2K7P.xzMWcBO.ucnS87zUrq", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu5RYaD3UZMA62Bfinm5QndpfWzruwF.O", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.8b67df7RZ0XnI62umy35MYpe4K51Fk2", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuW5igozlL8rSr/rkFexuDh1grrkW8FSi", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.F3K5wiwHej.p9lTXgX9bOlrEyWKv066", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuViu5c2UpaacAGAhQuLE2zyrV3jz4b5e", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.Td/f8oS7ISMxGfHYB8YP9rXGhoZDosO", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuxuElans2nYY6zVSN13XYHtA0oeOXZLa", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.kLVEehyg8LFsXfIVuFyGfLj4dvN7a4e", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuMNSliUjQvcDZoWAZHm/hAG9Z3ZRf5wy", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.4aisLqC2w3pT8aeXd3SHZFJkWSCkf0a", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuoBz.G9gMNiZlW/Gsj.oKhiomPeIRFTC", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.9c/KG5wY7kGTdky/Js0KWIpuVuJFUJG", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuinRgQYMZk.yuMIssG.kPPL6i9WP0xFa", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.j72N2Fi2j3pGalOZvTqtyH3bYGotuju", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuN5E4WSTo/R5henexIN1o8xkGwe2V86W", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.tlD3cmtHgs/TwWAvy5E3F.freZS1bau", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuIZEWKJgp.b.KG29zgOadgd2rUt5iV1e", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.ZH9vItRapPbkFKo0iQqU4v71o0e19Mm", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuzAUUWh4XGsBGYs6yyUJTSfEgzoLXO6G", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.QiT.KUY9PXgIzL2aECMKb0EvVl0Pzw6", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuufOj7giyJz5k22FHTKGVo8o1o5zGzPsq", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.2M7Vc.sF98e8DDmnxFjRfAmrudbv6y.", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuC3nvb4DotHdnRYgOPcdiK0C4q.DkIDO", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.6He0iAS8JsdM.iB4OQ4fbsKMXPagLhy", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuwhpbcVuyGrJbgveSSM3XQKa8G5alyRm", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.cYbtH8J2lfpMIiBKfF3pKpMno7JlLui", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu1Z0zKnHbUU3q/kk//Pknlv19a4/T8.K", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.8gGm3RkYFflDX50UQs.tJ8InKNy.HGO", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuugLfxf5sydYesf658mrFYb51nLrn/4Sm", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.cxMAJfIx3T.Fv3O0KjL9VdM/oSSUVRK", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuTYqa73Yp3leHe3D6.ysuJtNLwOma87C", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.25hhqa/GOJGmXui3avNI5MN8lOI2bCW", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuJ6Y/kPTV/aHj7iJKuDfD5OPjVTvT2BK", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.q5NMeQZ0UTyP/bILj02wdQ.Si5KHU1K", "\xc3\xa9tude" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuTmFuGBy/Zgc6JVAr667oHeCvGQGyS1q", "\xc3\xa9tude" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.odAvHZH9azlhi1x4pBLF25.hj08RMFi", "\xc3\xa9tude" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuufY4v5x6.8txtKUKDP86z1xjlXG/GgZO", "\xc3\xa9tude" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.qcYQ0c2j2SvETms11hszz5bnbvNhN0G", "C)tude" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuo170FGVreUKlJWzQl8GcfhpghDIp2c.", "C)tude" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.2iSSZ5gtiVxKz8BdAoDV9IxZl3LAH7y", "C)tude" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuutA7.Ir5GREoOf.twyI.Zoy.dI1gNHfC", "C)tude" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.7bLwFi3rlVcl.xfhc7LxjqwOExfxki2", "Chl\xc3\xb6""e" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuojiyBkc.4HZ2y5Yh0LxBbI6ZkLiRg0C", "Chl\xc3\xb6""e" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.fRmxM11/x97bxCrhecMENdkPm7YpRbe", "Chl\xc3\xb6""e" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuoBvt6zJCTP5OED1esTYUYPn31cWqwsa", "Chl\xc3\xb6""e" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.w.V.mBIadppiKKxZ0OzpXn86NOk43pC", "ChlC6e" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuQ2qgoto47/GjSmc6truiPxHNSL1jAfS", "ChlC6e" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.r7GLvyVWQLuQaOTYsrMOBkbLfy8sPIi", "ChlC6e" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuueolw0UBEFN.qCtReAkwiO7BAjrY4CX6", "ChlC6e" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.xSD.pz8Zg3vt0Jiovghl5Dqrs8aw8ni", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuNjlOVoE5aHHQGtU9zc25wu0VykHnD1G", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.3kVpkKaj1q2TAXm.ptIi98Nj3zVV8A2", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuXv3TUB0NdnMpyn4cfg4g48oZxRSIrNC", "\xc3\x85ngstr\xc3\xb6m" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.gx7D73FxK1lx9aoctuj3fhNJqC.IYc6", "C\x05ngstrC6m" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuusSqmEHNEXYcUAamAuvd.piiJP2/SvW6", "C\x05ngstrC6m" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.pjA09E/vp0VG8cavv0kgRuMJNPJRdqS", "C\x05ngstrC6m" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuEFW231TUkQA55cajdiwh2GQXkKY7v4.", "C\x05ngstrC6m" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.OVB6qjs7Uzos9N7/Rpm1laBHwGw11u.", "C\x05ngstrCU*U***U*" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuAEHJsqoIo5645CuTbmM6VobcvFM6pxK", "C\x05ngstrCU*U***U*" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.E/ZiYei4bcJNCJEyI148Q1.aMAOn66e", "C\x05ngstrCU*U***U*" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuumAqJP8MYx4tSoKoE9d0vR0QW81bYuSC", "C\x05ngstrCU*U***U*" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.84ASbYYPYkl18.t0.TvQbm0oh98TFvG", "U*U***U*ignored" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuR.W0Ohu3KxpPUfr5Knw07yOOzZkdd7.", "U*U***U*ignored" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.wx4V3qBoGl7ej9kbsoEpQTxmptzY0yq", "U*U***U*ignored" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu4SS72T2y2mc0YsQSe9qECdkPhGVslHS", "U*U***U*ignored" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.ebmmSqlfcFhKGN/743nH7i03zpqftle", "U*U*U*U*" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuF1QNFce4DfYnYJUcafR1v2/7XbWeLjK", "U*U*U*U*" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.5KIIW3tGg2xhhVu/AQXLZX9lSSeeehu", "U*U*U*U*" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuudBYNJEBvC10idL3LIvyzUGdaxqz0jJW", "U*U*U*U*" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.htnOkHgQ8LrcyWv4cQVE5Bt0DiVxJzG", "U*U*U*U*ignored" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu1JJvN7RoX92Zzq1yGezl/5/3vlXyrxi", "U*U*U*U*ignored" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.7YCBkroPI7yK9JGre8Hne5hdwmA6Z3S", "U*U*U*U*ignored" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuc1KKQsfk4nXu9CnvuF/SfMwrmif7tsC", "U*U*U*U*ignored" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.DzSBCMqe17IfGIqEfq.FrxykxqtrVi2", "*U*U*U*U" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuuzPVVNB/SAKLJbAoTgm3qolIt8JCyqG", "*U*U*U*U" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.1fL1/3fOtt1usdRoe0dWgjAUT/TMd76", "*U*U*U*U" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu39YJ8HbI96dgaVWEUkKUCgXR4676Qjq", "*U*U*U*U" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.yu/PNF5atjbvgp2r9GyRzSYOErUPNHq", "*U*U*U*U*" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuZu/4jl7FZnNPiPunsfxbXLTBcZ4XPMe", "*U*U*U*U*" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.YT6TwplC9qsDdIyZ4nZ.2STP1srJcv.", "*U*U*U*U*" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuQ6t3zlOYOUrJSlX7AdtXuuWd0hDhQiC", "*U*U*U*U*" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.7Cc1PePc3H0bDi8khYlhX6PVDNBB0QK", "*U*U*U*U*U*U*U*U" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuwd22F2Sxe6gq2OS.jcQfMBY2dJtwKyS", "*U*U*U*U*U*U*U*U" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.AYh0eQgGLbt9qiP1jMH9.zHrUuVNY5.", "*U*U*U*U*U*U*U*U" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuui4ZHqA63Ft09xDrL31aaZvJ3RjuITQq", "*U*U*U*U*U*U*U*U" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.jlPoM5ioW.OQLW.5JcdEmo4HtRjF876", "*U*U*U*U*U*U*U*U*" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuz3ESgmDkKJlK0Nuq2.ylqgmDHlpC38q", "*U*U*U*U*U*U*U*U*" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.scf6.mexwrzCAGi3ShQ8cYkynqeH0bK", "*U*U*U*U*U*U*U*U*" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuQLykgCNxKyLhRD0HXzLibuZLZfiGOEO", "*U*U*U*U*U*U*U*U*" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.Qjdj3GXX7D0sFE9jji6wxSTWIhqI3US", "\xa3" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuHdhhdUXVgLADnbTYf12kvsasO1gS51C", "\xa3" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.PIeeyENZVZmrKLAq5lwBUU9fMRVfV2m", "\xa3" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuMOaOTHB4gEm.rriBjXNwBNh.Oc4mKGG", "\xa3" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.nQF1kDoMDjBBwXy2wwMni2gJLKqA0ta", "\xa3""a" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuYdqUOXeMKw7X6zbqBXP6c1xqIKun7Oq", "\xa3""a" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.bqJMLkbvnTFj0OYMu9tPnQXstRzX/e6", "\xa3""a" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuUPPO3QqmgMIXGHvbOLe2IkNzHLAToY2", "\xa3""a" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.QZ7A0p9q1Ag9Utfnfl/xif8NiDtVhO.", "\xd1\x91" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuusND7G4.cx6Dzn6TqbXfK99bElU0a7P.", "\xd1\x91" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.2E0h7UFL/4fALemA5ApWrCWllQXSPTu", "\xd1\x91" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuumjGosqV8OkKEcduYTNz5PKN2scswFya", "\xd1\x91" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.bJFOmj3TaByM10X0BF32w0Fv/xFNSvm", "\xa3""ab" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuojaU9K.vmSlY6BHpgIQ/WY9rEOCcJO2", "\xa3""ab" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.0EeTSP42yLfD7uTTcDffPd2CNLKHdoy", "\xa3""ab" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuikYh/9nIvugTp.kFPFeZDBu7eW6BLoa", "\xa3""ab" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.Qjdj3GXX7D0sFE9jji6wxSTWIhqI3US", "\xff\xff\xa3" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuHdhhdUXVgLADnbTYf12kvsasO1gS51C", "\xff\xff\xa3" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.PIeeyENZVZmrKLAq5lwBUU9fMRVfV2m", "\xff\xff\xa3" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuMOaOTHB4gEm.rriBjXNwBNh.Oc4mKGG", "\xff\xff\xa3" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.VmFQpoXeVuKTzkg2ZRsAf.8PZJZg142", "1\xa3""345" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuucaGU5ROXj4M8Tgsx3s/D5BQIuhazIWa", "1\xa3""345" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.8jdeg8QqT4CX3ERA9vZPFZAkxZRpxJW", "1\xa3""345" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu9f4sA9SRA0scUKcRyC5kce8dao2.GKe", "1\xa3""345" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.VmFQpoXeVuKTzkg2ZRsAf.8PZJZg142", "\xff\xa3""345" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuucaGU5ROXj4M8Tgsx3s/D5BQIuhazIWa", "\xff\xa3""345" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.8jdeg8QqT4CX3ERA9vZPFZAkxZRpxJW", "\xff\xa3""345" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu9f4sA9SRA0scUKcRyC5kce8dao2.GKe", "\xff\xa3""345" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.VmFQpoXeVuKTzkg2ZRsAf.8PZJZg142", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuucaGU5ROXj4M8Tgsx3s/D5BQIuhazIWa", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.8jdeg8QqT4CX3ERA9vZPFZAkxZRpxJW", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuu9f4sA9SRA0scUKcRyC5kce8dao2.GKe", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC..sDifhVkUxvjPx6U4yeM2tC411Wuc.W", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuh.z2vLHB/tYSU5fPXkrYB7TxLHGJnI6", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.yphVralDu2JlxYbCqwwGli/H6wBgBtC", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuyED5tIjzyeH90te88BUWvTrMFHsWgCi", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.Ysbn1VpHCTzInfW/z/8Q3k676rxfmSW", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuupjce7u/YRnectNa8DXjsSGzRdyH2PSG", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.9iflVP0Ezo/iaxO0XS74wFglLNeryTS", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuIvJ5WHgSbYKj7g9hhdVsAjyzcnVT/.m", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.n2VnrmAaokJwiDSekcCjbZxRIyVngRy", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu5s2v8.iXieOjg/.AySBTTZIIVFJeBui", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.0ZsAfF0DsSCOCcfZKxtwXxkV4RFYBVG", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuRAip/W0RPQX4QKkqYqXE3GIXWH518Sm", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.n2VnrmAaokJwiDSekcCjbZxRIyVngRy", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu5s2v8.iXieOjg/.AySBTTZIIVFJeBui", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.0ZsAfF0DsSCOCcfZKxtwXxkV4RFYBVG", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuRAip/W0RPQX4QKkqYqXE3GIXWH518Sm", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.VTMVcF7YBLV2/O6V1PNcQw0BD3hTN6a", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuurB3dV.fJGdSihNlP0vo5PemoaZRp6LS", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.PMOS6ygjFMSbDo.iJJam/G63inGIOBO", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuxP2lldc1.10LvZDjJZXNBKLzWqnkbOa", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.VTMVcF7YBLV2/O6V1PNcQw0BD3hTN6a", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuurB3dV.fJGdSihNlP0vo5PemoaZRp6LS", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.PMOS6ygjFMSbDo.iJJam/G63inGIOBO", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuxP2lldc1.10LvZDjJZXNBKLzWqnkbOa", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.uB1no1bSvQlNFbG6DThB52xIhyG9z8G", "THE YEAR" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuuySE45JP/avbudkXbPzjvqTBKf61NNfi", "THE YEAR" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.c/NBil2GQ9h1axG3uDE7cen7O1yt4wu", "THE YEAR" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuT4fz1ym9dcyOwa1hMmFJSuk4yISb03.", "THE YEAR" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$2x$05$CCCCCCCCCCCCCCCCCCCCC.", "$2x$05$CCCCCCCCCCCCCCCCCCCCC.RURfiuM5wAc5Jv4SO604mh/l3NurIoq", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2x$05$abcdefghijklmnopqrstuu", "$2x$05$abcdefghijklmnopqrstuu6v4sW.Jh71LP6RHjCG1iTdKjHpi8Az2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2x$04$CCCCCCCCCCCCCCCCCCCCC.", "$2x$04$CCCCCCCCCCCCCCCCCCCCC.NNYMcLQ7lIauYt0h6mWJtoSyBZqwBwi", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$2x$04$abcdefghijklmnopqrstuu", "$2x$04$abcdefghijklmnopqrstuuZgFC0hc.gvORKBIExxdbXTGVmt0vRFW", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // bcrypt_x

#if INCLUDE_bigcrypt && defined TEST_bigcrypt
  { "CC..............", "CCHYKxYMMLQN2", "" },
  { "ab..............", "abmF1QH4PEr.E", "" },
  { "CC..............", "CCcePb2UhZY96", " " },
  { "ab..............", "ab3nfvqkpDCz6", " " },
  { "CC..............", "CCu3ZS/UCwMaA", "a" },
  { "ab..............", "abxxB7HlIeckU", "a" },
  { "CC..............", "CC0MiZNhf/ACw", "ab" },
  { "ab..............", "abAwh7.RciMzE", "ab" },
  { "CC..............", "CCQ4IySE25HV2", "abc" },
  { "ab..............", "abFZSxKKdq5s6", "abc" },
  { "CC..............", "CCHc6HsfCQ5t6", "U*U" },
  { "ab..............", "abCY/CHNnliwA", "U*U" },
  { "CC..............", "CCmOvmGnYgIOQ", "U*U*" },
  { "ab..............", "abrP9hatwxlsc", "U*U*" },
  { "CC..............", "CCzd9NlE45556", "U*U*U" },
  { "ab..............", "ab9YovNfzixZE", "U*U*U" },
  { "CC..............", "CCvbcTIyRnP1s", "....." },
  { "ab..............", "abQcwGqfvDF4U", "....." },
  { "CC..............", "CCcMgHKAHJ1SA", "dragon" },
  { "ab..............", "ab6Gj9YvrF2As", "dragon" },
  { "CC..............", "CCK5kzKL/XuQY", "dRaGoN" },
  { "ab..............", "abmNlUI1COvYE", "dRaGoN" },
  { "CC..............", "CCRDslM6u7nAk", "DrAgOn" },
  { "ab..............", "abUqB6rDk72W2", "DrAgOn" },
  { "CC..............", "CCUj.vcbp0YcQ", "PAROLX" },
  { "ab..............", "ab2mSJsfAaEYc", "PAROLX" },
  { "CC..............", "CCX.K.MFy4Ois", "U*U***U" },
  { "ab..............", "abRk/fdtGCS02", "U*U***U" },
  { "CC..............", "CC457075f2366", "abcdefg" },
  { "ab..............", "abJ1KhM1sjlUo", "abcdefg" },
  { "CC..............", "CCO7o2HcqNKcw", "01234567" },
  { "ab..............", "ab2wHQ4RTFVKI", "01234567" },
  { "CC..............", "CCBsM2N7uDf4I", "726 even" },
  { "ab..............", "abvP7wxxQ4tog", "726 even" },
  { "CC..............", "CCOGSgC4qjcA2", "zyxwvuts" },
  { "ab..............", "abbEulwxH3FHA", "zyxwvuts" },
  { "CC..............", "CCVTQupjkvqPYMXt7kJ5/KC.", "ab1234567" },
  { "ab..............", "abnYLVrXaFJ5wbbOy5TMMF9I", "ab1234567" },
  { "CC..............", "CCk4Onp6WTPTYcGQwikygdIE", "alexander" },
  { "ab..............", "ab76vmlPVRy5Q2/bWVChp3m.", "alexander" },
  { "CC..............", "CCoUdX6WyGKgs.4ll1y5t4hw", "beautiful" },
  { "ab..............", "abwfsjWX4EyO.54F5tcweK2E", "beautiful" },
  { "CC..............", "CC9P2ZjaWPiSQGjxqTYeOQtE", "challenge" },
  { "ab..............", "abNf5XM5DhRJsjTttFuXLpEg", "challenge" },
  { "CC..............", "CCFkZ6ziYuRO2LCFGKut0Jf.", "chocolate" },
  { "ab..............", "ab5g9v/XGNiAQpwEERnw4/Sc", "chocolate" },
  { "CC..............", "CCNbsdP6Epo2.m7Bgw8ZzxjU", "cr1234567" },
  { "ab..............", "abxR5d2mWY2GgbmtEHvkfvZg", "cr1234567" },
  { "CC..............", "CCOwLOT2cAuVIMc/EueVKMIk", "katherine" },
  { "ab..............", "abzBVZ7aWUKM6j/2ha276idw", "katherine" },
  { "CC..............", "CCoLp0sLZdas2rWkty8ZiqLo", "stephanie" },
  { "ab..............", "abO4gfga4XKD.LyaCgObeHxM", "stephanie" },
  { "CC..............", "CCZrXpzITbV1kikHjkiorO6g", "sunflower" },
  { "ab..............", "ab48pizZvB/R231zb7gnVeRI", "sunflower" },
  { "CC..............", "CC6fdwBHH3atwlQ9lNt6a5H2", "basketball" },
  { "ab..............", "abJqfe.5maUGkAQ70mQTJjK2", "basketball" },
  { "CC..............", "CCJa7tMefq.rwoBNL6XmZMek", "porsche911" },
  { "ab..............", "abAXo0qGhDad2x0n5AvrnUfU", "porsche911" },
  { "CC..............", "CCiwAFQV9a8P2tzhCAZYe6Q2", "|_337T`/p3" },
  { "ab..............", "abhOzUBEprC2Mn9crKdJV6uQ", "|_337T`/p3" },
  { "CC..............", "CCUIVkP6RhPU.HtCCpm2VJIU", "thunderbird" },
  { "ab..............", "abqhNEbBQBA3sUoPrPfnrgZ2", "thunderbird" },
  { "CC..............", "CC.FXhmgF9eGUNGazFEI8GD6", "Hello world!" },
  { "ab..............", "abMbH7WsHr7wQFVyKTqAt7D.", "Hello world!" },
  { "CC..............", "CCBkhrj5Ptwl6L39.Qc1YFjU", "pleaseletmein" },
  { "ab..............", "ab/DEQq.fnuz6aBwj.3UrCLQ", "pleaseletmein" },
  { "CC..............", "CCL8hSYYbUTgsUSRMXLhUt06", "a short string" },
  { "ab..............", "abgpCbJjOvjuoaRydemZ2HY.", "a short string" },
  { "CC..............", "CCzCSKYTyC2JEb3pCcnZOQIU", "zxyDPWgydbQjgq" },
  { "ab..............", "abfcHW3Eqw9a6Fs/VxbSDWzY", "zxyDPWgydbQjgq" },
  { "CC..............", "CCedg2FJ0iNYIBZudedTER.M", "photojournalism" },
  { "ab..............", "abZW.Bx7lmec.SDRa1Fdf49A", "photojournalism" },
  { "CC..............", "CC9rjRlxb4hYIUtYIWuraHEM", "ecclesiastically" },
  { "ab..............", "abWR9L6FAAjBUhciM5rPw9LU", "ecclesiastically" },
  { "CC..............", "CCdDDsxFI3f1IoBaUtkUPzhYHOn.GmO9vzg", "congregationalism" },
  { "ab..............", "abCQz3pDUMwjEYuKi2q9aXZ2N5cEyz20NfI", "congregationalism" },
  { "CC..............", "CCObKp6oZ/Ijs5BckuMqUe42t3lhtkogpPE", "dihydrosphingosine" },
  { "ab..............", "abi0ZGA2O7vz2N5qJzQtGPIopK9iDkNesxQ", "dihydrosphingosine" },
  { "CC..............", "CCSd6IjC3XUtQpLiYoJJR3L61ag8tPyMnkY", "semianthropological" },
  { "ab..............", "abkpCn0UslKR2lQRz5/EHshYNtWNhPzyZD2", "semianthropological" },
  { "CC..............", "CCkszowLaKwQICypy.I6xl/glI9ZVe7Xjm6", "palaeogeographically" },
  { "ab..............", "abQpNzgtS8Y4.8QujPFse2hICU6kR1Nqews", "palaeogeographically" },
  { "CC..............", "CCj4BLTHC8dPQhbf4iUgXJjsKRdcsOpBQdY", "electromyographically" },
  { "ab..............", "abhofIPtJKDnImNUGCkjfroAx8nN7ehOV0k", "electromyographically" },
  { "CC..............", "CCqYSYdfJDa9AZReZ1nNZdLsCdvwFQqiebY", "noninterchangeableness" },
  { "ab..............", "abjBC5WWqUx5sY1LtCMWebPwD9kvv6jSCjw", "noninterchangeableness" },
  { "CC..............", "CCYiWECFTvLboOsCPb5O261k4XXsJKi3eb.Pj78mokOy8I", "abcdefghijklmnopqrstuvwxyz" },
  { "ab..............", "abYH7TYgEKz2QoAyB.mxxiXgOOohoOIApK6ELI2GMEXSa.", "abcdefghijklmnopqrstuvwxyz" },
  { "CC..............", "CCDUc5yYKE2dIIv6tsd7Jzm.XBkdER00XCIxwy10ZCv.dE", "electroencephalographically" },
  { "ab..............", "abooZTCeS9jSg9290VBBYwb21PdwjAmuKVg6UlARNZjsx.", "electroencephalographically" },
  { "CC..............", "CCvT8tKTENFfoM60X889h.JkbwGKcf/eFCwQR4QAq3gGEY", "antidisestablishmentarianism" },
  { "ab..............", "ab6c/K2rnT8AwtU8ulncid6E4joJsx1acjgt4CdohWxSGE", "antidisestablishmentarianism" },
  { "CC..............", "CCqCWJUufOFw6FnRug44H5BoStVJTBled.crPhz0GMSvwk", "cyclotrimethylenetrinitramine" },
  { "ab..............", "abzi9F1yuymUQ/08a1n8/23wmfdEaTrt.P2/yfBeJeZ.mc", "cyclotrimethylenetrinitramine" },
  { "CC..............", "CCWpLVCzkv4GsfiC2CQF4JCgv2TKqhkG1tQFiHDoqCP82o", "dichlorodiphenyltrichloroethane" },
  { "ab..............", "abAXyrMLt2fwcEiuJgjLEj8ELvEtItM2UPoiCt9PfNsiWc", "dichlorodiphenyltrichloroethane" },
  { "CC..............", "CCFAo2el2sagU5NocAjwS.LIXuwuwlVq4yooUqJEP1y7UEAFxoQpabTMU", "multiple words seperated by spaces" },
  { "ab..............", "abAYLFLzcWoWo3uygM0YWq.6sgFIjwJbxCIqObjsdV5prMwvqiKtKSC82", "multiple words seperated by spaces" },
  { "CC..............", "CCSz2gog3i0copk3g62AcBKotVVA77Yv372DZauQ67wH8YyDlJ51euZQo", "supercalifragilisticexpialidocious" },
  { "ab..............", "abBTyQ2AdyQW.NX65b2kLmGI37LOYpInv.2LW9j1EmpUZArV9PZJ8bB62", "supercalifragilisticexpialidocious" },
  { "CC..............", "CCRFMtw/2Yz6cYE2qeoAowTEdZb2DLRzhdQ1d3R3w3eHRgMxDBIf60FlQaX1VUf04apcdi9ZBJwLyQ6", "we have a short salt string but not a short password" },
  { "ab..............", "abBCBt9IU4lugg.4bU.ixxyIUp.0Elat4LUsDTnSGYYoMYA875qHLhna.XUdWmk50yH.Irc3cDsuSYA", "we have a short salt string but not a short password" },
  { "CC..............", "CCFAo2el2sagUy/is9gPtJsk09WWrDyEBNAhhMd8X3ZuqAgTlKulLOMVEwhmmbTz.fZkU7ZbA.YZBCsNIdSXNGM.g2", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "ab..............", "abAYLFLzcWoWoAGdkYci9Fso2DsqBx9v0lE3ppOJwoJyaMrko1Wv9pFz2i3TFCO76PVIsUTpOmwjMPo5p99wCa/qRA", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "CC..............", "CC.nSMd1oqough8yDz3kHHd6CMmltaq1NrwZWrqo1YITyceQ8v6XVixfw8LJYrzE4ZSsGcY32UjcmoYZmW1kid7QDg", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "ab..............", "abzCGr5cnwu5QyHd7mdh8il60ak0tvYKIa.8wo.69BgkdAqW2gR9Hxt8wOgMJAyLGkhMZEp0C6kbMNIIbQ7Z7tjqg.", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "CC..............", "CCehtSXY9VcgUZ2YOt3h4GOMOzPpwCvkjZYo39LwWSbFHoC1F2QNfNnIEKrBF1JE4aHg4yczltNErjM8SkkKrjf/PsDwtB/uMk2y.4e6G7WwGsjI", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "ab..............", "ab1iBa.N.U2C6mzGmzqYiNVweDs/2eCEvo2JgfwvFy3nn2YL3CyMUoH8wRbI65CoVvq2qipX1DPxpq.ZqmLSl1KeKkTN0zS6FlWUAbvrI1YaHuYE", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "CC..............", "CCeWCPWeB0Y7sotLnsWgg152jISFe1nlm7.EABfmte0UFMyWccbNIjGnMfSlXsipHzoQIVrDe7XV2YMHo2eiTidoxMG9HorBbDtkoeLRQI4K9PL6Y./juXb87aA", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "ab..............", "abmQw6w8KuXCQdxJQmOYY8a2j9eM50RJMSc1IjbFsgYK9.14eN7o775aUJSexWmaQklQFRBoT205WiYopjr2HYdcJweENajtGY5N6BQHLRlAjvsQa09JllUnaoI", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "CC..............", "CCUj.vcbp0YcQ", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "ab..............", "ab2mSJsfAaEYc", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "CC..............", "CC4rMpbg9AMZ.", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "ab..............", "abP6zaVz4PU9U", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "CC..............", "CCk4Onp6WTPTYcGQwikygdIE", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "ab..............", "ab76vmlPVRy5Q2/bWVChp3m.", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "CC..............", "CCoLp0sLZdas2rWkty8ZiqLo", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "ab..............", "abO4gfga4XKD.LyaCgObeHxM", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "CC..............", "CCr8qoMD/gdWEs345DTs3Xe.7btteQJYjNE", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "ab..............", "abtb865WlwaOAOQYZhsInLvQ8Y4l28LTy4E", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "CC..............", "CCn9g8mHJ8WxU", "\xc3\xa9tude" },
  { "ab..............", "ab4vjYACxKO9o", "\xc3\xa9tude" },
  { "CC..............", "CCn9g8mHJ8WxU", "C)tude" },
  { "ab..............", "ab4vjYACxKO9o", "C)tude" },
  { "CC..............", "CCRgyVVVpXpM2", "Chl\xc3\xb6""e" },
  { "ab..............", "ab5zWidETSBlE", "Chl\xc3\xb6""e" },
  { "CC..............", "CCRgyVVVpXpM2", "ChlC6e" },
  { "ab..............", "ab5zWidETSBlE", "ChlC6e" },
  { "CC..............", "CCM6/Cpgtljf2J4DCwep/Zag", "\xc3\x85ngstr\xc3\xb6m" },
  { "ab..............", "abaBhSVlHGKLICoBGmfR65Vo", "\xc3\x85ngstr\xc3\xb6m" },
  { "CC..............", "CCM6/Cpgtljf2J4DCwep/Zag", "C\x05ngstrC6m" },
  { "ab..............", "abaBhSVlHGKLICoBGmfR65Vo", "C\x05ngstrC6m" },
  { "CC..............", "CCM6/Cpgtljf2oRwXaoXTsX6", "C\x05ngstrCU*U***U*" },
  { "ab..............", "abaBhSVlHGKLICus5dxoRsnE", "C\x05ngstrCU*U***U*" },
  { "CC..............", "CC4rMpbg9AMZ.Ar0HgE5ZjsA", "U*U***U*ignored" },
  { "ab..............", "abP6zaVz4PU9UGUOi2FoSM6g", "U*U***U*ignored" },
  { "CC..............", "CCNf8Sbh3HDfQ", "U*U*U*U*" },
  { "ab..............", "ab3RlyzKJBvlk", "U*U*U*U*" },
  { "CC..............", "CCNf8Sbh3HDfQZK9ghgqAMOk", "U*U*U*U*ignored" },
  { "ab..............", "ab3RlyzKJBvlkdAuvhqxf7FA", "U*U*U*U*ignored" },
  { "CC..............", "CCr8qoMD/gdWE", "*U*U*U*U" },
  { "ab..............", "abtb865WlwaOA", "*U*U*U*U" },
  { "CC..............", "CCr8qoMD/gdWExB1fA0Sa/mo", "*U*U*U*U*" },
  { "ab..............", "abtb865WlwaOAwvvRoBrx/P6", "*U*U*U*U*" },
  { "CC..............", "CCr8qoMD/gdWEs345DTs3Xe.", "*U*U*U*U*U*U*U*U" },
  { "ab..............", "abtb865WlwaOAOQYZhsInLvQ", "*U*U*U*U*U*U*U*U" },
  { "CC..............", "CCr8qoMD/gdWEs345DTs3Xe.7btteQJYjNE", "*U*U*U*U*U*U*U*U*" },
  { "ab..............", "abtb865WlwaOAOQYZhsInLvQ8Y4l28LTy4E", "*U*U*U*U*U*U*U*U*" },
  { "CC..............", "CCwH9PyRzmVTM", "\xa3" },
  { "ab..............", "abTqKyzTBdcQE", "\xa3" },
  { "CC..............", "CCZYYLpGi1lH.", "\xa3""a" },
  { "ab..............", "ab.Trho55NucA", "\xa3""a" },
  { "CC..............", "CCg211qX.b5cc", "\xd1\x91" },
  { "ab..............", "ab7FZcdAi4gGI", "\xd1\x91" },
  { "CC..............", "CCfPQN0mP.mF2", "\xa3""ab" },
  { "ab..............", "abO6Dh3hnXKYk", "\xa3""ab" },
  { "CC..............", "CC8cOxUkqH1as", "\xff\xff\xa3" },
  { "ab..............", "abiJnZqdV5Bc6", "\xff\xff\xa3" },
  { "CC..............", "CCutL9YOrA9uI", "1\xa3""345" },
  { "ab..............", "abpOcyfwGCZ7M", "1\xa3""345" },
  { "CC..............", "CCkTvRgBmtK4g", "\xff\xa3""345" },
  { "ab..............", "abPUWAfA7vSns", "\xff\xa3""345" },
  { "CC..............", "CCAtHFmg41y9Eu9AKRFbpYQk", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "ab..............", "abI531hjKAdzYsF3zv3/JKvA", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "CC..............", "CC/mlx4OdBiAkPZbn4qnw2.s98xTR2rhjKYv5InzHEygwI595ZBL6Ye7.iTixQ2vPVN2THdrwx78V9Md/xGLgH2V92/OSp159NrLg", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "ab..............", "abD/2HQeVfH5I8cWmIiwP4Fws9AYAuBIBW6q4mdhzX45QsH68uziHZWqYd115a5lk0skcYyXosIcOGkwJasyj1r8bc.wl8x162Y5Q", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "CC..............", "CCr8qoMD/gdWEs345DTs3Xe.EAH9EdGoz/.rJqpyURw0Osp/luMzjS4bMPsQNnZ4aAUckOLiFxloZc.hiMyL1Iw556cAkL3qEJJMU", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "ab..............", "abtb865WlwaOAOQYZhsInLvQp9O81qWm9PwZy0yk4BUz7YewIIWEwqMo.dPPnKRrVqLIZDsnjmQoEGUjQ4bDJ5E8QEtB7/WG4Q0iU", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "CC..............", "CCO7o2HcqNKcw9.JJlsXRKqQGkonR./Wpd.rWKgf6j9IG2p9YpBbZffeYcJRY.7J.s2sV.njh0Chv5EWHwzClcLdGAlIy5w1EnNys", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "ab..............", "ab2wHQ4RTFVKI3cyxPgr4a7QWEHfh0uTWT2qc51R8i0s.6IdtR1Wm8jNEuOnh.8s69TArVpLUfvi/oY7YsOX5N9ej66guo.cYqXoM", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "CC..............", "CCO7o2HcqNKcw9.JJlsXRKqQGkonR./Wpd.rWKgf6j9IG2p9YpBbZffeYcJRY.7J.s2sV.njh0Chv5EWHwzClcLdGAlIy5w1EnNysp6xkV2e9sEEcozN4OMMk1gXPaJvzXHx4gLgtk7nvvacM", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "ab..............", "ab2wHQ4RTFVKI3cyxPgr4a7QWEHfh0uTWT2qc51R8i0s.6IdtR1Wm8jNEuOnh.8s69TArVpLUfvi/oY7YsOX5N9ej66guo.cYqXoM.3.PG6MJ8pUCo7q0zcwnaIjsK3Fo010ewQpOJZ3nqp4A", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "CC..............", "CCddR21tiMaqgXjSVrlYrjAo/BamoDBI/g.5BZCEoYkXEUpkwVGmtI65EohwOE/9qr6swmlKdKJyiz.0oUVMxepYXA5aNlBSF6Yb2", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "ab..............", "abdpmZGWTUFX25HcCgIrC1RkXso4VQuZRBIyHkWmCurMVc7H/xnOtM0DgTNw7akyJaRwBda53dmCRSATwfVqDdlDwwnD2LfcTt8qA", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "CC..............", "CCddR21tiMaqgXjSVrlYrjAo/BamoDBI/g.5BZCEoYkXEUpkwVGmtI65EohwOE/9qr6swmlKdKJyiz.0oUVMxepYXA5aNlBSF6Yb2XirFOcRFPGk0Emf34KI.y6h.jEM31YeWkwkbBiwtUcPAMJ5SxKmhPz6", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "ab..............", "abdpmZGWTUFX25HcCgIrC1RkXso4VQuZRBIyHkWmCurMVc7H/xnOtM0DgTNw7akyJaRwBda53dmCRSATwfVqDdlDwwnD2LfcTt8qAlfDCOQpIe2ogMNDWJdiEdYdxCBXjNMNRoBVTePak5LvcluA/RDQer4Y", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "CC..............", "CC2RU2fzIuOsc7SvrIjqm2ewKbN1P1MJgvU8m36MjoOi4Q/die15s0b1YRrUVJ8qGcFMMaqdVwMqJ.YmgkhrmoHz/A7n.dckZEG3cIM0V/H2s8c6H2pGLAOLAdQwCzV2q8zNs.etSsFg954/oOaf.e11bkUMBOyjbAFu6OEBqZbxzcZSe6", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "ab..............", "ab7TBnHv4ezs2aEcMpSlsQBEuaf.p4Zk6uoS61vP0xzLasZZZ7NzKBXs6VjyhEW0gEW./WnJcMC6bPogRPj1CU7mwEklNG9PzQO1.e1L6Ft5iMXA8LWhVm9D/X6jn.3CdSIwOoxMQcAi0lkDM4fZClNTdP86aDazBFTtdvsVDKw4.azsbE", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "CC..............", "CC2RU2fzIuOsc", "THE YEAR" },
  { "ab..............", "ab7TBnHv4ezs2", "THE YEAR" },
  { "CC..............", "CC2RU2fzIuOsc7SvrIjqm2ewKbN1P1MJgvU8m36MjoOi4Q/die15s0b1YRrUVJ8qGcFMMaqdVwMqJ.YmgkhrmoHz/A7n.dckZEG3c", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "ab..............", "ab7TBnHv4ezs2aEcMpSlsQBEuaf.p4Zk6uoS61vP0xzLasZZZ7NzKBXs6VjyhEW0gEW./WnJcMC6bPogRPj1CU7mwEklNG9PzQO1.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "CC..............", "CC2RU2fzIuOsc7SvrIjqm2ewKbN1P1MJgvU8m36MjoOi4Q/die15s0b1YRrUVJ8qGcFMMaqdVwMqJ.YmgkhrmoHz/A7n.dckZEG3cIM0V/H2s8c6H2pGLAOLAdQwCzV2q8zNs.etSsFg954/oOaf.e11bkUMBOyjbAFu6OEBqZbxzcZSe6", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "ab..............", "ab7TBnHv4ezs2aEcMpSlsQBEuaf.p4Zk6uoS61vP0xzLasZZZ7NzKBXs6VjyhEW0gEW./WnJcMC6bPogRPj1CU7mwEklNG9PzQO1.e1L6Ft5iMXA8LWhVm9D/X6jn.3CdSIwOoxMQcAi0lkDM4fZClNTdP86aDazBFTtdvsVDKw4.azsbE", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // bigcrypt

#if INCLUDE_bsdicrypt && defined TEST_bsdicrypt
  { "_/...CCCC", "_/...CCCCBeguG7nmIew", "" },
  { "_/...abcd", "_/...abcdoj0PMidvoVc", "" },
  { "_B...CCCC", "_B...CCCCBeguG7nmIew", "" },
  { "_B...abcd", "_B...abcdoj0PMidvoVc", "" },
  { "_/...CCCC", "_/...CCCCVHofVuaSR6w", " " },
  { "_/...abcd", "_/...abcdLEZHkDADUl2", " " },
  { "_B...CCCC", "_B...CCCCQDmgBy8nghg", " " },
  { "_B...abcd", "_B...abcdU2HCHlvuzWM", " " },
  { "_/...CCCC", "_/...CCCCTvwHUrPYWbQ", "a" },
  { "_/...abcd", "_/...abcdKkq2nt4mdPo", "a" },
  { "_B...CCCC", "_B...CCCC967A/xgTAhs", "a" },
  { "_B...abcd", "_B...abcdTq40X7Fqj5o", "a" },
  { "_/...CCCC", "_/...CCCCWbyzXNEkZbo", "ab" },
  { "_/...abcd", "_/...abcdFQhyndvCmqw", "ab" },
  { "_B...CCCC", "_B...CCCC1UZb6e1agLQ", "ab" },
  { "_B...abcd", "_B...abcdYXY3mvPund6", "ab" },
  { "_/...CCCC", "_/...CCCC//OWMW4PJcU", "abc" },
  { "_/...abcd", "_/...abcdYkSYkxr7rF6", "abc" },
  { "_B...CCCC", "_B...CCCCqx0iPZT5wZ.", "abc" },
  { "_B...abcd", "_B...abcdbvwQNHyg.Zk", "abc" },
  { "_/...CCCC", "_/...CCCCCGHlkLDPnfs", "U*U" },
  { "_/...abcd", "_/...abcd97DycduxF16", "U*U" },
  { "_B...CCCC", "_B...CCCCYfQkIvgs0Rs", "U*U" },
  { "_B...abcd", "_B...abcd.9SgPxFi5w.", "U*U" },
  { "_/...CCCC", "_/...CCCCqaRcwwjiK3E", "U*U*" },
  { "_/...abcd", "_/...abcdHTF2GmmTF8I", "U*U*" },
  { "_B...CCCC", "_B...CCCCfNkdhjXezoo", "U*U*" },
  { "_B...abcd", "_B...abcdxB8ez8kkKRw", "U*U*" },
  { "_/...CCCC", "_/...CCCCIwIeyIq23gc", "U*U*U" },
  { "_/...abcd", "_/...abcdaV0BQEXXcic", "U*U*U" },
  { "_B...CCCC", "_B...CCCCt6tYbPIIepw", "U*U*U" },
  { "_B...abcd", "_B...abcdacWDzLDRATQ", "U*U*U" },
  { "_/...CCCC", "_/...CCCCF5fZ5vt.Y2g", "....." },
  { "_/...abcd", "_/...abcd5YiZ7LritzU", "....." },
  { "_B...CCCC", "_B...CCCCRi6lsA0puUw", "....." },
  { "_B...abcd", "_B...abcdfIEOZrkcKng", "....." },
  { "_/...CCCC", "_/...CCCCqSuIwqhxkds", "dragon" },
  { "_/...abcd", "_/...abcd2ZORBubFtYY", "dragon" },
  { "_B...CCCC", "_B...CCCCq45bbAMDyns", "dragon" },
  { "_B...abcd", "_B...abcd8F9wugwUEUU", "dragon" },
  { "_/...CCCC", "_/...CCCCS1p6b/YyVJ.", "dRaGoN" },
  { "_/...abcd", "_/...abcd/RKLgaWc97E", "dRaGoN" },
  { "_B...CCCC", "_B...CCCCtaq1OLOOZEY", "dRaGoN" },
  { "_B...abcd", "_B...abcdRshIla4rkYg", "dRaGoN" },
  { "_/...CCCC", "_/...CCCCMwyyu.b.0xE", "DrAgOn" },
  { "_/...abcd", "_/...abcdQWTtT/Xf7Os", "DrAgOn" },
  { "_B...CCCC", "_B...CCCCDzlOeJ2lpHA", "DrAgOn" },
  { "_B...abcd", "_B...abcdcw7r5Sl6xws", "DrAgOn" },
  { "_/...CCCC", "_/...CCCCOyVbAQbxTXw", "PAROLX" },
  { "_/...abcd", "_/...abcdgn9mlSB8mWw", "PAROLX" },
  { "_B...CCCC", "_B...CCCCciBqCA67jaY", "PAROLX" },
  { "_B...abcd", "_B...abcd73xKpZTZvTk", "PAROLX" },
  { "_/...CCCC", "_/...CCCCMToupEDpXE6", "U*U***U" },
  { "_/...abcd", "_/...abcdWvB2Q73W0B2", "U*U***U" },
  { "_B...CCCC", "_B...CCCCYdoTwmOvqqU", "U*U***U" },
  { "_B...abcd", "_B...abcdmDfkfahfZUY", "U*U***U" },
  { "_/...CCCC", "_/...CCCC1qEXrVUrwF2", "abcdefg" },
  { "_/...abcd", "_/...abcd6jFhVxJKwFg", "abcdefg" },
  { "_B...CCCC", "_B...CCCCrX71Rb7lmQA", "abcdefg" },
  { "_B...abcd", "_B...abcdf66uYqtupCk", "abcdefg" },
  { "_/...CCCC", "_/...CCCCuIpWCn4xDDg", "01234567" },
  { "_/...abcd", "_/...abcdLV13lYRdOx2", "01234567" },
  { "_B...CCCC", "_B...CCCCtZy/Om476tQ", "01234567" },
  { "_B...abcd", "_B...abcdYMY6dr0pSo2", "01234567" },
  { "_/...CCCC", "_/...CCCCfvGU5U5/3Ag", "726 even" },
  { "_/...abcd", "_/...abcdoRlYhFP6gX2", "726 even" },
  { "_B...CCCC", "_B...CCCCp9U8qH6KYyM", "726 even" },
  { "_B...abcd", "_B...abcdDhNfVRGwuBY", "726 even" },
  { "_/...CCCC", "_/...CCCCNnL0sFtBG/A", "zyxwvuts" },
  { "_/...abcd", "_/...abcdW22LfMmtHI.", "zyxwvuts" },
  { "_B...CCCC", "_B...CCCC5v4AmBG06Fg", "zyxwvuts" },
  { "_B...abcd", "_B...abcdYeK/oCxtyR2", "zyxwvuts" },
  { "_/...CCCC", "_/...CCCCuh2hDE2UEZQ", "ab1234567" },
  { "_/...abcd", "_/...abcd4soDPqn3.Eg", "ab1234567" },
  { "_B...CCCC", "_B...CCCCTMTOl/1Ih1M", "ab1234567" },
  { "_B...abcd", "_B...abcd/baGunX9paw", "ab1234567" },
  { "_/...CCCC", "_/...CCCCN18ifu91Z3Q", "alexander" },
  { "_/...abcd", "_/...abcdWu/d1.77uJE", "alexander" },
  { "_B...CCCC", "_B...CCCCX1xtoXIJ/zE", "alexander" },
  { "_B...abcd", "_B...abcd0DnTwzHvkHg", "alexander" },
  { "_/...CCCC", "_/...CCCCE/LOBAaEB2o", "beautiful" },
  { "_/...abcd", "_/...abcdJR1KkREntJM", "beautiful" },
  { "_B...CCCC", "_B...CCCCgsyFERc4f8Y", "beautiful" },
  { "_B...abcd", "_B...abcd31iralny5.c", "beautiful" },
  { "_/...CCCC", "_/...CCCCvQGKpbY8sRI", "challenge" },
  { "_/...abcd", "_/...abcdxeQKPXEWSU6", "challenge" },
  { "_B...CCCC", "_B...CCCCzPUz2J2CAeM", "challenge" },
  { "_B...abcd", "_B...abcdKP7e72UE/2I", "challenge" },
  { "_/...CCCC", "_/...CCCCrEIkl1HOZRc", "chocolate" },
  { "_/...abcd", "_/...abcddaQ941FqVig", "chocolate" },
  { "_B...CCCC", "_B...CCCCU/ua7R/UQQU", "chocolate" },
  { "_B...abcd", "_B...abcdru8w6IGYSzE", "chocolate" },
  { "_/...CCCC", "_/...CCCCtnw4Z9jZeOk", "cr1234567" },
  { "_/...abcd", "_/...abcdWPgHGVKg1cE", "cr1234567" },
  { "_B...CCCC", "_B...CCCCsE3lTU4mtgU", "cr1234567" },
  { "_B...abcd", "_B...abcd99E4bpp3jI6", "cr1234567" },
  { "_/...CCCC", "_/...CCCCkAD94zn1vyw", "katherine" },
  { "_/...abcd", "_/...abcd/HYgt1AYf9E", "katherine" },
  { "_B...CCCC", "_B...CCCCCy4qUrxHuIE", "katherine" },
  { "_B...abcd", "_B...abcdfrfbpb6Gv6Q", "katherine" },
  { "_/...CCCC", "_/...CCCCmQFknxgqJSA", "stephanie" },
  { "_/...abcd", "_/...abcdfTYpn4PZyFA", "stephanie" },
  { "_B...CCCC", "_B...CCCC7UCwyT8UrfU", "stephanie" },
  { "_B...abcd", "_B...abcd1Gd2yx3rFg6", "stephanie" },
  { "_/...CCCC", "_/...CCCC4bAcKLVxz1A", "sunflower" },
  { "_/...abcd", "_/...abcdVr9y8Ld42PI", "sunflower" },
  { "_B...CCCC", "_B...CCCCzLHgNhzuqVo", "sunflower" },
  { "_B...abcd", "_B...abcdb82.WKSkFxc", "sunflower" },
  { "_/...CCCC", "_/...CCCCIrAChAiWQkc", "basketball" },
  { "_/...abcd", "_/...abcdeS19gzBKY9Y", "basketball" },
  { "_B...CCCC", "_B...CCCCfU5bEsT2imA", "basketball" },
  { "_B...abcd", "_B...abcd6ImZPdQTzdg", "basketball" },
  { "_/...CCCC", "_/...CCCCWzz9JY4flUs", "porsche911" },
  { "_/...abcd", "_/...abcdAS3sgaZRtcs", "porsche911" },
  { "_B...CCCC", "_B...CCCCAETQUzGQm2.", "porsche911" },
  { "_B...abcd", "_B...abcdL1X2K8TR9T6", "porsche911" },
  { "_/...CCCC", "_/...CCCCHuv0KKrlCPI", "|_337T`/p3" },
  { "_/...abcd", "_/...abcd4ljnAIDBnlc", "|_337T`/p3" },
  { "_B...CCCC", "_B...CCCCNUdpKh1GhaQ", "|_337T`/p3" },
  { "_B...abcd", "_B...abcdqUSPUtBHBPM", "|_337T`/p3" },
  { "_/...CCCC", "_/...CCCCG14pqzCgI6E", "thunderbird" },
  { "_/...abcd", "_/...abcdl6Vc18JcUPQ", "thunderbird" },
  { "_B...CCCC", "_B...CCCCv6O7qtLKxas", "thunderbird" },
  { "_B...abcd", "_B...abcdrbVYYU9qYuk", "thunderbird" },
  { "_/...CCCC", "_/...CCCCAlnEgHaLlwM", "Hello world!" },
  { "_/...abcd", "_/...abcdp8WwWTf1aFI", "Hello world!" },
  { "_B...CCCC", "_B...CCCCJkJWYfPNHOI", "Hello world!" },
  { "_B...abcd", "_B...abcdBgZI0LAA2uo", "Hello world!" },
  { "_/...CCCC", "_/...CCCCT5ofitrBHDM", "pleaseletmein" },
  { "_/...abcd", "_/...abcdQQDF9VfzUpk", "pleaseletmein" },
  { "_B...CCCC", "_B...CCCC91UX9Wr2wj2", "pleaseletmein" },
  { "_B...abcd", "_B...abcdiEY2njmAvDs", "pleaseletmein" },
  { "_/...CCCC", "_/...CCCC/d9D8rYeVbA", "a short string" },
  { "_/...abcd", "_/...abcdZ9IAxyf8y9s", "a short string" },
  { "_B...CCCC", "_B...CCCCiLFjawTSDBY", "a short string" },
  { "_B...abcd", "_B...abcdHjdgGQuMd9o", "a short string" },
  { "_/...CCCC", "_/...CCCCCa.WizTe/zo", "zxyDPWgydbQjgq" },
  { "_/...abcd", "_/...abcdDNQYpuvlGy2", "zxyDPWgydbQjgq" },
  { "_B...CCCC", "_B...CCCCL7S9y/wTFxY", "zxyDPWgydbQjgq" },
  { "_B...abcd", "_B...abcdTLnmbqTDeSU", "zxyDPWgydbQjgq" },
  { "_/...CCCC", "_/...CCCCxTuhwE4k3c2", "photojournalism" },
  { "_/...abcd", "_/...abcd8Tl/FO/i2HY", "photojournalism" },
  { "_B...CCCC", "_B...CCCCu4oEMKvaNFI", "photojournalism" },
  { "_B...abcd", "_B...abcdW81LtS9at3.", "photojournalism" },
  { "_/...CCCC", "_/...CCCCgT7d4pE/Viw", "ecclesiastically" },
  { "_/...abcd", "_/...abcdvsSzrxanBvA", "ecclesiastically" },
  { "_B...CCCC", "_B...CCCCvbOfNfifyJw", "ecclesiastically" },
  { "_B...abcd", "_B...abcdZiCTo6VHHUw", "ecclesiastically" },
  { "_/...CCCC", "_/...CCCCD34AMsBSZ/o", "congregationalism" },
  { "_/...abcd", "_/...abcdEng7LU93Q3.", "congregationalism" },
  { "_B...CCCC", "_B...CCCCQQD4a860swI", "congregationalism" },
  { "_B...abcd", "_B...abcdGkcC7.2WqWI", "congregationalism" },
  { "_/...CCCC", "_/...CCCCsTqgvVPEHoU", "dihydrosphingosine" },
  { "_/...abcd", "_/...abcdqmltYy4Vc8s", "dihydrosphingosine" },
  { "_B...CCCC", "_B...CCCC9ZsLq14kpZ.", "dihydrosphingosine" },
  { "_B...abcd", "_B...abcdhG/je5XQQuw", "dihydrosphingosine" },
  { "_/...CCCC", "_/...CCCCbprZDw13EVA", "semianthropological" },
  { "_/...abcd", "_/...abcd5ELmFKFCXLM", "semianthropological" },
  { "_B...CCCC", "_B...CCCCXIMdWSafrR2", "semianthropological" },
  { "_B...abcd", "_B...abcdc3EEwZy11VQ", "semianthropological" },
  { "_/...CCCC", "_/...CCCCHO9C/P8bTQY", "palaeogeographically" },
  { "_/...abcd", "_/...abcdzXoE/sq1Prg", "palaeogeographically" },
  { "_B...CCCC", "_B...CCCC1Kwifqw9uGI", "palaeogeographically" },
  { "_B...abcd", "_B...abcdDdTVPNkCg/M", "palaeogeographically" },
  { "_/...CCCC", "_/...CCCCXMRnlxA3rsE", "electromyographically" },
  { "_/...abcd", "_/...abcdlH84PIScV7M", "electromyographically" },
  { "_B...CCCC", "_B...CCCCsRgPjD5SvTs", "electromyographically" },
  { "_B...abcd", "_B...abcdnc1FQpVWaSs", "electromyographically" },
  { "_/...CCCC", "_/...CCCC3DotYDlSnKo", "noninterchangeableness" },
  { "_/...abcd", "_/...abcd01yLN5G3hoI", "noninterchangeableness" },
  { "_B...CCCC", "_B...CCCCISj.TCHd/Ys", "noninterchangeableness" },
  { "_B...abcd", "_B...abcdrbv3wJfw4gM", "noninterchangeableness" },
  { "_/...CCCC", "_/...CCCCLy4NuWhfRTk", "abcdefghijklmnopqrstuvwxyz" },
  { "_/...abcd", "_/...abcd99ziiSM8aJI", "abcdefghijklmnopqrstuvwxyz" },
  { "_B...CCCC", "_B...CCCCKE2r9XSTXHE", "abcdefghijklmnopqrstuvwxyz" },
  { "_B...abcd", "_B...abcdI3kkuuHXz6w", "abcdefghijklmnopqrstuvwxyz" },
  { "_/...CCCC", "_/...CCCC6FgpGecPxKg", "electroencephalographically" },
  { "_/...abcd", "_/...abcdmKAUeZlWWr6", "electroencephalographically" },
  { "_B...CCCC", "_B...CCCCvk4oCFTH5qQ", "electroencephalographically" },
  { "_B...abcd", "_B...abcdzEfhuxbzTuk", "electroencephalographically" },
  { "_/...CCCC", "_/...CCCCbZ548uMFpz.", "antidisestablishmentarianism" },
  { "_/...abcd", "_/...abcdGphkdzix4L6", "antidisestablishmentarianism" },
  { "_B...CCCC", "_B...CCCC1bo6xasE8u2", "antidisestablishmentarianism" },
  { "_B...abcd", "_B...abcdYURKTmfYk3M", "antidisestablishmentarianism" },
  { "_/...CCCC", "_/...CCCCNAqf./ywd.c", "cyclotrimethylenetrinitramine" },
  { "_/...abcd", "_/...abcdgYwPgw1zr/I", "cyclotrimethylenetrinitramine" },
  { "_B...CCCC", "_B...CCCCKDG7alWIUlc", "cyclotrimethylenetrinitramine" },
  { "_B...abcd", "_B...abcd90v9Pne/2vg", "cyclotrimethylenetrinitramine" },
  { "_/...CCCC", "_/...CCCCnE8DuCyvO6c", "dichlorodiphenyltrichloroethane" },
  { "_/...abcd", "_/...abcdEzf9dIUGrbw", "dichlorodiphenyltrichloroethane" },
  { "_B...CCCC", "_B...CCCCYzEYe86tFpY", "dichlorodiphenyltrichloroethane" },
  { "_B...abcd", "_B...abcdN8QPNXzMj1M", "dichlorodiphenyltrichloroethane" },
  { "_/...CCCC", "_/...CCCCfd5wkcUh9Cs", "multiple words seperated by spaces" },
  { "_/...abcd", "_/...abcdTSPjuGt3EjQ", "multiple words seperated by spaces" },
  { "_B...CCCC", "_B...CCCCldyIeEqyS36", "multiple words seperated by spaces" },
  { "_B...abcd", "_B...abcdDo7mF7Z4irU", "multiple words seperated by spaces" },
  { "_/...CCCC", "_/...CCCCQohbLW1KjQE", "supercalifragilisticexpialidocious" },
  { "_/...abcd", "_/...abcdZajK9EJp11k", "supercalifragilisticexpialidocious" },
  { "_B...CCCC", "_B...CCCC7zqAeEYr99Y", "supercalifragilisticexpialidocious" },
  { "_B...abcd", "_B...abcdOKtLi2Hl7kY", "supercalifragilisticexpialidocious" },
  { "_/...CCCC", "_/...CCCCw6rjvmlD1hA", "we have a short salt string but not a short password" },
  { "_/...abcd", "_/...abcd/og8TpJvzAw", "we have a short salt string but not a short password" },
  { "_B...CCCC", "_B...CCCCZryeaXSvtzo", "we have a short salt string but not a short password" },
  { "_B...abcd", "_B...abcdmNlZ8iWNgIg", "we have a short salt string but not a short password" },
  { "_/...CCCC", "_/...CCCCVdtcJAFlK/M", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "_/...abcd", "_/...abcdTGETkK9kn1k", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "_B...CCCC", "_B...CCCC1g0udxbmRE2", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "_B...abcd", "_B...abcdY/AV1NlXi0Y", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "_/...CCCC", "_/...CCCCWEsepchdmMg", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "_/...abcd", "_/...abcdIjQl65Lih1A", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "_B...CCCC", "_B...CCCCWHl.4Q5ZOEs", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "_B...abcd", "_B...abcdMVExl294Kd.", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "_/...CCCC", "_/...CCCCj2jmHCAaBjo", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "_/...abcd", "_/...abcdGUK83lhrwik", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "_B...CCCC", "_B...CCCCOdAJ6xJLX/o", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "_B...abcd", "_B...abcdrQpQTSytOBs", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "_/...CCCC", "_/...CCCC1CPl3OBmy0w", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "_/...abcd", "_/...abcdgzlOwIfyQPA", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "_B...CCCC", "_B...CCCCszCdbPLEKkw", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "_B...abcd", "_B...abcdeHtnuHvk6z.", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "_/...CCCC", "_/...CCCCOyVbAQbxTXw", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "_/...abcd", "_/...abcdgn9mlSB8mWw", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "_B...CCCC", "_B...CCCCciBqCA67jaY", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "_B...abcd", "_B...abcd73xKpZTZvTk", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "_/...CCCC", "_/...CCCCf.ha3A6AlE6", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "_/...abcd", "_/...abcdwYSh45VDTgc", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "_B...CCCC", "_B...CCCCfRP64097qJQ", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "_B...abcd", "_B...abcdi555w3aRRUM", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "_/...CCCC", "_/...CCCCN18ifu91Z3Q", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "_/...abcd", "_/...abcdWu/d1.77uJE", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "_B...CCCC", "_B...CCCCX1xtoXIJ/zE", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "_B...abcd", "_B...abcd0DnTwzHvkHg", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "_/...CCCC", "_/...CCCCmQFknxgqJSA", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "_/...abcd", "_/...abcdfTYpn4PZyFA", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "_B...CCCC", "_B...CCCC7UCwyT8UrfU", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "_B...abcd", "_B...abcd1Gd2yx3rFg6", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "_/...CCCC", "_/...CCCCf//DLBYyJMU", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "_/...abcd", "_/...abcdwJgzAwQgoNc", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "_B...CCCC", "_B...CCCCO6z7UViseDU", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "_B...abcd", "_B...abcd.FvEj1rW/UM", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "_/...CCCC", "_/...CCCCIrNSleSGrAU", "\xc3\xa9tude" },
  { "_/...abcd", "_/...abcdezBVbMgQK0w", "\xc3\xa9tude" },
  { "_B...CCCC", "_B...CCCCrP2p4rL84HE", "\xc3\xa9tude" },
  { "_B...abcd", "_B...abcdIz8/KfzGFl.", "\xc3\xa9tude" },
  { "_/...CCCC", "_/...CCCCIrNSleSGrAU", "C)tude" },
  { "_/...abcd", "_/...abcdezBVbMgQK0w", "C)tude" },
  { "_B...CCCC", "_B...CCCCrP2p4rL84HE", "C)tude" },
  { "_B...abcd", "_B...abcdIz8/KfzGFl.", "C)tude" },
  { "_/...CCCC", "_/...CCCCNCR4z9/J5v2", "Chl\xc3\xb6""e" },
  { "_/...abcd", "_/...abcdZQEk8g4rxpU", "Chl\xc3\xb6""e" },
  { "_B...CCCC", "_B...CCCCICvqPQjdeOs", "Chl\xc3\xb6""e" },
  { "_B...abcd", "_B...abcdnNfT0CunTfw", "Chl\xc3\xb6""e" },
  { "_/...CCCC", "_/...CCCCNCR4z9/J5v2", "ChlC6e" },
  { "_/...abcd", "_/...abcdZQEk8g4rxpU", "ChlC6e" },
  { "_B...CCCC", "_B...CCCCICvqPQjdeOs", "ChlC6e" },
  { "_B...abcd", "_B...abcdnNfT0CunTfw", "ChlC6e" },
  { "_/...CCCC", "_/...CCCCLAnu2LMWrn6", "\xc3\x85ngstr\xc3\xb6m" },
  { "_/...abcd", "_/...abcdobTsvviP/3k", "\xc3\x85ngstr\xc3\xb6m" },
  { "_B...CCCC", "_B...CCCC0D8JPFOSneE", "\xc3\x85ngstr\xc3\xb6m" },
  { "_B...abcd", "_B...abcdrcZ5N..M/OM", "\xc3\x85ngstr\xc3\xb6m" },
  { "_/...CCCC", "_/...CCCCLAnu2LMWrn6", "C\x05ngstrC6m" },
  { "_/...abcd", "_/...abcdobTsvviP/3k", "C\x05ngstrC6m" },
  { "_B...CCCC", "_B...CCCC0D8JPFOSneE", "C\x05ngstrC6m" },
  { "_B...abcd", "_B...abcdrcZ5N..M/OM", "C\x05ngstrC6m" },
  { "_/...CCCC", "_/...CCCCtnJ8cCo.3zM", "C\x05ngstrCU*U***U*" },
  { "_/...abcd", "_/...abcdxcMJ4rXbM9A", "C\x05ngstrCU*U***U*" },
  { "_B...CCCC", "_B...CCCC4f/Jm9JWuiI", "C\x05ngstrCU*U***U*" },
  { "_B...abcd", "_B...abcdZZ3FoMqo/fU", "C\x05ngstrCU*U***U*" },
  { "_/...CCCC", "_/...CCCCAJ3mNbmiHno", "U*U***U*ignored" },
  { "_/...abcd", "_/...abcdQsIF/0O3j8o", "U*U***U*ignored" },
  { "_B...CCCC", "_B...CCCCqpxkiIrevrg", "U*U***U*ignored" },
  { "_B...abcd", "_B...abcdY5.r.59htLA", "U*U***U*ignored" },
  { "_/...CCCC", "_/...CCCCHBolZ/cIO2.", "U*U*U*U*" },
  { "_/...abcd", "_/...abcdE9xumTAImPc", "U*U*U*U*" },
  { "_B...CCCC", "_B...CCCCqMC/M8JYgQQ", "U*U*U*U*" },
  { "_B...abcd", "_B...abcdDw27Hu8t7vI", "U*U*U*U*" },
  { "_/...CCCC", "_/...CCCC83SohZDUyuM", "U*U*U*U*ignored" },
  { "_/...abcd", "_/...abcdzIRDXyWsFMs", "U*U*U*U*ignored" },
  { "_B...CCCC", "_B...CCCCNZ46e2ZQlq.", "U*U*U*U*ignored" },
  { "_B...abcd", "_B...abcdpo64mjPxzvM", "U*U*U*U*ignored" },
  { "_/...CCCC", "_/...CCCCWwLAdDLAlqU", "*U*U*U*U" },
  { "_/...abcd", "_/...abcd32gqx.9DhNY", "*U*U*U*U" },
  { "_B...CCCC", "_B...CCCCFytsW43tAPc", "*U*U*U*U" },
  { "_B...abcd", "_B...abcdWIJ23vb0VYY", "*U*U*U*U" },
  { "_/...CCCC", "_/...CCCC1t6b8imrh7.", "*U*U*U*U*" },
  { "_/...abcd", "_/...abcdFBV2KHxgnJU", "*U*U*U*U*" },
  { "_B...CCCC", "_B...CCCC7zMLShIGmes", "*U*U*U*U*" },
  { "_B...abcd", "_B...abcdYoxn5ShdX1.", "*U*U*U*U*" },
  { "_/...CCCC", "_/...CCCCOI9YZn/9qq.", "*U*U*U*U*U*U*U*U" },
  { "_/...abcd", "_/...abcdq/kBDDh1pFg", "*U*U*U*U*U*U*U*U" },
  { "_B...CCCC", "_B...CCCC9VsCmAIVNAI", "*U*U*U*U*U*U*U*U" },
  { "_B...abcd", "_B...abcd6k74YyhApEU", "*U*U*U*U*U*U*U*U" },
  { "_/...CCCC", "_/...CCCCf//DLBYyJMU", "*U*U*U*U*U*U*U*U*" },
  { "_/...abcd", "_/...abcdwJgzAwQgoNc", "*U*U*U*U*U*U*U*U*" },
  { "_B...CCCC", "_B...CCCCO6z7UViseDU", "*U*U*U*U*U*U*U*U*" },
  { "_B...abcd", "_B...abcd.FvEj1rW/UM", "*U*U*U*U*U*U*U*U*" },
  { "_/...CCCC", "_/...CCCCWfYoiTx6C4k", "\xa3" },
  { "_/...abcd", "_/...abcdpjvjs1/CK9M", "\xa3" },
  { "_B...CCCC", "_B...CCCC6mv7.mqDSWM", "\xa3" },
  { "_B...abcd", "_B...abcd9vcuX17ZKQM", "\xa3" },
  { "_/...CCCC", "_/...CCCCwf2kZE/5XSk", "\xa3""a" },
  { "_/...abcd", "_/...abcd0fl0VsRHBl2", "\xa3""a" },
  { "_B...CCCC", "_B...CCCCGhg85Fw0nuU", "\xa3""a" },
  { "_B...abcd", "_B...abcdDmwRvC2gx2c", "\xa3""a" },
  { "_/...CCCC", "_/...CCCC96w6ooDlSgk", "\xd1\x91" },
  { "_/...abcd", "_/...abcdPEGrYCRYQ4A", "\xd1\x91" },
  { "_B...CCCC", "_B...CCCCorJXnoXlg22", "\xd1\x91" },
  { "_B...abcd", "_B...abcdKj9MRtC9gfE", "\xd1\x91" },
  { "_/...CCCC", "_/...CCCCgKEz7Km9Af6", "\xa3""ab" },
  { "_/...abcd", "_/...abcd9skGqMXuOMI", "\xa3""ab" },
  { "_B...CCCC", "_B...CCCCj7WBOKCRAdA", "\xa3""ab" },
  { "_B...abcd", "_B...abcd0d0WtNaDq/Q", "\xa3""ab" },
  { "_/...CCCC", "_/...CCCCJSgJw/3uDc.", "\xff\xff\xa3" },
  { "_/...abcd", "_/...abcdbqKxdmFmTTo", "\xff\xff\xa3" },
  { "_B...CCCC", "_B...CCCC5Vcxf9knCr2", "\xff\xff\xa3" },
  { "_B...abcd", "_B...abcdts1BGqqdCoI", "\xff\xff\xa3" },
  { "_/...CCCC", "_/...CCCCCV6VaZRDapg", "1\xa3""345" },
  { "_/...abcd", "_/...abcdF/oeA2QzhNE", "1\xa3""345" },
  { "_B...CCCC", "_B...CCCCk9FNkKv87g6", "1\xa3""345" },
  { "_B...abcd", "_B...abcdfZojC31y3M2", "1\xa3""345" },
  { "_/...CCCC", "_/...CCCCPy4k/ab3P4U", "\xff\xa3""345" },
  { "_/...abcd", "_/...abcdVGDgkxePVgk", "\xff\xa3""345" },
  { "_B...CCCC", "_B...CCCCR20qfTcbOmk", "\xff\xa3""345" },
  { "_B...abcd", "_B...abcdkN.76rSsn3M", "\xff\xa3""345" },
  { "_/...CCCC", "_/...CCCCbOgFif1W21o", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "_/...abcd", "_/...abcdInpCH72mumM", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "_B...CCCC", "_B...CCCCxo3D/g7TQ4U", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "_B...abcd", "_B...abcdhAvj.atD1Ro", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "_/...CCCC", "_/...CCCCCgoxx8JH4nU", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "_/...abcd", "_/...abcdBFIGRJ7nTC6", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "_B...CCCC", "_B...CCCCKwGgfbWFM2w", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "_B...abcd", "_B...abcdydXuqMqLDTA", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "_/...CCCC", "_/...CCCCf0Dq2rnmjyE", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "_/...abcd", "_/...abcdNqj2pLcQCIs", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "_B...CCCC", "_B...CCCCwMu3fbiD6Ps", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "_B...abcd", "_B...abcdbwY0XWYUiIE", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "_/...CCCC", "_/...CCCChh18zOEj2I.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "_/...abcd", "_/...abcdzhT0k99wsyw", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "_B...CCCC", "_B...CCCC9L9SrjKUHUw", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "_B...abcd", "_B...abcdPerVNjIHgcI", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "_/...CCCC", "_/...CCCCBQOmoWLUSwc", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "_/...abcd", "_/...abcdpDS9tO8bBy6", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "_B...CCCC", "_B...CCCCRvxv4EXcbak", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "_B...abcd", "_B...abcd9m2IxfC3gSE", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "_/...CCCC", "_/...CCCC314jfbWa8nk", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "_/...abcd", "_/...abcd1MfrH9pD3ik", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "_B...CCCC", "_B...CCCCmtzL2gX5gLQ", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "_B...abcd", "_B...abcdUbPKEiaFUXw", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "_/...CCCC", "_/...CCCCJPJX36vYR.I", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "_/...abcd", "_/...abcdhxm0.K3aBNs", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "_B...CCCC", "_B...CCCC61eHvZQ80Z.", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "_B...abcd", "_B...abcdQ.TCe07hQYY", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "_/...CCCC", "_/...CCCCotFKYQijdBQ", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "_/...abcd", "_/...abcdfglVkBExi8U", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "_B...CCCC", "_B...CCCCRiZfxAVj2yU", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "_B...abcd", "_B...abcdEYqapacaAYs", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "_/...CCCC", "_/...CCCCUELtB3Fru9g", "THE YEAR" },
  { "_/...abcd", "_/...abcdw6dwjS9jP1Y", "THE YEAR" },
  { "_B...CCCC", "_B...CCCCh2RbaCahLzU", "THE YEAR" },
  { "_B...abcd", "_B...abcdQx0zygxMhZs", "THE YEAR" },
  { "_/...CCCC", "_/...CCCCy0pVqCLVn2o", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "_/...abcd", "_/...abcd2VeQzRb/CRw", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "_B...CCCC", "_B...CCCCq3yznjfxdu6", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "_B...abcd", "_B...abcdFvVe3CG2rcw", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "_/...CCCC", "_/...CCCC3P3XpjNKeAs", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "_/...abcd", "_/...abcdVZdYUgXYPWM", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "_B...CCCC", "_B...CCCCSqu8dXTjc5Q", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "_B...abcd", "_B...abcdbJQyCuuvcgI", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // bsdicrypt

#if INCLUDE_descrypt && defined TEST_descrypt
  { "CC", "CCHYKxYMMLQN2", "" },
  { "ab", "abmF1QH4PEr.E", "" },
  { "CC", "CCcePb2UhZY96", " " },
  { "ab", "ab3nfvqkpDCz6", " " },
  { "CC", "CCu3ZS/UCwMaA", "a" },
  { "ab", "abxxB7HlIeckU", "a" },
  { "CC", "CC0MiZNhf/ACw", "ab" },
  { "ab", "abAwh7.RciMzE", "ab" },
  { "CC", "CCQ4IySE25HV2", "abc" },
  { "ab", "abFZSxKKdq5s6", "abc" },
  { "CC", "CCHc6HsfCQ5t6", "U*U" },
  { "ab", "abCY/CHNnliwA", "U*U" },
  { "CC", "CCmOvmGnYgIOQ", "U*U*" },
  { "ab", "abrP9hatwxlsc", "U*U*" },
  { "CC", "CCzd9NlE45556", "U*U*U" },
  { "ab", "ab9YovNfzixZE", "U*U*U" },
  { "CC", "CCvbcTIyRnP1s", "....." },
  { "ab", "abQcwGqfvDF4U", "....." },
  { "CC", "CCcMgHKAHJ1SA", "dragon" },
  { "ab", "ab6Gj9YvrF2As", "dragon" },
  { "CC", "CCK5kzKL/XuQY", "dRaGoN" },
  { "ab", "abmNlUI1COvYE", "dRaGoN" },
  { "CC", "CCRDslM6u7nAk", "DrAgOn" },
  { "ab", "abUqB6rDk72W2", "DrAgOn" },
  { "CC", "CCUj.vcbp0YcQ", "PAROLX" },
  { "ab", "ab2mSJsfAaEYc", "PAROLX" },
  { "CC", "CCX.K.MFy4Ois", "U*U***U" },
  { "ab", "abRk/fdtGCS02", "U*U***U" },
  { "CC", "CC457075f2366", "abcdefg" },
  { "ab", "abJ1KhM1sjlUo", "abcdefg" },
  { "CC", "CCO7o2HcqNKcw", "01234567" },
  { "ab", "ab2wHQ4RTFVKI", "01234567" },
  { "CC", "CCBsM2N7uDf4I", "726 even" },
  { "ab", "abvP7wxxQ4tog", "726 even" },
  { "CC", "CCOGSgC4qjcA2", "zyxwvuts" },
  { "ab", "abbEulwxH3FHA", "zyxwvuts" },
  { "CC", "CCVTQupjkvqPY", "ab1234567" },
  { "ab", "abnYLVrXaFJ5w", "ab1234567" },
  { "CC", "CCk4Onp6WTPTY", "alexander" },
  { "ab", "ab76vmlPVRy5Q", "alexander" },
  { "CC", "CCoUdX6WyGKgs", "beautiful" },
  { "ab", "abwfsjWX4EyO.", "beautiful" },
  { "CC", "CC9P2ZjaWPiSQ", "challenge" },
  { "ab", "abNf5XM5DhRJs", "challenge" },
  { "CC", "CCFkZ6ziYuRO2", "chocolate" },
  { "ab", "ab5g9v/XGNiAQ", "chocolate" },
  { "CC", "CCNbsdP6Epo2.", "cr1234567" },
  { "ab", "abxR5d2mWY2Gg", "cr1234567" },
  { "CC", "CCOwLOT2cAuVI", "katherine" },
  { "ab", "abzBVZ7aWUKM6", "katherine" },
  { "CC", "CCoLp0sLZdas2", "stephanie" },
  { "ab", "abO4gfga4XKD.", "stephanie" },
  { "CC", "CCZrXpzITbV1k", "sunflower" },
  { "ab", "ab48pizZvB/R2", "sunflower" },
  { "CC", "CC6fdwBHH3atw", "basketball" },
  { "ab", "abJqfe.5maUGk", "basketball" },
  { "CC", "CCJa7tMefq.rw", "porsche911" },
  { "ab", "abAXo0qGhDad2", "porsche911" },
  { "CC", "CCiwAFQV9a8P2", "|_337T`/p3" },
  { "ab", "abhOzUBEprC2M", "|_337T`/p3" },
  { "CC", "CCUIVkP6RhPU.", "thunderbird" },
  { "ab", "abqhNEbBQBA3s", "thunderbird" },
  { "CC", "CC.FXhmgF9eGU", "Hello world!" },
  { "ab", "abMbH7WsHr7wQ", "Hello world!" },
  { "CC", "CCBkhrj5Ptwl6", "pleaseletmein" },
  { "ab", "ab/DEQq.fnuz6", "pleaseletmein" },
  { "CC", "CCL8hSYYbUTgs", "a short string" },
  { "ab", "abgpCbJjOvjuo", "a short string" },
  { "CC", "CCzCSKYTyC2JE", "zxyDPWgydbQjgq" },
  { "ab", "abfcHW3Eqw9a6", "zxyDPWgydbQjgq" },
  { "CC", "CCedg2FJ0iNYI", "photojournalism" },
  { "ab", "abZW.Bx7lmec.", "photojournalism" },
  { "CC", "CC9rjRlxb4hYI", "ecclesiastically" },
  { "ab", "abWR9L6FAAjBU", "ecclesiastically" },
  { "CC", "CCdDDsxFI3f1I", "congregationalism" },
  { "ab", "abCQz3pDUMwjE", "congregationalism" },
  { "CC", "CCObKp6oZ/Ijs", "dihydrosphingosine" },
  { "ab", "abi0ZGA2O7vz2", "dihydrosphingosine" },
  { "CC", "CCSd6IjC3XUtQ", "semianthropological" },
  { "ab", "abkpCn0UslKR2", "semianthropological" },
  { "CC", "CCkszowLaKwQI", "palaeogeographically" },
  { "ab", "abQpNzgtS8Y4.", "palaeogeographically" },
  { "CC", "CCj4BLTHC8dPQ", "electromyographically" },
  { "ab", "abhofIPtJKDnI", "electromyographically" },
  { "CC", "CCqYSYdfJDa9A", "noninterchangeableness" },
  { "ab", "abjBC5WWqUx5s", "noninterchangeableness" },
  { "CC", "CCYiWECFTvLbo", "abcdefghijklmnopqrstuvwxyz" },
  { "ab", "abYH7TYgEKz2Q", "abcdefghijklmnopqrstuvwxyz" },
  { "CC", "CCDUc5yYKE2dI", "electroencephalographically" },
  { "ab", "abooZTCeS9jSg", "electroencephalographically" },
  { "CC", "CCvT8tKTENFfo", "antidisestablishmentarianism" },
  { "ab", "ab6c/K2rnT8Aw", "antidisestablishmentarianism" },
  { "CC", "CCqCWJUufOFw6", "cyclotrimethylenetrinitramine" },
  { "ab", "abzi9F1yuymUQ", "cyclotrimethylenetrinitramine" },
  { "CC", "CCWpLVCzkv4Gs", "dichlorodiphenyltrichloroethane" },
  { "ab", "abAXyrMLt2fwc", "dichlorodiphenyltrichloroethane" },
  { "CC", "CCFAo2el2sagU", "multiple words seperated by spaces" },
  { "ab", "abAYLFLzcWoWo", "multiple words seperated by spaces" },
  { "CC", "CCSz2gog3i0co", "supercalifragilisticexpialidocious" },
  { "ab", "abBTyQ2AdyQW.", "supercalifragilisticexpialidocious" },
  { "CC", "CCRFMtw/2Yz6c", "we have a short salt string but not a short password" },
  { "ab", "abBCBt9IU4lug", "we have a short salt string but not a short password" },
  { "CC", "CCFAo2el2sagU", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "ab", "abAYLFLzcWoWo", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "CC", "CC.nSMd1oqoug", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "ab", "abzCGr5cnwu5Q", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "CC", "CCehtSXY9VcgU", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "ab", "ab1iBa.N.U2C6", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "CC", "CCeWCPWeB0Y7s", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "ab", "abmQw6w8KuXCQ", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "CC", "CCUj.vcbp0YcQ", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "ab", "ab2mSJsfAaEYc", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "CC", "CC4rMpbg9AMZ.", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "ab", "abP6zaVz4PU9U", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "CC", "CCk4Onp6WTPTY", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "ab", "ab76vmlPVRy5Q", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "CC", "CCoLp0sLZdas2", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "ab", "abO4gfga4XKD.", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "CC", "CCr8qoMD/gdWE", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "ab", "abtb865WlwaOA", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "CC", "CCn9g8mHJ8WxU", "\xc3\xa9tude" },
  { "ab", "ab4vjYACxKO9o", "\xc3\xa9tude" },
  { "CC", "CCn9g8mHJ8WxU", "C)tude" },
  { "ab", "ab4vjYACxKO9o", "C)tude" },
  { "CC", "CCRgyVVVpXpM2", "Chl\xc3\xb6""e" },
  { "ab", "ab5zWidETSBlE", "Chl\xc3\xb6""e" },
  { "CC", "CCRgyVVVpXpM2", "ChlC6e" },
  { "ab", "ab5zWidETSBlE", "ChlC6e" },
  { "CC", "CCM6/Cpgtljf2", "\xc3\x85ngstr\xc3\xb6m" },
  { "ab", "abaBhSVlHGKLI", "\xc3\x85ngstr\xc3\xb6m" },
  { "CC", "CCM6/Cpgtljf2", "C\x05ngstrC6m" },
  { "ab", "abaBhSVlHGKLI", "C\x05ngstrC6m" },
  { "CC", "CCM6/Cpgtljf2", "C\x05ngstrCU*U***U*" },
  { "ab", "abaBhSVlHGKLI", "C\x05ngstrCU*U***U*" },
  { "CC", "CC4rMpbg9AMZ.", "U*U***U*ignored" },
  { "ab", "abP6zaVz4PU9U", "U*U***U*ignored" },
  { "CC", "CCNf8Sbh3HDfQ", "U*U*U*U*" },
  { "ab", "ab3RlyzKJBvlk", "U*U*U*U*" },
  { "CC", "CCNf8Sbh3HDfQ", "U*U*U*U*ignored" },
  { "ab", "ab3RlyzKJBvlk", "U*U*U*U*ignored" },
  { "CC", "CCr8qoMD/gdWE", "*U*U*U*U" },
  { "ab", "abtb865WlwaOA", "*U*U*U*U" },
  { "CC", "CCr8qoMD/gdWE", "*U*U*U*U*" },
  { "ab", "abtb865WlwaOA", "*U*U*U*U*" },
  { "CC", "CCr8qoMD/gdWE", "*U*U*U*U*U*U*U*U" },
  { "ab", "abtb865WlwaOA", "*U*U*U*U*U*U*U*U" },
  { "CC", "CCr8qoMD/gdWE", "*U*U*U*U*U*U*U*U*" },
  { "ab", "abtb865WlwaOA", "*U*U*U*U*U*U*U*U*" },
  { "CC", "CCwH9PyRzmVTM", "\xa3" },
  { "ab", "abTqKyzTBdcQE", "\xa3" },
  { "CC", "CCZYYLpGi1lH.", "\xa3""a" },
  { "ab", "ab.Trho55NucA", "\xa3""a" },
  { "CC", "CCg211qX.b5cc", "\xd1\x91" },
  { "ab", "ab7FZcdAi4gGI", "\xd1\x91" },
  { "CC", "CCfPQN0mP.mF2", "\xa3""ab" },
  { "ab", "abO6Dh3hnXKYk", "\xa3""ab" },
  { "CC", "CC8cOxUkqH1as", "\xff\xff\xa3" },
  { "ab", "abiJnZqdV5Bc6", "\xff\xff\xa3" },
  { "CC", "CCutL9YOrA9uI", "1\xa3""345" },
  { "ab", "abpOcyfwGCZ7M", "1\xa3""345" },
  { "CC", "CCkTvRgBmtK4g", "\xff\xa3""345" },
  { "ab", "abPUWAfA7vSns", "\xff\xa3""345" },
  { "CC", "CCAtHFmg41y9E", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "ab", "abI531hjKAdzY", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "CC", "CC/mlx4OdBiAk", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "ab", "abD/2HQeVfH5I", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "CC", "CCr8qoMD/gdWE", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "ab", "abtb865WlwaOA", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "CC", "CCO7o2HcqNKcw", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "ab", "ab2wHQ4RTFVKI", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "CC", "CCO7o2HcqNKcw", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "ab", "ab2wHQ4RTFVKI", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "CC", "CCddR21tiMaqg", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "ab", "abdpmZGWTUFX2", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "CC", "CCddR21tiMaqg", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "ab", "abdpmZGWTUFX2", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "CC", "CC2RU2fzIuOsc", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "ab", "ab7TBnHv4ezs2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "CC", "CC2RU2fzIuOsc", "THE YEAR" },
  { "ab", "ab7TBnHv4ezs2", "THE YEAR" },
  { "CC", "CC2RU2fzIuOsc", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "ab", "ab7TBnHv4ezs2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "CC", "CC2RU2fzIuOsc", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "ab", "ab7TBnHv4ezs2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // descrypt

#if INCLUDE_gost_yescrypt && defined TEST_gost_yescrypt
  { "$gy$j75$.......", "$gy$j75$.......$C5BUyYB5xps0ocKn7vbPXrA/CKww4ZbrgU3O.X0kiy8", "" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$VIvMlb2yKp1wnlflMAxutM8UsAjZPD6dcXHT0nL2UP6", "" },
  { "$gy$j85$.......", "$gy$j85$.......$qcWboYF3QMRz3e9REHJfozixjIKov0Uujf7BEu2ZZB2", "" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$FFwajX.u/AzLfnYpLYaQpve0Zo.MzWzKkpWKCXVVdqD", "" },
  { "$gy$j75$.......", "$gy$j75$.......$yeq3RM1SBF/X5UXG3/rgW3ODUzAid4VZnK.beIBi7A.", " " },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$.QwcVcz9TqZtbUo52mxANeDJikjVhGhB8N7BLbOlw55", " " },
  { "$gy$j85$.......", "$gy$j85$.......$zA7FloUwnueYy7mv1wSgv0OyXjxaSIr/81pJeIyHwwB", " " },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$ysztMflCfFAhIz1oAxej1tDh5gMgyuTV23gkN9sakx5", " " },
  { "$gy$j75$.......", "$gy$j75$.......$eBagUD/6d5e0p3WmLp6DS1yMGjT9p55M7c1rJV6c2sA", "a" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$3cu6oF.5ffZtumWCBOTnzDnVwO9u1qooMY.tolVVmgA", "a" },
  { "$gy$j85$.......", "$gy$j85$.......$I0imOradhMNccrx0ZHpL.f02V7CVnVBiLyznVnU4FkC", "a" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$Pd2n9sm904arKsigtl8Q8CBjxiQZ3rti7ZX4t2YUqj0", "a" },
  { "$gy$j75$.......", "$gy$j75$.......$kUdcYFvlEPzM5g1WtlpGRTO0fPB34YAtUkimqcWTtr8", "ab" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$JQ3TPsm.eccu6pQfq83k6o65GqUAWRHze8fIJn5e/8D", "ab" },
  { "$gy$j85$.......", "$gy$j85$.......$9pjahGx1oL9Llexl21cbbA.eXK4UK5GhSGkmD7iYs.5", "ab" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$quk01WQ1quH9iMg0O02lIlsQoRgr8F4VjLLr9RCDmV0", "ab" },
  { "$gy$j75$.......", "$gy$j75$.......$XH2YP.u9tPw6ObDCXTRJiUfyrAEZ/TGIF0CjnxNW3h/", "abc" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$L2dOa9cEfoqtM0yxuEyxQCctdYVD6HCXsluuaIJe9I.", "abc" },
  { "$gy$j85$.......", "$gy$j85$.......$08Hdk6V57cXirP/uFImn98HF2BF6KZWIbCvkJ2ID6JD", "abc" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$R2ki2bsp3XNbL0RT0AqWD0aJo73DkXO71UREZb34230", "abc" },
  { "$gy$j75$.......", "$gy$j75$.......$2MgfEFMXQDMiVz5FoADXDmZqUGbHk1ZowcjDCELt0tA", "U*U" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$Udi6emcIyaqjsnk1MDoFsEZ/Osun/G3Vfl2xKSaS2K6", "U*U" },
  { "$gy$j85$.......", "$gy$j85$.......$uTjh9GTeGAXGqwHhhHNIfd9mc2vOjSvznKbZX7W9fT3", "U*U" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$em7NI7dyD4fZ4wIBmq1RwxGxmD5vaCyQhFzptmDEBz2", "U*U" },
  { "$gy$j75$.......", "$gy$j75$.......$3QfYsWjKOcG3/3050vUSWmi6sLvnJtplRcZFeDSDPb7", "U*U*" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$brR63dP6sW9ya2FqaQ.jvFeakx4BlaCdAprErx.KKQ.", "U*U*" },
  { "$gy$j85$.......", "$gy$j85$.......$OKdBTBDU/4rwZiJYVv1tAgNVTKfLPIDr97OETLmx6J5", "U*U*" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$xFP56XMS7dykUI.gheamShTgw4bJGK6bq.DCKykyo/5", "U*U*" },
  { "$gy$j75$.......", "$gy$j75$.......$LHGIR60LusLVPLX.vhk3wN6OUudxHoctGd1D6hskrN6", "U*U*U" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$m7k6NWNaAlb1ZsBNngUgx1UsGttDX4o8mug05LovYR3", "U*U*U" },
  { "$gy$j85$.......", "$gy$j85$.......$YBvISwdayI/b5HtXucqXxtSQx52dNbfEI7Crhr0kLIA", "U*U*U" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$P6zvk9rHj2Eq89wO8aHChgTXBaRVO6w9.KwkF.BzYwA", "U*U*U" },
  { "$gy$j75$.......", "$gy$j75$.......$rMrSARKvvE.gk9q3V/iRdZX09f72QHBCCepv3vTQmh/", "....." },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$4KoiKqFKUMvS4oFe/m/Dfx/WmWYWtOrr9p5S.MaJoS7", "....." },
  { "$gy$j85$.......", "$gy$j85$.......$uvwXuSvP/.vOGyoEtzfqhvymymRe9MwmBEtOpPFGto4", "....." },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$A632z25kLhB.iNNJUMH/.CQnDeTquwmGbeH/7n/Bdp5", "....." },
  { "$gy$j75$.......", "$gy$j75$.......$8XoI2beNyRr/sfdJ1zhybcWhRwhvAOdUcK6nqwz3O4.", "dragon" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$XOe1WAt0Aj.sOSXXrzCobxh1YgjFakCGQCmB58ZKKZ0", "dragon" },
  { "$gy$j85$.......", "$gy$j85$.......$2s30RlZzHAZW24TFe7vsa3y3V5r1CHAJ5JXuRH00Pn.", "dragon" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$K55LpE8tg31P6HtlqlR2/Y46br8ohiayx0JynFtaqj0", "dragon" },
  { "$gy$j75$.......", "$gy$j75$.......$xzXF8V3pf2mVgaf1V5Yv2xUGTR/KMen/.H9f53/aeI/", "dRaGoN" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$M9YlVcCkO2SG44MA5xV8gzg1Ol/7Mys.NuohwoeheV1", "dRaGoN" },
  { "$gy$j85$.......", "$gy$j85$.......$he3zfQzy.bPSTMvacDBjB/kWN3Y5oCfoBihwunDjg68", "dRaGoN" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$c1Tz45C1GGffLEIPamOZir8pAjTVWLpJOT9anIwy77/", "dRaGoN" },
  { "$gy$j75$.......", "$gy$j75$.......$tGaQcR3gIRQr6NSrtUZPr2IMkohE6YyyoPM6BnhQRx0", "DrAgOn" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$ozHV4YgroesMNBTOk.ZPU6ods.bFQ4uW9oLUgGq56h8", "DrAgOn" },
  { "$gy$j85$.......", "$gy$j85$.......$wnvBVYulR5RsJiAk7u94EJ4Qs8yzNgwRa7XH3Nud5e0", "DrAgOn" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$leV3.HrxgZ7wetBccpcz80YvgIWtmNT5VEyojiqHtE0", "DrAgOn" },
  { "$gy$j75$.......", "$gy$j75$.......$0typDNZ0Tl4sir49ZcOf5tJ64dCkh219z0vi54flZz7", "PAROLX" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$qbLj.WFRzkAqktxtpy/amhflmNPa9VdUM5H1t9BI9b.", "PAROLX" },
  { "$gy$j85$.......", "$gy$j85$.......$ObQJq4c4/YQClBaerSPsLx5u335EI7vEeJZ0K14SjVC", "PAROLX" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$3.hde8WfQqYzojcjdpFETOPXxAE07jN.hVsPRxWyut4", "PAROLX" },
  { "$gy$j75$.......", "$gy$j75$.......$Z7m1qzZ.4gYFqy2w7V0YOXpGvWz/DP.GBR/clR0lu73", "U*U***U" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$xD6mJI9Q5qbdOiKkwZzRIDrJQBEvFBkPPnEb5EHnHe9", "U*U***U" },
  { "$gy$j85$.......", "$gy$j85$.......$IX4VJZLEzVM0F/0SH8zI0aaRPyNFElweojqY6R4RPb1", "U*U***U" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$DdWnAHyuhiNUzIAueU6jI6bhtCLuX2z3mHipJKvySiB", "U*U***U" },
  { "$gy$j75$.......", "$gy$j75$.......$NIb62oBds0n69VNxMjzoK.galMyenjKndtiyH/.BzP5", "abcdefg" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$.w4ZMpkTRIsAFZmlGEkk1HefHWnRYNuqyhFXcmYpU52", "abcdefg" },
  { "$gy$j85$.......", "$gy$j85$.......$3YMTvMot1FbF2gRdyYIY5lpHWs/BzkSQqD7F5M/nra0", "abcdefg" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$5gEbvJyVRTl.y/2aVNV2zik5VtCnJNGOuLAbFTPLbA7", "abcdefg" },
  { "$gy$j75$.......", "$gy$j75$.......$wwJfCZTFWLC/oCJshdYocDGXBG4zayaAYYnaqQy6O.7", "01234567" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$ZvA.DWjyvxxKO8vCu2mReEYuDGliqf8f46VywSXzRf3", "01234567" },
  { "$gy$j85$.......", "$gy$j85$.......$P1of6vxmZsJqlnqqOb08atMTqlqrLSptHza4TnyMRX0", "01234567" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$CH89kK75GOmpcSRCN8/HCP3F8i4jos.J67BJNtseZHA", "01234567" },
  { "$gy$j75$.......", "$gy$j75$.......$06vSfetdFpfuSOmiC07VgJV94xwdZkdcvVV8tEQ.6g1", "726 even" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$BkDcHhA6h2ZloPYeaP./uui1YXvi/xypQO.Mx2jpTf6", "726 even" },
  { "$gy$j85$.......", "$gy$j85$.......$vQ1rLRqFSd94X5BRRhHPHVvu8LhFCYoQ0F74w4.yvuA", "726 even" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$eXL6mCaYcnNKHkekCMRCPcSiLmj4yJJkL87x62iZB/9", "726 even" },
  { "$gy$j75$.......", "$gy$j75$.......$XXVb6efUDkS.Z9AkBo02kEr8U5XAXcj6DsVx8KWS5K8", "zyxwvuts" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$4YAqk4DKKnD0xvNg3jLLzQek1heuzRAn.ct4CwhdRLA", "zyxwvuts" },
  { "$gy$j85$.......", "$gy$j85$.......$YdfHuCTWY1T/a60Ve/WEa3CGsRbc.6SnawF7ddFMer3", "zyxwvuts" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$bf6J5naHOyk7RNXxL7N/d53YcGGv8euyu8dL7Z7buL5", "zyxwvuts" },
  { "$gy$j75$.......", "$gy$j75$.......$OQFQ/WjDPoZ81BKrTamZwlQDEoO.amnpFg3fJJ66vx6", "ab1234567" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$2LVwnHAlnk4fyxfsHRaTx.uFScb5BlrWuEFTQn/DvV.", "ab1234567" },
  { "$gy$j85$.......", "$gy$j85$.......$48HqJwaKvDoFRD1dBUUf.Ls.Y3rqrwBJy6k4wsvSG54", "ab1234567" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$2mBdv7fxREQyxtrShAfz9lr8PAjF2b0ZOGDFKHAPGf1", "ab1234567" },
  { "$gy$j75$.......", "$gy$j75$.......$g8CXwJ7ccaismgA/kkjYgWGrPbO1nxtpX8EbTzQUFT.", "alexander" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$QxdV3fcqrHnos0CMmNMP.tyYb2ym1136Ibxsds5k3q.", "alexander" },
  { "$gy$j85$.......", "$gy$j85$.......$b6iSEiGkicetIL15EL/cmTS3YFbA7/rnELd0uW2qYJ0", "alexander" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$K6T2.SfueblQe.s3sG0uik0YSH81rNbDgje8he4s51.", "alexander" },
  { "$gy$j75$.......", "$gy$j75$.......$N6CYdTSgCVSvLqvOOq1Vg0uJoowU8W6ATTXP.iItrO7", "beautiful" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$iVOsFYn8Bcu7lUqPok3tEq.atcrgiaHnOCMeCrKOjr4", "beautiful" },
  { "$gy$j85$.......", "$gy$j85$.......$3o21UocX4SPe/qemqQmKoTQajYsYjkFDZfZL05CKBY5", "beautiful" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$3oFJdLH87C35yZ1Y6YCAfH8f54C9Cm2DYAYU6iO2yUA", "beautiful" },
  { "$gy$j75$.......", "$gy$j75$.......$4UujoVqzB4.rvnN7chI181vcUniG/GOvpEhdTt5J3sD", "challenge" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$7vL9STzD6ZvXhmF.pZydUmXO9grVxFuOuxyIGD6rRY9", "challenge" },
  { "$gy$j85$.......", "$gy$j85$.......$JsRFw3psyoXImWkqQXVc44PJY6YD8R7uGV1gbaL7DsC", "challenge" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$bqITrpEX/oZ1G3QA15ktUBnniVxXJwZ0Zuil3cvDn4C", "challenge" },
  { "$gy$j75$.......", "$gy$j75$.......$gqXFpMq0Qhp0rWCNWVPrZJYMa85l82bMzp3N55n4Yr.", "chocolate" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$hi1uMs3/xdQS8qwF5JiJgdPafv4JAXUoM92TtOORl4C", "chocolate" },
  { "$gy$j85$.......", "$gy$j85$.......$KzUbYZDqN1JQJ7G/070VuNuYccLO0BkcSqau9fwfCF3", "chocolate" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$B9vmGzz8W.vVN9dMXFVAMqf9DSQBMzBJgK3WRE7JzuD", "chocolate" },
  { "$gy$j75$.......", "$gy$j75$.......$dmnPVTcjsZZezusL7QvgK6rUqOmnzjFjA.rrB6b4e4D", "cr1234567" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$gfUq0qddSXU6K/lTWFiU1lYcmtASl6xaqdnFgSKDAD9", "cr1234567" },
  { "$gy$j85$.......", "$gy$j85$.......$ixpGY0InKowR/zRYQ9ykuvrkF9Z30CwmBgfUzEesyeD", "cr1234567" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$mFBR79lasS9a3Y.gN/7dI9ngh0FyauzHMYMIGcYdi52", "cr1234567" },
  { "$gy$j75$.......", "$gy$j75$.......$5qI1fZqyGXBa2dSRoD4Uq61LEP.s2hLvoPxe6EShDa4", "katherine" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$y5YZ1dqH.1qu1T0hJ6YU2/vhwd3dBF/JvLYTjT7ICX1", "katherine" },
  { "$gy$j85$.......", "$gy$j85$.......$u9OaUx.QOvLYZzsp.e8trGLXXOhyXoO4yl/xItsj721", "katherine" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$K0K7U/Np0gSRNQwTz5F/Uc4urv8vuDXMsVq5g3kAHk5", "katherine" },
  { "$gy$j75$.......", "$gy$j75$.......$3kw0SFwYnDDWkg/WsJ.WoTL5/g.FrVM3QXHBYIutk62", "stephanie" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$653GHm8T/yXCpk/LDiBLziwqiOjcZAq95GT6e.hnKS1", "stephanie" },
  { "$gy$j85$.......", "$gy$j85$.......$HvaCRW6RfUteFIm8G0AEGQWm5xL6fAezCKqxYtOptW2", "stephanie" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$C82thHwg1tSsWBnZLrYUCIojZqbJz2RU.szOVIqY1x0", "stephanie" },
  { "$gy$j75$.......", "$gy$j75$.......$u.9wgpq83ZxZ9nFSi14FQ65nmsnpo/02B.mX.WhhYGA", "sunflower" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$Ur/0zo5dUh8Bikmly78XKD.9AEXg90AuTl9ra4Xj7v0", "sunflower" },
  { "$gy$j85$.......", "$gy$j85$.......$bowtl//9DSMrMcPRyDdMZgeqzLlmz05kmD8ttz5jwTB", "sunflower" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$4LDovQsfXcYZTmpDpYWbBm7ZexgjzuoZGuOb75CpZM8", "sunflower" },
  { "$gy$j75$.......", "$gy$j75$.......$4ZnU5zBelTRfHVwNT07ZXt0iVGUbnH37xAdOdVcxTaC", "basketball" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$KZdGrPlBtS60pgtbfXO.2YrqaMBg/wYHCDVBixZKbO4", "basketball" },
  { "$gy$j85$.......", "$gy$j85$.......$.zn0bVJlFbbs8YysQvbHqBAfw2qBYQe/5gavPdhizn0", "basketball" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$2.I0pjFsW1HdmvEFCanlZsjl8Decyg8e7z0/x3hfCR.", "basketball" },
  { "$gy$j75$.......", "$gy$j75$.......$mWaDA.EsFP1mOaI3Ox0pUcw4WJDsUeIJ7EXeMfbUe33", "porsche911" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$agPYxvyJWCwDABuKjRgXVNVGS8qicZhMVXgj0FQ.YI2", "porsche911" },
  { "$gy$j85$.......", "$gy$j85$.......$IYHAe5xXEPHyK649n/AK4qRFTRvK0gCqSX4u9fe5bRC", "porsche911" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$U9sDkkCymgehl8bsioKK2DMsMP3qqP5pkfN/0XFXpX7", "porsche911" },
  { "$gy$j75$.......", "$gy$j75$.......$6rTjWFwZbW/AzSIO.aj9USmksMg0VBp6A4yA8g8bNB7", "|_337T`/p3" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$5W9zz6kiyR6T/gTkGoivl0s9tXwZPw5Do.yaB9Orc3.", "|_337T`/p3" },
  { "$gy$j85$.......", "$gy$j85$.......$EC5f1LnUSsxNHPD2JMU9dgp737uPibMGipWAYFbiot9", "|_337T`/p3" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$K696ZFX0TEjHwQ614URRGSrJeAtjrcdqBsX.oy4cx7.", "|_337T`/p3" },
  { "$gy$j75$.......", "$gy$j75$.......$j8ynU.zvWVOLpb.ykIfQelXu4yxPXgfqw9tE2f5TIt/", "thunderbird" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$D/kl.1T/t6zJNUh4YQ4Stcz.E6WMZ5uvPYT2kB.aU1D", "thunderbird" },
  { "$gy$j85$.......", "$gy$j85$.......$EXnrx3JDG/4scOqquFvMDGM0KsT6Ww/iCKHkGkttUu2", "thunderbird" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$b0V92DSxJ/u6FlAP40ibumgwY7KC2iuy1G7neEBU64D", "thunderbird" },
  { "$gy$j75$.......", "$gy$j75$.......$mH8A6PYt/6.FlDeVfUtD7mfEVypDgbSX0MagtEntiM4", "Hello world!" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$5jeCDa.gqje1rkEFrCfYWc0atZtZSqocZrak0uAbf18", "Hello world!" },
  { "$gy$j85$.......", "$gy$j85$.......$jKTcdxu6KdPXn7EN29ir..reDQZd2Ccwh0ctH4rEuM6", "Hello world!" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$rj762cpiSuHNd/UqxuVxRWksdhO6eDHPHsZ9MQMpDs0", "Hello world!" },
  { "$gy$j75$.......", "$gy$j75$.......$Dn3Q5nslkbrxxA3exxYXpQa8Ael1AAjHk1iU49c17ZB", "pleaseletmein" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$DFeQcmRiMM1ZhJ7ucqwvYLMj56sGp/durhpnAg/nVu2", "pleaseletmein" },
  { "$gy$j85$.......", "$gy$j85$.......$QqxlcA6VGIIUhWWTSyzO6JxNvoynDwF1io3UcAMSht9", "pleaseletmein" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$TGpKr9kK6ZX.IP1x7Qp2BvzwMd2BSZFSEDRhzvlGIM2", "pleaseletmein" },
  { "$gy$j75$.......", "$gy$j75$.......$kYaFes6Xv3gRerkLP7/4t6bzzTcAjRuXC934u6PMPM3", "a short string" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$MzPUiCu8m/E6Aam7FrciVxf.dI7BDS7icU4wvqIKA29", "a short string" },
  { "$gy$j85$.......", "$gy$j85$.......$uSSR1JanLC6D1yrW77VHka/i8svrbQe2.LiNvxv73V8", "a short string" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$Z.t5jfwcysgS0oZ2tYmqCqgeRN49L3lsJG78msREd01", "a short string" },
  { "$gy$j75$.......", "$gy$j75$.......$qfQyyxorg82JbbD1/LNpHD58xb8kFDMY.BpHDc4gt31", "zxyDPWgydbQjgq" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$JrbShULG16wdFk6J5G6gFbvjPb.XP6omfpMAPs4dTM3", "zxyDPWgydbQjgq" },
  { "$gy$j85$.......", "$gy$j85$.......$7cES0jpMWrnpVsAZQ08A3oQPA2MLOOiD3dK40jcYZu5", "zxyDPWgydbQjgq" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$0k7LcQHZ8wtfPkUCg5VXIWrnSDgd4Z1/avPWG8nSi78", "zxyDPWgydbQjgq" },
  { "$gy$j75$.......", "$gy$j75$.......$S0mtjhQH6Zgw9KtytdoBvanCgtWz8Knm5pb.0128yTD", "photojournalism" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$vlGaccF4.4ZtJKbe9hZgg0a/vaGTrLHCvjWgJzBY.I.", "photojournalism" },
  { "$gy$j85$.......", "$gy$j85$.......$4u2/yTgI3Xl1KbzDo/uviSCesJQp84q2h0uHvA5bEnD", "photojournalism" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$1NCXLRHuEM5RKqjn1rgYVLss90eS57dCasXTAeHh0G0", "photojournalism" },
  { "$gy$j75$.......", "$gy$j75$.......$0H.VHy1ylVgctz71jhBZgIkkVcPlDw5rOWBzUL.2ux4", "ecclesiastically" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$9eVWNVlLb.4dh66gdeg7irHelezkfqbBVFJYgvz2vF9", "ecclesiastically" },
  { "$gy$j85$.......", "$gy$j85$.......$ASJ.a8iPBu2p4OogAuMl/QV1xc275yLDGypbEMpVsH2", "ecclesiastically" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$Gj5SKco/.BeMECwg/Jt/ArmoUMfd.hlg7Q.joDcMv67", "ecclesiastically" },
  { "$gy$j75$.......", "$gy$j75$.......$kwIx9VaMEDQFOHrAuMVcUtQao4Ojp3LCAUlBo4wCBfA", "congregationalism" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$5RvJB3/RuAKu4ygA3nBauWw34iJ3XOvn/ZtVFYgfVD0", "congregationalism" },
  { "$gy$j85$.......", "$gy$j85$.......$1ySdm2sWMi3bnDtfn5B5MuqyBmJJ8KdMr3.mtfqR1l.", "congregationalism" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$TLTx0csFWbQjjPV5aQjNf9aXof0d0GwoK8X23JRroD3", "congregationalism" },
  { "$gy$j75$.......", "$gy$j75$.......$RK5fpDKQSf0Xx9l2WQJUGRY1lfItsvOTSvyzzVWX4q3", "dihydrosphingosine" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$G/HOt48aRXCO24Ck37vADmQ7xWVcCWdyzQvdVbyOQ65", "dihydrosphingosine" },
  { "$gy$j85$.......", "$gy$j85$.......$38l9FOgLKQnNhN1HXmAyUzym2uytsTmqsO3WR44q6d1", "dihydrosphingosine" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$/BaWf9Rb1L/2OmHor0UsEtaPX6ZVKdIsE.D5QzNwEsC", "dihydrosphingosine" },
  { "$gy$j75$.......", "$gy$j75$.......$t6XNiMKBS/Mi8ZiT4lL21cIOthgJaz6z1sbj5WmqSnC", "semianthropological" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$T1x61ml9QS8YYRsVFWtmJjM9W27DjBEfQK52coo6wx7", "semianthropological" },
  { "$gy$j85$.......", "$gy$j85$.......$pqa/u8x6KKA1.YsLW4AsKOoVS69S9g1tJkbEXmE/GD0", "semianthropological" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$fSKKp8h2F3Ojypt90/DpEE3JvGdWa/YvjBZ4j58gUW2", "semianthropological" },
  { "$gy$j75$.......", "$gy$j75$.......$ifIN//mcLmGvaW2A376.ud8qOTj54ipuLcif3K8bDC2", "palaeogeographically" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$xJf5Q.Eb7DsEMhKjLReHnk9d1yat1YFD9RGXT5cWTi6", "palaeogeographically" },
  { "$gy$j85$.......", "$gy$j85$.......$tb7hNOWIT0P5h/jqjSoi7WXAfRLgETj8Bkq7.MxGam.", "palaeogeographically" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$mpXv0XWYUjD8Xc24ELz0YXQotWsiovRlZHXd10Kkk64", "palaeogeographically" },
  { "$gy$j75$.......", "$gy$j75$.......$ZL1kbSRJ5gLlLJmZ5IyxmH04DsiuMkyRiv6FwWMf3tD", "electromyographically" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$wJkWx5ncSA2VxgqjqXE2pKDs4l6/X63iORWcK9U8rL4", "electromyographically" },
  { "$gy$j85$.......", "$gy$j85$.......$58lpf1g0nvLJvZnSDBfsQTuCMLNCMTMBtoje3/XsiGD", "electromyographically" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$1bSWHPkMcULM4QbUlFbDU1N9.z4PSqDEW8C.p8d2Gz0", "electromyographically" },
  { "$gy$j75$.......", "$gy$j75$.......$5eVq5ZSWFrO6JYCbPEIKJ6vB27nvNM48dlvvjp1IsBB", "noninterchangeableness" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$7wDG3ept6jRsTymR1AVZ.ozZBazh8w1HzhYZsMvPPH3", "noninterchangeableness" },
  { "$gy$j85$.......", "$gy$j85$.......$.toEFxnTRi1pQepaOLJLNJ.B7lpnwTZDyo7T4IdSer9", "noninterchangeableness" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$Ij4GVB1F8oTt0KlkUvZmRXMeHmD84BZRqNRR/YWwYeA", "noninterchangeableness" },
  { "$gy$j75$.......", "$gy$j75$.......$gMYvyzZ.Gvc39g9eFXcoJd3G9Co1Kw.LltZPGU5jmR4", "abcdefghijklmnopqrstuvwxyz" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$6sGuvOiKa4x1EAiPcvOuqA9yJaHUSR3ecdJw34xZsj0", "abcdefghijklmnopqrstuvwxyz" },
  { "$gy$j85$.......", "$gy$j85$.......$x5vfHstS4Jivur9YYXL0qT6HlqGEhyqnICAyq.ArKTD", "abcdefghijklmnopqrstuvwxyz" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$A2ULAPT3sNLkLGe3pi/6xuCQBFrTOsadL74HMctdoOC", "abcdefghijklmnopqrstuvwxyz" },
  { "$gy$j75$.......", "$gy$j75$.......$u/qpH4hndENeGzp.aqWHyxmorU50/FAiGA5609TE9v0", "electroencephalographically" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$3ZUaPzdOdgEV62tb37hvCMIBvsDsEg1U/nc.PnA4uPC", "electroencephalographically" },
  { "$gy$j85$.......", "$gy$j85$.......$w5QrgWSribxVno.06Ht0OeJ3Pf5KIkfIpG6YvRiI0C4", "electroencephalographically" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$H8rMtycWCkGldExWhv6Wl1xwwdLL41GpR21qS4yruv.", "electroencephalographically" },
  { "$gy$j75$.......", "$gy$j75$.......$nNh4plGlwarUxm2WK6OmFgsI3rHlSzBC8Y1jBJ7NYi9", "antidisestablishmentarianism" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$6E0e1F4MH9YpvE0yVZPHCqNzJUAdFSz5T9Sw/bRZ9ZD", "antidisestablishmentarianism" },
  { "$gy$j85$.......", "$gy$j85$.......$zJaa20rPNkk7be.9QlSDHgx2imp3uweGiaNe8l/BDy0", "antidisestablishmentarianism" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$NbJyuhgbNAT3fsObqL.d2QukuKtyeAhZs0lvYp/phVD", "antidisestablishmentarianism" },
  { "$gy$j75$.......", "$gy$j75$.......$d4uRpI0Hu163.UYCarR..5Dl2FPZB8TF6Bsfd88PhmB", "cyclotrimethylenetrinitramine" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$cHniVRkWa.v2T7UC8PzpiO0/JiU1HAPgLG5Qai616U3", "cyclotrimethylenetrinitramine" },
  { "$gy$j85$.......", "$gy$j85$.......$fMnj9ncwhSSeQyPfw2EBTHffsb38g5Ynfi590CODe8C", "cyclotrimethylenetrinitramine" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$6dpFLbr8kFY0jWWPTfUPqa2qeVUeDqDt.mcbGjzVeH4", "cyclotrimethylenetrinitramine" },
  { "$gy$j75$.......", "$gy$j75$.......$ssSXu/TjP2nYRAm8MA994K7/oEqbrAMXTl6J6zyvHcA", "dichlorodiphenyltrichloroethane" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$rSUrvUtOFl8cHFyKZgxzg.uqoFkK6ASdzGKEhT7PmI4", "dichlorodiphenyltrichloroethane" },
  { "$gy$j85$.......", "$gy$j85$.......$w87ij/NI4trU0mQrMYztx7GgT.o0Vn3/WIoJvO75Kt/", "dichlorodiphenyltrichloroethane" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$9Sz/V/2Mkz1dJA54sV1GsyiYiD1cHSV5cM0Gjvtp6C8", "dichlorodiphenyltrichloroethane" },
  { "$gy$j75$.......", "$gy$j75$.......$hVw/wMPY9n9WTSIFq8EBRj1K3Xqn2A3VY371LhJQcoC", "multiple words seperated by spaces" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$skUlgwOh3JoXydPND.75rARvcp.Zo.f1HzvIBu4TYpA", "multiple words seperated by spaces" },
  { "$gy$j85$.......", "$gy$j85$.......$2rmC6QOfkGRHgdQK0uNFHANRaqs3bmyGqfbkBoUUWLB", "multiple words seperated by spaces" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$HMf.OMxaGaQdclIBWm5IPDnTCnPdJoaM7ZxJSmVGkO4", "multiple words seperated by spaces" },
  { "$gy$j75$.......", "$gy$j75$.......$zpFF2aDakeRnRbR6h8.vIhF3yixzs05ehqEYNSmk5l.", "supercalifragilisticexpialidocious" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$5KTrFndb.PN/kJSoRnHk6C42OZ2jr8xQ4bZc8psO8p1", "supercalifragilisticexpialidocious" },
  { "$gy$j85$.......", "$gy$j85$.......$0FudcGnwMUXxgo6FhxYmJGbeP8SnOonK5A8hfxhMxM7", "supercalifragilisticexpialidocious" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$MeT7lb9jGGIrWFffwbs7mK8TVgJlvDVaH5rK.ihnsA3", "supercalifragilisticexpialidocious" },
  { "$gy$j75$.......", "$gy$j75$.......$gqopDIPx5bn5AlnM0FhKfPLLIXKJ9NMo6r/PpvptoE4", "we have a short salt string but not a short password" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$KyCr56Xpf.eE8S7s/QtL9szvDm6/EaxBIkiFposJtP/", "we have a short salt string but not a short password" },
  { "$gy$j85$.......", "$gy$j85$.......$AdQm5p1BACTl.f/dprWskLZjXpmCaVZ9wW5P.oTFZDA", "we have a short salt string but not a short password" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$PbB.vSkaao43xr2t/hDEKyBo9wjTWjnE.k/r6Duomm8", "we have a short salt string but not a short password" },
  { "$gy$j75$.......", "$gy$j75$.......$3mvlCdQV8od7T53oA9ZukYRE6k7zjswxVr1nt4jejJ6", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$1ZIpeYyPm/pUOoKbVj3DTAjZbQsDvMBkTFtl22RaXl3", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$gy$j85$.......", "$gy$j85$.......$el/h941NrwLzT6Tq9XrDYdZqetNZGISZ5emb9UiPHwB", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$TmLxSUBkwVMqip3IszVmYMdIICqFDvJszXxLD0VGKl4", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$gy$j75$.......", "$gy$j75$.......$75IHAeKATZ8/PeFavlLjtPzXmWH.lAOD86m7poUAZP3", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$XxMxCBAzhFj.RD1py6NWOz7FxAlnzAiP/XKdl08e8k9", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$gy$j85$.......", "$gy$j85$.......$mEU6IUsg.cU3p0IUPBxiOMPbKRfTfT4goGxbisJMtR3", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$M4ZJEU2S/uskYewVkAuGY5nxd/UmNQlma981EdcI79B", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$gy$j75$.......", "$gy$j75$.......$7ligFf6OMmQhSniQDP6pGcLfrEtN2nGzzn4ByhXTIRD", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$miDODWYQmRSVbU36.BJ5KmgClbOM4V6iW1aExHs8m36", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$gy$j85$.......", "$gy$j85$.......$LgT6EalaUYSJOHg3UXNp/rahh9STcnxYONPPiY2XNg4", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$SROlP.aT6WPBs0L3fzc0bYg5qzCpNU2EDO6OZatRHc.", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$gy$j75$.......", "$gy$j75$.......$RbowMpRY7rpZum7k7cswdTS1jXRRVPAUp9Fy3ueBlk2", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$adi0bxhoImhH6g.xbP63bFbMWl48JfsLowMhusVO5u3", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$gy$j85$.......", "$gy$j85$.......$TpQvC5YE/oN6s2C42aHRUzp.5I5qAVg4xKzfLl9tkJ4", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$g2TF4SWLsQtonL4ZxZdi5XK971M35IsZWJj3pjTxYgA", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$gy$j75$.......", "$gy$j75$.......$7RnHl5dZGakq9KHbs.U62FogKMo9n4ix8zboFw4DN37", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$nl.ehg3WTLQUbhBImTlQEB8iyHH7RKPoqRGgHzP3.e2", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$gy$j85$.......", "$gy$j85$.......$dQRV5w0yfwJjwvfOy/7dSe41758u9Uu2wR3qA2iAEI2", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$orMYLYeekI3egQDDXqMvAgUP94OSVTm/87SFTv5ZxC.", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$gy$j75$.......", "$gy$j75$.......$.LISmKHe7RY7UW20ETp6m.r1ghqNBkyCj3K6iV0nEjB", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$T8vVQ.yid7eAAdk9.IJS8rjK2YIaIDbgLfaPAw7YrY3", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$gy$j85$.......", "$gy$j85$.......$X4w.z05IyNKvY3Mn3hhYGnDlK0U2Hx2Zo8J2UsHRcs2", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$IGBjII4Cw4u3o5YHtfdpchtSRzlrQAQnITDl9S0GlU1", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$gy$j75$.......", "$gy$j75$.......$5pBGmi.PGaf1cBy117ChvVOlKzNEyMyb3SxHO2FOIJ4", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$kdNTW/TU.dXgihSRqfJZLNRlC0y86Z1UQlrSt3AZop3", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$gy$j85$.......", "$gy$j85$.......$xWDwDM5OHKi/N3woTo9teU.DyTmELEhSnCUOi2oxu5D", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$o3S5eT9cwQ6tIFgd5nW66Hn1CeNrubVpg3IvamdqD75", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$gy$j75$.......", "$gy$j75$.......$bN38lnE7dvEdYR.70uN4CmmhKOyHayolDz7xwW4asA6", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$hLaqCM19hL2DNv7iLjdCMhVAL5NrbubEdSOZr5g4On5", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$gy$j85$.......", "$gy$j85$.......$xTdKkwwTL9eDaqQOGTlw1Z96i/oBvyk3WuwNsjtQPhA", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$f0uMn5svuaQvqtaHm1M/CE0chsEFQ1LtDAOwdtmyPP.", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$gy$j75$.......", "$gy$j75$.......$DzdK5SbueEJbTCRV2l8B0iOB3zq1xtBpM9F9dd2e4k7", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$Hww9O32Kz93oERgd6DfB5/a9ECRbmOsAznSgaQ61Za1", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$gy$j85$.......", "$gy$j85$.......$a.tj/sPg9XuNnPQyvuRGYsm8iGtt2QMzyB8u3fqC2eD", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$/BNXO4SmhW8SEu8NKipNK2FTvCt6UTJsqtXkHgwzbc4", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$gy$j75$.......", "$gy$j75$.......$alBloYJOS1Tj4VZ477hLFJHU9X/x4NEAxEtypHlFeN8", "\xc3\xa9tude" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$izHHCLwbvDPcdrnjubnRBORxtqGAVVxwRPiBMBLtcLA", "\xc3\xa9tude" },
  { "$gy$j85$.......", "$gy$j85$.......$MT2NorwMFy5Pp07yrTIvhpPsCh0V1Pupz0XITobLI77", "\xc3\xa9tude" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$YwjvamIoYSlYvsJN8v.wMLoOjejaRufZ9e5Y13/WhW2", "\xc3\xa9tude" },
  { "$gy$j75$.......", "$gy$j75$.......$ZxaD5Fa7z/r3ERNQ7hn5iJmIu2IF9jmWuRm5VNxZ9T5", "C)tude" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$a88GVPT32c8pSEJSokpZXVI.Vd1bXFJJ5pHx6zNYQbD", "C)tude" },
  { "$gy$j85$.......", "$gy$j85$.......$cLPn255iyF9vuFL3K7a5PuRDm6mVAHA2XwBQkrv8a2A", "C)tude" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$Cp237pZ5lpRH.MGtGDmnAEvfBlSpaRv8McurDTnIJC6", "C)tude" },
  { "$gy$j75$.......", "$gy$j75$.......$G6iciVL5YBxKN8MAS32upd/c7i2r6kwZy1D1wlZgJA4", "Chl\xc3\xb6""e" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$LTAnw6k0iRD.jv.uLl0Ora/tL7/C3LN7qxTanm6PFU8", "Chl\xc3\xb6""e" },
  { "$gy$j85$.......", "$gy$j85$.......$WSMrFLWCtFFZs6dF9URCAMJ5kUkff2t/TgqItJ0d/QD", "Chl\xc3\xb6""e" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$RR0ZfbSM5GnO8ZnqSQ2Ozmk2x/tmPGjNkMu7/oxDuG4", "Chl\xc3\xb6""e" },
  { "$gy$j75$.......", "$gy$j75$.......$VAqr/mXtW86YYxtLkkpIdurozPqnRho/I/MxZY6IiU4", "ChlC6e" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$UoCxceq28qTU2A5oi6zxfV3l0hmf6t2ge7CUKPQ5zz2", "ChlC6e" },
  { "$gy$j85$.......", "$gy$j85$.......$vzQS4YmKY9zistx01qhIUtt0WHCL/vmpRvjWqIjOkWD", "ChlC6e" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$LwYtOumNHoM2CLa90kozMqULC97OIud7H4GvhLTJIk9", "ChlC6e" },
  { "$gy$j75$.......", "$gy$j75$.......$wgWA9l8Ne3kojZdkpCt4OAuakdCW8ZmRYMTWP9kforA", "\xc3\x85ngstr\xc3\xb6m" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$NI8ZYYsg6q3hAus6c1eEoKYUpaUdRZWm/VA7MBo91yD", "\xc3\x85ngstr\xc3\xb6m" },
  { "$gy$j85$.......", "$gy$j85$.......$znZNaByPGnHki8EVEE3Ad3b4QDgu9M/jBPMe41GrUU4", "\xc3\x85ngstr\xc3\xb6m" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$/w8tExwgISevWouw9aAXH27g3VDeQ64GEs8fNHTI.t8", "\xc3\x85ngstr\xc3\xb6m" },
  { "$gy$j75$.......", "$gy$j75$.......$Lt3k8Rr6WK/lFcBKAve.XzTDQJDRgud2Pqug0t9o/n1", "C\x05ngstrC6m" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$HsoWU9DuyuAKbBD6MDryaGpa8DHmbnTaPoGLBUjVW2.", "C\x05ngstrC6m" },
  { "$gy$j85$.......", "$gy$j85$.......$5YqFIYGv0kUVeA6Qybj1gtSt7R8b2X89sf2Jkz5gFy4", "C\x05ngstrC6m" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$JWNl/sAyYUX4KJY//J9Bhz3gsnj.AiQmSGrHWgxcjc1", "C\x05ngstrC6m" },
  { "$gy$j75$.......", "$gy$j75$.......$JI3XmF.GJLU2ehT7MWJOXSXZXfS3qyuD5dNwM.UyncC", "C\x05ngstrCU*U***U*" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$PN.APUSSEkkGmn.wqEhL91YdgcUPUxQtY.ObziHvs8/", "C\x05ngstrCU*U***U*" },
  { "$gy$j85$.......", "$gy$j85$.......$gb4f1IcvEAQor7/I1Xe2P9DQ4Ufi7esTzf5TFOf4U9B", "C\x05ngstrCU*U***U*" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$scA6FwGGUwgLdOSc4U7H4crOp25qk.KU/.PTeDL.yW8", "C\x05ngstrCU*U***U*" },
  { "$gy$j75$.......", "$gy$j75$.......$ZRoDq9Y3NPunxRkzntmuoM.Kv0hKLyHfnnEI0ne1aK1", "U*U***U*ignored" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$HEBJLsXS9iDBx7Sl7Kh32V4F7e1uL1ZexBGuNBi1yQ1", "U*U***U*ignored" },
  { "$gy$j85$.......", "$gy$j85$.......$3FobIobqjw5UrNb8OhkBu.MKUGl5DPluj7fKDx54Y.A", "U*U***U*ignored" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$Q5.H9bsApL0bFe4DFp0.ebFePnh8D44Ozc5vDxovTdD", "U*U***U*ignored" },
  { "$gy$j75$.......", "$gy$j75$.......$pb.gwC5hQUaEdshckBgBtPIZKFmfueHpYL8.uNk6I2.", "U*U*U*U*" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$PkLZ8OGN5g1v4L5W1ZjinoSe0XUOvhKzr7gjbq05fN/", "U*U*U*U*" },
  { "$gy$j85$.......", "$gy$j85$.......$TIknUuGwu6vYQDkk6E0EU.fpcpAnYEFnekdIsZem1K.", "U*U*U*U*" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$MgRKQgAz86P0Ig/9PpVEya89VdIzRdyn.LjiZfJH0v9", "U*U*U*U*" },
  { "$gy$j75$.......", "$gy$j75$.......$h5gIYIw92xuGDjAJ1OheyTK4TprYAGlWtwZynoIRLx2", "U*U*U*U*ignored" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$KWomDMPtXlkKfoX8FNXyHU8w3M8/1NgchP0e6wqszd8", "U*U*U*U*ignored" },
  { "$gy$j85$.......", "$gy$j85$.......$GYg4b6ZmzsUvkL/ZWB7zEKEtqdut6ExxI./ttIuBel4", "U*U*U*U*ignored" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$4f5qvAhZwrNQ757j9VgQRb6VWIVsRdUJL5.OIROwlJ9", "U*U*U*U*ignored" },
  { "$gy$j75$.......", "$gy$j75$.......$.95v53CDmbdxsfgzKki6y/hUGPTphFNQ.jHwVvD2Ly0", "*U*U*U*U" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$dx7MeqVF.xJON221S8MehLC/2EF8Pvf5WuJRrS24dC8", "*U*U*U*U" },
  { "$gy$j85$.......", "$gy$j85$.......$fQrHG0v6eXFH6sIC5UVMspOGuvMKgWCq2aCgCEXfd20", "*U*U*U*U" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$8dHc3EiE9IjD0h/ib0q9EKoMG4FEHTkhgjgIo7VT8d9", "*U*U*U*U" },
  { "$gy$j75$.......", "$gy$j75$.......$5r9KPMPnInksPEuazZ18bXSPZ0TP4kwzXnS5.pNtmXB", "*U*U*U*U*" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$ilac/bjcWM7ayt0Mwr1OHdDhjbbKnlxwZoLpJJEn.UB", "*U*U*U*U*" },
  { "$gy$j85$.......", "$gy$j85$.......$KAuVnqdHNxhmbgJylzwVUqM5bKMe8sE2TCqywtMwOb7", "*U*U*U*U*" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$kp4PvkqiaTxVwoNJamchNjbWumjH4c//JeT4D4zuxR4", "*U*U*U*U*" },
  { "$gy$j75$.......", "$gy$j75$.......$PdBPO1IcU7Dfz7n3IL4RF8EbKNrqIG1vxRhagQlWxw9", "*U*U*U*U*U*U*U*U" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$prcqek/w3CFRJaXis7k/NrNBdXgPbmpZdEvD5IjzcaB", "*U*U*U*U*U*U*U*U" },
  { "$gy$j85$.......", "$gy$j85$.......$Bhc4g7.eAbnHsK6OreunJktj0LIBi3ACMFB2wx57gpC", "*U*U*U*U*U*U*U*U" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$J9j48wlufw3FOnWXZiP8f.hefuj5R1ccae6U4LoG2F7", "*U*U*U*U*U*U*U*U" },
  { "$gy$j75$.......", "$gy$j75$.......$A6O2sSnaQOloMRb97QEnRYMJgTh5m.IKg373cNiOqz6", "*U*U*U*U*U*U*U*U*" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$CZLRG4/sEZdXAI6EmhwKFU0TZbNJtlQSvn6ySei0fqB", "*U*U*U*U*U*U*U*U*" },
  { "$gy$j85$.......", "$gy$j85$.......$bTZ7DDwPdB8j.PVLLiez3aMXd0uIuWo.pGCEUtqTxq3", "*U*U*U*U*U*U*U*U*" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$5cLFTQ7/f1q761MZqL3QQnLO974KhVDK3pgPiqwR5W7", "*U*U*U*U*U*U*U*U*" },
  { "$gy$j75$.......", "$gy$j75$.......$dfeK1ue.MyJSj38VmaRY7vxEd0c82fmH40YJNWSdkY3", "\xa3" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$ZHNcBWtiGfWpz02p4Cg4GYsV4qGrfFRWZeDo8sjfXR7", "\xa3" },
  { "$gy$j85$.......", "$gy$j85$.......$pETIIQuwbukDPUVgFe9x5mY3LCMqPrsJ/1KGuFPrZD8", "\xa3" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$qxTX.XwoE.SJAeaBCcD2yVTlg2O6V6zmOm33nlDgac0", "\xa3" },
  { "$gy$j75$.......", "$gy$j75$.......$7Y4.WveE8WFV9.ew5aJMmWrOPss.8ie8uWGZ8eUI6fB", "\xa3""a" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$AperSj/SdcBCxSjaRTxDdm9xz/VgKpnYWZ72S/O.ORD", "\xa3""a" },
  { "$gy$j85$.......", "$gy$j85$.......$M8Kv58mhB6MLilozaAhoh5FONvWvrDmtcLHIXvu60X1", "\xa3""a" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$QbWXa8vFSzEYQMRkL6t0gdwOX.nip4LpquhYXPy44G7", "\xa3""a" },
  { "$gy$j75$.......", "$gy$j75$.......$W3bV.ZJDUq2pKdJz8t/8EUzvaxuoZdPB7jIHNMf4qY2", "\xd1\x91" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$PyDzJfpCroClRpIHx2A1LbY1yV99cVFBpDsxXBRUUt8", "\xd1\x91" },
  { "$gy$j85$.......", "$gy$j85$.......$vgenLSrIBWbkVX1mKj0.4e9fmIAhtOc/tvdYhr7DOH/", "\xd1\x91" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$.xW9F5znHb6bRogZkj/iMqJyx7LSWhPWJ74A5DijFHC", "\xd1\x91" },
  { "$gy$j75$.......", "$gy$j75$.......$XsnvURKnFtJQf3xR75dC62RqBdFrcm/R.S2h6qMa8QA", "\xa3""ab" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$2dml/8E6YfsNlXns47qs1HfTRG0QZoctMWYAAiVc119", "\xa3""ab" },
  { "$gy$j85$.......", "$gy$j85$.......$G8ticvG7nGXh5dihMNiSWWTZoConjhpOhDptcmEYy31", "\xa3""ab" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$Y4JGzKzjYxaMkKXOH.R6nuCivxD1mcvwtp/FvW.NJB.", "\xa3""ab" },
  { "$gy$j75$.......", "$gy$j75$.......$/YlCClBJX3gRIWRIWFHouJ/pPJK5EBoHOL7rOGa6ko5", "\xff\xff\xa3" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$pw9fGvwlUL6B8XLLsmikaG6GTD0CIXVj6NWfH/jbY8C", "\xff\xff\xa3" },
  { "$gy$j85$.......", "$gy$j85$.......$.ADe6iQ62NfgIUbfyBDeXzaJQVpA6VwBklKkjnLNRRD", "\xff\xff\xa3" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$ZlSujtcLWxd6vl8UQUPYSdKbwDKlYqAGKyd6HD8lCG4", "\xff\xff\xa3" },
  { "$gy$j75$.......", "$gy$j75$.......$etolgfLgQnYTGjLGhF4Ak/0lg2cm.RiwCl901dQShbB", "1\xa3""345" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$/yzytS9V3kQSvKduaFb0TJhQyGp11xP2IYti5e3x2o8", "1\xa3""345" },
  { "$gy$j85$.......", "$gy$j85$.......$KjpsCK/kTmF4X53GS2828Ddclkj5.R9YwrVEDEX16g0", "1\xa3""345" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$5FuoOfGJgxl8hVkHMuE9xyAuTbQJryfVGQX0RYx/102", "1\xa3""345" },
  { "$gy$j75$.......", "$gy$j75$.......$QhTBmXTFPaRZCTeBq2YZouowF7vbdubUUk3fHULDMD2", "\xff\xa3""345" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$2/PMQbmxJVbvXF0a5q8TvFIFXIvuyakUQDz/x6wavb0", "\xff\xa3""345" },
  { "$gy$j85$.......", "$gy$j85$.......$sJhENr.9tjU43kTPMiNLy6y9r9iP5Q6A5CEhhNQiD22", "\xff\xa3""345" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$YqqZ.VOXJtWdHxKf6fgFGKmdLKHzk1wINFL678YJOK6", "\xff\xa3""345" },
  { "$gy$j75$.......", "$gy$j75$.......$8zsZiUX2E1SXL/NLoYrmIJpyhlF9bR/7c.beu91HuW.", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$hsaNxokXGddBWmvjbm//QNsWRW4y/W6ElvNul.3KRE1", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$gy$j85$.......", "$gy$j85$.......$VjzE.ltCX4NjGB6/wo4YOOfsbvrHqC3loLZcXqrrH/.", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$xdWdeN1fMHEZrzAyX8xot6XN4TOodQZBjhZgNu.n9t6", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$gy$j75$.......", "$gy$j75$.......$rNSIEwZ9A9.VT2aMVSHvAKgLmy6X93cN.2fVjA4jcj7", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$HtB2DxTt6hBQNvSS0OVUyotc6mF8zXIulGC8i4N/8M8", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$gy$j85$.......", "$gy$j85$.......$SGjpChZGrJrh4tjMQNlWHbxuXJy9ofzUThuAqpjNiZ.", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$9EXtL13D7IAOHCyDl06bEyDdvPzGHAJyRWMSUpX.N15", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$gy$j75$.......", "$gy$j75$.......$OObIA2eneYrC9Hv6nS6wYvbm9vyPM.zi6gw1fU.eLy6", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$Coco8Ms9cTsApbGikhGGCnPEE3dSuVjFTUvjBaePnQA", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$gy$j85$.......", "$gy$j85$.......$KLraiuzjVKrlxr5j5AC2J7slssws95G5o67.lPGDQu/", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$M0SCsrVDn9X7rZ7/tBr.e9a0VVVYkOEpKfn.B2uOq9B", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$gy$j75$.......", "$gy$j75$.......$Kufo3tnBeB1VeYNwCLQqbRPaUcKAvS8qoWBR2OLfA9C", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$/PoQ1T4MAgC85QGvPDQgRlbHymcS8hj1dFZfc.dw/uC", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$gy$j85$.......", "$gy$j85$.......$mEHUx6S6ZHfWsT9pvOix7TEHRu7Cd6aApJFzj4j/pW.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$R.bEEI5eTMs9P8AE4LTVjn9zv6DmH4LI89NrYXwyDM1", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$gy$j75$.......", "$gy$j75$.......$1LS6.oC2/ngI/4dQ2idiuuu/dyNCxkBF3XFYzIbPZkD", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$6P.Bvon4OtDfLnKiZvFWUotcjScUQMkP/qfwL2sfFkA", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$gy$j85$.......", "$gy$j85$.......$UvIQWwYbXTE2VO/eZJ3RAaQwBOQsPmrXBcuVtOQQQI5", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$JO.6V8aM9mE29i07h2BUTMV3ZD9AEEJU35obokiLLa.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$gy$j75$.......", "$gy$j75$.......$5Q/Xt3ErIeGXaA8Ofe.5LKpZI5iqJNWHdstY/usxRgA", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$CJoPT8pQoOzIEd9rVhXbqSpAPSOLOIqO4SMODSg7ri8", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$gy$j85$.......", "$gy$j85$.......$RaFsuYTQlb3xEiSU6Kl5et2Kvi32lptpgvPlaU7EzCC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$SPFeE5GnWOkp5u.ML/V1wB8ouox75IK05AlDrU/0lZD", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$gy$j75$.......", "$gy$j75$.......$wh1PjR8WTxkAemIWAb/BEggLZRDqVPuFu6bjeGru.f6", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$A5JdRvZdUnm8dRZ6TorakNVqTOHIM8BGA2NyWVr05OD", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$gy$j85$.......", "$gy$j85$.......$H.CaCtAHpd/KJjU963DcDfd/JZ0H3ObF3LC8odpE/9D", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$DDg2lHaFqes4dZMBkmrSrngFEV5GtaOCwBInxvkukzC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$gy$j75$.......", "$gy$j75$.......$3HgXHJ0LvV/stryxOfrNtPM/4/WU0JVUO6MiFD9.Lp5", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$wXYInodkebOrIbqkAFikwcPHhk3o04P5O53fIsEwj96", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$gy$j85$.......", "$gy$j85$.......$fK3M2aH3JO8aglZalDgPEZcni3b4TeUDe8fdwppGJ7B", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$lH0hnbEgsYcM43SD7OK/K5.6FuhwF/a0kSCav6WK.A4", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$gy$j75$.......", "$gy$j75$.......$eM1eggivZnmLlacaqwcED8oe9/TfLuPQezj.xR0fiC7", "THE YEAR" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$tJg7PZ3RWCiTHYH5k4CwP93mvcLHrQcXEpzxH0fJbe.", "THE YEAR" },
  { "$gy$j85$.......", "$gy$j85$.......$AKYs/ze5RzoPsxsE2SCEHYW1nAXZrp4twD6Acs77NbC", "THE YEAR" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$IY1fJnlULLmIAz2CvZsExBXae6sjcuAaHSGaNYYthYD", "THE YEAR" },
  { "$gy$j75$.......", "$gy$j75$.......$8X.enacaiXWDH4xyB8vLrQiKv/8cVKIsfiiiQuNRAJC", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$OnN/GHEFcUP9DoI9ArdfcX7BWxwA6oLeiaT9SNl5/w7", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$gy$j85$.......", "$gy$j85$.......$1ZY7rHIXoxc3D5pA6.bH6SQN9wgRYU2pqhAoC39LpA5", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$4MVk6KBvVvhCjGXK74jbGwhWWLOixShEBmfzgZ6MoaC", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$gy$j75$.......", "$gy$j75$.......$F05eoM783SXbeWIx7Qpb9AXsyokxft9cmeFW7LSQqi8", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j75$LdJMENpBABJJ3hIHjB1Bi.$GYt3.jbzAzZYLZrGFeJ5V1u0q7oHrijnZH.H.DcVT11", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$gy$j85$.......", "$gy$j85$.......$ThY51yoJZcdxhDAZLP.XKU0aD0BBU5iQ.YkpPLjOiW.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.", "$gy$j85$LdJMENpBABJJ3hIHjB1Bi.$8woNvgPfpTpOqf5FSLZukSAZ7qudVXPmR0CerJh5UWD", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // gost_yescrypt

#if INCLUDE_md5crypt && defined TEST_md5crypt
  { "$1$CCCCCCCC", "$1$CCCCCCCC$3VEFvYjOvLeslZkqpLoqn.", "" },
  { "$1$abcdefgh", "$1$abcdefgh$M55TzYaaccxVGbptZWaxX/", "" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$fF1eBrniyJJXCQxhnuZWu/", " " },
  { "$1$abcdefgh", "$1$abcdefgh$O7BjR/ZHapYPQbSTcq4Nq1", " " },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$G8nuxHw3XLmkyKhpNPCog.", "a" },
  { "$1$abcdefgh", "$1$abcdefgh$jUYc1Xi7pkozuzWQ0Dft71", "a" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$EjzjgyBQi50ijfMgLXBe11", "ab" },
  { "$1$abcdefgh", "$1$abcdefgh$Vp3YNwpcydYzv31o3cmRg/", "ab" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$feWwGi1u/IRJbumxdmIKi0", "abc" },
  { "$1$abcdefgh", "$1$abcdefgh$Kn5qrjcQzV7oAHBJ23Cu3/", "abc" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$gw92IW7tqCd0lx8RLT6Xd0", "U*U" },
  { "$1$abcdefgh", "$1$abcdefgh$MgWcALXH6GdKt4lgu3JCA/", "U*U" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$hgLez9pNcD04OdMFn5Aid1", "U*U*" },
  { "$1$abcdefgh", "$1$abcdefgh$r0botEXKzX1B2i63LvkBU/", "U*U*" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$2n0GWD4YaCrGB0j9A1rQt0", "U*U*U" },
  { "$1$abcdefgh", "$1$abcdefgh$U7jk83m0mbZHeDFC1osTv0", "U*U*U" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$KV2Sv2T97eDjbQKa.Scjm/", "....." },
  { "$1$abcdefgh", "$1$abcdefgh$rJpkRIK5xqCYuBQrFSSpu/", "....." },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$9rSWi2uvoMaF4tuRo/FmT1", "dragon" },
  { "$1$abcdefgh", "$1$abcdefgh$gyPqltr49ET96qfEMI36o/", "dragon" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$GJiVP2WgZ2g7d.8WZIYtt.", "dRaGoN" },
  { "$1$abcdefgh", "$1$abcdefgh$DT8OQqxRq0eFPYY0AlLBI1", "dRaGoN" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$fjxnrgDnpXEDdB2LhMYzg.", "DrAgOn" },
  { "$1$abcdefgh", "$1$abcdefgh$RC6u3Q4xCFpJ/H/9Mdd7x0", "DrAgOn" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$fPCBG64zc9zVh2lOUuDzz1", "PAROLX" },
  { "$1$abcdefgh", "$1$abcdefgh$P/TbBAvAzGkKmD2eCFwS51", "PAROLX" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$ZFa4RVhiKKr2BjumIRKLY.", "U*U***U" },
  { "$1$abcdefgh", "$1$abcdefgh$SL24g8PA7capmoHnO2tLr0", "U*U***U" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$kzV44m6FcLqPKlmR.ensm/", "abcdefg" },
  { "$1$abcdefgh", "$1$abcdefgh$F.A05.w2tKCW6T1uhxZYJ/", "abcdefg" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$PVyf3huWcnHp.eMatEdTx1", "01234567" },
  { "$1$abcdefgh", "$1$abcdefgh$ndt42kAlt/A34dn3RG9Hb/", "01234567" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$D6VIjDq8l9PRLFIQ4dkbN.", "726 even" },
  { "$1$abcdefgh", "$1$abcdefgh$r6lRjJ/vvwnG/tlAi9OQc.", "726 even" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$neVLpneLdTzs2AguXgadz/", "zyxwvuts" },
  { "$1$abcdefgh", "$1$abcdefgh$HXgBrBO6l8eRk1w0fblnH.", "zyxwvuts" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$rr/FYyvajUIk4JcYMCsqw1", "ab1234567" },
  { "$1$abcdefgh", "$1$abcdefgh$RtTAt.JhGdQVc2itkTYbS.", "ab1234567" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$232NhbDiq0GNSDCea4DTz/", "alexander" },
  { "$1$abcdefgh", "$1$abcdefgh$z8M6ycmJ1OciX9vhv6XBW/", "alexander" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$0CaezolaUbbpq/dIbB3zc1", "beautiful" },
  { "$1$abcdefgh", "$1$abcdefgh$SQTzRjDY3bXAidB.WGpYA/", "beautiful" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$2OJ.i7uNxiGR0QpcC41FK/", "challenge" },
  { "$1$abcdefgh", "$1$abcdefgh$7/4aP4i2U1OVKKxGdkXYK/", "challenge" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$C0xdYrrcROWSoB.A1mkpm/", "chocolate" },
  { "$1$abcdefgh", "$1$abcdefgh$.3RF/pxvzv7Usl0FYBu8R0", "chocolate" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$BX3EUhgVc046dPA2aK1jv1", "cr1234567" },
  { "$1$abcdefgh", "$1$abcdefgh$KeHYGRfRiCVyBt.zyEmvC0", "cr1234567" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$PM5tGbAZr2mQocZUPnnmK/", "katherine" },
  { "$1$abcdefgh", "$1$abcdefgh$ATOPrDtE2LBiLO7FZouMY1", "katherine" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$1gp52OR0MPKH8LfNF6uoc1", "stephanie" },
  { "$1$abcdefgh", "$1$abcdefgh$HWr7QFFJlg.qzuajUZeNo.", "stephanie" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$XnZshSTLEoW9.yPGVijpA/", "sunflower" },
  { "$1$abcdefgh", "$1$abcdefgh$VlDMZ8Yy3ahVZpYnSeauX.", "sunflower" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$ymdTuavwPu.hO/2D4B8Bs/", "basketball" },
  { "$1$abcdefgh", "$1$abcdefgh$v3r7hyJfpbJVlZPQGueCF.", "basketball" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$b0RKtgL2MCXW0qPX6r54b0", "porsche911" },
  { "$1$abcdefgh", "$1$abcdefgh$aw9.XNDWJA0DtFT2Jhjmf1", "porsche911" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$nlIUzfjWxs2U7Axp.WQZF1", "|_337T`/p3" },
  { "$1$abcdefgh", "$1$abcdefgh$OEAL/g.n7FoYsHk2N9FDm1", "|_337T`/p3" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$1ZF01ppNU3L6LTgcFtexS/", "thunderbird" },
  { "$1$abcdefgh", "$1$abcdefgh$D9jDI5vFMKtr6gizj5VjR1", "thunderbird" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$rJ.yZpWZdEhUcaGDAvyzP0", "Hello world!" },
  { "$1$abcdefgh", "$1$abcdefgh$fzmjzFdo5nMtBG8gtud5e0", "Hello world!" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$/nC1ARcvhLEJ2FHKRkBbK1", "pleaseletmein" },
  { "$1$abcdefgh", "$1$abcdefgh$3qy9r54GtjsyVILgK0aOa.", "pleaseletmein" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$r0lPgYOthMsmbdXDT2JVh/", "a short string" },
  { "$1$abcdefgh", "$1$abcdefgh$4.48BCvaYOCpQt50Y430b0", "a short string" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$AOrFbY68VuK/iYF2YmCwj.", "zxyDPWgydbQjgq" },
  { "$1$abcdefgh", "$1$abcdefgh$YtwIsfm2sDo6qgYsu5Ii.1", "zxyDPWgydbQjgq" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$UsbDzObTc7njWzvooxioG.", "photojournalism" },
  { "$1$abcdefgh", "$1$abcdefgh$vTwWkt.61b178rKwdPmyU.", "photojournalism" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$YF.So56GLoDKmLeZdudRb/", "ecclesiastically" },
  { "$1$abcdefgh", "$1$abcdefgh$x.4Hvf9t2FLspOzG1fCBr/", "ecclesiastically" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$lGAtGVGP5wFLgvGsdUuDA.", "congregationalism" },
  { "$1$abcdefgh", "$1$abcdefgh$IuWBvGW1pUxwqzbycdjfN.", "congregationalism" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$XnvN61jk3QGTbPOLYzMIq1", "dihydrosphingosine" },
  { "$1$abcdefgh", "$1$abcdefgh$aVbFx8M7gjfV9fc3.jrK50", "dihydrosphingosine" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$qTggqR60CB/DZ7D1g66WB0", "semianthropological" },
  { "$1$abcdefgh", "$1$abcdefgh$CjguQzuQU8zYdzO08NwJq/", "semianthropological" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$Fs2ZhR.fzIcLkzNVljjwl0", "palaeogeographically" },
  { "$1$abcdefgh", "$1$abcdefgh$xck3UcDH7lIOFLC9YHcfH0", "palaeogeographically" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$gq4ReK9TyFSQiunk9dXNc1", "electromyographically" },
  { "$1$abcdefgh", "$1$abcdefgh$pxvjfPct1kja4b/zs/a4w1", "electromyographically" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$uZArZttLs4Me7t4mhb.NA1", "noninterchangeableness" },
  { "$1$abcdefgh", "$1$abcdefgh$z2bNvZ.Ghp0y2QxRj/lI0/", "noninterchangeableness" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$N7SF4UPzT5sF0Ab9JkjTw0", "abcdefghijklmnopqrstuvwxyz" },
  { "$1$abcdefgh", "$1$abcdefgh$PUUA73rkgF7NpJCpUy0nH1", "abcdefghijklmnopqrstuvwxyz" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$om1uqQHIYK6Yg7uwQoyZj.", "electroencephalographically" },
  { "$1$abcdefgh", "$1$abcdefgh$iBygg/0KwmzuUKJXZHs3a/", "electroencephalographically" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$/H48fHVT4Vb3kzPt5B/Ux/", "antidisestablishmentarianism" },
  { "$1$abcdefgh", "$1$abcdefgh$gxeQVSJBHtRwspExzsGYB1", "antidisestablishmentarianism" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$RHjWx.M98KRbQXKzakD2X1", "cyclotrimethylenetrinitramine" },
  { "$1$abcdefgh", "$1$abcdefgh$o0DrqaV1Km7U/bvH.lnFe.", "cyclotrimethylenetrinitramine" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$rsroqf1CeL9MCRXzugE5k.", "dichlorodiphenyltrichloroethane" },
  { "$1$abcdefgh", "$1$abcdefgh$9u5RmjOdf4YvnCvNOheJA1", "dichlorodiphenyltrichloroethane" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$19F48bDspWw.nL9oeltvJ1", "multiple words seperated by spaces" },
  { "$1$abcdefgh", "$1$abcdefgh$ISZa8Bd6MhtOCY2RZxNHS.", "multiple words seperated by spaces" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$e03M.JG85W/Ceg0Jmit7P0", "supercalifragilisticexpialidocious" },
  { "$1$abcdefgh", "$1$abcdefgh$XjyDQRyWmrgHG/aPLip570", "supercalifragilisticexpialidocious" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$KnUTNWYq99MC3ieupa2Ps/", "we have a short salt string but not a short password" },
  { "$1$abcdefgh", "$1$abcdefgh$SzFLz7qPo5zlUc9riugWR.", "we have a short salt string but not a short password" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$J5jgRhocHN/1zF3Wodaj..", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$1$abcdefgh", "$1$abcdefgh$DAYp5MGob5QJ5B.zsKV0b1", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$i8oV0kZYcBU9CcOy.vjff/", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$1$abcdefgh", "$1$abcdefgh$gRJNFY8U.ACWCSYdcGzsK.", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$7CfsiXMdA9cscLPyziddW0", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$1$abcdefgh", "$1$abcdefgh$HpCl68zMykh9X16y73S8N0", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$xvczMupCEqTEMdsbNvNmp0", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$1$abcdefgh", "$1$abcdefgh$j37CHvGkiOEUvY/w0I4gw1", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$HXricYVZu8bgI85Hv7Cq3.", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$1$abcdefgh", "$1$abcdefgh$xGvS9opNzTVoMbVPog4ha0", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$AoBBJ5BVtOtVDTW4gB2Nu0", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$1$abcdefgh", "$1$abcdefgh$Rsvboxu8AALo99ByYHO/z.", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$XsTrEjKT8enjnESvPmRrZ.", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$1$abcdefgh", "$1$abcdefgh$KDskBFOHq.zkwdRvOh1vE.", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$qyJQqz405Vy2EDzt8ANwM/", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$1$abcdefgh", "$1$abcdefgh$ld0cLXNNe45GlLjk/FUeb0", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$WCf0lStfTbXAJh8lZgcf//", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$1$abcdefgh", "$1$abcdefgh$0jy3aDbrPsoN.YgCUgG9P0", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$ztBvhxgwecESGOR9UyhRp.", "\xc3\xa9tude" },
  { "$1$abcdefgh", "$1$abcdefgh$ZQEnYbGW/Adt9cLn9yjwV/", "\xc3\xa9tude" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$Ny4b16WAD8aIhJzV2Hdsi.", "C)tude" },
  { "$1$abcdefgh", "$1$abcdefgh$R8W51vsbuWul19F22rgc4/", "C)tude" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$5mye/USugxlUzg6mXzZ78/", "Chl\xc3\xb6""e" },
  { "$1$abcdefgh", "$1$abcdefgh$nxcLmY4E.1mOxFQAM.nVx0", "Chl\xc3\xb6""e" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$4zoZTVNmMVHoUAJkjMJxO0", "ChlC6e" },
  { "$1$abcdefgh", "$1$abcdefgh$NxKoGC3PkWPDQcaVPY0Da/", "ChlC6e" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$SGa7fFS8YaUadEPpmiLcT1", "\xc3\x85ngstr\xc3\xb6m" },
  { "$1$abcdefgh", "$1$abcdefgh$1ieAOKER8H8Q8E9pWRDAL/", "\xc3\x85ngstr\xc3\xb6m" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$TcOpcz.jGk5G1oOnt1WZE1", "C\x05ngstrC6m" },
  { "$1$abcdefgh", "$1$abcdefgh$S2Rs2iVMhwLIoD.IVy/Br/", "C\x05ngstrC6m" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$6P2AiSKjDb/MRWxo5/TKB/", "C\x05ngstrCU*U***U*" },
  { "$1$abcdefgh", "$1$abcdefgh$ZyL0yNgxjea9B0nAIiOb81", "C\x05ngstrCU*U***U*" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$WQUEqsaUgBt/KwWzhwoU01", "U*U***U*ignored" },
  { "$1$abcdefgh", "$1$abcdefgh$wBnlJdQykzoCl7zpRg5mk1", "U*U***U*ignored" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$nJMgkPMU61cAabNxupF4e0", "U*U*U*U*" },
  { "$1$abcdefgh", "$1$abcdefgh$s7nrRJjPHTR5VyMXFUOR.0", "U*U*U*U*" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$ovvoeLls1/ni2cpTOQdEm1", "U*U*U*U*ignored" },
  { "$1$abcdefgh", "$1$abcdefgh$8SPAiyyWUxp.IGr/rFjAF/", "U*U*U*U*ignored" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$watTtD/zvc5Fq4Z8I/V4i.", "*U*U*U*U" },
  { "$1$abcdefgh", "$1$abcdefgh$JtVGN5QQGqdEUIr2DPDnH0", "*U*U*U*U" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$w9RqVTcK.GSJX5nqROGfw1", "*U*U*U*U*" },
  { "$1$abcdefgh", "$1$abcdefgh$he.rHYpSVPrQ6zOmBIVUk.", "*U*U*U*U*" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$Z92WSOtMLK5z/RgSrsIZV0", "*U*U*U*U*U*U*U*U" },
  { "$1$abcdefgh", "$1$abcdefgh$QI10y/BEoUb2DndAp1GmF/", "*U*U*U*U*U*U*U*U" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$aPvdu9a759jHQAwa6zDTB.", "*U*U*U*U*U*U*U*U*" },
  { "$1$abcdefgh", "$1$abcdefgh$IbeuoYf5T8SG6zOOe06a00", "*U*U*U*U*U*U*U*U*" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$naH8Ddw2hni3K6EBuhhqO/", "\xa3" },
  { "$1$abcdefgh", "$1$abcdefgh$2bBGUs.MaAMF/GswXhbTM1", "\xa3" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$VNWLRC3x8d1LdF0Ult/6k/", "\xa3""a" },
  { "$1$abcdefgh", "$1$abcdefgh$b4GBSPqq29.5uSGAdEm5V1", "\xa3""a" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$4s.VBq0BxC5QCae9ZrZVb.", "\xd1\x91" },
  { "$1$abcdefgh", "$1$abcdefgh$YdLYoJwm9dp95oN7TuIye/", "\xd1\x91" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$zNyWM22x6Oj01T7wU9t880", "\xa3""ab" },
  { "$1$abcdefgh", "$1$abcdefgh$vIfeQm2KwLPlHwVfN4Eqf/", "\xa3""ab" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$N56OzIlm0dgH2dCTfCJwM0", "\xff\xff\xa3" },
  { "$1$abcdefgh", "$1$abcdefgh$GoUrYKmAk2AGHJA1iJccH1", "\xff\xff\xa3" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$Z1jBzcsJuaDyWnL.BzznP1", "1\xa3""345" },
  { "$1$abcdefgh", "$1$abcdefgh$8sTvaVzVcRcxrFZ2ZTvoy/", "1\xa3""345" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$HlH6u4jaAlgbA31qxx0mn.", "\xff\xa3""345" },
  { "$1$abcdefgh", "$1$abcdefgh$EvqgIpKkkXaucuZH10LoY/", "\xff\xa3""345" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$rTb1DMSszWMgS/kNnuDCV.", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$1$abcdefgh", "$1$abcdefgh$pt7agU8yTzKdDB/RIzdWl.", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$8XbJ0x.3VArmvlna09qgw1", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$1$abcdefgh", "$1$abcdefgh$LDWZ6yPRz1pfZnrCR3NMl0", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$jPqxrmlwfjnt8.QPFPR5E0", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$1$abcdefgh", "$1$abcdefgh$KP06ldpOd.6om40DB7BD11", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$OvKP7wmqPIMxqvmd3idHc1", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$1$abcdefgh", "$1$abcdefgh$0lRoLbWrDtFCdbPXsCGeQ/", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$uul920dnxWu.YFRNsmBuO/", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$1$abcdefgh", "$1$abcdefgh$8qkEzjcTUyyWHpDKU1Ck3.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$CsqLLDOcxcaf.yLPQCA4c0", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$1$abcdefgh", "$1$abcdefgh$K0NgKIz4p8cq6H9GHXMwD0", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$zWTB4WxPAwUyt18y5Zc31.", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$1$abcdefgh", "$1$abcdefgh$zNuGPTPch3zuDqO7yQzkx/", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$J91yKhxXfvtUnYMc.dJRS0", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$1$abcdefgh", "$1$abcdefgh$JW/dlwDB3OEb0pH8o5rFJ0", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$Gsh1Cpbqgk.zHFemcUtVH.", "THE YEAR" },
  { "$1$abcdefgh", "$1$abcdefgh$wX/XLDulTCITBlw11On0e1", "THE YEAR" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$RKWSDpG6MqWtaVJXPLGFn0", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$1$abcdefgh", "$1$abcdefgh$q5HH4Ys2I.htqrplqRNBW.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$1$CCCCCCCC", "$1$CCCCCCCC$9DWTJzTp2eEsXN/hOgDyO/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$1$abcdefgh", "$1$abcdefgh$qJ70XApTatr8UBxoCT2tj1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // md5crypt

#if INCLUDE_nt && defined TEST_nt
  { "$3$", "$3$$31d6cfe0d16ae931b73c59d7e0c089c0", "" },
  { "$3$__not_used__0123456789abcdef", "$3$$31d6cfe0d16ae931b73c59d7e0c089c0", "" },
  { "$3$", "$3$$71c5391067de41fad6f3063162e5eeff", " " },
  { "$3$__not_used__0123456789abcdef", "$3$$71c5391067de41fad6f3063162e5eeff", " " },
  { "$3$", "$3$$186cb09181e2c2ecaac768c47c729904", "a" },
  { "$3$__not_used__0123456789abcdef", "$3$$186cb09181e2c2ecaac768c47c729904", "a" },
  { "$3$", "$3$$79312f7ee81e59d4e76a15021e74b597", "ab" },
  { "$3$__not_used__0123456789abcdef", "$3$$79312f7ee81e59d4e76a15021e74b597", "ab" },
  { "$3$", "$3$$e0fba38268d0ec66ef1cb452d5885e53", "abc" },
  { "$3$__not_used__0123456789abcdef", "$3$$e0fba38268d0ec66ef1cb452d5885e53", "abc" },
  { "$3$", "$3$$ceb4a53eab759a7b5da77a864c89969f", "U*U" },
  { "$3$__not_used__0123456789abcdef", "$3$$ceb4a53eab759a7b5da77a864c89969f", "U*U" },
  { "$3$", "$3$$020b0e67d1f7cf9572872be20eea8e46", "U*U*" },
  { "$3$__not_used__0123456789abcdef", "$3$$020b0e67d1f7cf9572872be20eea8e46", "U*U*" },
  { "$3$", "$3$$4a8c3c762ab3d8555d9c56c10c22192c", "U*U*U" },
  { "$3$__not_used__0123456789abcdef", "$3$$4a8c3c762ab3d8555d9c56c10c22192c", "U*U*U" },
  { "$3$", "$3$$c68e5da4d65da3c0af82c12b570a70db", "....." },
  { "$3$__not_used__0123456789abcdef", "$3$$c68e5da4d65da3c0af82c12b570a70db", "....." },
  { "$3$", "$3$$f7eb9c06fafaa23c4bcf22ba6781c1e2", "dragon" },
  { "$3$__not_used__0123456789abcdef", "$3$$f7eb9c06fafaa23c4bcf22ba6781c1e2", "dragon" },
  { "$3$", "$3$$daa481bd1f162914a274e2a245f8109e", "dRaGoN" },
  { "$3$__not_used__0123456789abcdef", "$3$$daa481bd1f162914a274e2a245f8109e", "dRaGoN" },
  { "$3$", "$3$$4797812bea44e9096249023d368fb105", "DrAgOn" },
  { "$3$__not_used__0123456789abcdef", "$3$$4797812bea44e9096249023d368fb105", "DrAgOn" },
  { "$3$", "$3$$c772c8e4d04f243c605cce71ee6f62eb", "PAROLX" },
  { "$3$__not_used__0123456789abcdef", "$3$$c772c8e4d04f243c605cce71ee6f62eb", "PAROLX" },
  { "$3$", "$3$$f853ef408446648d7b169102806b7c0d", "U*U***U" },
  { "$3$__not_used__0123456789abcdef", "$3$$f853ef408446648d7b169102806b7c0d", "U*U***U" },
  { "$3$", "$3$$352dfe551d62459b20349b78a21a2f37", "abcdefg" },
  { "$3$__not_used__0123456789abcdef", "$3$$352dfe551d62459b20349b78a21a2f37", "abcdefg" },
  { "$3$", "$3$$380bc5229eacff2c5552486b68a6ccc5", "01234567" },
  { "$3$__not_used__0123456789abcdef", "$3$$380bc5229eacff2c5552486b68a6ccc5", "01234567" },
  { "$3$", "$3$$7fbb217faea46857f612f84bfe10e812", "726 even" },
  { "$3$__not_used__0123456789abcdef", "$3$$7fbb217faea46857f612f84bfe10e812", "726 even" },
  { "$3$", "$3$$b3c508fbd73269591969bfb8fbfb183c", "zyxwvuts" },
  { "$3$__not_used__0123456789abcdef", "$3$$b3c508fbd73269591969bfb8fbfb183c", "zyxwvuts" },
  { "$3$", "$3$$ddc0dcdede6610bb6a0ee2d44311be88", "ab1234567" },
  { "$3$__not_used__0123456789abcdef", "$3$$ddc0dcdede6610bb6a0ee2d44311be88", "ab1234567" },
  { "$3$", "$3$$b2afd3ee7005887d914650f0d30231c0", "alexander" },
  { "$3$__not_used__0123456789abcdef", "$3$$b2afd3ee7005887d914650f0d30231c0", "alexander" },
  { "$3$", "$3$$9f76131357710f136b9827c3996a9baa", "beautiful" },
  { "$3$__not_used__0123456789abcdef", "$3$$9f76131357710f136b9827c3996a9baa", "beautiful" },
  { "$3$", "$3$$1597f8e3b872d5348767416f6921d346", "challenge" },
  { "$3$__not_used__0123456789abcdef", "$3$$1597f8e3b872d5348767416f6921d346", "challenge" },
  { "$3$", "$3$$b8018bbb613b4454d120f964b27c0335", "chocolate" },
  { "$3$__not_used__0123456789abcdef", "$3$$b8018bbb613b4454d120f964b27c0335", "chocolate" },
  { "$3$", "$3$$49ebe86d5beb8fd388ae37b865a52a0b", "cr1234567" },
  { "$3$__not_used__0123456789abcdef", "$3$$49ebe86d5beb8fd388ae37b865a52a0b", "cr1234567" },
  { "$3$", "$3$$163e842740652fa1f35b4e979e5d40f1", "katherine" },
  { "$3$__not_used__0123456789abcdef", "$3$$163e842740652fa1f35b4e979e5d40f1", "katherine" },
  { "$3$", "$3$$cc01ce7709c35d13429488edde7b58b1", "stephanie" },
  { "$3$__not_used__0123456789abcdef", "$3$$cc01ce7709c35d13429488edde7b58b1", "stephanie" },
  { "$3$", "$3$$22958710c569d1fa791f43aba4d4e9ea", "sunflower" },
  { "$3$__not_used__0123456789abcdef", "$3$$22958710c569d1fa791f43aba4d4e9ea", "sunflower" },
  { "$3$", "$3$$cf5fd610b326e61f175e3a9bac4751f9", "basketball" },
  { "$3$__not_used__0123456789abcdef", "$3$$cf5fd610b326e61f175e3a9bac4751f9", "basketball" },
  { "$3$", "$3$$f4cac307bff26ea1aa0189e361d39212", "porsche911" },
  { "$3$__not_used__0123456789abcdef", "$3$$f4cac307bff26ea1aa0189e361d39212", "porsche911" },
  { "$3$", "$3$$ca8ad8058c3226764a3af34a8edcbb2e", "|_337T`/p3" },
  { "$3$__not_used__0123456789abcdef", "$3$$ca8ad8058c3226764a3af34a8edcbb2e", "|_337T`/p3" },
  { "$3$", "$3$$0dee2479a5d39b0a7ced5776173596eb", "thunderbird" },
  { "$3$__not_used__0123456789abcdef", "$3$$0dee2479a5d39b0a7ced5776173596eb", "thunderbird" },
  { "$3$", "$3$$87ee0af454a9cb8d90d24196068637a8", "Hello world!" },
  { "$3$__not_used__0123456789abcdef", "$3$$87ee0af454a9cb8d90d24196068637a8", "Hello world!" },
  { "$3$", "$3$$50ba50a9c78298045b88320ea47fd387", "pleaseletmein" },
  { "$3$__not_used__0123456789abcdef", "$3$$50ba50a9c78298045b88320ea47fd387", "pleaseletmein" },
  { "$3$", "$3$$d1a71e89e521aa81176f6ddf3b86b68c", "a short string" },
  { "$3$__not_used__0123456789abcdef", "$3$$d1a71e89e521aa81176f6ddf3b86b68c", "a short string" },
  { "$3$", "$3$$f869abd36f7b31c1f9c4a213e49b559f", "zxyDPWgydbQjgq" },
  { "$3$__not_used__0123456789abcdef", "$3$$f869abd36f7b31c1f9c4a213e49b559f", "zxyDPWgydbQjgq" },
  { "$3$", "$3$$83200a50482a6daf45b2902ed52042f2", "photojournalism" },
  { "$3$__not_used__0123456789abcdef", "$3$$83200a50482a6daf45b2902ed52042f2", "photojournalism" },
  { "$3$", "$3$$0b83b68ba7a5ce58ed50bb0f9a5fa06a", "ecclesiastically" },
  { "$3$__not_used__0123456789abcdef", "$3$$0b83b68ba7a5ce58ed50bb0f9a5fa06a", "ecclesiastically" },
  { "$3$", "$3$$ebd2b24e1ee857784f6ac40fd500077e", "congregationalism" },
  { "$3$__not_used__0123456789abcdef", "$3$$ebd2b24e1ee857784f6ac40fd500077e", "congregationalism" },
  { "$3$", "$3$$40fabb09b52fb8a7843f7e1ee723cf03", "dihydrosphingosine" },
  { "$3$__not_used__0123456789abcdef", "$3$$40fabb09b52fb8a7843f7e1ee723cf03", "dihydrosphingosine" },
  { "$3$", "$3$$1eba95138c99f9a0621d24876eea2868", "semianthropological" },
  { "$3$__not_used__0123456789abcdef", "$3$$1eba95138c99f9a0621d24876eea2868", "semianthropological" },
  { "$3$", "$3$$5d6536aea6febd7b98e373cfd3f28a85", "palaeogeographically" },
  { "$3$__not_used__0123456789abcdef", "$3$$5d6536aea6febd7b98e373cfd3f28a85", "palaeogeographically" },
  { "$3$", "$3$$a27af10e890b5e0856360a4d993eeb77", "electromyographically" },
  { "$3$__not_used__0123456789abcdef", "$3$$a27af10e890b5e0856360a4d993eeb77", "electromyographically" },
  { "$3$", "$3$$3f820d837c34f4019203f9ae5df458e7", "noninterchangeableness" },
  { "$3$__not_used__0123456789abcdef", "$3$$3f820d837c34f4019203f9ae5df458e7", "noninterchangeableness" },
  { "$3$", "$3$$0bd63185f3484bb000286c85917dc12e", "abcdefghijklmnopqrstuvwxyz" },
  { "$3$__not_used__0123456789abcdef", "$3$$0bd63185f3484bb000286c85917dc12e", "abcdefghijklmnopqrstuvwxyz" },
  { "$3$", "$3$$ed5d6deb9f1510c55d8c825c05985a42", "electroencephalographically" },
  { "$3$__not_used__0123456789abcdef", "$3$$ed5d6deb9f1510c55d8c825c05985a42", "electroencephalographically" },
  { "$3$", "$3$$bf4dd2e2566dfb4fafae5f7b0ef32470", "antidisestablishmentarianism" },
  { "$3$__not_used__0123456789abcdef", "$3$$bf4dd2e2566dfb4fafae5f7b0ef32470", "antidisestablishmentarianism" },
  { "$3$", "$3$$260a9c487c4815769245a28c242ed260", "cyclotrimethylenetrinitramine" },
  { "$3$__not_used__0123456789abcdef", "$3$$260a9c487c4815769245a28c242ed260", "cyclotrimethylenetrinitramine" },
  { "$3$", "$3$$6674a3a9bb08c4e58b2cda57c66ea608", "dichlorodiphenyltrichloroethane" },
  { "$3$__not_used__0123456789abcdef", "$3$$6674a3a9bb08c4e58b2cda57c66ea608", "dichlorodiphenyltrichloroethane" },
  { "$3$", "$3$$51439a927ed19fe271002bb43f355758", "multiple words seperated by spaces" },
  { "$3$__not_used__0123456789abcdef", "$3$$51439a927ed19fe271002bb43f355758", "multiple words seperated by spaces" },
  { "$3$", "$3$$f5295d5b0a47abecb70ed08bdb6d4e6e", "supercalifragilisticexpialidocious" },
  { "$3$__not_used__0123456789abcdef", "$3$$f5295d5b0a47abecb70ed08bdb6d4e6e", "supercalifragilisticexpialidocious" },
  { "$3$", "$3$$626450a571c8959e9bfa9f48e935dd34", "we have a short salt string but not a short password" },
  { "$3$__not_used__0123456789abcdef", "$3$$626450a571c8959e9bfa9f48e935dd34", "we have a short salt string but not a short password" },
  { "$3$", "$3$$48370cb663dfc4a0a54555764653c7f3", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$3$__not_used__0123456789abcdef", "$3$$48370cb663dfc4a0a54555764653c7f3", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$3$", "$3$$2e74cc46c96ee4caee5df20d0898fef8", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$3$__not_used__0123456789abcdef", "$3$$2e74cc46c96ee4caee5df20d0898fef8", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$3$", "$3$$cf17b1ae2606afa964193690df7543b1", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$3$__not_used__0123456789abcdef", "$3$$cf17b1ae2606afa964193690df7543b1", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$3$", "$3$$556736618d1bc1343ad8ccc7d43e6d03", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$3$__not_used__0123456789abcdef", "$3$$556736618d1bc1343ad8ccc7d43e6d03", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$3$", "$3$$7d17e6e477db7a72b5b88d7cc9c5c6e7", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$3$__not_used__0123456789abcdef", "$3$$7d17e6e477db7a72b5b88d7cc9c5c6e7", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$3$", "$3$$39810dfba0f9bbfb2e115d56a5324d18", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$3$__not_used__0123456789abcdef", "$3$$39810dfba0f9bbfb2e115d56a5324d18", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$3$", "$3$$6107f1da1190680d85c060b621c50702", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$3$__not_used__0123456789abcdef", "$3$$6107f1da1190680d85c060b621c50702", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$3$", "$3$$fc52480ca4ecd0d0c2a40fdd69a34992", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$3$__not_used__0123456789abcdef", "$3$$fc52480ca4ecd0d0c2a40fdd69a34992", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$3$", "$3$$e11d090c0e5619e1468d25ed58978748", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$3$__not_used__0123456789abcdef", "$3$$e11d090c0e5619e1468d25ed58978748", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$3$", "$3$$14afdf1514c72786089966de5e09b928", "\xc3\xa9tude" },
  { "$3$__not_used__0123456789abcdef", "$3$$14afdf1514c72786089966de5e09b928", "\xc3\xa9tude" },
  { "$3$", "$3$$6f2b35b4fe89a75763f5c1e2b560f022", "C)tude" },
  { "$3$__not_used__0123456789abcdef", "$3$$6f2b35b4fe89a75763f5c1e2b560f022", "C)tude" },
  { "$3$", "$3$$398278be7fac0d1eedc81352055df0f4", "Chl\xc3\xb6""e" },
  { "$3$__not_used__0123456789abcdef", "$3$$398278be7fac0d1eedc81352055df0f4", "Chl\xc3\xb6""e" },
  { "$3$", "$3$$a36be97082fb9837c0cfbca4431b3121", "ChlC6e" },
  { "$3$__not_used__0123456789abcdef", "$3$$a36be97082fb9837c0cfbca4431b3121", "ChlC6e" },
  { "$3$", "$3$$7a42a07c229f3cc38d80acd4dc6ffdf9", "\xc3\x85ngstr\xc3\xb6m" },
  { "$3$__not_used__0123456789abcdef", "$3$$7a42a07c229f3cc38d80acd4dc6ffdf9", "\xc3\x85ngstr\xc3\xb6m" },
  { "$3$", "$3$$7c240517e69272d8e162da986b275aee", "C\x05ngstrC6m" },
  { "$3$__not_used__0123456789abcdef", "$3$$7c240517e69272d8e162da986b275aee", "C\x05ngstrC6m" },
  { "$3$", "$3$$18ce4e221995066db5eb9cc70bfe7a69", "C\x05ngstrCU*U***U*" },
  { "$3$__not_used__0123456789abcdef", "$3$$18ce4e221995066db5eb9cc70bfe7a69", "C\x05ngstrCU*U***U*" },
  { "$3$", "$3$$1eee46ce75794382efd97b8f45d0f011", "U*U***U*ignored" },
  { "$3$__not_used__0123456789abcdef", "$3$$1eee46ce75794382efd97b8f45d0f011", "U*U***U*ignored" },
  { "$3$", "$3$$cc2c846fbf2013694591d0ec141c4928", "U*U*U*U*" },
  { "$3$__not_used__0123456789abcdef", "$3$$cc2c846fbf2013694591d0ec141c4928", "U*U*U*U*" },
  { "$3$", "$3$$040763d90c35a7f6bdda15e25050d505", "U*U*U*U*ignored" },
  { "$3$__not_used__0123456789abcdef", "$3$$040763d90c35a7f6bdda15e25050d505", "U*U*U*U*ignored" },
  { "$3$", "$3$$3131bc805d3a46021b9f392cf32865a3", "*U*U*U*U" },
  { "$3$__not_used__0123456789abcdef", "$3$$3131bc805d3a46021b9f392cf32865a3", "*U*U*U*U" },
  { "$3$", "$3$$0e5c31b469e9563440fb046190337219", "*U*U*U*U*" },
  { "$3$__not_used__0123456789abcdef", "$3$$0e5c31b469e9563440fb046190337219", "*U*U*U*U*" },
  { "$3$", "$3$$f1940520dd599a5456144f76bd58cdca", "*U*U*U*U*U*U*U*U" },
  { "$3$__not_used__0123456789abcdef", "$3$$f1940520dd599a5456144f76bd58cdca", "*U*U*U*U*U*U*U*U" },
  { "$3$", "$3$$d110a48f7371b735dd04806f12c57798", "*U*U*U*U*U*U*U*U*" },
  { "$3$__not_used__0123456789abcdef", "$3$$d110a48f7371b735dd04806f12c57798", "*U*U*U*U*U*U*U*U*" },
  { "$3$", "$3$$e1ae1bf327fbcc23730f7db73a56ac44", "\xa3" },
  { "$3$__not_used__0123456789abcdef", "$3$$e1ae1bf327fbcc23730f7db73a56ac44", "\xa3" },
  { "$3$", "$3$$c709b0e6d1791452cbff9bc7344ac892", "\xa3""a" },
  { "$3$__not_used__0123456789abcdef", "$3$$c709b0e6d1791452cbff9bc7344ac892", "\xa3""a" },
  { "$3$", "$3$$4ee17ce1db45df7e2b63eaf5f70cda9d", "\xd1\x91" },
  { "$3$__not_used__0123456789abcdef", "$3$$4ee17ce1db45df7e2b63eaf5f70cda9d", "\xd1\x91" },
  { "$3$", "$3$$14cac4c35c77a1ed966b51fa42e2a9bc", "\xa3""ab" },
  { "$3$__not_used__0123456789abcdef", "$3$$14cac4c35c77a1ed966b51fa42e2a9bc", "\xa3""ab" },
  { "$3$", "$3$$3dd5944e24802eaf5c79a1612159756d", "\xff\xff\xa3" },
  { "$3$__not_used__0123456789abcdef", "$3$$3dd5944e24802eaf5c79a1612159756d", "\xff\xff\xa3" },
  { "$3$", "$3$$11ea99f039752eb3a546eeca3cf9f9a8", "1\xa3""345" },
  { "$3$__not_used__0123456789abcdef", "$3$$11ea99f039752eb3a546eeca3cf9f9a8", "1\xa3""345" },
  { "$3$", "$3$$27cc3d4e8b7ed255af0c71e510712391", "\xff\xa3""345" },
  { "$3$__not_used__0123456789abcdef", "$3$$27cc3d4e8b7ed255af0c71e510712391", "\xff\xa3""345" },
  { "$3$", "$3$$5b06d09bfab79cb270c95cd551997554", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$3$__not_used__0123456789abcdef", "$3$$5b06d09bfab79cb270c95cd551997554", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$3$", "$3$$207aa340ce45277a3fe0a449dd866e5a", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$3$__not_used__0123456789abcdef", "$3$$207aa340ce45277a3fe0a449dd866e5a", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$3$", "$3$$dbc6f00b397fb4e7495069aa36fd6db6", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$3$__not_used__0123456789abcdef", "$3$$dbc6f00b397fb4e7495069aa36fd6db6", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$3$", "$3$$f2352a9d32bd205080543902d7f0ebb0", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$3$__not_used__0123456789abcdef", "$3$$f2352a9d32bd205080543902d7f0ebb0", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$3$", "$3$$5a244c197ea731df985e08cfe273ddd8", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$3$__not_used__0123456789abcdef", "$3$$5a244c197ea731df985e08cfe273ddd8", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$3$", "$3$$51ba57575232c303f407d91bf1949cca", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$3$__not_used__0123456789abcdef", "$3$$51ba57575232c303f407d91bf1949cca", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$3$", "$3$$9d299c47c4a4759f9e6608d6cde88c3d", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$3$__not_used__0123456789abcdef", "$3$$9d299c47c4a4759f9e6608d6cde88c3d", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$3$", "$3$$eb300ad67bac4085d47c166a75efc7bf", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$3$__not_used__0123456789abcdef", "$3$$eb300ad67bac4085d47c166a75efc7bf", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$3$", "$3$$e1aeb5cac1f5fc905085787a81ff3a1f", "THE YEAR" },
  { "$3$__not_used__0123456789abcdef", "$3$$e1aeb5cac1f5fc905085787a81ff3a1f", "THE YEAR" },
  { "$3$", "$3$$c2b3fff2d75601bd8759e782256d0491", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$3$__not_used__0123456789abcdef", "$3$$c2b3fff2d75601bd8759e782256d0491", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$3$", "$3$$10c8c9d7aca870531d3647209f4f9bbf", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$3$__not_used__0123456789abcdef", "$3$$10c8c9d7aca870531d3647209f4f9bbf", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // nt

#if INCLUDE_scrypt && defined TEST_scrypt
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$SpJsFY2pIFcsdECgiLhE7VnInSJAT3kTfdlS6S6xFq9", "" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$5eHIcyF4C5bDzpiuGzYQQc1sIe60.UsmfjoNrxt5adA", "" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$YNmeZ8Ubrj9X2G.Id80j6RGT1rp6Pi2ZfUpzCG21dZ6", "" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$MHVhxrNwp6l3KndOGprjC2Go6U2ZoyHUGXYBX7mnlM8", "" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$XVKS1M06owVrhDhmhl2upMTpKBrSpJTIRPXIER0dYGC", " " },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$.lqTTv.oXq816RKZeJeqMXVnnGR9jcb3W2kWm23ubu0", " " },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$QGYQu4qLFgl0ToyUv5btcXxk7xMU5BovtmsLHYYT4j9", " " },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$bglUTSbAvHFOd5FwRuFMIFeWmFeuJeDMJxPbhNLxoT1", " " },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$3O/5oVC8v927Yhzj2bu8S8CyYleLle9tDi1rFTQhC57", "a" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$PFYi7kkAbbFJJo4LO7XenXepvOo0cAH0lqQyEusOru1", "a" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$A3TZmeiryDHQ2WPMhp4DJMj40uf7Gow9iHzQxhe7ikC", "a" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$XviMC77gAZJx0sr/dxV4Pr.OY5csaR.27w/bjvi4KVB", "a" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$nsG5DCq79pNVsIV9tJfaaDYfF5TKV213491RLvWYdFC", "ab" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$UIhkXrHHqBfavxeyz1WXixjNuEUcfycTC6qaTB4LuE4", "ab" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$WHUeP2Kz.d0azHgvtaz7fEuUff38B.ijOQrubDYvjz/", "ab" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$lI2ks79t8lOMoWSim7ImZ4grk4ByCn2LKTudAGnAxLB", "ab" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$WpfVhZgVj63.RiL2fAQZsLyYNROrrN67Wlo8QJ5bI/A", "abc" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$jXEtOySg6CHRImbAKo9ZS94G90MwIv/l3KJd2IQUYE1", "abc" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$HAy4uW28T5fT1BwdCh3Hi9S3QGAS9DVqOf0fOay9p2/", "abc" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$qqhmchrAEOkJB2ovbd/1lTjre9m4bHXpVc/.2cWPUA8", "abc" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$eHW53P3AOnosAY12RWow37kj/pZSTnjAQiJ8d/eEQrB", "U*U" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$7GLPoDH0it14nReTexn.dU83I70ZcCO5x4In1pcadu5", "U*U" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$GM424MuY.1sSOBEV8It0PvXfP8iUFL3y/rn.TqnUJv/", "U*U" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$h7jZQEJddV6UDPACDlwBZS.qLZQEXl2dA/T7W8EUci2", "U*U" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$nEzR6msJS9q1w.szC9sxbJQR06Y0nnKJa33APSFp0U7", "U*U*" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$BozgJ5Iz9pRrJsAs8ieFnhoq34dBKGJY0jD0tzw/SfB", "U*U*" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$F5/bgQXMe44nby2xG2ToqGbBF4YynN8Uz7Mc6bEEvo8", "U*U*" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$EB3IrD7WvuZhkB.Y6rNuCL03xtVAIDrs/xx/Knl0J0B", "U*U*" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$G92gG28oqBL96NWkds6Vm9TxKNr9ea/b9VqbfhWfTO7", "U*U*U" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$qTP.SfAIXuSmRutQizKlYTEFXXgEoULHRKIMTuF5Ov8", "U*U*U" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$xIk7sBb5/sVvsF1Hkae5Su.mMk8VUdvhZsxd2HcnUf9", "U*U*U" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$vwTzRJlP8KJJNqzM2/9roop6k3Fg1wbS5H1l/vhJll.", "U*U*U" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$AIPjRNZ06KQkx1//R/.QVpMz0EztB15JDka0eAaqWgD", "....." },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$eOM0ZZztCqkd2qDLTIRl1iIc/mel7i6hrTT4zVmhI//", "....." },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$axAeSprvMSJYMhochVAm7HeLaGfKxslF1CaSVhZzhr9", "....." },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$zPut5OL3XF/cwZwTwxXUIgLZse.4Z2F9ogYMBfvyeM.", "....." },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$IRqON6M.CZInCa/Y/Zpx/d8q39oKlIqQK642upv8ZHA", "dragon" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$TmXG5z0LQfe5kdF/qETXc55bYcXZSjfxYiGltg31Nd8", "dragon" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$vQPLamucdOIp12SaBOsZXbo5SIZqu4VGHeE1YV5N9s4", "dragon" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$MU/BOJSzTs4BeSQvVviHPuZJnENnzLaJRtwkr6hUsN/", "dragon" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$aBfmQa50n5hqmnNg0cUZcmsOYoLu559RPbGeoF.Jg10", "dRaGoN" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$CQQ6hp5p20aPby.LkRq9jDuo2dniE4nb/uJaKnYYlV3", "dRaGoN" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$8ZT7Is53G8Vw3afeCrPVhgyamUCnKgNmkAAk2LPhU49", "dRaGoN" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$pQv1H90A4X3uncsPRAmk82kxFCPBNJi0iqHVGIOWYO2", "dRaGoN" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$YDB1Tr765PRQpPVpNGtCjNY7kqMufAK77BFZ/ijS.M7", "DrAgOn" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$We0A.oZyALXJI9Ini5aHQnlc5J013amcrV0k9Ps7tZB", "DrAgOn" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$cUXY28GQtryPo4gJ5LciNFvJZyfTj8EIHC2mZKjGM9D", "DrAgOn" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$uz8WUtmJ8JC5S/KIiXQ2S70j/xNKBQuyrDt8bcUZHa4", "DrAgOn" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$jZCq1DdvUYOs9G7Q0foP9fO3N18QXnX2M5QcYs1mVF2", "PAROLX" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$y/7imVOFYgfPlLT.ZvtKDiwuARo015oUmgrLjFPKe23", "PAROLX" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$FphGDxa5WkvRGlUEqJAMOnlcyy2DzxFXZCGgD1nBsGB", "PAROLX" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$9glq30y.Natpjmbrej/5mOYJmck9zl7QzCC0vgiTgZ8", "PAROLX" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$mhqjZMevLIGgQdqxcuTA1QNqzB.gi7NYcLdBAdvGQM4", "U*U***U" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$4CiBN6FD3hQBo635kLlTInaextOLlrmXICq1ByL3CT6", "U*U***U" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$KVPhyat3KccJzoC1JRE7iHKXV3X0yB5BLL5mzB3oE2B", "U*U***U" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$OumU4KdQJFjYVryM.yXFwAng/OV6Y/EykfEOb0y2wv4", "U*U***U" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$HKJRdmlw7HlNwRLH9FzgY/pFu/BKdRBcCP3YerzM4oB", "abcdefg" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$BvtzWq5aneD3A8PLNqnga5rcIye5Tp4D7dniuWL9kA5", "abcdefg" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$e8NjLJqvzfFzekXBbZaZlnpJx6FmyuqZlsOQS/7mjt8", "abcdefg" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$3nflZbkjxcBkM7pHOhjyCeKkvIVYxZlQPt1XO4ujuz6", "abcdefg" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$qHKFqYwK50fIZziG55wN24cs286uyxoEJTuf.heOev6", "01234567" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$zgXL0PpmXAb.i9pEJsmc09rwZqDNacNHdZN0/NY2lK9", "01234567" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$20vrIp0.jgpaJ4JGQQYqJpguASZ6oYiDgha7K5O64V3", "01234567" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$/Jb9DFZEhda1tFv.OIkLxSTFf2NTqZjTW7OAtKYX5z3", "01234567" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$13AFum4i9NcNGfVWuIccf8tUm.lQUQusuWPltLHoaLB", "726 even" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$q/bfJHp1GXTYTs4/MIvV60/VKsRAa77tcpfz1NrjJn9", "726 even" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$xWxBm0VjhEr15xo65XU4VGwgELA2J.jtO79Hl65mQ5A", "726 even" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$ZMiqzxEH50JkXRf/fw2DeIsPnkkPC50cDSfSSsewrL.", "726 even" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$PmOlv3tOlc3JE2UP0CpTk1QUjiJAN3hvPSvcOmvaM64", "zyxwvuts" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$vONMZNYuNFJGw3u7N18S3U9Ms7lP6YtQHkuzPAerbw3", "zyxwvuts" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$MOtbLb2ErLv5CM1.zp1v9G7WVXc20WKkN2j.Ai4ARX8", "zyxwvuts" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$mRppiF5oVCPdn59FbkPfEky4aIyV0GYQ7XOmpmeUpoA", "zyxwvuts" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$Dd2S4vWFOJ1ALCT2oMbI1qnlJqSYXP6UgS.vRG6AIg8", "ab1234567" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$OO1cvKmiKSEkVBiu1fJOPYk5c2gCr10sjcgzj8xhqDC", "ab1234567" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$vkqZtzwTK3SRp4In4Pa3NhC5KjHC3RM1d/0vVbH4hH2", "ab1234567" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$pojoC/jFk55RpshsRlWi0kkJhBuWCzLpf3ulKU14TGA", "ab1234567" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$mJNMEE9LaxlIknmcisrS84fH09mME84ZeRgHOfx7AB6", "alexander" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$zLMutqlywtCWYlg/sSbB13kw8fo1Y9jmAK88lXteMu0", "alexander" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$1QLiTYefj978U.BzORPg086aZ3mooSRqb.9PHXF38R.", "alexander" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$g9a04uZyjWL4XvZUJNxRlc8jZyKvaL3KjVXfF5WIqU1", "alexander" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$3lzuyQm3mRtKEPqcpZTMpwZyYbY3c3Dejhan5GodvPA", "beautiful" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$0zhaZgjwyh4wo.s./KhTWUDGMERXfLKE0r6rCT0.rd3", "beautiful" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$kFhAWU1XtiaxuYoepaGTQJbuRy0Bj7zArprlZOP1LE.", "beautiful" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$YSlmTrkj5g46GMrj2kUVvlhtTkkSbROjlUN6o5o5AK.", "beautiful" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$KD9RUk3QMt41WfPigOQtLf6GZ8fuzMugHwvIVmqOKD6", "challenge" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$wjC/v8aboVqjwHEFJulHUyR9hkImgGF5NrqlFZ.gVq/", "challenge" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$pabePgNXmr3YrdrVJmZQtwbMeXQtJATVrCu4Ol/xUu5", "challenge" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$Usl.rWM8DLh0IEJXNOMBaYj.gVj7AREmu7zah2/PDFD", "challenge" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$Dw5.FC4qLmYIacDSnM5f4uQ/tpuYOIYfVAmngXwlI13", "chocolate" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$fkhDQcQUdLK6E0TZvVTIbViviDoImiza/k4EFxSc7L/", "chocolate" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$MhegevG2ur407Nfxp0WvIHeYC8BzmroT0it8m9qQq55", "chocolate" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$i14Db3..kJdxVZiBEaoBhS6VKrfrx3FGiSNtb.Hh4RD", "chocolate" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$KB.UbNINFVhURIZ7S6c/1OzT67VrFXO9I78oEhX/kq0", "cr1234567" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$ucQSvFHUGc5p8PpusL/BueRc7twsa9y0LyZNWKBxR71", "cr1234567" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$PzMgRZKQAlpwFaMij9qr7EO8LoLZjnosbf/5SH3ip0B", "cr1234567" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$XsDDeYZNV1J.bYkH8JaFMAis368kp1IDacG0wQP3nQ4", "cr1234567" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$OAFCY25qhD3G2FUgPaP0vpVlOJmwAcxpOyhTQ4cvZf.", "katherine" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$3whsjio4Hg7nnIJqJHcwFrCocU0Wg4p8Nw04lMJGTi7", "katherine" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$riJgGCL4gJ3EnsquTPL/Bx9zPOEE20B9RUmclPSgUVA", "katherine" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$iXGDrW1DV4ifO.nUmUlqtzMK23R97rq4eCvJ7E.Tpm.", "katherine" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$ZhLWjy0PFkIC.e7AuE4bFakUNYumRcu5ugj/KGQ3Y60", "stephanie" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$1XS/JDwJxhqrowy0zwk3EEbiBZMIbkAPgWJjs/vYeH2", "stephanie" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$DioI2qUrm8k15E4mboazqTOE.sPOGKAvEIgYV/CDk42", "stephanie" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$KrKcCZUYvh6GMkZjJ9YHoWDia3yR28CW/370088czQD", "stephanie" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$7C7KL2uWEDQCUtzFhANJDkQK6cC3vnyWMiodIU2JsV9", "sunflower" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$hsIMmC/tqayFMUN6Y7BtvgDf.AwCEfGKePsityZ9cTC", "sunflower" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$X.QvVrcBovlKor7imsKbmywWl3Mygqc9JU5huaKFoZ2", "sunflower" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$ESGOVyD20HhkM5ciRQ5ipORH4FqIt6MImqCCxjL4iZ9", "sunflower" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$I3EW44BECMn.MdHUieUGRBrKOS5vxFEF7doDhXu2XA4", "basketball" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$4ug51qZJiNQgFlj0FxDp2AXU6crqsH2u5USWC2nsDyB", "basketball" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$GOFi2fx/KDZ9FZby/aiDXWLlVm5icuPXKmsS2YbeT/8", "basketball" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$UlQY5zA31QInXucVDM.LLgCQhaHy/4VLe1qUtLmmaR9", "basketball" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$6aGvr82BM0EEKCa9GiTIlAJpczbt/xaWtA2v80kXts2", "porsche911" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$rvqgVRgbyRLAN2HL0OqSi5pvn8gxUYCJKmKuqpyIm40", "porsche911" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$1Eqf.wtEz1ZG9O8UrBGVg0uJ0tJkr7CQZZiahkFWlL5", "porsche911" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$oe7Gnl0NaBXwUWIBlTTZQOr7meiOXOxeVmUmW6XEx/0", "porsche911" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$86OMk6tZ3eDfJautFi4fJsrZZ2tm/VZDEpNZW8NS8WD", "|_337T`/p3" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$R.kkSOX4ljlpBMgo/hicWZ98jmS7fzd7CDzCA76T/b3", "|_337T`/p3" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$3xmjXRfo9XAIx4FwmRJOxMrdVdSe.5AWFx9ZoyopWL2", "|_337T`/p3" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$aR3IeXwWgTCTCm0Iq8yF6Bv7GXXsHoEK2zSWA2HzKV.", "|_337T`/p3" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$I99TnpFaDm5INcdFSDIElPlgLMBs5Y6D3MaS3JDaUs2", "thunderbird" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$bL2l.GhY8JjrkxozCOM8cqfXTK.afoZ9DbGSujtVBJA", "thunderbird" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$lSSKwgpP/06k.7cNQ16lJpRqpSkmRBM6HraLv989O09", "thunderbird" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$kqhNa1TbrgdAdPYMgYhNMxQWeiaVhGMgkcqpSjPGJa7", "thunderbird" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$yws9hx0PxszV5EA/Wj/B9RGulgq1wsB.EeAff9wuv0A", "Hello world!" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$s3CcnrhMQ1QUz621AevEZCTXCd57u5RHmmoGiBQvQ39", "Hello world!" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$RSX2DurfOMuYmtJ.GuheprbkovFO2MwstVgLF0JMBq2", "Hello world!" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$tNWPwi8ycih56sTZlTY8aDlZ1W.5CnlkNiwoCU8GUh/", "Hello world!" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$Gu.XUfhI8F1OmjjnsS/8R.xTl9c.dNxBKG27fItU6f3", "pleaseletmein" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$UgFCxJxBNa54dsmJWQ.zxD/esYpRE.0nOa43N/g8mL/", "pleaseletmein" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$pZCS9SDuSgM9UaPMmvQnA9pMjrsYMkxpu4Z/iEGhHC7", "pleaseletmein" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$eg1OUQ7Qlv1dI5u14n1d.jleeeA9Swr.XdGGj.YZLp4", "pleaseletmein" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$KYam1TJTr5uOM24iKU5sOzL/DD7o/piMz85CR1p3PI0", "a short string" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$7/3m1ziUFO5uPFj0X/a33YE7oBQpilKVq8yi2M8vgz.", "a short string" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$vjsgudSKKQboBAZykH5Fjr95a5aKW8jkNTbB2hWA2pC", "a short string" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$9WA4Ltb38MFY/01Bcc1kEfB3uZY/UnMob9067971np8", "a short string" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$/r6s4npJwl/qj1n33VekNzG6J.Od0JiSi.NiU4OsCp0", "zxyDPWgydbQjgq" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$kxWRv8sQN2djJCtZ6UzPXmBKkpd4wnyWAR9bk8UnaH8", "zxyDPWgydbQjgq" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$Ky/M2li/VKiTbggPaWDfR3h1i2t8I/YfWeeiydwvUR2", "zxyDPWgydbQjgq" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$qgs5y/mf.AgBL2VxKHVSw56.SJlOM6KWsVfA4TgrJt3", "zxyDPWgydbQjgq" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$uhLWHz5tD.ds7S/.ZnzcnyWpIBWni/TUGDySldPKc07", "photojournalism" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$dUQyEbezujy0uRffnMI38JjTiJYLk6gDhyBuHFewXu3", "photojournalism" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$GxotTvvfVNhXxhmRI9GxbPFtO9buyN1AA7uctLib7m.", "photojournalism" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$0B1Jtwfr9Fqs46qAxv3xkeRZs2ohIjRKGghD494tcy6", "photojournalism" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$A9H4UqOCZJTGJDfX18h4iyBLujzQtFnicm9sPp/nT50", "ecclesiastically" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$.Qj/GOg4WWuz6cU2awV/s/q7ELkgK1L4TI.hdVXvrN.", "ecclesiastically" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$Fm6eiIV00qR4yDpGxI.uv.xvEtHD93X31P4OwSk1RNA", "ecclesiastically" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$VDYsX9FgMddZ53w1Blup3JeT8ZfSNQpa.S3IK7aBTu7", "ecclesiastically" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$g2.FfaB2jZVVQyDsV2Ogxqv8PrVbH1uzS8vm1UtT8p8", "congregationalism" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$qz9dvvi/YgHhHoFQJk7pHoH0Hp5scS1xLM5HEXG3JF1", "congregationalism" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$XzSSUDYEDtpN4Q4tlSz70A1HHlTiZAipOKOKcuHrsS/", "congregationalism" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$tF8qu42hlpHzxQ04245mbvEVYKnuCxE/52T/j4CsZLC", "congregationalism" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$zvknIv/4C0Un.fSHgWL7llQ2w52A3i/inAPVDPubmr1", "dihydrosphingosine" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$uBYMbuA5Blob66kdTGj.Ha8gtLYdpRLBkCvn6tRc7F4", "dihydrosphingosine" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$WFKbPB2LaF4Xk.4AKGBhzbeG04jb4.YmbDJ8/GyYME4", "dihydrosphingosine" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$8ctwb1BYGQ16BVs65s4D5pJsV6Iqybxs/G0CMc65YN.", "dihydrosphingosine" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$KqNJJ9MetQhb8hIUafmBA62P6BB8.9qdlki5q/Oxl11", "semianthropological" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$sZIzlkCuQMOV.FOEMKHIGTnBCK/pWTzDPdRlUGWof33", "semianthropological" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$uAE6EpMP/2qs/f6K1IYgexDdQH9YEFJLJuAlrv8nQ/7", "semianthropological" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$yghI7LZeAdKMPJ1Kcwt.poH7.HKccf4RaNPSPDhiYf9", "semianthropological" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$brEwm96SNW0TVYPogmSBwvTWo15eHFyWLjprwj.rk23", "palaeogeographically" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$IdAjGtFnKdnnbb7D4brCU5npfVV5JsOuOUlRUNC5uX4", "palaeogeographically" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$zp3i38vp3QiN4NcpBMxypdNNP6UmUZqHfQNdmW5GVW1", "palaeogeographically" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$.rRDG811VnfgDOphwx0v58/Un/0b/yqlQeEqnSx9wxD", "palaeogeographically" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$hNBu4ivuLdtFvgcvw/Js82YlIyvdl71HQLAWQOo/iD/", "electromyographically" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$UffarlyZ.Q7ZMCLUWoar4LXGrY3vC/gsmztiGPnXFm8", "electromyographically" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$74MjXshvfP5lLY4ATRDe6bAMMla/5phwsQ5NrC5SzdA", "electromyographically" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$lkKqkxegFPCRrmLiQHkn5/LVwnspaCJ8Gy5E2mZwui1", "electromyographically" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$KNQ/5ja6h7mscZbwqpH.iEpXyPBEkRJ9RM57AGd8LwC", "noninterchangeableness" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$yAeMOp9QX4wt1lt/RWf8Lzk1iDiDWJgC3fJaQ2PvqF.", "noninterchangeableness" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$OZE37yOsji/vihsTRie//KghfLDg36hvG9fs80mvpg2", "noninterchangeableness" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$t0S7LBBTkpU3qva2gUFOmwQf62ZuSfIZN8pxhySNHF.", "noninterchangeableness" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$CUYPLJy6LoXtljQDkO04hlE.gilwwqjxlt6t2qVSjv2", "abcdefghijklmnopqrstuvwxyz" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$6H/tA7duVyrkPwk7iKE2CQTHBbcEc/G9yQ.rmvCCzq1", "abcdefghijklmnopqrstuvwxyz" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$6kkrcXSUEwzunuRxeslvWes5DYsvW/RIy6fDjDufYp7", "abcdefghijklmnopqrstuvwxyz" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$r3GUOCcDpB6FpFKfBluyu0XCLp4hucbNjfF1WNSj0d5", "abcdefghijklmnopqrstuvwxyz" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$XEv77kvbvqdbQCJng4I3D/m6NjDYuWKF6/MG1L258r0", "electroencephalographically" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$BgZVKL5keloiD1zPtW8K4FhjubX.lyXktMtxLGp.PYB", "electroencephalographically" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$xDUhBS4DqBgtfiO/5byHY5nLqIdLY1gOu55V4Ru5PKB", "electroencephalographically" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$ghuPfXLrXuGVh4n1EYom8NjB46M30q.8IdeFLgA25TD", "electroencephalographically" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$hbIVIW3Hs8JQ/dbBEsDeplEKM9Nqen.9m6cRg3lnRyA", "antidisestablishmentarianism" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$bPoDjdIiZfB/.0ZhW9HDDVmR4s.dgJISacsjuHqonN2", "antidisestablishmentarianism" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$G9toGVRwz/26QeL7LYMsJUvFRo.ymQTOFKwb0OJBPE5", "antidisestablishmentarianism" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$xSoXugIYrd1Kw7.0coaqwOjsGO7vI0l1XR6nii8kOw9", "antidisestablishmentarianism" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$MLWhEztYNELFd/PYpkDdGRQIMaxrFHYUWgDx4GHE7h3", "cyclotrimethylenetrinitramine" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$8GZvqrkMMz7iLpT425YKke/3uISWjpr6piwTGgL4kc5", "cyclotrimethylenetrinitramine" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$QxEx6K3TBTIdnKw.7L4g4x203i1eQoWVC8B/MLXCE//", "cyclotrimethylenetrinitramine" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$NQM6UR9Cn3y5RpRYi9.BOEKiEOask8wUGwBuxfpjjD7", "cyclotrimethylenetrinitramine" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$lBdfxI4O2hA14dB3MephYa8B5ot8oXG/oOuEpnNgAC1", "dichlorodiphenyltrichloroethane" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$ZYvGdIp/iEXn64SffBI1MTBUGyjYHhm.AKNUwZ8ORYC", "dichlorodiphenyltrichloroethane" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$5PGTGTfoMgeVRLExFZcYnQ60p6JiAboEaxU9cEMA415", "dichlorodiphenyltrichloroethane" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$.4wQnG7tTPcxgRUfU.dm1NT2wNgdqqyFFeJIpFwTFu4", "dichlorodiphenyltrichloroethane" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$kdVQatRfJqgtmphXXTYg00J2nxPINlGefGYQevNBW09", "multiple words seperated by spaces" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$OZf.b6XF8a8Plo0jueF/vU44kPS/vsRXkZZAi14/Ng5", "multiple words seperated by spaces" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$Vi4X0cIfMTFTjdx/IR0wvNOIUn9FkbJeFT.2e8v54y4", "multiple words seperated by spaces" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$qDaN3uWN2U6nlwrm0aITbXRjdIy0tmq7U26M0oG0/H8", "multiple words seperated by spaces" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$gSBL3DnRcy/JLvbq3ci6juELi94IF9ZsdV4.3zMhvE3", "supercalifragilisticexpialidocious" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$w/MkHQjGUXr5ZCefUrLsIp4ytR5DvzPM3dNsurBMFZD", "supercalifragilisticexpialidocious" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$ZSsEFxX0KbK1vjSTJyHoEF2Y2wxeXcDYk6.cZFz0SM.", "supercalifragilisticexpialidocious" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$lpENVoBj7AEyEyf8riXs5c15grUonMZalUUrTeLPxo1", "supercalifragilisticexpialidocious" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$h/ZJga/dNpY076nq06yA5xD/VJ/F21sh74BQ0d6pRv/", "we have a short salt string but not a short password" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$Csps3zKBhCt7Vku6Are1m8Owwds/u9CSNV6Qc2uJiPB", "we have a short salt string but not a short password" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$gOx9RDgmVRdzSJlE0Ci2ytt55Wht4F1/UpJq0I2w9c/", "we have a short salt string but not a short password" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$ca.ZfqSluM5LSJMeKyuXbUsztyKFYiV3Ms.6MQLoJw5", "we have a short salt string but not a short password" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$m4rB5kSSkH9ej4Nlcp9UAuhLrKvPhQnWBWFie4l2va0", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$if43uVHmfNErvPbUbj.P0RzaqmoIYgccd3yrWSKFpuB", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$IEuGp5dUsMJJJREfPggbUks/3e1GOn8wcyltsTgBXv/", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$f658PeyhhWW6Y6GKEFv8cvukWFqE/7FWsWlZ2HHfmSA", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$HRqVH4PaV0wiWpemjmhhw5OxDVvx13LpC6n/vBicXlB", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$gKaNLHX36iVpdi5ewcUTR4/HjKk1PxtF9AhHbZnOLG.", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$gDUXkFO3sSuNijh5n8q8bcWhUqHasp8uFHlCb18Npw3", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$yY5yuCtt2klGs4W3StK/krL2J3LJ6LWWyfMylGE5aP6", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$A6WHcwWZpjgSfa1ngCBZYahf9eyI3t75WvaSnxnzH25", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$T5bqciTYrsZFVFVbxkTHN30pfTbljRJ/m966N5OAfR7", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$0cSTRsNmhbr81DtJHAM7FJ.vyJvY6bBGUTEuKSYl17.", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$slOkk.KJlnAMqheMHqN907MayfR3vXBbs5BGQEGQNd5", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$.pbieXeSVNL39ATY0oPdKYCV5QvMNi0DeVIl4q/.rK.", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$ATPpafm6yia2P3.IbncE55JuQwUMoFAW70g1Vxi3pH9", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$0eaxJnTVq07T9FMJvShP7BZhuTREgXYUgkfNOVkxyeA", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$nqET9bwT1mcbXvT0uUgH7aJR422Kwx7.pURU7kE86O5", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$GZ36xGAcwHXjjRhiDCGP91Jche.ChE/dmLjBww6lR8C", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$4kq6g7KTg.qlKwTXzD6M7gCbopcY4.cJmdknT3YaV03", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$0QttwQ3y8GIFlaBd1OKJav03xdDdhDNeSwf5NtIcfq3", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$Ca5hjdbTg76aKYimyLabk0SPl//G9iGC0TiKIgxt/q6", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$4Zog16enLMlDstdejo/AvHk9DYuHsVptymAnM3bjR.8", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$aRuiHsZDl2ktFlwvnjx7T0VBTPE6aunlmpIIs6Zj0k5", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$tyd4kG/q20CGuAXU91HsshL8p4W5NI8OmFu1z6kqqL.", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$vpWZbPKg.gOudWmAn1i/m.jz7hkswc3fLHVHsSEDqy7", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$edUTmV9p3X7NfQrEZkuVV9Q7H2EpMG6JwaipQCx..37", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$Up4CGTaC4DcLJeWumLq2oYpsQBdGZ6zhefQtD5vf4B7", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$KB8pc1gdDCtiNPZd2cZUmjshm9GQ.Yk4uspB.3xrRd8", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$H4LrNZ/3mpKiAeKZqNCS.60b.L407Y7K/tpI1kHXBp8", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$taXiXmR1LaEBv82YaQ3SBl8F3Gcuf4jTmvdfmid46W.", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$WVK43ggptNSR88TRDzbRdB3vXkI2lraL8CyS3viXYk7", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$HOFNCX8mY41ken5Cjvq/Hg2eCh2jvmd9QsadZnsMgfA", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$tEeoOSU9CXY8jSFhNWnI.65c/vAM77WP84DQFMXiOh3", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$GnxAApWhTAk0w95IKHC4g76uSDwEhfaGqRwHz8nYGT3", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$53YP/5lSxwCFXZriLWhEumpMr97.rSzYdt.T1nT8o60", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$zWuROXQzGUp9R8E5h0AnsUkelve2vtXjpTDTX6aNlo5", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$enSeUXaINLX6wa3HA08fvDw/uHSedJfgiu2FTJbc1o7", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$7YxRixGFJcQ0iUdI4sdLYUB.QO3YbeTCxW3SwzzMGo7", "\xc3\xa9tude" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$ECwRAGSxvgb1/KmboMJL1f2Cyt997OERnWC.9UVHRb3", "\xc3\xa9tude" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$pK2u/JUkP4FBcu9ygDg2kDKqF/8W0pPOGtjVweTEDU7", "\xc3\xa9tude" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$7e6UUY2ruu431N4qu5VqvbGloAERSKWscHSohwpq8x4", "\xc3\xa9tude" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$iebMQMvY4dNBwougHGbuTK0LwLfvai2JmAi02Zt7.40", "C)tude" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$yDEn2iJBjfAkq88sLvWu5le9cgbPHBLX5eKGZRikDs2", "C)tude" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$g/1vF6ADAMayLCBCvLcj9IR7UupsnjWSnjSyN3GCPS5", "C)tude" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$awa/bIY0pRLscq/4q7XsgAFCUNnWhE0BkCP7d/VnYp7", "C)tude" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$Tw39uW5qnx.068sZ7imQrpaO04CpSSWFw1SyfYWOjM0", "Chl\xc3\xb6""e" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$xVKR0vEo2aBZXz6izQFdMWrxrRxdEAF4Jh7VR48QmdD", "Chl\xc3\xb6""e" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$TvGwUq6yImvl7jyBbtt4mkbK8OkjH91.buV.j.Zdjo4", "Chl\xc3\xb6""e" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$eIvWRZ70aeggFV/9IrenXXFwAI1wiM6fEFfzkZuUby2", "Chl\xc3\xb6""e" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$FNMfr2g9s.l95sk6k6O2Z/hYJ8Q3KBYPungYU/.gGc3", "ChlC6e" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$ZunXMqAj4Pl64KKAji63Q4kgVVoNH2eOwD5FiJbsTN2", "ChlC6e" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$o9JpUNH9h7HnyU.koOM2d0RYAY7QpMF59KEaVS7mzi.", "ChlC6e" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$WV15m4A6WrD9Pf0cHpaEeJTUEWXKfE6JjuHejLNvH/6", "ChlC6e" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$9c4boo0yE48RQsdNfhqabszXZga0chCIJHfXpMnN9b4", "\xc3\x85ngstr\xc3\xb6m" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$aXXYXsPC7ZXcKTEJmwagJZq0./I3SAkmwDNgfVK2r91", "\xc3\x85ngstr\xc3\xb6m" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$QimJe0885yasrX58w1mJfYGZaGx7cpAMbVFejXwXsZA", "\xc3\x85ngstr\xc3\xb6m" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$uLw78UCq8kgGJ/f/hyTjbR3LY4PT/coimrnuhSKeHM8", "\xc3\x85ngstr\xc3\xb6m" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$cQCoPfhwC5XZq0jWBSoxwAaNHVKOzMrw3BEzbYORTr1", "C\x05ngstrC6m" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$6icbwVQfTjEmyBzDjIhcj.eVgxnAQYcXRux51qy4je6", "C\x05ngstrC6m" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$b1AooKtTJ8LMItkXgS2KtoGHHnMBTRQXAdULmIDfSm5", "C\x05ngstrC6m" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$xck.JIR9K8h2wtFPXat68.uruOIvMiBGw02hgXRPcQ.", "C\x05ngstrC6m" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$IiAMtRbn31nS7eTo0D86GtHnjO6Vj5rWBgSviKaPuIB", "C\x05ngstrCU*U***U*" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$rF.n95KwHM1oFUOynHOJuC8gleTXsjLs4a5BBn5fyE.", "C\x05ngstrCU*U***U*" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$eDeOgA6iIrdrhSlATANsgmIBCCP.zNSg.VMuI6ooZ6D", "C\x05ngstrCU*U***U*" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$C/nyPkTqs7FjMXGXFbyjRpurGJWLrCr/9o5GTxY1uM.", "C\x05ngstrCU*U***U*" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$FD2gMMrxEcUavxXywaHg18dL.1zg2tRVyiRgdqx17p.", "U*U***U*ignored" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$6mnihpCBh3mK3a8PaQe/MXvlG/uHnXmtDkd2o9CdWW5", "U*U***U*ignored" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$4k8OO2yMIOqmEp2cM5j8/bicLTRiJTmhQZY6/uV1cbD", "U*U***U*ignored" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$e8VUg.Rrc4Uto8oNK7ebWblYkVKOj38N2MbMzDLyPyA", "U*U***U*ignored" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$F86V4KQXciynySIYU62E.Pgkn4/R/6BmR.nN/yuW6Y6", "U*U*U*U*" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$0gicmm5BtY7dBezbkBcsT6drHRJS4SwpldzmaagAOi1", "U*U*U*U*" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$131cregLhY72L1SCJMRcJV/wFnaXYpCfAoM.I6lRKO3", "U*U*U*U*" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$ZrPFoAiMIkBVnpdgM1KWGyZkIBihtPids5J616.4bv4", "U*U*U*U*" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$.eU1o0il.hO77hAiVFeFjcwYzkrw8W/xG4R/t6xyuj/", "U*U*U*U*ignored" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$Tp9gUITtxCqjcxrOyFwWR6OJHET3NYDdfheJVuPAg7C", "U*U*U*U*ignored" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$O19rd3DVUcTsYjqiSIr806M2gnDdtO.XrH7.bJSLc71", "U*U*U*U*ignored" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$sM/qkyd1LcgGCO1zscauewUyDxx2WabrxQU.2lHnoB5", "U*U*U*U*ignored" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$8oBdAWdWBxHSBzIxOXJhGBxrgBr1x5QDTT62pv/PBT7", "*U*U*U*U" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$JmL7VfGcKNwntIRPBxInEq9cqZG4dTgN1QHoJYRFhU9", "*U*U*U*U" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$/nF4yqbXJb9LLaj6nsAO8IuLbJLAw7bHVqBupaYOUr/", "*U*U*U*U" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$mw74WE2pyCoLDzLTHjIkaXzWCfpAXKw62PKX6BuX0y6", "*U*U*U*U" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$ujH6VGmEIBtxPi5NQD9oCa3CwTBA1/H95FKlGltdQR9", "*U*U*U*U*" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$v5hV2JabckGN6x.Ti1TorG.O4OJZ.DvLJ2HQ2TeVP45", "*U*U*U*U*" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$qj8FEKJTbuFZXDtTZBV6ueI3ShgFhUBOhjm.MuVeNm6", "*U*U*U*U*" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$bB9hQmub5roDfDkDG/.AUyH0GUx1Hbt4zqOA1YXUaQ2", "*U*U*U*U*" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$EvTdArdcQuXxCFUyu8urMaY9wCSo2zVhgUk651bBk08", "*U*U*U*U*U*U*U*U" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$UOYLpVu28lBtuMRZ8oy6qICNufeQiiv86bIRuvukEh3", "*U*U*U*U*U*U*U*U" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$xRLMFI5mh135V9NMFgrcUyL6Dhrv3hdGlUz5RRzu1Q/", "*U*U*U*U*U*U*U*U" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$O/fYa975Oab7hUPjZq9mbNOSQzxjAIfqPouRuvIgVm7", "*U*U*U*U*U*U*U*U" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$RePK.di7NuD.VUy8SaEw2HT0GlwlMqkjVsM8UzEk8J3", "*U*U*U*U*U*U*U*U*" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$ibcYiggYF7w6/3F3EUcX6COy/RDRy3W3FQMwFDoxKT6", "*U*U*U*U*U*U*U*U*" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$mS34ZYmcC/KqbQCQK5JLeaqlem5YtOmnAxY5RxkGEp3", "*U*U*U*U*U*U*U*U*" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$TQodCEzmT1iYm8dXR4Q8Tb6ems0mlE9cQjYa3DiY2c8", "*U*U*U*U*U*U*U*U*" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$zMvDpwv1riqro9MagZ.9lDdG9PDk0aa5BSpMGKhUaLD", "\xa3" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$3RqmFvJAvOzugD8jQoWtCamCLD2XcrAW5yYy.w9aEf6", "\xa3" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$PF36n1GOVDJHPn1HMjgVul2aj.lkW51Nxb5x0CknkvA", "\xa3" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$uxnYccfaaCSbULfJRwa/OvR64bNeL9P686g9gqlY5h2", "\xa3" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$mT4x6wjY6o1GQS7D/uYnZGZWm0EYDGgzvbb9iUsKug8", "\xa3""a" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$0mX0TmnXNllLRDUyvuF2BUdndBqHi1IMI2DfttEuY8.", "\xa3""a" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$r8cMdCDon/cX84m7F7Ac.JaJHDMGi/NMPtu2nLnu/v9", "\xa3""a" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$9AhRhs3DOnxMHqgcwLqM.giO9bcjFdDjrwZIWjbbzKD", "\xa3""a" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$RjYtMKrm0Dfbxz.NPamXblt0QWzH1bdCZrSAvoFUZT0", "\xd1\x91" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$U60iLmAbdWjZtqC3/DGTuBrwUMyJgOWchmteULVE9X9", "\xd1\x91" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$JC2FgAb473Y3tpVl/96F2dzULdExv/it/LF9gK9oL65", "\xd1\x91" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$G6Rxr9HAMCdXQIlL1g8Ecx0HV.KGnyuPlBgQaDOuB/.", "\xd1\x91" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$E6W.reBwHzUAT7eM67zUaOINeMVOhysElp.7gQvmbH9", "\xa3""ab" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$hTyEPYPLPGJZUmENXQk7vDiwXHitk3NQR7UJmHaDGLC", "\xa3""ab" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$yIWpWKiKgyC30URAYuYJD0T4OZzfueGWyKtOGdYE3GA", "\xa3""ab" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$jIak4C9WVCs9YDP2eGI7O7ee2rd9xpIqmWgznukuyu1", "\xa3""ab" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$qxEBlzPJlM6OAtfchj2arh2bdwqM5Z45cw5ML.jAjd5", "\xff\xff\xa3" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$biGQRBKqafxdN.asEvmuR2Kdl1U9.fzBJ70FeiQHgF1", "\xff\xff\xa3" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$g76tp0jkf.fgTlCOKZByz6ClnclUtfENJFgg7MC1Oy1", "\xff\xff\xa3" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$eqL/XiUhQVmhMS3dCWtr.xCdYwCDIINIZYEMc3D41q3", "\xff\xff\xa3" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$osocfLgQvWEug3PJIEU6JnkX1v73RtGlEI4rgM4HDS7", "1\xa3""345" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$f5WUC8WzClufnbcUsy.fw7cc1o0aCb6CCwJG20d67v6", "1\xa3""345" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$hKTA4vbfBrjCKbEjhgYs/w.iYA/6k1Coyuxq1vME8C/", "1\xa3""345" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$M4MJvkf4l3/9yYMv.kt23msFi/LE7uC5B/5N0NLj897", "1\xa3""345" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$80g/tKzSNL1oAWoOno2iMnBH7dUXBm/sI.pfkjiioq5", "\xff\xa3""345" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$3AJnhopg1F5YGQmzoAgWnclqadWVYwE0PNpDluWMRH4", "\xff\xa3""345" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$60heEl4VMS6POJ1h2tpme9MNVe2wBf4eOSG8nc.kWrB", "\xff\xa3""345" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$PEMVTGfatVb8JvjV.U3GMLnFy9CPr.rYTg2qm0oVtC/", "\xff\xa3""345" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$8qKJs2sxI2X.IjaD92XbkmXWbnXKWKbpu8doXlQx9L7", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$LNSuRInMWKAAr4dCdIWcpVJaFneJuv9hDWLQk2mTnO3", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$fjpW.HlyqrGYcfpUpFMOWRAbeKvx/0vvKEjF9x2xvy4", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$nsuyo35dVIW2jGX.M6sEPiadNegFLwICITC.AjNxGw0", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$PpYniTQpnDu2xjPqepGv5Z5LNSobSslIu06t0ZheM/C", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$Xhwh23B1bvYySrY3CYgjHfLuw/HnFuzz5Cs7Jl5UX/9", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$Aqp6YYwpRSNkKVFOMy/dpSGXIEdu5cv3k6jlZ3XsK4A", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$Ei1/xPtI96wvI8QIYoetMfg9LFvr.FHhCW8qaNt2nV5", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$4fgfBWi0WdIDTL6vId2y0lR1lKxWBdy2mcW5v30E9d9", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$Mm1a9LtT/t76JvHmQzo6ZQ2kterNAfZOgbPcw0RONa4", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$.pdaiyKPOOC7vX1dErqdtuBa7mB38hTRtK9Y9NURrQ/", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$at/UBhHq3lOkIWwKq0N15zcSXJeX1fGkbsrnJOwXI/3", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$liSf7mTa8u.no7HgXcNQwIE3K8Twqr7nSt5N/HrEXBA", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$e1MvxAxlc5CmmyZIv4wFjK1QFcSlZtYRu8js3vt94J.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$BfP7vcwPuLK54Srdja21kWTs9YjKGAHEXpCr64pjeD9", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$iKHIQ5QmbKatT4KlSvoUOLrrxtluLDrygpezD80ULV6", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$LJM0EguPUkwuiest9cmjcXFGt2y7OGLrqLKKxEsZh./", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$/185VGjSOo5ctS1gXz9vIFEyvZBbFQK5eIadLqA/0E8", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$FI1q4hzGjbE.Y63Y0R8dGXpzUPysD2a3Wl2eQevi0I0", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$sSi/MnMMQ5bJT7uK31bZQUbo9Ndx74f5szGll45S2E.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$5PFYYEDmxkMMY7y3kC3WoJPgp3RMn1kk75QEGg4zHqA", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$Tr0LtKtY7GdlNqkFyEPE1rAO/DuDnx8zap5LAdFoj8C", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$HPGIvKO9qSfB6hjHQZior8vp9DZyTraLFU..WpZ1i4D", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$ScEUeW0bf4lIUkvnDsN.GBoG4YltcedJ0LpgG/0FXT/", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$E58r8pgTX.C9h5GE4pFjxLfryIqvfkIoPzl6.Qd.PoC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$8tbjwsnKXj54RkRmY/6OmwkZ6VWrZsggSPZ78BBVbl2", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$u9qLMsrODvlTH5RKmvy6QjXj8naJuZFrfqZYgUYR8tC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$aprvZJwQjJ/851juw5.bmh7SD7XXgZbhFZo6Gc0NTcC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$XWvM63NkSpzT20/b2/EZnuewkQsMK27yYxPuFHqmXF7", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$qz35/rXwtde9v9.76nCueVwZxyyaEMEKVswakoKRNdC", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$oC9JvM1.2hG7iuvTSssKDcI41wbEJRSylSXYH5G8KQ1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$UxlMyj4KzIf6NphvvTX.8L7hnTiHIuiWGbHsw185rN/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$kBd3tMYCmP.08m8B54zvtjY8oJCsycaa0NJkW8pGzY9", "THE YEAR" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$etfOU0Hskdu32Pq.V5yi0JDeW4Km7kKQNvjgTNdL4G4", "THE YEAR" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$IA7kRgXhK58Xq1X8U.FBjnRSkt.2ZrbxiKjVViamhN3", "THE YEAR" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$gFVdU3.j3cBR40YFm1oih5HfoJPk0Yic4aO5j94p384", "THE YEAR" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$qamur.ZkdwGjSTdMcOvVP8to/mYsUbyWhXysqR2wZT1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$8A1w6txth2aqCCrdtUmTeiHonLF5t.Mf/kxSCtiWMi9", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$/VAM3Y91pyeZ23jD.PtAwPmCt60jWQevXqaUoHta.r/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$IpbZMRgpk4lDjCvkWRnYWZAp6w.L4TjRknBIK809ke5", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$7$66..../....SodiumChloride", "$7$66..../....SodiumChloride$5.dMdkgPkYWBeo.bwGGy5uvM07HG.sPN5FqKIN5E5O6", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$7$66..../....unUNunUNunUNun", "$7$66..../....unUNunUNunUNun$JCaaEytAqFSFA4kEO/n25qwV07qz6lIrS10g/e.RLpD", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$7$76..../....SodiumChloride", "$7$76..../....SodiumChloride$6QRmYmWRMTS.24zHZcNvULbsQVtIrbU/0ks/gXD4is.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$7$76..../....unUNunUNunUNun", "$7$76..../....unUNunUNunUNun$KdYezd0y5ca2uj07L06lxge3dcYwkXP6jW0bpglZ/U0", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // scrypt

#if INCLUDE_sha1crypt && defined TEST_sha1crypt
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$24ApQz0YcjniaKRybMfRK5DJIz6n", "" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$tsxg1OcOIRcYxCEtp36rr6ULn4vQ", "" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$LzqiYdGaEExjTzfTk7H73qMJvK.o", "" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$hMqn.E6yFWqU4pFAN8bfhI/IDHY5", "" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$t.6rYZWKJE2c3hmqOqEQFIW1QzVS", " " },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$pDIvodIjXB2aL6e5OTqNZ1r9hDJ1", " " },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$pwWLA6h5Rp26X5d1KtniDlvvSB/u", " " },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$tzRaH1vW4yFkis7C4RX1u64aN8LG", " " },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$15ay/sqt8x.kymG1fxcilMe9uzbg", "a" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$ffbX5Tib3HIamb7DFtCXLv1/CWeI", "a" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$QaIV98sGCzM4BrksS1Lfsq473yOw", "a" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$02YDwH9L3BdhhLT7rLnikG6dyszQ", "a" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$coqIIvpcdPaKfu9NVK5oHZ8qH/ZL", "ab" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$EdA2XMipVWA.VW.LGjxi8NVCEUSb", "ab" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$4jye9tqDQ51RUiFxAxlHDY14fm1M", "ab" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$.eePvxQ9ZzUK5nok0gz1xdBOixQa", "ab" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$I2kBSbaKuC5BRdOKHDkuhGyZrkxV", "abc" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$wpPICrXXbgCprRZZqVyXlnxBFhwV", "abc" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$1mhAryDechbI5mQqzYx6fvVAmwtb", "abc" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$tVZ0qNp9iIF2diHSAUeusnx58AZl", "abc" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$20wfOdRz0K3r0xM7AqRJussRjGDk", "U*U" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$51ZPvwXNjQYXfYrrWyeinPaPipaL", "U*U" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$NFzZf1UYKoeVuELW3myamKkQLyvc", "U*U" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$UsODgIeehgmH7cTX2VyTwXPnxkcq", "U*U" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$F4ExSFycFzqnpRJhqrCsxqbrprhi", "U*U*" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$2Q7KEqqpPG.MYLtLYBfuYR8uMlEx", "U*U*" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$P3P4V4Z4dINocgBN823Tfu08NAo9", "U*U*" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$V1UhjMiZjPBXnyhjndlPB/bCqyUA", "U*U*" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$ZEhqfNRqqR33vdjdVscpBkyZOP.v", "U*U*U" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$qXmxLa7XHZYkTW.axnkg0ZhGr9x.", "U*U*U" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$pvLi1u1DPEtMoZygL0a5YyMrt8mZ", "U*U*U" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$.U0OGzNsh/UE79suFDuDGCxicRjV", "U*U*U" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$Q/Av96L5yOChpaU6nGevJ0SQgTU7", "....." },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$V8srR4/uIK6eyidOtxOQs/WJTn3o", "....." },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$coB1LPzD8yyBRF2Yi1KjtyWlA2my", "....." },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$jfd7rLEMYJCDAC3l1HHa/UEUa6JO", "....." },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$lE5gwUx7lqvoLTE95ye4XFOxkiGQ", "dragon" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$GXkoVxTeHFfTATwniCm7z4KxHTu.", "dragon" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$0hIfm8r3KhfUvVt/4AG9OcnKhGwJ", "dragon" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$3kZ/qZ3kQPyRMir72rL.QGjZ42PK", "dragon" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$orRJ0KAkqwFrecUBbcN8i6PfJZF6", "dRaGoN" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$OG6yxfAI0P.b726ZpYhTGSApsvAw", "dRaGoN" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$MPzBJfoigY8Ey9ehBlUQQzYdrMhT", "dRaGoN" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$d7E4PuoGZ3ePAS.J9eULvaowNAo3", "dRaGoN" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$DNZfgYD3oaQExTMJjHsHofS6iOR/", "DrAgOn" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$Tzq4FXgzX2eUrOEy7XCHKszrPEON", "DrAgOn" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$Pf3dQfv5VjzxLNA7jBhbwkmRY8e0", "DrAgOn" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$4mKiedWXLPWMFMDoJvckdEYMtO5c", "DrAgOn" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$r0aGVbba/xYqyrbqA3wgyZxP8tJ8", "PAROLX" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$SRq1Cdzi8fO5XwMVRQzziI6KD2Ig", "PAROLX" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$Gfl6qj9WB6pRmNJfpblIp7G2XQyO", "PAROLX" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$fPmhu.0LXBK3ORrPCY2p2UtsrG4o", "PAROLX" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$VQj1n8LC/BS5EMdvj2aI3vTgCE6U", "U*U***U" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$fNI2qxRjcTxlbYO0ih4VOQnZFkQo", "U*U***U" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$nUB9jDUMXrAN4Y8pKrxUTRCbgUCY", "U*U***U" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$4X9FWFi3F.qq.C0MnsVADBTm2RE7", "U*U***U" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$2iFSnCvKPCM4SybxdZhExWkOtNPH", "abcdefg" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$5aGivE87bTt/BPyyzJIqrjoktC7T", "abcdefg" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$owUknBv4X0E6arjEmMmd0X0/0LjX", "abcdefg" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$M4F2I58zN8OAd1yYs1JShB7fFgUl", "abcdefg" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$M6hIV6GFtpCL.paD1vY.uOqJGhFx", "01234567" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$Z5GTMuJ8/Y.4b4cOdiTOwnkNxdst", "01234567" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$mNvcvlHj8O4DSYc0NJfvMnxaX0yf", "01234567" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$0H2y1zjvHhq37bRqD.d6WtKKsjXq", "01234567" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$gmebmy9.lK7EqTNQN.yvtgRhSqzk", "726 even" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$QUzJhvdFR.heRuTvVw7EtAL4LBiS", "726 even" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$ex/Gy/D8ayFSi9hMqEuHLYQ86xGr", "726 even" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$9qGm6Rhl0ZsBXC3TVQaQQHJV71C8", "726 even" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$HmPjxO0O4Vj2cxxMgK9T2ut2xSUY", "zyxwvuts" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$Zs.U4S3bCpJ4kTgS4u40oFYo.SiX", "zyxwvuts" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$JHY.q2lZMVF/j9z0MpUGYmT90cgI", "zyxwvuts" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$CR705j9gESaj4PNTSKrqnBtj6AJr", "zyxwvuts" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$0gzRQyn63KJGHz2IgBC5Vtiurlfv", "ab1234567" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$0TZCcjXB1.FyrqljAUJaVxbxukTc", "ab1234567" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$HCJq4IwHYFgr0qBYctL0rwoXNnlE", "ab1234567" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$y6RIbBXKq/U9DgS4qYr6d8EkFFyI", "ab1234567" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$RRUYOaZ.yperjvWOWC8eqDURG0X8", "alexander" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$gxwXwNNVJUfd4bNTGwx2hio/DuWD", "alexander" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$MH0L6iqWqUAR5q5VKf4kCjgXQpun", "alexander" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$EBWqMJGdGmlkPJ3hMKy9G9EnO5Cj", "alexander" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$iGbi33LAG//xo7P9OrVgt2e9uG3D", "beautiful" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$.U8q9ng/yLORWouONPNqpC/yMTKt", "beautiful" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$exwvD8qwsBWPbRWPgh6BalAGjDgM", "beautiful" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$0zUI1qcqZdmaHgKDOrcisK0FGddE", "beautiful" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$Z/.IGAXegw2kcp3NrpNA.b3TExw/", "challenge" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$Oamt4nNqncjsLrQlCdxUCAztbn2m", "challenge" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$7FytHUwn/VBgEtmKVFe4yRz8b9Ha", "challenge" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$0jVKVGrN0wvtOMFYrT4bkB/oO3Gv", "challenge" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$HhRx/Ht9CLmpMKHW4Be0u1lGp5xk", "chocolate" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$dqVgEi8YKsf786zDZPt3FHsPmqL3", "chocolate" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$UPUpnKhJdSi795DMLIlTkz.zKj9s", "chocolate" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$V5h6.MG39oli0U5PCZOnauukWonp", "chocolate" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$j3UfDsKNCssFBTPEka8mKGvLiest", "cr1234567" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$/peMa2rTr0qQjcHGpJaI3PS.W/rb", "cr1234567" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$1W303Nca3i3PvnmrkZr9EM6A6Mt7", "cr1234567" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$5bB4M/IQSjj6nqdZr.DbzrN0MY/N", "cr1234567" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$nxQZcrYTwloQ3SfLMqtFm/kKJqH6", "katherine" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$S7FblxEUCvl8nFqlPeX8ezoGRK0I", "katherine" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$WtogReSEY.tPLsA0KYAd1emXnG.o", "katherine" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$7siI6B3pe.tSom1SFZpw8JwmGJ2P", "katherine" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$Ihx3taVNZ7adhKZV3gEqexuZLEzJ", "stephanie" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$POJf5NDie5l91DNDMTrspav9haEX", "stephanie" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$DHhjdouuLTqY4sIg5BQFHvRJyOkM", "stephanie" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$i/wXlVLnQbnsuoesL8tbxh/7DKi3", "stephanie" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$18wDgMPoMpl4DIfY3uVzFtSvz.Rz", "sunflower" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$fH9G35dSxw62qYaVYR07a9fn6lbM", "sunflower" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$yW9TNxSlAShsumhwq15AWtKvwxjz", "sunflower" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$iteXYw8XvE76pdHzS3EV9kzNCCH5", "sunflower" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$0Em11nwLcF1KLAFrPIVImhyDDg3H", "basketball" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$08jDlHINxEuFBSRMgGes0Agbyo9G", "basketball" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$uTKagARWVMMfvR1SfdXwktF1N8D4", "basketball" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$LWrJCyly9hZYMNdIYmJeFt1NL7.x", "basketball" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$bJq.vrY7Hepqu.MQN0RjksUq1g1F", "porsche911" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$vUCwAW3S7V3ShfjByPUZjXvkkLlc", "porsche911" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$xCUDZyBf734N97WiX61DCU2MyM7C", "porsche911" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$SkP.k3PSMo8H7DZXj1VEkIgH/YPn", "porsche911" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$WFygibX0dgvTCbTvVwhLE3fDn0QK", "|_337T`/p3" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$tu0rAC7uzczRfKZBACsIOyoXQ1e9", "|_337T`/p3" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$tHjMHWZ1Ed.mJ/1hOxi8lxU5Wp5n", "|_337T`/p3" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$wpFfxr5WYr3HChe6cA8r4XhphGf/", "|_337T`/p3" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$iJ1CqxIlvrZ09jI9w.o3Zc3dsoEq", "thunderbird" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$TFfFzeE6VstiWlsO2E6RGTxR4J62", "thunderbird" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$sgKMac/nyL2FtRxlfIBoVCKiVNen", "thunderbird" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$op47uCExlJzZcxLrW2VuS5HZYY3I", "thunderbird" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$PuVU6CGbpBXBpK2bHZo/Ut0E0aBw", "Hello world!" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$6MwMtjzd/WHzLGSI52GXr/4jX7vL", "Hello world!" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$k1yThyIEpa2h/x6R9yXSSK2Zz7i7", "Hello world!" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$YTj6RNNa7n7SXzGt728eI4OvWQQm", "Hello world!" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$DgX4wcC2rmpnCUwqS6XtoMeVOQp/", "pleaseletmein" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$opDsvhROutWpgqX1TDteJS4BUb/I", "pleaseletmein" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$HBeNjwwtfNwV6cYzO/BUeEfpaF/s", "pleaseletmein" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$fPwPwQD6qSpyM/Y1E1b8pauFj3KC", "pleaseletmein" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$UyN40MGCb8O0QUISTgRP4OihNg1k", "a short string" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$xdLE8zMImh1y7Dh20mJ4Vnu3/3os", "a short string" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$68q.PY5p2z6J2poLbV0Rmz2b1.Xl", "a short string" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$OdIS.TLfeSUwNZ95hOaSIYzpt7lO", "a short string" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$w1iV0W6F/mtL82sa5FWreQbw48bE", "zxyDPWgydbQjgq" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$qxD8BGydfVfk1QUxFANhfeFHc.N5", "zxyDPWgydbQjgq" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$3K9gBj3jbcYY1wLPPJXHM.j8kucB", "zxyDPWgydbQjgq" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$Fj5uai/pq53MoK36RdhO32o2cL.s", "zxyDPWgydbQjgq" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$kAEDsHJt1FQqZ0Tu.FSND4WzxkIN", "photojournalism" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$s7VG48i5qlWsi2L9w0b4UtNH8lbO", "photojournalism" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$K84eDZhNb7UPrmYdjK.kZpehcOQV", "photojournalism" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$Io27rIBMIITCVyiLrAOpXX/qYAKF", "photojournalism" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$MNRGm.wL5SQZeg3LSLYb9YRK777m", "ecclesiastically" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$aXxTZS6hK6zv7FP8KzTeXzkrzJA2", "ecclesiastically" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$l210wtVdfS5L7zXiAWg8iXwk6YBc", "ecclesiastically" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$YnrpanJtO5kjtFXT/i.y//.ELHaF", "ecclesiastically" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$M5xx8nh3EgMT9Fc8SAS1adeBrjg2", "congregationalism" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$Utz7UbQkqKEbg9Cl.qAtSxD2bQsc", "congregationalism" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$G6POXP5uD81VxdvRcFmiOsRWdp.Y", "congregationalism" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$FfFu2D5UVxnc.xCbmN8HLa6Sdf8J", "congregationalism" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$KJWy.WJVVoxzdlw52Zbg7wT5u9P6", "dihydrosphingosine" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$DVL.o4xjpNBVKIyv.DP6P5Ip/oCh", "dihydrosphingosine" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$lmAhoTfrOJw0VQpmO.aozByboWER", "dihydrosphingosine" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$iMdTClqZUleHuCqlGR9LUWahy7tB", "dihydrosphingosine" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$wFokh3I6d6MEVZbvUZNqXSIi1rKY", "semianthropological" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$3yvWSwVTW/OnnJ1dFqoaANuf9y59", "semianthropological" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$AanEEj8ov9AzQ6I0WErvvUgS1Vt9", "semianthropological" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$Hfj8iZBDJLyu/nLgdtasfsw2eQMb", "semianthropological" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$f98fwWZutzgZuZjwsLyX.F1kg4Wl", "palaeogeographically" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$Aa/5Of9op0oQGHKrUazFLabsQs.V", "palaeogeographically" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$6rChzFn2O5shSlB0icdWgCoAo8jL", "palaeogeographically" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$e4v.geXpULpj0zDgQ3X68lMx1Q5i", "palaeogeographically" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$gt91MtFM2Bl7C4/bxZXT7o6UAMtf", "electromyographically" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$8yVB9AjSAx7D5DKXoWbMIED.qkBV", "electromyographically" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$39/p9L/UINfnGjcOiD/SbH.qIf0d", "electromyographically" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$cMrppqBODRDidLPKsp7dIeMvLnnz", "electromyographically" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$PIcK7/MRaVxd7TXqrwf4wpdxOBS9", "noninterchangeableness" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$u42HIhhX7Ko/UwjkVmNM3rL9AN5D", "noninterchangeableness" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$elEqLPmkxasI85MJ474OeXEwNfR1", "noninterchangeableness" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$IfJmIXui7p1HmG5FkiNKSecE7vXa", "noninterchangeableness" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$ASOcvYQ6KrSjxyjw1togF9n9VCBV", "abcdefghijklmnopqrstuvwxyz" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$uAqgtGfbcUMbHvctwCQBH3pMnO4i", "abcdefghijklmnopqrstuvwxyz" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$G36.DfuxWCD5nnv/Dti82e/a.2xQ", "abcdefghijklmnopqrstuvwxyz" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$RBMU8K0iB26X8/6x.qjaFYKh/uD9", "abcdefghijklmnopqrstuvwxyz" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$CxIqcg69KfRz5gDOABfWHLwcNf5Y", "electroencephalographically" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$e0BgTV7r/gJ6OV12dJXVzcUEkG6j", "electroencephalographically" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$A9Qg0.8NvqaPKfMB2dcUNC3alaRl", "electroencephalographically" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$pnt/NwsBoNzYemC.xt/fydIN56hY", "electroencephalographically" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$Wc/4rTJImQHAUQ/Fi5B7O6gxM.BI", "antidisestablishmentarianism" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$X.JadOXA86ypgkqIM4v3pi5kNKHv", "antidisestablishmentarianism" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$gmJ7rzVSZSdx6/17wwo0D/mtZ6Eb", "antidisestablishmentarianism" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$1LtFfVPtd.XqVQYp.TZue1IB5xkf", "antidisestablishmentarianism" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$ocG2YkRNcs6PNTgWNKHr2WgrFIBD", "cyclotrimethylenetrinitramine" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$7nUx7vXFrbEozgASvE25dpnTqb74", "cyclotrimethylenetrinitramine" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$vnNqeP1JkhXF.vQoIjD5GirjNDQa", "cyclotrimethylenetrinitramine" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$hjpC1EhsF7FfVORbQZxEgKJyv2X4", "cyclotrimethylenetrinitramine" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$x19TSKExVjDXMSyIKnNWUTDDw/U7", "dichlorodiphenyltrichloroethane" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$LvENCurrUesWUzDpnt3vmdniZVNr", "dichlorodiphenyltrichloroethane" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$vEvISAotLlSUu/MBBQljm1YQHR9B", "dichlorodiphenyltrichloroethane" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$1356iAygxiV16hrelgftX56IU6mO", "dichlorodiphenyltrichloroethane" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$kKf99s.OHwqpY2LveX5WHFjsiE6F", "multiple words seperated by spaces" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$VZ618mejjM3bg1Nb4hfkSQ4dA6XF", "multiple words seperated by spaces" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$NWO5CzgmNreB5xeYHHZpdlikRY19", "multiple words seperated by spaces" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$eYjLRVTbSq/5jfSAxW26jBGYSxWo", "multiple words seperated by spaces" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$EMUFfKSlnt3P5qLKLwVg0jw24BuY", "supercalifragilisticexpialidocious" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$WA62oqmOX.XSPVU5k7vbdaA0E.iP", "supercalifragilisticexpialidocious" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$jWKRusipT76SKKq5Z4zxHHUfpVPc", "supercalifragilisticexpialidocious" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$lHYEbGhKrM1ZRmqfPXwip4vB0RHh", "supercalifragilisticexpialidocious" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$dAlnKRbxkRevFazvhmarOTYsDf4S", "we have a short salt string but not a short password" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$M8EB8h612uUYJOb6YX9fCgkipg0I", "we have a short salt string but not a short password" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$a3a6IiZcLcgWFnohYpkGr8R/W69K", "we have a short salt string but not a short password" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$sFftXTj3mcMa.w/JEXAXqIPbabHi", "we have a short salt string but not a short password" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$totaKtwNhKQeSQwaKC.yUAhFPygz", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$3eezBADzknYJlMQkLtacHpC6yntw", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$egR8TbSSRwXWtSC1EXLio2KOdgxv", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$AQyOn73WUdoqbng..Yn9XY58fZLq", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$.yQeSaMQGCtUbFu7Nis2LgV4diTq", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$QIaR47vjsMev9DryhApi.FDIqp7u", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$I4fLJArARSUzQWm1CgAxV6RpSNBC", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$P.Sit/qwokwD8t243bDpdIOFtOBk", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$cFA0MAClwyaJrcmclfBUfFwK669W", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$cx27ZSgKzTqTHFV.BuEFb9cHYsuc", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$ZFZtRdHUomKSku3pbuYMXPDnaXns", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$vpa7TDRCaPWqIGCJmzQpSMXOac72", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$YX.gyNn4gBiBmAAh7bZxa/.8kqjJ", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$373JT1JmfaVV9AeQrLmvWlvIINrO", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$lPJO0.dokdHxd/afTKVWV6Vad/Qq", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$7QI1x38cNArM3d.iQmKcTgnNBMG7", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$XYVNV1cIL8JC0X0cPfexSxGGaV7V", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$bzkDR/NH12RDEpw2R85IV4oLzcoB", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$khPUkoK8qbdfSnGDXnVmpQhg/K9G", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$BWHrUET42Seg2xQswoM7vGA6Rb.N", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$fSzKUkeUwNHR22UA6EAPpYpwPVV4", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$Wa20muWTx1gfUK2mPpmpLOrA6cpS", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$ifDXWLRvPtxTQsypEXjmrPkBA8Fc", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$ZuuDg00sSwS8Th2kaInFXO5dzE0O", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$cS77z/5fVKbBLitvpVnIRc09YQOq", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$FzK5Ah9WgwSdtxI3dGeHK/qyR2Hr", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$pmpqhNVz7HkddH1PTqGuiPEQPnhp", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$lhLC53WDd/ZG3V34K2ebX5urtYNR", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$nFaf9rBqbWSazj.ooHq1.CT1ieNw", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$RcjRuWvnAr32tc/mzFRNbeT4q/I8", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$rg6RVehnME3TwNGxauBeFYnMohL.", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$jMixhjYagayubqsLI2vEj5aOqjyf", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$tIDqnSXhlW48BmgbQUIx7tf8MXQa", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$o4a6tx2N7CYm1d6LYAz0E9TwWgYD", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$k./eTdqpCL9iHr1fGBG.uOwTcGsH", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$G/6PWZSZy84cA9ewI9b0A0rIgl6a", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$sZDwvUxDQ3dJosrx3z/G4mBak1.4", "\xc3\xa9tude" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$VcZQD6FB.ypIBfQP.yQ1aov.mxeZ", "\xc3\xa9tude" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$DoC.EObtIjM8HJLdQgdU7TGp.otl", "\xc3\xa9tude" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$Pm1m/9LlLBZeC0HDbZD9LEFg6fS.", "\xc3\xa9tude" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$bk.6epHsYcz1SgOkKq7vn/SVUQ40", "C)tude" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$bR.kyclVlQuIJlImCWGAEeMz.9DT", "C)tude" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$huGnH6ykSWm/Ar1GTAfGQ0peBDee", "C)tude" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$7WcpSUFvN2oSR76BmlFNcyXxK9hd", "C)tude" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$NmI1WMCwdS9OEVI4zPbbYkqYB2Ci", "Chl\xc3\xb6""e" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$lckumipQ3drtWpIhZsqgx83Lf5Wv", "Chl\xc3\xb6""e" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$G7oxk8nlgYX9DdkageP85uv.r1Xp", "Chl\xc3\xb6""e" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$RVEhA7RCZGHwT7jNcSM50cZEpKYk", "Chl\xc3\xb6""e" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$yy1vxUWkEwyNu/CFGd7KmBHWgTuZ", "ChlC6e" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$frlvEuYifgvSP4/eg/R9wZF7jnc9", "ChlC6e" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$yVCDVt3YW3ydvmpKRovJEuN.w2ao", "ChlC6e" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$R87otilThKLSoM6e2m2Ok57uEbNV", "ChlC6e" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$lCT6UrllVtJv7hSethu/C6aLVkwW", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$GlrH0ss8fD0OwiQ.DPB5RA0aDNYK", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$XbaVbSvVT3bkN6xC/seo.9OD4GqP", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$JjGGspeneGJ.QUCgScmuUkjs7x8B", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$8J/rZLUoxASUliYF5qw3roPoQ96U", "C\x05ngstrC6m" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$6Ywi4XG3ASJmOkAVGCCW7XAIvyDV", "C\x05ngstrC6m" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$tdbIJVVY2uis85MwC/OfFTzwGt0o", "C\x05ngstrC6m" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$OI34Udh90qNL2N9/FAefW9byMcyd", "C\x05ngstrC6m" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$.ezYA.nWFgrQVQhlwRbP06XIHKme", "C\x05ngstrCU*U***U*" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$NhYiqvdFOXWNsqZ91DOkuj1aue4g", "C\x05ngstrCU*U***U*" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$NcbU3HfUE6jVnMiMTOaU2dj00SIp", "C\x05ngstrCU*U***U*" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$9gvrSuY.A.fH37Fc97tEShuVTD62", "C\x05ngstrCU*U***U*" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$YYyQxusqQv61BzY6u3Owggjxn/fa", "U*U***U*ignored" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$7/MDoFThUx.o079a96AvY9L3xgwZ", "U*U***U*ignored" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$s4q5w12aS1fGCGmbUldz4/7VTsgv", "U*U***U*ignored" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$lGsXGC3bGbH0MdlfnTL4fjYvDms3", "U*U***U*ignored" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$vZ.GOyiM8e833bLP3M822wM16RXj", "U*U*U*U*" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$wP8g2GEZfpP3uUb7DXNNQkbEkmH/", "U*U*U*U*" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$9LuetbomuuWOK7hOcseKci.bfmtc", "U*U*U*U*" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$L4F2xOdkXVyk4kyR6YTHi6cKF6fD", "U*U*U*U*" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$.p.GBhRbUvVTYGLHPQtH3Eu76ZCP", "U*U*U*U*ignored" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$YyXQESPuoS1Qv0YHJ0ckhLkymRz6", "U*U*U*U*ignored" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$ecxGKRGTcmOucUKfGBviHs9i9NDO", "U*U*U*U*ignored" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$JpDRUyl2ukjgNV/kqWZjKe.Kox0P", "U*U*U*U*ignored" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$5eNtACoA6wV1Cf3ogX6b7I9PZD/v", "*U*U*U*U" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$k9Vq6RUfBByK8PwFgpk51DvMOXVq", "*U*U*U*U" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$.q2hQd3qeDCo0LM8XFWS1fUwoOBa", "*U*U*U*U" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$hLm4hssKGL5hKCYAwS32cTvMPkyN", "*U*U*U*U" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$lq.bfcAX3gZt3DyRZNB06JAcQC0w", "*U*U*U*U*" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$sn5.XhbA2O4hC4v6ChbZiXMf.kfs", "*U*U*U*U*" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$oNe7DeZUgYxDDeUPC6DdaVTkaoOv", "*U*U*U*U*" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$8UWmNIZWZ.IO.Bitwzg6NjRu8bJm", "*U*U*U*U*" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$HiHiw87aVOp3SjtbFdVU0GjjtyLe", "*U*U*U*U*U*U*U*U" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$T5uNohp1sY05MZ5Rows3eEU7bhs.", "*U*U*U*U*U*U*U*U" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$arIZAG0ASvSpqcmtFDI4YcNAJGxi", "*U*U*U*U*U*U*U*U" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$66o3gct6bg9enNwyPOnXLkToLEp.", "*U*U*U*U*U*U*U*U" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$NHnsTLD9c.qqpDj0ivsy3UesXfyY", "*U*U*U*U*U*U*U*U*" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$QN5qm.mwP7XtG1Jamo3igqY/Mv5u", "*U*U*U*U*U*U*U*U*" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$zQlh1xTnn7PlUkI.Lr4CcGBQrKHs", "*U*U*U*U*U*U*U*U*" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$eCWSg/IiErpjfaoAY2f3VdCcu7ne", "*U*U*U*U*U*U*U*U*" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$fDEyOBMUBXwWaOsacf.qOdthtnHB", "\xa3" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$gV2eKiRwPx5LJbJvB0sYg9KQciVp", "\xa3" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$1Azk2nQWrVF1xwjl9.wAmhwn1Dy1", "\xa3" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$W4r31HbkRL6iJUvu5qkZjxTWLc.5", "\xa3" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$lUfcqV58n.68./0EShcaDtSYWiNK", "\xa3""a" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$tiMzbPt4HESrqCVzPnLf2nd8x9/i", "\xa3""a" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$rxIHEdG9yaUP9BTgLZNd9ZrjBJWt", "\xa3""a" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$WRCz6/eoIIbKcqfauydYda0BwnQD", "\xa3""a" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$Cv3ybI0CjNOBYjoO8UEJ/sjus9lh", "\xd1\x91" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$IH8M4EDkWIoT8grPgpEY06LZUNN6", "\xd1\x91" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$1TFjGzYsp8rNyvt5B0tv2W2YxyBk", "\xd1\x91" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$ldW/R8wxBbUmF2NA7Pi14L/F4cze", "\xd1\x91" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$zRceyKwrWMJBT7db4Y.g/UKqe0kK", "\xa3""ab" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$7fBVDHRYcA10Xx43bVfgGoLg28D9", "\xa3""ab" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$irFslG7UibZiH9wJLWFK5UHDVXNj", "\xa3""ab" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$wnmxICXdkkBqiRIhbAoPlK16rDxK", "\xa3""ab" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$VXF5NxVr0bYGLytXPiL7vC3yRwEn", "\xff\xff\xa3" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$6YO1uAKD1aBOAZHb3lTk8d8kBUNv", "\xff\xff\xa3" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$y7e7hXzJrCSK7m1cLj5WZY26a6My", "\xff\xff\xa3" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$b8OelPiAHe8mYYG4TzeYFHh4dOX3", "\xff\xff\xa3" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$Pn4YgWByMZwjfLPYPEL08rliEqvO", "1\xa3""345" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$QNPXOFIWoTRDvgOK.mx7tqHTBGp/", "1\xa3""345" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$piLl/2exQRevLdv.Ml2Mi4Ec3nC/", "1\xa3""345" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$1AoD3WLAbhK3Fdcxl.Zv5ANbzAQg", "1\xa3""345" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$kKlvUPVr/IhPd6K3OjQHNgrfjnxX", "\xff\xa3""345" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$TPfIaMJk.EwkF6lLVAQnIAetGZHT", "\xff\xa3""345" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$1Z6wO1XiQcPjQ/6562tbi53SkjV8", "\xff\xa3""345" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$J0XLa21Euf1rIa0uprO8a1zCS3vY", "\xff\xa3""345" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$aZ6OQv7x7zvChQvsHqzxuPetcBP7", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$CWClZr12514vpnWHc8ySga9.2jSx", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$N5bO63BYWVXyYMnGobPm9fNOeV4q", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$yb40wzWbA8NBAx0TPhUyyQ3u6EWT", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$VK5HtRgp2UOB/z2JIxxEoHwmA3OM", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$eobLeTF37ePbcxR.oK/2PuZqSdWQ", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$RDsyq3uFVRLbSmg2ObD4SnHSvnQK", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$q6f5RKwRTo00xqVXF/pXkLG2SYmK", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$nbCwTmRDEbY9eNSS.UuOHqfik9EC", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$4nj6DOAsCTz4GuvxdAhINzMsWQtX", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$fAEK1T/oFKsIh9sboI3spfNqNBOM", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$3Wbmlp4mK0yT/DtOkvslGV0N8HCp", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$QS9Wg2yZk2Lm.3U8v6W9DHm36ivX", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$k7d1KjnjNACPAbiKWMenwUjQCQGX", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$xgz55CjqgNmydkdemqL9Wm4QTgXW", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$EMrGDUBDdjniuXmmIQ8WT8/r9Fq9", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$aMcJMC3XjD.gP5.glG744i3eKp0p", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$4wF4kUkElJl6mhDvdRld6yR5N21g", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$XLArh.YfeVeOlhdyhdSkxHtkQPgA", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$nNSyf1OgbiYzlPhH9wEi1EfytjUc", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$940slNzFLWJTrnpfSwL1JxdrUf35", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$pLaXrLNBULbSM/y03S2PPbbpCi/v", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$7/1wqTR/8w4gG11lkuoqEk76kDTh", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$5nEQW638iyLrCL60FUfPDym7ldI9", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$6.oXLFCk/sgk7UtgAfrZDKrIDeLv", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$YF5QaIrSoREJPLZTnaZVAtdtkBtC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$L6EVbKBdIYazhXRimAgyM45J3aoP", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$IBK.wDSFrF1.jUbizDLW9STb/EjR", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$uI6mOZKK18SwXyU2bPKwNGz06nL/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$.SWn8.aXKqe7RiMkc5HoLiQ/CbRm", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$RuaRNYlRkDHYpN3u7beWYym7qhKx", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$lTINYU41Tl7RnjvMC6tCGCByZlwd", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$FxIi5d2Kp25IMRlRHzo4sEZ9teh2", "THE YEAR" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$BtIqeltUbAwyCW6I5mLorivdNfwQ", "THE YEAR" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$XHsqKTWefssI8mhXXgMrlZsNPfIJ", "THE YEAR" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$oP9XJgU7aE5n7Whw0VyjVxxjAGk4", "THE YEAR" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$A7Vifk/FRT1QUrJCaw8Fyi6PuiX7", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$Colp64c2ar0Yygc1ZpDS.tFfLn7k", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$drqxGi7mXaSlILtUC0gzzk4UrTNj", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$p.Oj34VIAnJFXFby5iM792QwxaYU", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sha1$12$GGXpNqoJvglVTkGU", "$sha1$12$GGXpNqoJvglVTkGU$D83A9oarQDhx8jqd2Ms5Ds9lkYMC", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$sha1$12$xSZGpk6Bp4SA3.cR", "$sha1$12$xSZGpk6Bp4SA3.cR$Fi3D1aMpBKlVG5tD3PbkkyoqwEgj", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$sha1$456$GGXpNqoJvglVTkGU", "$sha1$456$GGXpNqoJvglVTkGU$s9kkP3Pp9Ylj2RgsnLcWyHrT1rs6", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$sha1$456$xSZGpk6Bp4SA3.cR", "$sha1$456$xSZGpk6Bp4SA3.cR$Zt2D/B27LbmI2rKeSK5PctBywc6e", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // sha1crypt

#if INCLUDE_sha256crypt && defined TEST_sha256crypt
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$TzAJABAaJwl111nyuH1uQy8kjHahyMHq1D7Y09hLQV1", "" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$9rs63TM4j6doEhq2MAUYxnS5Mc/aeEhOVfpnwHTpz6D", "" },
  { "$5$saltstring", "$5$saltstring$FdNfA4gXqvCeO6iZs7G/.wwwoywYZqo0l1pwmfWaBA7", "" },
  { "$5$short", "$5$short$cLqQczNe1fmrPIy0KIrfq/WfsyygGH83SzXaZDNpS53", "" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$4nti.9yeDGrq7dgFVF6jua2B1WVYRoUDP9bEunlHAoB", " " },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$BkGJgO5w3i5y7cMInvGAtnoOaITfZPQMoII89TwRR56", " " },
  { "$5$saltstring", "$5$saltstring$HykkwSGwziMgr/9/Jna5DIi6FDwhDkmbAIZ70wQm7x1", " " },
  { "$5$short", "$5$short$2LqgRiiiGoTGSf/Kca60f5hmY5qLS/I8Pm9DeD3cIRA", " " },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$PUh3dLhrRUf5DImijCTHA/6RNalgRtHHx.PjXg80gE2", "a" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$d54wru8d70L00hRKpuVP5j1CwpjR/Sr.f8IdsBMUx5B", "a" },
  { "$5$saltstring", "$5$saltstring$7cz4bTeQ7MnNssphNhFVrITtuJYY/1tdvLL2uzLvOk8", "a" },
  { "$5$short", "$5$short$26OgkZnNPH/fhIJiNDSUG8GpRVc3tG42gPClFWxDDA2", "a" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$Ndn3qi4Vkx11hLCK8fYx/utZ8feeqrzddAFNzEVII2A", "ab" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$w0L6KFeqIXAW7ys62SmjADL75RsPla2sbOG9aMzgeN0", "ab" },
  { "$5$saltstring", "$5$saltstring$4Wjlxdm/Hbpo8ZQzKFazuvfUZPVVUQn6v1oPTX3nwX/", "ab" },
  { "$5$short", "$5$short$dDc6wcJbORAIZqWEh4wEd1f0ik2FgRzg20VpjLnwJj1", "ab" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$n1MEWFPd1lEE7/KU5DhSUSLK1IJKM0A7BOA1Fk2uBa1", "abc" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$0Ij9XkhowU5BQIHIg1KJcjx4Nhzc/iCx.RamOa64mc1", "abc" },
  { "$5$saltstring", "$5$saltstring$tDHA0KPsYQ8V.LDB1/fgW7cvROod5ZajSrx1tZU2JG9", "abc" },
  { "$5$short", "$5$short$PKcRAEJSPWRgSvYSDOgjYdNBO/NQesdEIekzR.MC.B6", "abc" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$QTMEAJM8XtlGnH8mydl0lpvaoi8Tfx.zzYENctIj/S1", "U*U" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$sqf/wEDeYsKoPjRyXCcrE7HExjVRaMwh.8NOYTU3vH/", "U*U" },
  { "$5$saltstring", "$5$saltstring$L/ZEDb/ocvEdnc8kd0PfoWLeVTOVNTFbXLW5ASvhNxC", "U*U" },
  { "$5$short", "$5$short$J5zE3iFFNeXjpqpEylGntITmXwqDokMWugyKHkdDgoD", "U*U" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$w7B.PZBQo0HzMEIoQRJCREnXorRX5DBvuQJfDc8JAt2", "U*U*" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$1dpaSH3OopbKKF.vz9kIAgHoDHVFyPeE9FXXRuH2EV2", "U*U*" },
  { "$5$saltstring", "$5$saltstring$WIaR8zhcCgrBuajNZ8.ji/0LvShyVHiYOCQUvPYJwk.", "U*U*" },
  { "$5$short", "$5$short$jNknpdiAHr.cGSEV3eu4Co564H/IFUk6/WKwoYSOd8C", "U*U*" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$BD9vKyRCILdHHPoj6XbXoZDmo5uPjdY86UiDlZKds96", "U*U*U" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$VXbLwCUo1D6oEdBR808Vnr24eXXyOPJvJi4LhjZ5d03", "U*U*U" },
  { "$5$saltstring", "$5$saltstring$ug9WzODAg6NTltop86swjVhibITjtQkuiQ3ruyozXX4", "U*U*U" },
  { "$5$short", "$5$short$gQ.OanDymM7z7SxBB9TNRd//x1PiwYtzSFzfPBZ6u.B", "U*U*U" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$ut2CmAbIX1MifplCLAtPBz5uXi2reY4T0vDeSwoU4P8", "....." },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$/eA8s2vA7Mf7/vPuxtEb7macFmjbsHDFzyzcQRjBwH/", "....." },
  { "$5$saltstring", "$5$saltstring$XEgskAvmn0w0uulL7.zemqva..V960QOSKvibYJxDO5", "....." },
  { "$5$short", "$5$short$yCvwWwNy5kxKzp.dWCO92QqfZLfM2g8v7hpHJMxU8HD", "....." },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$cFiLTMs.Jr2K8y/P/6CFh7StY6egGmiq52cnuiEoX79", "dragon" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$6UOH5fnOVqhx8m/LZDTlROwiLDyQupxaY1Kx.hEV3VD", "dragon" },
  { "$5$saltstring", "$5$saltstring$bAAndV8SatHm0GHO.MXdaHSuBK/E.jHeO1S/zczf1jD", "dragon" },
  { "$5$short", "$5$short$O1Ru9GOtCZikhh1oFe07JX0aDFCTmfCTOLGTpYf8JV0", "dragon" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$rN1H2WOp.isUIWF1SyyFEmYmZqc8l08twA40A7tnzc4", "dRaGoN" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$/EbClmIsqX01e/9bDZWzj5Q8BfTdP1oFh1JOIX0IbYB", "dRaGoN" },
  { "$5$saltstring", "$5$saltstring$xcUyK6BgpOPipecfDrY1a2f6SD0KmWDc5Ze5a.GDFg.", "dRaGoN" },
  { "$5$short", "$5$short$PkruwUYqaeygy0qwU.xZefUJoxWXlTYRAvTmu4ew92A", "dRaGoN" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$X5oPIIFA8.2EiQg6dAT8gW.Iv7PPwLz.dV/aIQlhUF1", "DrAgOn" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$BSGZL.7uzlFmubvJV1fAohCI1yfsL1zlhm8/1.DVsA2", "DrAgOn" },
  { "$5$saltstring", "$5$saltstring$9.JDRC7yOVZakuuU89Ql4GrR0i5JAFmM8bx3qk.yzHD", "DrAgOn" },
  { "$5$short", "$5$short$Cx36ARMKWjs9hoGpSC4sPUGHqoyG65Zq6DTOd3MoCp8", "DrAgOn" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$2GitaEekG8j/d/3b8ur0nO2M.dBB2SnF0QF46wZgMH4", "PAROLX" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$JxWewYMcEW2ywgV6ESnbwpOKb49RqRTOMs98kD1H1b3", "PAROLX" },
  { "$5$saltstring", "$5$saltstring$XMd91zSqecc6GtwNsvY9RBcWQ5iZpXQyyeLHIumJg6.", "PAROLX" },
  { "$5$short", "$5$short$OqVtcZCBcQBnYiP66mauhM7/IBLyyEbzX252ZFZDom.", "PAROLX" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$X3hlwjc9AzhT.XOra9TAPFOQrrygMbFe1l/lgiYnH/B", "U*U***U" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$xLmPAp.tK8NBs4sk0HUbCDXZrwPF2SBIQvWA3cZh4vA", "U*U***U" },
  { "$5$saltstring", "$5$saltstring$zOjq7Sj.Mq1STxn6LfRGRcVhbb.hHTD8/wrP/m6OUwB", "U*U***U" },
  { "$5$short", "$5$short$Grsvx2pI8WZBBdHH68WimvWZseU/QInJCp4hz7bynn1", "U*U***U" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$Y1D2nLkjfzc0zppUKQvr6t2akwzcxik8LXGA.haEWN7", "abcdefg" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$v8fJBDq.7TBS532RQZiLBLKIcZFcQ50Ya/4pN3pnZ50", "abcdefg" },
  { "$5$saltstring", "$5$saltstring$4Y5UR.6zwplRx6y93NJVyNkxqdlyT64EV68F2mCrZ16", "abcdefg" },
  { "$5$short", "$5$short$itev2RUhWDo1qyFoBZ4G2GH59SGOR092gZ6Dw50vRM8", "abcdefg" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$JwkZk6wXemMg3os6Lno61imo3qbiCUXBTGJ1dv3UIzD", "01234567" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$zKyRLozv6G/X7TwpgRFwaBz.khkwZx3yqe/SwYR8GM6", "01234567" },
  { "$5$saltstring", "$5$saltstring$PLoJBR6Ssa1JeK1dtzugeoYDgKEv1C1bu9lA0sMlId9", "01234567" },
  { "$5$short", "$5$short$0aGVjAg3euocNTef7xPCnkQvgKA4t7U.W/cOXs7xiYB", "01234567" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$Gw34kCUYGK1ecDSye2mJ6rkR4OlP5YJo00f6RNd7EV3", "726 even" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$dXJWGG.EUGmsvNwF7fl/msQ8NHMN44vpok/k63b1ttD", "726 even" },
  { "$5$saltstring", "$5$saltstring$NnZBpEXQtgUXAILBss77/adN/qryK.XDYSlhSCzCo0B", "726 even" },
  { "$5$short", "$5$short$9tb7z9Vo5XyuE25srHlsupcqfo3uCf.S7mSxx08BkDA", "726 even" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$4iFKl/GxUCV5vHaGoBVZSWfIplo1ZgDd/leUxbJ02pD", "zyxwvuts" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$7T5eXcJXbhQHoDBaytYshEEPfL11ic5AlcquYr7rrJ1", "zyxwvuts" },
  { "$5$saltstring", "$5$saltstring$ZtEf6EZNrD0TnCEEXKwocMCBzUX0X3wGfixnJiZTXA.", "zyxwvuts" },
  { "$5$short", "$5$short$70hQf98iYxO0Gf1XH8ysrx141gT38/5NTrgSMjZ6.d0", "zyxwvuts" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$pqZW6kqyGeiRLcN5mu4J3QDGn/28l2iMpKxokNjSr06", "ab1234567" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$0Kom8xILqBjR7KI1iTjhfqkphspqFY.7egtFWByXTf/", "ab1234567" },
  { "$5$saltstring", "$5$saltstring$BkCPxWWwOOkIwsv.2PXz64/DMckCpuJNuX4KbNVv6dA", "ab1234567" },
  { "$5$short", "$5$short$XzxGMkSLy5F7Ay4.HmRl7e/rk.2y1.MnfQB1CWIhoI4", "ab1234567" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$Hn1MNhjZFsbzO6XqZz0rHm3jZfTw1U8WQi9v2pAOYW6", "alexander" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$s.59odO3IwUxURX708YNMsW31djTqUk3ewXmoMg4/T/", "alexander" },
  { "$5$saltstring", "$5$saltstring$NASvps1iAyfFVbJQQZWtoTYaiWEzDqP8YcqCnwG1WMB", "alexander" },
  { "$5$short", "$5$short$/EVoeDCPif1fCxo6nRjQg78HoEdI2Gr0.FxdjPXkMO7", "alexander" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$12KE43GvUv2S.lCD.FT24yy2Gz8.KeGRUWYeUTgQG/D", "beautiful" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$rl5ihbSEp3unBa37pL9x3bMCORjU1JVYMC1V8xnZalC", "beautiful" },
  { "$5$saltstring", "$5$saltstring$C2AMAGzuvgJxOZmNP/T6rDBhQ2zTRK.CXpbG1S.RWO/", "beautiful" },
  { "$5$short", "$5$short$Z3m8cvUtBOWW/TICiik0gnCW.FNolf5HZeF.4l5WTxC", "beautiful" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$4pWYCjU.v282ET..m0e6Y28SLhqtX3ocW26g0dLIZhB", "challenge" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$JX85magFHwzAlI.FpT/4GXk0XSah4JVIB7EaS/CV366", "challenge" },
  { "$5$saltstring", "$5$saltstring$nSg9yOU7v85EG.edc.jZ78Ka/vAmOSv5ZdiEieR6p41", "challenge" },
  { "$5$short", "$5$short$YtN8juwAK8.02K.WFi94MUAHO5htID0BWv7sDwa53F3", "challenge" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$YXFib4zYzUk3bg1GUlp/gw8spbuhihIXp8.HMhFR1aC", "chocolate" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$Fb41GKZeDO2mysfetiL3XXLHVpSv7Lf5LS539rxd.y/", "chocolate" },
  { "$5$saltstring", "$5$saltstring$z/1qMnW24cZekB5Sbv0LFzSkHTgxCABbc0PnRnjpza5", "chocolate" },
  { "$5$short", "$5$short$/1.yT6KLIOMvLobdCcZ1x2jUMBTN1gO6QhlEzLNzimB", "chocolate" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$.TJeUK8SwhVryWkUKzCLK4cfHgsWYpc8JUZzAOtHfzB", "cr1234567" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$9./UKvCIa1i9cPxaAaL9nycTcVTkKb3ssgYNH.irxq9", "cr1234567" },
  { "$5$saltstring", "$5$saltstring$W4PH1hC0FvF1QzrI/pAb2xb8T1WTiGAj.XKN5zbCpuC", "cr1234567" },
  { "$5$short", "$5$short$byYKlAD1fPpFqbB73q34Kjg5CzMExj0eRq03jhSPES8", "cr1234567" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$RxJhYX141E4p73t1p7/IJGJXbY1gKHeUgMsjTcv7vr/", "katherine" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$59ya0/bIilo6QjRKAAXN4HQ2COqb.p/PyKd9OD9QwcA", "katherine" },
  { "$5$saltstring", "$5$saltstring$4XM9x/HGGvQO1odMw2alp8070lFyl0UuSNiX388ZDw2", "katherine" },
  { "$5$short", "$5$short$1qMMEHF.p57mXoBmn/1uVbikGKL9bIjE1t2mHuPwax4", "katherine" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$9RKy/x7FoouKS76XViHdQ9P6I66lWfrAqFYokMohme3", "stephanie" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$q7rGjsU6ToOgh/cg2twyLty8ZSzVptf5P5JzdGIhGtA", "stephanie" },
  { "$5$saltstring", "$5$saltstring$QusAfTywgDjEbZp18TERSYkMMvJj/FjodIIaAndwka0", "stephanie" },
  { "$5$short", "$5$short$qM3Ld3MchnyBfIm0g4U0SZRer//Guy4QRDy1rkpDb3A", "stephanie" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$cWSOVvB28CkzJ0V.xwYrZtiJsDg1yo9PN.tIqHlAgyB", "sunflower" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$DvBa9WTAV6Uab37tH96oR9cS6OQ4hL/nHJuTaNIL1D3", "sunflower" },
  { "$5$saltstring", "$5$saltstring$djXKuk38DBZzNJt5zhLQ02lOKteHN7SbHGGJpFLyhm6", "sunflower" },
  { "$5$short", "$5$short$s9zT/0obfO8v.U64FJZ2yuWSoo/LWV71Uy5By/ebni0", "sunflower" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$pMAkXql6tGOnzxwkOctgd3upr1z65uBwKrDuNBztV75", "basketball" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$rtSRz6EpMscNxctAlAC3O/4yMTiHPUxQL1dxzg0UL/5", "basketball" },
  { "$5$saltstring", "$5$saltstring$2Qa7B6ty34U6dsIgPjZvPB4ajafhobA9Vi5yfnz4.j2", "basketball" },
  { "$5$short", "$5$short$XHEJwWoI42rN4rzke1nrDPqCkUnUdy8BuCTlGOLL9VC", "basketball" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$5XUdMTGZZ3ke86N.zy9olu04KlBqZyXhP.UCB1BwOs2", "porsche911" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$.rhqJWTVSXVRjzzPpkeRx2KHakpI.PQGSa8ksI4Y9f0", "porsche911" },
  { "$5$saltstring", "$5$saltstring$byuieD/21AZCxtnydeGT24JMyziARRCS4gbbbCPr0v/", "porsche911" },
  { "$5$short", "$5$short$IbXJJiMLPClu9L3wbYp9p.2Ct0eUb87QcYa9//i7d98", "porsche911" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$fXkDMdP5GQ2xhn.AaSaP/w4W6eZusrBaxRVrGu0vMt3", "|_337T`/p3" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$xlfWYGY4rA2QGhq/HxauZf3XJJedTJePznUXsdoWwR8", "|_337T`/p3" },
  { "$5$saltstring", "$5$saltstring$yO0RPKJPpCet.RoPrSJk7wj2MquZzqqw5cD9Uerf2wC", "|_337T`/p3" },
  { "$5$short", "$5$short$7Fh5KVvhymTZfrXYBsZJTr3WfTK4/ceSwm9Esct6B3A", "|_337T`/p3" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$jhQcoGF9yioDllOF182q6gAcYiRoAKFvPvki70b6028", "thunderbird" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$/nU38mqaYcCUz.xu.bOW8mqW8Tt5HeLTTrGLNmD5S82", "thunderbird" },
  { "$5$saltstring", "$5$saltstring$/paWdBHd0YsYYU7DT6Vnwm7.zYKvMSzm/yhbJ8xWXAC", "thunderbird" },
  { "$5$short", "$5$short$ruwod7bCElrLXcAciMldFy4VWE3DTYKL41Mt2F6fQKD", "thunderbird" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$z/y8l95GSjij6uHx2xAJer7YCODLtrhIxItWC13D4g5", "Hello world!" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$Zn1jA7vGSJxSOcxz82BehM5YBK0V0FxI3Muhq4iKhwC", "Hello world!" },
  { "$5$saltstring", "$5$saltstring$5B8vYYiY.CVt1RlTTf8KbXBH3hsxY/GNooZaBBGWEc5", "Hello world!" },
  { "$5$short", "$5$short$hmIdTXQxlIn/fe0KrwbEgPnVteecdmSd59XyxENOB27", "Hello world!" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$FPw.JkTq./NjCz2H2CQqMGCp3PZeDxHr.PYE1fAE6S1", "pleaseletmein" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$ZdPvzZvIImIpuK5lWQOf9fejM0NmEYYdVaC1aT4mrYA", "pleaseletmein" },
  { "$5$saltstring", "$5$saltstring$yHu4NCI8wZtVmEi4UlBewMEOd14T6b2X6goRY6eWJo7", "pleaseletmein" },
  { "$5$short", "$5$short$tc7f9dKpR8fAwl6jiUEkIlRqKggCyow4n/epnG7AXB6", "pleaseletmein" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$kE7O7h2srChzp1LlhZhRuAT.upiSmuoxq55eX6ABKh6", "a short string" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$sUlltbS3YXuMuo2NNBE4iOBTqSYoW5P3SGoMvpu/bE.", "a short string" },
  { "$5$saltstring", "$5$saltstring$UWveRLeGMbj458WWHTeetxiIuXlDckEpLhl2OeHyU70", "a short string" },
  { "$5$short", "$5$short$uKb0CZJW1TkuGBNa8H/Od2dCTmPwq4fdhsnC6oqKe19", "a short string" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$hX96QENY7dXdfYWhKjZaNKTnvZ6LZn/I8Cu6sTSXzrA", "zxyDPWgydbQjgq" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$2aPm/vabW0Balkld/gbINUnmZ4/6R6d/9wkzVK.2cx.", "zxyDPWgydbQjgq" },
  { "$5$saltstring", "$5$saltstring$/FM6Opkx4LLCZKMWKtx7cplMgjbEUg.fbmUtj/46Qd9", "zxyDPWgydbQjgq" },
  { "$5$short", "$5$short$V3q/FqxoOxjk2ZPeFyZElOTz0uKuwTwKaD3rkQWDyY0", "zxyDPWgydbQjgq" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$5C92.MkmJW5sYQhA1zsGrr8Eiuckq4bIC4tEf/eRHs1", "photojournalism" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$sB53ls3vS.M37dOgIN6/8nVyvIrzkTy/EBtZRb2Jwi6", "photojournalism" },
  { "$5$saltstring", "$5$saltstring$ODWcOQ1n2vDcY/4Um9g9fQ2rCrUUULx.A7h6XKyc5p9", "photojournalism" },
  { "$5$short", "$5$short$Gl6HC8b2tRzTC14g.7dcUwbitwTiUQCvG/GNnZoamvC", "photojournalism" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$9iemJMGS0YQTqG0BXFl4xbjS5nh./iVHnDS9jp1Htn.", "ecclesiastically" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$XkZdp7kQyiL2RZSb6/rSEoD.08dW9J.4CmIzPworvr3", "ecclesiastically" },
  { "$5$saltstring", "$5$saltstring$O3atAUTtQ5OE5RhXUyifvH7K8xWHdhhVCDKuzGFPTk3", "ecclesiastically" },
  { "$5$short", "$5$short$YFDKHxfbGUrj2mZCL.2rKqRUWdxSODho9WFJEC7E.VB", "ecclesiastically" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$cFArbePYxzVxWakU/iL0X/td47zSG73L5Hi6lXG9Uj5", "congregationalism" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$GPo/DSbLsla2hj39B3GHAKkgkyuexKvCn5y7M54pzG8", "congregationalism" },
  { "$5$saltstring", "$5$saltstring$FVhuycUvkCWxMLNj20kQ3dqUSAFQL/uDyV3tpdb76t1", "congregationalism" },
  { "$5$short", "$5$short$aHEqHhvf.k.FmeYcxuTdHYwAR1rfP.6SMEg3C1VAC4C", "congregationalism" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$Ztz9/LCcvh.EhdTii7HVr6B7k8gg3G91aaX07Y4qNa6", "dihydrosphingosine" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$huNMHfh6.djIqkrpVGxNubCBUHVFGE6Tl8wFnMc8F/9", "dihydrosphingosine" },
  { "$5$saltstring", "$5$saltstring$nnFpMrKDpLiOmV3r27c/u1aXuwM1qa2wmGXDy.WuZH6", "dihydrosphingosine" },
  { "$5$short", "$5$short$UOoIFo5xkPjolSPuJhqTp0Y.KbODgMzX6PLzhp0wrP8", "dihydrosphingosine" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$lGPC7OxE22w.U..pMC15d/vaJpiTQa90MGi5qkpc0hD", "semianthropological" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$Wc7kDQm5oc.ncXJKN/ovrGglAvRjyrMjS7HmFOOThf1", "semianthropological" },
  { "$5$saltstring", "$5$saltstring$gEtvL01MHGrBDm2mXMiHFJ.RrU./Ma/tdJ97IhFqKU4", "semianthropological" },
  { "$5$short", "$5$short$rgG2hgd8BVoFKz4X5O4Bw8ZGf.yUrtXVojqC/vpkDz/", "semianthropological" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$ZvtiW.ojdZ/4D5jSmorHe3cttL2u4sbtf7mrDn8mXD0", "palaeogeographically" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$Ouu8bmsjQaJoaeOXRUSWv14xTFVchUdB2BNuf/iz.T0", "palaeogeographically" },
  { "$5$saltstring", "$5$saltstring$xFg9T9AferqGOgz1tf4BXtca7pmBzSU/ndd.FcbZz/4", "palaeogeographically" },
  { "$5$short", "$5$short$VlZZTuTHmUBLdXYor9zyFWBDm8yMEGnPi7WNCpswpHC", "palaeogeographically" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$Jxz2ELvpKlzfpfyPw8z3djDAQ5rVE2VWgThdmw5FFZ9", "electromyographically" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$zxnndt34usJ/tSj4Q8vya2Rn9NV4gho17lkrHGqQhU9", "electromyographically" },
  { "$5$saltstring", "$5$saltstring$7w0VnvR0veF/DJiBgwbzy/FNE4ZL4ikQiUmRjkTocb8", "electromyographically" },
  { "$5$short", "$5$short$/kodHpDQUFXMoR8xxqDi29dHOFmqaY5xc9KvKhugIx2", "electromyographically" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$WDhu/SslnFKjL7GPYvdIbKSG6jmdDMmvSWkkhhiotV3", "noninterchangeableness" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$tias6R5/CDL32Z5E2NfQvLLMZCGkQg3MDXvru8EZYXA", "noninterchangeableness" },
  { "$5$saltstring", "$5$saltstring$IMhhfBdaQe3Z//6MqTaRLhnoALoBcSOh3Vy.S9HMhi8", "noninterchangeableness" },
  { "$5$short", "$5$short$RQqbVWGu5mxCLgzwPjj/eJ2Wv/POU5in.ReSSgcvuC/", "noninterchangeableness" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$dOmFIPgoW3PBRIyzN6aJmsPJyQJ3xbjL2FTKX162j22", "abcdefghijklmnopqrstuvwxyz" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$L/dAUhD2tZtccNIxSubqgapvn2hvJUiR.69dRJKk.u/", "abcdefghijklmnopqrstuvwxyz" },
  { "$5$saltstring", "$5$saltstring$aGry7pVYhkfltCgHFRyJXTlwefssqT0qxosJrEOX1w9", "abcdefghijklmnopqrstuvwxyz" },
  { "$5$short", "$5$short$CCHdkpHtQRLrZn5MHY1MxGZsSsSYf28qa9z1uyF5cB7", "abcdefghijklmnopqrstuvwxyz" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$qKkE9r5KjCoAOlXOlUy1eCH9GVe/IQZJat39ZctGuX6", "electroencephalographically" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$NJX.c8uJBvQ6t1JYszvMVKYZirEWJJL3GUumUtw0DJ.", "electroencephalographically" },
  { "$5$saltstring", "$5$saltstring$/z7CnEj2tu4OJv.5ZFmmY8kB2joFwjCjVdds8bn0pJ4", "electroencephalographically" },
  { "$5$short", "$5$short$PkwxjYX3tBIZwAGX0DkbtgcVzavicCK3.sxVteTLx00", "electroencephalographically" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$cT0IpGiU69KQJaTowa/7xNkIJijC0Cs3sdANYBIGMr0", "antidisestablishmentarianism" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$ExLzGAlW4swzzo3vA9VUECglgmTvYdfai4vTXptH6K8", "antidisestablishmentarianism" },
  { "$5$saltstring", "$5$saltstring$7bvFUMIVhg.kNNkYPuFV2aqeooTiC9V5ZRmserHWrG4", "antidisestablishmentarianism" },
  { "$5$short", "$5$short$CVEY4iRE63rZnxGxdW3VklcR7A1fNF5PQnJ3f1pxL49", "antidisestablishmentarianism" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$LQiZvWwjYdrFbTN5ymkBxHvng6Zu7f70raxBEOqWwUC", "cyclotrimethylenetrinitramine" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$kD6UPSVgOnl6Y8TCvrHFeEa/Th9mOx8T8/N7rpX0od/", "cyclotrimethylenetrinitramine" },
  { "$5$saltstring", "$5$saltstring$32JKKbGOT7Y8XZNR8EAesDA8FkGcSbbuOG03SSHjybA", "cyclotrimethylenetrinitramine" },
  { "$5$short", "$5$short$F5nKWudDmv5p8YEJD0ReCNioPBqQMCbjhjVH.r1RV96", "cyclotrimethylenetrinitramine" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$pvRk5EF7LhV0HzMYTUQv0kQ7x9w8mdKykut2qQDas1D", "dichlorodiphenyltrichloroethane" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$FJZEx924cmXtSHSQs/lj6qoLQdbTYetJ9SNauPdsxc6", "dichlorodiphenyltrichloroethane" },
  { "$5$saltstring", "$5$saltstring$jO1wWWY2aafB5lfcaLZIrpXJPxabcHX0RRHiFUQmryD", "dichlorodiphenyltrichloroethane" },
  { "$5$short", "$5$short$/0aLVDWx3n2SLtAZ78JFbwb0R.tS/acVYzI1TdxWk66", "dichlorodiphenyltrichloroethane" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$v3fD9XaC9bY.98wO5/ScchiBac3c6x0E3PpD9MQbWL1", "multiple words seperated by spaces" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$C2yP42AGMo/MvxjBA3yTIcMT1WqXhX8rWajXmXTp9b/", "multiple words seperated by spaces" },
  { "$5$saltstring", "$5$saltstring$pMkeCqxu.vtrw0mHNX8yMer/Z9FBDQxQLTOhuNaKD5A", "multiple words seperated by spaces" },
  { "$5$short", "$5$short$HYDJPFwuZd0fMXq/6S98o3IzpQ1Q4xBHH0Y/blu/c/3", "multiple words seperated by spaces" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$DwfeEUfydtq4ygunbHHUAIm8BZ2YBiOk6lrXLq0RA3B", "supercalifragilisticexpialidocious" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$eR16tof73KzUkQjmy6TPwSmDfhrIiktrb8.QewY1nZB", "supercalifragilisticexpialidocious" },
  { "$5$saltstring", "$5$saltstring$fiernEL6ChiHc7nPHkXcjjM9wcR1JiujSpO3M9PxVO3", "supercalifragilisticexpialidocious" },
  { "$5$short", "$5$short$vZwGOK9.Z0OTKnQsRLjYAXUxKUXziXaPn9Xx6fjaIl5", "supercalifragilisticexpialidocious" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$fed1lJ3lW2cumwmE7z56j2M9NKGJ/0cEPnUX6okL/JA", "we have a short salt string but not a short password" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$MmIwYWG9YrU4oKUcYNM.GQIpfQfgtDuY60Pogui2lq7", "we have a short salt string but not a short password" },
  { "$5$saltstring", "$5$saltstring$hAjPzXHWwGr9aUP09hSB6AppvpBlppQ76QOQrVTvOD.", "we have a short salt string but not a short password" },
  { "$5$short", "$5$short$k38kpRP0CfxHLIcmymaSTFLK.iFfF4tKryDuEGKp6SC", "we have a short salt string but not a short password" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$WETcug70j3U1CZ0KSQ7I4ExAfQMLOb3Ybdu.Fobesx.", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$sRnDROv.NNPqURgBm2H7XmSnQAe6pz4NQeIPbQltAs5", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$5$saltstring", "$5$saltstring$Hj0H5p4Ahc5B8Sj19RINIA96syTW/MJRghBIav0By./", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$5$short", "$5$short$LBld60HP1.xjGGVO9FfMs2yj9uDmtn4IhXZH.xfE2G6", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$iyc15a/9G.b4By0AM6Skl40ZFiVQ6Ve.4AWtS7qnRd2", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$G7puPqxdnBssEpD9payou.77h7mPzKganTdVxIbp2C1", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$5$saltstring", "$5$saltstring$Jihv1rKDul5NVDfWvK/9SJfRfqzAlp2aG2dN28Xeff0", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$5$short", "$5$short$YbqMzWqKsXGeoCn/jNKu8RbEoQzDewXnAIfqsYw0di0", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$IRtLOwX1H1LzYXdcKd410a1MT5McgLbhTxcnfDdQZPC", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$2Xo2DxeRyhsRVh5XZNbGBH3FjI0.RJ0if1j3Z6mEWh2", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$5$saltstring", "$5$saltstring$lrNPQ5cNmFI48/TRiyiejPsgxZjX2G91hAnr3tiSI/4", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$5$short", "$5$short$KwOfci8QXmXpL1x4ExMHKbXI6qRrYIkCvhN8VKawJH5", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$LQPlWhvLlgkoD59OQPyGFDSuwDFLmtCdDBOEuSjlM38", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$Q.Av/946CD4FpBQd9dK57WSw7gQvjF9i80QZtf9Mg28", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$5$saltstring", "$5$saltstring$GyTEZtFuSijnDwgZAdeQeFYSkAzF3f3QpZGhkJUrWWD", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$5$short", "$5$short$i3halgCPA5Tj950eNUYOu0DzkhP80kE9UzWfE8CAZTC", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$gk1cmhZrzlHbkS/YU0m.PwlXmUwpsAhUpajkCt3TxZ7", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$vwWI7JOYj5dK1i5E35BUoicYy165qCkWdapQb6Twk7A", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$5$saltstring", "$5$saltstring$6VnnZXMWFzOeI6ggS3s0OCxFV6AY9qXppMhPApgZyhD", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$5$short", "$5$short$BFDPnEODDRy1YPioHKSTylA/IOjYXHITojD3S/Y9sY9", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$yp5FNCpeL6lBQpXi3MZ84oEZwnIQuDIcbFSGJKQegV7", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$XVnX3Amv3qP8fIRCimGVTxHaE5mY51uyWjgfCiwQSPA", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$5$saltstring", "$5$saltstring$MdEVkH8B3PN/xikOXWPV6nCC8ZaO3cX7ebOsXEXZsO2", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$5$short", "$5$short$I6DOrupEBRatUlTLa4RjBdGQv1hSJotXyUJU3U8dCmB", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$9E4.qb3MwOEuU1h2sFFrE6XRrvwfMncska/wvO72MFA", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$k.tJT4X4nqn/uZOfY0gnleScETyx9LOAExP5MZV17b.", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$5$saltstring", "$5$saltstring$VEs9jMJrjQLbyhUejpy6/BdP4TbttCEIVxTfJpXcxV5", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$5$short", "$5$short$pYe1e3x0Gu/fk6VNo90twKozMEC3PQWOOlT/dV7VP42", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$HriXtU7JfPe7d8yIOJ6zTiOiT9t/nHRRr68kCKApqD9", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$kR3dmjXARctlq2y5mZYiCXREn9WCRe6B21QMFYTJAg5", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$5$saltstring", "$5$saltstring$nj0gZpcBJThrDkdgumO8UTgbgMujx/5x5I3aDUDLPw7", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$5$short", "$5$short$rWKVGxY7USbu82RTnLFbJbp.Ai9l93IK/4Gw.lETit6", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$7UGqH1PUpvOI7nQA53BmYkjX5RSYQVNPIQWEeB9jZ62", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$ZOUU/ePkCUS74VyH0vq5/6UPuNJv11VQqZO.rHVbpX3", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$5$saltstring", "$5$saltstring$RfVPT2pZPJYjGTYVZi/FeHo5RcOJY4KIQpYgP.ssvJ7", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$5$short", "$5$short$1UWCOs5nAZ7BLTyMjP8yrK.P0bVWMBC6ugzP5f7mG72", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$wKWBAS7VQIIVDySNOA30cOS/oRfOdgXW/xxu4UYmeKC", "\xc3\xa9tude" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$8WIwuXDCLeGI8HEInbZvlH4sPyPF1ZKM.uGs/qT/2x4", "\xc3\xa9tude" },
  { "$5$saltstring", "$5$saltstring$QlnL9RGFsX8B/AGDX0A3uuwAftWodyd.jCzsFuyf8N1", "\xc3\xa9tude" },
  { "$5$short", "$5$short$Zmzn44UVLFYCCOH9DoNjQAKNXDazxBSfCVNEnDvCEsD", "\xc3\xa9tude" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$8u/3/vJfg7OvAtim1YYxTxHVSbThl7zHu2Avjlp/Ls8", "C)tude" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$lWZsDXd.2zW8tdjfvxf.hUWailjSN9UMwH28m7LNyED", "C)tude" },
  { "$5$saltstring", "$5$saltstring$90AcLQxle/ahUCdPH65xgZXJW1Z556fGB7FdvUOs3sC", "C)tude" },
  { "$5$short", "$5$short$nNez5uiDjDB4Gm4rASdWdsvMBpu45SW1bUHViMmiDU/", "C)tude" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$3KSP.yY6tJfSfw4Izk4oR8bfhs.TLeN4LsON56liBw0", "Chl\xc3\xb6""e" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$DVxWZCKtQ0y4ybhL..wjjC5yDvaHp6DANjf54g6wy1.", "Chl\xc3\xb6""e" },
  { "$5$saltstring", "$5$saltstring$kfzKVZQMzmV2N.eErPTBpWGknf8uIJagpVtoMGjFHL/", "Chl\xc3\xb6""e" },
  { "$5$short", "$5$short$IJ3QWXGiVakbLkA4QmWIKHjQNhqWWXetg2LWOsO6of7", "Chl\xc3\xb6""e" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$ENTXAnkT3tf9A02K8MppeXYkb.Wvwc6D.U3Mbj56Ws.", "ChlC6e" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$xtzj0nJxBWQay9PBMrqNEcsZmTx/q13uTg7ZlBySCA1", "ChlC6e" },
  { "$5$saltstring", "$5$saltstring$FGSbqU0MFB.hSy9FfWp.2Ft1O1w6a5b2PgwM0QQ0kEA", "ChlC6e" },
  { "$5$short", "$5$short$nalt3ZVS7TfvwLcOAfVT6KLmeNe4n3o1epkOKgqtu49", "ChlC6e" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$LQoifXWEJ1vdCy16M9hsraudwVrh3kkcqDW.h8th8WD", "\xc3\x85ngstr\xc3\xb6m" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$AQFgaOQ6XsvQFZbdsKsrTL9io1H9dWn6NFaxb27Fwd5", "\xc3\x85ngstr\xc3\xb6m" },
  { "$5$saltstring", "$5$saltstring$AM9UjjyFdF4stfb22a/m7hvu6os1zF5HdE8.PwbxSi3", "\xc3\x85ngstr\xc3\xb6m" },
  { "$5$short", "$5$short$Bsco/qeAtPyahH0oq7.p2uwGUVUYwtMNGDaB9.zVkm/", "\xc3\x85ngstr\xc3\xb6m" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$ce4ju/M5FuwmUqv/hnPmII.9rAcKPXBT/eDKKCX95/6", "C\x05ngstrC6m" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$o5Y/HQCpLoX9NF8vdqic6qMGzaDfElSYs97Kca.EzV7", "C\x05ngstrC6m" },
  { "$5$saltstring", "$5$saltstring$VdoZfDfjYAVHqhzEXWJAMNWkEMhHI2gHV6juIqLZxf6", "C\x05ngstrC6m" },
  { "$5$short", "$5$short$WPthUBvSN3f/R3f6Y4uiXdpdc01sJ47Zx5H5nEdPGA0", "C\x05ngstrC6m" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$TBxDXOY54FP0scTIaoMs/Wz9uH9YZIZs5yp5HupgIj5", "C\x05ngstrCU*U***U*" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$Lkrj/zzbbDuRWHzm2yIjooZt4Fp.DwXttqvFClJz.d2", "C\x05ngstrCU*U***U*" },
  { "$5$saltstring", "$5$saltstring$kd6OS3hef1oXOVcT6i2S78Qr/gH3xPuNUsmVMwA6aT9", "C\x05ngstrCU*U***U*" },
  { "$5$short", "$5$short$tMuBqTyn9wk./frLwensjuJ4ufC/fK3FaSgUUQNQ8t7", "C\x05ngstrCU*U***U*" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$sNW6r1bvoUOElxOBXMF3exrNUcspyJoxoBzHXu6fjo9", "U*U***U*ignored" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$deat4nWC5dVTiaTK97lYYbglk83A3TigoXymtxCJs69", "U*U***U*ignored" },
  { "$5$saltstring", "$5$saltstring$wRpT8u2CoXrRr/C6BeIE0X0J1xOs4JMn9YFrgJMN47C", "U*U***U*ignored" },
  { "$5$short", "$5$short$Q/t/KhCAoNOUJDD9q25n7VwpSR0t9ywCAd2o.p3UeI5", "U*U***U*ignored" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$XOkLSld2i0Gvh.lIuoMlLtDW5wHTzgwBRL/OvVPNYJB", "U*U*U*U*" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$8Rg3qoDqd5FApi.NBu7bry88Rf.GM4TBVL3QYemoop1", "U*U*U*U*" },
  { "$5$saltstring", "$5$saltstring$fIwP.J5WacDL8/2681VIKTI5zY0fE7sRL1TqtKBHGZ1", "U*U*U*U*" },
  { "$5$short", "$5$short$LVu3ZxISQAbAZjmNU/xaigpFRT4whgI4Phb4p1OyDbA", "U*U*U*U*" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$jr8gCV/sfT1vDnLCHqOiY7VS7RGINZ0VENBsDI64EA0", "U*U*U*U*ignored" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$a.8SBZG0iEeVbmH.k30b.MH1iIObUvEmpaJQWS08YK2", "U*U*U*U*ignored" },
  { "$5$saltstring", "$5$saltstring$fhjC7SOvwvZx1OzMqD1x7c6yNa.95FDuIpvwjWLr/OD", "U*U*U*U*ignored" },
  { "$5$short", "$5$short$M.1lIPdZuX5M2x.uBXOZxl.cRcObSmvaEZ2okOf2sA2", "U*U*U*U*ignored" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$eihjeRQCktwBZPwa9ReRRzT5J4lM30s2Vtbp8n247Q.", "*U*U*U*U" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$MtnExYMFnmeNYD3WVySFe9c4w1QrGCWIhCjIw.DiREC", "*U*U*U*U" },
  { "$5$saltstring", "$5$saltstring$6dDpFuPXWJYZpIFWH5cQVtdl19gu7CPQvNq2fQN53KB", "*U*U*U*U" },
  { "$5$short", "$5$short$TexhQP8iFMHgxQEHQGkWXXCjsyLWFtgj2FSpZlJDzs.", "*U*U*U*U" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$THaCwy.hKVG0PqaVSwtbLt1Z21bDBxlHsz8XZx1SCw9", "*U*U*U*U*" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$91nEtbnbm7eCjSeyXHKgOHhd73W8AYomC4NjxFlP8E7", "*U*U*U*U*" },
  { "$5$saltstring", "$5$saltstring$66MMFyc7gSnLUy3Q/vAQfk/nC3aO431Pm6mQI16NVu7", "*U*U*U*U*" },
  { "$5$short", "$5$short$cXex/yuGjoAWWUQFmLmriov8YT8yiALFuThaOxJ1Y/.", "*U*U*U*U*" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$1XjmdUftmdl0vxeQQV.BzzA7dTCyH.hjgE7bYT1Nqb9", "*U*U*U*U*U*U*U*U" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$jOD6VK5qHLXWgOqeGtYHpTlyRdsd6OSH.Gz/kxl1Kn.", "*U*U*U*U*U*U*U*U" },
  { "$5$saltstring", "$5$saltstring$kC5Rv/TpesQjXdphc9nv5emEeIL8/j3SbMzCTx9gm3D", "*U*U*U*U*U*U*U*U" },
  { "$5$short", "$5$short$K3t1UPv6fXpnZ//jsFWFmhSFQ.IBVSQNbv97YLPFYV.", "*U*U*U*U*U*U*U*U" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$bXHL/qe1Ly3kbMYLUQHw0k1rYHGliLylw48Q50JZAN8", "*U*U*U*U*U*U*U*U*" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$B1HmaHw/EszlsG1mG6BOrN7ZMgzpPcedUBLrBGZ2Rk1", "*U*U*U*U*U*U*U*U*" },
  { "$5$saltstring", "$5$saltstring$ON9CgScsA1TVdyqC1NDNmVpR73B58eBuoGMw5uGgP6.", "*U*U*U*U*U*U*U*U*" },
  { "$5$short", "$5$short$uFpf9oo7x4sVYvGtZIPNEELVgtEw3uQA9kcvVUoR1B9", "*U*U*U*U*U*U*U*U*" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$l4GVwOvfBc0YxX8hqcNZBRM/1y9MRmvftllmUeoWNED", "\xa3" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$q.qMjvTXJCFiKWVCcMv8Tb40cSOwPcCd0YXinbU8VHA", "\xa3" },
  { "$5$saltstring", "$5$saltstring$O3BXeHQH5EJ57Wn6wQ5g3.V5zAb49Hf6TkK4YgfHzI/", "\xa3" },
  { "$5$short", "$5$short$eHufM64jvUn/SJ40GkV9C5K/MQgpt0TloNiPStW/m30", "\xa3" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$qajej7MTwAu9Pz1xQKeOJs6Hp1PityMI1SoCDBVJl5D", "\xa3""a" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$Z/jfDC7CTp5zp9C4Y7TjWcCmHTgyGWlQOkSx9jUywt8", "\xa3""a" },
  { "$5$saltstring", "$5$saltstring$.7kFVTI1wLmMXri1d8m7p72ZUifTFIBmLr38ZXBFmO4", "\xa3""a" },
  { "$5$short", "$5$short$jiEo6p0ZAkvG5QyYSk113ZRlQK/nDOkiNJh.xHRQsBD", "\xa3""a" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$nj/lBlTLTVe0hliQV8FSOnDzTYqvrRkwpCFusBdhZGB", "\xd1\x91" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$zL20/QtiyvdXyPBjwH2qa.fPRoCdoWa9ehTExsKyw6A", "\xd1\x91" },
  { "$5$saltstring", "$5$saltstring$d5dyionoZTFvY55JzosR4cuQJrqr6gT.Fb8EzDOINM7", "\xd1\x91" },
  { "$5$short", "$5$short$KK8Ikc6poCc3DXiZsjZTMWMHKPLnXNtKTK7aut24trC", "\xd1\x91" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$gWBaipSsSFWdKiTrX7.xZMK/rPboX9NJMnqGqb0CBsB", "\xa3""ab" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$QE4iyV1U2sjE8msEYBm/lmb8AqHvCgOutWoQ1HILWDB", "\xa3""ab" },
  { "$5$saltstring", "$5$saltstring$/km3mqS/G/x.MFh9KBR0NdlZEmBUISwz3m00o/QagJ6", "\xa3""ab" },
  { "$5$short", "$5$short$N0EclrS/e7b5cWD2u/WxVad3cQuSS1zmNKUUwN8jzs3", "\xa3""ab" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$TxRgTZCS8J4zgmjAOdsOsfx7RWenn8RkmHwwrsJNS4.", "\xff\xff\xa3" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$WsmbkHWyCQTNyQ3ZwtbHUs9HrPSUfyeiUtmq./SXFx1", "\xff\xff\xa3" },
  { "$5$saltstring", "$5$saltstring$.COnhsezFfwrVQbP8p00YcYbWxXnsoqC3lwyC3c2425", "\xff\xff\xa3" },
  { "$5$short", "$5$short$CPPwRKR/a12gBJH4NP5ojHnsjdJra3EeDpJoGjUwjb1", "\xff\xff\xa3" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$Xg3ubVsdlDkuqgMEGWfaD53Mca.H7xf.gniv.F/.dG8", "1\xa3""345" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$JdnpVe6R6Gau6ROrAyZK00bWaw9t3qaw4lbgXnnbtSC", "1\xa3""345" },
  { "$5$saltstring", "$5$saltstring$de3T6BCjxf1FUQfONzVilPJmezOGs.KOjC9THVRQVa1", "1\xa3""345" },
  { "$5$short", "$5$short$GguGYaEbgyLXPsKjrN/qyMHf9k/CiduGgQZIN5HtdO5", "1\xa3""345" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$dM.wMqEAvHsNsWLEXpebQ5mSzDeeZG6fSy6zpuU0dg9", "\xff\xa3""345" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$kcJnRFGKlJJLwf01rz15C0hz5wHL3PkLumn7LhlzGfB", "\xff\xa3""345" },
  { "$5$saltstring", "$5$saltstring$u7vqjaBFDu7JSukIL7tG/1CzytHYH.6qpRUBPR.hm65", "\xff\xa3""345" },
  { "$5$short", "$5$short$jKhDCbrxTPXa1Bn.H5RdYzfHI5qhRxsPUu4IXU6.PyD", "\xff\xa3""345" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$EJ1c2KQFGjxtzhqtQRtdz48JBwFIoJx8k1ZT9Jiq4d9", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$Ek8LCijiYDniJm44bu4A3i7D37rjL5LEk7sl.WIq233", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$5$saltstring", "$5$saltstring$HNIq3RAe0MXrkVr6dakN8SpMQ6859tmOcJCPQMtpcc.", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$5$short", "$5$short$EOqEdDik53VTIfabvtwTyfaifyoyLbaT1owJYjUn7Z/", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$kVNqYJivzIrebWWXn1U4VKlJEntiSvIafG5s029ih67", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$HH3SkCMnBeaxMz.uLK.UFM3dwkr8vfXIMoTWjig7c76", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$5$saltstring", "$5$saltstring$mVZkZPFUSzI9v2BYGPtD5Gzn1bfEopyddGJDNQhdmjB", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$5$short", "$5$short$tgJKveuOwdyG6XoB3yJWh2SAE9ntY2sB58sKWM5/BW0", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$qVGirGMoWjB/Z69NmPiB2B.NS4d.1FoPCiWBzSsc.5C", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$kGy03Xexm3wbL94grcrrUd1k4nrR7.YPaGp1d3nvvr5", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$5$saltstring", "$5$saltstring$ov.Jy9WwaTW/oqxi/qKFeVWCaL2W4MWTq/wVOAYtU5.", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$5$short", "$5$short$opy6rbPVTArhWn97HXMMGbCYxXPkuaZizwAX.XJX/FD", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$VkKzdlE1JejMEL.Y5D5P1gi/Yq6gdBk95RMvZ5oisO/", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$I6fwZKRLdSRR8qWPO/fskouT4jW0h.v2fPopUTcCUm2", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$5$saltstring", "$5$saltstring$YO0oZW5LlmwquY0etazzwJViUBZbrWWuLTxOu1lYhA1", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$5$short", "$5$short$B3AT6NTe5GRCvTJo2P7sIlsVvAp8KLG.E.FL9zfJQG6", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$gUqg0.W5wjf/MkQObzLELsDM4zxAF7UJuFoL4sh2E9.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$aDe9qvKknPyjgyGHdlnLJZ5ICIan05/rNBXpQiaj2KD", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$5$saltstring", "$5$saltstring$jH3BNoiawVVVzC50m9189voB49kAVIds.n7fr8YBZ/9", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$5$short", "$5$short$jN0iwClI0xZHvLgpnY4.kd0H5Vu8d3p8wmz7ypctQ85", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$la2vBFM8h.w/6nvBM.stp/36ijTb1/3qBnmkHq3srr1", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$QE/atedPCMXYCO.Ra8H6v6..wAH2eg9kLxXsFQm8Qy.", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$5$saltstring", "$5$saltstring$AgiMWBAjafvFIH7a3dwM58GXLAc7CG9.WLTA6YLalo7", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$5$short", "$5$short$wdEGKqXt8nNUdFyyT8AhuLzeu0n7MNKPJoNgrXoQHxB", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$Wp7l1F/gGZjObvP4RcNT5i6UZAnH3ZyDrnHw4zf3WI6", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$s8MvOmxC5urOSwkKxaUtcVaVwUbvQ02KXBloLkkwtd/", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$5$saltstring", "$5$saltstring$oJTRi6ifiWjXOdSTxz6vidhK2Ravi8s8kdzNm5c69L7", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$5$short", "$5$short$lN2P/ch0DxoXiTqcTCkbech4t9JDfTivpq2skcDgXu6", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$KoR2vxitaHbPBeo4pull1WXi9wQmHN/z3GuPwnetZZ1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$Ynx75xSyBUrsFP752fb6gGNv.TWLOZgJ1CbbLelLsi9", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$5$saltstring", "$5$saltstring$nINTWgP1LMRNXqxDr7KCC8bNRFfbZqL09gUh28Qx/0/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$5$short", "$5$short$XgYzO6f8kndNameCZWS36MOFqlWxWK1BAEWb1Q63q5.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$gVlj16PP14ChP.LQUqOo.OWuzssfLr/u66.h3DUUj46", "THE YEAR" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$n2En3b7G45v27byFLmhXpDPwUySbQpMA6ilTXPhCFdC", "THE YEAR" },
  { "$5$saltstring", "$5$saltstring$Vv1lzv5eAfcSCbebybS3gutlLuJpqQ21yfFWmt4LVHD", "THE YEAR" },
  { "$5$short", "$5$short$7pg0D8TVmTf1UaaLMwVW.s5xL.69HZ8XfyXqeoLUrR9", "THE YEAR" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$XIo2x0NKFm2167FjhnjfFOqORhi.s30sQAqcWVluIc9", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$ZnqtIhKDdnYTNy54c81GAnDf03rJmuM7ctF9GcpE6K/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$5$saltstring", "$5$saltstring$u6o91TJF8rw.CppQUOeBkNFt7swIg78pit4z9Au0HO1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$5$short", "$5$short$XyUWXqKGt5DzxMwYLvv/JDIg1AlIvegbQnOT7QdI8Z7", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$5$rounds=1000$saltstring", "$5$rounds=1000$saltstring$ZApVfssDWyWtqrFAzBpDVefHwmq/7hUn3AHgzeLLneD", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$5$rounds=1000$short", "$5$rounds=1000$short$.O9mO3j2c3e4CJzYrYdqLvMp2lC.2CszbSN/XN/u1w7", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$5$saltstring", "$5$saltstring$pSKQxUa2Hi9KsZs2ZajH5hfUIz1zYNP3fmIhGdJd6JA", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$5$short", "$5$short$CPXKAGURsmbcVF0TVhJw8KiGh7wAG17hUGKIPCGwML2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // sha256crypt

#if INCLUDE_sha512crypt && defined TEST_sha512crypt
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$CF.N.0BYYN72qUcyvvSEsw6BVOF30ljypIAf09OO9srNHWPxyxF8MeuK7MXWjGoVlM.3yAAk/owEEJQEYuWsY1", "" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$Ocl6K/qPAcDqPeFvc9A.3r9CpINjXCDnNaLAGbHGaUfW/VAnUhMnVHLP9fLC0f.gFxi5W6DCYe3HkDMICsYY21", "" },
  { "$6$saltstring", "$6$saltstring$kyGrqt6gmjAdtFLPrflEFifSYLCWWq1pyx95SvqinLDy2UHmj0sTF0MSLMwxPFZc3tu5kQckI8fks0zOPda3n1", "" },
  { "$6$short", "$6$short$9cWqpgO.6JABL0ADkGtfzxbmgs6aMf6bBGPgf/BfywRVTYst7nGb9Xj7Z.LBrpR8cGEdbOXzUd4c8bJUaBrOT0", "" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$z9/OGLq8a1gH78Tr8AOieA72kANE1.AvrdSKbMGFlvl9Xvo/iMuzUr0iwhY0MUGTQ0Ml0axZ8aent6Ku3oE10.", " " },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$uk5nYPVtjONzRCt.AHJ9AQWXnz06P3rAUmeEm/rEhGdkRpwU4paa7eMPJrnEXuQeT1dG3EW5bAnPBoUXGfpre/", " " },
  { "$6$saltstring", "$6$saltstring$EJ4I95ilqN/xS610X0E4NakP7nU0ch3o0WjeZfC.dyLIX8Epyw8tRFBHQCeCsWAQ.7EA0RL/OkSnZ98spMVQY1", " " },
  { "$6$short", "$6$short$cTaRWuqZPPUFmBogM4J5BssQiHsva4xbFVw4Ffz1qc4iXoM1KSlzREiXelBhIhuUDQDeWwezbvZSQPY7yeVEM1", " " },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$RrPGXWEiJKglBQ7c4Z7ubMQSfj96YZui3FKtC93SVTqGfF2ex1C1SYjoBtBB4ba3rt/BD7RfAsnl9LRml0K1.0", "a" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$fLMyq4ATZ565WMG8sNs7yVQoJ6kiQXR.mIdj7DncgVb3BfDZJfIpHJwv9pmj1.X6mXDa4kw3sDEXp.TMrHCSB.", "a" },
  { "$6$saltstring", "$6$saltstring$MO53nAXQUKXVLlsbiXyPgMsR6q10N7eF7sPvanwdXnEeCj5kE3eYaRvFv0wVW1UZ4SnNTzc1v4OCOq1ASDQZY0", "a" },
  { "$6$short", "$6$short$H.b6NeQvCMQ5GOPvzn5zXXcNUM2w0yE5a8Oal0EJetFKvqFQ6m2H7Mqzyppvg98IIRXVxUXmgh7oCMe8z/7hP0", "a" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$7cb.nX/vTRLhJubZ36w/FqG6Lnc13OhLW0dSlWB9AZACurRv24vCZKJAsx7DRMg0OXEnzf8lHxS1bytPWFHSc0", "ab" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$0GyoN.SITegKx6YKFiQB32lwP2DZ0gUycrUqGAQ083JAP1P9h.bzJIvZ/YR9e8sK3ipT8fCkV0KymXGkuvmxM1", "ab" },
  { "$6$saltstring", "$6$saltstring$q.eQ9PCFPe/tOHJPT7lQwnVQ9znjTT89hsg1NWHCRCAMsbtpBLbg1FLq7xo1BaCM0y/z46pXv4CGESVWQlOk30", "ab" },
  { "$6$short", "$6$short$h6ONWxgu/DxeSf9K3s9xBLakt6oSmK/AowUBPfsxO0aEdKuCHe9ftyi7TFpM.IaA2LQXbflWOsUErieB4Rpap0", "ab" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$6NXfJcHAqOszRoqrAsiHaMLcALd/df4qk51Md4dEGLXrloQi6cyqUbtHDwWpZDzImbFkZCx2eWVTYIGoe1dJi1", "abc" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$CRJLGVN4TQNTWduw0Yp7yEH6wT79OmBVoFSEQ8G3ukm9Nus7PUrAjbIGCkEY3PNsosPBjiteaQQfiMADjrvsL/", "abc" },
  { "$6$saltstring", "$6$saltstring$pClZZISU0lxEwKr1z81EuJdiMLwWncjShXap25hiDGVMnCvlF5zS3ysvBdVRZqPDCdSTj06rwjrLX3bOS1Cak/", "abc" },
  { "$6$short", "$6$short$Ryq3E6X1uflaH/sejgCmd0x1.7auBVIFWrOIV7TOdgr3jpkhRAKUqgcDaTH9Cz0yspS0dOsLZNr541gtVWIyS.", "abc" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$6supY5aNDQVvBGYV4FvM00TPOhNTmySH0kzOVRhxfSAv/0e.9HhbrE/nCxhRiNLaSzDBasxYQX.YrmLmIoQB0/", "U*U" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$3uc/HTmhqDdzlkTyQ7JJpMRRfj9d21NxgfS3elz.63bUcqov/Gz.mOrrtW2PJDn/TBTrwJo3XYl7W79wB6Cez0", "U*U" },
  { "$6$saltstring", "$6$saltstring$hitX40AsX91LfrgfyWiA7hqXb.iu7KxcYOMpo2DsJPdpzpQkHPzdjo.YBVr9cxVFSBHMa8eKgPyXSLuNyUPZo1", "U*U" },
  { "$6$short", "$6$short$/fj4QrdCNavMCL3fjX/5lb003LqpEVS3VTrdXpFUJeFIJJLfq6nu/3Ol46kjwYSpmQtPgMZ88wrFU9Zz58gli0", "U*U" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$QpJyPX8a8xQvTV45BsjKAKz3hRvOjUE6jR/gygc9E2KWdhuqDTzE3UG9iBJCBbentFQTprqgfuot/yb0/wioB/", "U*U*" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$f3iK5AFf4ZmvHDzwEcQe51hxUemi8UN4GGujN1D.XqlX4PGugGYX.jYo0T7OBqRS0tDM0DJneUrtODYwlGg7M.", "U*U*" },
  { "$6$saltstring", "$6$saltstring$LxcShRvMQCHA.zcsI/DA.BiDJuO.NakGsSUgyP3/.CmD1BefgmltDFyv7zhEQfre1pXojfJdtFr43Pnjz8HuS1", "U*U*" },
  { "$6$short", "$6$short$UxD/GBDw5uZSpQaaGTrdaf2GgAEtQ0F8E4.R2Vqsch5SekTY9dwANzKMuw1E/gtYXQVWBwI9EirBE1QErDD5t1", "U*U*" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$aPnsG1a6Q11OEUgdEvb2K/M5tleKAo3UUwOtARzgau3zVpJ3SMm.2Tls1WawZ8CcCstgs0iL8BE5mmeVnDTyn.", "U*U*U" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$a..ep.5S4SEVwWuMm2t9fyjLSoeE..lCfuHxqeZeMqA2G7WjU3OK0/rNW5TWDYP3dfdx.oaBieR6wdrG/3MLh0", "U*U*U" },
  { "$6$saltstring", "$6$saltstring$o.lX/OaU2BzTI4xKucC0wOS/UNGkMMQmo.oR0lK8c02WCKnUDCDwFqIpBVCQIbVQJIQ4Faa9gWyJzey0r8KtF0", "U*U*U" },
  { "$6$short", "$6$short$KRnh4SZI2RoOsf1IhN/Qr79MJrqHv33Qx453HNa2iqS6CNIbsprMjvtalghXE9OCvtHaVQqKIKv6Zh9EjUZiq0", "U*U*U" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$gqEXRsuIypeY0yPmrOsj2wPMOoZLf7NC830BMfX0dPXyWAgXeuHX9Gv.grXCSr.ZTZ7mzGHTb65vt87soTv1b0", "....." },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$ZKrjx7t0VMhA8dnBQpZ/yCVeS9gdrITs8gHsoxWFhnaGDHXQNe9G5WYH2CQAleFZ9B4t5iBCKBa0Y5pRkL6z..", "....." },
  { "$6$saltstring", "$6$saltstring$BMjmQjIKt4.nbFKlanQwIjgOR5Jxa/VPrMinnNV9DYJO3jRFy11KBuAgOU3lFdZ7jgT7ZIfrI2rqgAvRng1UV.", "....." },
  { "$6$short", "$6$short$tQMoNHI/Vly3tDFTKIx2A4z4ay2FGWtVhlGZ98g2VzWa03BOsx3rEhwUUNut8dUYmCGB3saNsJn6Mq3LowfQV.", "....." },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$En8o/oyzgbyw63JdjWu.Aes3bingJfWRZaiwbYK./iuQnklEsPznYePOdzOSzYo6Tisz7duXW2ipkjAhIke2g/", "dragon" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$yvmbqXI2qt9bZWSsZ.WflX6oSrjs5o9EULyuVyxjKq7KIS6bde51ObcKDxLCOIlUF10rJgrI74dk3gnxqQT7T1", "dragon" },
  { "$6$saltstring", "$6$saltstring$T5Pvevzodw2yOMrxNC1VW2A2CkVUovvfCgmix9t.oPmrAFwOaX1dIyDo3AWgEXnKKludzNtDirvW9vxQhmomC0", "dragon" },
  { "$6$short", "$6$short$kxo6QdZ2eitvmQSaTxHbeE/s8hH7JtPlafO/igRODmgEU85OgRksEFgthUebJuKayTde6Q1GI5VKjrmELYn6X/", "dragon" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$yrI7xfcE05dakMP491u1JNRQyoZuRHmKDSYewYOSa688xW0157Q0dDq8FYtaQ4hSzrl9EbvtzqyQ/3ALHZmlp/", "dRaGoN" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$uQsO0zO3H/apaYVK1XT.CZgXvzfrzjD8HtEZ048AhaBqihzVoRbmlR39SVOHnxskhqBYyZHbc9dORNMMFFjuG/", "dRaGoN" },
  { "$6$saltstring", "$6$saltstring$gQPpfX77fpxMZCcOVWuxxuJ86S0tFGSJIkg.HPg3KHXDQm91bgQ0hl.71kPHPhNakphdI54bCzM8L66OEOgDt.", "dRaGoN" },
  { "$6$short", "$6$short$3bZaOHFVYyk6mP59idwIFAh5NwQ4YQo2Tnguxf6mwyrhjal/EIGTA4d0aRvJXa1yNsaTwQZnQj.FK5LiGycYl0", "dRaGoN" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$tfUZMKR82Xdxy7rP9MSw/r8FHGM/4reAAt96iM9EU5sl6WlXUVqQg/4zxJu.6gUWIyxUSk6469.crqhZuNaYK.", "DrAgOn" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$kq4PJSdy8JZtArEHelqkv1ue.vZOPwWsntDsZ50Xc1O0JeIGGxZHfXEnVdZfPu.uAtOKrOp21HxrLE5k9SZwZ1", "DrAgOn" },
  { "$6$saltstring", "$6$saltstring$woi7zhTQTPiwhwfVPwtZbJUCX4fFU/LVWsB7F1X2.rLSpb19pJxi5hd77H7xFqcin1/y6mpRb4s1ca2idmtrB1", "DrAgOn" },
  { "$6$short", "$6$short$piblfONXxsf4SeUM.wPXKgIyehV1rXTuewSVFTDtaE/XmRbCmR.v2wwDEUFbzQuxhWsUgERSBCHNLIZXH.SLQ1", "DrAgOn" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$aHF6yPAGj5786f.6c6Vpl82sxE8KbJ8dkm3L8dYbAv1WsxlHz8RBIKbkgkcYWy0A3fbP7QrY5bvBD0zq1F9oV1", "PAROLX" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$AKP45r11vC6X.wtvc31AthJDoj20oddoJurs604Ad/10/Ya99OhQRg7Sk0v1Yv2T0L072Htq1wUN2Htkieede.", "PAROLX" },
  { "$6$saltstring", "$6$saltstring$YRWRCWdqhjbClmDQbolZP4zqGT8gDIhSXNzc0Pv0od455wb8PBgTMHF5VUUAzZ6bi5ksJrj/wSKw/jcOwhJiB.", "PAROLX" },
  { "$6$short", "$6$short$NDdVSOD2Ofd/BBRPxStg1aV05uiAgqbnbmKilz7PHnFv2McaeYKy97JGecnvfFT9voKa48GljriViITsVmPHF1", "PAROLX" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$MejmM.FdVO4uPJY/2lmIw8PsF6XsXqNePvqDxg9oHSBQq7R.HVm.kizyaXRKHC4pqqUcE2x/DKSFJNSuUiZyt0", "U*U***U" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$lWUCaM7m4FveO2wVFaK2uPu/0P/YFQcUQ3QgvSsyCnKbxtO2krsS21qW34yRBvH5gRa6E4GvvuOcPcZjeg0Mu/", "U*U***U" },
  { "$6$saltstring", "$6$saltstring$xScdaJUfK9ogPrG3Pr7QPrdwWVTBELr/G6ejjsWl63EmyvrKqfJI8S8alziVwLb/7brxLXdULlBKBkZVMj2uu1", "U*U***U" },
  { "$6$short", "$6$short$PSXUZOFMY66rAh3BSrBU6aFSLE0vKnUagLBMBeg0cGn94qP4CakAi/nJpS3X95HOzyXAu40smIKHaU1DPAzUy0", "U*U***U" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$v6ewfGx3LKwaU6ErzCjUrTPki8Ce1oTrUyjLZfCB6TNk5TB0.BRn3K1Upyi.ayspVIUaVsuWy9jiwHfgO3//v1", "abcdefg" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$CVjnpPl4DwiXa1dTuc4bCPS/6G6hzBCuTmcneiqtUVIfexvukN6cWorGEazFACKCY/JtYpl2Y80rqJKtJ6noi.", "abcdefg" },
  { "$6$saltstring", "$6$saltstring$YBQ5J5EMRuC6k7B2GTsNaXx8u/957XMB.slQmY/lOjKd1zTIQF.ulLmy8O0VnJJ3cV.1pjP.KCgEjjMpz4pnS1", "abcdefg" },
  { "$6$short", "$6$short$mAM7laJRaAgxZkAbi8JvV76sZ/oESqgfILMv6ipn3VWpdGItIw0kIKgeb6yiaLTOKFs0Tx3Aat3uD6jb/kyVh0", "abcdefg" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$yxI4nqKMGR1L1ExV9qklDjFG6E4NKcSlKb3rq97/M0xHyr90dP9z1LSBkkUQVsCMBHKcFiEwIuBcYC5LJ.c7m.", "01234567" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$uxm7LbFP/sgIsZgJG5sCGOBoYRbhqrgM6sbb82/ONghu/EfcaW037Il.BR4nq9l3IzQFAVp.ykCqkc7fOn8QT1", "01234567" },
  { "$6$saltstring", "$6$saltstring$IUhZcWIrPwMl63Oj7MX4VmgPWKlqfnoHFDqCOWKKcHO8c4CEHFwEpEI0CirU4tYz30IqR3eeWkYP9YhMQHmfK1", "01234567" },
  { "$6$short", "$6$short$wq4c0Xo0CC6WnT5H9RJvP/PQZVxD/X5Mx94QUAhzNnLarEnn7Q9WvS7tjjvv6jQVoAsARytK86UntkddTmRaE1", "01234567" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$/2.GiP6ZBy3kXzOKHn7uzID4w87vIJJ7g0MPeI08R1BjyawVjbQKbDaR2Plp8n1gMCsTs2.8Yq7tuGfnDqTrf.", "726 even" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$JWUognoEgDLOYnkw7PX0H6Vs2ppz2/gFTHaASLvtob7kty82QkHLetXma5Od5FXf7m6Xpee9PdFDYau12pAX80", "726 even" },
  { "$6$saltstring", "$6$saltstring$PDwX1LTmFznmuJJK5s18YVjBQx2auusk/d3QGvbziQIcHR5SynNEhnvSCTaLD.cNcHlgu9BwNtFzukKPEWSRN1", "726 even" },
  { "$6$short", "$6$short$x2Jou.v7wjBpHDIw979qDh7Rj8TAOhQ/YlJ6/axxWFbwt/xn3NRHdrdGAjvboyPsPHx75FDXZyTa3ZIqlrM160", "726 even" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$7w5i/bK5wBtam9q/c75Rc6FxMaIQGieE8Sxr93Vby82Rp7qJaX8OJzAKBZlgnBAQJuvrwGV0CUbZYV8B.vZGv.", "zyxwvuts" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$1PFgbHD2gubtqao.DYRmi/pEKQgUp9/VeqYiVwlnoXqilGi4ANIhaLYN8mrAVuhPu0wcVk7Z1rW9Sdf7Js6rt1", "zyxwvuts" },
  { "$6$saltstring", "$6$saltstring$/xSotNhtJDqi7ac9fWq7ezQhiHD79VAY4LId2M6z5Eb.UwKHQUMsx5/RKNE8l8ejxBitkeqAAI8yjK.LQvCs7/", "zyxwvuts" },
  { "$6$short", "$6$short$4OZ6AWaxNsOK8MNOXBdFxTmaXDCwhhbaVFEzIjx1ruJ/2VQzlZe92r3LJnxI8Bq0DWnrD4yKxty64hAtCZdH.0", "zyxwvuts" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$6aqMDQntWWumaowUdKVT.7qAISv4eTdk57XhdJQ80wrtjxhmbv/NwdZVatFHpOKQq3/a0OAIfB7.9Z1ezcE261", "ab1234567" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$fW9xxf0lJlojZN8RoX6m6QPY.lmR9hRNFN1JGq9SAj56KDcd2tYC5wBfCYyExX60QvgBO0iXEExD2PgaUoy5G1", "ab1234567" },
  { "$6$saltstring", "$6$saltstring$88RiumddDjzoI7aZxYoraZfohCDi.diPRtEeU/W8FYpChHMzY3KHcobtvfS.j4vWk.upu2eXxLHJpcTB3iCnM0", "ab1234567" },
  { "$6$short", "$6$short$kEJ49Mx7ct.fMjF.JQeoawGdrD6hScqA2M58qu9u5d/sFHtFmAkaYEWH7N52qYzjsPdRP6QxllPIGzqr5ceDg1", "ab1234567" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$9ap3pOL.0hemQKfgMZBN4i.AMMLnk6TTHoaiqqOj/ZwTfpOzr.5O61iOlrtSTl/s.kqMwx9Qq9vqdnMY599Et.", "alexander" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$lwBu6Fuycna18Tv8laX074./jT7L7QJ1OJs1XJo9hHD7sFVI5hByP34PC0Cba2OOs/wUqS94/MWmVwug7nHt30", "alexander" },
  { "$6$saltstring", "$6$saltstring$sJtcsdgzKCHX5dZ8HLUiuFk0l1KSq2YDhWZQ4d5FWBriG1bj2IQXNa/QnGzXUKtZy8s5WrPQqgIhZSjc255AU0", "alexander" },
  { "$6$short", "$6$short$gTHcvDR1MN6WQHAyxm2TzF/T9HjM4FWnxDqsoKia6A12h.l/qVmaWeEkIgZ7lDQcxEztdUCM8mSb3un8niAR3/", "alexander" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$UCHJCtk1hH3Ln/Omk8Do8TIlajueMYZU5XcHyhdBXZQbpdsR2DBK2FdrA1YtNIfX.IHn2wXdb6j3vbBkmPNWU0", "beautiful" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$KkHTzX6kaaTemTaKvJrL6MD4tKCHRjW2uaLOdbf/wt9X2xpr6l0AXSR/fFDGHPZUCYxXMFQxAsMO3mrtb5oPd1", "beautiful" },
  { "$6$saltstring", "$6$saltstring$uGpzSu67SBz3WdBwL2BYMOb4bWHNEnAN6og/NnWbtmPcV45m0nfmRFicGSTqRU8ciUDWBCjPqXEDd..8XFiQk0", "beautiful" },
  { "$6$short", "$6$short$lbKkYMxfOZaU4Bt7IYdn.1s8IXajUzgoUaz6Ao0uNZC4xbP32wz3fUMvulXi0SF/BOsrRXZJ/rvES4ZBiTN3z.", "beautiful" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$6y0WHB3/Ru6zIBLFakwhSaORlUsUjuKAHlfOAQ94PBheyIk785u2gkhPs9CWYKRTXXLVjHIeWWVtevgi3frw./", "challenge" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$b3NVbgqoVE4OPQrxPW1F7Iwd25wqdNAyuqQiYWZ3pqG.adEzvynJ/T2bzSxsTkifOJZcMOgOTsYHfDCBqQsGq1", "challenge" },
  { "$6$saltstring", "$6$saltstring$IoCnLUypAiOc5N6QOr6HH/I9BF8wX7KbT/vUbp8SMnaCjBiWw.yPXVAiFdnX9B0x6tZtEJgHDL68/AJbMqrzo/", "challenge" },
  { "$6$short", "$6$short$5u1J1/nW1jX5GQkKoPBnsj4Mp.PwuO6Ch0rwLJADCxI50GpayA448olHvBR3rfNGlanIJ0BwoO2CP2Pytdh7P/", "challenge" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$.pwes.io0cSb2UF1WZF/28nM2a3Cq9uq.ix8c/ARfapguyysiDQK.QwPqGz3X.vRq4y4c60H2MJ5NuXqAxVlD.", "chocolate" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$9L8I/NANkidvv.gBJT5Xx0Gtx.7Cp2U9Gc7qs5.mmr1G9ETM1B//bwlNLum89Zv64s822ZEhJoLd6v62TRCgt1", "chocolate" },
  { "$6$saltstring", "$6$saltstring$J.dgq9aSPocnaRtuUkXQxhZkIeXIuAp/LMo69Os4iBeiDa.0QfsfPtJ51oZoBI2Kn2sWdWkfjxUNT3BqNFRSg.", "chocolate" },
  { "$6$short", "$6$short$ibsxqRXouBAsURuHVgjRqaT6L4MvmtCkHqnBypM9z8yGXU1XqNlMkYOAQA1fIYmCl3MYdqPf3J0ugleTcl2Iu.", "chocolate" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$x0Uv0V6qleasFEfgYxxLXRss6kWbyVDEqWI7wPq763yA08gtYezHs4EpiJhZ46bwej99czUMN9wnRNq8khSOZ1", "cr1234567" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$vvd8EgisjnZwwHjrPWXBDMzXnnS7rbLkLFmYpPAxK7M05OCC1IWZw2csWpwRVh9uzMtgrsZjvYUVF5DxXzdSf0", "cr1234567" },
  { "$6$saltstring", "$6$saltstring$Tyubx.MJi8OtoEUtF1R8Awuq1/J4jfOkrGF6p.X73jdOL6S.39EtDXtk5XsMmQbM3ku4pE.hRnV66TKF1idH3.", "cr1234567" },
  { "$6$short", "$6$short$phqFUlvea4pxo7MPWaXLoqcof2.vJ.SaDxo3MVDsqb52m/c8BTqVDebxvG9tbSwXo3vE.zA3bPNNKKRaziWsV/", "cr1234567" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$Ph4ACwjluk48VTJzznay6W/5.dRwQ9r5wmNDc.P16j9YDWbW19/7YjzsovnXBXjuGg5iWikVyp0/BQ4uw6iTr/", "katherine" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$PwO9r3LrV6dmtVS4ZxIHgO9PgVd82W3Z9ed8QNSe9rT1fAZ0kcN6dZzUGerS7W2GKm9gLTDZeJ.bqKROrIR5U.", "katherine" },
  { "$6$saltstring", "$6$saltstring$4MCBo5IK..GdkDABFP.8zxqUehcttV3vZNtR/Y5NiuaPXFQLgYv/baBx8XQNo8Zfw8aeRA9AV9FqRvZybeKM7.", "katherine" },
  { "$6$short", "$6$short$61GnSHDjJHFjy8bOWDXu8J8FrnuBziBmva6CVLeJrM563X7iwCAhnHUEBveNivoGSeOShCHwpqBlqnf.t9ZNC/", "katherine" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$UpHQ9KY/Xt4p5yMcUwdLWna/KbwfaWfG1J.RjguQqIKZc/u3R8zw51SXukAwZBxgQq7hsXBG6r4bHNTFaYoCy1", "stephanie" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$tlbidOpGQowQTYOqQCtKuQm0dksBR6/RpuRWiBcm2dkx4t9qk.Zn/GE8hBP2auOLyvkyjDmetQ/WXMGsW6Jpw.", "stephanie" },
  { "$6$saltstring", "$6$saltstring$Im.hMpdh.xjM0kIiiHSZ6adkhQd6G4W09s/yGM.U8tYUlquUDr4w21McH8QYzKkhfj0lX.7w98rjra6h25/3T.", "stephanie" },
  { "$6$short", "$6$short$PAjx/sOyQZ7..D.UnTAoNutYjYbrHVWhnytEsTLIUr8VRA8txwUm/UoFFn.js0uEyZMFGJ1hn.wVHz9o7J2N5.", "stephanie" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$U4mGRilc6Lx2FZ/G1yEqNjVPp7LUMSJYbotCMEOEoaUg7KC.VBtCRJLH/cTSVWpJTAKboZcst.NxmYXTo6DLM0", "sunflower" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$cBh7q85PzwqXZP6emub7VxmiB2stWHreULiaP26avsaKYAN59IAj3irG0b5E/WpCgHZv0X.k7QpeT/4ytRDN7.", "sunflower" },
  { "$6$saltstring", "$6$saltstring$5uD054AYexrdi30JHVI1zE26.fs.1uWfpJqVTAOAFSZprnXXUXPg/Tr63h0gAoylB1ti1rX02.GDA4suHTFS80", "sunflower" },
  { "$6$short", "$6$short$lZhCbm0hqVpgf4nr33LKDsprALikyfHZmxoy/WEs3C9WH823Wl3qJ80mQlqO1MpRoMKrdg7R8I2NSh8q.srP.0", "sunflower" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$dtC8sK2UqfT.i61CEAXj6jfs3jEazvYUwYhQjZbmrbtKeFVwt7J.0/LB6DpajtwDfU4INJpOETIcGLvnXzNq3.", "basketball" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$aDgvcvtehk11aZUyry1fZRQvD4nQ5zAyoeF1HHjS7m3Kvjdmj2DmDLD/YX6n3PWv.lMe6Ib2ifEBphZpESfBF0", "basketball" },
  { "$6$saltstring", "$6$saltstring$aee/dAuD//0IMOybq6gNvLwBpQXOwcpgCE/WXZaKGio4dp5ZLSTMQinbVe8lLIidHTWH5w6jaRMP8qddl9QZC/", "basketball" },
  { "$6$short", "$6$short$WQPt1QcAX2IjzgXlTtbtl6KwHD8TUWIzPKroEJpg7x95SuViBCXaS4fm3VV0afTWGMouJiSTQnU4MOWBOqqj7.", "basketball" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$VRqKChK2r.wKr.1BnDhc/Cxte3Z1dUFJ7tixjF9LtqaTKsP91Ozaks2n7OnZquFW4DxQtPzilGlXOYEHgHWxg/", "porsche911" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$CpiV0i./E6AgJE5m4vDE25G2a3L2EoYlIl2xYNnvSRKrpuCeFrAbL6bwzhcygPi27FKms1378YGS8sbLCalSg0", "porsche911" },
  { "$6$saltstring", "$6$saltstring$EAbT7BVpwfcxScryVnOnvCADXTcGvu45sE40Tg6a6qkr6R5.tT7j776nmY3kcA2UwIvTBg5OgODuhbp7iPRys/", "porsche911" },
  { "$6$short", "$6$short$TjnEiKvhycsHcBAFnf.upiakg.XL0I.K0LiH.wieoZ3idVQ3bEFBA3NJkPdMbVg9NWI.3rmbz8eLnJ4m1AqnX.", "porsche911" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$aAwIBNJYKFZoHjNG/CdEu3xQysYfnY/CF048B.ozt6zbX/1jMNSp/Q7/sTIaxL2ipIpnIK.2KiYX7bgzTE84O1", "|_337T`/p3" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$EswKQIXZn2IOmVDgzLIh.jrebkGyRxJql8VwaJoBBktiVR3XMWU5aZt5RYIaaheJBiH0s5bObz5vJCoAW8eDz.", "|_337T`/p3" },
  { "$6$saltstring", "$6$saltstring$w7lL5LYs4DhqSBgWtyUFL6HBwPBLkeL4DJZwamoFMMa.f4COi0f1nRdL0InNhyc0PVH5YBxaxlSHgCvi7y4dp.", "|_337T`/p3" },
  { "$6$short", "$6$short$.G2W3y65U8Vphkt7S4ZAFc8t8viM18mg11RJidkFDV/jSAbX6K69sQXXnz46nIQn21uBQogL8n8FMxTnEKVaA0", "|_337T`/p3" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$m2uF6VgzV58EObIU7.nZPU0/uToZxNlxBkeuFB3tOPwSO6rorldb7QHPX.MajjIEsdQYwiaJVxgL8sRbNOoi.0", "thunderbird" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$hQ8lU5a0ggbGodMfKgz3CmPUXTdy1KXKKMhqBoXPH9l5MvKGjTralpUjbfinYqNTeRjtkK7ocaOGhk9nlB7fg0", "thunderbird" },
  { "$6$saltstring", "$6$saltstring$1q0FQv0GRSDkxJykeraC40Mq60nuM0waGlZr9S34T5zAzPB3uf4O3O1eOnH7Aqs/m3SLywSNnIvPQGvZCAcVh1", "thunderbird" },
  { "$6$short", "$6$short$r0d2pE58rge4cdUpI57OpzMXVWTp46PsKmXkWDryx0Rpe9owr01xmrD2vw2d.gDns5Ssimaiq135mvEdZSAue1", "thunderbird" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$Zu2Vknok2/f53APfN687ADnzeNBLcsEgTwvcBHMD2./07rZQAt8vsuKVufD15dyZh.LOLB/uZKf6I3GyON4bp/", "Hello world!" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$BM3/GjEUABzKYsQf5Qb5BAuG3hyEj/vNWgdM4jw3CWiBptFRQUVDqFjOd2yMP3RtngUR3G9paxHlcOBgWVNJw.", "Hello world!" },
  { "$6$saltstring", "$6$saltstring$svn8UoSVapNtMuq1ukKS4tPQd8iKwSMHWjl/O817G3uBnIFNjnQJuesI68u4OTLiBFdcbYEdFCoEOfaS35inz1", "Hello world!" },
  { "$6$short", "$6$short$5LDNaXtCEHSCdHwfOGbSZlgt54YFW6U0FaxKkvo/rhpm86r2NwXmd8IEQYNV2IJSS.IH8jaJUBAk3K5xRDBXw.", "Hello world!" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$mUzaGDDVnOsq2tXwboJuEeMSdwHewrviq2hNFSCSVbOrWAkDHza1wpdVg81sUAfc1ki.xuLyu.h.JJmzHGXJa1", "pleaseletmein" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$BugjOC8S3rs0luXd27Rw3SEWUOZ2xSajDQJe/eHFTDd5uEmdTdhFNxgC6tq2UtFto/iSlhZbjdsQr0DngnWx40", "pleaseletmein" },
  { "$6$saltstring", "$6$saltstring$SqyhDWidy1FyYQvxJS0mCfscyB71Ni5Yi9UsukwaGkrvtN5uj8uxcQrCB9XRTz8SWHp08vMi14NTi36I1YPJR.", "pleaseletmein" },
  { "$6$short", "$6$short$rLc6/9Uv/lPa6jahU8mQ2DxUh.2OJlTc4jozt6eXBDRV/RBp1xO8Ak1X9k2s35Awl5eQ/ATaGzXd8JR.620ZJ.", "pleaseletmein" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$KwZ2liGK6UEbPaJVn8S6WkTloL1plmF42hVNDKYHDfig9ew3zJEvJpwwl.vLWhHYwl5raidHjVu2BRCbSvKcd1", "a short string" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$MP4AEo0Y/aosRmucAAG2icn2J4ts6SwQMTGzIwvZTIe33UyicdmYJ7wmWnVmoa1QnhWt/TTbvatI/ksJuZz/S1", "a short string" },
  { "$6$saltstring", "$6$saltstring$bVgvaXKNXtgwFOF2fBEKsb8Uz9HK/5FuGOwE8bDnB2o72JsLi/2k8iws8LwuIKiqLQNqeqPR9fx2p6yedvsPT1", "a short string" },
  { "$6$short", "$6$short$l5pisUgX7mbr2YP0LfYbOFex0.SfKFfhUlSn0A8YZmnOlgSYQOrXvl.et4tW3Msf7a08XXGUsH2MSa5lCseeq/", "a short string" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$bMEvnXyS4ECr2wz7BCB3phA5lQYcNizxQCgBrpDfXYE3QW5kDsrAs.9g8mh92ntU8hpocIEBhchNH5VeQlHLE0", "zxyDPWgydbQjgq" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$5jtfYwHPnFRZJtwnAFICLibEVYe9mnMHuP0xfwwLUqTAyU7.1kcdMjD/1.s6cvX2wwgIxDS.g/pY5nixNx3ZP1", "zxyDPWgydbQjgq" },
  { "$6$saltstring", "$6$saltstring$WyvtwGlIs3KUKJJN6mU1g1yaCAj.t83bgk6FLnzAfhsv7GQ8TQnOOgs.4yLrafnMjVWHPZXPR1GGxBgaBnZVy.", "zxyDPWgydbQjgq" },
  { "$6$short", "$6$short$Iqh9FX6VY2sLmIeZcOSXUJdtKLbJ12kXVcmoZr0WTtUqWkf95RXnsSPt2vY690sOzRzNq4V3YcbhigvoXmRXu1", "zxyDPWgydbQjgq" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$x23XHQPBtvv99XqYi8OXbEIxUcn1jpMjxxEc/hemGHLlY44h9rDbhb32ZKR25OfHaUdIYapiJvQLjhp9fCOUK/", "photojournalism" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$nOAsxg1xCvVTa0xjUCU6wHgyZJQuoYpXhdAIltaNDpbssuHx8L6OZJrWvdhkw4RXFgzxU45ZK6Ovki75BfTmL.", "photojournalism" },
  { "$6$saltstring", "$6$saltstring$cYSRI2.umeOf1Zloyp78Q0MSog5BRdANlXosmd.wviDS0Ur0wKDker3BUMbndd0X0yz85gIPufTc4NYZLbCGw0", "photojournalism" },
  { "$6$short", "$6$short$9N3DUaaEiOgaJ53JP6Ke7FhjGFtYQXylz2IjRta79gNeGVmKVSinYkvcAi5G6UoTknaUQXZPr/oTRB8IFUINu1", "photojournalism" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$hWNWX0lo44REPtRwK1ebR4yLUqLI7whuGXxCig2XFSZ4acGoAYrmPP6nbqSyHfVmK8rjnIArMj3mo6bTNmZax1", "ecclesiastically" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$kLhJNxw7JEQ5O9zZcCj2E6Nfv1v8aLIg7hKRye5wWHRNvrJqIQS3OHb9dryJK.dwWtp2AAzRtLBUzJFaGhmAK.", "ecclesiastically" },
  { "$6$saltstring", "$6$saltstring$r.476M.nEFbUeZSLRrQeENHijN.0L7SNYFMWxVMHvpLJMy9Q1HkkHu/IAKtqVntMqB73tx4fW1UVcjKEQ.AZQ0", "ecclesiastically" },
  { "$6$short", "$6$short$wVusyt8KnWVJo.K5S47jAIc4qNIqMDPdEm2pOutL.EarRI3XRTgHyIhKqh4DNX.z/DfJgXiWz7euiuMJqcYOw.", "ecclesiastically" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$mKQRVaf.sD1V3/T3o7wxGDxjNdle.W5y8YVW4mjAk9PKiU0kg2X5lJ7yIAMuHEc9bfGagdG8AHAysXvsfgT6r0", "congregationalism" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$80.eMXqsJoDW0tAPpzWix8bzvt43eAHApsrjN/lpCRznM.zX1Qlk53OU7SOO7ZI4988d7WxmccjjqDk4mrYQM1", "congregationalism" },
  { "$6$saltstring", "$6$saltstring$FBZkpnfkH4QKrMQON3/w9za6gBJk5Eqwg10Z6EdGzqR.Mcfkc.gdogU/WGXdJrfYh2GVliXBi3hCd4UT3kTI9/", "congregationalism" },
  { "$6$short", "$6$short$zyf701bC7P13xL/0KNgubXYvfQVte0BUXH0g1oK3VpGHYXzBR0BxvUUKo0ja4kexx3tnEOGOOZvkLE8vJEEGV/", "congregationalism" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$ZjoGdYCsAIeV0fkKa7ASfuVDAfFcpVuJ46IHZ/YMLDXFaQH6n.ak5tdw9.3q14onav3bYnaoCZKhOAqWLEHgB.", "dihydrosphingosine" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$4i8XAB5cnJXTIC7b/uV4DLzgp5n2IitFqD6BVKTDZKD7qCEDNG/0kKLez7YZIkBUeYGyhExo7NEjARVSNW6tI.", "dihydrosphingosine" },
  { "$6$saltstring", "$6$saltstring$yRKwAmrD0cLj08ps.vnxNGSg2b0aJaCtY7PLx5L8GnX3oGICqvrUGQKpDox0xpXQ4hXtd5qcWAeYMFVdEI908.", "dihydrosphingosine" },
  { "$6$short", "$6$short$YAct39Z1emQ6IWH1Qt/Y8PWtcGq93s3KR2M8GnUObQiJxouo4LSSq72AgyG.CccmyGdbgy6jOe.IYucZzvCuE0", "dihydrosphingosine" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$oEk2ySqxtnaPzTYal7O/GgQvICJbU/b7d/Db0b8AG7SgCgctghRuccC3w5s/Ygzu.sFzXZGktVWmh37Nx6wXd/", "semianthropological" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$TLov1E55B.7Tals.d1Su0DZHqzGuV/269ihJCM0iTQHunh.eVL8Pm.uZ0.Z7cjolZp.BwJG10L8KOs92fJHEq/", "semianthropological" },
  { "$6$saltstring", "$6$saltstring$N5HxapGqZn0tb6JD6SafDzmZXRwgLnlqh15JMquXPROFffYTRtU1yDMcvMuxMHbIF3ksh5C1FO9MjSg24l2g21", "semianthropological" },
  { "$6$short", "$6$short$6XFDEI2eitO3w8HpJPlW2nrfMhOjjVsWVz6WCx07PIj49QC2xy7ic9AedmdI3lCG8yLoGmnhh1ncpQqv9DqlT/", "semianthropological" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$t5/Ubu6sYEt7.JNxCEqrkxZIeQ7LMyTlgQH7ps6stEaqCmLmYXO7jObjuAyrzreqBIUCBONhbPYUNLiN8NEQp/", "palaeogeographically" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$EngEfM2GWS7VaQ5YxyEPmXz8ICSVy1UUSVPLZXVHFNp7JU7EgFQFQWAmDQamPWVjaj4WYyHW9hmumfhAtBu1d0", "palaeogeographically" },
  { "$6$saltstring", "$6$saltstring$7JMY9UHRts1MQO4I/uNxn58/OJn/zfWP7MSaMWHQgcPHvQDwf1lYF9I22qpv70qMyOrxx2NOA2hhorXUbH6IG/", "palaeogeographically" },
  { "$6$short", "$6$short$NVEvchm9nQ/krJHdXLP8eJU3ektp7kl5Gw33zGi8lqmjn9q.lw6GttKvLrmp1Am5FVPCOMVgMeWtv5jqTrFkU1", "palaeogeographically" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$W6Lyloew8r1Mxb70JGpKxvZ5LEPX/i0p6ZRxGmMm3WDl31V5RiDPS3XasV3u0pFsJEOETUswoEQKRvBcyNwoo.", "electromyographically" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$1GO5TfgN67af/XxnWIQyiQjIlVJtTa5/EAGPY8rj8fi/dRUwHnrYfK2mIK3cjH.xrVTsGHhc8/N2aVQNdsxwg.", "electromyographically" },
  { "$6$saltstring", "$6$saltstring$lXosHnTI4Q4vxJmEa0nFZfqsrtWbAeRRR68j.U1aqTKpYevn5o7dpqIVp1A1tW8T5h4KTLD/VeoZFk3IvN/6q/", "electromyographically" },
  { "$6$short", "$6$short$KmubNFQTjZ36AAt9Ek.XY1sjer2outbT7HU1k27VpZjDw8YvH46JwTmBVdYfwyQCLs7O4K2nh4MSfPinS6mMy/", "electromyographically" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$R9bZ0a3DdQu3hanlYE2Pk0GFS.Ao0Ou9UsXOxStW4I3nKLS/myLOpqPE/ZK9o6s2vBSZINzylbi0bIC.HgLrU0", "noninterchangeableness" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$fxfAaCPtPmPEa33CtbRFE6vDmJjSpI9577x9xXnGFAUzSodbwO.2M9yAUOX6tA6i28MurKAyxRMqQMritEOQp/", "noninterchangeableness" },
  { "$6$saltstring", "$6$saltstring$cnwbhEunsQtJvc6fXP2rVNvdo81wH60rfVnTijSR2ythHgdkCmcpL8FzC45F.CI5izeS4t4jEqJ9ugw2dkvr00", "noninterchangeableness" },
  { "$6$short", "$6$short$cIaKgMqjcGNFwq6gQwwsPXE1kDrrMw5kHWzVcuUstKw7oPDOe7CWiRm4PjBp3tZN6ALyrak6900aJOZAKM13O1", "noninterchangeableness" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$rJDFb6TSL2s0NkVXDISZcqTV5m9kBxufGz40kKAE8FF0YazTVWjAbJukOMvTvAGD0.nlSmfMsFyB5EVpFUkTi1", "abcdefghijklmnopqrstuvwxyz" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$m2FWbVAtZsUsqsTjOEmHfEDk2F/J5poz5t1jyNc4GAuoWb3xIEUJN1NKEObAlAkMZizl3rb1F4t5HapC/sGsW0", "abcdefghijklmnopqrstuvwxyz" },
  { "$6$saltstring", "$6$saltstring$75lgzikeZZkiiKNx8VOI3jKEfDaLkrqUGNysLY7Ovz6WmI6pBL9g.f9XIFFO8rTUoTe4NUbw7199ZmeOCX294/", "abcdefghijklmnopqrstuvwxyz" },
  { "$6$short", "$6$short$4xc7GXnum/WJvmAZJQVv67wxo2Yf7ZxulYOSabOwEKRxtU0YmKaVpMXgRKJC.uG0CgCXigSiTYbdvAsDD2CLg1", "abcdefghijklmnopqrstuvwxyz" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$2vkYw1yWm1R8iCQFlHQc01dCBR51WqvOsJm/9SKokYZGf2i7OsufGYAHTmRNpZlWumTeBD3RgDznhoxSO0VVC1", "electroencephalographically" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$tDJz1QxbHlaRzt9uEfc4KA6rk8Zb22x/yVuXdalO/e2PxEqCAv9/1p90VshXPCRop.gSkggSoPVPZnhzcu4Ry/", "electroencephalographically" },
  { "$6$saltstring", "$6$saltstring$r9rQolTH4Xp2pytB0lG4PLSNBe78o.IlYv.dHFKPki9mhDcLn1QvqZ3nEkq5ByW9BsLOvufbRaQpnMp63yLgl/", "electroencephalographically" },
  { "$6$short", "$6$short$oT990cpWHOXJkA0t2UDtadiR1oqM0sMoxQtinW3ZKnAjQtoo7LihXv7OcHJcCJoMjx4fMCc0Ft1t8kf3p3n8E0", "electroencephalographically" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$sI1RN.usWbpe6cYqoOzFGmM4CPXcberx6xCfUSsR/NTqxw3h0RZyn1YopsE/Bz48x5Sy1TYEFkDPTvvGuTckn1", "antidisestablishmentarianism" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$MFYX73E93p4x9O2gJxrl.pq5hJ9tgMz0fTu19xeWaJ.zxIHSHD0CbpY30MKsCO6ylm8wB9BWiYLpJTQHPXKqb.", "antidisestablishmentarianism" },
  { "$6$saltstring", "$6$saltstring$irtmeIkR/.d8.5V9.LQRfvtekaEEc3buLskP7j5jUrzrfsxPAcoWf4/HxUtRIqdC85fjUs05hdncrU23axyX90", "antidisestablishmentarianism" },
  { "$6$short", "$6$short$V2lql4hxhfF9BQndhNy2KJ8qJgzmtYIpmiychW.BdhgEZNEHwdcrNwJsdHOsjz96eE9k7mSAuX4CIWTEg1b3E0", "antidisestablishmentarianism" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$LRSuCicXmwuyx9pP2kl6ijVq0QZkCLAG4cR5zqxrbOuM6Gzy7D2NB44tUaGGV7MQL.UNcqYONVCi8Jd.Za9Vf/", "cyclotrimethylenetrinitramine" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$h4JahbADRfvQvb3eumZIDFs11y2F1G6ICzL0msni5zt03dmAV3LGhzLxkHxQcG8rZwOsft8ndcAg9MQgX/L9c/", "cyclotrimethylenetrinitramine" },
  { "$6$saltstring", "$6$saltstring$RpIwnJJB6wpXPS61AKVMn.efTR3aEW5MAKdXvVvykgUTuXGDY4pxz75DN1mOOsVSUVp4e5xHkidoEpNUvKQum0", "cyclotrimethylenetrinitramine" },
  { "$6$short", "$6$short$.T4cAvYZrWXkMMJrNgjwXWqzj3Htq7JNdi3EZJqqpIcP7oQ0ynYfCVON6zK6k.ATMXubPVXYynUE.cFcJApOO.", "cyclotrimethylenetrinitramine" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$LFAaq/iXnkSwestkau8rRT4mTpNr4MrGv8KqpemSR4HW3h0e2h.rhBK1aKGb7mNu6AB0UQ.MYV978eFoodCWB0", "dichlorodiphenyltrichloroethane" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$psb2l5uVmivxx/H59WVe27zCblwvgJ02mG04yWkpuwrfu5dmF8wEOcZEYdWcMbTe1aadeF4PZ6pfLhY7QsXpc0", "dichlorodiphenyltrichloroethane" },
  { "$6$saltstring", "$6$saltstring$kgM6MK/PG.mD78/O28Ub4LG0Tt0oO92PCemAZdYX.ZXBxrIM4TpCj5VixroRE0GURFwLsrL7h2d6TLZE.uYUn0", "dichlorodiphenyltrichloroethane" },
  { "$6$short", "$6$short$UiRZByrytTaAFjSccJakcbMgFjc34CAf5pKg60SGyMRfdW4A/gqwkL3IGSUXcGaV1MYsr2UlAixQcHXmlWXBA0", "dichlorodiphenyltrichloroethane" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$QPmwGefzQF93ovGpF68yHGj/6o1hz.55pJ1znpGlS3R94HsU2PBh6O8GIeDlBwCMuaBeVn.IdkULQAEhnbbwz0", "multiple words seperated by spaces" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$ZOrUIMu5dr3NB1W8DRTfTt2EBpS8wfEXhmCx215vJ6TaTtuD9IsuU4R36r8CrFRI9J7Qd9IlJ8AU9X5rDwhJe1", "multiple words seperated by spaces" },
  { "$6$saltstring", "$6$saltstring$i.b.Cp7T88aRtYzhmKAaMx7uG5H3L0Zgffu1bRPx1LVDZ5eJP6f8.SSO6cSeUq.2hsH53RVweTDrJLhKBoYOz1", "multiple words seperated by spaces" },
  { "$6$short", "$6$short$Ws3G5sD2stDlxmVMDPZ1YmW6ecs.RvDGBmnmnpAMkmL1GyzGTjweHxR8bESQRybUIaAYZ38ApBZQvyKj.Q8Pb0", "multiple words seperated by spaces" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$mnfkLQyHkZdPPPjL3r02kSYe5D.wHzxpKp57Kx8P1Mf96jA.R3p/A5tei/L0IsvjHfdvasay0N2o2o/YFxpdS1", "supercalifragilisticexpialidocious" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$KWaVqu3o1/v0c4AwRlhjHni/nStjWNFhJ7Bp4JRjFEGVSMVhL69Yks72eShQSksniVHXmbASVcx3Wp/Yn4FT70", "supercalifragilisticexpialidocious" },
  { "$6$saltstring", "$6$saltstring$2xhSY.YhTn1fOh3W8NMjyXQyU971s1FC0M2LbQGIaM5ZZXSqcoHxvq7J7YBVMMuDZH312czlbPFvfxWUvqlT10", "supercalifragilisticexpialidocious" },
  { "$6$short", "$6$short$8qlemEl8gNvy4R27g/AfXhCaB7hnqLkhrUa3bEPRmOPmhlCTWHu5o/zkw3FveLwKEu3AlKZoLU/nnfwSHGSUD/", "supercalifragilisticexpialidocious" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$hLdnVwtdrsq2uQ1qznUhkaTC.xlk8dzbSalJJ4fyGeqRCZdTzDv8hDhmqgJdpU1bspQjDxxFdvILumFpmGD/r.", "we have a short salt string but not a short password" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$yKjiOaKKa9hmO09NoaGIIFVrNG7WY8CArzJJlZJ5viSZrI9TzqYa2t7AA6THmblNo18mGtDJZYi2nxBwwsjsN.", "we have a short salt string but not a short password" },
  { "$6$saltstring", "$6$saltstring$t0RxQNZ/Qlu3QMHB.qNAuyNKV49ZOL0OImloFF3LiEslYehfZIdxbknK6lABzSWSLK2ocbPAlFWKTNskYmCR20", "we have a short salt string but not a short password" },
  { "$6$short", "$6$short$qmfj2meTBr5G2EAGIJ4vjX7RpefsD4JzpEyTAeEUJdzdxlBS6pe8gdMHm5zFftaFSj/2p2bjBwyVS9ZhWpLZt.", "we have a short salt string but not a short password" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$FEJucJhvOf.sznbIdzXX/nevTmcAeQ/WxZGbdiLp4NGpdTw9IOy2DvUtHlAQmJ1e7TMBN/rvtwD1trnDwl4LA0", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$aIKPCIfvmmyV0tcgST.lxx7V1l5gHBJwRm7.0ixeLoCc9Nc3tY4uZSLzAp6c9rBo2XJTjgZ8ebkDE.l5Dw5yD1", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$6$saltstring", "$6$saltstring$GI6jHPMfuIzUD8UXE2zBbflRu.szOsYF7hvmbDaGU2Ef6oJYNStCZqud4naoxW4YtG87M0./kBT3P7w/xU4rt0", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$6$short", "$6$short$rRodyi/SnEGpjj93X0SyJvt3q1Zj4ATIwklXEuYw2S8/e2.mafH.cuAG.oBXTQiVaDu1lke70r4IXL9p5FZ811", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$YZc/19.0UTa95tPZLhobLGN/RWx/rpD7wQSGm3o82g3XqNg0QESp7dbnjvGqdDWKH4JHAbB19JtLe.Mz7fmpO0", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$g8VIp00WyyGpOO6iGLN0v/3FxFlPBTpsvRtmgUyTM7/eBwLnLW3v9ldEYUdcnRaK.YX3BOVBdStnCFU6ssQJM/", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$6$saltstring", "$6$saltstring$ofHwA1se8kFR9SJr7ScxKEqYZQVPNBzNPtGSki0VRB4LIr/A771XM9.5XyaRzq5QC8h6m3o3F5GDiA1q39/911", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$6$short", "$6$short$lp08GpKo8AhNOLaK0KDFe3xaOSst8DsfOHZgozk2W4aULPlBGVibH4Qbyrvkken2v9XC.6QCq9iish9wHJ1Gc1", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$1icV78MRKo2gSp6USFTfZhMIGp0dONMCUADe.jNkhQt1fukWiyIKVSMhX4K5.HhiLcYm6A9lrDSX89TG7CHwV.", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$EOg0uCzVU4K0q4lBphlMKR8OpR3ZeCcZB6kR2nA4dxv1VJ1aGl0U3Za3q7tVdwOfY0BmxQjBys8l2HiS251XH/", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$6$saltstring", "$6$saltstring$L0b.Jd9LfRLMzY4Nl34qUXG1pbcXQvL0BDHYY7dTBdjLxDM3YK6QyYOoCMKXbDlqdEdFKYzWpWIhqxJfWOa51/", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$6$short", "$6$short$rFqhHhA3sDEMZNlVzRpFWLenaMxaZjnaTU1x4HeShmrUkydWFJHLI2MgHCE2xRpS1WthIfB99kEgkL5VK2xOi1", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$0TO8MCVIN3QPgE7tm3JmEvbLxkEz3rfSDqDUgaL22IjbU61isyTMvRVHt6FxPx8c/tSAs6yRAlAbc96R/PCe20", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$LzCaL0sq/Kjsi33G6vTlwdY6Otwy8r2nOOh0mEzgHO22HTwqFqxtvN/OTYb1AeilygPRyVRur/5fCt4C3407A1", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$6$saltstring", "$6$saltstring$53QDttM5XFD.Uhcc3Efy7XV.zrHuvtZBT.o/f2SKV3xQtXyOrfywMwP0f2HpBrNF2SZtZsbhq.f.OV.UeVZz0.", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$6$short", "$6$short$fYpg6FDLLGgKKgczuklusuWHGzT9K6NxQDXKtdooSBHqgNlAo/Mvwx54PmGeF50XLuyKAqzMqStrYNerssBhQ/", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$uHWrFUW5s8RS9u.dk5CylCJl0sBNl72MrUUrJHZMAKfAAML2CIOw60ALQyn/JlzB.vwyd.f5YuF/xP/WURIl81", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$01SVVXFQKExUZmFlKe3KbJ.f97g3fKW0xAo9wM0EyPE9b/F2IHtK3UXGFKyvYvibpoz5Z2y.ynzXhWhGXWEH80", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$6$saltstring", "$6$saltstring$9SPQbC5k4pZ0t4UpGoM.Vx2ujkzeqfuZOriYtbJY4SZYcEwMuigPWSSgJOo6EKqTD9BIGkpLVrt9nHjL.4Flq0", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$6$short", "$6$short$d5cAhyxswvAEBxLwekQIWzeppZvQdA372KDr046UlygOGI/JDqkOv2TiKwDsk.M75YdR.RIlSgDqVZIFBtC1b.", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$y98e3CNpayfziP3LVQrwYooPJt3SiNpjwhOOz9YDWZIK7hfoHi92JW6Im03byxtpOw2F0pxbPOVaSWLgziUpb0", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$008aNfGm6HeWIzQtsyNNHN/LbKZdFerJI1S/vuBIdI/itiBNixWOYBBX7Vjeq3gSrpI8j.VABomUPri/noOqy.", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$6$saltstring", "$6$saltstring$zSKb.dfffBahNYeOdVPph0KLzrpnC.sYJG2co7U3amskV0psOFLJsxlBKQipWNkV6uW8VYNq6lh2CAJgp5lHc0", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$6$short", "$6$short$dzyFC763S8QhaYsdATKEhS4Enyjn.5x3lYcgtaWPLd4kZP0OgYE.Aozbip8IGrA7HDjL/O6PRHDHJmgNX9Pmu/", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$xbAcWgg3yrJhh1kQBLOML0lX7ruUOcmSFtnlCWfvdhNoLr8S1ITVqDJMqpLkDGxZsUmHlpAGQwbmrF6FH/9pU/", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$H7O6M/KIKoNPKD/eU9UInmP2yy18yDpWG6OeBzpn5rObAhiJrgjQ.58fakTOy56horrBoi8.gVJ8V3UFkCtzF/", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$6$saltstring", "$6$saltstring$aNvmG6BLAyz8Fs6rx69lSHQJTlPW8eQSmE9HJSw9aMiPAeh/M6qQHc5LJ3X0s6eq555oSVNsumeFhfLkD9/of1", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$6$short", "$6$short$lH01Vpje7gW.LNPRyCScyWZo3C7745.dpo7ze1ZTCUN9rLY58N7kAEd3W/gS2PFTbHWdcH01YSds/Wx1lQ75y1", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$.g.WGNi7iLuLVZkeTsOXmAbwud95EhzM8zjYdjA1QWiQEPACtSRq1pIuJECsUwvVgXk7coEwtigP87xg6nQtG0", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$xeMNn161B7yjdn/yxMfWIoVIEreVVWDTu1MKnSogkzLXo9uTSrnKe3wDwuztE1knU1XMmTMDGA2Q52vD8d4Jc.", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$6$saltstring", "$6$saltstring$TYs7vsVh7g5sQJr9.uSuJVwRYrG3dp60lkMWy3IZo.tILrQk7B.uGeDhIDWOFey2eI0C7WYO8NjN8tKps4TWe.", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$6$short", "$6$short$aEHDhCGhHm/xMtm0V.FaNxIYmjHSMWZDhgJVeG9zHrPZqJDF0PP.zoJCGC99hayBazoRODwP4FQs9JilGFwHy0", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$n6yjjvpTf5vOYjbZ1aZjqrx/TggPr79pwgjTl2dFI7VNx8oGNLeTle5emEp8tU4q7VPD8rjbwF2MItb7ZLN9h1", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$YZBz3nb0tkiSw4VXXdYnRJobyr01k3IrXmvT.Xqg5xlpx4NzUW7WFVRooLmi8BSLKBqYe5dOH197HElp4TxXC1", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$6$saltstring", "$6$saltstring$Nh.bh2TdtwRRFRiq9No4f2NBOlm2wFGPKtl9rtVLkWtXvuPu7/cekroG/jUdMSVyW./MMqulHZiEZU/UIfUhb/", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$6$short", "$6$short$6WsjdYHCif04SXtslG/IFSeDkvlhiEPkUlzkwTy6BPg4qwZUynwL1l8b.Uutvawr/TsUERyoFSlCiNJEWZRMw.", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$lqSxKTyNJyfspfDPqtL94zhESr4lrEzgEglVOs0bb.UNtwTCy3/77xPq0u4eMFNOBLe4B1wEKZu7E//jALYYw0", "\xc3\xa9tude" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$DzTgQhcR.H7PNaDMGgZftQTnfYUKeRk51fQjbzSqLV712wJbvyuayaz5XzcMs5mqE9/W7QyrgpdoVrDS.I8VU1", "\xc3\xa9tude" },
  { "$6$saltstring", "$6$saltstring$oyMuy295ywHYFzCNzjJ.pQfbChSPODUMXSPj0eUmlza6ouZkLV5B1GcLYOJ5cuAIs8RBfa.m.vChLPhnzV7Y61", "\xc3\xa9tude" },
  { "$6$short", "$6$short$2kwvr8XBcIJt.cQGjw4l/HoyOQ/1M9K1gL7RKX76.LOvs4xoXsgBNI/8sRVjo3UET/GdEKsum/OOrqTBS6Mfi/", "\xc3\xa9tude" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$aI8.T1BMUrBKzFge9FnSf9UxICh2qXaka98CL9RMdiDdjfwoOJKoHnItsfQ0L8QwbB6heNAG/xcsIVcJl.ezP.", "C)tude" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$twUHZ7RWCTqbFKkhbXWkdKGQ3mboAdqqXi6ylwepTq75xRwrpojEVg89Ecytxhl3vQnv7H3IEo.GCFYYpakYJ0", "C)tude" },
  { "$6$saltstring", "$6$saltstring$l89fmVBDOQGhgKenz0dZvndaV5YKqYFI31rs2fwt/Hi3xrMd6/penzXFaO6w4DEWHYUfkeNAVjwspRqGBKhIq0", "C)tude" },
  { "$6$short", "$6$short$eP7XY9WD7L95d7FQyG6aKbJYmLxmyirFkAdOzBVNHohadfApTXliu1/8AekPNdEqKYeNl4QxbO09egjAnd0Wh.", "C)tude" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$FpZ0gM0i8QK05LCaxmrLdup7MGQE7zazPQzhRLqnv3WCuy2Mpbv5IvaM99xgwqUXps.mWYi2rUNYBJ/M8xGS21", "Chl\xc3\xb6""e" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$HAeOK7n6a/Ka6SUpUkVHFlgba6zgPtXvAODDIyprAgwvky8GDQbLlBNXnUjcRWiRZeq8usNJ2/NnQpuP0F/Rv1", "Chl\xc3\xb6""e" },
  { "$6$saltstring", "$6$saltstring$TTqmAriNncf6gEOVEXU2Wgq6xkdKTfG4sbTUa3VSCNrmytU0Zb7T7O2oDvLoTx4rv7AKhjl/lEoAAAYwjVteg/", "Chl\xc3\xb6""e" },
  { "$6$short", "$6$short$4SAQwPI8F4hDophQlxlKgLlADRNvdnHYQuGqx3Wb7Wp7EEgRN6iqasf36IsTH6sQzN8Swt0M9j50BqctnwQxD/", "Chl\xc3\xb6""e" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$oPGrrC61AnuTL9X0zqAcQl7zbNUjbmukqIfzk17Vw0BMaWqwjfYPhf3Fx0LRgt0USYZmZlR0MdKrZOwx7dUCX0", "ChlC6e" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$fu/5N2TO.aYWDv6cyPgWFR.p.OLAMYSXV4qvKd5ynBKqFJCeDi8CmV4QIuAnp8uFfitJnAO1dXuQJaSwH/OJj.", "ChlC6e" },
  { "$6$saltstring", "$6$saltstring$2TIVIwonPaTL.E9zo4StKddFCtLh4W6EHyx70ouAn/Yb14E4wDRjth5h65VmVe1K2gTz.dn9T3UNqIaTBFjEx/", "ChlC6e" },
  { "$6$short", "$6$short$yQfcxqnFm5bP0x8fSHaY4gPcytdZ3DhcbKW9ugeU1tYnrp0lwd1pdtnSOd3Cwg4ZXiI01Kh/wRw76fA3zE4Zm0", "ChlC6e" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$qNEsE30AUxzt4Wyu6jSYhX5lNm7xX/JBoEpeZ24dY97F7Mst7KyDnty3oroA8Xgm2oTk3CL8sSig0sH6TICMZ.", "\xc3\x85ngstr\xc3\xb6m" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$iZC3Y20GgQQoCliTKHsDRisrB.h8g5Y.HxVfhKC8So1QDLV/Ni5X6kr.eJ.UsI6FLdLqtzQBD0CscI0OqIoxl.", "\xc3\x85ngstr\xc3\xb6m" },
  { "$6$saltstring", "$6$saltstring$.QesR2gQR5OtQR8FRy2drKqyBkarrH.ebtlK/iZMywUg3US5JDl/UW9hjzcSNSww0N8Xn8piAqbjEmzs.Qh500", "\xc3\x85ngstr\xc3\xb6m" },
  { "$6$short", "$6$short$c/96eeT9kNWuBy9FQ6c.hAJk7EApHKN29sozv7fL8fapNnb5rNa3eebQgZJYHmFjcL.qJhvyAVA0jSfadw1VU/", "\xc3\x85ngstr\xc3\xb6m" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$tjsfeL70n5StiTBhtioiCQQUbWuvPZl0WUtRZgjqgi5kO/DbBLHK0VqE8Js0ftK3i12BheBMv/Sw8psYVdHTZ1", "C\x05ngstrC6m" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$LfhdTfQKM.G7.gJMxUPFqGHQVn5mHe.42pKpq.CB3BEh.k5K7JgCsa8CdofBHgo1xseueAi8/AujKy8MBSh0P0", "C\x05ngstrC6m" },
  { "$6$saltstring", "$6$saltstring$LVh4mOHTcPsGlcm95e7OmJulwDcVl8F2d/PEU2GsDYx/AYV3zf6y6K5nug.sWfIbaRmg8pTuBkOLjj1fJesCK.", "C\x05ngstrC6m" },
  { "$6$short", "$6$short$JTRpBWXnPzC8TD4FLT2UNG/WUZ8napdn4HsC1n6XsG7xujXuE8TAgOV1GfsBLLgzElLUhzN.uulzMcq/BvqGa0", "C\x05ngstrC6m" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$ZnJfhfyCu.H44gsm31d0lZR94Brlnr7PoGsSJY6wdqw0UR5095GHCl.HmsWDEdoJkwyW/r3LGgITqpo859nAC/", "C\x05ngstrCU*U***U*" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$kxnJ4McbIHqgngO5keKkME6UcOw.HUWjPd2XX2ZidVG.4MWnAji94/u4k2AOEIhhrOh//mYIviRwx1Te2BgSL1", "C\x05ngstrCU*U***U*" },
  { "$6$saltstring", "$6$saltstring$ARcJN4T00LHHGdZrSnMYK3GCG1nzQhrF14eAeZb3W3Fb5ZEkCsSAFX7oPYdYothQw.09vdXp9gXzhv2MzSJQM/", "C\x05ngstrCU*U***U*" },
  { "$6$short", "$6$short$SWbqaVYzAkO6NnoFwTgF0PGTvU0RqsvO5/jLac4I1C12iYa4WzgqTJeuA40/N/bbjutZ6LEkRRqaFW9xd9Edq1", "C\x05ngstrCU*U***U*" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$clMp3RQ0uaQJZMtAO9qgbn8JCzjS9X/jfP6yIeK66I0jWWmkrIR8D5wDO7WoIpeBcenxgFe1KD6lVcg6J3mta.", "U*U***U*ignored" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$K0A0RUj4BoimsKEMr7kKqqfSV.X8.v9itas2BHE6rCKt450KxmyczZuVYSb8VPfH7pyi/dU.DGGY7KKPgPMJI.", "U*U***U*ignored" },
  { "$6$saltstring", "$6$saltstring$0W5Rdj5MD81NRYg2cR2iIkQjFIGtIGXxP8JiaVu.Tk/Z3Ui72SYzycEtjMu2Qc6HFD/wczVOpN4OusAA3WyEY1", "U*U***U*ignored" },
  { "$6$short", "$6$short$bX782QNGcL9s5fuGzlFh8e9jtrdFmA/OdtZJADO6KesigMtXUCHt7RevVOJcaWCDGCz57BgAs.am.j6.dOo2L.", "U*U***U*ignored" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$jWOGAhbA8zaKHCyf1UW7Ba9G1xjD.0TQ.63WCHWPHg6/qGFR/ve3pQM457QvWNhVh554j3gMUUp5vliH3IvMU/", "U*U*U*U*" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$nVAKakB4Y9t46BM7jkyJzmdfBJfOS786wiM2tGNQA2S2hYyrT7368CT4jifRtw2hB6Edcrxuj9ddiBzsYtX8b.", "U*U*U*U*" },
  { "$6$saltstring", "$6$saltstring$8xidKME3hWgcpxkMIJTKpHSQWqP7Pz5i26k/7tkdM/3ia4unNXdkdtMua/fgVEp9UvwOij/GisU83aV1cFn3u0", "U*U*U*U*" },
  { "$6$short", "$6$short$c89eemEzAG/bdTaeGawqJBXmfT6Uz81eNXLnKCisJVRFSAp4Wetukl7sZUGdr7aHE.JnFy4SR5tZIJ6IAVcug/", "U*U*U*U*" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$vA9sSBNM0OGhuk8/zVEGmnPE5UJQ0Cty8nnnpfjf.j6AFh6vnZtPJOIW5KrlADlamng0qCPTX2/cB2lob9VAw0", "U*U*U*U*ignored" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$1WUlGvGT5yxqLbj6jVg2dn35RtUYE3M4OBm.dF3X2BbTXKqfGQcdR2KxgvZ6E/E3IaIrs3Gk30wGYkk12eHKM.", "U*U*U*U*ignored" },
  { "$6$saltstring", "$6$saltstring$x8WUpqM9x28MUMMonJGLWv.AuQK63nmzqj/LFdPUydpkJQICSnxrZtRLwbygIDeRDlLART7IXcN1T5irL9Blz0", "U*U*U*U*ignored" },
  { "$6$short", "$6$short$sB0VNp2O.CPxvionlKYE8B7JWAVb5N3bOcCHnhKnEb3H17sRcQFP9y0oBIN.TIK68D74GPkfxGJ3D3djVgO6q1", "U*U*U*U*ignored" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$3Gmu79mkWCkOXvDFpq.h9hiIFLVeGstX1lO47su9rcrZLp1WVX7iE6eRPgV5/en8YPgWqWqpAB3gdGXfgZL950", "*U*U*U*U" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$0bwHhJmLN12.KCXc5Yx0ySUkB0V7qybZkNp781ze7vhdyLFqg5BU31iQY.kp.48wM24EtaSwdQGaebHqLMWa6/", "*U*U*U*U" },
  { "$6$saltstring", "$6$saltstring$AfsOGv5ealHbyGZrlI.fpIA3Imnl4C.WalSavWhgiINL2A/9/Wqd872PrREmJpbv0lfVgFgBD8oJZWSv0aeOn0", "*U*U*U*U" },
  { "$6$short", "$6$short$FpGFMOXTJ3UMXgnTiJtiQAPsxw0cUOgyJdPC3n4XumXDyErGWX1KSCpQAS2A2zXQVnulfi8nnn50XVG/xW/B31", "*U*U*U*U" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$ucF9vPzSVeoaG5PiR3UULS3BQyuHezx78af.c4dsuEU2MKL3iENf3n7zLglFFaQqFCD42CkT5bdwtK.OutUTt/", "*U*U*U*U*" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$zUfmF1xmQ5aJeZjRB.K42UfSEyKRDVDSthLbbRA1KoADdDWOsuUT9jLkqq04h1qRzVScGzYKDuqUX1A7zWQLU0", "*U*U*U*U*" },
  { "$6$saltstring", "$6$saltstring$V2AkgtJ7mXyiQV4/YUHVdN.WU9i445RgQ.AJCOpXfMFAVvbARob8OZ0asO2hzBJjfw2osBH6.CEAip1vPFhue.", "*U*U*U*U*" },
  { "$6$short", "$6$short$ks7wOW3l4dY.Da8YZ381hq0TFJZuQHed3TamxI4FfMlQvgn2UZuQoMSGds8fO4mfxYns5odKkJskfhGJ7LSph1", "*U*U*U*U*" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$R9YZaqQkrcPmqqW9vTU5TtIRU4nedTtzRpbREJPWdr49f2kl1lNs7nS4wEhcPjUUGKop2XU81A5nk/lFLlG2N/", "*U*U*U*U*U*U*U*U" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$guHXWtwStMlV4XenpNt4gUtFhBlOU4Stw1L0Z5o4eFPq25CLQHlXKzzW0oA4fO5CMS9xrlZszwYpmo5Zm/Qj5.", "*U*U*U*U*U*U*U*U" },
  { "$6$saltstring", "$6$saltstring$BKMJ16L3.XaWCHsbS.I1GG1TFKJdca1f5lGLor3ruzatqQQfJiWUAXJS8kfPGZCNw.3xNJK1j8fd7PBQmikCW.", "*U*U*U*U*U*U*U*U" },
  { "$6$short", "$6$short$i4.3mdbVX.AbDRRa7dyj8lamfx1caSAQh5BYCI9NHLAtJbUpUARpC3kcRBkp1F5J5Mw9yrPi7PKtut1vf.XNx.", "*U*U*U*U*U*U*U*U" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$PFSRhxM4iFRFcpTYBiAOtHQSwx0P0Y5dbiAJO2./Az4XuY8BPHpEHt3H.uffeJJdQIkAJAc7/FTJZIk4YKuDB0", "*U*U*U*U*U*U*U*U*" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$MD3xHDcFA0jQg0mZjNWAiQNr/LwQqwJRoehrDBA.9.rLAWK.wJJYwH2FhgkKUcE/N9STPqSCuPApoGxy4crSM0", "*U*U*U*U*U*U*U*U*" },
  { "$6$saltstring", "$6$saltstring$MLrB6KAxSMubezmVyywj/.12/6UVFi4e8uJKlBDEPBUNLzczLbJaIuAyG9E1BqB1VhjY.S5n/e0KgS0R/8zu80", "*U*U*U*U*U*U*U*U*" },
  { "$6$short", "$6$short$Nwq/3dfZoXSeR5KtnYSPQjbPjX2kG2cqJIwbcAFldjrsMLLpnW7AOXPKL93v.Qs/4jMKSA4wGCXdQmq2fFwLd1", "*U*U*U*U*U*U*U*U*" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$cfoadzqgR800Al7RBZYRSAwn63dmpU1BETe7n/5XlUKSe6nT8QsfQIx9nvpNa3EjeCLIhKVA/XmU0MDDsDtF3.", "\xa3" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$INiDCgrrVBhH2oDmKa70.OJzfmu2pSakZMPzWkm48/AGaEpxrTny563qx5IN.F41Nc36HzlS1ve7zvmgnfDAp0", "\xa3" },
  { "$6$saltstring", "$6$saltstring$ADYH2ZsU27JBhxjlw7RXDfxZbXaVpK4W9bYJdNqqhFVOjYt3/gU6vqWToxOcLNtuhaREGYQ/mLXxEQVFW9rk81", "\xa3" },
  { "$6$short", "$6$short$1ZXqXxhqZcG14m3.bN2jnIjfOWespbWzqvv9pakDEytsWB045W8.L/Ep217dDfE3pZImgWkUORsprwbWbaqbb0", "\xa3" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$T2s2OgRAcynEjfKC3/3DwA0Om5qKU10BOp8vk9N8WFIl8/Lk/JvaNTtLIr6FFf2Dfttul1AS6aY/1.YUkLbQJ.", "\xa3""a" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$YdIefl9o7S6nHVk1qVVJ7PZ2XYeSANZLRjtQHRYbdob0If094.dV3aXePEI/KC8KkitLucubwJV/CT8cukVMe0", "\xa3""a" },
  { "$6$saltstring", "$6$saltstring$pE3u.AmL.gorMh21dRdH46xHDqPJMGOn0rano.dhDuXBbDD8KeB1n12Q.mE0GRrZEvCn.el5KiCiksWKjGM8b/", "\xa3""a" },
  { "$6$short", "$6$short$CIO5DRmcbEZstpV0g6zzheLj6K6VYnHTbHFKILGVQUHMMrhWyz/ZRMccFKYpsIttXXHsjiOLlmDHRQxDiHhID0", "\xa3""a" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$4pYy7FBoMTYoniXE2gMQGly5RSqlhpvbDS5omtNwCf/EhPR0oJNmtaiQtSIRtb8TVszvNp53UxmP3V71MPTes.", "\xd1\x91" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$4PJE3f3503BMGyo6.aY9iwU5WoxD86YY1YMZUj.ENtDIBDg3kdsD15LOhKVSwVqdqluNFScl8Kon1PjAQiNr8/", "\xd1\x91" },
  { "$6$saltstring", "$6$saltstring$0btQSgkTTtr1nZt680KSHeVHbAAk6J49wwzykSOmgrMXW0dK2IplebW9XCWyAntNybFXnRXIPOQQfril35s351", "\xd1\x91" },
  { "$6$short", "$6$short$EzJP58XRCkxWG64SAn8ETKobdEoFn8EIDHbw/zX5CH93YY9iOY6b46MPrhS/5UJtbWpUm7GU5l0Dvm3iQC6Yl1", "\xd1\x91" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$2Ht59ZLnAJVqQ4OT0JfbjHLlA5QyMX/4BGHMVH58zZYMrJ8Zl1sNVIldCGk0zGzW7O8wdMr0W2iJmQ8WLmX4b0", "\xa3""ab" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$msJhgJ841qE8e8QPZL000iGc6.HZrRxUAI19sGn9OBpo1dJZuivalgo91zLkCBdDxieYtC5usXZEcQLJHQDWs/", "\xa3""ab" },
  { "$6$saltstring", "$6$saltstring$VTS3fHTxGcquer68dZ4HRB4Oa0/EXQHbA9cAFXrcwsp6HftEvW8FmUPaRgJyGxmFzai4LbLga0f.eHAwV3lW51", "\xa3""ab" },
  { "$6$short", "$6$short$Yco2oerlIrCu7bOitFiuNPeK5GGE7SEatCEJUcXBeOLobPqwQ0cwJ2SOvJGfRWjbySrgqNSRZAFzv6Oez/3y9.", "\xa3""ab" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$.MLHSFsM6VZptU1wN409BybKpHGtQo63uKV1e.UuROXTLz5TJSI4lFzLOxVLXA6dCvNvQjw.9RucAN.yLamjz.", "\xff\xff\xa3" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$C1dEQEgTHGfcd220x2sRsrkL8xBfIlP61AwE0Ccc9KMbOLZzI17y7p1cf3viOlQplEK/VIJ68SjXyi5TjH.4c.", "\xff\xff\xa3" },
  { "$6$saltstring", "$6$saltstring$eaAbRikHNdlr4mEPeMr8tDrsgiN.bSrv7DdZTJ0Kb893ii5AxBlZWEqn.O0T61mvoL53kdQchRIPDkrqCmFVs.", "\xff\xff\xa3" },
  { "$6$short", "$6$short$q51.yi9rKiq2ggZbDsvyJ4QU0.PH7giEh0.1dN7yMLgwx4vZaquFuUaNe57mMPno8CilObFBTy1y8DzDXSz4S1", "\xff\xff\xa3" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$bJhHkqf9pTlbtNRhvknNEUWn48g1nQ4cVf0EnC3FgQD2S4z93ba5qXCyDdUH0q4ondiumGvHjpz8QEiPvM/9m0", "1\xa3""345" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$65S5U8tpUq8t9.X6fMdeyqwMygKGstI/5FACfNG6urolq4uFg5R1R5b1tQa.UqGAT9R9Hn6hkzCgVjysFNkD30", "1\xa3""345" },
  { "$6$saltstring", "$6$saltstring$flE4V9gqvvXm/QJnvX1oOb8bcXXy.mtwdXtOO2PlGaeMxVc6FVv8w3G4pCpLCnJSIWs9t0wTRJGdv0MVSK2VU/", "1\xa3""345" },
  { "$6$short", "$6$short$0Ad82qChXGoajTEc6.uvKBWsPh1CNg/gOcOC2lwjzRfCgmqJsjuGkKtyPineorhrkyTpM02NasxuxZnUZin8P.", "1\xa3""345" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$yKfXESMPI59Z/TrG/DPmnFDZGzk0NBB8AS1Ksmw/5eV5rFhJ3OiGAgXlm1QUMZRtQvu8psczVer/CRJypjMEi/", "\xff\xa3""345" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$kC4oHr0rsvmn0A7RHOv/01ZsZJ1yBykFOFiTBbNG4PnYS3Ib4sY1YIrSx9NfdEVkCtgRjvw5jbmYs2da9W2fl.", "\xff\xa3""345" },
  { "$6$saltstring", "$6$saltstring$j7gw/3zW1xgIPsT8.z2teyd1cw2m6fFKCnbqhx/XLlUdKCw12GiZeDyyDMXk0bksJ57Il/R/c1tnYUD3bFkEO.", "\xff\xa3""345" },
  { "$6$short", "$6$short$BFKpPq/vAq/sr7IWp9M1MZldjRYu/Y5OIE4PBmyeAw4Mubl49zqINvuycugnUSmYf5EzkNJ.tIjv/aQPiFQYa/", "\xff\xa3""345" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$naCEzI9DpEwm/SpkW2/r3lCd20R6MbS/fgMV47EKgPBdnQ3SU3PJBoTz9kTU3ImIYDRzN53wxv/BQuCk9P2pW0", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$t.zajUER6gsJLjzHyW5ESeVmjG4UpzLb4JCXxpgl7q5qXVR1UH2Ygnq4Or0b1oTuocp8.QX1Hqfk77xH73bwT0", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$6$saltstring", "$6$saltstring$SOVyoUV5lm5ghaDHxOE7kphQYEmSZS2VlGp5dUrxgYdIwCs6pI4qF5W7Z5h2rYirPaZBVENAMkcv9E3XAz4vC0", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$6$short", "$6$short$0sHULbee4AUcYqZT1na6upzJQokEnbrkRXxaBFaxkNm9JTurn5EaDDIYq.1SCJe3CJGnuWM9qtMGNx.1iHtqh.", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$dvpgvI.4mhAYtOyD9D6xEJ8a.UWej46gyKsTrQog552LNYQ0O1e916wbvsAk0jDhbk3kM/3Jm8KjW8Z2383my/", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$EV8wmcsmm0.SToX7sHV4qqD51uQaF2T3Nipl105jF4e8uadxo5yOeeYLak7SodePcVQkuTYKd3Hvn2wsZ8ZRq.", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$6$saltstring", "$6$saltstring$Px6rvo3I1vcj0PkiLEDLVixte5TFmT97fbXEnyAEDG7VLTxTZ1fDecMUoRMx5PRUz.yWTDjn.75miqMFT11MK.", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$6$short", "$6$short$2nnUc9n55VzsmsAQBj4qiErQUQwwjdUwVD1lOcz5bqtR4fidsgfILgMQoy1KnIi9xMayGH3mIDno2khToTQtZ/", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$IqD0BNFtlXmBnWgHAi4oaHuUyRSM6v9JnMqxJLsCFT2G0U/TzE/V0eWKlxksHbGn7nAA4ftcXAI85T7IksWf//", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$1NfLYMXy9wmDo5EwSO.2qj6C6nYb/eQghFIejexDL1dAmR3npkH7x5WtZP6t6GxMJUjz8IgRF/AjgcTVpkjGu.", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$6$saltstring", "$6$saltstring$fkK/ZI4u46n0tAbp16eXeOREnOVMaf44V3FeB/cYfgvelYxgR8PvR6FtRUUwnSlYXOf456YrkKxh1ur8E4q8U/", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$6$short", "$6$short$SX2.srHh2BTZwj3aSJZVOjA31Yk0Qs1W08o5gqEWe0/jP/J4uKgDYpX3GnozFCXFypx3tmmoQAdyybE4Ymqtb.", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$TRt0WFaSeryA68pUHkFxNfLMoTamHYhboYLeHAU8PJl3sczB6PcXeVSLm4ciYTDGF3awWOHQ/nrYhnfP/srP3.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$KWkvemjbBkVmpG5.4rqLa6foWxsACsEUBhPVuDdYXTdVDWsFxaPRYcpiPfsiK/K0.EHMOqx2mKdleUwKAncCQ/", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$6$saltstring", "$6$saltstring$C1x4DCtLXdfvBDuO5l0LJohGrKTCd5DkHCzFcr6I.YY4k4MzX4lRn/Eymio/qiJHZJDqLOWsjiXCIJtBjX7u/0", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$6$short", "$6$short$fjfXygfY9TDUZFN9rJI7KIpqbkXw49IsfVmbMYdnh/8rTwFOGVudwJfli.tPfzKl59TYC4KQuirm3BO9KHLH6.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$5Bd6L7C7SUpEXWs8dXzJvdIJ41AjtWiphxBEf6LfrwKSykyq7byQ4QgSixbyjWNYn4o.Fjxx87jcekCNu2HRU1", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$dSjJVEhhlmqSva/1drYyoSCXF31mJEHuUZaPH7YQYlt5jjxzIF7V74Er.CE91cSnblPvaaFmu4VSCMRbacfUi1", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$6$saltstring", "$6$saltstring$4Vv94gOcNYi0BxlN.GhQomB7GR83BKINzEjrbJj8pY4j3s7J3UPSw5UCMm2dNbLtLXrmTpLlArH4pVkreOtEZ1", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$6$short", "$6$short$FDplMXyOzzSAXu9fXGmBPz3dAmX/XTfweZmezTAxvGuIwlJklJXFXZsKnHd5AterTt2TJKIJtOuPLLHOCcUcz.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$ha2iJIaQFeY6GCMllr3nYrBsK.QZPyMPSa2CoF0XWektRLYXj0rN7icm03qtZfnSxcXQ0ORZWTKdFrK9NnnIg1", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$pSqjkTfNFOJANgCT2lIrtxjdUPdJaIbwPzDLVZhYJd61Dvl.qK2P8kSB1djRlXOy.81ZlCxPx2tcWVrG0Js7S/", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$6$saltstring", "$6$saltstring$9z3GMm4CWgnakXrrcu.3OtSBdptT71.vAn/H.dYFAGkUqr/yaN.NpWLhrFRjvVbd6tHT3mPWrBwlFVYAYgCGY0", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$6$short", "$6$short$Js8gsW5AQZwcBewLbIaPXb9f.6tQAitBpkreCDsSEg6Q0IKjUwaKDM69aM09hR7juO3.qZKm24Rs9BCwhIkeL.", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$xo/8FMRG5rsIK42JlxIFrljJNGpDy7FrbsEc2gvkL3tWTbnrLawlIQtO9BNAa/3ctWJBL8r.5x08ciyC6/zjt/", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$s7JVyEHSMjfdTb44bEYkeDOeaqcEs1xC8BB38QEqyLvbHmelag/6gMhQsE2yeB/m4gA6KWrxgt0V36enuScik0", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$6$saltstring", "$6$saltstring$lpmpUkmc1.CRlX3fUfYkqAriUSZQw/BTcSkT5AMROt0XOldAEXpMeCLPbddFVRwdJhUT/G5BDdT8ar12duDsz.", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$6$short", "$6$short$vNSO.LiJll5YbbuHlfV0iA.jHH6MOwphvlqNxb9iqSatOoyG7KcI5O0AmSvM1inukyHDZMbrm8pD7sz7Yr.Uf/", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$5zHh8vzmp1yP8U09jY03BRwUNbxRfoqmqyr5zo5QsW8EUoaA1fh2/d.HwLVVGZuEfp4d9THYQtjJjvE.k.LNF1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$b8GYqihRAr8HsGYgrNKE0rqgYqIUKF0.B90P0CAU/818kUOLy.L00w52DEdl7PjoKjNX/UTwU9ncwid92uba.0", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$6$saltstring", "$6$saltstring$/rUd972yzYX7DEDZKhzC8/ICeAzy6fpGa8KrARh44wB.qN82ZipJw.8OhyPOlMFYq6tfOOdIAe4sHPMQKixWH.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$6$short", "$6$short$R7iqLyuPtPYLi8TIjebyTcNnotYvQkAOjavothfOSPmOjEZhzKky4zQwNjKdJBZTq4Efgy29zgd4zmEwvPc.80", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$q3v0W9tO9bfZQ4Ep9mR8UbDxRurrbS69d29jYKq6/cDC5H5f/sULXpiBHHJpBSM38ENzyiD4mNQPHqwgqrEXe.", "THE YEAR" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$AD.qO3XcIk7OQ2mLqo1D4YQR5glYYhRRn4s2UHXwhWMEIIEWM1Itgg.T4bStNoOqYctOlSglkTSQXMttJ/B/0/", "THE YEAR" },
  { "$6$saltstring", "$6$saltstring$5o0AwCbNt91d5vd1vpi.1LPQjvjqhBPgV5Nb9X8PV9QZqXADhg0F1YtZT86czIA.JBze0VG.OvPe7rqNcKXYg.", "THE YEAR" },
  { "$6$short", "$6$short$qYiQnpVUJSi2kdrrH.8YC7KpahfqCzOzU.Q/OBJuh5z7ypfAZqLp/zPRvzec.sKnXvcVEer9ya/4sWQVhTWvC0", "THE YEAR" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$4ADe9g6C1fd7bkjXm93MX5ju6c8ceT4N6So01LeQkeDmKk996eMT5ewoybuTkvtub/KOOuUvfmVIjzm134mUs.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$f49IihvGQysoBWU6X2ZYhbhmIy1F6jnbD2nKQubmXlH09Pmlvu0ClgR.DexZDDQlBQKBPi5J49PBDfaFDyxW60", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$6$saltstring", "$6$saltstring$RR6MtIURCum8PuEqvuHCH4yIPfgW7SDWIplo0oprxEyPn5iREDsDoEEej6sORhA/zA2T8.JQ7NLRaxkMq71fU/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$6$short", "$6$short$qLbQuWGGk4Z6Vfupuvzn5LXJop385TlZWxhSl37bN1cdY.sOmlwcJN4tsXMj7SwNCVtwgzchzKzfYwEB6DOo3.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$6$rounds=1000$saltstring", "$6$rounds=1000$saltstring$4LTytAiTGVAwfvtK0DlkMWJZKotvcimOEhCT6B7qO0edp7Tu.BmUP2YgW/LFq.Nk9GeULIPwd6Dz31TY20x72/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$6$rounds=1000$short", "$6$rounds=1000$short$PoqbmvF5IEmD.iLzi/LMjuJr1EJPZ3fqm98VtatJbLAikQHB0RAt6gpBytXGZOgPZp/f/HGn4o4RLAsb7xk1N1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$6$saltstring", "$6$saltstring$TgW9Lt0wix94P3AFI9AXi9MdzBWXXPBz1.4uTh3wx.3usNfiAqlPDEt62eimfnfgDh.AaMXND53S2Mci3Jyhq/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$6$short", "$6$short$MUawXOnh6YJmVmSJlYkzGpxCmQzcNLMASIiALHA5R5nxL2s1EnaeG3of5d6SV6aQmEnLTHAKz4pgOxJCDTOz//", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // sha512crypt

#if INCLUDE_sm3crypt && defined TEST_sm3crypt
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$DY/RxQGOgn6Cwtu3J3zls23H/HR.msQ00y43IniBULA", "" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$hdFJtTV19YqAC8eEHE47MmFZfctHPlLKmOFQIv2pni6", "" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$4zfK6aB36s/5LqYV1jSDT2H2H1junxCd23hZZ4l1409", "" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$5vN2Y1nopz.smCAfb7gds.V7mstevRRNpVyIxDduzO9", "" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$sxITr.8FDs0MEXZ0TdglNfItrcUPQtxbBQmRw3Coor9", " " },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$DBDe97bnMwomNBamqKYQH4Hat3A3/4TeM6UzjIQyotB", " " },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Ytn77U0zAOwqUcFEzPDlkASOmvjTnZaLRtCxmbt7w55", " " },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$NNd4StfvfAADWSaBE0UCKbRtw9j6HHTTf3ObfFKdnK4", " " },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$ejuqN9JzrsNNbp3HmsTB9feeYHrLZedwW4hJGIE4M35", "a" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$jNJ78CbhDOdJiASJs7MfMbm5dIRxgq7z1h8CnHDpvi1", "a" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$MpWc86WvXV3mmcDi2EilrIWezQj8bMPhvLmixn9rbZC", "a" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$Zw0RaM0Nza1qSgeY0CAyeQ6/HMeystw9giEdEoVpvL5", "a" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$nxyvt3gZusI2uBLDgB3XblB6OmGmvXHe14K0HDxrBX9", "ab" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$uccxmwfX5Khx1fgNOskLYfgDTIaHKosXJqf1xyI8r0B", "ab" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$4Ujzo48fXYH7yucGMBCepZ2QLZ1q430Q9hN7m9BgBG3", "ab" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$KBbPXLQdLz2DBYAa69uKH4PD/U5Rkg5TpRHO.2EJ9w4", "ab" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$rA2ewUHqiQH5Le9o318IWjgsADyZCgfFXofbx1T1NCD", "abc" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$Ob2BBYUSZZxv.dF1TN.HXtJhmy6vQN0WSQsLG51CNi9", "abc" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$U32OLSWps435lSsn72lk3zD0tHkCMmnE1GC.tOjVvW6", "abc" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$pHV99BN12dlJp3efg3FMo2AcCkn1BxLTrAVFGsoEFI6", "abc" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$4Q3X.Aa1nM7Dh2OKxRXyGzi2wxG7fQifl1KCU6vV/69", "U*U" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$rHM4vOe93Gz5ALhptVmGlWzNlRya6TW.GCvGK4F6BX1", "U*U" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$.ZOeFY689PqIb7QbfsIXjk1ZavWXPWzHuOF8dL4ej..", "U*U" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$FijVuNU6xiNbr6eEOe8nx2Bi9YFr0JPoXi6QRFRzl70", "U*U" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$XuwSVNIXXmZMEG47840kV7CYOAXhZmFvYYlaqF3CVCB", "U*U*" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$pAjwBjYeBK.43Hf3YQvxB9Y2Z7srix0j4ru4GROM6JA", "U*U*" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$txMiXkJXnt/zerIuTZRvBLhJwRieSxQuxvki8DHA136", "U*U*" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$peVnLo0H9RSddJBmXTGoeNvr6DwFgQilW4QFzugLAU3", "U*U*" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$HDnCN25CUyrhJu0EVrZ5QzQmgToRjNSa4eBkl2FUvH4", "U*U*U" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$KeTF4ZbYxwIBP37fuE9I0aEPjBxLCfJdMQ6sUT6LprC", "U*U*U" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$mIoEJ49aqX.gQf5en9Z8VRoR3qC2CcM.9hWZT2dm6N.", "U*U*U" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$vzLs6NYwaJZiNtQqVTz0ikEjNTgfbbgvpAyUDGDplg8", "U*U*U" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$1XFjK.4XTxLSXOWvHmfS0ruYkh0QcgJ54DuY31J.TF0", "....." },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$aAdb2TvgmWj8FD9SrSbPYOfHTxnrqoyiqxijhYbPRF3", "....." },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$6/CEoyynHobD/QRB3UrZabVxDKc/zUs5gUBg4nhBeA4", "....." },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$FN/NW0hZoGgSR5ecTC7KsjpY228f7KWYIm471Sr0aaA", "....." },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$YYXZgZLvT/Fq//Mz7PGZOmvN3AbIpZvAcVRDw9NIBa9", "dragon" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$ZUwV2z9FN8sZCVrlZURJ9XwyMJwRXF3vntPnQ5MZHu1", "dragon" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$eT95chxbg0ylgqXn4oyfwfNL9ft29WyfFbWm/mzma78", "dragon" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$N0A8xfgXxC1VDK6DQTvXIzpqpOn4LnHPDcBa4gEVzC/", "dragon" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$xBQklIKTd/y1bgctpBTm7wXqLebDYuWlMHk/9Z0Pk3D", "dRaGoN" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$tBlzdqC0DnY9byrc5Ig.ddeSyyceTgPOQatWIInjtk7", "dRaGoN" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$ykuSz8OGyu2x1xVQqccQKD.DazLFYi8M.Xdaog9hAbA", "dRaGoN" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$nziejcq5svxUfTKYG5klPySdQhjRz67LI.IM3SXB7i9", "dRaGoN" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$UGAndeR6RmXVtTFcoXIRX8zdeeKm.g42tCsazpxjkeB", "DrAgOn" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$D0KbCtU4HAOn7aVCIqXjkE/XKHqgHfjNlDYOkZmFJt0", "DrAgOn" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$V4xR/.Uw42fyGj2pHU3Y5pCXVu89geNV.nuM7DADMx6", "DrAgOn" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$dG/g0ZHy.MUyk1vbTdwIY0mWfi0kbpPbZC1vUO9OArD", "DrAgOn" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$9mL6PAtEdYliRUMm0nzwiAmyYj55hBPQYp8rvKIQW/0", "PAROLX" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$JOakc7TIzgakCcZAp/UBDc50PnIh.4FlYJgHTyoSLd8", "PAROLX" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Fh588p2obDNmfBNQ/EV1sk4Hs53o/bisQzBc/5yhIt6", "PAROLX" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$pB8toOQ2UvlJguN75WmxKyxKn1KmAVEcKESN/zn7mG0", "PAROLX" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$F534AsJG0XvZywHWgOom.rYJxTCpE3WoIbxYWhzezkA", "U*U***U" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$L1J4HMdo5s5xhJ07p1DCFwJlRCJbeIy0jiaABB0z8J4", "U*U***U" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$333I.hNdFC8mNGS5P89t.b9ldb62NsKz.mCQLchHW67", "U*U***U" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$hQ20kGu1jkeUKn1foc02XZnZoYzfU4D0Amm5Ksav6B2", "U*U***U" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$taYtFABmjxy9s3STG3dov9O.Senab8IDKoGL53s2hc5", "abcdefg" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$nQERoPAD3QmkSsmf5MYPQyKu3kfJJ2NkjmBHwnVxLM/", "abcdefg" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$fKZroPmyPm/kJVVqEN3Kv9wfjgP1tc4D8MkSFMyek03", "abcdefg" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$25nyMuun660zbmb99lNsRuPcp8Xnnxo3DzAp6/PXLg8", "abcdefg" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$fg65oPVYz6Xf9B5vyweEvTucFoRRRvxoy1.TV/163D0", "01234567" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$nyTxtgSjSCd7RUj/Gg5i.ZqrP8kmXGG2h2IZYuWAnDB", "01234567" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$341ZVXHGiF5lVl6/blvPdxBm9OOel8BBlZ968uFss22", "01234567" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$xYtCdSoCC6vOu7f1M3/2m06i1D.ypNhqPwIjLpygEGC", "01234567" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$pi32X.3SMRQItwJ/sGp08YODXnJtjZYj8bMCOsh6Ta/", "726 even" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$OdLgob98CD3ypkHaLiu1Xh5II3VkjCFxno5osH4eh6C", "726 even" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$nTHZRic2COBpxgavH6azq1eJUoNt7DQkDS28ZrkVSpA", "726 even" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$4WNlik8pvLeVwIklbldXHSgSSRbgI9smIX5qqxMVDU.", "726 even" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$7KI2qQ5GQnGJSI8Od5qIUNU.q4HbJDkDA6kBuGo6BC0", "zyxwvuts" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$M6Fa9N0S72cJkYK9FBL1nxYkkd3vt2o0UwVnV03AXR6", "zyxwvuts" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$tXyloQukxjTiFPgYlawck9zzEAWqyyBQTIA1Tw4xpz1", "zyxwvuts" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$Lq6FF9140PVBSlatimf1CL0vniFyuNEY3EogIkmgqB6", "zyxwvuts" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$TM9CWlgsKUa6ZAcmQfGhR/G.2DSdyUIatmwgb7reDv/", "ab1234567" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$DRcn5e4i9fjYUbpsm1x.j/enG.zWBo1BW53FJRt9pC.", "ab1234567" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$JnfpW7SSlTNCKcYyLzdfofJgInlNw3KU989DWPqhYQ/", "ab1234567" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$kBQlhEiwZoX5oNxAampnJBOlAR.rlPC/0LRvR76Sh26", "ab1234567" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$.N/7tWjhx.fR6e59F.o2NxduJZjJ1E8pHCrcWz7A0H7", "alexander" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$nZ5vMVX9c6f0nT7tANvfqZP1x9ozYWIdLjByMz8pcV9", "alexander" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$R7XBnNqBXSsH59U2NGEX/ZFHQcunqkSWL7/4.zt8rH2", "alexander" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$w5ktbxDWw5Ku6uX6xSUEomsAOpOnnh8is4M3kcOAoX2", "alexander" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$PRNbwnnrUqjIbhhmiUgn/o3346RxDleSZBNDJGnGsr4", "beautiful" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$fufvyFFBTbMXAV/94iyt6i5MBnMSt4.MGrDQejWSJn1", "beautiful" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$k8xmg9rXc3wzDj8a/IfTgQzE.HBsLK86ulxT9iw2f16", "beautiful" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$/OG6mE46AseMMBB5rxIUeI.YKyB7kVypQRzcpiTwYy4", "beautiful" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$c6XUPc/ba8IPvtkqlpgeZuBzYa4SgXquMTklvsFLKh5", "challenge" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$gSBwQeI0Wgp7.TQkANKIj97jS9lVIZcXypdjcy3Dnt3", "challenge" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$U4x136Pj4rUNdV8zQNu7O89favMuqAiln8DIcMoKF6D", "challenge" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$Lv7LGEmtQIWQfNHIxBYntKXn80DVvUM7Y98ITJcjFv9", "challenge" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$hoE3dlo5O7mRxczAY9FY3yNmdQ2HgJi49Cf0Ff6cNj1", "chocolate" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$NM/9ITZ9mrzlW2h.7AsaY4qyTThoUq3VfgQG8MeVte5", "chocolate" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Oi.5kWmhn8kQLKgSPS.x/BwtYx11w/5LetyA/lCoBw2", "chocolate" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$sraphl6DcEsU2rhD9XFnOwGGa8KfSUQd1zc6kBwyCZC", "chocolate" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$UqoBiLh7Bl4B4gfH9bgiQM9rFqyQmBmXbe0qeBOFJK2", "cr1234567" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$vbL9wx4r6p3DUH2J3nbTvSBjD.avTsBM91dLPvqfbB8", "cr1234567" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$OKdl4kX.79ghc56.5cYgz2w3TKkO9gYZUrRG4Rw52//", "cr1234567" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$l7cf63qpDl6T3LiQe2BflvskU.ROdXVoK4MRMfv5kN7", "cr1234567" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$YXMIdEZSCGd648XO.jaU2OZw2wPzbC3myNMszNiOJ6.", "katherine" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$B/SvUAXb2bDV7Xa4iT12iTFaoZbxuS0cPhCx6ZMRGf5", "katherine" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$ej3pc7JZsxTEL1LG/iozcwzpKnjxE/PoGNue0oQnal7", "katherine" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$ajehP5eUVHGoxDinu8h6NfckgTJ5U.OLPcWQVh5yjj8", "katherine" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$HLqUc/WnXFNg7GPTV12IEcHKOylSVmxZpPJZl7/afF.", "stephanie" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$4o/w3sLtsr2K1nXhH8Acx547tRvzMQvaiIVNjqnROo7", "stephanie" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$p6kJszVW2oI3svGpVuNdbE81P0wDogA8Hpk4l4.Elg/", "stephanie" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$cCroEV2lIJnaHrahnL/ElJzC.puOvmcWS8fTS3I9fo1", "stephanie" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$njjDZplG32S8RiKRjgWKy9BR0Y0H8s.v8pfL2t7fna8", "sunflower" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$teVxXLfTZnUrgKWa4UKfM63CjiIl9HMDXU7Q/UlhYr4", "sunflower" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$2kI19jrgMd7dCvxGhNY8iwRI.2rsyBnKkfGm2rOfoAB", "sunflower" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$qatlAf3zxNz5lViGHa4AHS43iTPvRDmWAUebVWmVMQA", "sunflower" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$Ekq0X8MbuAPFmmRslhuXGs6f2DeHB92.vqoOc9UzQY1", "basketball" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$Gx6qFfkffYkppCG595hoQghzIlkKMm758Ain6ZOl/e0", "basketball" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$poqCB9FzryUqt9SwOanhMqFSrSMVNqX3AZ2MQAlDKYD", "basketball" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$2wWjAXu2TipE3Vq.AYBHPEVcKzqEl8tNxr5X3H0EIV0", "basketball" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$8i56XE1WIQF5lUt0Lj/2Vd65WRjT4av6tskB11UlUBA", "porsche911" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$c4rVR12ojhvXB61CQxWYliwrKASQLUTXQRTud6PkZjA", "porsche911" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$ZMStbvdBwprrXD7vwityYtfYSoouHX30EpgpH7Ed2t3", "porsche911" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$65HtHfBI7jDDE.LFRQKjpBcIydiasezxFwuqZZaAKR3", "porsche911" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$QPRooF05NKfdCkLd15NT8F.m62NYsYTOBwgDMdpG5cB", "|_337T`/p3" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$m4KV6Lcbn0fQhymntvugJzx9IBPcMDlONZm0GzwLpV5", "|_337T`/p3" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$KtLvwzxUPkgnCZSdnSFHFDHFNGp3KeWvW2.COP8MGDD", "|_337T`/p3" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$eumtcwyayLmZp9hyz//Yq1/XIq9EARblYosbO6eJH27", "|_337T`/p3" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$bJAURkxnfpTj9GZYBWxHmt4ZYr5yroCxfrC4PYju3tD", "thunderbird" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$9MxC.Inri6Fa4fYwZja9tki40nMuiPlxz3mzoL9B2E8", "thunderbird" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Tz/UYdlyCJZuH4um3d6u/WQMAHqkXwhHUpwV1..Tqb7", "thunderbird" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$0q8VEiDUanfd/J4j2muPXBFciBihy4G1cW4bVRa1/rD", "thunderbird" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$Pa6kHw.dW3mLTQrRPyPgMDBD9J2Yot.vLuIYEaVOX7A", "Hello world!" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$Xhljz5ONFk7loiwSG5NnUO1CJHNBHOKVMXCoxiWhfD6", "Hello world!" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$6RCuSuWbADZmLALkvsvtcYYzhrw3xxpuDcqwdPIWxTD", "Hello world!" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$IU4UgXlHh91C6vLfqAIjp4AYrf00kYdb3NnaiI0Kt91", "Hello world!" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$FL47naUWWFfU4BgZpmi5jyAAd.plDlfh3U7mufFnrN9", "pleaseletmein" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$kop/QFyf0Ho4I7Cwa.UrbCLDcPqPIeiuftPB6sBawE/", "pleaseletmein" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$cfJY5xu50jB9G/6suGLwfsVVnMpe1DXE7VysG79iTRA", "pleaseletmein" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$kZS.oSc15a/RZAuyk2pS5.V4Y7Ty/46ySmsU2mwxZ00", "pleaseletmein" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$wA3gPvI/bAv7kByrKbiMHvcqugsxvMF9cikErohj0m3", "a short string" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$5j53g0ADwVUooubjKLpu.H5K9DNkhfPnxVUco4XUgIB", "a short string" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$F08Rb8imuSOATNNFxg5RwN3TK3UNlgZ0kdwa.0xY.NC", "a short string" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$BvscFXRN0ds7Q28C2Yx8n4Da.otvCG8qO5vh.A2lRF5", "a short string" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$hDrzE9tpgmDqltcbBBwZZvBYwegA4YNFKSt0weSI.v8", "zxyDPWgydbQjgq" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$QkVf2FU7mv2sWcgJb3QmKfpWjYpu63g.Rb0yxrgo6E6", "zxyDPWgydbQjgq" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$SwA/Mx9kiH1m9Cw/47r8C4unl3CBE6qmon5iWJGevvC", "zxyDPWgydbQjgq" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$mHT/fU8JrTB0RLogTbM/JSaYCPD4qKBLZdMid2ZRVk0", "zxyDPWgydbQjgq" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$m2GKtR5fRtzbmc82jxbyILOn0UmGWV9qPZciOOGJ9J.", "photojournalism" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$u3HEKP5RxNhNLwT07o56ZH7Zvj8nDCbGyALEZ0P2VB6", "photojournalism" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$6HadTv.Cnm7cJAJJrrUTM2TSH8weeBVNkRmGcw3LBh7", "photojournalism" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$fCtA58ScMHvYadFMh4Ph8fgrq7NEl0SdGCEt/Kb4XZC", "photojournalism" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$8TfxxaG/1QWTdtSRMNl8GSrT3Z1wsxGGFGcCre2aNb.", "ecclesiastically" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$C3mQiPFk0bZ6FoZS1X88P1/ODoZB5aFTuMw2opLTw15", "ecclesiastically" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$hwAWuVrU/4pt.hGbSxMdNQ9KIsbuNOgtdrKEGm0rnr3", "ecclesiastically" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$ip29IeV7nQEW7Jb.LTdzDC08S6WSKPY/AY2UvVg299D", "ecclesiastically" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$4JY9H/DVzH52xHjvEp6i.uKxsTDgsFFJtQaZHDMqGzB", "congregationalism" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$l2pX1cF87NzGhoERBly0mVfzCJeecSM8xCbhCDkLCT9", "congregationalism" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$vNPsGPqzz/nR8uRKdfOWPh4Q1HDxC3PEUN2aZJSMAa6", "congregationalism" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$qN6WzXNQl9a4jkIXDux9OpIxv0.R1jebzplWOfmWvE9", "congregationalism" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$go./GUQM8QwIngLU3/EsEmFNbvxT0FW4lgwMrKvKbYC", "dihydrosphingosine" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$jaNN6cmO0VUlPJEDo/wjbpdhA5/BkYPrxreRBUAKcM5", "dihydrosphingosine" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$f.gxXdq9s8TUmuvTNp/O8HoEP4RWJhYAM/Fq0DB4wP2", "dihydrosphingosine" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$X7e/Iv/KKc.O2K8tdOIiVZTy/JJDwoUrTGYrmFQEmTC", "dihydrosphingosine" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$HU/Lo4YeVHHcWJ2KSwwOmvqrtxvxhLj7E0mRwfrYCd/", "semianthropological" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$ez.q6KGYTd4SZi825mrlC7e3jcbr8lUqcJKo0X45fk4", "semianthropological" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$rTWQeoMBv6t9zOvTFa3ZhMS5QNx.lHudyUZSpPc59h9", "semianthropological" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$WH7VNghB2xdFo4UGse8JYAyv3/6iTdFdWpe2b.5Sd85", "semianthropological" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$jp/cWYbbtwMQhiwSC/24ntbIYkCnstA821mOgJDiNp6", "palaeogeographically" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$m.FwWSsKz5Ebeqp6OBqc5Tm5ysE75C/flqMAUDkmFsB", "palaeogeographically" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$7iCK499PfIK9wFP6JMC0D481JQM0O0Tr37ZRIt5PdH7", "palaeogeographically" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$IDTEwM8ID1CijzyOqRlHNbtA0FJ6yAytl6a/5sAJYBA", "palaeogeographically" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$PjX1TR7utV.HK5vM6RFrj8rhMzbGRqVNHUrf9v4RWD0", "electromyographically" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$vNEbtelA7nXFyXK7DWayr/3M0ZOMnguPR/.1ih/3xm7", "electromyographically" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$dywVqkxVM8yASOR1nC8uZ/OTvByy328f0G2.u5jdLS1", "electromyographically" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$o3hBf0JXl7fOu/O6osYNSi6HVk0Sm8gp2JO5Cyws.i/", "electromyographically" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$aRNt242V17/4M6WrFNidc5OGh65D/5RwJ7UZ6cxs/e4", "noninterchangeableness" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$IP0BmdKNDR22hX5sqJqhwNyOaGxxQGJBuhCNoob8cz5", "noninterchangeableness" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$J795RjQ9UE43OIeIDhtTPTByoNrpG/rosxRVK1kcze5", "noninterchangeableness" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$lypG6VWS/x7bRMT2Sula9DOKbn9Kb64h/AaoYm8GT88", "noninterchangeableness" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$6Z/ztHFicqTviv/runc8zvzbNtaSQnxGg2f5BXZME9A", "abcdefghijklmnopqrstuvwxyz" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$FrbF.1un9X4AH8C9ZkT4Ix6X1nlANgLFVuCz6s2TaQ2", "abcdefghijklmnopqrstuvwxyz" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$5CNbkunUr.BKoN.tm26ttEiP7ydrNDrI.tN2nR7O.fA", "abcdefghijklmnopqrstuvwxyz" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$6M2o3he2TIIUqRvPhrgftFV2zOHNixPzB7DeM4WIyVB", "abcdefghijklmnopqrstuvwxyz" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$a2p5myGBwXGcQPuog9IJNm.f.m5LDjrA.CAbO7jWmZ6", "electroencephalographically" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$2D0zqCxOl5/2UtqCF0VQW4KJXqqpn.6XT.HTkTsw2EC", "electroencephalographically" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$/ubRwa8MxujkX4QWuNYhs0Fje1W1oNjK78oGPV3UYt.", "electroencephalographically" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$DYWk1yH/lZd/cYmh1EYRnyPgzu2pHcCMMQ3jks8TbC/", "electroencephalographically" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$K5fvmYZF2QH905s81hkgHHn0uZrKzudqqi7ahWXxmx.", "antidisestablishmentarianism" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$sLI7RjV28kIqCrQwUx29sP64MeVsrTHIYGwtqZMc3vB", "antidisestablishmentarianism" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$lf3Lg3dBDp9p7meEgSGba2ncZxNkn5mQahr6xHX.812", "antidisestablishmentarianism" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$7jF.Bp2lVghCj9hi4xbegdXuiS06TDk6i2ecFkrrqm/", "antidisestablishmentarianism" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$Y6H4YSAz5tCY.dPLDMLDhsVVOrYElP37dBi6vf2GZmA", "cyclotrimethylenetrinitramine" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$GsJwoF7seuSByJ/L30pth2M1ZyM3pV944kkVtAuViL8", "cyclotrimethylenetrinitramine" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$wFq0tGlna4j5F7lV4c2/XC0RkEfXG23N1BPRQ1JoD.C", "cyclotrimethylenetrinitramine" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$xc5rvzORo2dhP9REc1I40LnXRKrx4drRmenjQGh8BlA", "cyclotrimethylenetrinitramine" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$t4bM5DCjZ8RaSdG1Qbw2cLOVg.IaR1HW2RJxbSeXRQA", "dichlorodiphenyltrichloroethane" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$WV7JA0NqJqyjO/mK3RorUe10CIqbNr4c96n87hTi4R.", "dichlorodiphenyltrichloroethane" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$uqqk8cpOeRg1voybWeSMtL.KefcaS/l4JJOr7na2rl9", "dichlorodiphenyltrichloroethane" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$ciTG5kwtd7cx5QkkJ56sgiPU7jqcozb0XTXvgr2SMQC", "dichlorodiphenyltrichloroethane" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$YNqregTjuxWNVpj/YQMOnvBaPuJCWNloXCLoTfcLMeC", "multiple words seperated by spaces" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$Yuypa7VvtaKE2ey.uc80Wujc4NXRbM2b5.FX9K3dvM6", "multiple words seperated by spaces" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Pokp0eFIyDW5sbDQqg0xPQ8cOS500eP0jM6o.zUeHq/", "multiple words seperated by spaces" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$G8eyyx8QzNgoSpEPyi/hi7DhcRkP6DGK7rQeVLP.nh/", "multiple words seperated by spaces" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$EcMTU3Q8SYyE6/pTTCM3cIQqpAZgQyLVAcreJ5yHPy9", "supercalifragilisticexpialidocious" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$/hcEhkxFZraFqJkQ2ysfcaqHJOq7jhwK9is./c..7i9", "supercalifragilisticexpialidocious" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$RSPHt7ENpT.WkuEBVt67lSATvV9gXg4pvuOpGl02yrD", "supercalifragilisticexpialidocious" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$/ClChT.ZIFeogGi8KaKAJWGRRabtWblPRyYTsr03/V4", "supercalifragilisticexpialidocious" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$mQvSFc4wlX43dWlk8mrOGP.NBvBe8TgBKTx2.sncA/.", "we have a short salt string but not a short password" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$FJQKB.aX2UW3BcossAqf60FPwp5AkJVo16hOXiZMdI8", "we have a short salt string but not a short password" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$FPoSNbUDYr4/nDrQMd0Rz1Skid3ByxrMJMsWxRIRYRC", "we have a short salt string but not a short password" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$oAt.ZgQBnQWSYgjlCVmIk6.nVWUCgofJBqYC8LRjBI1", "we have a short salt string but not a short password" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$2B8UJmSdErl3QM9.6VniqtE78gBAgJkXMAWohxNaFPD", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$a/hGXCrV1A/vRTnqQttNVcmUca5Zuco02TYEhBpmDR/", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$DRystZBkjtpanszSepAb5QEK4Z2Yx1cx5b0a877QGK1", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$PHKwM5ZynGDjb9WFrU9hUKo5DRkDtoBjBYHnSRo15w8", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$rhtCacI9n9hLTXouopGunTofK4hDbU3PYZeKSbVlY5D", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$WejmLB8lKuz4lbn3x91Auf1NeJqjWao/WZ7QEbHNxi6", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$xlAhWCVG3.N5KWKihACVhhKVTqAdjJn3OXAUOH2w1d6", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$ZcffqmwmwVXJ4hrrOl2ccbxyILWA8i9W8SGq25fOxyC", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$xPwOY0J0bDzXKxC0JwB2k80WxyS.jh7j9XQ56Aqk.L4", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$A.gR7E3BN9XglvFRbrybVxa7eeVsl7yTsrTieeuVchB", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Rr.CISWFO3kIfAoYFz6TlsyG2tECs1k2EQSpyr7Js42", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$TrjtpKkgWB3fi64Nlyi.tbB0xICx.VR0kGEVvpNQx09", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$3SqImOMqMzXE4/zdnClNr7Dw4W2TsSt07i04tCdW5f1", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$9KQ2Prf52xPxP.aQn2pysh36RwqgzyO02VgjdybHZHC", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$h7I1Om/q6w/QXeFJVqHmT19MvcpIIkxG3Esr5DBFFb.", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$zcNvuFNNFk7PMrZRDtkoY78E7.hX7OICcpijwJ0FT90", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$pjacT/KurWRCpgdpG26NevciPkApHNYYraVVjCpjhE/", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$NTj4yc.//IQhWSB..IjncFA/Te9O5052FOn1PneoDM0", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$k8JOipbAgIVak80YyDTLGBLBlcnefaR0KhERsNtrLF5", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$3bo9Pp0BNPLsRiR/1WcehPldb75WvwVE3/2LEWJFk50", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$KDvVoMuQcdyc2nxRnXTkm5.2FMvfGM6pYPedrQAyhQ5", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$tOC2KTCZEv13vRqB3LNM0Z8cLsvnJbT/3t/rtxkFla0", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$G3rM/Ys5HanPSdK23EYc1lNJWzq2oq5YYw21M3iNWF.", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$NztksAWS0wdtgwJhi/wJtFGAUKl.BWSWv8bJGr9pOSB", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$9.vBK3LWbonABUZ68LXpCEtckCKHKrIiT/4Db36AKm9", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$DF7yocLwCmjinoChDQX8RVi4p7F6mL89n3pRzoyEJI7", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$.mVbRdHx8JJsg9VZk8NIOIKgz3nda.rvEONL6zsxqT1", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$AKs/pXZzmbVU9sajD34dnNWqqwoNBJvqrkFLUnyv8I3", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$NmfqUx9YVDwmgkZ2sqoMawWDmfJZfuIUbIkq9dHu8N1", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$rcr9jA4UGZ0soWuAYmEewePPOrdWse4WdwbZKDjnoS3", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$.d8ucVrbrnwo4inw6/EC4O.Lb6knpehq9R6VmkEurND", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$jseeqZpGRxS02BBc67/vYDvxd9pUdXHSx8VLwOlmHD6", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$q/H2LjdeGHR.IZzMolMIjty.yE5st5UXtW4oV7.68nA", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$PW6/Hy4LSC6oWoWPPvWaoNXTTFNecyiDvtGUoH6Ehq0", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$XMViHj9DBHI6MTk7Q1Qe.H8/uZSoqgoqOkTlrepLSp0", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$/nj5uf2KAThGKZ7jzVRdPZETr/NzsEDwO4dEdFJ7JY7", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$3KCmKfZxpkCGt0icqULgVdGPn0GSw83vkiVDsqq6D.A", "\xc3\xa9tude" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$a13CZy/fViEqrCwpjVseQV2672j/7vKG4wPvrUFK/9.", "\xc3\xa9tude" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$bZIT68GWYwWdrio4orp.Qq6ITlv4qfdeQa2Poi0nRn/", "\xc3\xa9tude" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$4DpCqdQg0PkJtLKcTqLvStVM/FpGiWH/Dbjxs1ifjM2", "\xc3\xa9tude" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$.2xRVxrlhADx4W3Be9rjdNmStFD9FkS7GryviSRpIi9", "C)tude" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$Vm9OJsQ/TZ6T6GKEU5yuRbBwjTvcQE.udXfFNYt0Nb0", "C)tude" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$HoImpxJb5lLYnEVGP66uGBOOobHn.wmyL3nV8isMWE5", "C)tude" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$2ynxM1Y/swCUgaFje.QumENYy7Euu62vm0EVGGeBlr9", "C)tude" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$g7VN4eGDLfJHMWxah.mlw.vBaxt42LJ7ajZsnOqH6p4", "Chl\xc3\xb6""e" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$oTwpW4ct8VT8hrO5CdOhhH9nCJNVf8t7pzFZ3ifT/CC", "Chl\xc3\xb6""e" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$vfJUIyCBz0TumrRQo5ZiYD2FfzVrVJ8EYrUxLHVi6n8", "Chl\xc3\xb6""e" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$IiLivkLUbmaE2qe6ZcVOqY9.6Sgd0eHEV5qny6PAjHC", "Chl\xc3\xb6""e" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$dfGe19y7IU2K8qJYWCCfJ1ilzXvkEw9m1vG/98VrmW7", "ChlC6e" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$vAeLPzOys4yvNMmBG983zhdgYVbhX2CH0ACsM0Ir5KB", "ChlC6e" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$5Nk62M75Yzx.x1QCROF1Cs8k4M4lsujK6NUpsfCKPP3", "ChlC6e" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$BTN0wDwMLkj6nYLN4rpGnfyVAel8cGpS.tazNGdMt3/", "ChlC6e" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$qZ.aufR92q59TpKyCZyrkqEJI6DE6XU3l0HLXTsns5C", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$XDd9nXiAN2RU7bgrzEFrW1bVoeqvhehVlfB5fwtS0DA", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$POqI985fRfZBF1exbe.Bips1aPXmvX5sQzWEpCc0Y0D", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$aNkolPAy51qGOJrfiudBfHralwHyxGBRHQnpd7/zEo7", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$2dKNRRHnLbPCi24SKdPjC0PzbjHfs7SDQtNxCalQqN0", "C\x05ngstrC6m" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$esWj6taRGsOWBYAKqJH4zQW6BTahcbv4MMG2YtYRUn6", "C\x05ngstrC6m" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Yf1bfyz.IbGLtYZzBiWAu32287l0XLSJLpF03lH.I/D", "C\x05ngstrC6m" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$QIhH0l6gfS4LHUIiMlE.Kjneuv/iVxZZJIoTLO5jhP9", "C\x05ngstrC6m" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$yki9u1ADIgZnsfPat6zxs5pe1jSJrNQ8bFfDUsD4KY9", "C\x05ngstrCU*U***U*" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$3Gb.ohhevoNHXiXqYKs56liWBEdTUyZuDnwUAEz0BvB", "C\x05ngstrCU*U***U*" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$pQuebOxfI1RL8zXNX.k20UF2xKvQSb3KZdmoh.bqk1C", "C\x05ngstrCU*U***U*" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$bQsT0TqgXR7R91mEUfIs8BZtR07qS3kos9D2Gi1vde1", "C\x05ngstrCU*U***U*" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$uxWb8p2E9EIevWh0QlYyUzTXYumWuNRzC/zv0U0itb7", "U*U***U*ignored" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$LiPBfbT3vuZoo2RGj478NobNqMiOU.btR.3Z5WxhQ/9", "U*U***U*ignored" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$mZo2OWmexe4iPNcHnl/xWin1C/B0UvfSxghOl4jMkf2", "U*U***U*ignored" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$eqEgDtav1GjFSU8HarH8BeQvi6QnYhxlqA4dBNLrxRB", "U*U***U*ignored" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$CWKgdzzvXINOu7FyuScWgSehKteRBj4ZIJ6a9y14Q.A", "U*U*U*U*" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$sxwi.gem2FV.cAzGukNfO/skVQDNbyON4uakXRxSq31", "U*U*U*U*" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$6CuiX1WtwOj1GQE3ztY24bSz4.nJfpbJHBZR5rrysE/", "U*U*U*U*" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$zTv/7GsE.114IpbG0TMJdzViJJmTBacnMcR2ORHLblC", "U*U*U*U*" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$mptGIXs6YXZrX6U1BZaQZw1ZGawz/JcQlv9GT759/T0", "U*U*U*U*ignored" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$04LuGv/hvv.2/358dG6cBsQp6bO8pLmGqIkVs.e8kO1", "U*U*U*U*ignored" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$NIWB7f5tOCQI.cA6E.Ipv.RC4JW7z0U1sFy7oIgftAB", "U*U*U*U*ignored" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$DlQ.1QPVTW2r3xt7WTQoPkYRlqBJKz0kkKUgnenKcd2", "U*U*U*U*ignored" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$sodhQYgXM5uv87RbLeojt1KIcDBvqqUexBqm/D8LsNB", "*U*U*U*U" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$6yRZiRc7CmZ06AB/4WxXx7PiyYKcNcjKr.gMLoHf3.6", "*U*U*U*U" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$hM.3OAWJnsUpneaLT4Pr0UZtmE8CF3WNELMWsW5gN5A", "*U*U*U*U" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$8e1KHuoQAUGgsmyIwDlLX0epF9GSg2.n7zfkwrJJ7M9", "*U*U*U*U" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$zRqDCuRKAh5IJgGuj5NKHPNgBIwBxt8Ba850jlQtTf9", "*U*U*U*U*" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$154rGtfeDV38jMbl02Sv/nfDCo2VjW/JxQRZkbnBv8A", "*U*U*U*U*" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$up2bu8DjvhIwbuSGXA38uUJIDFk/5cuXBZQzB6P/Lk3", "*U*U*U*U*" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$IsMsxVJrwQ9nCHbwKYhsNHQY0qDkVmbdLM2OviR61w/", "*U*U*U*U*" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$k3dFp7/Ayj/TWDNWJiyMJTCCyfAGhD5VTNMMibim8yC", "*U*U*U*U*U*U*U*U" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$5n3C52cgbhzxpqS8WDBcwTx8grFGxbtxLNPdUGEQcE2", "*U*U*U*U*U*U*U*U" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$RSCAF9dDWvYidRQ.TuM97SiWE/eeOFxEaPosbruJaQ1", "*U*U*U*U*U*U*U*U" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$3A7pimvxSBj.yVkrinakd0iq1LHqpcHKVzuKnDfW2gB", "*U*U*U*U*U*U*U*U" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$WJVlgoPpUiRngzMyRW84qrfKTIiUhtOjDkFPKOesc27", "*U*U*U*U*U*U*U*U*" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$6BJR/TAUf/WrA.mVRBafKccfX4CnqvKZAWgdVeLUdu4", "*U*U*U*U*U*U*U*U*" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$TBN/HcqjW6kYqtl5Hv/F4Y/KX0Rcv8CKrKvpZ0xeyk0", "*U*U*U*U*U*U*U*U*" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$.pnAxWGkq21pbyDsPa.85wTmcIM1izrMTvktrnWxWA4", "*U*U*U*U*U*U*U*U*" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$p4wA9dSMVpCgy8SsjcMMZ3BMCzA4HDLynoCwLdP0lP0", "\xa3" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$iL7iOoXcKINoapC.16H/91vNKQI48TCRX0C5Y3QHz5A", "\xa3" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$YhrI4mEX7dj.e317mVqg9g.w048D6chil2wtEIWtfdD", "\xa3" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$4c228.rgY0vBrXV/sYCqPd8.2aR477Ax828HjSZsdRD", "\xa3" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$s1XIbDy3XUuLwjC7/nZBafvsCzgHzP7s7BfOtJRqA/6", "\xa3""a" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$xEYiJNE8HqocOmXep1vM/TP7ouZB.M.fj98wHmLB6BB", "\xa3""a" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$K2HdSa/5QObAoZqb3S2vAxC.UuBlBGJBv91LKutYB8B", "\xa3""a" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$r.y93S3vqSBqE9sMGVA2Q.CsfQp9TD/TNSETILtc1/A", "\xa3""a" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$2wl3x3cTlQr1njn1mCSPTK8XWhQq3TOQWrVnTW7gniC", "\xd1\x91" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$yCYFweHyHiTTOnmsJmlySYKuQxhDWuoj6oUM3SXKRJ.", "\xd1\x91" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$ylyh7bDLIvuCSsrVlbULqvim.gYyRBbeLgVxSs2hT1B", "\xd1\x91" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$xiSWfCR4NKYDRCuznfM4nl3VE8kTjRaZHoMbw9JmEF/", "\xd1\x91" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$Pclkzl5B.pvlQY9Jn8jf2ZMutEA3SYZ63LMGulcsw81", "\xa3""ab" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$d90R4yO02ebyY..oOa0ERhXJyRKcEyR0iqhyfgzRDM3", "\xa3""ab" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$k89zyHcpSe5LUbxolcCS4LCOwyn/s98BI7Gzs1mUkU8", "\xa3""ab" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$jq.SxQhWGw88YUuyBn6Sk99mU7DdogDYrxPncymzR60", "\xa3""ab" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$iqupg7bxbFLJaRvnaU1QpcqN9C4emrG028Y5dXF79G5", "\xff\xff\xa3" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$IoU8JDt2zoHYjvt3Qi1SQ4QVFWNEjSqAU8kb1prsWPC", "\xff\xff\xa3" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$5HNA08VC5DtYdXDDW0N/TnWB/4UVFEIEaXiTv/HB7f1", "\xff\xff\xa3" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$rHdbmQn9Sl4QCXgq/1WrL4odQrwTHB/CUfdnUCtDQG9", "\xff\xff\xa3" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$lrdwMw6.Oj5x/YDFs99emPTYwxlUcEKixin8Ajv/vF5", "1\xa3""345" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$Kk7/1v.5tDssBFg7GOHMB7gsmEasYxj9Btfa590cV22", "1\xa3""345" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$LiNtJvS6RI2YY14QNkkMt1BjSoANheB1rLaPp/edJP/", "1\xa3""345" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$tHrFViXPbqYAL/fhak4wAz.ryg59mUAPlrI6raR1bdA", "1\xa3""345" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$HwXXJ8rEhvBIjlGKO/o.uIorp0Zh8SPCg21H.t/Akv7", "\xff\xa3""345" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$SukeoARm8wGlkmUOjJZ9aWpD6b76xYoEsJXxubXowU2", "\xff\xa3""345" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$F9bYz0My0dUbtFyWbQ1wTPdnC7snkdekogVVMa/fP5.", "\xff\xa3""345" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$9exqorR1VFRtNsk2UoedwcWF42KBF/WV4ZQlok1idQ6", "\xff\xa3""345" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$oimJbqeMdws5mKcOVR6mKuUhwoXXHGZes2uEbvMEVh5", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$O0hbPALHTrkRvEy2YLfsusffWOgw9KCRZ35lIwzBOw/", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Ncf3nAk7XJ6tnhZ7T0kOk0VmbJqDNYYWjJFViE3z9/4", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$03JbbcLkNvmiTo32nJEkfFsDozcXpBscnwrjN5IGFZ.", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$QJ51gEgjm2aHVjuarsCUjgf1dwB6MXk6mGyYMQsAqg.", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$jt4jKr1UW4KOSAqQO6welW6OzFdIdyI/7bCxNHovJ8C", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$g7ZH2A7haq9rUKI2ti3vBr8yK9gk8TSJ2cuAxfr4U07", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$oXjTkK6s8Fu3xkG/oejXOK/hnAN2ZGOF/rv6pDE4oG1", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$TA3Teg6WZ.uK7AuKTMIAwSIdpCztyWlh89LMzjN2xTD", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$qff5XdvTAUMP24n5eI8.n2FsEhImceo.mVGhIT0OU.6", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$e4tvO9ljtjgeUstCxTIrtbUAUKR9wAxfgs0MMf1WIb3", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$IdsEdCjCB.UY.518v2xNpPZAX9/ZgfhdUEBWBNS/gkC", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$jmNpRUqvFuuujRC04KafxgGKNXlMDihpcL53rhAOQE6", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$krUh4blLghyzjKZS6Z.bTKgtAmNmgBfVB1Vba0n4Mw8", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Ecn3a8M02DQsMJwM6CQnSQey42OwAJP.wqE9S/aYG.5", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$FRljXSTGQ6wYCHg1ySOIXzriIFG3pjz4A0zkO4eGeO8", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$64auiZLkLxSrfVQ1g8aRcHWGUX1mg8PIl8otpcZMM06", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$fX/bO8RXJoICvyG.B8SSDiHCOv/RgUsoEPeGXuts5mB", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$XgHR/ST4xUshi9DmBVLVNv1bKsB1Laq1LVQJIN40KO8", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$DpLN8ms7OTxY21AXBTxuEDxehhAwhrYPPEl4S/Sw/k1", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$U1CB2ppd1uqzgJceMKBwpmVM4EaEspYo9a34QjCj5W2", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$qqCQmfDh7RnBdGX.kMWcGL7jNZsePB77qkSVXa0CF17", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$l.ZWCZzt/KDvW/a9FZ43oxSO65hnvctSnH7n0ygghl1", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$5cQrS5c7E4w/AbGecOwB/cUGjRPQe0zfVpzkZABbDX7", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$JMwMZydqHG64EVV6eVII6RAik1WyuXl1H2n298BXrH0", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$iO0em06EO3srjRcqS/AA18yna8P9CEKENebHo8HUi4C", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$5kFTvPbIb1qWj072nOsZ7PNhyQDhspd.CplRn7U1v1D", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$QrLERZbdJXMx1vm6qQx6G6U1fetwVv/0G4Hfhzm1tl0", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$grLfsJRKyft/TIBZSRK4sd0sSdqTC2ULqmInAJlAVx0", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$Sz5MjikaOXePAN37FBpkNudmGy5aCj1.bIPXMBGt.49", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Mauhc2OUEVflNQwLhigUeZfSZuxoHuF3JyVUVOPUn63", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$Q35JDXMX70cuxM/Q9HXhVXHwt0atD73GHTmLi3do588", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$SlETijLqYQk6z4ked1kzp/IKvvw7caX7jsDTrWfUkg9", "THE YEAR" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$fqSDVO/JdpQqciZks6eb007ke8dbYxt3OPpMlcoE6M9", "THE YEAR" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$Ngbb.7tnFl7mrfVWvdGNXLEoRXxrBSjkGVqWYXHLwS2", "THE YEAR" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$mbennzyTb/5JoOQMiJ70gG58rQmN93E16kZXx9/pBX/", "THE YEAR" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$VR3tsd3dYK4W7wKt.JPOvIsLuFyU9D4qfX.wz3XKOBD", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$WYG.mkN1Edu1bB3sPH59eTCJJcyLUvdC68KRvjCJ3YB", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$2HUfCEytJ9jLNw3FwzH/hsWdEYldzoCVmjioGG2UA85", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$.7mnyO7YSmWtn9P8KqfBi4MjktgyFWS4Gum640PPsZ8", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sm3$rounds=1000$saltstring", "$sm3$rounds=1000$saltstring$Dprot0iG6OCniUDv9gKPN00qDvRJ/j/oKenbdLasiH5", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$sm3$rounds=1000$short", "$sm3$rounds=1000$short$4NJ3XuMAgEyOaO89mQwx8Zjn0lD50ed36.hlzbWppKC", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$sm3$rounds=5000$saltstring", "$sm3$rounds=5000$saltstring$O78Q6GPpi6Lb3A6C9MksIrreHNG6RZ/cQrt6thummE5", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$sm3$rounds=5000$short", "$sm3$rounds=5000$short$4r1RgwZCB.EQL/MJnaw0hxGdvJ0aFp3Wg0FJf7bs6O8", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // sm3crypt

#if INCLUDE_sm3_yescrypt && defined TEST_sm3_yescrypt
  { "$sm3y$j75$.......", "$sm3y$j75$.......$jLlybI3.a4oUf75jlH1cAu3iZ25uTH7pMKjmVkEoO53", "" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$kdJs7YYSxwI3HVtd9/kSgfz3NlXfMCMXy388H5VEnx9", "" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$uhXpa0SueOn6bHISmg/NqaSlnLi6X8J.BAhuGbglIN.", "" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$SSYCKhmjBZNUoJjsTiZ1VABmfTPhK6Oyn/hXa28noO1", "" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$.c6X1EvaZx0mgCl5oqsE1HDp3BnzTPSKGUbfgDchQxC", " " },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$5.SnkPGwZKuso4PZEE/3BhF1t1ydAvREolfxqTHdUP0", " " },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$DknrdPf/FJ9x9929mIabJU.kGWUaWFiy9cM3nLh2TK6", " " },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$Os7dzGeH8dHFWRcqlRC58M2deR/bJmJR9/VtDPeyIzD", " " },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$7g00F3CMuQHic3UfpjBpkCSThg3x3orBTkxTEiYE5w0", "a" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$Bhmrgu6Ijdxc7zW5/YXKy0V7XQyz8Lss6T3XwA15sU5", "a" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$mDAgxdokxVmmHY4izNqif74VtpLBO3xUjMQmmATGWy1", "a" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$Sgkp3thH0HT6S0NqIlu4rch5blOcdEYnXlVBC01SUP6", "a" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$MKqfwnVesnb48IAZb4nCl32Te3v6FEbr/ZqkhW0j0GC", "ab" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$3njRzLMJCMFr9obSumTxlpwLWlVyVSaTUrFq0F7hwX8", "ab" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$Cdp.AsRB8sGGCplmkWCUEgNTx8BwY7/KFUjF8d7UuA3", "ab" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$KFODRPgy.RJZ9z8By7e3vCjfKT0hi5.W289KMfeJ45A", "ab" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$duiiYQVhOT63KI.mAoLYbyaDvBu8kRypgtoCouFp3r8", "abc" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$dJnvLFkU0bHXFSHLrkYYdLR0izAunY2NZr0VAgViWq1", "abc" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$VjytKeSlu8YK5ZNfFhNKW3krKa04ZZddIXpPDfukSq7", "abc" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$/1QcmBswh5O4QFCpwsUl5pR0ZMIuNyhL.nzsF8LV2q/", "abc" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$N1CaZtLLeIViR/6TG3aFcvbbSIbyNiPphX2aNLf4haD", "U*U" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$MzejmjV8pdzmwtcsFDeUDMIFwBWIi.5MyM5xa72VzHD", "U*U" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$tnU876ka7Pv.R2gydF6xdBA/5ZXHPOfNDFuBICYZvB1", "U*U" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$unXTppdIcfxCowfz0tPdlE4xM0PCImrP3of01F4Mk15", "U*U" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$NFXX1CfvGYhsjYJkdjS8xD4nnt98W.F6wxzDwxnsuh/", "U*U*" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$zV42Naw8otXZ.Xy8z4ywC9Ez1m19ZV2yqpYivy7gTO6", "U*U*" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$JSCIPhasfNUf2pLWvLl1lTBAqfJjhAY/hqw8C2ZRRA1", "U*U*" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$wQAsuCArN4wwGGc4ArVynvS6LCwnM04Bpk0VT/4pFj/", "U*U*" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$aUUUnHAi2dZaYFb3dOcHlMh4AmCN92chCvxk5UZPR59", "U*U*U" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$TGo.aQYEGUIpinY7pEoZ3gu.uyXKc8L88nBRWT/aaH1", "U*U*U" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$p.bCL3SHzOPkk4KRULHeZxNp9Ue6a7cZICgGndJ6HGB", "U*U*U" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$H8/TF5G4IkO.O1NHWps/KzfZFLRcJjfz4/oQrwjQEs5", "U*U*U" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$ODsdOrYVByj8Tic9QQHQ4z0ZJzTyO59qa5XcGcIylv7", "....." },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$BuXD8ccdGd2ovdeSVdrp6pmdx4D8cwwYRBPOJbAwLn8", "....." },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$k0iAMcPlGz4s7hRsoxfWGoyigXVoCgq4fkl8M/UyU80", "....." },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$xu3OXdk6fdduRyW03wmY1HASHZ8NFOBpvt6dpHZZP99", "....." },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$n7nhaXDXPRZgDA6D1HvSQT0i0zAbdojGztD2YyY0/S2", "dragon" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$QwOgiihx2RKmOLEm0kOyqOSRE2crSe85YI2lbbgBDm7", "dragon" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$GyOizGgwabSKQPbmlAL9cu/EO2zRKgwsb3bu/BqbjeB", "dragon" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$APoVSzt7GwevS8bWf0k/Hvr.8qvJdYEGE3T9Vbmbbf1", "dragon" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$9Evw3xTqL7937bmisDV0n1xFif7wdBktFEVtXFqGFGB", "dRaGoN" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$TVUsdgVdVcIQT1obPO3TYxuVx8co4MNGjG1MIV.AMF0", "dRaGoN" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$7dKVzz7GXwuaTA/PGDPHnfQSCYXC4jaAgQ5Tkg9jMR7", "dRaGoN" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$cx.GdLWzo5NldVMYXgKXOFXwQtBH.g2BgtwNM5qKUIB", "dRaGoN" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$dtRD0LFz0j7j4uD2dUfRw.SzdzxlT3S78c6VZh0Xzm4", "DrAgOn" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$Z5ZiB1XPsVGDkJ.3xBD/.lw1xMC9bwDZgkLZ382BJYA", "DrAgOn" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$mAe3CdvvUbhRAn6Co3a048JSr52WhBR35lbCEQ6urq5", "DrAgOn" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$o7HRnupxyF7F9mqSrjOUsnry5xP61T8BZWOh1gj5U..", "DrAgOn" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$l6Llo0Yg8DjNHSFp36AfkqJSkzf3mhtx/TRz1rjYLU.", "PAROLX" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$pD9ukbmxQVkugtT0etgXQceBujs8id5wYOFAUkA57L2", "PAROLX" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$S4YsiFtOO80DiqW1DEpOSndijKO0wBF/MWAqGI1kxU1", "PAROLX" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$lGHflsH0KzhW7iSbtgtF3.tfEFBqpWfseZx9cSSVFgC", "PAROLX" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$.zYyWvixCaRsw8OrE2z3n3QKSXJsHIkVFhGCqL75aA1", "U*U***U" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$027IYCiKaLSsO5bo7gTqkHyGuJLOtfo/mt4jqDymYs0", "U*U***U" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$IcHXm.1lii.5704lIHomUVZfpA2EqnJuxJ3liV1TTJB", "U*U***U" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$fGc5WA8hZjYI2.4AwUfSUFY.ZTsbw3t1MFwcytvkft.", "U*U***U" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$1H4EijHWcLYyJ8t8OtLK2Iy4oiPEp/O4NgvejWFtD05", "abcdefg" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$OC1A9KmjvCUIOvtEl56s2RvYIAkBKG.N5uHXIo7PeF/", "abcdefg" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$GW43MQqtmI.Gmv06EDBvln4c4jW1OqGxRmPzPLLrhND", "abcdefg" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$swX6fdQdbtQ3cF2piJr/xEuyFmhdF2w9m/1dlJ0AKRD", "abcdefg" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$oNnrAHuqT/wD.LOa1J7hDghs4lMRef5UBmKYPnTm6a9", "01234567" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$WrxrrAHUoA.deGhFLFIWVGENWEpPMGbGRRyto9Gcf9A", "01234567" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$w4YvlEYOvFMIjqT/RfnHqtJH3Id.eDImwuXiQJdtsxB", "01234567" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$T3w8/KfzW8jn1kGFcKmdVBCTc8hgISmC/yerAeXHj.B", "01234567" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$PBYPxYlSpNj0gB402Iz3o2VpQwaeDNogcR8fW2UitK6", "726 even" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$18By7IeohK1xNRKtHMcF9R/fIi7r/HH9uy3EG2HTxuB", "726 even" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$jPbfSA9ezaMFq/ECEHbppP8AMaR17442cgu1ZJua073", "726 even" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$HJ.1UjMMS48gnlpjPYLzBAz2Sm4ZefycYjOHeldWu5.", "726 even" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$Dr6RYUMF7Px621i5Yisww5w8nvYeRrrJABV4mhSQNn7", "zyxwvuts" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$lTFRuLKl2Gym8SFfPTpN5DCvURL6PhIF/xEK9XvYkm.", "zyxwvuts" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$N1ubDBd6/iSrmMH4NKp0qebykcWWCHLjf9hOsvSLDv1", "zyxwvuts" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$9l51p7dZv8PjKFTEHhagirbhoZx.zReBJm2zsvgXML2", "zyxwvuts" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$nEtNyf17UhAAIbmk9GtBs3V/pJe8sRgz22riNXxDDZD", "ab1234567" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$0CWnIcPuQ455p.GL5s0mRUlkfXmdsZaaZqx9ad.R.P0", "ab1234567" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$9e49exJxWbzwvDf1r4SeeHeU6MGd724D9.0YoCR7bB5", "ab1234567" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$UaTMpZjMGLEKytKKgolYx3qH4hd77eITA61h7zxGPJ2", "ab1234567" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$OiK4NlF/dEPlQI/mrJaLW4G7vdBbGDXo6Z.fmLQp0KA", "alexander" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$/ZawJw.6VNHlX6T9mfPfxHURaHy2XPwg/nqUXGursW7", "alexander" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$7UZEGlYfOSPPcOfZ4TH.xl3XHrxEL9INIDR0Rzp75F3", "alexander" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$KSOCZY3sw3jpdJN/5ZIcdccZGp7iAcES26e6wKCNbk3", "alexander" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$QDGrV9VjD7k11ghi.5erZmIy9VOpEWTRXRdg1E.YxlD", "beautiful" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$tj4YDl2Eir6.8TwS9cDJTn9e3u4SZowZSZP6ctdmSm6", "beautiful" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$aV6eGxDHi9Ykj11NntviVzV98SSwhg1pm5wx.2HIMeA", "beautiful" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$D9ebHrjc5DYx2ic7mue6eU1IqsA04Sm0ghuskVJJOz5", "beautiful" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$StuH5t46SsEIA5swVUEg/kCZ1aH9WJkTtiN2wyhBRD9", "challenge" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$99Z4ROgAOhOX/U5xxsUGIVyXS7h5WgimgBQXUH0nt79", "challenge" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$eIcRElyTJ/q0wodZHUoMhIjQksYgEz7jX.Ff.wrYbvC", "challenge" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$35W2FXJQa2o3vWlunZqIAJq7iPFyFFeu./bmEYsTO71", "challenge" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$cSWOwN1Z.CrbLb74DaIAUTJXYV6PVr6b8St7tPcYBk8", "chocolate" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$oRDp8o282.u0isJCpSp43XVqEecyy4ijY7hIFBz4YA9", "chocolate" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$mnvyFwW75lWUE.DOBviUC/NgQL40eTM9Jx.EFTynAyC", "chocolate" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$KQkjQN7P97bjR/aB5uLqEgtpHA103w/o7uKHSw4/Kd/", "chocolate" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$iN2f2j5KaeXbqy7GKuEX0DdQR/MZxftcVCRxx71Y370", "cr1234567" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$IW612/DltGUzi2H6A9nwVJhya/gUd7EU.hNu0sWzepC", "cr1234567" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$5fzJdtPGiCHQ6zfbQWbe.WY3jcJY6xNbtHgJqezteED", "cr1234567" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$RZLK9al6PNdvi4HQYJ8x81Q9TJMcjQRjX80Vsg9vkb8", "cr1234567" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$N6h96UCWvYOEhn.pYWJviasPwY7L9a3wjXcFI57sAh9", "katherine" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$DnyFqg/7dXNrlmHSKJEPjmgSxr/uKqg9VYfNrhILJY2", "katherine" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$Y7gPCZm1dMkIo7mzScI11xifY/Ia9sCjWsaO2JMxwR6", "katherine" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$sWiIyn0dfKDKJhqvZJVLMRfWiQZW92XGvTflCH9Duq1", "katherine" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$1cKf1LZam2tba5gR9.Rmoh8Y.0QeHyswdrWlmD/xbn9", "stephanie" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$GvknHkXHdVYAfv33/bAZibWjvii2BHDVLHK5KIubnQ2", "stephanie" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$2gqrbmOl5htmtrRYwV4jmEkWpI8q.WW2B5STh2xMdd9", "stephanie" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$wHuJFnyMU4b0FLbe35e5jYhI9.PQLdbuliaVCNPXHM7", "stephanie" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$u.3XWIqa8Cg3wyLMd/XyyyXLTpUiTcaNvQvztQaJvs1", "sunflower" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$delOpS/UmtueEiPLT8/NgI0CU.Vko5lkSAMgXCXuwl4", "sunflower" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$kT7hw.brJzaZhJzM15r4CxZgi/iVPQN/SQAHLACtfe.", "sunflower" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$K4XykeNaJX7zSuF.sSgmqtAG0RTgq5PyGzXOEfms2l6", "sunflower" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$QDfF4DUqQMj/KILwnjOhE3ooIZCDICLJMAdPbJDPmSD", "basketball" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$8blTSISF.GTK7Po2/3W99JXhJ3ZS8BCC4jWLrSfGNK/", "basketball" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$VcOtI28vgGqZWNLSDmA/n681Rh/PNtWPSrX/OtMhU/2", "basketball" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$UiQ50XHk5GSLuJgpeumeqZYpRLJXG6xjcDedLMSi1aB", "basketball" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$sbQENuRjmZNKCdWJJ7Ri/rf9IrmG0m/ZKlWUNmkOZ83", "porsche911" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$nGaBPBYIzrfPERPpCaKuQ3UIQ3L3TBdcYBjE8zhqYZC", "porsche911" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$1hwTcqFRPqfaZmTBs.3WyDf6GN0TDupqB9uSkLCQZ5.", "porsche911" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$sW.yjH3kcrHCEKQFJ1sLqQf4OL3gC90xRcWfOZX9c.C", "porsche911" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$ci4PjgAmcnoAdjcR9YIYmleV/D11dal7kzixZK9Bss7", "|_337T`/p3" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$kSN2FusfhBYV20X0Mec1B.p9LdMJWcB7H.KSXG.PbV.", "|_337T`/p3" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$01dQzRuADp.AEQ4z4Zlcm5GnCrEMu/SLoInm3YrTet1", "|_337T`/p3" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$IUFwGhqo7GgXHeK1V9F6txeOArMdaPKtgHUxvYZStHC", "|_337T`/p3" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$K866xiC/MlK5slzeKUbHxSPu.2c.HePn0Rve4tVTm6A", "thunderbird" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$6X.YFzEoNH1UcE.6nFEQYr4YAVhrTSHXjjdH6qx/Kj8", "thunderbird" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$FZmRulf182LlqO.SC27vzbkCxzXoos3p2nSCq1bNrv.", "thunderbird" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$8Ae86weM7S.Z4WSjCvdPAD6mmXEI.5FNSWjOZzBIyt4", "thunderbird" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$Fl1JJO5mL62Dfrp1fFIfH6NFnbUCi.A1c.PyE6Otzy7", "Hello world!" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$T5oJ8L.jiL/FeyTFmiU8pkr.Eyetg6OyCSCi0EroP.6", "Hello world!" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$9ZzOEPFLt9nOjDqEWWdy6hstVEr1/MLgHfBUvOO3Xo8", "Hello world!" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$l0odnaaS/w.YV.mPRnRuCKF2DB0xzbyBWNkUehZRyG1", "Hello world!" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$hqWYPJmGbf0cDGv5j.AXsAn8AcdVSkbtM9.MNhXnFe1", "pleaseletmein" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$XJNbhT4iSEOsJ2FM5kZaflHkq0IA0/uZh6J3Mowi7..", "pleaseletmein" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$TI7CsxhY2tnTpMRIbN63pB.gss5HSB/u1ilPcd93Qx.", "pleaseletmein" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$eDSefvnttySbZdZegiFLTuDKvqofEf2j3aaD3c4ili4", "pleaseletmein" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$.NZryhrXSak7wdo5kY1CK1AWe5JXUZGiafn0/bl/2l1", "a short string" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$.C2iqk0wGoRUiOH/yI.h/Igq37hJKgv3LVQvQopY4u.", "a short string" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$iRQiAmiPZ5p1FMa0Z..Xq6JkzRB2owpkg7NH9zeuSD9", "a short string" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$4NwjO9WeREyBQ90PqZpGT6IaThRyxbBFiyCr/30MVT6", "a short string" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$TjutbMlOWH6DUKtbmFMQg9RqAQltZz219YAG6Pamxo5", "zxyDPWgydbQjgq" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$AEitNI6.RwGf7i8wb8E51eALx4KCwYU3/Aljc965e39", "zxyDPWgydbQjgq" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$qqpK0pPdWgRU.dQ72MVyZT9a8w8OsIuCLLumF2Q/gC0", "zxyDPWgydbQjgq" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$RpBjGUNqnS0qP9b8LEq38amBw2UDXvaTH6EnYR1Dgv0", "zxyDPWgydbQjgq" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$CzyeCpvPhjvvwX/m35/p9P/h8aKeKmDgCi6unO4XFq2", "photojournalism" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$nfs1nA9TbVtB0H9hNnDKcO3.KNxuWOEr25q6//MLrID", "photojournalism" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$3MCKxDxG8G8FJ57X.bumvvXENHALvCTB8/spk6nez67", "photojournalism" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$2pmqecyJlmGFtyKFhNBj/6hc4ChxFD08b.hvPPf23C7", "photojournalism" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$5qu4rPGth7jS4L2Y0gTBS73LXncfeClWlfC7yxXxXfD", "ecclesiastically" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$iKO90lf.O.cRTU/he7fbPezuFhP3K5qHdL/FbaCa996", "ecclesiastically" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$wl39zAPBDj1nq3f4upMnKxZZGPIR69ovHNqFLzPEFt8", "ecclesiastically" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$aqv4Bt8FIndQ.84n0blFPSZZSc8cys7xOFXLRErgk68", "ecclesiastically" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$7sQUAocNZymwoAdpHWnk/QIN0p1cCtTYgHwucndmJG6", "congregationalism" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$aq2XUT60eXAbFZp9kWog32/G1wmhSiCiCSL3AU2DRs6", "congregationalism" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$Uv1knpWJquIltC2a9CXvOG8zREJ.0HcCk8CyyaFZKF8", "congregationalism" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$n3qPCFOUhldCDaa00kDcaFN1v3Q.Emq/VgYgQ2DruQ5", "congregationalism" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$rDKdIe8NSLNT6y/SkhevQsl4ZlEwQyUaqGoHX9uQuUB", "dihydrosphingosine" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$sqgBstaMK0RBJOcFvpY2z03f2uu1GBEewsqapmN6aIA", "dihydrosphingosine" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$GqTp7cncMzPAvOG2euBc222i0AhPdAZzhlX8En5HgV8", "dihydrosphingosine" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$y6i6yQGe8lh47fK3BgaL4E8cxZRQrMy6l35LjQZ8dyC", "dihydrosphingosine" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$AUmpkePIM8fW33lDy2m16bWgudqefiTWyUo5yY3OeQ5", "semianthropological" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$nU2jFD4JseH3z7/r1h4JtJlS5AT882bSwEbsf7.hqg6", "semianthropological" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$llLsyl3Lp.Ktf8.3ghXU7.Adm5jtcren2phSTn3POxB", "semianthropological" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$wWF6AVNgm75bUED44hoinCiXArKYNYXiV1o9ESIqpI5", "semianthropological" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$u4Qmy2M9BC4xiplWkE9snyOoB9Z/Wr5YRQCuKyCJoK3", "palaeogeographically" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$4hNATW9eCKWDN0r.NqZRmCKxqIrQEEoDbiBZKPE1R/D", "palaeogeographically" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$S6nEbn.ViYkVpaWWAQX9DlEnJMXGgPNNgFCDf6zLu2/", "palaeogeographically" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$sRlN04EeaCPteV8yrN9JPvuWZD8CsnsaKWZqKe8eoI1", "palaeogeographically" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$VcnRaesCGnSfwW/dq.FsPF6HrcW/1E9WQhmzQMifIc5", "electromyographically" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$Tw/DS4gFoW3tRQmoOuyTKrSHcMPrwd7Txc0wkABqZu2", "electromyographically" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$KAHxGO3.Aavpw3u4MWa0IiR5oiGHczEEx/3Ytv5nxM6", "electromyographically" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$48YaT4jWabKJ3A0ABn9hQKn4F7EvIJrXIkNBNLxYRZ6", "electromyographically" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$Tk1pJjxN2ZUhlemYZNfvGUkYcHf0O.4rJmFJVZrUbt1", "noninterchangeableness" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$dOpRB9P4fh/E.lotj7RK2mpG4uU2qYny0LskZLwZXOC", "noninterchangeableness" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$8tInt9IJq9Mz6MhxVak/DS6AsvAtvbpn2wBNUnyyzs0", "noninterchangeableness" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$GOSd.X91S2Ge.mKSH3Vqu3jXr12rSDsSHAAoR4X9ab5", "noninterchangeableness" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$/z0h/0ndkDUILZ.lcf2VcYDZKhIBdiqwcqsF6bHFZi8", "abcdefghijklmnopqrstuvwxyz" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$e11DJvhbJLIw8asJjzxn1.F.qx1jYh7xZSF3ZztgWb4", "abcdefghijklmnopqrstuvwxyz" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$egZJgaZAybJOuson8i5F3BsYjGRbsEgOylne52Aoon6", "abcdefghijklmnopqrstuvwxyz" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$mwWQn0EZxjR9x7NUiwvHysmOZHSImCZbcd2iVe2oTz5", "abcdefghijklmnopqrstuvwxyz" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$0KMOoqBO0G.wrS33WhhU76x65PFzUiMV7Gqt/Zfb0k6", "electroencephalographically" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$xhg1D7QA.rcONQG4pXpVuM08SVfh4Fb90Dud3Of13H2", "electroencephalographically" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$WKl92eNlmXiQ077IJJdaRqEnYNPE0aQn3ltgt68ifH0", "electroencephalographically" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$0vWE6Uas01XnYNplcnSBF03krpQZMndC1Pk.e9nzV34", "electroencephalographically" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$cERU3PEDoPwOEG26AS5p0U1PIDVkrCV2ymgizVolc/D", "antidisestablishmentarianism" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$ltrA22uM/p0alV3E3avf1EsCMYVjoztc/3mtRRYET7/", "antidisestablishmentarianism" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$uqXLmwPoht9SfnV1nbbNNFtitOZ/f8cc65hIawAIQ3D", "antidisestablishmentarianism" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$j7nBWet2yKGT2fo4x/Y..T7Rj9hOgfYnasDSmGtllRA", "antidisestablishmentarianism" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$A2yWp.KyIll2fm07vdLWwhv71b5T2BOaxhe.dU6pj.C", "cyclotrimethylenetrinitramine" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$RnVi3HhaJZtFsPZEEk0AEvyXthjxIf4AC3f/rHuckOB", "cyclotrimethylenetrinitramine" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$yQMYAAfYvhZvfUTa/AK3VE.m.noihmAMaCYprR4Cf5C", "cyclotrimethylenetrinitramine" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$ywi5v3T3lvxrFt3srzyXJu6i1VX0h.7jpJE/gfVNX.A", "cyclotrimethylenetrinitramine" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$/VUsYdM7G3coTWb/Ds2U2PkQu1nf/rbzqVpplZsS186", "dichlorodiphenyltrichloroethane" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$6MZbxfhSkMYJc.PY9H.ZnYpvmhNMmpHryhNVuGYJJUB", "dichlorodiphenyltrichloroethane" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$Hgqjy0lKLdex5.AkXPeQXxD7281U57qyNAIvIUUGmE4", "dichlorodiphenyltrichloroethane" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$CAD.5MVyCl4t54hiKCKL1ErKD/xjn1wA0IV4hbpGcT5", "dichlorodiphenyltrichloroethane" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$1jVjUF4p0gR0MtrjUt/vWUdhv0wm3EPwXGGkniuWzU5", "multiple words seperated by spaces" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$Zze7WCJFQ93RuclmNvng/RPsZWJK8.9S0xLq8nFKKi7", "multiple words seperated by spaces" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$ocKyuGflhycdlUaOeO.RqkZysvZz41UhxaOlENz9PY4", "multiple words seperated by spaces" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$b9OTfBf6CXmuqXZ.TxnKiw4Btodt83rbUJGJVuhHnD6", "multiple words seperated by spaces" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$AudhEDwuWxZJDjgEEaKoLNDtRepeRzD3OpANIP70cX1", "supercalifragilisticexpialidocious" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$RSO0/dnP4FVgo5EOTQA9Emjg/xKTQEnLKwAt7XBMdR.", "supercalifragilisticexpialidocious" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$3mACU.qVO2c1S7ibVvBzCUnM/tod6xFQuzPP8zlLNQ8", "supercalifragilisticexpialidocious" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$KnaIPquArEqrF7vHnnJo2kgkWmEOfxivx66Hw4J50E5", "supercalifragilisticexpialidocious" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$uXmQxhueQtnBjk2ySRyV3zkZ7hcSlhLdTEX41BPlY85", "we have a short salt string but not a short password" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$SNWfAWhsZGH1Wk/1dFB6Q3TVrj/7ZolVUzh8t4zJE92", "we have a short salt string but not a short password" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$AoUL6ulXGcjxTnftWia686Lzcma/7oWI2B78Ixm41N.", "we have a short salt string but not a short password" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$vVXaL5w375VxaWAW9v1Z7v7BFSqEN0qU.8PsPYB.qm0", "we have a short salt string but not a short password" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$xtPYXO0PStqsEupRLAy.55IoCbjFTPsNxgVFnbS2Mp0", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$EAWHQFH057lsmdgRW1Evr7lYeLXmMvilEdxN/plEIRA", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$EmbPGLCLep65sot6B1GeeufxsnnFB6lw3dg1n93.Zh/", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$7YMN0XcBtzw5umXex6ejdX7CP2AhyAF2fF/dE21DTC1", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$XIRRv/eoRCyRvTmHz5xr.AFokOBDf/qo3MCwXzOmbs.", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$8aDFJ/hdYvd1yIVIcq0E8xszlYiB.2hXZwh1J0J.eRA", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$PEhAojyPMy1FUCl251CaHIGh2smhyzMjwfLb4Nsdn18", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$ZPxqkG53GDLTInHJOZgHDr88k0us6XUHD41bcxAamG8", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$..RX2a7Xnhf4P4wVOc7mQtVpBbxb5cZX2vsMYcl9.11", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$issx5PW8M0fliK40Z133/sbqQz6ALp3ir0m3ueh9HpA", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$QwPVJltRiaZIfxJAnf/mdB19PJNYLX/Coku5DzoGby3", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$3byD/cldHxA2cpgq.2.dD58L/Se2xNx0juWiAoe0Dh8", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$6t5fIG0kHQgSqWT3Bs3E7oas5MkeCsbRk0UoA5TvMuA", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$fVFkjSwka4PD0FBbTD24MTS1EbWt2BA2LgBUsjH59U4", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$WOd.9C/nsVeuC1U4PdxMKvpkM97p0bx6C.njaDOjnM3", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$qoZlum5WeZrhHyyhRupgieU0fvvSlowbSPk8YffUD14", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$JglkDc1WF00QU7cPZEL3jmX63URqqc.irI4EVP7jLeB", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$VqyHgXICaZdZTnoQvLNlX1TBpOZQ9QsnSWbOmt8ydg6", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$44ww/LHyorphVKGehLCyK.JxRg/qLZhTszatV1Du/j9", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$Rgerj6UHJzFAraJLXA0Ba4v77gzAv9nSer0XnnG.asD", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$NgYe7MVLYoSLBtKdpJqzDuPGs7Ei9qvroWe5VEDZey3", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$eUL6TKeedsHvV6pMSdoT9XcqsZfXUBMT1/lhA.mR3w.", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$E..VBJYqRUJ4Mtb/MJg0Oa3Zs2mcjP4TDrWDzcDIsf7", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$Ab68hm0/3I/aWvLtXJawxJmwetnDm8GtAEIPyDA2cz6", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$gQxRaN2SU.Je7UbR74T06IWg8yMlsukTD1ofRSjLvmA", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$VWuxzu2V2YMSqSs0uEtFjRYzYV3CSmjQ5t/spGMPvRA", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$orNyai1mjjJGLEwxuNBJ/iPwMahEf44W.d2fgk/pVN6", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$9eGBzgkzRQg.HZYFgPuRKgaS/Q50Jex5eP3Tn7ta0D7", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$eR0Of5SlN1Jfs1G3hhrAZmK0Uxtmi6SVUb0gBM5gwv/", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$lwTIi6ZEVx1JoejVrkWwu05sezZGi9s8JO/QXRcWzI9", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$EL..8u/q5bl8BwqSjXtoaWHGQcjbMsPlCOqoPtVpJB7", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$jJ6JXFYkOSZ9JvDS0bB0gRj9/.QXl/MIrbwY82HuHA3", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$hJCKrP6x9i6xpc4eGZ6eGDVFwIKG9x7QXtfFuc9kYv5", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$L.hrcRaZpnBs4xwFvhegNAtLAvNk6Bc52yYpjxSv4bD", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$FlkiUUCRGf/I6U1zOx8.9Bi62EtSjPbabB8KPqnoKu.", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$mMQ/3g4hKymi2n.evLQuatQI43j5KV9..A5Y7ql7NR3", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$zzfh7usZ1zSLP0RIEZcReyGH8ox0ojkSu.m1zoczES0", "\xc3\xa9tude" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$X6tdhjPOgIdmDtjW4XTe3iB5xwnQ8.PUhDy8UPr17w/", "\xc3\xa9tude" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$p8W92RcfBo44EIhCifD9QPE1qtECi6ERH4alck4w1H0", "\xc3\xa9tude" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$bwwJeie56AV3NZMg9US4kZpES7GTYWnr8y0C6pRQCw7", "\xc3\xa9tude" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$Wkjym1pGft.6WspCbekdhOQSRtwpwMWayzSlFOEBfB/", "C)tude" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$WvQgfN4FSr1GW7.OYcZZoEUi2nDb.cH5TUkWKCeYZ7C", "C)tude" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$hIlueHcE3FxsgyoDjjG27mVXDXvltmOogLSKcEPWLxA", "C)tude" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$t4vDIwoxmwaMpxM6iqPSbXuTP.g0GyR.Hdtgd1R2pd0", "C)tude" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$X7vixvDipDpiFhyoseeVf8LJ2aIci3cBn0r6gpCFMj9", "Chl\xc3\xb6""e" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$KzKH0/WAdiU/WElporyamvW5MgI8bRLS1DnxpoVsUT/", "Chl\xc3\xb6""e" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$foikgyB9lj7j80oWRnyg5GFVcF.mVw7rhtk36EjG0m5", "Chl\xc3\xb6""e" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$jkbF8eD6jGNnYBGpwZD7P9Fp0osaxqC6XY87bidynA6", "Chl\xc3\xb6""e" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$GVelwNn3GOtNcpA.BVrhR/omX5cirxyrcmsfEBFkX9B", "ChlC6e" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$aJQAN9JepFtB8w7I5vLYlY2ko8f6scs0xrLFGvaNqs0", "ChlC6e" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$WzvzI2osPFtnHceHoykwPx7McGY0o5Sw.gW8tcjXEU5", "ChlC6e" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$sDBi6H607ug75T7Die7jHJgPB5TFndLqQ76JKsJ4WF1", "ChlC6e" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$.QjdZMSTlu4IUiOQdbKYrscABm8c5T9Iw0aaLLrLsp8", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$v/m/L63vnUJrfJ60gTmNrDbD9yaK3NqLVZfcHfSwfK8", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$0LsFP0gXIl37AN5.15tY4p/Qe6K8pF3bIgRfVNGJbS6", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$GiZmoWVC7pnefpwEGYTH/tsn715pspvKqPaTl6eWp2/", "\xc3\x85ngstr\xc3\xb6m" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$p8wPhzwQ6dBTi5QUziAFQaaydwFcwg/cIJOklrMUd71", "C\x05ngstrC6m" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$EFDFPfC4J1LupzDx7XPfiGJxZs7hSuvBaZv.c5jl266", "C\x05ngstrC6m" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$s5NTd4.d8FtFgdypAtdERo0F30oOfaUzVTzZGiy6tp.", "C\x05ngstrC6m" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$mC/cfDifbCoSMDpQVyLkQRlJKoTaQBJhCtcLMvtrnz6", "C\x05ngstrC6m" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$4tXC7Y7YpaG0IUaUiAw8hK2yyNwbEGTGeEaiobVGgI.", "C\x05ngstrCU*U***U*" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$a1sK3nmiByf6uwd7xU57w.DXh3/y9caOuv9nHT0sXKC", "C\x05ngstrCU*U***U*" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$jY2tUS2gifNFfJeU3Fy8l.egfAl1y3BKJ/Ozx48GT6C", "C\x05ngstrCU*U***U*" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$UMVchHFzS.3VU2EZayj1s/al7thD4U4q8bwwMY2igG5", "C\x05ngstrCU*U***U*" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$9F6Xw9GDD/eGBRW16QS31t0.CtA13wYXD9wsLBZyuLA", "U*U***U*ignored" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$RDBAUZkkPs1nz5Z8o3qYiVeuLnY7fW90SKMZbgGzZv2", "U*U***U*ignored" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$Dk2KUOtqij6YXCZ50idBTWt9s2hbvgIV44avu4vntk.", "U*U***U*ignored" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$CWJK1uteGW0sD7bj.SlkZd43OdVH/xZRTLf0JZZNAtA", "U*U***U*ignored" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$8xhsHrvNSXB6aHdJK5b.gT6KxClWxQrkEjzXmygtu51", "U*U*U*U*" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$0BafhOLobittF7QyKaKRmvUJwYSBnZXslftc6GmBiV9", "U*U*U*U*" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$GTTLijPTaZG/kCEy3Q75imWazPFohb3v8hj5l8aB.c3", "U*U*U*U*" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$YD04u3k06QzcXaPvsoaTLu1KXpgdqiOkBhJZ0CgwuD7", "U*U*U*U*" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$2CRRwq/7kuOpfV.GBA6S/LtxNYca3ExCeKh0aRdmyj3", "U*U*U*U*ignored" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$mpr./nX21oSVX9HxyrmL590Ps7WQ0Xe2ktFHhBk0oQ9", "U*U*U*U*ignored" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$JBDoFnZekbkNoeukQ5iUuI8h/MHqwzGt1Eye1g073ID", "U*U*U*U*ignored" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$z1v6truw/882nfMSXWneaoYYaz7sl1oyK0bYr2qwxP5", "U*U*U*U*ignored" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$yFD5m64w/AIPAv75.teZO9T7ZlQDyu7tE0uwbRdb9vA", "*U*U*U*U" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$V2iPaC/fm4XxTKaLpkEQpZ3q5t4Y2eJPFmF38mxl0R8", "*U*U*U*U" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$PP3FwB/sOjlm8QamjaDHh2R3Ikt7OhcxoUABbjij419", "*U*U*U*U" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$NjwW/.M/z3A2VZurRcm83ce6lQflPkStxjrWmPaRF12", "*U*U*U*U" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$lYfpZ5HLNsh5bXL.gem0qgeTGhzvnfUmVKq4IQgrhv6", "*U*U*U*U*" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$4CYzwEcr1QbkQ9v0Xn3sQwWeTm7niD.tv8mjrlXNJCD", "*U*U*U*U*" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$ggLQushGkKgUyd908pOnPwxTnTGd42rmnl81xWXXZg.", "*U*U*U*U*" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$PWDJmSYxwWMa51Dznu2wjJM9fQJrkOpeQWEUIr25ug5", "*U*U*U*U*" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$sLTmLDtt5obdF7vLcuSS6QS3srkCr5FCLS1YHiaKIz/", "*U*U*U*U*U*U*U*U" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$6bUvaM9hghAYVoRnUxV1S07g36Y/TTWruZjadHZYXZ4", "*U*U*U*U*U*U*U*U" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$TE9S0wSAJS7O.r7N2l4YUw/KmqulkiyAEqjF2RoMkh9", "*U*U*U*U*U*U*U*U" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$N0bWlQBnIapr/qOoh5tzsk0il/i2nT4OwXV6il7SoT1", "*U*U*U*U*U*U*U*U" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$5bBuxhkJhoPSVJlTdXdrGzfmxy54LTh5qJEr9N/jaz.", "*U*U*U*U*U*U*U*U*" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$QzY8TrqELXDotVg7eKJ3hymqy3NtSKr/TGXALKtGGf5", "*U*U*U*U*U*U*U*U*" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$wHjJYZOEr2QSOGHOQU/DUXV2Xab319tYUGmMpflst33", "*U*U*U*U*U*U*U*U*" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$M2aXy82P3pniVrMho5o.ii/xtVBht6.TV5boFeoEvqD", "*U*U*U*U*U*U*U*U*" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$4l3gfaieJEQ2hIsqfO0R3ihFH20wTC.v3IV1J861eZ.", "\xa3" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$THdZOHaFgwYzKZ8CaGaqdta0qlg4rHr30.yL58vwYL6", "\xa3" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$kCfU4yn7MC03aZ54uVVNp0rSLSrF1EzFjR.FMvAPua3", "\xa3" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$QNkMwZs.dLpzO4CmyXLS7JDStS5.HsRZNVbK/nSbnd3", "\xa3" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$F7LyrC3dBgwS6Y/gRvSpgcMXl.oCurIBK1uOdOs6cz5", "\xa3""a" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$XWLHtOWzkP0oR2UJaTGj2CnJE3TtFeEq468S12aok04", "\xa3""a" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$g54TtfHJ/FfBwv.QL47hIlTMgLEaYxDVEgUgtTwz662", "\xa3""a" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$ScHOxrRnAVZ5v2LGzaq3te8ncmlBLuMF3A70bd/YcV8", "\xa3""a" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$EL1zhq6oCbR3Jv0T/SkQzkT4qc0gQpKt/c3I2mjZUuA", "\xd1\x91" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$paK9PrSnGaZwUqrexRx6RK.OiMT9e4uuuyiEPRaf2d.", "\xd1\x91" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$E3WfS8j6gCRtvjcKXi6DkRvPT2RwnK3h3jNj8hFPy05", "\xd1\x91" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$TCKAbO44nBoGdgNnC9duDN9W2elPiz5BEQC.c/1/DE6", "\xd1\x91" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$WxNXTayEw1N9sMfBKQteo3kKedzeiTDnUxTIkiiIC.6", "\xa3""ab" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$FUjT89Q6bKGhz.aNiI6jmHF.h3Toeki60ekucx40WH/", "\xa3""ab" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$NAr1cag/Cw8m/.W.uuTkt3Boaa.w8j7.GAUctQj7i73", "\xa3""ab" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$bzmiTpfSam40mMyPhXglmxEu1NvSBd1E/73Qnog.WgC", "\xa3""ab" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$ibmd5LjNFtjwC/0nMzXbECR29RBJgVL9RfgR8YOkD17", "\xff\xff\xa3" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$xsV3zvygieg9Dy8oFr9.L5NMXbQDev2t3zfMWuTPc6B", "\xff\xff\xa3" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$q0G2lIhyrZ0wk/giRyqJgwhg4TtWSYw8B7YL/gb5D88", "\xff\xff\xa3" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$ys5cdHyU9B9Q8XCVoJp1pCSUl5vG5sVWuDmRpVSfX78", "\xff\xff\xa3" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$nkn5h/7A4ufoHNY.JXCpe85KdGB97i.c2CPfNYJ0Xw/", "1\xa3""345" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$1zSFBx2oDrVo8YeBuSeFiMqvhBRZIRG5/HGb9bA48H0", "1\xa3""345" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$7UXjuW0C1rHtG8gs.A6.yRSd.Jp9JrbYvp5G7moZvf.", "1\xa3""345" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$qtd4FgtdNvMFVAVxJMh6kibm3pweNHO84XXP6S72WxA", "1\xa3""345" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$sJXxdKucpb9vu528RzrtZhoqEMAPokLumbw1hpl8h01", "\xff\xa3""345" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$jwPHL7jjMt1y8qH2HD/mC9BpyvKb6pxrdSFd/C3qCs7", "\xff\xa3""345" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$Kq66Zz4DS/TIwX9eYETVP1BUcGo0/HQtQdlMZO5mz2D", "\xff\xa3""345" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$JDOZD1if6RoHf4TQWLDwd8uu2N5obPWdNI40A2uvAA.", "\xff\xa3""345" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$pnzu3MtodIKp/4UecbcDKzanT6DfSME8C8mF09CjFhA", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$CnSsOqOFwZTCFNw2BV/YHad7jcD7aUB8AEozektLwy.", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$SrZh5/PCD7uZlc/EQJ2MG2.BUwVZ57g6GK7Qu9mYnc4", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$4E1SRUBTrnFcuJGCFD11x3f4uipOt/h1iO.aIi5CDs5", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$ALUCjqTx2/F4IwLaxTFgAk04ePudG/88lr3qJDCshVB", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$ZQhxVXFmkL7KoXgNjP96TvfaRk9CIjcPpwtdrr1S5ID", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$4cLHewnnKS.yskYtL/pcrJd2Flc2wbIKak2TUqJFeFB", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$LYeIs/Npq/TmYgxlbBSAdkjultRk8QHlHBkoyThe/93", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$wi2mW6HjPmEJGYtPqLEDDaxVr7SSKXG/46moqrFEdC9", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$zh5Uh8eAMrMxFG8Y.rxfXpFkcvymLwTQhfNrMAz2oH8", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$Gz98oPBR5Ik8nzf6pWGxMlYW7E5Q3nRi204PAxahV33", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$zjvqsm.prmZpGiM3NzF9OYYKdTxGnngC9heo/KZEKf/", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$qEP3zgPnnCU3cQWvOXUNwaTDBOeRce1mu9DJrZxOlzD", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$RpIUOMzNUOq8mDI9ZUIIe2nOo.y5PURnU4pA6Ncmbr/", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$U.QuzzwJ2J1QPa9DzBHbNY2Wm8eIV3DQ9wh40n4JuZ1", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$5KOm1SGxZzxC.63yg1UeWP5fGSh.2f.jH6CTEwEyseC", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$Ug013u.PK.btjahtTr3g7JPNWD2w5jGaRkQTqtk4Ej/", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$0TpJ2fMqzQTUNO8zBg5M.oaGCb1xPXdf4vcog8Dv4R8", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$aaOdO/0UErwYEdg0sLrQeFAf5Ui4pqacJIoYS.5TKxC", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$1VlkcRef.IW8Ng1Q2RLq0ffKZx4in2RIM7/wD8jt9/C", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$uRgAfuVZnLcRrjaRTDsIja4.Ft4TEQDuwQauF0p6lBA", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$ITEtpuf42kdqFT7RUiE02KBDr5yPnVsNtsEu3YcviP8", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$RBvOw9TRa3M9B7jV62tL5ckbZ9LYChqVlGP2uGmidt7", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$/48D9zWzUcWoqfLq9GP.356v9EcHABfKdHu0p3pU7C3", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$W74SfnCWsKe/FTnf5YuJWcCbMn8OGhtA0E7otlfBEn0", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$GUDoqr9BQjMcIKthOvF6AAaHwDNaZDNCnkU1OzV.z28", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$x3MYlzmKXpNCVb12wpREXx2vwDb8ZeF7QOV9BUZ8EH9", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$YXLWWKC9g2Xac2O2zHKBQxKIkjZ3jqIMV4xTIq1uAIC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$ixuJPMBrGHTzA3SMmjW9sZZz64CLQcIDT53zv3P0gB6", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$qTeO1tmKicVuNmDpshvLjxNLjoMl0b.J0KPsVTyOyo2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$MoCNV91RESTAwoHTaTFXCzV1acGn46OyTFGUxZOSHe0", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$yq34rt/vGD5hu.V/VZi4nPaURxb0GFGlKS2hxm/8WDD", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$QpMdw3klRpIZQ.6EpvNojlH5qPBUEqXh89WaFzgELM6", "THE YEAR" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$i4UK9TpLkOs/ZAGVCwyr9xLrUY/iYvjh.UNcCPprXbB", "THE YEAR" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$DQ74A6lhXMHprQvi62K3NOuY0AtWIBai7feta.W2.x4", "THE YEAR" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$WsTTrZ0dW06CzYMMiynOfJ108lKkjFS3Uk4yx62hvZ3", "THE YEAR" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$Jmx4iYyEDYnYdR4Sirwu6InXG/UZoZKq0cqX08upyB1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$NLHlg22Sc0t84keMlpBrn4YLj0WJUTtVfyI7wt9O/X/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$QzdWDuD0Q7JI1kD3OzQcbmBRwY2vvPNH9gMaR9l1kiC", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$vLaWben/jVffUgVUTXncP4czYXjEt/FPnoF1tUAlZX9", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$sm3y$j75$.......", "$sm3y$j75$.......$mf4Q7BzVUa5V9N14a0ZVHHnH9zohfu0kwpQBdJFRUXA", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j75$LdJMENpBABJJ3hIHjB1Bi.$9WVtJHSgz4OFfU.tx9CKAfpzQEvP7LOieIB1PnPKK3.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$sm3y$j85$.......", "$sm3y$j85$.......$HB0qJFxqvVAhno.1hPy0PXJNbKVkzTBsUT1RhQaJrt2", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$sm3y$j85$LdJMENpBABJJ3hIHjB1Bi.$It5fnoEMPtvwdNEOif0qQmwvJri39Bzs41GiZx4fen5", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // sm3_yescrypt

#if INCLUDE_sunmd5 && defined TEST_sunmd5
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$RZCI6tPskaQD1XDK/Ffsr.", "" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$RZCI6tPskaQD1XDK/Ffsr.", "" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$0XWUyO5foTuTHGCTvb49N1", "" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$0XWUyO5foTuTHGCTvb49N1", "" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$qpW6RLvS68lr/i6KhZdRD.", "" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$qpW6RLvS68lr/i6KhZdRD.", "" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$DHOuObSHqAho/a9ri6kgq0", "" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$DHOuObSHqAho/a9ri6kgq0", "" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$4Jb86c7oEf7eNt4YR5J9R/", "" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$4Jb86c7oEf7eNt4YR5J9R/", "" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$nJy1.BHla9NYuuvMBOKSz.", "" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$nJy1.BHla9NYuuvMBOKSz.", "" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$s2SenojLvgwlaKoskqK6S/", "" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$s2SenojLvgwlaKoskqK6S/", "" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$f8InLGccBbbeLla0lgGGn1", "" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$f8InLGccBbbeLla0lgGGn1", "" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$W9EpSlbJtKmRB310cW08Q.", " " },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$W9EpSlbJtKmRB310cW08Q.", " " },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$mB1mrzEG652GPT88z9hFf.", " " },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$mB1mrzEG652GPT88z9hFf.", " " },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$mRGUC.fJ7bjQR/VYaVg6s.", " " },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$mRGUC.fJ7bjQR/VYaVg6s.", " " },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$/AEBYWX86Uwi3EMxMyUmc/", " " },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$/AEBYWX86Uwi3EMxMyUmc/", " " },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$idnWS2AKDOWEVU5bak5/X0", " " },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$idnWS2AKDOWEVU5bak5/X0", " " },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$8mJYfoL3Y/FH2UMuTRtJa/", " " },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$8mJYfoL3Y/FH2UMuTRtJa/", " " },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$/iVfEhSComOv3UO28XYH0/", " " },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$/iVfEhSComOv3UO28XYH0/", " " },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$Lg2zcwQNW0D85l1LEu9Pg.", " " },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$Lg2zcwQNW0D85l1LEu9Pg.", " " },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$XMEBs0n0S31/6qX/qsg2E.", "a" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$XMEBs0n0S31/6qX/qsg2E.", "a" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$jt8Vz/QxkBtyChJu1yaW6/", "a" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$jt8Vz/QxkBtyChJu1yaW6/", "a" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$PSOmhc/8C3iRpWrXvRZ9S0", "a" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$PSOmhc/8C3iRpWrXvRZ9S0", "a" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$KcJO43Bl4spsHXKnZxltJ.", "a" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$KcJO43Bl4spsHXKnZxltJ.", "a" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$kdlvW44dPPaNESsdPeFRB.", "a" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$kdlvW44dPPaNESsdPeFRB.", "a" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$VlpZ3xmSPBUezOQx8tx/D1", "a" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$VlpZ3xmSPBUezOQx8tx/D1", "a" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$etrC6qxk3qQeR6eO2AASX0", "a" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$etrC6qxk3qQeR6eO2AASX0", "a" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$MMNNm2Be.aQQ6fNR9JrPu.", "a" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$MMNNm2Be.aQQ6fNR9JrPu.", "a" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$Sio8a5HlU7o1uou1i8sdE/", "ab" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$Sio8a5HlU7o1uou1i8sdE/", "ab" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$A5WnMRz8DD8PNcsFgRB0f.", "ab" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$A5WnMRz8DD8PNcsFgRB0f.", "ab" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$wm2HLpJsTxGeJbd16hXN8.", "ab" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$wm2HLpJsTxGeJbd16hXN8.", "ab" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$ZXvgJMKTk2meSQmGFFxtS/", "ab" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$ZXvgJMKTk2meSQmGFFxtS/", "ab" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$esUqrAk4ExA9lTHzqeutA/", "ab" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$esUqrAk4ExA9lTHzqeutA/", "ab" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$v/7H1VxPixZc8pX.3.2lq.", "ab" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$v/7H1VxPixZc8pX.3.2lq.", "ab" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$mMElfrSD3LuRmq8IYIxXr0", "ab" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$mMElfrSD3LuRmq8IYIxXr0", "ab" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$eFQwMKsMRRjoBSI075qx9.", "ab" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$eFQwMKsMRRjoBSI075qx9.", "ab" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$7FmTpHA5KbiMguiS2NE8f/", "abc" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$7FmTpHA5KbiMguiS2NE8f/", "abc" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$lVM7wgda0NqS96p1rXpJa.", "abc" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$lVM7wgda0NqS96p1rXpJa.", "abc" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$Z9kwgXS5qWfSH43HjURUI1", "abc" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$Z9kwgXS5qWfSH43HjURUI1", "abc" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$g7cmsxdKt.wlfudrwT5ZT.", "abc" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$g7cmsxdKt.wlfudrwT5ZT.", "abc" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$My0RfHdMxCWOibFsKw0990", "abc" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$My0RfHdMxCWOibFsKw0990", "abc" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$3u/OIHOy0UMiMfEiW92HL/", "abc" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$3u/OIHOy0UMiMfEiW92HL/", "abc" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$YcmnWonUErnpK.mf79DPs/", "abc" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$YcmnWonUErnpK.mf79DPs/", "abc" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$8HOuY.OqUc/XDWEsZpJED/", "abc" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$8HOuY.OqUc/XDWEsZpJED/", "abc" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$c5LDCIVsF6DEQ5.xab0MC/", "U*U" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$c5LDCIVsF6DEQ5.xab0MC/", "U*U" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$ckh4W6t3xuZFtIJ6Z/0AC1", "U*U" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$ckh4W6t3xuZFtIJ6Z/0AC1", "U*U" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$ubD0.FdyUGtMja6YsRSJd.", "U*U" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$ubD0.FdyUGtMja6YsRSJd.", "U*U" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$cZV9P3rpKvkEd0SziHCqY.", "U*U" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$cZV9P3rpKvkEd0SziHCqY.", "U*U" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$LYSZ0z8WOsaS2VGQsqOnP1", "U*U" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$LYSZ0z8WOsaS2VGQsqOnP1", "U*U" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$US3vgHZxnaSdVNbvIr8rE/", "U*U" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$US3vgHZxnaSdVNbvIr8rE/", "U*U" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$iQj2/Q9uhHucEHehmJ8J8.", "U*U" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$iQj2/Q9uhHucEHehmJ8J8.", "U*U" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$ry39WDfDno9mLYA7EuuRh0", "U*U" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$ry39WDfDno9mLYA7EuuRh0", "U*U" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$DGKWEJRQJ0tmrIoJ6ML890", "U*U*" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$DGKWEJRQJ0tmrIoJ6ML890", "U*U*" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$vSfPyHXf94AXuq5vJ31JI1", "U*U*" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$vSfPyHXf94AXuq5vJ31JI1", "U*U*" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$MPTlDmpMkScEuZSS5Qc8n.", "U*U*" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$MPTlDmpMkScEuZSS5Qc8n.", "U*U*" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$/w7FbUHGWT19vg6Zg58M10", "U*U*" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$/w7FbUHGWT19vg6Zg58M10", "U*U*" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$XDQpYykw91t4mS5ymcBPP0", "U*U*" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$XDQpYykw91t4mS5ymcBPP0", "U*U*" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$Hi1GLp3D95IJ.BJNG4v5b0", "U*U*" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$Hi1GLp3D95IJ.BJNG4v5b0", "U*U*" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$RUFgPpn0wCSHXSxUbzK7q0", "U*U*" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$RUFgPpn0wCSHXSxUbzK7q0", "U*U*" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$CGVpnQoyf2hwZMfP01o3x1", "U*U*" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$CGVpnQoyf2hwZMfP01o3x1", "U*U*" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$d.IFFJATjxAWAGrwhC4Y5/", "U*U*U" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$d.IFFJATjxAWAGrwhC4Y5/", "U*U*U" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$EnWzCBpVdzhU2aOPIlObf/", "U*U*U" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$EnWzCBpVdzhU2aOPIlObf/", "U*U*U" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$01rSVF4L04dVv2ZG9WDGG0", "U*U*U" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$01rSVF4L04dVv2ZG9WDGG0", "U*U*U" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$1I1nVtulqeE0NyvVar4Mg1", "U*U*U" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$1I1nVtulqeE0NyvVar4Mg1", "U*U*U" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$dCciDXD7pe48.7IiP3/2G0", "U*U*U" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$dCciDXD7pe48.7IiP3/2G0", "U*U*U" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$C2qRf6H.0BwggSyymDqki.", "U*U*U" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$C2qRf6H.0BwggSyymDqki.", "U*U*U" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$YsA24aNojyria1YOg3bYW/", "U*U*U" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$YsA24aNojyria1YOg3bYW/", "U*U*U" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$DeUGw.vRgFjMVEG7aGB/40", "U*U*U" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$DeUGw.vRgFjMVEG7aGB/40", "U*U*U" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$XNM8F6G7U/OWjgteUrQsA/", "....." },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$XNM8F6G7U/OWjgteUrQsA/", "....." },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$KT1m/mJc2D49JOvROv4iT0", "....." },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$KT1m/mJc2D49JOvROv4iT0", "....." },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$vbHDah.s5mQXxNq7ETrc2/", "....." },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$vbHDah.s5mQXxNq7ETrc2/", "....." },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$dZ1YxYxBE63zWuq4N3HJb1", "....." },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$dZ1YxYxBE63zWuq4N3HJb1", "....." },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$dJ9JQn2KinCwHKQeEO91A.", "....." },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$dJ9JQn2KinCwHKQeEO91A.", "....." },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$LDogFpsr23j76cgQjPykA/", "....." },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$LDogFpsr23j76cgQjPykA/", "....." },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$15KPM/GLKsO9YOtvCBGlT0", "....." },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$15KPM/GLKsO9YOtvCBGlT0", "....." },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$BGQbBwo7kyWiiBgxvqMXc/", "....." },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$BGQbBwo7kyWiiBgxvqMXc/", "....." },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$4eWbNuqnNqnGcXTDwhjpQ.", "\xa3" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$4eWbNuqnNqnGcXTDwhjpQ.", "\xa3" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$/pCVufpCfnzsvoBuBrf260", "\xa3" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$/pCVufpCfnzsvoBuBrf260", "\xa3" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$io2qnLbEYGZO1aznIsCzC1", "\xa3" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$io2qnLbEYGZO1aznIsCzC1", "\xa3" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$ZvXaZoaKNm1kAe7GrBT7J0", "\xa3" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$ZvXaZoaKNm1kAe7GrBT7J0", "\xa3" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$Un3SaDBXf8b6MMft7KPPU.", "\xa3" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$Un3SaDBXf8b6MMft7KPPU.", "\xa3" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$rKU2FWNPm4g1kGGeh4chO1", "\xa3" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$rKU2FWNPm4g1kGGeh4chO1", "\xa3" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$1wncUZbGNo9olsRuFJbUg1", "\xa3" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$1wncUZbGNo9olsRuFJbUg1", "\xa3" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$UBeMARFRPJhnRA3MCSZ7R0", "\xa3" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$UBeMARFRPJhnRA3MCSZ7R0", "\xa3" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$KPChp6qUra6Z7AgmXUPze.", "\xa3""a" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$KPChp6qUra6Z7AgmXUPze.", "\xa3""a" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$tf07EYBIjQKctFrlUgSKj.", "\xa3""a" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$tf07EYBIjQKctFrlUgSKj.", "\xa3""a" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$McbSOwVJjbwQh7Ow9KTG3.", "\xa3""a" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$McbSOwVJjbwQh7Ow9KTG3.", "\xa3""a" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$sI7MjZFAaI7aHFev6hsH11", "\xa3""a" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$sI7MjZFAaI7aHFev6hsH11", "\xa3""a" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$oP20mOeOzcSWx5PF8OynY0", "\xa3""a" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$oP20mOeOzcSWx5PF8OynY0", "\xa3""a" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$fxT55wdIKcu1I6I/L7Rgw/", "\xa3""a" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$fxT55wdIKcu1I6I/L7Rgw/", "\xa3""a" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$3P5H7GuGErAOPB9JI/9.d0", "\xa3""a" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$3P5H7GuGErAOPB9JI/9.d0", "\xa3""a" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$cxDjtvfWEWwuVcB.G0GpX/", "\xa3""a" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$cxDjtvfWEWwuVcB.G0GpX/", "\xa3""a" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$WT2EmPo/of6AlJKDUGdFn0", "\xd1\x91" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$WT2EmPo/of6AlJKDUGdFn0", "\xd1\x91" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$w6b8PqRIPHXTFoIr3z6bS1", "\xd1\x91" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$w6b8PqRIPHXTFoIr3z6bS1", "\xd1\x91" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$zK/fZmp2D0rPfe1qM9fFw.", "\xd1\x91" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$zK/fZmp2D0rPfe1qM9fFw.", "\xd1\x91" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$X2BVd4NtkuyzM6cnzmRqV.", "\xd1\x91" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$X2BVd4NtkuyzM6cnzmRqV.", "\xd1\x91" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$uNPVV/sftb.VJ6lsFa7D3.", "\xd1\x91" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$uNPVV/sftb.VJ6lsFa7D3.", "\xd1\x91" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$s6Tt81LbN8fGUEEddqiuV.", "\xd1\x91" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$s6Tt81LbN8fGUEEddqiuV.", "\xd1\x91" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$W01/eDPaIwJcNRxPVtPma/", "\xd1\x91" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$W01/eDPaIwJcNRxPVtPma/", "\xd1\x91" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$5wP6g38bLMarRh23OoD7A/", "\xd1\x91" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$5wP6g38bLMarRh23OoD7A/", "\xd1\x91" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$1jWZgfH86Iovpv/wyloQ00", "\xa3""ab" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$1jWZgfH86Iovpv/wyloQ00", "\xa3""ab" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$9uuQD6WEaN/IKu3gN6JVL0", "\xa3""ab" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$9uuQD6WEaN/IKu3gN6JVL0", "\xa3""ab" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$Qqr.jTCkLhbShdBLf9rNF/", "\xa3""ab" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$Qqr.jTCkLhbShdBLf9rNF/", "\xa3""ab" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$iFg0LwUaGTqVCvKSQjOVZ.", "\xa3""ab" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$iFg0LwUaGTqVCvKSQjOVZ.", "\xa3""ab" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$PsYRtwkUg9hCqv4O/yE/g0", "\xa3""ab" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$PsYRtwkUg9hCqv4O/yE/g0", "\xa3""ab" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$jNkQvHOp7dK4GxR6p6HUV.", "\xa3""ab" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$jNkQvHOp7dK4GxR6p6HUV.", "\xa3""ab" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$LH7wvRqMe7/knajmqVeOK/", "\xa3""ab" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$LH7wvRqMe7/knajmqVeOK/", "\xa3""ab" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$EjVNn27w7Xnq/qnXqeJT50", "\xa3""ab" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$EjVNn27w7Xnq/qnXqeJT50", "\xa3""ab" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$Zazx59BEvPwTWLZy3AovQ/", "\xff\xff\xa3" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$Zazx59BEvPwTWLZy3AovQ/", "\xff\xff\xa3" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$DgtKjVqffMoOKKn08dTZ10", "\xff\xff\xa3" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$DgtKjVqffMoOKKn08dTZ10", "\xff\xff\xa3" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$T5U9upsDgtz2ooRAz7M3k0", "\xff\xff\xa3" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$T5U9upsDgtz2ooRAz7M3k0", "\xff\xff\xa3" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$yRTEPdMa6RMxlpzNCrWVG0", "\xff\xff\xa3" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$yRTEPdMa6RMxlpzNCrWVG0", "\xff\xff\xa3" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$sVNjo.XG1R8l4.kYkDSYW0", "\xff\xff\xa3" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$sVNjo.XG1R8l4.kYkDSYW0", "\xff\xff\xa3" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$C9a8tTmZrw/Wem4ogPmZy/", "\xff\xff\xa3" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$C9a8tTmZrw/Wem4ogPmZy/", "\xff\xff\xa3" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$Y075WrJYAWhG6guZuv5D41", "\xff\xff\xa3" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$Y075WrJYAWhG6guZuv5D41", "\xff\xff\xa3" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$ErT1cNHJcz36fhkIXUijY.", "\xff\xff\xa3" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$ErT1cNHJcz36fhkIXUijY.", "\xff\xff\xa3" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$CfW3l.cN55ZMihBMn1M0//", "1\xa3""345" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$CfW3l.cN55ZMihBMn1M0//", "1\xa3""345" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$7OhaV2/cpeu0122zI9.xD1", "1\xa3""345" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$7OhaV2/cpeu0122zI9.xD1", "1\xa3""345" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$Gnr1Y2lfuUEgrpgf.cERI.", "1\xa3""345" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$Gnr1Y2lfuUEgrpgf.cERI.", "1\xa3""345" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$FlohIbjBnn3FIzAgwsxNv0", "1\xa3""345" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$FlohIbjBnn3FIzAgwsxNv0", "1\xa3""345" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$me1BsjWhTFyWZ4VVIJXXw.", "1\xa3""345" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$me1BsjWhTFyWZ4VVIJXXw.", "1\xa3""345" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$BhSJNaupgjz.UV5ibT/YY0", "1\xa3""345" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$BhSJNaupgjz.UV5ibT/YY0", "1\xa3""345" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$YJe36.Z6aj/iIl5b0qWNh0", "1\xa3""345" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$YJe36.Z6aj/iIl5b0qWNh0", "1\xa3""345" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$mBIVMuKh9RF281HXN1Imj/", "1\xa3""345" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$mBIVMuKh9RF281HXN1Imj/", "1\xa3""345" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$8MwfBX7DAEO587BHA9X9q.", "\xff\xa3""345" },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$8MwfBX7DAEO587BHA9X9q.", "\xff\xa3""345" },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$RqcR1gku7duuWbyp25es20", "\xff\xa3""345" },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$RqcR1gku7duuWbyp25es20", "\xff\xa3""345" },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$uBZHyzyNGSOPzRmTOJl3I1", "\xff\xa3""345" },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$uBZHyzyNGSOPzRmTOJl3I1", "\xff\xa3""345" },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$MzXAxvcW9l4TsmCyW1BWo.", "\xff\xa3""345" },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$MzXAxvcW9l4TsmCyW1BWo.", "\xff\xa3""345" },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$2anjs2wDZkVUCFBAXxGEe1", "\xff\xa3""345" },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$2anjs2wDZkVUCFBAXxGEe1", "\xff\xa3""345" },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$OfNzaWssbxHD4uOSr/Ww7/", "\xff\xa3""345" },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$OfNzaWssbxHD4uOSr/Ww7/", "\xff\xa3""345" },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$mNSwJceKLy6so7ro3q0rJ0", "\xff\xa3""345" },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$mNSwJceKLy6so7ro3q0rJ0", "\xff\xa3""345" },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$eaj6Hm2IJUm4OnUgJ3h0h0", "\xff\xa3""345" },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$eaj6Hm2IJUm4OnUgJ3h0h0", "\xff\xa3""345" },
  { "$md5$9ZLwtuTO", "$md5$9ZLwtuTO$5R/cG4CL2Lmc7wTf155mh.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5$9ZLwtuTO$x", "$md5$9ZLwtuTO$5R/cG4CL2Lmc7wTf155mh.", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5$9ZLwtuTO$", "$md5$9ZLwtuTO$$FToplDYTms/5PNpWJoMLH/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5$9ZLwtuTO$$", "$md5$9ZLwtuTO$$FToplDYTms/5PNpWJoMLH/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5$1xMeE.at", "$md5$1xMeE.at$IHEADoNqjSYpSCy2mz1Z61", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5$1xMeE.at$x", "$md5$1xMeE.at$IHEADoNqjSYpSCy2mz1Z61", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5$1xMeE.at$", "$md5$1xMeE.at$$KmAqE3KH7rI83mi9/l1HL1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5$1xMeE.at$$", "$md5$1xMeE.at$$KmAqE3KH7rI83mi9/l1HL1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5,rounds=12$9ZLwtuTO", "$md5,rounds=12$9ZLwtuTO$UszC7.KA9XJuDuCoSl0at/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5,rounds=12$9ZLwtuTO$x", "$md5,rounds=12$9ZLwtuTO$UszC7.KA9XJuDuCoSl0at/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5,rounds=12$9ZLwtuTO$", "$md5,rounds=12$9ZLwtuTO$$NkpjxR6Wx0t1JVt7WwoOe1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5,rounds=12$9ZLwtuTO$$", "$md5,rounds=12$9ZLwtuTO$$NkpjxR6Wx0t1JVt7WwoOe1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5,rounds=12$1xMeE.at", "$md5,rounds=12$1xMeE.at$6PwhEnzhej3fHkbxg1BI/1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5,rounds=12$1xMeE.at$x", "$md5,rounds=12$1xMeE.at$6PwhEnzhej3fHkbxg1BI/1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5,rounds=12$1xMeE.at$", "$md5,rounds=12$1xMeE.at$$2o/WzMcgZgIP10gFnPSzQ1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$md5,rounds=12$1xMeE.at$$", "$md5,rounds=12$1xMeE.at$$2o/WzMcgZgIP10gFnPSzQ1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
#endif // sunmd5

#if INCLUDE_yescrypt && defined TEST_yescrypt
  { "$y$j75$.......", "$y$j75$.......$/FQush7wojITE6a6KwAF4pUyKZAyYRCYJdWcgqjTeS7", "" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$tUlUF19mIl6XpRTpX7LBp5ABKS8KSmDfP1gXFrZ6Sy8", "" },
  { "$y$j85$.......", "$y$j85$.......$zzMmbb9N2eIInsJNTpiAwUZmq5hS27wfdyT35REbpjC", "" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$vBgoYm4d1h/QcOpqPPYz9LsGfXN2mCFVKmYuethZ796", "" },
  { "$y$j75$.......", "$y$j75$.......$7sY4klKrG.spYAfDnzO4mVv8pcnkbXLPbRu8mK9c3OB", " " },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$.dXU3P0B6GfV.ZuQ4Pj37gi.zJoXsLmh72N97I5Lcs4", " " },
  { "$y$j85$.......", "$y$j85$.......$3ZhDisMLJc4kpXpEASNG2.tW0yVgZuSEXLUoxU.jhGD", " " },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$xX8BSaIr7LnZUNhO1aTOEgBaSrWDc8dpOnxgOYhMhjA", " " },
  { "$y$j75$.......", "$y$j75$.......$Azb4unskovkivqV5L2S5ovdEGpbGNKmfaJnP.BqXgm3", "a" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$Ve4m3xXQj6CIT78tSP/FDzNIam38Z/rZlUFmHwBcrhD", "a" },
  { "$y$j85$.......", "$y$j85$.......$f6ebtuCjkC8UHFeQayofExxwYwu79YFyIOXOkA5Mus8", "a" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$8/.fVqeICb7tzbG/qB1LWS8JeaEzOWqFEeMNYgITxs4", "a" },
  { "$y$j75$.......", "$y$j75$.......$m4cnrAlrqwYwXTENdmME1U8Wut80qJVbP/Pawl5Ocn/", "ab" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$JfUZqvntjL1uH381/J1Dd/5aJZdD1CWWWpfsPNLm5d.", "ab" },
  { "$y$j85$.......", "$y$j85$.......$ih6Nb7ewCX4QP6ez/CGjxHkbQHbEUZHji6.wYP9P8vC", "ab" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$r1hlKf7zyDI/l/WXaO43BRD2R4dd7R9bUVuWr39W3V1", "ab" },
  { "$y$j75$.......", "$y$j75$.......$stbr2M6i8w/SU36N/.i6VVEHCMYG2OkDpj/I1wKYZC4", "abc" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$aN8IREm4mVoXwP2ZkEbfFinwVjML6Krr5zkB50rSJX3", "abc" },
  { "$y$j85$.......", "$y$j85$.......$OmeNRbjUy/kse/kx039zqvnLEcMwpvMsRr/MKAccHW0", "abc" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$UvuqvbTEtM2tjSx4PNDuWDTu7ZH82t51dznnOS5InOD", "abc" },
  { "$y$j75$.......", "$y$j75$.......$B9odMQM/B2QLVLHfsJEC5lAgv3j/JVoUzO6rSxbqEDA", "U*U" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$qg5uCaJyN9mqNwXudbDtC1qEOS/SINLqwjTdEN5xk52", "U*U" },
  { "$y$j85$.......", "$y$j85$.......$.mv3bVd1BEBrjfj.7o6SNMXo7F./76n9r7sfp02/rDA", "U*U" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$kR.1Y8IoXykHJ.i8QnvTf2TYwxwkBPetGGV.3ViURz5", "U*U" },
  { "$y$j75$.......", "$y$j75$.......$6H1Mg4EQDxxqJ0GHtMNRrbONT4LwKO.gjTFIkVuOj71", "U*U*" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$7cch1Te3ie5Hyrj.cx6OJEtD5GucuHML1.VC1Ws/KP3", "U*U*" },
  { "$y$j85$.......", "$y$j85$.......$YiwOtfXn1QOC30s0ASMEsMWPRVoaaFpLgDg27gzvmD9", "U*U*" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$6fM8sVHyWF77ZlxmtO5CWutdCipgcQJL4fEABM7rrR4", "U*U*" },
  { "$y$j75$.......", "$y$j75$.......$PACNP8rgVa3N4PjCnsU1y/LaaSLDczCtvx4SVoeAKfC", "U*U*U" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$Zmsp/YP9Syl0F8xHwa16Yj09NnetFlH90LPtUmVTQkA", "U*U*U" },
  { "$y$j85$.......", "$y$j85$.......$T94HJZtQZS89indO6tpwqWsG6lz2j1cDtwNBSkp.ga5", "U*U*U" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$owrjAyK5Mj2kmFTp4wY.8rGcgnms6S9Cc7bnKJhaSf1", "U*U*U" },
  { "$y$j75$.......", "$y$j75$.......$ZCBDDwUvZmAYolgFx0dEOG.xddgO9j2kCik0j/cfp3.", "....." },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$ZBCjHl.chaOfX8R7SQSSgmjqcbrScEj2RG2Fv0OiyK3", "....." },
  { "$y$j85$.......", "$y$j85$.......$Era/o8syD90O.jxu00Rd53DBW.2Y0Cv3DjYEpbO9hh.", "....." },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$sHtH6IOD2QxYnWK82wGJaoDoXk1M0eQt9l2fUbqtzW8", "....." },
  { "$y$j75$.......", "$y$j75$.......$gMy/pYNgzmP49aAL5urUtAK1W.9qMlMJOFZY9tMlYA3", "dragon" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$KdzgkknR77mrk3X5yAUt9w27j3DuAmnAhuFZy7MAY5C", "dragon" },
  { "$y$j85$.......", "$y$j85$.......$U3/SnDOqn1VP6YIo4SwaJ0Uy7w4WKrMQoUZZ2ddBN49", "dragon" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$0LxVYF3PFv8KyPej3fau.J8QjrXe/fqj8G2Uh9YzzdC", "dragon" },
  { "$y$j75$.......", "$y$j75$.......$wIiGAotJxWMKSkSsp/a.F9I9wITKTH4/cqdbTd58uS1", "dRaGoN" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$8pqiZU8Sjpl/msFkwFTpOjK/P9yGxUvn77/Yme7cAX4", "dRaGoN" },
  { "$y$j85$.......", "$y$j85$.......$r92bon9zT3D/KRtNB8GmoC7Oo/.Kwz0NlxsPpK0ExiA", "dRaGoN" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$gN4fCUcA71HcJYqNCOumS8eQ0suSmd.FPkVc8SkcJE8", "dRaGoN" },
  { "$y$j75$.......", "$y$j75$.......$RvCYhfAxJV1IiYGsthaHTYADdH2G0apxqjz7oiN.Ay6", "DrAgOn" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$sT37jX9RwF/E9NiESFgm15cssiiqnmh9F880./vz4k2", "DrAgOn" },
  { "$y$j85$.......", "$y$j85$.......$rLtG.1kRrOgsaFU7xyyZoKNy0lPRiYMhPPf0AksWSq1", "DrAgOn" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$/SMJ.RHHu4oox6zfaZv8MeJGf9J6WqZFo3fbrXchSU3", "DrAgOn" },
  { "$y$j75$.......", "$y$j75$.......$yhucF/AHPHoRCo1pyB/8HqUUknh9Qha5XwmRSWNbzW1", "PAROLX" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$n6LGRqxG1dss0ne03lEh7N9rSUow3ZqvN5Y9q8ykqw8", "PAROLX" },
  { "$y$j85$.......", "$y$j85$.......$B7kWn3cIqxkpygmYyPsFqt7viJEo/VWOo4NjXkygBV9", "PAROLX" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$/tu1HvJEfH69pHd8ucinYj66VDfkWFsZMRsircZ2Zf5", "PAROLX" },
  { "$y$j75$.......", "$y$j75$.......$5f/J7kwHfEmgNwiDTvlgW.ogkFEg0co85dGb1Y3alz4", "U*U***U" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$iq6o7U49bdvwtT4YtG1so.gK2G3XxNycAxLrG.l7Yi4", "U*U***U" },
  { "$y$j85$.......", "$y$j85$.......$2DN0XilWmbEVeUjKnBH6YVKFCRapOi6lzuIpvk6QpOB", "U*U***U" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$2MhtXIjJe46l4UzEvM8DqE9kwUiXYJ4xOmB0do/mD/.", "U*U***U" },
  { "$y$j75$.......", "$y$j75$.......$Oexrj8H2hVMPS6roqSJDmrInWLzlOjFgLmuxXm8Qqm5", "abcdefg" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$Ptc/JaF9eGbpjwj/kdmJVh41nUZ6r68e.9S84trDA2D", "abcdefg" },
  { "$y$j85$.......", "$y$j85$.......$68kILCeYp.dC4HBZonpV74zWphydKMQPNe.PfGKj0S5", "abcdefg" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$zrhv2ITCB/LYe7wrMLRga2j5jD4dmY0kyKqx2fba.K4", "abcdefg" },
  { "$y$j75$.......", "$y$j75$.......$vSDAeHx9Q8hfWNYhDdS/ADenNchyIyWKsORm0p9poOC", "01234567" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$vrF.0OiBfLX6jtDOQfdX5erkqiw3qpWROI.v/S6SHt.", "01234567" },
  { "$y$j85$.......", "$y$j85$.......$tILMEe8DtVt9VeilMONf4KbYPQGiUXu2G6OI2dv3cz4", "01234567" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$lRmA/CtQri0iW/hHOTzQewNaXCDz/bh7JP.StYQmrfD", "01234567" },
  { "$y$j75$.......", "$y$j75$.......$rFyadMjTjbpLQ3Amr8FdGSPDkj8ty0xjC.5/3SLzcjB", "726 even" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$k4dSODsKeobDaJRbXpRTR3.qL1rJq0dUdmoJhS4HztC", "726 even" },
  { "$y$j85$.......", "$y$j85$.......$R/Ecl7fBdNbKFnkIt2SwwXwftNoP01nO9VL5rMrVPC1", "726 even" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$VRXkfdzwZXHcV4GA.ssGwrNPxD2TKzbhlPnZkwUvCa8", "726 even" },
  { "$y$j75$.......", "$y$j75$.......$bwGnlPJcAaFY7QiJtQEzLFeGVd.ZOJxegBPFVTPV8j5", "zyxwvuts" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$B1Dn5/XFjZtl5m/6QQGgMXKU2YjIfn55mTp/1dhNzgA", "zyxwvuts" },
  { "$y$j85$.......", "$y$j85$.......$XhOpt.z.U.rCweV4yA9B6ZOc2iQWDG.VuCFnUhIwOH0", "zyxwvuts" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$31GHnkn.dYKV8no..z48s0nnKE7Q5nHkEyZjSTcHzL.", "zyxwvuts" },
  { "$y$j75$.......", "$y$j75$.......$/28Hn95nD3Xrq3C8IlfTCmyqtC0RMo6sAa3OnQ0zdD5", "ab1234567" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$8A9gon1kngVBk3LhZMKKU9L4I2dEahDdH9YfPBLocW2", "ab1234567" },
  { "$y$j85$.......", "$y$j85$.......$Gi5SrS5hrVX3i7heJ7p0pDJZw99B6/Y/8VWSqRi7k4/", "ab1234567" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$FV0XuI6Wd3lRtW6K8kHISEH5kQd4G/wtm26yJK9Onr5", "ab1234567" },
  { "$y$j75$.......", "$y$j75$.......$uh/6GkXW.YnzFYoZB41fmhtce4MEJ3FqANOq1QG0RG6", "alexander" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$BDKkgFmTj5KY.hH4CWNzbSKQRHpBZ3aiPLMVaC1LgfC", "alexander" },
  { "$y$j85$.......", "$y$j85$.......$PYRih1z.MBBKh/VYlBzOSmD3nCREwnwogWQjFa/Emf9", "alexander" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$VM/zNStijfS5BuBdaEYTF6nh5DOEKzAdjFlfTP/55cB", "alexander" },
  { "$y$j75$.......", "$y$j75$.......$wsnn8OuvATBVLwg6JEr36FgStoNAJM0pzn0tBwlaZy3", "beautiful" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$J3VqPVfvnWXlEFe7FhqBINV4.hIuXSs.RaZfRCR04lC", "beautiful" },
  { "$y$j85$.......", "$y$j85$.......$UCtZe/e4AQM6MXCP2kZyynmkvYUo3SQy4Ziq9ivE2S7", "beautiful" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$lptRgOFZYFJrayM07farXlKG4X932yV3LbggAohzUH2", "beautiful" },
  { "$y$j75$.......", "$y$j75$.......$Wan5nIS.hGTPfs9IkwSR2O2MsBHapbJEiO9Q4kELJ7C", "challenge" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$k4KIU./8FgH.M0UjpzM17GJQqZkY/ceJrPks6RnQZJC", "challenge" },
  { "$y$j85$.......", "$y$j85$.......$WDXAloGQvP7gK2eMGIGmppXal0P0e0OAkwGJxvMp1M0", "challenge" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$tztDZhYuITVT0PEaLV2xqZsu.JW22Q/ydKTOvhjk2G4", "challenge" },
  { "$y$j75$.......", "$y$j75$.......$FdihoTp4oeAiLvSu0FB4B3SVdQsh9RL58ae2gCFzik4", "chocolate" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$CrfNUh5xMCUTnoCfOe8Xkn4OIkGuKr1NZfCIXCBOb/7", "chocolate" },
  { "$y$j85$.......", "$y$j85$.......$wgh3g27cjnpTJqhliv85LcePfmIHFOAs91nGVRBQsG2", "chocolate" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$Um5DQwznRL0JO54YJd851tWpWgCilzlcb2/VhW80Bj0", "chocolate" },
  { "$y$j75$.......", "$y$j75$.......$GfJb5gz8E0YlFwUeUe9gtTByiY6jyyF6tq8FfAAZKN.", "cr1234567" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$R7OKe3JRbE6HNsjX4iWw4M2K/lc7bn6cDcXid1p35q2", "cr1234567" },
  { "$y$j85$.......", "$y$j85$.......$PJbOqqMBycy29ZI2ns4tilubtkfx0qQZHH3ZQqJu0R7", "cr1234567" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$fYn2u2yXhbgqGFupd5Fv6tKs02MPkchm/6LJtrEH7LB", "cr1234567" },
  { "$y$j75$.......", "$y$j75$.......$PZvyjYH68X2v60Sc46lxKw7uC1M/9Ytq4.Ba2UfKDj1", "katherine" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$jgWFjlO7QV12gOmLRvdzvl5dz81L3a/T1vbMr/8Bdo3", "katherine" },
  { "$y$j85$.......", "$y$j85$.......$Bb8S5y0Yes1kWP/5Xu2eGKdXJe8aVQFyqvSHFxXvo.B", "katherine" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$lV2SLFuNrHFvA5u6Quz80OywW9Nd3Zppqfe36Itk1p1", "katherine" },
  { "$y$j75$.......", "$y$j75$.......$y6Z/2U8B7k.XHl01xCENAfAdhLuv0hoEHi3RfP.7X83", "stephanie" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$y2qD3I0Dx9wfp44mm3DTuj9qhtXRZ6JuDLs.tl8PRP1", "stephanie" },
  { "$y$j85$.......", "$y$j85$.......$crMnG.pTDhnRFL6tycNwNmTpDRrSnr7oaiie5v/aC19", "stephanie" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$rxh/dJN69oAz00rMN4L6sMv1G5y6m7jHCByyqpSYLFC", "stephanie" },
  { "$y$j75$.......", "$y$j75$.......$3t0Tv4xlsxxIiRAbZRDjFzVPlEkN.xbkMGI2p32ZbAA", "sunflower" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$lDgPdzesIlqCwfYMD5NZQsCkltW8CBJxdMxeux1xQA3", "sunflower" },
  { "$y$j85$.......", "$y$j85$.......$FZY2eAZBfHWTGWazFqD96tg7MS4AZDAG3ykgOzmD.35", "sunflower" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$ePN0k66bV176GoRdGDo5W7S7yH2ZisbyVpbTj1oGLiA", "sunflower" },
  { "$y$j75$.......", "$y$j75$.......$w6pG21vDZJRBadEErbIgzWJsv1LqprVFJfsOZBQKZM6", "basketball" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$b68lZZuAfsp1iM5N5kE7a0KpxV6lEhNafQflvxWlYU4", "basketball" },
  { "$y$j85$.......", "$y$j85$.......$B1i92iBMuTNyacZnVPTneaPw2n8lIUJxbrj.gCU4MP1", "basketball" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$BvuTmsVWl1B4hTMu8a68niXEIchrSkwY7rK24Eg1HC5", "basketball" },
  { "$y$j75$.......", "$y$j75$.......$SAL3S.R3yaNpmo4cbhIPtg8sI1GZu5HEkv.1K/BsXZ7", "porsche911" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$Tm420wgVp91I.KJYcqv6soAIPj0Egq6HcOCmB.Z6/C2", "porsche911" },
  { "$y$j85$.......", "$y$j85$.......$PvTUZyM10XhZ4TI.SCkks0zaa7oLmHZ3AEm5bxugB/7", "porsche911" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$S9GqWx7GF2Q5jW5H8/qq1scRC50qcW4adkHzuyaxZL8", "porsche911" },
  { "$y$j75$.......", "$y$j75$.......$Qz/8Nw3eZ5D6n1ZcVETd/KSGZ6MbTsUJGq74wayf3kD", "|_337T`/p3" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$phuG.GfilMjsQgP3lUPghPfnNgqb0zLyda9lpkVWJG5", "|_337T`/p3" },
  { "$y$j85$.......", "$y$j85$.......$08areKle8YW41P7DAd7AxaExVwgSHoLV8BL/BwDXoH0", "|_337T`/p3" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$fq4YDTQZG2Pegmmq2BtjUfaOlRXY6tAv9e0ceFpTiU7", "|_337T`/p3" },
  { "$y$j75$.......", "$y$j75$.......$Y/3KOWQGtXCWddmY.jhv4TxXyVnPeFb7EBM5SvTQ7HA", "thunderbird" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$8PVB/qPJ6.QB02Cw.xXkmH/9jtK552.jV4X3cs/AwKA", "thunderbird" },
  { "$y$j85$.......", "$y$j85$.......$NdY1ZhskId51bCXTHxhc1Co2C43dkh0/FwP340rDRK7", "thunderbird" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$IWoHO323xckmD7hz5O8cB3TV3jcVt6nvFBPS3WcFkL5", "thunderbird" },
  { "$y$j75$.......", "$y$j75$.......$pufaYitKyIkZ.NWfVYAUyRXoTBDYCdJzEUcX42001t.", "Hello world!" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$7jWcEoQKhxMUMQ0E.6waDjn7XDoqraSK3MjNTjRQ6R4", "Hello world!" },
  { "$y$j85$.......", "$y$j85$.......$j/S1DCRpqPq6lIR7fBtz4KTgd726qw1LrBaMriTkU15", "Hello world!" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$Bgn0rf.zRxE/DaHqyxcNw5e0Jin8Fxo6KVUmWxkAFT6", "Hello world!" },
  { "$y$j75$.......", "$y$j75$.......$4BCCMdYqJIh8un09wEJiNI5xA9HEcq2bR4lB2hHmk7B", "pleaseletmein" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$LOFz5qVpaHYHlkfy7RM1hH9gRBSqy5mk4KRmFVRFKM4", "pleaseletmein" },
  { "$y$j85$.......", "$y$j85$.......$pqqOReIA093nDWWsIrXzu7kwnCu10SbTz19KWDf9R.2", "pleaseletmein" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$bAfr8bOshRhNY74kqJ7IEJD9fzS2/JRu6jYSI5oSKpD", "pleaseletmein" },
  { "$y$j75$.......", "$y$j75$.......$qd0.mS0ZK.2HVP4wbSbu5RpgqsVHjDZA/5S1Ykfn6s7", "a short string" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$6v3T8C7.WH9kA4nbq4DmUR7T4vXq48CT9hDfLdi2Zt7", "a short string" },
  { "$y$j85$.......", "$y$j85$.......$ZlHk88/KmNCcx1e8.fTbOrDLs7vqEmXMbMKaUIDHFSC", "a short string" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$V54RamiustzxvSKbuVA3bbw2Fz1tJ2v2DG1LzXfyJU1", "a short string" },
  { "$y$j75$.......", "$y$j75$.......$YwBPJ7vfLRfaZyOjIPwp7PDWj0KZCnEn98sBZKdqdf7", "zxyDPWgydbQjgq" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$MVXnlaUlLnjxC8.Opa45IbXEnQlFxosD999ArFpyv1C", "zxyDPWgydbQjgq" },
  { "$y$j85$.......", "$y$j85$.......$U4y9nIzgWDQB5wfu9aokmtWp1kZZ7gc0/uAyUApZMp8", "zxyDPWgydbQjgq" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$XyPXET3kw.J0C5VhXLS8z342mrNCc4aAD/gw6pDVJSB", "zxyDPWgydbQjgq" },
  { "$y$j75$.......", "$y$j75$.......$sq19/LDU/9VSUc3U/39p.28J5gDbovkn6dRuJRdrfv.", "photojournalism" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$4m.JXUU8RUMeiuUOPcCumS0lnETcsS5krf2/gwbSek1", "photojournalism" },
  { "$y$j85$.......", "$y$j85$.......$Mri/OMLkgc5PNI5.yavGabYbWZuUoriH2jOD51j.7z3", "photojournalism" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$ffH68z3cM80885GlB567cFXUR1unVj5t0kXhBp6YRh9", "photojournalism" },
  { "$y$j75$.......", "$y$j75$.......$KrwFvcUOidbUxoPIQ/0G4QprqAMPCr9MNP/LAC2nMG5", "ecclesiastically" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$uxuo7SJQBjkAPuzhzjftYUcAdkW9JyWspWDcamhZMj5", "ecclesiastically" },
  { "$y$j85$.......", "$y$j85$.......$TTFj4Z94TTSmHHWEVyxOrAYTqmQOeLyrtttrkZCwim9", "ecclesiastically" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$uFP4C7KBVOPtHyJMJFPmZni9WwImMXcf7vhB6LNQgn6", "ecclesiastically" },
  { "$y$j75$.......", "$y$j75$.......$RA.KNb9VR1NtaOKYYbXK30O92aAeijEELrK0tm/lyQ3", "congregationalism" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$SDrqOyOsh65CSZlU5QwWgK2SCu2Nz/mIAg4IqHtaKRC", "congregationalism" },
  { "$y$j85$.......", "$y$j85$.......$/boIFwQ1YeYHApfoAcYO1Kdu0jN5kI7maZsIi2LRnwC", "congregationalism" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$WwdywFM7iMlb4ibJj7UHw0WaMEV9WSXqgvOKFhfBY8B", "congregationalism" },
  { "$y$j75$.......", "$y$j75$.......$o9BxZefx4cfMy5ns3pqW8GKHp/NFt2qp7FHdkR5vE44", "dihydrosphingosine" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$KrY1j4hodif5jMyalcrQU7k/OyXznoS7iplWuu/A8d8", "dihydrosphingosine" },
  { "$y$j85$.......", "$y$j85$.......$WfCJQzJ/GBTrSi78dpmCIz2Cfb4cQ4JccvSYZY55rN.", "dihydrosphingosine" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$iWwpKnRm12cQWXl7ygqxfcrbGvzt0A8ZEFrnbdX4v0D", "dihydrosphingosine" },
  { "$y$j75$.......", "$y$j75$.......$NjaFf4yZ8pQb50CeKfNl28sPqNV6XApKlb9pVHmnTA0", "semianthropological" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$AOJaKlXc2m9fAvHkhDNY3LnvTV1DVk8fVxK9XKxyklA", "semianthropological" },
  { "$y$j85$.......", "$y$j85$.......$6TlC0yGSrDU9/7OmI1X.kr807CqhURb6jzsB7/Zmn26", "semianthropological" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$SDmpfFPxUxlWAhXMC3hsiUAdQ5rtq5RwZ93BgUecot4", "semianthropological" },
  { "$y$j75$.......", "$y$j75$.......$VOayCQJjtTXCQ8MJTCpIJu7aqA69XDKPAcVwkMiJckB", "palaeogeographically" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$kMOB3hGOWm.5ay03gv7xY0ChoYNnOOjbDPO6c/pLZY4", "palaeogeographically" },
  { "$y$j85$.......", "$y$j85$.......$7BYcUkHTqy5SJ7HODzTAEVi0iVdtllEjzEsvs0ZtvR5", "palaeogeographically" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$wdIBFXU0DybvDKphDQReMSe1acXyOKge1mrPIxLut39", "palaeogeographically" },
  { "$y$j75$.......", "$y$j75$.......$55B82nY8lbxrXopmyZSsX/pJSmHk9dKrgLAzPDO2kHB", "electromyographically" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$jCK1qDm8Z9S.TE4zuMHDKnoBZYfxr/Uy5RNzOyMs5EB", "electromyographically" },
  { "$y$j85$.......", "$y$j85$.......$hKbtROb3sVNcMLQlewE.zzZc7pDaPURGFdUNCp.NdQ3", "electromyographically" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$.MsGXOW6hS5s4FpnTsk.VujgLTJxh0hrePDi4RLxJLD", "electromyographically" },
  { "$y$j75$.......", "$y$j75$.......$oeux1F0j8ylt4EAUKSn/RRsWoH8NRxZ7/115pKf4OJ7", "noninterchangeableness" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$jyj.ILc354MhDbE1DzFyCZsk.Hmx7u53AdYX4eP3QBB", "noninterchangeableness" },
  { "$y$j85$.......", "$y$j85$.......$CZZrxLjJAp.2tRu/z6tu3BIs.2ZrkXqpdLO5TxXAomD", "noninterchangeableness" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$zMrO/A6oUC7/stkcFKl55HXSBTDez.9q/q6R6F7ZN0C", "noninterchangeableness" },
  { "$y$j75$.......", "$y$j75$.......$Q6INTIUqVhIISMLT/ZawC1QOmUyqb6pDXT0KUbM8xF2", "abcdefghijklmnopqrstuvwxyz" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$YNDvFyH.qHNmyrTszZI4SOiQ/qVvSTYDKYjXZyvG05.", "abcdefghijklmnopqrstuvwxyz" },
  { "$y$j85$.......", "$y$j85$.......$m3x5iypa7ModE9pWOxfuS24RURs5P44U.Z74.9bnMO2", "abcdefghijklmnopqrstuvwxyz" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$7OqikRK7L3lKAdPmG6j11toBXcw22osyrMftrLEK2IB", "abcdefghijklmnopqrstuvwxyz" },
  { "$y$j75$.......", "$y$j75$.......$krhhCtPNlJmSH99F.ZwUsIvjbaVelDTjUp5j9RQpnz5", "electroencephalographically" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$aEiBZ.lsS4g7WuffKVvlqRnhjpjc6vfZD8.VZLZ18w9", "electroencephalographically" },
  { "$y$j85$.......", "$y$j85$.......$KYGJ3r/PjCRAiKzO1bVhDQ9VaO0PN8hWEyns1ano.J8", "electroencephalographically" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$jiD3ojm0fPmPFjAzt8HsMWnTGdmxiAgQkVt2My0H7B7", "electroencephalographically" },
  { "$y$j75$.......", "$y$j75$.......$1SRFYhiNyk1CBif9Eoy/YjV7Im3rXIMx.jocaEYFBp.", "antidisestablishmentarianism" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$A9xWQtsDkQBVyIXRJIN7nGI6p5SgDfNc5zy42OXf/O1", "antidisestablishmentarianism" },
  { "$y$j85$.......", "$y$j85$.......$hwSL8szJRB0KZ2gARhwFPJbM1CEAO5oKu4QePBIP.35", "antidisestablishmentarianism" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$PLbmxP/.HJDfzuILGvSnJ4XKFDW14dDGwgNgjbQ.mw6", "antidisestablishmentarianism" },
  { "$y$j75$.......", "$y$j75$.......$acP22XrS6a5ERFUnUGxoj1WeSmiDxol0QFWG7XmoXG8", "cyclotrimethylenetrinitramine" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$zo0ow6WQl3V5Pdf50i9OgXtXkQReigG3w/xI4cvKGRA", "cyclotrimethylenetrinitramine" },
  { "$y$j85$.......", "$y$j85$.......$oe5YkqbB.uT394t4UBtfPLSfxgCvfbIA4eQkkmkETF.", "cyclotrimethylenetrinitramine" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$tzvUqJHxICPbgT0YiVHc/D2MXXPz6XioAFxSZD6TH73", "cyclotrimethylenetrinitramine" },
  { "$y$j75$.......", "$y$j75$.......$gEtqbNXBiWRWRU5LSxoyCbLxxdO4CpFYTDckoR8PMtA", "dichlorodiphenyltrichloroethane" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$UFQ4WQ.Ae/.enSnCMSHnIV22lcJ/R4HfnGQLMAeEXoC", "dichlorodiphenyltrichloroethane" },
  { "$y$j85$.......", "$y$j85$.......$xXb9GNRBYY1BJys2R8Nh8p3P/zIbaQ5FRgpjdhMZNcC", "dichlorodiphenyltrichloroethane" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$uJTtWeFKID4ZLqAdYERWhs0ZOa5nZ2Uf/NNtcScLEs/", "dichlorodiphenyltrichloroethane" },
  { "$y$j75$.......", "$y$j75$.......$GYg6LLsCbWr5l8H6MgnHGBE43zqZ63zFlANeMi2Me33", "multiple words seperated by spaces" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$nmEOzm5zwjg8prkf0v9eSLpMUdAmcMhdVGHelR7O805", "multiple words seperated by spaces" },
  { "$y$j85$.......", "$y$j85$.......$CycUDxoxlqPK9WAwqNxq5jhbO4VBYicZOxjsxtfePj9", "multiple words seperated by spaces" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$zLZZCV7b8MWGjK364GG5IAs5q9CTIGbjrb0pDlM9Wx7", "multiple words seperated by spaces" },
  { "$y$j75$.......", "$y$j75$.......$TIRisR6icF961PZADPNUuQ4IyNo3RsLXeHYjcWEs3o7", "supercalifragilisticexpialidocious" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$MKQFUQSxouxcIfy0zzTkL715uzoMo8OK2H6kSFX6Ad0", "supercalifragilisticexpialidocious" },
  { "$y$j85$.......", "$y$j85$.......$JptZ9stAo2Kd16dZwa7WKierQpfoToBFOeBlGigcxV7", "supercalifragilisticexpialidocious" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$e2UBwFQnG5HLb53e4wY.w3eKgqRKSHW72LO9pXdbK/C", "supercalifragilisticexpialidocious" },
  { "$y$j75$.......", "$y$j75$.......$pMPSS2G8Q.c6cASGpXXcspZDtuelQdeSnFg6Tg8ol27", "we have a short salt string but not a short password" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$mEOM8D9n74/Tv3oRnrCb8eOE/3yeCsQfe6bXjAWDWS4", "we have a short salt string but not a short password" },
  { "$y$j85$.......", "$y$j85$.......$Yp2f/ney5DfedEXUrYnnjDve0VZU6DqWc3/RuDD1R81", "we have a short salt string but not a short password" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$vWwIMvMNdtzA.bhzhR3ddqBoR4Q2HjxwRHAcBqc5CQ1", "we have a short salt string but not a short password" },
  { "$y$j75$.......", "$y$j75$.......$T7zg5aGkjv7PqdA2ENCtz9f.sEq9qzZJQK440SvGvn9", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$9P7F.Z7i3OWeSxxck74puDcbgRyos2peWauAuuCJmU8", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$y$j85$.......", "$y$j85$.......$EctcB4pnSfHgc/3/IjT.e3eaMJYCzOgmT7hI0dl65D4", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$jZxEeajWFN6X0CWs6oQH0EFM3ubVpLJGiWeGnWZTS29", "multiple word$ $eperated by $pace$ and $pecial character$" },
  { "$y$j75$.......", "$y$j75$.......$l3LBuUnjh5p14rHbfaq5RIlOyTJKf1FwUQcMGevD9w1", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$V2eFxIWbmpV5HoMDMO0yAKbNO16AFPp60j3neYyxkGB", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$y$j85$.......", "$y$j85$.......$fBbahOKwsnsFDz.Fj2m4L5Y1jhYAMa5j1YPV8q898k7", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$m1c4LIhXJURC9VKCOrWnQ.fLRYPgKe1XhQ2lUXTVWD5", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
  { "$y$j75$.......", "$y$j75$.......$dAe4BVoPscaf5jj.jeK4/2Eve2T60PJPeSYWevsFbe6", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$kL5aNawo/K9stdq6ccKp2LKDaWoYgkN608x67.LaP3.", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$y$j85$.......", "$y$j85$.......$P/Hv6iE3IaOvkGzwravk/jrdgdZuUQXCAkEEq9fR.Y0", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$ScSHwJjPMTEQbfWpv7UInCjQOlY8/jHHPIwvJTCJE/0", "12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
  { "$y$j75$.......", "$y$j75$.......$f1GovCsVarj5J9DzqXNTF0SDfAOgW0UYyMdoUW6lRD4", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$Sl.2H7uWEilpZAJsv5sGqMqGAUnfmbXUXCrGO3c/8QD", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$y$j85$.......", "$y$j85$.......$GavTV1IxKIGHVEWEvjDs3XLEaSmbEuatBGiXM9OVqZ/", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$hsvl.lO/qRm/7SX8ugjJ99qGtJ.7T99808PQ8g6QL7B", "a very much longer text to encrypt.  This one even stretches over morethan one line." },
  { "$y$j75$.......", "$y$j75$.......$v/AHVX5OCINkV6aEtD0fPZWVuCBpb4zHw5u5crGECP3", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$e84hur2sHb36vxaY96XMO2FgyTJ4NCzmzgQdY0asn78", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$y$j85$.......", "$y$j85$.......$4TTnF4e8cBMEoVBQB9CgKyjX9qPNBIGuUTHZNybzYW0", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$xoZuC5mHSxpNTAA64K8vRHApeirQySj9XePL0xhB8DD", "\xd0\xc1\xd2\xcf\xcc\xd8" },
  { "$y$j75$.......", "$y$j75$.......$byyfXzCdVYYaX5HXnrI00ABQoX8u6KBCdU2n1Jw1B92", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$IQVJw/isQDL3EDGhAIjik2RM1ML5jLp30UDNKRte5YC", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$y$j85$.......", "$y$j85$.......$dalk6SpXn9oBRMuoI37yja79J7gf6sXRXoSrML3z/43", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$ntyIYQCvkO936l7PduoNBHokYfwYg9g5ZON1LMAJap0", "\xd5\xaa\xd5\xaa\xaa\xaa\xd5\xaa" },
  { "$y$j75$.......", "$y$j75$.......$yAXMnMegZ6zoYLa5NyjEZLHxJqKD47c8SHvo4OPnV99", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$oQgZl/Buh695xmQuzx3PKMlvNtNy8PJqJIg1nGIrbh2", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$y$j85$.......", "$y$j85$.......$TDInLXdLRdgX0yoH1eqjObMhhNl3cXEP6fhIILsLSKC", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$mjoKPDzO7rmL4rgxLHaJ/fKyOYEekYR/q04D6ZdRU43", "\xe1\xec\xe5\xf8\xe1\xee\xe4\xe5\xf2" },
  { "$y$j75$.......", "$y$j75$.......$z3HAsdyEUCw6oNEQGbjY/SJE67wT/LbxSFm4naco7/0", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$zc5xEgCoVgi4LYdlLoGsuuJ7FVw.zHElBNW9mpJSSx3", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$y$j85$.......", "$y$j85$.......$T.A9BfE4lOUYWYsiIE0b4HOcQp89UoHbXBZZAqdF.96", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$AiUlAUMfDgRQ6tLRaGXWbZwvxu2TwKgcd8U0DYZamd5", "\xf3\xf4\xe5\xf0\xe8\xe1\xee\xe9\xe5" },
  { "$y$j75$.......", "$y$j75$.......$cOCyRRwVilnraPa0tjbdRpDZivpGJljtO8GHwzqiFj6", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$t.8PPxALiVYgZmrb03uS4vIZTDTgHGf1TlQ.TPlGL9.", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$y$j85$.......", "$y$j85$.......$McwPo7oQ/IkY/DKQxoG3w5yE9rVjZ.gWOrAbXmgm1./", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$07UgaNQFuCB/6XhoXP/7wn1FVzkxHLTy1bI/S/Q7.16", "\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xd5\xaa" },
  { "$y$j75$.......", "$y$j75$.......$sI7RyjhB97WNUwzsZYS5vveZ34q/Iz7x9eYi/px7Kq0", "\xc3\xa9tude" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$zwEkXTpleQb38SUTKZD5XEkaZbn9RJLlzRA7fT1HX21", "\xc3\xa9tude" },
  { "$y$j85$.......", "$y$j85$.......$XOUj8SgY1uyy0UDLubY/Ax..UUFthol9rNePgmYFss9", "\xc3\xa9tude" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$Z1Z2Q1ArPGYVSVqJN41MQZq/17sl1XFsH8AXoFvdPc/", "\xc3\xa9tude" },
  { "$y$j75$.......", "$y$j75$.......$wLsp3pISikh/GgG95SF3zUzdyAgip8Okb6S6NNtlPqB", "C)tude" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$e0ygMnaqiEFsZijBJdN60j3b3rRvos2iX1AP3cXM3F5", "C)tude" },
  { "$y$j85$.......", "$y$j85$.......$lx1YjzZHlCLelIGDbT5kW2pCpbOkYOpMRuH/1yrnhYC", "C)tude" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$n8MhxAIWaaCQJdBnqafj7e0iJu817ZP8WkysKVPfpC7", "C)tude" },
  { "$y$j75$.......", "$y$j75$.......$J82yPQuk4ANq9kiKs6yITU/gf8oCRQP7UDeUktxWwh4", "Chl\xc3\xb6""e" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$uyzanVvvlqEW5EOu.RVgqK2syNXi6zO5mqCdfx39A/B", "Chl\xc3\xb6""e" },
  { "$y$j85$.......", "$y$j85$.......$uMEe9unOziC8wuBomf/hdHMq6sBKabTPdLscxXptMD.", "Chl\xc3\xb6""e" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$cjbsS2axwGKnoXW0ZeDYG1jYEQkidY2U0aD4EhuSTx3", "Chl\xc3\xb6""e" },
  { "$y$j75$.......", "$y$j75$.......$RatMorOW2rNdLl/TxBppLij1VZTXTenZ2yjMl0ZbcoC", "ChlC6e" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$iWMKU2bvms4.GDbSDRAmF0o7gWE012ofo5MdVrxbDh5", "ChlC6e" },
  { "$y$j85$.......", "$y$j85$.......$vreLrIaU69pVDlSVzYg0BXwK09efnvqpeTt/kxWZFa6", "ChlC6e" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$y/LLie2eoT8E.RONmtIbjc7ceo62JYROChnanaRwDo7", "ChlC6e" },
  { "$y$j75$.......", "$y$j75$.......$FzvUTzntBI5wPOrRSwo1QjjFFmBVsl.c7wlWiBnuXp.", "\xc3\x85ngstr\xc3\xb6m" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$eu0Cv.K1Z.X3P4bdX7.yd4Ej0Yz6aQ9IA5AViQFF5q8", "\xc3\x85ngstr\xc3\xb6m" },
  { "$y$j85$.......", "$y$j85$.......$GSUNyeKspjDH8cv3JurJH2kNVGQmctfBDP6v.tfASy9", "\xc3\x85ngstr\xc3\xb6m" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$/4EsE62765pCfZHJYRQCtkDfV9JyhozsaVp.r.8TYc6", "\xc3\x85ngstr\xc3\xb6m" },
  { "$y$j75$.......", "$y$j75$.......$sp51CQ1zjFYB50g/Vjq8UEaPbzdt9ZOf6UT17IJOX77", "C\x05ngstrC6m" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$V8DQ4copC6DaLvhwoGWxZ4DytV9AI5j1qsZi3/oLHiA", "C\x05ngstrC6m" },
  { "$y$j85$.......", "$y$j85$.......$pZ.V3JLUMS1DWr54KRDbGNAgaS9naZuVjhJhTRJvYOB", "C\x05ngstrC6m" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$FKjrK4BHRv3/l6nUkQs8FpXephngq296TAIpyC55218", "C\x05ngstrC6m" },
  { "$y$j75$.......", "$y$j75$.......$/XlK6bqi1ZJAyV4BUDMq33cfunTz2OYx/kwbIp9/hJ2", "C\x05ngstrCU*U***U*" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$Aj5AbqAjk1f7sqre2RG7Nb9R3uCborWSoqIMbeIguP4", "C\x05ngstrCU*U***U*" },
  { "$y$j85$.......", "$y$j85$.......$XzgWM0r/N0itj48ORBatiByRLmWz83RqWnBDAOuf.rD", "C\x05ngstrCU*U***U*" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$El5dG9jHfuX89Q/2xeuoJXCij4Xc6uqYCRTyiDxLqN5", "C\x05ngstrCU*U***U*" },
  { "$y$j75$.......", "$y$j75$.......$v4AjSNpQ2WBHuGorhka/XlLtanhEPTlEmU2m8N/DHZ1", "U*U***U*ignored" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$IbWbU0271Fz8gSoKvx9fm1QEEpLj8rKgCgDSO3FDJy1", "U*U***U*ignored" },
  { "$y$j85$.......", "$y$j85$.......$oaKB/uHToBz.iSw9avmxDVD4ZTxgvsHUD6ke/jvdwD0", "U*U***U*ignored" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$j16p/Guq1u287CHWYT.yEkUFRSavNoZyFyjLvpyLZA/", "U*U***U*ignored" },
  { "$y$j75$.......", "$y$j75$.......$Xfm2A6aPRI6z8YWbSD/GG8etKSaE35/W0DOjcWr5w56", "U*U*U*U*" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$GkV5eMZq3lOmz56h7npRKav4z/g5.z1knaHu3chxxS5", "U*U*U*U*" },
  { "$y$j85$.......", "$y$j85$.......$SPL1CMBXFo/bmZ8tfDHWnBiJUPNuthqSMZXkWLUX.l3", "U*U*U*U*" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$u9l/3Kyw6P5TwcYd74KDAGhd9Mma7k6D0/LZ0ZT2pwA", "U*U*U*U*" },
  { "$y$j75$.......", "$y$j75$.......$qxSShULhb08vkDQc2O4yVLmWnj/4lT8bR5DO2hcDV91", "U*U*U*U*ignored" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$V1NwdKXbhWiUXotn/980FtMAf2pFyk3vWKKwNrsiAt4", "U*U*U*U*ignored" },
  { "$y$j85$.......", "$y$j85$.......$JGSP.n7rV/GT9dkIRs8IxDYk4RTB0PLRSL7JuBbavS6", "U*U*U*U*ignored" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$vBlbpNldFDun2OfjSSa9w59tVvb8aUCRlUpBgPvJ2aD", "U*U*U*U*ignored" },
  { "$y$j75$.......", "$y$j75$.......$rfCfKGurRs34Dmotg2vAkDlxO5pBnazZnrigufcrzG2", "*U*U*U*U" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$cukHtjbLCSv9aBrZAWtFeE84xzIxxqXfqp9.onBvXu9", "*U*U*U*U" },
  { "$y$j85$.......", "$y$j85$.......$veitwebPg63P7taUH3jhJb/l.jOCSlaHkZpicfKWCV.", "*U*U*U*U" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$8W0cWmraLxevKbQBUW8xr9CCNN095kVQFN0/S1GuvJ9", "*U*U*U*U" },
  { "$y$j75$.......", "$y$j75$.......$FZ7amzAcoTYrqSGRm9k7tbHPK6rZ4DUd4vrRgqJ3fO5", "*U*U*U*U*" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$9Sm1rkplccfpTHizD6Em.WCDpcKJ49eAXzWKL7C3IqC", "*U*U*U*U*" },
  { "$y$j85$.......", "$y$j85$.......$LF3QWH86ZRG.zOnphNwzFWIukNjLUvcH8BIdzTVfgRA", "*U*U*U*U*" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$algqGjlxLtpey/0X0uNxDEYupwUjdeDLGopwhEO5Vz/", "*U*U*U*U*" },
  { "$y$j75$.......", "$y$j75$.......$dCbRg0hkS4JdZvOnMF9rwrVA/RwtxcUx8H37bB/RzLC", "*U*U*U*U*U*U*U*U" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$h.fmV/gwDw0tKDCTnux6KGlHB1DEAsoHA.OJFO8/LL8", "*U*U*U*U*U*U*U*U" },
  { "$y$j85$.......", "$y$j85$.......$5ZzGchdUDEhADFTnOSjEw24dPGTKBIIqRMV1VJJXIO6", "*U*U*U*U*U*U*U*U" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$X2bYomzg0Jg.u5RVNC0qXtKo1htsVlSJl8QoNImGep3", "*U*U*U*U*U*U*U*U" },
  { "$y$j75$.......", "$y$j75$.......$iWYHAmjkWWPyzN4uWdroXQr3mS5VKiBOeUJE1FXMWiA", "*U*U*U*U*U*U*U*U*" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$850DnH6XLieRVQJkRfdEQf277Sfsj8rWv.AIe7RLEB9", "*U*U*U*U*U*U*U*U*" },
  { "$y$j85$.......", "$y$j85$.......$FoamjCm/5l9.ntM1VZpqlt5pCDmX9W9fAJQvNssN9p7", "*U*U*U*U*U*U*U*U*" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$UFJkwh.EK94X.ZvL4RPTH1SbZRduwgSC21.U2/u9Rz3", "*U*U*U*U*U*U*U*U*" },
  { "$y$j75$.......", "$y$j75$.......$nG1nBzJeNcJGeZqWO5HOe6LsQ2QP2s4pJ9lDJN0Dri3", "\xa3" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$tD6xLg3UzoBB.YaqdU/iCU6x0JV5EfAWs7xhBhj9yj0", "\xa3" },
  { "$y$j85$.......", "$y$j85$.......$aOGorl2OKEWMpAKE.nFFsB2xHjrazNF4qcSAY4H6n88", "\xa3" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$y1ICnDFiIXV7IU8HwEvY0g00jplC2qKfQI56fmr03pC", "\xa3" },
  { "$y$j75$.......", "$y$j75$.......$gOb4YjcxY0krLlRSFD8GpA85nSQ7RUtq3/COYKtxp93", "\xa3""a" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$g93fUlB7MNXyVYXEMt5LK5xZuwzbR0KrSmSln6IDlX5", "\xa3""a" },
  { "$y$j85$.......", "$y$j85$.......$ZZEi7xmfhpm36jVKgEEF6p90i2WU8MpIYjhDC0V9H55", "\xa3""a" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$ppFmdT1TL3FecCJlmf/i8xZ/zeq0q9JCh3FGnHM8ii1", "\xa3""a" },
  { "$y$j75$.......", "$y$j75$.......$ub/X/d/wqm7fGbSRcpvpeVtatXBGCVVX/Ex6cqNPyB3", "\xd1\x91" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$PdnQe2EsH7DN4PQO5F3DWtR4UJvfL8u1YPYHdw3t2O5", "\xd1\x91" },
  { "$y$j85$.......", "$y$j85$.......$B5dsi3Em0v5y68xRfW0X6EN5Wna1/n2QMnhbA6Q4UzC", "\xd1\x91" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$ia0jMaasZGmozqz0rroB1AzURW9m2ppA0k2JhhDXp94", "\xd1\x91" },
  { "$y$j75$.......", "$y$j75$.......$M7SObd8LBQb5rGAjT1t2I.3MX/5aBUoxaXYAmS1Bvv/", "\xa3""ab" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$Zdm3CXNKAlLjD.X/27zFbzbJhGReP8oWlw7we0eA3X/", "\xa3""ab" },
  { "$y$j85$.......", "$y$j85$.......$V5ndJDX5mUb.9HSxgoetpSbbaDV99kyQoPkcKum1It4", "\xa3""ab" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$fk.sz1q9mNP9LEw3IXzwNVb.5xdh7LHuM8MonW12Ie1", "\xa3""ab" },
  { "$y$j75$.......", "$y$j75$.......$5qt5cv.ymOqAHg89rmmF4nEjL0MRMvkxWPEBtCjFpm0", "\xff\xff\xa3" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$E1urEsQgaJ4RgiK9WhyiXlAwuR0HxWbM5K.VAiOe1ZD", "\xff\xff\xa3" },
  { "$y$j85$.......", "$y$j85$.......$MWLdsfTipIOt5OFRt6BvZ6V32KY6vdfHN5lBSaKlAc2", "\xff\xff\xa3" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$ZHvxQJ0LnwjoB0/hiubRE1nf7g4tMTi.F2SKjj5mGtB", "\xff\xff\xa3" },
  { "$y$j75$.......", "$y$j75$.......$D3W4QjjSz2D19VlKKiAZdi8ijvsTpsxNJDcRvusJOU4", "1\xa3""345" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$FjTL7ogvhXvz/UWjObjzlmUreQCU4y2/kKfazRi1KEC", "1\xa3""345" },
  { "$y$j85$.......", "$y$j85$.......$3Ce03eQC1/Byo59IHi9w41hx1x1Fqj4MSxUN2EUpb7B", "1\xa3""345" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$dS2TLRRvfRU9k64cUtvaw8qCKrjE7L31fcGaH7WmRP7", "1\xa3""345" },
  { "$y$j75$.......", "$y$j75$.......$boq.Ka0WNoKC1sEL0fzbiTpDV.rUrMcYVbZGw0nA3w.", "\xff\xa3""345" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$0XaXni2L0uDbNmbGqNbcvMZ2p.La6TBUqbP3hAlmjc2", "\xff\xa3""345" },
  { "$y$j85$.......", "$y$j85$.......$k4Gk5Q2bCNWNNjYxdhJTYBIXulJrQYkb/RphrrcUae/", "\xff\xa3""345" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$uhTB3iKOUe51NKQ83mRhJjXXBAPjve5Sy6hzgousi/6", "\xff\xa3""345" },
  { "$y$j75$.......", "$y$j75$.......$XAYFhJvyJauPzmIfZKHGpcTexMpXV4ISecJB8VMY4e1", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$TKXyBnX2cXkGXeqLx5JANBew/0nQ5UBSel0YsD22yt7", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$y$j85$.......", "$y$j85$.......$g9GEPu6PHnbXRPWsWd6fX3U8PKTdBF41LwptRy4oz93", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$TWE2dBRx.jn3LX.BConFVgcLSdJyhvfOESjz1EMMcaA", "\xff\xa3""34\xff\xff\xff\xa3""345" },
  { "$y$j75$.......", "$y$j75$.......$Nq4j1IZsYEWZBLlqjSt4AlhviyN7bvbvWrgjP6V2EF2", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$5QyXXRlR57uked5ysXmCItOvXX4d5zR0ttqafx7Uo51", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$y$j85$.......", "$y$j85$.......$x1o1UfucDdAFjdXzREvO/f6o49Lo3h091xrnvwlnoFB", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$ndX0.rOECgKW6OZnBTjfxbcscJdcWDdnr9Tw4degrG8", "U\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xffU\xaa\xff" },
  { "$y$j75$.......", "$y$j75$.......$DzOck5j6dl2zwkbMlFcM04tpFK5PryDwpFI.Mm81/c0", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$r1z9RInA2Zcy6JNyEuy8aQjAHXqOZgF0z70zcCmR/N6", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$y$j85$.......", "$y$j85$.......$p.9UI8XwpIn5Z/zR9D5FA5WVLCqr0D70B43s/qrDgTC", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$Zvdn9FqFFKCwm8AM/J58sQYerb6uxacC00SQzVllO21", "\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU\xaaU" },
  { "$y$j75$.......", "$y$j75$.......$F0rjxBIyFkN54IVLBaKuM5YfEfLCid.cRdUgqU7F1m3", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$ZgTUWYYUx76vUOHZF0X27Rq9go43bzjSmecsreE0zo7", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$y$j85$.......", "$y$j85$.......$ROueloIUt1VztPrvAgyjIMk0quqc9HG6M.BtxYIsvA.", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$A168ps.AKPbIXUE/wXjlE570CqBkRY7sJGXUC9d3703", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" },
  { "$y$j75$.......", "$y$j75$.......$LPJMBkV8tc7ramZ1xWMLqoBVL4aBijXbWajjn4Vl3j3", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$VyvQwJiydQK/7/IH2YN5xE2b9XuSqDrEGACYlWoi/T2", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$y$j85$.......", "$y$j85$.......$EBF/PgI1CrfkVbX5yoLX17I/rujRO6.Uk7C23pHTsj1", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$319JYYAC5.f59Sjoe1Bai9oV5jBNssg2YuN7tUIsKf6", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored" },
  { "$y$j75$.......", "$y$j75$.......$/JddBodz08R8Q5/Tm1.L.owqz/tnyE9pNHW/FMEr/T8", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$rOvJTqqIT7O0IxWztHPXlwM51x8OH6TDccKgvETfzEB", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$y$j85$.......", "$y$j85$.......$zhMXhnmP.gcaiEKILOQ0uPSqcOn2Nfplf0Q0D.erAQC", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$/BIM1ElpX1fPxuYbjHwOojsDjRDxQQxl.DFSXERgSo9", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa" },
  { "$y$j75$.......", "$y$j75$.......$cCGRbVjL0QnKuM0Ia7JrF23BKJPsXBU5xco4JeDI261", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$AvPvZNd5IAQFLQbERhlzfBq2276rzjKbD8RPiSxhMv.", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$y$j85$.......", "$y$j85$.......$oB2vJZ3pZWQB5NfqUOWkdDH7neDH96F4OWSqWP3adb/", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$uFCPlt7crGqlxHcgP5VhNa/Y.TGV3rfrLf1818lF0s8", "\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa""chars after 72 are ignored as usual" },
  { "$y$j75$.......", "$y$j75$.......$rH24sjf97yDTkvsCoaOjnMZO1TYYsUzU7XYvclwbXVD", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$GvVaUBsKJZRpLNffGI63DblLjvrJoswzwIKthTrHXPA", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$y$j85$.......", "$y$j85$.......$7717E6WQ3N3SEk7pLxFR/pTBqAYrMQMm4/fSoiHtdF/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$hMM1/N5eNTtPpY3oX/KRhSzvP/3NKATqL0yiHqyZBJ3", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has forgotten." },
  { "$y$j75$.......", "$y$j75$.......$6v6FMOgOfETtKAUsUjzlPEFqKzbkDZzXMu4cgRJKjP5", "THE YEAR" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$s0qvYYdO0C7xT6wRA3w1OvwQN1QFKFzQOjgDrNuprK6", "THE YEAR" },
  { "$y$j85$.......", "$y$j85$.......$ZGmePNljl4FLa/oy7BUoETfx2Oxd8.ApP7.0JN82eSB", "THE YEAR" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$9bzSqsy.tgf3vABDP.Wuq0kUG2dQzR03IMMoqvle5I0", "THE YEAR" },
  { "$y$j75$.......", "$y$j75$.......$HQLzXiMk5aoX4p5YhGs7gxpvSsaFgoyYtNbl8qwkff/", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$YHrsISjCmnYp5VOu2Z9LJ35ZFNKBVX4O588QmRjyVP3", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$y$j85$.......", "$y$j85$.......$Vj0u6joQCGHbEGpEZo2lmqr607HKbbk8syGAIW5s7/D", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$D9U3XZCYxppcyiDqgrOBTXPCGw/5gR.mLQC7n7YM.H1", "THE YEAR 1866 was marked by a bizarre development, an unexplained and do" },
  { "$y$j75$.......", "$y$j75$.......$4cpAwkBU2/aPOo0jOEv.jKHALwkIm249pwTl8ip3oJ7", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$y$j75$LdJMENpBABJJ3hIHjB1Bi.", "$y$j75$LdJMENpBABJJ3hIHjB1Bi.$U1mZ5XnIo.cxARAIbDW4yEX0XTQkIMrebpv3ozgRf6D", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$y$j85$.......", "$y$j85$.......$jM1iuAyD3Sv3mHsjAEfqLcqT2pCN24.Oio37k6YgB47", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
  { "$y$j85$LdJMENpBABJJ3hIHjB1Bi.", "$y$j85$LdJMENpBABJJ3hIHjB1Bi.$tyD22ALWYD5Wl5tkIhSB0QXxBvBQls96l2AVKjX/ei3", "THE YEAR 1866 was marked by a bizarre development, an unexplained and downright inexplicable phenomenon that surely no one has f" },
#endif // yescrypt
