/****************************************************************************
* Render Radiance Scaling                                                   *
* Meshlab's plugin                                                          *
*                                                                           *
* Copyright(C) 2010                                                         *
* Vergne Romain, Dumas Olivier                                              *
* INRIA - Institut Nationnal de Recherche en Informatique et Automatique    *
*                                                                           *
* All rights reserved.                                                      *
*                                                                           *
* This program is free software; you can redistribute it and/or modify      *
* it under the terms of the GNU General Public License as published by      *
* the Free Software Foundation; either version 2 of the License, or         *
* (at your option) any later version.                                       *
*                                                                           *
* This program is distributed in the hope that it will be useful,           *
* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
* GNU General Public License (http://www.gnu.org/licenses/gpl.txt)          *
* for more details.                                                         *
*                                                                           *
****************************************************************************/
#version 120

varying vec3  normal;
varying vec3  view;
varying float depth;

void main() {
  view   = -(gl_ModelViewMatrix*gl_Vertex).xyz;
  normal = gl_NormalMatrix*gl_Normal;
  depth  = log(-(gl_ModelViewMatrix*gl_Vertex).z);

  gl_Position = ftransform();
  
  gl_FrontColor = gl_Color;
  gl_BackColor = gl_Color;  
}
