/*
 * Musepack audio compression
 * Copyright (C) 1999-2004 Buschmann/Klemm/Piecha/Wolf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mppdec.h"

Huffman_t   HuffHdr    [10];            // 9 bit
Huffman_t   HuffSCFI   [ 4];            // 3 bit
Huffman_t   HuffDSCF   [16];            // 6 bit
Huffman_t   HuffQ1 [2] [ 3*3*3];        // 6+ 9 bit
Huffman_t   HuffQ2 [2] [ 5*5];          // 7+10 bit
Huffman_t   HuffQ3 [2] [ 7];            // 4+ 5 bit
Huffman_t   HuffQ4 [2] [ 9];            // 4+ 5 bit
Huffman_t   HuffQ5 [2] [15];            // 6+ 8 bit
Huffman_t   HuffQ6 [2] [31];            // 7+13 bit
Huffman_t   HuffQ7 [2] [63];            // 8+14 bit
                                        // 4608 Bytes
Uint8_t     LUT1_0  [1<< 6];
Uint8_t     LUT1_1  [1<< 9];            //  576 Bytes
Uint8_t     LUT2_0  [1<< 7];
Uint8_t     LUT2_1  [1<<10];            // 1152 Bytes
Uint8_t     LUT3_0  [1<< 4];
Uint8_t     LUT3_1  [1<< 5];            //   48 Bytes
Uint8_t     LUT4_0  [1<< 4];
Uint8_t     LUT4_1  [1<< 5];            //   48 Bytes
Uint8_t     LUT5_0  [1<< 6];
Uint8_t     LUT5_1  [1<< 8];            //  320 Bytes
Uint8_t     LUT6_0  [1<< 7];
Uint8_t     LUT6_1  [1<< 7];            //  256 Bytes
Uint8_t     LUT7_0  [1<< 8];
Uint8_t     LUT7_1  [1<< 8];            //  512 Bytes
Uint8_t     LUTDSCF [1<< 6];            //   64 Bytes = 2976 Bytes

const Huffman_t* HuffQ [2] [8] = {
    { NULL, HuffQ1[0], HuffQ2[0], HuffQ3[0], HuffQ4[0], HuffQ5[0], HuffQ6[0], HuffQ7[0] },
    { NULL, HuffQ1[1], HuffQ2[1], HuffQ3[1], HuffQ4[1], HuffQ5[1], HuffQ6[1], HuffQ7[1] }
};

#ifdef USE_SV8
Huffman_t   HuffN3 [2] [ 7*7];          // 8+ 9 bit
Huffman_t   HuffN8 [2][127];            //13+12 bit

const Huffman_t* HuffN [2] [9] = {
    { NULL, HuffQ1[0], HuffQ2[0], HuffN3[0], HuffQ4[0], HuffQ5[0], HuffQ6[0], HuffQ7[0], HuffN8[0] },
    { NULL, HuffQ1[1], HuffQ2[1], HuffN3[1], HuffQ4[1], HuffQ5[1], HuffQ6[1], HuffQ7[1], HuffN8[1] }
};
#endif

static const HuffSrc_t   HuffSCFI_src [4] = {
    { 2, 3 }, { 1, 1 }, { 3, 3 }, { 0, 2 }
};

static const HuffSrc_t   HuffDSCF_src [16] = {
    { 32, 6 }, {  4, 5 }, { 17, 5 }, { 30, 5 }, { 13, 4 }, {  0, 3 }, {  3, 3 }, {  9, 4 },
    {  5, 3 }, {  2, 3 }, { 14, 4 }, {  3, 4 }, { 31, 5 }, {  5, 5 }, { 33, 6 }, { 12, 4 }
};

static const HuffSrc_t   HuffHdr_src [10] = {
    {  92, 8 }, {  47, 7 }, {  10, 5 }, {   4, 4 }, {   0, 2 },
    {   1, 1 }, {   3, 3 }, {  22, 6 }, { 187, 9 }, { 186, 9 }
};

static const HuffSrc_t   HuffQ1_src [2] [3*3*3] = { {
    { 54, 6 }, {  9, 5 }, { 32, 6 }, {  5, 5 }, { 10, 4 }, {  7, 5 }, { 52, 6 }, {  0, 5 }, { 35, 6 },
    { 10, 5 }, {  6, 4 }, {  4, 5 }, { 11, 4 }, {  7, 3 }, { 12, 4 }, {  3, 5 }, {  7, 4 }, { 11, 5 },
    { 34, 6 }, {  1, 5 }, { 53, 6 }, {  6, 5 }, {  9, 4 }, {  2, 5 }, { 33, 6 }, {  8, 5 }, { 55, 6 }
}, {
    { 103, 8 }, {  62, 7 }, { 225, 9 }, {  55, 7 }, {   3, 4 }, {  52, 7 }, { 101, 8 }, {  60, 7 }, { 227, 9 },
    {  24, 6 }, {   0, 4 }, {  61, 7 }, {   4, 4 }, {   1, 1 }, {   5, 4 }, {  63, 7 }, {   1, 4 }, {  59, 7 },
    { 226, 9 }, {  57, 7 }, { 100, 8 }, {  53, 7 }, {   2, 4 }, {  54, 7 }, { 224, 9 }, {  58, 7 }, { 102, 8 }
} };

static const HuffSrc_t   HuffQ2_src [2] [5*5] = { {
    {  89,  7 }, {  47,  6 }, { 15, 5 }, {   0, 5 }, {  91,  7 },
    {   4,  5 }, {   6,  4 }, { 13, 4 }, {   4, 4 }, {   5,  5 },
    {  20,  5 }, {  12,  4 }, {  4, 3 }, {  15, 4 }, {  14,  5 },
    {   3,  5 }, {   3,  4 }, { 14, 4 }, {   5, 4 }, {   1,  5 },
    {  90,  7 }, {   2,  5 }, { 21, 5 }, {  46, 6 }, {  88,  7 }
}, {
    { 921, 10 }, { 113,  7 }, { 51, 6 }, { 231, 8 }, { 922, 10 },
    { 104,  7 }, {  30,  5 }, {  0, 3 }, {  29, 5 }, { 105,  7 },
    {  50,  6 }, {   1,  3 }, {  2, 2 }, {   3, 3 }, {  49,  6 },
    { 107,  7 }, {  27,  5 }, {  2, 3 }, {  31, 5 }, { 112,  7 },
    { 920, 10 }, { 106,  7 }, { 48, 6 }, { 114, 7 }, { 923, 10 }
} };

#ifdef USE_SV8
static const HuffSrc_t   HuffN3_src [2] [7*7] = { {
    {  78, 7 }, {  20, 6 }, {  36, 6 }, {  51, 6 }, {  21, 6 }, { 101, 7 }, { 255, 8 },
    {  37, 6 }, {   0, 5 }, {  62, 6 }, {   7, 5 }, {  60, 6 }, {  49, 6 }, { 100, 7 },
    {  30, 6 }, {  53, 6 }, {   8, 5 }, {  14, 5 }, {   5, 5 }, {  54, 6 }, {  26, 6 },
    {  43, 6 }, {   1, 5 }, {  20, 5 }, {  14, 4 }, {  22, 5 }, {   9, 5 }, {  46, 6 },
    {  47, 6 }, {  61, 6 }, {  17, 5 }, {  16, 5 }, {  11, 5 }, {   4, 5 }, {  38, 6 },
    {   6, 6 }, {  52, 6 }, {   6, 5 }, {  12, 5 }, {   2, 5 }, {  55, 6 }, {  27, 6 },
    { 254, 8 }, { 126, 7 }, {  31, 6 }, {  48, 6 }, {  42, 6 }, {   7, 6 }, {  79, 7 }
}, {
    {  65, 9 }, { 161, 8 }, { 109, 7 }, {  11, 6 }, { 116, 7 }, { 160, 8 }, {  71, 9 },
    {  34, 8 }, {  97, 7 }, {  56, 6 }, {   8, 5 }, {  55, 6 }, {  85, 7 }, { 166, 8 },
    {  84, 7 }, {  52, 6 }, {   3, 4 }, {  11, 4 }, {   5, 4 }, {  59, 6 }, {  86, 7 },
    {  10, 6 }, {  13, 5 }, {   9, 4 }, {   0, 3 }, {   8, 4 }, {  12, 5 }, {   9, 6 },
    {  98, 7 }, {  51, 6 }, {  31, 5 }, {   7, 4 }, {  30, 5 }, {  53, 6 }, {  99, 7 },
    { 162, 8 }, { 108, 7 }, {  50, 6 }, {   9, 5 }, {  57, 6 }, {  82, 7 }, { 163, 8 },
    {  64, 9 }, { 167, 8 }, {  87, 7 }, { 117, 7 }, {  96, 7 }, {  33, 8 }, {  70, 9 }
} };
#endif

static const HuffSrc_t   HuffQ3_src [2] [ 7] = { {
    { 12, 4 }, { 4, 3 }, { 0, 2 }, { 1, 2 }, { 7, 3 }, { 5, 3 }, { 13, 4 }
}, {
    {  4, 5 }, { 3, 4 }, { 2, 2 }, { 3, 2 }, { 1, 2 }, { 0, 3 }, {  5, 5 }
} };

static const HuffSrc_t   HuffQ4_src [2] [ 9] = { {
    { 5, 4 }, {  0, 3 }, { 4, 3 }, { 6, 3 }, { 7, 3 }, { 5, 3 }, {  3, 3 }, { 1, 3 }, { 4, 4 }
}, {
    { 9, 5 }, { 12, 4 }, { 3, 3 }, { 0, 2 }, { 2, 2 }, { 7, 3 }, { 13, 4 }, { 5, 4 }, { 8, 5 }
} };

static const HuffSrc_t   HuffQ5_src [2] [15] = { {
    {  57, 6 }, { 23, 5 }, {  8, 4 }, { 10, 4 }, { 13, 4 }, {   0, 3 }, {   2, 3 }, { 3, 3 },
    {   1, 3 }, { 15, 4 }, { 12, 4 }, {  9, 4 }, { 29, 5 }, {  22, 5 }, {  56, 6 }
}, {
    { 229, 8 }, { 56, 6 }, {  7, 5 }, {  2, 4 }, {  0, 3 }, {   3, 3 }, {   5, 3 }, { 6, 3 },
    {   4, 3 }, {  2, 3 }, { 15, 4 }, { 29, 5 }, {  6, 5 }, { 115, 7 }, { 228, 8 },
} };

static const HuffSrc_t   HuffQ6_src [2] [31] = { {
    {   65,  7 }, {    6,  6 }, {  44,  6 }, {  45, 6 }, {   59,  6 }, {   13,  5 }, {   17,  5 }, { 19, 5 },
    {   23,  5 }, {   21,  5 }, {  26,  5 }, {  30, 5 }, {    0,  4 }, {    2,  4 }, {    5,  4 }, {  7, 4 },
    {    3,  4 }, {    4,  4 }, {  31,  5 }, {  28, 5 }, {   25,  5 }, {   27,  5 }, {   24,  5 }, { 20, 5 },
    {   18,  5 }, {   12,  5 }, {   2,  5 }, {  58, 6 }, {   33,  6 }, {    7,  6 }, {   64,  7 },
}, {
    { 6472, 13 }, { 6474, 13 }, { 808, 10 }, { 405, 9 }, {  203,  8 }, {  102,  7 }, {   49,  6 }, {  9, 5 },
    {   15,  5 }, {   31,  5 }, {   2,  4 }, {   6, 4 }, {    8,  4 }, {   11,  4 }, {   13,  4 }, {  0, 3 },
    {   14,  4 }, {   10,  4 }, {   9,  4 }, {   5, 4 }, {    3,  4 }, {   30,  5 }, {   14,  5 }, {  8, 5 },
    {   48,  6 }, {  103,  7 }, { 201,  8 }, { 200, 8 }, { 1619, 11 }, { 6473, 13 }, { 6475, 13 },
} };

static const HuffSrc_t   HuffQ7_src [2] [63] = { {
    { 103, 8 },    // 0.3338   01100111
    { 153, 8 },    // 0.3766   10011001
    { 181, 8 },    // 0.4715   10110101
    { 233, 8 },    // 0.5528   11101001
    {  64, 7 },    // 0.6677    1000000
    {  65, 7 },    // 0.7041    1000001
    {  77, 7 },    // 0.7733    1001101
    {  81, 7 },    // 0.8296    1010001
    {  91, 7 },    // 0.9295    1011011
    { 113, 7 },    // 1.0814    1110001
    { 112, 7 },    // 1.0807    1110000
    {  24, 6 },    // 1.2748     011000
    {  29, 6 },    // 1.3390     011101
    {  35, 6 },    // 1.4224     100011
    {  37, 6 },    // 1.5201     100101
    {  41, 6 },    // 1.6642     101001
    {  44, 6 },    // 1.7292     101100
    {  46, 6 },    // 1.8647     101110
    {  51, 6 },    // 2.0473     110011
    {  49, 6 },    // 2.0152     110001
    {  54, 6 },    // 2.1315     110110
    {  55, 6 },    // 2.1358     110111
    {  57, 6 },    // 2.1700     111001
    {  60, 6 },    // 2.2449     111100
    {   0, 5 },    // 2.3063      00000
    {   2, 5 },    // 2.3854      00010
    {  10, 5 },    // 2.5481      01010
    {   5, 5 },    // 2.4867      00101
    {   9, 5 },    // 2.5352      01001
    {   6, 5 },    // 2.5074      00110
    {  13, 5 },    // 2.5745      01101
    {   7, 5 },    // 2.5195      00111
    {  11, 5 },    // 2.5502      01011
    {  15, 5 },    // 2.6251      01111
    {   8, 5 },    // 2.5260      01000
    {   4, 5 },    // 2.4418      00100
    {   3, 5 },    // 2.3983      00011
    {   1, 5 },    // 2.3697      00001
    {  63, 6 },    // 2.3041     111111
    {  62, 6 },    // 2.2656     111110
    {  61, 6 },    // 2.2549     111101
    {  53, 6 },    // 2.1151     110101
    {  59, 6 },    // 2.2042     111011
    {  52, 6 },    // 2.0837     110100
    {  48, 6 },    // 1.9446     110000
    {  47, 6 },    // 1.9189     101111
    {  43, 6 },    // 1.7177     101011
    {  42, 6 },    // 1.7035     101010
    {  39, 6 },    // 1.5287     100111
    {  36, 6 },    // 1.4559     100100
    {  33, 6 },    // 1.4117     100001
    {  28, 6 },    // 1.2776     011100
    { 117, 7 },    // 1.1107    1110101
    { 101, 7 },    // 1.0636    1100101
    { 100, 7 },    // 0.9751    1100100
    {  80, 7 },    // 0.8132    1010000
    {  69, 7 },    // 0.7091    1000101
    {  68, 7 },    // 0.7084    1000100
    {  50, 7 },    // 0.6277    0110010
    { 232, 8 },    // 0.5386   11101000
    { 180, 8 },    // 0.4408   10110100
    { 152, 8 },    // 0.3759   10011000
    { 102, 8 },    // 0.3160   01100110
}, {
    { 14244, 14 },    // 0.0059   11011110100100
    { 14253, 14 },    // 0.0098   11011110101101
    { 14246, 14 },    // 0.0078   11011110100110
    { 14254, 14 },    // 0.0111   11011110101110
    {  3562, 12 },    // 0.0320     110111101010
    {   752, 10 },    // 0.0920       1011110000
    {   753, 10 },    // 0.1057       1011110001
    {   160,  9 },    // 0.1403        010100000
    {   162,  9 },    // 0.1579        010100010
    {   444,  9 },    // 0.2486        110111100
    {   122,  8 },    // 0.3772         01111010
    {   223,  8 },    // 0.5710         11011111
    {    60,  7 },    // 0.6858          0111100
    {    73,  7 },    // 0.8033          1001001
    {   110,  7 },    // 0.9827          1101110
    {    14,  6 },    // 1.2601           001110
    {    24,  6 },    // 1.3194           011000
    {    25,  6 },    // 1.3938           011001
    {    34,  6 },    // 1.5693           100010
    {    37,  6 },    // 1.7846           100101
    {    54,  6 },    // 2.0078           110110
    {     3,  5 },    // 2.2975            00011
    {     9,  5 },    // 2.5631            01001
    {    11,  5 },    // 2.7021            01011
    {    16,  5 },    // 3.1465            10000
    {    19,  5 },    // 3.4244            10011
    {    21,  5 },    // 3.5921            10101
    {    24,  5 },    // 3.7938            11000
    {    26,  5 },    // 3.9595            11010
    {    29,  5 },    // 4.1546            11101
    {    31,  5 },    // 4.2623            11111
    {     2,  4 },    // 4.5180             0010
    {     0,  4 },    // 4.3151             0000
    {    30,  5 },    // 4.2538            11110
    {    28,  5 },    // 4.1422            11100
    {    25,  5 },    // 3.9145            11001
    {    22,  5 },    // 3.6691            10110
    {    20,  5 },    // 3.4955            10100
    {    14,  5 },    // 2.9155            01110
    {    13,  5 },    // 2.7921            01101
    {     8,  5 },    // 2.5553            01000
    {     6,  5 },    // 2.3093            00110
    {     2,  5 },    // 2.1200            00010
    {    46,  6 },    // 1.8134           101110
    {    35,  6 },    // 1.5824           100011
    {    31,  6 },    // 1.4701           011111
    {    21,  6 },    // 1.3187           010101
    {    15,  6 },    // 1.2776           001111
    {    95,  7 },    // 0.9664          1011111
    {    72,  7 },    // 0.7922          1001000
    {    41,  7 },    // 0.6838          0101001
    {   189,  8 },    // 0.5024         10111101
    {   123,  8 },    // 0.3830         01111011
    {   377,  9 },    // 0.2232        101111001
    {   161,  9 },    // 0.1566        010100001
    {   891, 10 },    // 0.1383       1101111011
    {   327, 10 },    // 0.0900       0101000111
    {   326, 10 },    // 0.0790       0101000110
    {  3560, 12 },    // 0.0254     110111101000
    { 14255, 14 },    // 0.0117   11011110101111
    { 14247, 14 },    // 0.0085   11011110100111
    { 14252, 14 },    // 0.0085   11011110101100
    { 14245, 14 },    // 0.0065   11011110100101
} };

#ifdef USE_SV8
static const HuffSrc_t   HuffN8_src [2] [127] = { {
    { 2426, 13 }, { 4943, 13 }, {  787, 12 }, { 2470, 12 }, { 7270, 13 }, { 1764, 12 },
    { 3632, 12 }, { 3633, 12 }, { 2486, 12 }, {  395, 11 }, {  607, 11 }, { 1242, 11 },
    {  108, 10 }, {  300, 10 }, {  199, 10 }, {  440, 10 }, {  442, 10 }, {  616, 10 },
    {  909, 10 }, {  897, 10 }, {  178,  9 }, {  309,  9 }, {  311,  9 }, {  451,  9 },
    {  449,  9 }, {   26,  8 }, {   74,  8 }, {   94,  8 }, {  122,  8 }, {  136,  8 },
    {   12,  7 }, {   29,  7 }, {   28,  7 }, {   36,  7 }, {   39,  7 }, {   46,  7 },
    {   60,  7 }, {   69,  7 }, {   76,  7 }, {   92,  7 }, {  126,  7 }, {   11,  6 },
    {   15,  6 }, {   10,  6 }, {   16,  6 }, {   21,  6 }, {   25,  6 }, {   28,  6 },
    {   32,  6 }, {   31,  6 }, {   37,  6 }, {   47,  6 }, {   43,  6 }, {   35,  6 },
    {   45,  6 }, {   48,  6 }, {   52,  6 }, {   53,  6 }, {   54,  6 }, {   62,  6 },
    {   59,  6 }, {    0,  5 }, {   61,  6 }, {   51,  6 }, {    2,  5 }, {    1,  5 },
    {   60,  6 }, {   57,  6 }, {   58,  6 }, {   55,  6 }, {   50,  6 }, {   49,  6 },
    {   42,  6 }, {   40,  6 }, {   44,  6 }, {   41,  6 }, {   39,  6 }, {   33,  6 },
    {   29,  6 }, {   26,  6 }, {   24,  6 }, {   20,  6 }, {   17,  6 }, {   13,  6 },
    {    8,  6 }, {    9,  6 }, {  127,  7 }, {   93,  7 }, {   73,  7 }, {   72,  7 },
    {   54,  7 }, {   38,  7 }, {   45,  7 }, {   14,  7 }, {   25,  7 }, {   15,  7 },
    {  226,  8 }, {  137,  8 }, {  111,  8 }, {   95,  8 }, {   88,  8 }, {   48,  8 },
    {  455,  9 }, {  450,  9 }, {  246,  9 }, {  247,  9 }, {  179,  9 }, {   55,  9 },
    {  896, 10 }, {  620, 10 }, {  443, 10 }, {  302, 10 }, {  301, 10 }, {  198, 10 },
    {  109, 10 }, { 1234, 11 }, {  883, 11 }, {  392, 11 }, {  394, 11 }, { 3634, 12 },
    { 2487, 12 }, {  786, 12 }, { 1765, 12 }, { 1212, 12 }, { 7271, 13 }, { 2427, 13 },
    { 4942, 13 }
}, {
    { 3728, 12 }, { 4005, 12 }, {  264, 11 }, { 4004, 12 }, { 4044, 12 }, { 4045, 12 },
    { 4046, 12 }, { 1424, 11 }, {  449, 11 }, {  448, 11 }, {  139, 10 }, {  231, 10 },
    {  133, 10 }, {  719, 10 }, {  641, 10 }, {  676, 10 }, {  225, 10 }, {  677, 10 },
    {  620, 10 }, {   72,  9 }, {   23,  9 }, {   67,  9 }, {   75,  9 }, {  113,  9 },
    {  311,  9 }, {   68,  9 }, {  316,  9 }, {  467,  9 }, {   10,  8 }, {  468,  9 },
    {   35,  8 }, {   27,  8 }, {  358,  9 }, {   32,  8 }, {   26,  8 }, {  501,  9 },
    {   44,  8 }, {   45,  8 }, {  142,  8 }, {  173,  8 }, {  161,  8 }, {  188,  8 },
    {  189,  8 }, {  190,  8 }, {  191,  8 }, {  254,  8 }, {  251,  8 }, {  255,  8 },
    {   19,  7 }, {   26,  7 }, {   70,  7 }, {   76,  7 }, {   87,  7 }, {   85,  7 },
    {  124,  7 }, {    7,  6 }, {   15,  6 }, {   41,  6 }, {   46,  6 }, {    2,  5 },
    {   16,  5 }, {   28,  5 }, {   12,  4 }, {    1,  2 }, {   13,  4 }, {   30,  5 },
    {   18,  5 }, {    0,  5 }, {   45,  6 }, {   34,  6 }, {   12,  6 }, {    3,  6 },
    {  118,  7 }, {   88,  7 }, {   81,  7 }, {   29,  7 }, {   78,  7 }, {   23,  7 },
    {   27,  7 }, {  253,  8 }, {   12,  7 }, {  232,  8 }, {  235,  8 }, {  159,  8 },
    {  238,  8 }, {  172,  8 }, {  168,  8 }, {  143,  8 }, {  154,  8 }, {   40,  8 },
    {    8,  8 }, {  478,  9 }, {    9,  8 }, {  479,  9 }, {  469,  9 }, {   42,  8 },
    {   43,  8 }, {  504,  9 }, {  357,  9 }, {  321,  9 }, {  339,  9 }, {  317,  9 },
    {  114,  9 }, {   82,  9 }, {   83,  9 }, {   73,  9 }, {   74,  9 }, { 1000, 10 },
    {  933, 10 }, {  621, 10 }, {  718, 10 }, { 2003, 11 }, {  713, 10 }, { 2020, 11 },
    {  230, 10 }, { 1865, 11 }, {   44, 10 }, {  138, 10 }, { 1280, 11 }, { 2021, 11 },
    { 3729, 12 }, { 4047, 12 }, {   90, 11 }, {  265, 11 }, { 1281, 11 }, { 1425, 11 },
    {   91, 11 }
} };
#endif

#define MAKE(d,s)     Make_HuffTable   ( (d), (s), sizeof(s)/sizeof(*(s)) )
#define SORT(x,o)     Resort_HuffTable ( (x), sizeof(x)/sizeof(*(x)), -(Int)(o) )
#define LOOKUP(x,q)   Make_LookupTable ( (q), sizeof(q), (x), sizeof(x)/sizeof(*(x)) )


void
Init_Huffman_Encoder_SV7 ( void )
{
    // Splitting of the 36 Samples
    MAKE ( HuffSCFI, HuffSCFI_src );

    // Differential Scalefactors
    MAKE ( HuffDSCF, HuffDSCF_src );

    // resolution, differential quantizer indizes
    MAKE ( HuffHdr, HuffHdr_src );

    // 3-step quantizer, 3 bundled samples
    MAKE ( HuffQ1[0], HuffQ1_src[0] );          // less shaped, book 0
    MAKE ( HuffQ1[1], HuffQ1_src[1] );          // more shaped, book 1

    // 5-step quantizer, 2 bundled samples
    MAKE ( HuffQ2[0], HuffQ2_src[0] );          // less shaped, book 0
    MAKE ( HuffQ2[1], HuffQ2_src[1] );          // more shaped, book 1

    // 7-step quantizer, single samples
    MAKE ( HuffQ3[0], HuffQ3_src[0] );          // less shaped, book 0
    MAKE ( HuffQ3[1], HuffQ3_src[1] );          // more shaped, book 1

#ifdef USE_SV8
    // 7-step quantizer, 2 bundled samples
    MAKE ( HuffN3[0], HuffN3_src[0] );          // less shaped, book 0
    MAKE ( HuffN3[1], HuffN3_src[1] );          // more shaped, book 1
#endif

    // 9-step quantizer, single samples
    MAKE ( HuffQ4[0], HuffQ4_src[0] );          // less shaped, book 0
    MAKE ( HuffQ4[1], HuffQ4_src[1] );          // more shaped, book 1

    // 15-step quantizer, single samples
    MAKE ( HuffQ5[0], HuffQ5_src[0] );          // less shaped, book 0
    MAKE ( HuffQ5[1], HuffQ5_src[1] );          // more shaped, book 1

    // 31-step quantizer, single samples
    MAKE ( HuffQ6[0], HuffQ6_src[0] );          // less shaped, book 0
    MAKE ( HuffQ6[1], HuffQ6_src[1] );          // more shaped, book 1

    // 63-step quantizer, single samples
    MAKE ( HuffQ7[0], HuffQ7_src[0] );          // less shaped, book 0
    MAKE ( HuffQ7[1], HuffQ7_src[1] );          // more shaped, book 1

#ifdef USE_SV8
    // 127-step quantizer, single samples
    MAKE ( HuffN8[0], HuffN8_src[0] );          // book 0
    MAKE ( HuffN8[1], HuffN8_src[1] );          // book 1
#endif
}

#ifndef MPP_ENCODER

void
Init_Huffman_Decoder_SV7 ( void )
{
    Init_Huffman_Encoder_SV7 ();

    SORT ( HuffHdr  ,    5  );
    SORT ( HuffSCFI ,    0  );
    SORT ( HuffDSCF ,    7  );
    SORT ( HuffQ1[0],    0  );
    SORT ( HuffQ1[1],    0  );
    SORT ( HuffQ2[0],    0  );
    SORT ( HuffQ2[1],    0  );
#ifdef USE_SV8
    SORT ( HuffN3[0],    0  );
    SORT ( HuffN3[1],    0  );
#endif
    SORT ( HuffQ3[0], Dc[3] );
    SORT ( HuffQ3[1], Dc[3] );
    SORT ( HuffQ4[0], Dc[4] );
    SORT ( HuffQ4[1], Dc[4] );
    SORT ( HuffQ5[0], Dc[5] );
    SORT ( HuffQ5[1], Dc[5] );
    SORT ( HuffQ6[0], Dc[6] );
    SORT ( HuffQ6[1], Dc[6] );
    SORT ( HuffQ7[0], Dc[7] );
    SORT ( HuffQ7[1], Dc[7] );
#ifdef USE_SV8
    SORT ( HuffN8[0], Dc[8] );
    SORT ( HuffN8[1], Dc[8] );
#endif

    LOOKUP ( HuffQ1[0], LUT1_0  );
    LOOKUP ( HuffQ1[1], LUT1_1  );
    LOOKUP ( HuffQ2[0], LUT2_0  );
    LOOKUP ( HuffQ2[1], LUT2_1  );
    LOOKUP ( HuffQ3[0], LUT3_0  );
    LOOKUP ( HuffQ3[1], LUT3_1  );
    LOOKUP ( HuffQ4[0], LUT4_0  );
    LOOKUP ( HuffQ4[1], LUT4_1  );
    LOOKUP ( HuffQ5[0], LUT5_0  );
    LOOKUP ( HuffQ5[1], LUT5_1  );
    LOOKUP ( HuffQ6[0], LUT6_0  );
    LOOKUP ( HuffQ6[1], LUT6_1  );
    LOOKUP ( HuffQ7[0], LUT7_0  );
    LOOKUP ( HuffQ7[1], LUT7_1  );
    LOOKUP ( HuffDSCF , LUTDSCF );
}

#endif

/* end of huffsv7.c */
