/**
 * Standalone signaling server for the Nextcloud Spreed app.
 * Copyright (C) 2023 struktur AG
 *
 * @author Joachim Bauch <bauch@struktur.de>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package signaling

import (
	"reflect"
	"testing"

	"github.com/dlintw/goconf"
)

func TestStringOptions(t *testing.T) {
	expected := map[string]string{
		"one": "1",
		"two": "2",
	}
	config := goconf.NewConfigFile()
	for k, v := range expected {
		config.AddOption("foo", k, v)
	}
	config.AddOption("default", "three", "3")

	options, err := GetStringOptions(config, "foo", false)
	if err != nil {
		t.Fatal(err)
	}

	if !reflect.DeepEqual(expected, options) {
		t.Errorf("expected %+v, got %+v", expected, options)
	}
}
