/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.webservices.clientproxy;

import com.sourceforge.knecs.webservices.clientproxy.ResponseHandler;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPHeaderElement;

public abstract class BaseResponseHandler
implements ResponseHandler {
    protected String mEndPointUrl;
    protected String mNamespace;
    protected String mOperationName;
    protected QName mReturnType;
    protected String mCorrelationId;

    public BaseResponseHandler(String endPoint, String namespace, String responseMethod, QName returnType) {
        this.mEndPointUrl = endPoint;
        this.mNamespace = namespace;
        this.mOperationName = responseMethod;
        this.mReturnType = returnType;
    }

    public Logger getLogger() {
        return Logger.getLogger(this.getClass().getPackage().getName());
    }

    public void setCorrelationId(String id) {
        this.mCorrelationId = id;
    }

    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    public Call constructCall() throws AxisFault {
        Call call = null;
        try {
            Service service = new Service();
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(this.mEndPointUrl);
            call.setOperationName(new QName(this.mNamespace, this.mOperationName));
            SOAPHeaderElement cid = new SOAPHeaderElement("http://cmcs.org", "CorrelationId");
            cid.setObjectValue(this.getCorrelationId());
            call.addHeader(cid);
            call.setReturnType(this.mReturnType);
        }
        catch (ServiceException createex) {
            throw AxisFault.makeFault(createex);
        }
        catch (SOAPException soapex) {
            throw AxisFault.makeFault(soapex);
        }
        return call;
    }
}

