/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.WithNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNoteOpale;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class InstructionWhile
extends WithNote
implements Instruction,
InstructionCollection {
    private final InstructionList repeatList = new InstructionList();
    private final Instruction parent;
    private final LinkRendering nextLinkRenderer;
    private final HColor color;
    private boolean killed = false;
    private final Display test;
    private Display yes;
    private boolean testCalled = false;
    private LinkRendering outColor = LinkRendering.none();
    private final Swimlane swimlane;
    private final ISkinParam skinParam;
    private Instruction specialOut;
    private BoxStyle boxStyle;
    private Swimlane swimlaneOut;
    private Display backward = Display.NULL;
    private LinkRendering incoming1 = LinkRendering.none();
    private LinkRendering incoming2 = LinkRendering.none();
    private boolean backwardCalled;

    public void overwriteYes(Display yes) {
        this.yes = yes;
    }

    public InstructionWhile(Swimlane swimlane, Instruction parent, Display test, LinkRendering nextLinkRenderer, Display yes, HColor color, ISkinParam skinParam) {
        this.parent = parent;
        this.test = Objects.requireNonNull(test);
        this.nextLinkRenderer = Objects.requireNonNull(nextLinkRenderer);
        this.yes = Objects.requireNonNull(yes);
        this.swimlane = swimlane;
        this.color = color;
        this.skinParam = skinParam;
    }

    @Override
    public void add(Instruction ins) {
        this.repeatList.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile back = Display.isNull(this.backward) ? null : factory.activity(this.backward, this.swimlane, this.boxStyle, Colors.empty(), null);
        Ftile tmp = this.repeatList.createFtile(factory);
        tmp = factory.createWhile(this.outColor, this.swimlane, tmp, this.test, this.yes, this.color, this.specialOut, back, this.incoming1, this.incoming2);
        if (this.getPositionedNotes().size() > 0) {
            tmp = FtileWithNoteOpale.create(tmp, this.getPositionedNotes(), this.skinParam, false);
        }
        if (this.killed || this.specialOut != null) {
            return new FtileKilled(tmp);
        }
        return tmp;
    }

    public Instruction getParent() {
        return this.parent;
    }

    @Override
    public final boolean kill() {
        if (this.testCalled) {
            this.killed = true;
            return true;
        }
        return this.repeatList.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.nextLinkRenderer;
    }

    public void outDisplay(Display out) {
        this.outColor = this.outColor.withDisplay(Objects.requireNonNull(out));
    }

    public void outColor(Rainbow rainbow) {
        this.outColor = this.outColor.withRainbow(rainbow);
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        if (this.repeatList.isEmpty()) {
            return super.addNote(note, position, type, colors, swimlaneNote);
        }
        return this.repeatList.addNote(note, position, type, colors, swimlaneNote);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeatList.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Instruction getLast() {
        return this.repeatList.getLast();
    }

    public void setSpecial(Instruction special) {
        this.specialOut = special;
    }

    @Override
    public boolean containsBreak() {
        return this.repeatList.containsBreak();
    }

    public void setBackward(Display label, Swimlane swimlaneOut, BoxStyle boxStyle, LinkRendering incoming1, LinkRendering incoming2) {
        this.backward = label;
        this.swimlaneOut = swimlaneOut;
        this.boxStyle = boxStyle;
        this.incoming1 = incoming1;
        this.incoming2 = incoming2;
        this.backwardCalled = true;
    }

    public void incoming(LinkRendering incoming) {
        if (!this.backwardCalled) {
            this.incoming1 = incoming;
            this.incoming2 = incoming;
        }
        this.testCalled = true;
    }
}

