/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.creole.Fission;
import net.sourceforge.plantuml.creole.Position;
import net.sourceforge.plantuml.creole.Sea;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class SheetBlock1
extends AbstractTextBlock
implements TextBlock,
Atom,
Stencil {
    private final Sheet sheet;
    private List<Stripe> stripes;
    private Map<Stripe, Double> heights;
    private Map<Stripe, Double> widths;
    private Map<Atom, Position> positions;
    private MinMax minMax;
    private final LineBreakStrategy maxWidth;
    private final double padding;

    @Override
    public List<Atom> splitInTwo(StringBounder stringBounder, double width) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public SheetBlock1(Sheet sheet, LineBreakStrategy maxWidth, double padding) {
        this.sheet = sheet;
        this.maxWidth = Objects.requireNonNull(maxWidth);
        this.padding = padding;
    }

    public String toString() {
        return this.sheet.toString();
    }

    public HorizontalAlignment getCellAlignment() {
        if (this.stripes.size() != 1) {
            return HorizontalAlignment.LEFT;
        }
        Stripe simple = this.stripes.get(0);
        if (simple instanceof StripeSimple) {
            return ((StripeSimple)simple).getCellAlignment();
        }
        return HorizontalAlignment.LEFT;
    }

    private void initMap(StringBounder stringBounder) {
        if (this.positions != null) {
            return;
        }
        this.stripes = new ArrayList<Stripe>();
        for (Stripe stripe : this.sheet) {
            this.stripes.addAll(new Fission(stripe, this.maxWidth).getSplitted(stringBounder));
        }
        this.positions = new LinkedHashMap<Atom, Position>();
        this.widths = new LinkedHashMap<Stripe, Double>();
        this.heights = new LinkedHashMap<Stripe, Double>();
        this.minMax = MinMax.getEmpty(true);
        double y = 0.0;
        for (Stripe stripe : this.stripes) {
            if (stripe.getAtoms().size() == 0) continue;
            Sea sea = new Sea(stringBounder);
            for (Atom atom : stripe.getAtoms()) {
                sea.add(atom);
            }
            sea.doAlign();
            sea.translateMinYto(y);
            sea.exportAllPositions(this.positions);
            double width = sea.getWidth();
            this.widths.put(stripe, width);
            this.minMax = sea.update(this.minMax);
            double height = sea.getHeight();
            this.heights.put(stripe, height);
            y += height;
        }
        int coef = this.sheet.getHorizontalAlignment() == HorizontalAlignment.CENTER ? 2 : (this.sheet.getHorizontalAlignment() == HorizontalAlignment.RIGHT ? 1 : 0);
        if (coef != 0) {
            double maxWidth = 0.0;
            for (Double d : this.widths.values()) {
                if (!(d > maxWidth)) continue;
                maxWidth = d;
            }
            for (Map.Entry entry : this.widths.entrySet()) {
                double diff = maxWidth - (Double)entry.getValue();
                if (!(diff > 0.0)) continue;
                for (Atom atom : ((Stripe)entry.getKey()).getAtoms()) {
                    Position pos = this.positions.get(atom);
                    this.positions.put(atom, pos.translateX(diff / (double)coef));
                }
            }
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        this.initMap(stringBounder);
        return Dimension2DDouble.delta(this.minMax.getDimension(), 2.0 * this.padding);
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return null;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.initMap(ug.getStringBounder());
        if (this.padding > 0.0) {
            ug = ug.apply(new UTranslate(this.padding, this.padding));
        }
        for (Stripe stripe : this.stripes) {
            for (Atom atom : stripe.getAtoms()) {
                Position position = this.positions.get(atom);
                atom.drawU(position.translate(ug));
            }
        }
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

