macro(CONFIGURE_DOXYGEN_FILE DOXYGEN_CONFIG_FILE FILE_NAME_SUFFIX)
  if(EXISTS ${PROJECT_BINARY_DIR}/${DOXYGEN_CONFIG_FILE})
    file(REMOVE ${PROJECT_BINARY_DIR}/doxy-${FILE_NAME_SUFFIX}.conf)
    file(READ ${PROJECT_BINARY_DIR}/${DOXYGEN_CONFIG_FILE} DOXYFILE_CONTENTS)
    string(REGEX REPLACE ";" "\\\\;" DOXYFILE_CONTENTS "${DOXYFILE_CONTENTS}")
    string(REGEX REPLACE "\n" ";" DOXYFILE_LINES "${DOXYFILE_CONTENTS}")
    list(LENGTH DOXYFILE_LINES ROW)
    math(EXPR ROW "${ROW} - 1")
    foreach(I RANGE ${ROW})
      list(GET DOXYFILE_LINES ${I} LINE)
      if(LINE STRGREATER "")
        string(REGEX MATCH "^[a-zA-Z]([^ ])+" DOXY_PARAM ${LINE})
        if(DEFINED DOXY_${DOXY_PARAM})
          set(LINE "${DOXY_PARAM} = ${DOXY_${DOXY_PARAM}}")
        endif(DEFINED DOXY_${DOXY_PARAM})
      endif()
      file(APPEND ${PROJECT_BINARY_DIR}/doxy-${FILE_NAME_SUFFIX}.conf "${LINE}\n")
    endforeach()
  else()
    message(SEND_ERROR "Doxygen configuration file '${DOXYGEN_CONFIG_FILE}' not found. Documentation will not be generated")
  endif()
endmacro(CONFIGURE_DOXYGEN_FILE)

macro(ADD_DOCUMENTATION TARGET DOXYGEN_CONFIG_FILE)
  find_package(Doxygen)
  if(DOXYGEN_FOUND)
    # Try to find qhelpgenerator, if successful, use it to create the qch documentation
    find_program(QHELPGENERATOR_EXECUTABLE
                 qhelpgenerator
                 HINTS
                 ${QT_BINARY_DIR})
    if(QHELPGENERATOR_EXECUTABLE)
      set(QCH_FILE "${PROJECT_BINARY_DIR}/${PROJECT_NAME}.qch")
    endif()
    configure_file(${PROJECT_SOURCE_DIR}/Doxyfile.in
                   ${PROJECT_BINARY_DIR}/Doxyfile @ONLY)
    CONFIGURE_DOXYGEN_FILE(${DOXYGEN_CONFIG_FILE} ${TARGET})
    add_custom_target(${TARGET} COMMAND ${DOXYGEN_EXECUTABLE} ${PROJECT_BINARY_DIR}/doxy-${TARGET}.conf)
  else(DOXYGEN_FOUND)
    message(STATUS "Doxygen not found. Documentation will not be generated")
  endif(DOXYGEN_FOUND)
endmacro(ADD_DOCUMENTATION)
