#
# u2df02.rb
#
# $Id$
#

require "numru/dcl"

include NumRu
include Math


nx = 19
ny = 19
xmin = 0
xmax = 360
dx1 = 10
dx2 = 60
ymin = -90
ymax = 90
my = 7
nc = 3
drad = PI/180
dz = 0.05
p = NArray.sfloat(nx, ny)
uy1 = NArray.sfloat(ny)
uy2 = NArray.sfloat(my)

#-- data ---
ch = ['SP ', '60S', '30S', 'EQ ', '30N', '60N', 'NP ']

for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

uy1.indgen(ymin, (ymax-ymin)/(ny-1))
uy1 = NMath.sin(uy1*drad)
uy2.indgen(ymin, (ymax-ymin)/(my-1))
uy2 = NMath.sin(uy2*drad)

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(xmin, xmax, uy1[0], uy1[ny-1])
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::uxaxdv('B', dx1, dx2)
DCL::uxaxdv('T', dx1, dx2)
DCL::uxsttl('B', 'LONGITUDE', 0.0)

DCL::uyaxlb('L', uy1, uy2, ch, nc)
DCL::uyaxlb('R', uy1, uy2, ch, nc)
DCL::uysttl('L', 'LATITUDE', 0.0)

DCL::uwsgxb(xmin, xmax, nx)
DCL::uwsgya(uy1)

DCL::udsfmt('(F6.1)')
DCL::udgclb(p, 0.2)
DCL::udsclv(0.1, 1, 4, ' ', 0.01)

DCL::udcntr(p)

DCL::grcls

