"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mirSeqIsWellFormed = exports.TestRawDcOptimize = void 0;
const draw_call_1 = require("./draw-call");
const general_1 = require("./draw-call-optimize/general");
const mir_1 = require("./mir");
function TestRawDcOptimize(ctx, passes, original, optimized) {
    const dc = draw_call_1.CffDrawCall.charStringSeqFromRawSeq(ctx, original);
    const dcOpt = Array.from((0, general_1.cffOptimizeDrawCall)(dc, passes));
    const msActual = draw_call_1.CffDrawCall.charStringSeqToMir(ctx, dcOpt);
    mirSeqIsWellFormed(ctx, msActual);
    expect(mir_1.Mir.rectifyMirStr(mir_1.Mir.printCharString(msActual))).toBe(mir_1.Mir.rectifyMirStr(optimized));
}
exports.TestRawDcOptimize = TestRawDcOptimize;
function mirSeqIsWellFormed(ctx, mirSeq) {
    let sp = 0;
    const maxStack = ctx.getLimits().maxStack;
    for (const mir of mirSeq) {
        expect(true).toBe(sp + mir.stackRidge < maxStack);
        expect(true).toBe(sp + mir.stackRise < maxStack);
        sp += mir.stackRise;
    }
    expect(sp).toBe(0);
}
exports.mirSeqIsWellFormed = mirSeqIsWellFormed;
//# sourceMappingURL=test-util.js.map