"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffStringSink = void 0;
const errors_1 = require("@ot-builder/errors");
const data_1 = require("./data");
class CffStringSink {
    constructor() {
        this.mapping = new Map();
        this.n = data_1.CffStandardStrings.length;
        for (let sid = 0; sid < data_1.CffStandardStrings.length; sid++) {
            this.mapping.set(data_1.CffStandardStrings[sid], sid);
        }
    }
    push(s) {
        const existing = this.mapping.get(s);
        if (existing !== undefined)
            return existing;
        const sid = this.n++;
        this.mapping.set(s, sid);
        return sid;
    }
    getStringIndexList() {
        const strList = [];
        for (const [s, ix] of this.mapping) {
            if (ix >= data_1.CffStandardStrings.length)
                strList[ix - data_1.CffStandardStrings.length] = s;
        }
        errors_1.Assert.NoGap("string ist", strList);
        return strList;
    }
}
exports.CffStringSink = CffStringSink;
//# sourceMappingURL=sink.js.map