"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readSfntView = exports.readSfntOtf = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_sfnt_1 = require("@ot-builder/ot-sfnt");
const primitive_1 = require("@ot-builder/primitive");
function readSfntOtf(buf) {
    return readSfntView(new bin_util_1.BinaryView(buf));
}
exports.readSfntOtf = readSfntOtf;
function readSfntView(view) {
    // Table header
    const version = view.uint32();
    const numTables = view.uint16();
    const _searchRange = view.uint16();
    const _entrySelector = view.uint16();
    const _rangeShift = view.uint16();
    const sfnt = new ot_sfnt_1.Sfnt(version);
    for (let mu = 0; mu < numTables; mu++) {
        const tag = view.next(primitive_1.Tag);
        const _checkSum = view.uint32();
        const pTable = view.ptr32();
        const length = view.uint32();
        sfnt.tables.set(tag, pTable.bytes(length));
    }
    return sfnt;
}
exports.readSfntView = readSfntView;
//# sourceMappingURL=read.js.map