"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolyFillType = exports.ClipType = exports.removeOverlap = exports.combine = void 0;
const ClipperLib = require("clipper-lib");
const intersections_1 = require("./intersections");
const rebuild_1 = require("./rebuild");
const slice_arc_1 = require("../shared/slice-arc");
const to_poly_1 = require("./to-poly");
function combineImpl(op, s1, s2, rule1, rule2, resolution = 256) {
    if (!s1.length) {
        switch (op) {
            case ClipperLib.ClipType.ctIntersection:
            case ClipperLib.ClipType.ctDifference:
                return [];
            default:
                return s2;
        }
    }
    if (!s2.length) {
        switch (op) {
            case ClipperLib.ClipType.ctIntersection:
                return [];
            default:
                return s1;
        }
    }
    const i1 = (0, intersections_1.findSelfIntersections)(s1);
    const i2 = (0, intersections_1.findSelfIntersections)(s2);
    (0, intersections_1.findCrossIntersections)(s1, s1, i1, i1, true);
    (0, intersections_1.findCrossIntersections)(s2, s2, i2, i2, true);
    (0, intersections_1.findCrossIntersections)(s1, s2, i1, i2, false);
    const segHash = new Map();
    const termHash = new Set();
    const p1 = (0, to_poly_1.toPoly)(s1, 1, i1, segHash, termHash, resolution);
    const p2 = (0, to_poly_1.toPoly)(s2, 2, i2, segHash, termHash, resolution);
    const cpr = new ClipperLib.Clipper(ClipperLib.Clipper.ioReverseSolution | ClipperLib.Clipper.ioStrictlySimple);
    cpr.AddPaths(p1, ClipperLib.PolyType.ptSubject, ClipperLib.EndType.etClosedPolygon);
    cpr.AddPaths(p2, ClipperLib.PolyType.ptClip, ClipperLib.EndType.etClosedPolygon);
    const solutionPaths = ClipperLib.Paths();
    cpr.Execute(op || 0, solutionPaths, rule1 || 0, rule2 || 0);
    return (0, rebuild_1.rebuildShape)(solutionPaths, segHash, termHash, resolution);
}
function removeOverlapImpl(s1, rule, resolution = 256) {
    if (!s1.length)
        return s1;
    const i1 = (0, intersections_1.findSelfIntersections)(s1);
    (0, intersections_1.findCrossIntersections)(s1, s1, i1, i1, true);
    const segHash = new Map();
    const termHash = new Set();
    const p1 = (0, to_poly_1.toPoly)(s1, 1, i1, segHash, termHash, resolution);
    const solution_paths = ClipperLib.Clipper.SimplifyPolygons(p1, rule);
    for (const path of solution_paths)
        path.reverse();
    return (0, rebuild_1.rebuildShape)(solution_paths, segHash, termHash, resolution);
}
function ToBez3Slices(shape) {
    let result = [];
    for (let contour of shape) {
        const resultContour = [];
        for (let j = 0; j < contour.length; j++) {
            resultContour.push(new slice_arc_1.Bez3Slice(contour[j].a, contour[j].b, contour[j].c, contour[j].d));
        }
        result.push(resultContour);
    }
    return result;
}
function combine(op, _s1, _s2, rule1, rule2, RESOLUTION = 256) {
    return combineImpl(op, ToBez3Slices(_s1), ToBez3Slices(_s2), rule1, rule2, RESOLUTION);
}
exports.combine = combine;
function removeOverlap(s1, rule, RESOLUTION = 256) {
    return removeOverlapImpl(ToBez3Slices(s1), rule, RESOLUTION);
}
exports.removeOverlap = removeOverlap;
var clipper_lib_1 = require("clipper-lib");
Object.defineProperty(exports, "ClipType", { enumerable: true, get: function () { return clipper_lib_1.ClipType; } });
Object.defineProperty(exports, "PolyFillType", { enumerable: true, get: function () { return clipper_lib_1.PolyFillType; } });
