"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.equal = equal;
exports.unequal = unequal;
exports.zero = zero;
exports.nonzero = nonzero;
exports.between = between;
function equal(a, b, tolerance) {
    return Math.abs(a - b) <= tolerance;
}
function unequal(a, b, tolerance) {
    return Math.abs(a - b) > tolerance;
}
function zero(a, tolerance) {
    return Math.abs(a) <= tolerance;
}
function nonzero(a, tolerance) {
    return Math.abs(a) > tolerance;
}
function between(d1, dj, d2, tolerance) {
    return Math.min(d1, d2) - tolerance <= dj && dj <= Math.max(d1, d2) + tolerance;
}
//# sourceMappingURL=approx.js.map