"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncodingMapT = void 0;
class EncodingMapT {
    constructor(init) {
        this.mapping = new Map();
        if (init) {
            for (const [code, glyph] of init) {
                this.set(code, glyph);
            }
        }
    }
    get size() {
        return this.mapping.size;
    }
    get(code) {
        return this.mapping.get(code | 0);
    }
    set(code, glyph) {
        this.mapping.set(code | 0, glyph);
    }
    delete(code) {
        this.mapping.delete(code | 0);
    }
    clear() {
        this.mapping = new Map();
    }
    *entries() {
        yield* this.mapping.entries();
    }
}
exports.EncodingMapT = EncodingMapT;
//# sourceMappingURL=encoding-map-impl.js.map