// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package options

import (
	"context"

	"code.forgejo.org/f3/gof3/v3/forges/helpers/auth"
	"code.forgejo.org/f3/gof3/v3/options"
	options_http "code.forgejo.org/f3/gof3/v3/options/http"
	"code.forgejo.org/f3/gof3/v3/options/logger"

	"github.com/urfave/cli/v3"
)

type Options struct {
	options.Options
	logger.OptionsLogger
	auth.ForgeAuth
	options_http.Implementation

	Version string
}

func (o *Options) FromFlags(ctx context.Context, c *cli.Command, prefix string) {
	o.ForgeAuth.FromFlags(ctx, c, prefix)
}

func (o *Options) GetFlags(prefix, category string) []cli.Flag {
	return o.ForgeAuth.GetFlags(prefix, category)
}
