// Copyright The Notary Project Authors.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ber

import (
	"errors"
	"testing"
)

type errorWriter struct{}

func (ew *errorWriter) Write(p []byte) (n int, err error) {
	return 0, errors.New("write error")
}

func (ew *errorWriter) WriteByte(c byte) error {
	return errors.New("write error")
}

func TestConstructedEncodeMetadata(t *testing.T) {
	tests := []struct {
		name      string
		v         constructed
		wantError bool
	}{
		{
			name: "Error case",
			v: constructed{
				identifier: []byte{0x30},
				length:     5,
			},
			wantError: true,
		},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			w := &errorWriter{}
			err := tt.v.EncodeMetadata(w)
			if (err != nil) != tt.wantError {
				t.Errorf("EncodeMetadata() error = %v, wantError %v", err, tt.wantError)
			}
		})
	}
}
