#!/bin/bash
# a utility script to update libknot*.symbols.* symlinks after SONAME bump
#
# run it from debian/ dir:
#
#     cd debian
#     ./scripts/update-libknot-symlinks.sh

set -e

LINK_TARGET=$(find . -maxdepth 1 -type f -name 'libknot*.symbols.*')
echo "updating libknot* symlinks against target: $LINK_TARGET"

for LINK_NAME in $(find . -maxdepth 1 -type l -name 'libknot*.symbols*'); do
  echo "ln -sf $LINK_TARGET $LINK_NAME"
  ln -sf "$LINK_TARGET" "$LINK_NAME"
done
