#!/bin/sh
set -o errexit

CONTRIBUTORS_LIST=$(
	grep 'SPDX-FileCopyrightText' games/* |
		cut --delimiter=' ' --fields=5- |
		sort --unique
)

CONTRIBUTOR_MISSING=0
while read contributor; do
	grep --quiet "$contributor" LICENSE ||
		{
			printf 'Missing contributor in LICENSE: %s\n' "$contributor" &&
			CONTRIBUTOR_MISSING=1
		}
done << EOL
$(printf '%s\n' "$CONTRIBUTORS_LIST")
EOL

test $CONTRIBUTOR_MISSING -eq 0
