
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:





Copyright (c) 2001 World Wide Web Consortium, 

(Massachusetts Institute of Technology, Institut National de

Recherche en Informatique et en Automatique, Keio University).  All 

Rights Reserved.  This program is distributed under the W3C's Software

Intellectual Property License.  This program is distributed in the 

hope that it will be useful, but WITHOUT ANY WARRANTY; without even

the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 

PURPOSE.  



See W3C License http://www.w3.org/Consortium/Legal/ for more details.




*/

package org.w3c.domts.level2.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method createAttributeNS raises a NAMESPACE_ERR if the specified qualified name 
 *  is malformed.
 *  
 *  Invoke the createAttributeNS method on this Document object with a valid value for 
 *  namespaceURI, and malformed qualifiedNames.  Check if the a NAMESPACE_ERR was thrown.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS</a>
*/
public final class documentcreateattributeNS04 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentcreateattributeNS04(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "staffNS", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Attr attribute;
      String namespaceURI = "http://www.w3.org/DOM/Test/Level2";
      String qualifiedName;
      java.util.List qualifiedNames = new java.util.ArrayList();
      qualifiedNames.add("_:");
      qualifiedNames.add(":0a");
      qualifiedNames.add(":");
      qualifiedNames.add("a:b:c");
      qualifiedNames.add("_::a");
      
      doc = (Document) load("staffNS", false);
      for (int indexN1004E = 0; indexN1004E < qualifiedNames.size(); indexN1004E++) {
          qualifiedName = (String) qualifiedNames.get(indexN1004E);
    
      {
          // BEGIN android-changed
          //     Our exception priorities differ from the spec
         try {
            attribute = doc.createAttributeNS(namespaceURI, qualifiedName);
             fail("documentcreateattributeNS04");
          } catch (DOMException expected) {
         }
          // END android-changed
      }
  }
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentcreateattributeNS04";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentcreateattributeNS04.class, args);
   }
}

