/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.view.selectiontoolbar;

import android.annotation.NonNull;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.SurfaceControlViewHost;

import com.android.internal.util.DataClass;

/**
 * The class holds the rendered content and the related information from the render service to
 * be used to show on the selection toolbar.
 *
 * @hide
 */
@DataClass(genToString = true, genEqualsHashCode = true)
public final class WidgetInfo implements Parcelable {

    /**
     * The token that is used to identify the selection toolbar.
     */
    private final long mWidgetToken;

    /**
     * A Rect that defines the size and positioning of the remote view with respect to
     * its host window.
     */
    @NonNull
    private final Rect mContentRect;

    /**
     * The SurfacePackage pointing to the remote view.
     */
    @NonNull
    private final SurfaceControlViewHost.SurfacePackage mSurfacePackage;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/view/selectiontoolbar/WidgetInfo.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new WidgetInfo.
     *
     * @param widgetToken
     *   The token that is used to identify the selection toolbar.
     * @param contentRect
     *   A Rect that defines the size and positioning of the remote view with respect to
     *   its host window.
     * @param surfacePackage
     *   The SurfacePackage pointing to the remote view.
     */
    @DataClass.Generated.Member
    public WidgetInfo(
            long widgetToken,
            @NonNull Rect contentRect,
            @NonNull SurfaceControlViewHost.SurfacePackage surfacePackage) {
        this.mWidgetToken = widgetToken;
        this.mContentRect = contentRect;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mContentRect);
        this.mSurfacePackage = surfacePackage;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mSurfacePackage);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The token that is used to identify the selection toolbar.
     */
    @DataClass.Generated.Member
    public long getWidgetToken() {
        return mWidgetToken;
    }

    /**
     * A Rect that defines the size and positioning of the remote view with respect to
     * its host window.
     */
    @DataClass.Generated.Member
    public @NonNull Rect getContentRect() {
        return mContentRect;
    }

    /**
     * The SurfacePackage pointing to the remote view.
     */
    @DataClass.Generated.Member
    public @NonNull SurfaceControlViewHost.SurfacePackage getSurfacePackage() {
        return mSurfacePackage;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "WidgetInfo { " +
                "widgetToken = " + mWidgetToken + ", " +
                "contentRect = " + mContentRect + ", " +
                "surfacePackage = " + mSurfacePackage +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(WidgetInfo other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        WidgetInfo that = (WidgetInfo) o;
        //noinspection PointlessBooleanExpression
        return true
                && mWidgetToken == that.mWidgetToken
                && java.util.Objects.equals(mContentRect, that.mContentRect)
                && java.util.Objects.equals(mSurfacePackage, that.mSurfacePackage);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + Long.hashCode(mWidgetToken);
        _hash = 31 * _hash + java.util.Objects.hashCode(mContentRect);
        _hash = 31 * _hash + java.util.Objects.hashCode(mSurfacePackage);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeLong(mWidgetToken);
        dest.writeTypedObject(mContentRect, flags);
        dest.writeTypedObject(mSurfacePackage, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ WidgetInfo(@NonNull Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        long widgetToken = in.readLong();
        Rect contentRect = (Rect) in.readTypedObject(Rect.CREATOR);
        SurfaceControlViewHost.SurfacePackage surfacePackage = (SurfaceControlViewHost.SurfacePackage) in.readTypedObject(SurfaceControlViewHost.SurfacePackage.CREATOR);

        this.mWidgetToken = widgetToken;
        this.mContentRect = contentRect;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mContentRect);
        this.mSurfacePackage = surfacePackage;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mSurfacePackage);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<WidgetInfo> CREATOR
            = new Parcelable.Creator<WidgetInfo>() {
        @Override
        public WidgetInfo[] newArray(int size) {
            return new WidgetInfo[size];
        }

        @Override
        public WidgetInfo createFromParcel(@NonNull Parcel in) {
            return new WidgetInfo(in);
        }
    };

    @DataClass.Generated(
            time = 1643281495056L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/view/selectiontoolbar/WidgetInfo.java",
            inputSignatures = "private final  long mWidgetToken\nprivate final @android.annotation.NonNull android.graphics.Rect mContentRect\nprivate final @android.annotation.NonNull android.view.SurfaceControlViewHost.SurfacePackage mSurfacePackage\nclass WidgetInfo extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genToString=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
