#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import line_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("Presents the indentation level for the current line")

    def run(self):
        # Prefer review cursor over text cursor

        if self.env["screen"]["newCursorReview"]:
            cursor_pos = self.env["screen"]["newCursorReview"].copy()
        else:
            cursor_pos = self.env["screen"]["new_cursor"].copy()
        x, y, curr_line = line_utils.get_current_line(
            cursor_pos["x"],
            cursor_pos["y"],
            self.env["screen"]["new_content_text"],
        )

        if curr_line.isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), sound_icon="EmptyLine", interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                _("indent {0}").format(
                    len(curr_line) - len(curr_line.lstrip())
                ),
                interrupt=True,
            )

    def set_callback(self, callback):
        pass
