#!/usr/bin/env python3

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

# Load base configuration class
_base_path = os.path.join(os.path.dirname(__file__), "..", "config_base.py")
_spec = importlib.util.spec_from_file_location("config_base", _base_path)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
config_command = _module.config_command


class command(config_command):
    def __init__(self):
        super().__init__()

    def get_description(self):
        return "Reload configuration from file"

    def run(self):
        self.present_text("Reloading configuration from file...")

        success = self.reload_config()

        if success:
            self.present_text("Configuration reloaded successfully")
            self.play_sound("Accept")
        else:
            self.present_text("Failed to reload configuration")
            self.play_sound("Error")
