#!/usr/bin/env python3

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "Save current session settings to configuration file"

    def run(self):
        self.env["runtime"]["OutputManager"].present_text(
            "Saving current session settings to configuration file...",
            interrupt=True,
        )

        try:
            # This calls the settings manager's save method which writes
            # current runtime settings to file
            self.env["runtime"]["SettingsManager"].save_settings()

            self.env["runtime"]["OutputManager"].present_text(
                "Session settings saved successfully!",
                interrupt=False,
                flush=False,
            )
            self.env["runtime"]["OutputManager"].present_text(
                "All temporary changes are now permanent.",
                interrupt=False,
                flush=False,
            )

        except Exception as e:
            self.env["runtime"]["OutputManager"].present_text(
                f"Failed to save settings: {str(e)}",
                interrupt=False,
                flush=False,
            )

    def set_callback(self, callback):
        pass
