"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffDictWriteT = exports.CffDictDataCollector = exports.CffDictReadT = exports.CffDictInterpreterBase = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const draw_call_1 = require("../char-string/write/draw-call");
const mir_1 = require("../char-string/write/mir");
const CffInterp = require("../interp/ir");
const ir_source_1 = require("../interp/ir-source");
const stack_machine_1 = require("../interp/stack-machine");
const encoder_1 = require("./encoder");
class CffDictInterpreterBase extends CffInterp.Interpreter {
    constructor(ivs) {
        super();
        this.st = new stack_machine_1.CffStackMachine(ivs);
    }
    doOperand(x) {
        this.st.push(x);
    }
}
exports.CffDictInterpreterBase = CffDictInterpreterBase;
function CffDictReadT(interpFactory) {
    return (0, bin_util_1.Read)(function (view, ctx, dictSize) {
        const interp = interpFactory(view, ctx);
        const irSource = new ir_source_1.CffDictIrSource(view, dictSize);
        for (;;) {
            const ir = irSource.next();
            if (!ir)
                break;
            else
                interp.next(ir);
        }
        return interp.getResult();
    });
}
exports.CffDictReadT = CffDictReadT;
class CffDictDataCollector {
}
exports.CffDictDataCollector = CffDictDataCollector;
function CffDictWriteT(collector) {
    return (0, bin_util_1.Write)((frag, dict, ctx, rest) => {
        const drawCalls = draw_call_1.CffDrawCall.dictStringSeqFromRawSeq(ctx, [
            ...collector.collectDrawCalls(dict, ctx, rest)
        ]);
        const dcIrSeq = mir_1.Mir.toInterpIrSeq(draw_call_1.CffDrawCall.dictSeqToMir(ctx, drawCalls));
        const encoder = new encoder_1.DictEncoder(frag);
        for (const ir of dcIrSeq)
            encoder.push(ir);
        collector.processPointers(encoder, dict, ctx, rest);
    });
}
exports.CffDictWriteT = CffDictWriteT;
//# sourceMappingURL=general.js.map