import { F16D16, Int16, UInt16, UInt32 } from "@ot-builder/primitive";
export declare const Tag = "head";
export declare enum Flags {
    BaseLineYAt0 = 1,
    LeftSidebearingAtX0 = 2,
    InstructionsMayDependOnPointSize = 4,
    ForcePpemToBeInteger = 8,
    InstructionMayAlterAdvanceWidth = 16,
    IntendedToBeVertical = 32,
    Reserved6 = 64,
    NeedComplexLayout = 128,
    HasAATMetamorphism = 256,
    HasStrongRightToLeft = 512,
    HasIndicRearrangement = 1024,
    Compressed = 2048,
    Converted = 4096,
    OptimizedForClearType = 8192,
    LastResortFont = 16384,
    Reserved15 = 32768
}
export declare enum MacStyle {
    Bold = 1,
    Italic = 2,
    Underline = 4,
    Outline = 8,
    Shadow = 16,
    Condensed = 32,
    Extended = 64
}
export declare enum FontDirectionHint {
    FullyMixed = 0,
    OnlyStrongLTR = 1,
    StrongLTROrNeutral = 2,
    OnlyStrongRTL = -1,
    StrongRTLOrNeutral = -2
}
export declare class Table {
    readonly majorVersion: UInt16;
    readonly minorVersion: UInt16;
    constructor(majorVersion?: UInt16, minorVersion?: UInt16);
    fontRevision: F16D16;
    readonly checkSumAdjust: UInt32;
    readonly magicNumber: UInt32;
    flags: Flags;
    unitsPerEm: UInt16;
    created: Date;
    modified: Date;
    xMin: Int16;
    yMin: Int16;
    xMax: Int16;
    yMax: Int16;
    macStyle: MacStyle;
    lowestRecPPEM: UInt16;
    fontDirectionHint: FontDirectionHint;
    indexToLocFormat: Int16;
    glyphDataFormat: Int16;
}
//# sourceMappingURL=head.d.ts.map