"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Vhea = exports.Hhea = exports.Table = exports.TagVhea = exports.TagHhea = void 0;
exports.TagHhea = "hhea";
exports.TagVhea = "vhea";
class Table {
    constructor() {
        this.ascender = 0;
        this.descender = 0;
        this.lineGap = 0;
        this.advanceMax = 0;
        this.minStartSideBearing = 0;
        this.minEndSideBearing = 0;
        this.maxExtent = 0;
        this.caretSlopeRise = 0;
        this.caretSlopeRun = 0;
        this.caretOffset = 0;
        this._reserved0 = 0;
        this._reserved1 = 0;
        this._reserved2 = 0;
        this._reserved3 = 0;
        this.metricDataFormat = 0;
        this.numberOfLongMetrics = 0;
    }
}
exports.Table = Table;
class Hhea extends Table {
    constructor(majorVersion = 1, minorVersion = 0) {
        super();
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.isVertical = false;
    }
}
exports.Hhea = Hhea;
class Vhea extends Table {
    constructor(majorVersion = 1, minorVersion = 0) {
        super();
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.isVertical = true;
    }
}
exports.Vhea = Vhea;
//# sourceMappingURL=metric-head.js.map