"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Param = exports.Arg = exports.Option = exports.Cmd = exports.Rule = exports.Bullet = exports.CONSOLE_WIDTH = void 0;
exports.OptRun = OptRun;
exports.AltRun = AltRun;
exports.ArgvParseError = ArgvParseError;
const pc = require("picocolors");
const terminalSupportsUnicode = process.platform !== "win32" ||
    process.env.TERM_PROGRAM === "vscode" ||
    !!process.env.WT_SESSION; // Workaround https://github.com/microsoft/terminal/issues/1040
exports.CONSOLE_WIDTH = 80;
exports.Bullet = terminalSupportsUnicode ? `· ` : `+ `;
exports.Rule = (terminalSupportsUnicode ? `─` : `-`).repeat(exports.CONSOLE_WIDTH);
const Cmd = (s, ...placeholders) => pc.cyan(simpleTemplateCombine(s, placeholders));
exports.Cmd = Cmd;
const Option = (s, ...placeholders) => pc.green(simpleTemplateCombine(s, placeholders));
exports.Option = Option;
const Arg = (s, ...placeholders) => pc.yellow(simpleTemplateCombine(s, placeholders));
exports.Arg = Arg;
const Param = (s, ...placeholders) => `<` + pc.yellow(simpleTemplateCombine(s, placeholders)) + `>`;
exports.Param = Param;
function OptRun(...xs) {
    return ["[", ...xs, "]"];
}
function AltRun(...xs) {
    const a = [];
    for (let index = 0; index < xs.length; index++) {
        if (index)
            a.push("|");
        a.push(xs[index]);
    }
    return a;
}
function ArgvParseError(s) {
    return pc.bold(pc.red(pc.underline(s)));
}
function simpleTemplateCombine(s, placeholders) {
    let res = s[0];
    for (let i = 0; i < placeholders.length; i++) {
        res += String(placeholders[i]) + (s[i + 1] || "");
    }
    return res;
}
//# sourceMappingURL=style.js.map