// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package util

import (
	"fmt"
	"time"
)

func retry(fun func()) (status interface{}) {
	defer func() {
		status = recover()
	}()

	fun()

	return status
}

func Retry(fun func(), tries int) {
	errors := make([]interface{}, 0, tries)
	for i := 0; i < tries; i++ {
		err := retry(fun)
		if err == nil {
			return
		}
		errors = append(errors, err)
		<-time.After(1 * time.Second)
	}
	panic(fmt.Errorf("Retry: failed %v", errors))
}
